/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.bearer.OfflineBearerUser;
import com.nuix.automate.scheduler.security.bearer.OfflineUser;
import com.nuix.automate.scheduler.security.bearer.SystemBearerUser;
import com.nuix.automate.scheduler.workers.ApiKeyWorker;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.general.SortingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenceValidationException;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.apikey.ApiKey;
import com.nuix.automate.utils.models.api.apikey.ApiKeySubmission;
import com.nuix.automate.utils.models.api.apikey.ApiKeyWithSecret;
import com.nuix.automate.utils.models.api.apikey.EphemeralApiKeyWithSecret;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.SecurityUtils;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Path(value="/v1/scheduler/security/apiKey")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ApiKeyResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ApiKeyResource.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;
    private final Map<String, ApiKeyWithSecret> apiKeys;
    private final Map<String, EphemeralApiKeyWithSecret> ephemeralApiKeys;
    private ApiKeyWorker apiKeyWorker;

    public ApiKeyResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.apiKeys = new ConcurrentHashMap<String, ApiKeyWithSecret>();
        this.ephemeralApiKeys = new ConcurrentHashMap<String, EphemeralApiKeyWithSecret>();
        this.apiKeyWorker = new ApiKeyWorker(schedulerApplication);
    }

    public void initializeFromStore() {
        LOGGER.info("Initializing API Keys from store");
        List<ApiKeyWithSecret> apiKeys = this.schedulerApplication.getSchedulerConfigurationDao().getApiKeys();
        for (ApiKeyWithSecret ApiKey2 : apiKeys) {
            this.apiKeys.put(ApiKey2.getId(), ApiKey2);
        }
    }

    public void trackLogin(String id) {
        ApiKeyWithSecret key = this.apiKeys.get(id);
        long currentDay = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() / 24L / 3600L / 1000L;
        if (key.getLastUsedDay() != currentDay) {
            key.setLastUsedDay(currentDay);
            this.schedulerApplication.getSchedulerConfigurationDao().updateApiKey(key);
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), key.getId(), Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), key.getUser().getIdentifierName(), EventType.Type.API_KEY_UPDATE_LAST_USED_DAY, "", "N/A"));
            ResponseCache.getInstance().resetKeyId(CacheKey.API_KEYS, "");
            ApiKey eventResult = new ApiKey(this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions((BearerUser)new SystemBearerUser(), key));
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.API_KEY_UPDATE_LAST_USED_DAY, eventResult);
        }
    }

    public ApiKeyWithSecret getApiKey(String id) {
        return this.apiKeys.get(id);
    }

    public EphemeralApiKeyWithSecret getEphemeralApiKey(String id) {
        return this.ephemeralApiKeys.get(id);
    }

    public Collection<ApiKeyWithSecret> getApiKeys() {
        return this.apiKeys.values();
    }

    public Map<String, EphemeralApiKeyWithSecret> getEphemeralApiKeys() {
        return this.ephemeralApiKeys;
    }

    public boolean isApiKeyExpired(ApiKeyWithSecret apiKey) {
        long elapsedDays = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() / 24L / 3600L / 1000L - apiKey.getCreatedDay();
        return elapsedDays >= (long)apiKey.getValidityDays();
    }

    public void refreshApiKeyStatus(ApiKeyWithSecret apiKey) {
        apiKey.setStatus(new Status());
        long elapsedDays = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() / 24L / 3600L / 1000L - apiKey.getCreatedDay();
        if (elapsedDays >= (long)apiKey.getValidityDays()) {
            apiKey.getStatus().setError(this.iu.getString("ApiKey.Error.Expired"));
            return;
        }
        if (apiKey.getSecret() == null || apiKey.getSecret().length() == 0) {
            apiKey.getStatus().setError(this.iu.getString("ApiKey.Error.InvalidSecret"));
            return;
        }
        try {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.API_ADVANCED);
        }
        catch (LicenceValidationException e) {
            apiKey.getStatus().setError(this.iu.getString(e.getLocalizedMessage()));
            return;
        }
        apiKey.getStatus().resetOkMessage("");
    }

    public BearerUser authenticateWithApiKey(String keyId, String keySecret) {
        ApiKeyWithSecret key = this.getApiKey(keyId);
        if (key != null && keySecret.equals(key.getSecret())) {
            this.refreshApiKeyStatus(key);
            if (key.getStatus().getCode().equals((Object)State.OK)) {
                this.trackLogin(keyId);
                OfflineUser offlineUser = this.schedulerApplication.getSecurityDao().getOfflineUser(key.getUserId());
                if (offlineUser == null) {
                    offlineUser = new OfflineUser();
                    offlineUser.setId(key.getUserId());
                    offlineUser.setMainIdentifier(key.getUser());
                    HashSet<Identifier> identifiers = new HashSet<Identifier>();
                    identifiers.add(key.getUser());
                    offlineUser.setIdentifiers(identifiers);
                }
                return new OfflineBearerUser(offlineUser);
            }
        }
        return null;
    }

    public BearerUser authenticateWithEphemeralApiKey(String keyId, String keySecret) {
        EphemeralApiKeyWithSecret key = this.getEphemeralApiKey(keyId);
        if (key != null && keySecret.equals(key.getSecret()) && key.isValid()) {
            OfflineUser offlineUser = this.schedulerApplication.getSecurityDao().getOfflineUser(key.getUserId());
            return new OfflineBearerUser(offlineUser);
        }
        return null;
    }

    @Operation(tags={"Security"}, operationId="GetApiKeys", summary="Get API Keys", description="Get full information of all API Keys", responses={@ApiResponse(description="The list of API Keys", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApiKey.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getApiKeys(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.API_KEYS, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ArrayList<ApiKey> allowedApiKeys = new ArrayList<ApiKey>();
            for (ApiKeyWithSecret ApiKey2 : this.getApiKeys()) {
                ApiKeyWithSecret result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, ApiKey2);
                this.refreshApiKeyStatus(result);
                if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                allowedApiKeys.add(new ApiKey(result));
            }
            SortingUtils.sortList(allowedApiKeys, ApiKey::getName);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedApiKeys).build();
        }
    }

    @Operation(tags={"Security"}, operationId="AddApiKey", summary="Add API Key", description="Add a new API Key", responses={@ApiResponse(description="The API key that was added", content={@Content(schema=@Schema(implementation=ApiKeyWithSecret.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Consumes(value={"application/json"})
    public Response addApiKey(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The API Key to add") ApiKeySubmission apiKeySubmission) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_API_KEYS));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.API_KEYS));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)apiKeySubmission);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        FormattingUtils.trimAllStrings((Object)apiKeySubmission);
        ApiKeyWithSecret apiKey = new ApiKeyWithSecret();
        apiKey.setName(apiKeySubmission.getName());
        apiKey.setValidityDays(apiKeySubmission.getValidityDays());
        apiKey.setId(UidUtils.getRandom());
        apiKey.setSecret(SecurityUtils.getSecureRandomSecret());
        apiKey.setUser(user.getIdentifier());
        apiKey.setUserId(user.getId());
        apiKey.setCreatedDay(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() / 24L / 3600L / 1000L);
        this.schedulerApplication.getSchedulerConfigurationDao().addApiKey(apiKey);
        this.apiKeys.put(apiKey.getId(), apiKey);
        ApiKey eventResult = new ApiKey(this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, apiKey));
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.API_KEY_ADDED, eventResult, user.getName());
        ResponseCache.getInstance().resetKeyId(CacheKey.API_KEYS, "");
        ApiKeyWithSecret result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, apiKey);
        this.refreshApiKeyStatus(result);
        StringBuilder details = new StringBuilder();
        if (result.getName() != null) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ApiKey.Details.Name", (Object)result.getName()));
        }
        if (details.length() > 0) {
            details.append("\n");
        }
        details.append(this.iu.getFormattedString("ApiKey.Details.Validity", (Object)result.getValidityDays()));
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), result.getId(), Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.API_KEY_ADDED, details.toString(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    public EphemeralApiKeyWithSecret addEphemeralApiKey(BearerUser user) {
        EphemeralApiKeyWithSecret apiKey = new EphemeralApiKeyWithSecret();
        apiKey.setName("Ephemeral " + DateTime.now().getMillis());
        apiKey.setValidityDuration(this.schedulerApplication.getConfiguration().getEphemeralApiKeysValidity());
        apiKey.setId(UidUtils.getRandom());
        apiKey.setSecret(SecurityUtils.getSecureRandomSecret());
        apiKey.setUser(user.getIdentifier());
        apiKey.setUserId(user.getId());
        apiKey.setCreatedDate(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis());
        this.ephemeralApiKeys.put(apiKey.getId(), apiKey);
        return apiKey;
    }

    @Operation(tags={"Security"}, operationId="DeleteApiKey", summary="Delete API Key", description="Delete the API Key with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="404", description="Cannot find API Key with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{apiKeyId}")
    @DELETE
    public Response deleteApiKey(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The ID of the API key to delete") @PathParam(value="apiKeyId") String apiKeyId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        ApiKeyWithSecret originalApiKey = this.getApiKey(apiKeyId);
        if (originalApiKey == null) {
            return ExceptionUtils.toResponse((String)"cannotFindApiKey", (Map)new HashMap<String, String>(){
                {
                    this.put("apiKeyId", apiKeyId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Set smtpServerPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalApiKey).getUserPermissions();
        if (!smtpServerPermissions.contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)apiKeyId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        this.schedulerApplication.getSchedulerConfigurationDao().deleteApiKey(apiKeyId);
        this.apiKeys.remove(apiKeyId);
        ApiKey eventResult = new ApiKey(this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalApiKey));
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.API_KEY_DELETED, eventResult, user.getName());
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), apiKeyId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.API_KEY_DELETED, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        ResponseCache.getInstance().resetKeyId(CacheKey.API_KEYS, "");
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build();
    }
}

