/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.scheduler.security.oidc.OidcUserServiceClient;
import com.nuix.automate.scheduler.utils.HttpAddressUtils;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.general.SchedulerComponent;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.user.AuthMethodType;
import com.nuix.automate.utils.models.internal.user.LdapUserService;
import com.nuix.automate.utils.models.internal.user.OidcUserService;
import com.nuix.automate.utils.models.internal.user.UmsUserService;
import com.nuix.automate.utils.models.internal.user.UserService;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.ResponseCache;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;

@Path(value="/v1/authMethods")
@Produces(value={"application/json"})
public class AuthMethodsResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AuthMethodsResource.class);
    private SchedulerApplication schedulerApplication;
    private SchedulerConfiguration schedulerConfiguration;

    public AuthMethodsResource(SchedulerApplication schedulerApplication, SchedulerConfiguration schedulerConfiguration) {
        this.schedulerApplication = schedulerApplication;
        this.schedulerConfiguration = schedulerConfiguration;
    }

    public Map<String, String> getAuthMethods() {
        return this.getRestrictedAuthMethods(true, null);
    }

    public Map<String, String> getRestrictedAuthMethods(boolean addressIsLocalhost, String requestUrl) {
        HashMap<String, String> authMethods = new HashMap<String, String>();
        for (UserService userService : this.schedulerApplication.getUserServiceResource().getUserServices()) {
            OidcUserServiceClient oidcUserServiceClient;
            if (!userService.getEnabledForUserTriggerdAuth()) continue;
            if (userService instanceof LdapUserService || userService instanceof UmsUserService) {
                if (!userService.getAvailableForUrl(requestUrl)) continue;
                authMethods.put(userService.getName(), userService.getAuthMethodType().toString());
                continue;
            }
            if (!(userService instanceof OidcUserService) || (oidcUserServiceClient = this.schedulerApplication.getUserServiceResource().getOidcUserServiceClient(userService.getId())) == null || !oidcUserServiceClient.valid() || !userService.getAvailableForUrl(requestUrl)) continue;
            authMethods.put(userService.getName(), userService.getAuthMethodType().toString());
            if (!Boolean.TRUE.equals(((OidcUserService)userService).getDefaultAuthenticationProvider())) continue;
            authMethods = new HashMap();
            authMethods.put(userService.getName(), userService.getAuthMethodType().toString());
            return authMethods;
        }
        if (this.schedulerConfiguration.getInternalCredentials() != null && (addressIsLocalhost || !this.schedulerConfiguration.getInternalCredentials().getRestrictToLocalhost())) {
            authMethods.put(this.schedulerConfiguration.getInternalCredentials().getDisplayName(), AuthMethodType.USERNAME_PASSWORD.toString());
        }
        return authMethods;
    }

    @GET
    @Consumes(value={"application/json"})
    public Response getAuthMethods(@Parameter(hidden=true) @Context HttpServletRequest request) {
        if (!this.schedulerConfiguration.getRole().equals((Object)SchedulerComponent.SCHEDULER)) {
            return ExceptionUtils.toResponse((String)"instanceDoesNotHaveScheduler", (Map)null);
        }
        boolean addressIsLocalhost = HttpAddressUtils.isAddressLocalhost(ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request));
        Map<String, String> authMethods = this.getRestrictedAuthMethods(addressIsLocalhost, ResourceUtils.getRemoteRequestUrl((HttpServletRequest)request));
        String lastHash = ResponseCache.getInstance().hashObject(authMethods);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(authMethods).build();
        }
    }
}

