/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.resources.VersionResources;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.scheduler.resources.LibraryResource;
import com.nuix.automate.scheduler.workers.AutomateLicenceWorker;
import com.nuix.automate.scheduler.workers.SchedulerLicenceSession;
import com.nuix.automate.scheduler.workers.UtilizationUploaderLicenceSession;
import com.nuix.automate.utils.api.automatelicense.AutomateLicence;
import com.nuix.automate.utils.api.automatelicense.FileContents;
import com.nuix.automate.utils.api.internal.automatelicense.AutomateLicenceModel;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.licence.Licence;
import com.nuix.automate.utils.licence.LicenceFactory;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.Serializer;
import com.nuix.automate.utils.licence.exceptions.LicenseException;
import com.nuix.automate.utils.licence.services.Credentials;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.licence.services.LicenceSession;
import com.nuix.automate.utils.licence.services.Product;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.resources.Versionable;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.utilization.DiagnosticLevel;
import com.nuix.automate.utils.utilization.Key;
import com.nuix.automate.utils.utilization.License;
import com.nuix.automate.utils.utilization.Organization;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.Closeable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Path(value="/v1/scheduler/resources/automateLicense")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AutomateLicenseResource
extends Versionable
implements Closeable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(AutomateLicenseResource.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private SchedulerApplication schedulerApplication;
    private AutomateLicenceModel rampivaLicence;
    private AutomateLicenceWorker automateLicenceWorker;
    private String previousLicenceFingerprint = "";
    private LicenceSession licenceSession;
    private SchedulerConfiguration configuration;

    public AutomateLicenseResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.configuration = schedulerApplication.getConfiguration();
        this.rampivaLicence = new AutomateLicenceModel();
        this.licenceSession = schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.UTILIZATION_UPLOAD) ? new UtilizationUploaderLicenceSession(schedulerApplication, null, this.rampivaLicence.getLicenceInfo(), Product.SCHEDULER, VersionResources.getVersion(), null, DiagnosticLevel.NONE) : new SchedulerLicenceSession(schedulerApplication, null, this.rampivaLicence.getLicenceInfo(), Product.SCHEDULER, VersionResources.getVersion(), null, DiagnosticLevel.NONE);
        schedulerApplication.getEncryptor();
        this.initializeFromEnv();
        this.initializeFromStore();
        this.automateLicenceWorker = new AutomateLicenceWorker(schedulerApplication, this, this.rampivaLicence);
    }

    private void deleteAllData() {
        this.schedulerApplication.getUtilizationDaoV2().deleteAllorganizationV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAlllicenseV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllclientV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAlluserV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAlldataSetV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAlltransferV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAlltransferVolumeV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAlldataRepositoryV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllengineV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllexecutionProfileV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAlljobV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllcollectionV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllcollectionTargetV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAlllegalHoldV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllnoticeV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllcustodianNoticeV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllcustodianActivityV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAlllibraryV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllmatterV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllnuixCaseV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllrelativityWorkspaceV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllnuixCaseStatV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAlloperationV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllparameterV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllresourcePoolV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllserverV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllworkflowV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllsessionV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllmimeTypeV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllmimeTypeVolumeV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAlloperationSettingV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllactivityV2();
        this.schedulerApplication.getUtilizationDaoV2().deleteAllconsumptionV2();
    }

    private void initializeFromEnv() {
        com.nuix.automate.utils.api.automatelicense.Credentials credentials = this.configuration.getAutomateLicenseCredentials();
        if (credentials != null) {
            this.updateAutomateLicenseCredentialsInternal(credentials);
            this.trackLicenseUpdated();
        }
    }

    private void initializeFromStore() {
        try {
            if (this.rampivaLicence == null || this.rampivaLicence.getCredentials() == null) {
                LOGGER.info("Initializing Automate Licence Location from store");
                List<AutomateLicenceModel> automateLicenses = this.schedulerApplication.getSchedulerConfigurationDao().getRampivaLicences();
                if (automateLicenses.size() > 0) {
                    this.rampivaLicence = automateLicenses.get(0);
                }
                this.trackLicenseUpdated();
            }
        }
        catch (Throwable t) {
            LOGGER.error("Cannot initialize license from store", t);
        }
    }

    public LicenceSession getLicenceSession() {
        return this.licenceSession;
    }

    public void trackLicenseUpdated() {
        this.trackLicenseUpdated(false);
    }

    public void trackLicenseUpdated(boolean forceStartNewSession) {
        boolean credentialsChanged = false;
        String currentLicenceFingerprint = "N/A";
        if (this.rampivaLicence != null) {
            AutomateLicenceModel tempLicence = this.rampivaLicence.clone();
            if (tempLicence.getLicenceInfo() != null) {
                tempLicence.getLicenceInfo().setSignature(null);
            }
            tempLicence.setStatus(null);
            currentLicenceFingerprint = SerializationUtils.toJson((Object)tempLicence);
        }
        if (!currentLicenceFingerprint.equals(this.previousLicenceFingerprint)) {
            LOGGER.info("Detected updated LicenceInfo");
            if (this.rampivaLicence != null) {
                if (this.rampivaLicence.getLegacyLicence() != null) {
                    this.schedulerApplication.getLicenceUtils().setLegacyLicence(this.rampivaLicence.getLegacyLicence());
                } else {
                    this.schedulerApplication.getLicenceUtils().setLicenceInfo(this.rampivaLicence.getLicenceInfo());
                }
                if (this.schedulerApplication.getSchedulerConfigurationDao().updateRampivaLicence(this.rampivaLicence) == 0) {
                    this.schedulerApplication.getSchedulerConfigurationDao().addRampivaLicence(this.rampivaLicence);
                }
            } else {
                this.schedulerApplication.getLicenceUtils().setLicenceInfo(null);
            }
            if (this.rampivaLicence != null && this.rampivaLicence.getLicenceInfo() != null && this.rampivaLicence.getLicenceInfo().getId() != null && (forceStartNewSession || this.licenceSession == null || this.licenceSession.getLicenceInfo() == null || this.licenceSession.getLicenceInfo().getId() == null || !this.rampivaLicence.getLicenceInfo().getId().equals(this.licenceSession.getLicenceInfo().getId()))) {
                if (this.licenceSession != null) {
                    this.licenceSession.close();
                }
                DiagnosticLevel diagnosticLevel = this.schedulerApplication.getSettingsResource().getDiagnosticLevel();
                Key key = this.schedulerApplication.getSettingsResource().getDiagnosticKey();
                if (this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.UTILIZATION_UPLOAD)) {
                    if (forceStartNewSession) {
                        this.deleteAllData();
                    }
                    this.licenceSession = new UtilizationUploaderLicenceSession(this.schedulerApplication, this.rampivaLicence.getCredentials(), this.rampivaLicence.getLicenceInfo(), Product.SCHEDULER, VersionResources.getVersion(), key, diagnosticLevel);
                } else {
                    this.licenceSession = new SchedulerLicenceSession(this.schedulerApplication, this.rampivaLicence.getCredentials(), this.rampivaLicence.getLicenceInfo(), Product.SCHEDULER, VersionResources.getVersion(), key, diagnosticLevel);
                }
                this.licenceSession.startSchedule();
                LicenceInfo licenseInfo = this.rampivaLicence.getLicenceInfo();
                License license = new License();
                license.setLicenseId(licenseInfo.getId());
                license.setLicenseIsActive(licenseInfo.getEnabled());
                license.setLicenseName(licenseInfo.getName());
                license.setLicenseEnvironment(String.valueOf(licenseInfo.getEnvironment()));
                if (licenseInfo.getOrganizationId() != null) {
                    Organization organization = new Organization();
                    license.setOrganizationId(licenseInfo.getOrganizationId());
                    organization.setOrganizationId(licenseInfo.getOrganizationId());
                    organization.setOrganizationIsActive(licenseInfo.getEnabled());
                    organization.setOrganizationName(licenseInfo.getOrganizationName());
                    this.schedulerApplication.getUtilizationDaoV2().replaceOrganization(organization);
                }
                this.schedulerApplication.getUtilizationDaoV2().replaceLicense(license);
            }
            this.resetVersion();
        }
        this.previousLicenceFingerprint = currentLicenceFingerprint;
        LibraryResource libraryResource = this.schedulerApplication.getLibraryResource();
        if (libraryResource != null) {
            libraryResource.buildAllowedOperationsForLicense();
        }
    }

    public AutomateLicenceModel getRampivaLicence() {
        return this.rampivaLicence;
    }

    @Operation(tags={"Resources"}, summary="Get Automate license", operationId="GetAutomateLicense", description="Get the Automate license", responses={@ApiResponse(description="The Automate license", content={@Content(schema=@Schema(implementation=AutomateLicence.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getRampivaLicence(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        AutomateLicence allowedAutomateLicense = null;
        AutomateLicence result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, this.rampivaLicence);
        if (result.getUserPermissions().contains(Permission.VIEW)) {
            allowedAutomateLicense = result;
            allowedAutomateLicense.setDiagnosticLevel(this.schedulerApplication.getSettingsResource().getDiagnosticLevel());
            allowedAutomateLicense.setDiagnosticKeyId(this.schedulerApplication.getSettingsResource().getDiagnosticKey().getId());
        }
        String lastHash = ResponseCache.getInstance().hashObject((Object)allowedAutomateLicense);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)allowedAutomateLicense).build();
        }
    }

    @Operation(tags={"Resources"}, summary="Get Diagnostic Key", operationId="GetDiagnosticKey", description="Get the diagnostic key", responses={@ApiResponse(description="The Diagnostic Key", content={@Content(schema=@Schema(implementation=Key.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/diagnosticKey")
    public Response getDiagnosticKey(@Parameter(hidden=true) @Auth BearerUser user) {
        AutomateLicence result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, this.rampivaLicence);
        Key key = null;
        if (result.getUserPermissions().contains(Permission.VIEW_SENSITIVE)) {
            key = this.schedulerApplication.getSettingsResource().getDiagnosticKey();
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)key).build();
    }

    @Operation(tags={"Resources"}, operationId="UpdateAutomateLicenseCredentials", summary="Update Automate Licence Credentials", description="Update the credentials used to connect to the Automate licence service", responses={@ApiResponse(description="The updated Automate licence", content={@Content(schema=@Schema(implementation=AutomateLicence.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/credentials")
    @PUT
    public Response updateAutomateLicenseCredentials(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The updated licence credentials") com.nuix.automate.utils.api.automatelicense.Credentials licenceCredentials) {
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.AUTOMATE_LICENCE));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        try {
            this.updateAutomateLicenseCredentialsInternal(licenceCredentials);
        }
        catch (LicenseException e) {
            return this.getResponseFromErrorMessage(e.getMessage());
        }
        AutomateLicence result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, this.rampivaLicence);
        result.setDiagnosticLevel(this.schedulerApplication.getSettingsResource().getDiagnosticLevel());
        result.setDiagnosticKeyId(this.schedulerApplication.getSettingsResource().getDiagnosticKey().getId());
        AutomateLicence eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, this.rampivaLicence);
        eventResult.setDiagnosticLevel(this.schedulerApplication.getSettingsResource().getDiagnosticLevel());
        eventResult.setDiagnosticKeyId(this.schedulerApplication.getSettingsResource().getDiagnosticKey().getId());
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTOMATE_LICENSE_UPDATED, eventResult, user.getName());
        this.trackLicenseUpdated(true);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    private void updateAutomateLicenseCredentialsInternal(com.nuix.automate.utils.api.automatelicense.Credentials licenceCredentials) throws LicenseException {
        DiagnosticLevel diagnosticLevel;
        AutomateLicenceModel temporaryLicence = new AutomateLicenceModel();
        temporaryLicence.setLegacyLicence(null);
        temporaryLicence.setLicenceInfo(null);
        temporaryLicence.setId("00000001-6811-44ed-9f38-c2409bccdfc4");
        Credentials credentials = new Credentials();
        credentials.setLicenseKey(licenceCredentials.getLicenseKey());
        credentials.setLicenseId(licenceCredentials.getLicenseId());
        temporaryLicence.setCredentials(credentials);
        if (this.automateLicenceWorker != null) {
            this.automateLicenceWorker.validate(temporaryLicence, true, false);
            if (temporaryLicence.getStatus().getCode().equals((Object)State.ERROR)) {
                throw new LicenseException(temporaryLicence.getStatus().getMessage());
            }
        }
        if ((diagnosticLevel = licenceCredentials.getDiagnosticLevel()) == DiagnosticLevel.NONE || diagnosticLevel == null) {
            LOGGER.error("Cannot set Diagnostic Level to None with a Automate License");
            diagnosticLevel = DiagnosticLevel.REQUIRED;
        }
        this.schedulerApplication.getSettingsResource().setDiagnosticLevel(diagnosticLevel);
        if (this.licenceSession != null) {
            this.licenceSession.setDiagnosticLevel(diagnosticLevel);
        }
        this.rampivaLicence = temporaryLicence;
        if (this.automateLicenceWorker != null) {
            this.automateLicenceWorker.setRampivaLicence(this.rampivaLicence);
        }
    }

    @Operation(tags={"Resources"}, operationId="UpdateAutomateLicenseFile", summary="Update Automate License File", description="Update the Automate license from a license file", responses={@ApiResponse(description="The updated Automate licence", content={@Content(schema=@Schema(implementation=AutomateLicence.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/file")
    @PUT
    public Response updateAutomateLicensefile(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The license file") FileContents fileContentsModel) {
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.AUTOMATE_LICENCE));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)fileContentsModel);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        String fileContents = fileContentsModel.getContents();
        Licence licence = Serializer.deserializeLicence((String)fileContents);
        if (licence == null) {
            return ExceptionUtils.toResponse((String)"invalidLicenceFile", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        AutomateLicenceModel temporaryLicence = new AutomateLicenceModel();
        temporaryLicence.setLegacyLicence(licence);
        temporaryLicence.setLicenceInfo(null);
        temporaryLicence.setCredentials(null);
        temporaryLicence.setId("00000001-6811-44ed-9f38-c2409bccdfc4");
        LicenceInfo licenceInfo = LicenceFactory.getInstance().convertToLicenseInfo(licence);
        temporaryLicence.setLicenceInfo(licenceInfo);
        this.automateLicenceWorker.validate(temporaryLicence, false, false);
        if (temporaryLicence.getStatus().getCode().equals((Object)State.ERROR)) {
            return this.getResponseFromErrorMessage(temporaryLicence.getStatus().getMessage());
        }
        DiagnosticLevel diagnosticLevel = DiagnosticLevel.NONE;
        this.schedulerApplication.getSettingsResource().setDiagnosticLevel(diagnosticLevel);
        this.rampivaLicence = temporaryLicence;
        this.automateLicenceWorker.setRampivaLicence(this.rampivaLicence);
        AutomateLicence result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, this.rampivaLicence);
        result.setDiagnosticLevel(this.schedulerApplication.getSettingsResource().getDiagnosticLevel());
        result.setDiagnosticKeyId(this.schedulerApplication.getSettingsResource().getDiagnosticKey().getId());
        AutomateLicence eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, this.rampivaLicence);
        eventResult.setDiagnosticLevel(this.schedulerApplication.getSettingsResource().getDiagnosticLevel());
        eventResult.setDiagnosticKeyId(this.schedulerApplication.getSettingsResource().getDiagnosticKey().getId());
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTOMATE_LICENSE_UPDATED, eventResult, user.getName());
        this.trackLicenseUpdated(true);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    private Response getResponseFromErrorMessage(String errorMessage) {
        HashMap<String, String> messages = new HashMap<String, String>();
        if (errorMessage != null) {
            messages.put("response", errorMessage);
            return ExceptionUtils.toResponse((String)"automateLicenceError", messages, (Response.Status)Response.Status.BAD_REQUEST);
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("automateLicenceOk", messages)).build();
    }

    @Operation(tags={"Resources"}, operationId="TestAutomateLicense", summary="Test Automate License", description="Verify the Automate license", responses={@ApiResponse(description="The test response", content={@Content(schema=@Schema(implementation=TranslationResponseStatus.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/test")
    @PUT
    public Response testRampivaLicence(@Parameter(hidden=true) @Auth BearerUser user) {
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.AUTOMATE_LICENCE));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        this.automateLicenceWorker.validate(this.rampivaLicence, true, true);
        String errorMessage = null;
        if (this.rampivaLicence.getStatus().getCode().equals((Object)State.ERROR)) {
            errorMessage = this.rampivaLicence.getStatus().getMessage();
        }
        Response testResult = this.getResponseFromErrorMessage(errorMessage);
        return testResult;
    }

    @Override
    public void close() {
        if (this.licenceSession != null) {
            try {
                try {
                    throw new LicenseException("Closing Automate License Resource");
                }
                catch (LicenseException e) {
                    LOGGER.info("Closing session", (Throwable)e);
                    this.licenceSession.close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot close license session", (Throwable)e);
            }
            this.licenceSession = null;
        }
    }

    public void clear() {
        if (this.licenceSession != null) {
            this.licenceSession.close();
        }
        this.schedulerApplication.getSchedulerConfigurationDao().deleteRampivaLicence();
        this.rampivaLicence = new AutomateLicenceModel();
        this.initializeFromStore();
    }

    private static enum Feature {
        SCHEDULER,
        LEGAL_HOLD,
        COLLECTION_ECC,
        COLLECTION_PURVIEW,
        DATA_UPLOAD,
        API_KEY,
        WEBHOOK,
        SCHEDULES,
        CUSTOM_BRANDING,
        CLOUD_RESOURCE_POOLS,
        DASHBOARD,
        NATIVE_ENGINES,
        REMOTE_ENGINES,
        JOB_SIDE_SCRIPTING,
        NUIX_DISCOVER,
        RELATIVITY_REVIEW,
        NUIX_NLP;

    }
}

