/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.general.SortingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.client.ClientPool;
import com.nuix.automate.utils.models.api.client.ClientPoolSubmission;
import com.nuix.automate.utils.models.api.client.ClientSubmission;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.workflow.StaticParameter;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jdbi.v3.core.statement.StatementException;

@Path(value="/v1/scheduler/clientPool")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ClientPoolResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ClientPoolResource.class);
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private SchedulerApplication schedulerApplication;
    private Map<String, ClientPool> clientPools;

    public ClientPoolResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.clientPools = new TreeMap<String, ClientPool>();
    }

    public void initializeClientPoolsFromStore() {
        LOGGER.info("Initializing Client Pools from store");
        List<ClientPool> clientPools = this.schedulerApplication.getClientMatterDao().getClientPools();
        this.clientPools = new TreeMap<String, ClientPool>();
        for (ClientPool clientPool : clientPools) {
            HashSet<String> clientIds = new HashSet<String>(this.schedulerApplication.getClientMatterDao().getClientIdsWithClientPoolId(clientPool.getId()));
            clientPool.setClientIds(clientIds);
            this.clientPools.put(clientPool.getId(), clientPool);
        }
    }

    public void setPoolClientIds(String poolId, Set<String> clientIds) {
        if (clientIds != null) {
            ClientPool clientPool = this.clientPools.get(poolId);
            clientPool.setClientIds(clientIds);
            this.schedulerApplication.getClientMatterDao().deleteClientPoolClients(poolId);
            for (String clientId : clientIds) {
                try {
                    this.schedulerApplication.getClientMatterDao().addClientPoolIdClientId(poolId, clientId);
                }
                catch (StatementException statementException) {}
            }
        }
    }

    public List<String> getPoolsContainingClientId(String clientId) {
        ArrayList<String> poolIds = new ArrayList<String>();
        for (ClientPool clientPool : this.clientPools.values()) {
            if (!clientPool.getClientIds().contains(clientId)) continue;
            poolIds.add(clientPool.getId());
        }
        return poolIds;
    }

    public List<ClientPool> getClientPoolsContainingClientId(String clientId) {
        ArrayList<ClientPool> pools = new ArrayList<ClientPool>();
        for (ClientPool clientPool : this.clientPools.values()) {
            if (!clientPool.getClientIds().contains(clientId)) continue;
            pools.add(clientPool);
        }
        return pools;
    }

    public ClientPool getClientPool(String id) {
        return this.clientPools.get(id);
    }

    public List<ClientPool> getClientPools() {
        ArrayList<ClientPool> allowedClientPools = new ArrayList<ClientPool>();
        allowedClientPools.addAll(this.clientPools.values());
        allowedClientPools.sort(Comparator.comparing(ClientPool::getName, String.CASE_INSENSITIVE_ORDER));
        return allowedClientPools;
    }

    @Operation(tags={"Clients"}, operationId="GetClientPools", summary="Get Client Pools", description="Get full information of all client pools", responses={@ApiResponse(description="The list of client pools", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ClientPool.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getClientPools(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to list client Pools");
        }
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.CLIENT_POOLS, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ArrayList<ClientPool> allowedClientPools = new ArrayList<ClientPool>();
            for (ClientPool clientPool : this.clientPools.values()) {
                ClientPool result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, clientPool);
                if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                allowedClientPools.add(result);
            }
            SortingUtils.sortList(allowedClientPools, ClientPool::getName);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedClientPools).build();
        }
    }

    @Operation(tags={"Clients"}, operationId="AddClientPool", summary="Add Client Pool", description="Add a new client pool", responses={@ApiResponse(description="The client pool that was added", content={@Content(schema=@Schema(implementation=ClientPool.class))}), @ApiResponse(responseCode="400", description="A client pool with the same name")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Consumes(value={"application/json"})
    public Response addClientPool(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The client pool to add", schema=@Schema(implementation=ClientPoolSubmission.class)) ClientPool clientPool) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY) && !this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.CREATE)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)clientPool);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        clientPool.setId(UidUtils.getRandom());
        clientPool.setDefaults();
        FormattingUtils.trimAllStrings((Object)clientPool);
        if (clientPool.getName() == null || clientPool.getName().trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"errorAddingClientPool", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        for (ClientPool existingClientPool : this.clientPools.values()) {
            if (!existingClientPool.getName().equals(clientPool.getName())) continue;
            return ExceptionUtils.toResponse((String)"clientPoolExists", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        Map allowedParameters = clientPool.getAllowedParameterValues();
        TreeMap<Object, List> normalizedAllowedParameters = new TreeMap<Object, List>();
        if (allowedParameters != null) {
            for (final String parameterName : allowedParameters.keySet()) {
                String normalizedParameterName = FormattingUtils.normalizeParameterName((String)parameterName);
                StaticParameter dummyParameter = new StaticParameter(normalizedParameterName, "");
                if (dummyParameter.isEffectiveTypeMaskedOrProtected()) {
                    return ExceptionUtils.toResponse((String)"unsupportedProtectedParameterValues", (Map)new HashMap<String, String>(){
                        {
                            this.put("parameterName", parameterName);
                        }
                    }, (Response.Status)Response.Status.BAD_REQUEST);
                }
                normalizedAllowedParameters.put(normalizedParameterName, (List)allowedParameters.get(parameterName));
            }
        }
        clientPool.setAllowedParameterValues(normalizedAllowedParameters);
        LinkedHashMap workflowParameters = clientPool.getWorkflowParameters();
        LinkedHashMap<String, String> normalizedWorkflowParameters = new LinkedHashMap<String, String>();
        if (workflowParameters != null) {
            for (String parameterName : workflowParameters.keySet()) {
                String normalizedParameterName = FormattingUtils.normalizeParameterName((String)parameterName);
                normalizedWorkflowParameters.put(normalizedParameterName, (String)workflowParameters.get(parameterName));
            }
            Response errorResponse = this.schedulerApplication.getLibraryResource().verifyNoBuiltInParameters(normalizedWorkflowParameters.keySet());
            if (errorResponse != null) {
                return errorResponse;
            }
        }
        clientPool.setWorkflowParameters(normalizedWorkflowParameters);
        Map requiredMetadataHeaders = clientPool.getRequiredMetadataHeaders();
        HashMap<String, String> normalizedMap = new HashMap<String, String>();
        if (requiredMetadataHeaders != null) {
            for (String key : clientPool.getRequiredMetadataHeaders().keySet()) {
                if (key.trim().length() <= 0) continue;
                normalizedMap.put(key, (String)clientPool.getRequiredMetadataHeaders().get(key));
            }
        }
        clientPool.setRequiredMetadataHeaders(normalizedMap);
        Response errorResponse = this.verifyNoClientPoolParameterConflicts(user, clientPool, iu.getString("ClientPool.Action.Add"));
        if (errorResponse != null) {
            return errorResponse;
        }
        this.clientPools.put(clientPool.getId(), clientPool);
        if (this.schedulerApplication.getClientMatterDao().updateClientPool(clientPool) == 0) {
            this.schedulerApplication.getClientMatterDao().addClientPool(clientPool);
        }
        this.setPoolClientIds(clientPool.getId(), clientPool.getClientIds());
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENT_POOLS, "");
        ClientPool result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, clientPool);
        ClientPool eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, clientPool);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.CLIENT_POOL_ADDED, eventResult, user.getName());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Clients"}, operationId="UpdateClientPool", summary="Update Client Pool", description="Update the client pool with the specified ID", responses={@ApiResponse(description="The updated client pool", content={@Content(schema=@Schema(implementation=ClientPool.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{clientPoolId}")
    @PUT
    public Response updateClientPool(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the client pool to update") @PathParam(value="clientPoolId") String clientPoolId, @Parameter(description="The information to update the client pool with", schema=@Schema(implementation=ClientPoolSubmission.class)) ClientPool clientPool) {
        String normalizedParameterName;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Object> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
        resourceIdentifiers.add(new Identifier(IdentifierType.CLIENT_POOL_ID, clientPoolId));
        boolean canModifyPool = this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY);
        if (!canModifyPool && !this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY_CHILDREN)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)clientPool);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        ClientPool originalClientPool = this.clientPools.get(clientPoolId);
        if (originalClientPool == null) {
            return ExceptionUtils.toResponse((String)"invalidClientPoolId", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        FormattingUtils.trimAllStrings((Object)clientPool);
        clientPool.setId(originalClientPool.getId());
        Response errorResponse = this.verifyNoClientPoolParameterConflicts(user, clientPool, iu.getString("ClientPool.Action.Update"));
        if (errorResponse != null) {
            return errorResponse;
        }
        if (clientPool.getName() != null) {
            for (ClientPool existingClientPool : this.clientPools.values()) {
                if (existingClientPool.getId().equals(clientPoolId) || !clientPool.getName().equals(existingClientPool.getName())) continue;
                return ExceptionUtils.toResponse((String)"clientPoolSameNameExists", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
            }
            if (!canModifyPool && !originalClientPool.getName().equals(clientPool.getName())) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)clientPool);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
            originalClientPool.setName(clientPool.getName());
        }
        if (clientPool.getDescription() != null) {
            if (!canModifyPool && !originalClientPool.getDescription().equals(clientPool.getDescription())) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)clientPool);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
            originalClientPool.setDescription(clientPool.getDescription());
        }
        if (clientPool.getAllowedParameterValues() != null) {
            Map allowedParameters = clientPool.getAllowedParameterValues();
            TreeMap<String, List<String>> normalizedAllowedParameters = new TreeMap<String, List<String>>();
            if (allowedParameters != null) {
                for (final Object parameterName : allowedParameters.keySet()) {
                    normalizedParameterName = FormattingUtils.normalizeParameterName((String)parameterName);
                    StaticParameter dummyParameter = new StaticParameter(normalizedParameterName, "");
                    if (dummyParameter.isEffectiveTypeMaskedOrProtected()) {
                        return ExceptionUtils.toResponse((String)"unsupportedProtectedParameterValues", (Map)new HashMap<String, String>(){
                            {
                                this.put("parameterName", parameterName);
                            }
                        }, (Response.Status)Response.Status.BAD_REQUEST);
                    }
                    normalizedAllowedParameters.put(normalizedParameterName, (List)allowedParameters.get(parameterName));
                }
            }
            if (!canModifyPool && !this.sameAllowedParameterValues(originalClientPool.getAllowedParameterValues(), normalizedAllowedParameters)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)clientPool);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
            originalClientPool.setAllowedParameterValues(normalizedAllowedParameters);
        }
        originalClientPool.getStatus().reset();
        if (clientPool.getWorkflowParameters() != null) {
            LinkedHashMap originalWorkflowParameters = originalClientPool.getWorkflowParameters();
            LinkedHashMap updatedWorkflowParameters = clientPool.getWorkflowParameters();
            for (final Object parameterName : updatedWorkflowParameters.keySet()) {
                normalizedParameterName = FormattingUtils.normalizeParameterName((String)parameterName);
                String parameterValue = (String)updatedWorkflowParameters.get(parameterName);
                if (parameterValue != null) continue;
                updatedWorkflowParameters.put(normalizedParameterName, (String)originalWorkflowParameters.get(normalizedParameterName));
            }
            Response errorParameterResponse = this.schedulerApplication.getLibraryResource().verifyNoBuiltInParameters(updatedWorkflowParameters.keySet());
            if (errorParameterResponse != null) {
                return errorParameterResponse;
            }
            originalClientPool.setWorkflowParameters(updatedWorkflowParameters);
        }
        if (clientPool.getRequiredMetadataHeaders() != null) {
            HashMap<String, String> normalizedMap = new HashMap<String, String>();
            for (String key : clientPool.getRequiredMetadataHeaders().keySet()) {
                if (key.trim().length() <= 0) continue;
                normalizedMap.put(key, (String)clientPool.getRequiredMetadataHeaders().get(key));
            }
            if (!canModifyPool && !this.sameHeaders(originalClientPool.getRequiredMetadataHeaders(), normalizedMap)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)clientPool);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
            originalClientPool.setRequiredMetadataHeaders(normalizedMap);
        }
        Set newClientIds = clientPool.getClientIds();
        Set originalClientIds = originalClientPool.getClientIds();
        HashSet<String> modifiedClientIds = new HashSet<String>();
        for (String clientId : newClientIds) {
            if (originalClientIds.contains(clientId)) continue;
            modifiedClientIds.add(clientId);
        }
        for (String clientId : originalClientIds) {
            if (newClientIds.contains(clientId)) continue;
            modifiedClientIds.add(clientId);
        }
        resourceIdentifiers = new HashSet();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            for (String clientId : modifiedClientIds) {
                resourceIdentifiers = new HashSet();
                resourceIdentifiers.add(new Identifier(IdentifierType.CLIENT_ID, clientId));
                if (this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) continue;
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)clientPool);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
        }
        this.setPoolClientIds(clientPoolId, clientPool.getClientIds());
        if (this.schedulerApplication.getClientMatterDao().updateClientPool(originalClientPool) == 0) {
            this.schedulerApplication.getClientMatterDao().addClientPool(originalClientPool);
        }
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENT_POOLS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENT_POOL, clientPoolId);
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENTS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENTS_ENABLED, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.MATTERS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENT_MATTERS_ENABLED, "");
        ClientPool result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalClientPool);
        ClientPool eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalClientPool);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.CLIENT_POOL_MODIFIED, eventResult, user.getName());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    private boolean sameHeaders(Map<String, String> ap1, Map<String, String> ap2) {
        if (ap1 == null && ap2 == null) {
            return true;
        }
        if (ap1 == null || ap2 == null) {
            return false;
        }
        if (ap1.keySet().size() != ap2.keySet().size()) {
            return false;
        }
        for (String key1 : ap1.keySet()) {
            String v1 = ap1.get(key1);
            String v2 = ap2.get(key1);
            if (v2 == null) {
                return false;
            }
            if (v1.equals(v2)) continue;
            return false;
        }
        return true;
    }

    private boolean sameAllowedParameterValues(Map<String, List<String>> ap1, Map<String, List<String>> ap2) {
        if (ap1 == null && ap2 == null) {
            return true;
        }
        if (ap1 == null || ap2 == null) {
            return false;
        }
        if (ap1.keySet().size() != ap2.keySet().size()) {
            return false;
        }
        for (String key1 : ap1.keySet()) {
            List<String> list1 = ap1.get(key1);
            List<String> list2 = ap2.get(key1);
            if (list2 == null) {
                return false;
            }
            if (list1.size() != list2.size()) {
                return false;
            }
            ArrayList<String> list1Sorted = new ArrayList<String>(list1);
            list1Sorted.sort(String::compareTo);
            ArrayList<String> list2Sorted = new ArrayList<String>(list2);
            list2Sorted.sort(String::compareTo);
            for (int i = 0; i < list1Sorted.size(); ++i) {
                if (((String)list1Sorted.get(i)).equals(list2Sorted.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    @Operation(tags={"Clients"}, operationId="AddClientToClientPool", summary="Add Client to Client Pool", description="Add the existing client with the specified ID to the client pool with the specified ID", responses={@ApiResponse(description="The updated client pool", content={@Content(schema=@Schema(implementation=ClientPool.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{clientPoolId}/client/{clientId}")
    @PUT
    public Response addClientToClientPool(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the client pool to update") @PathParam(value="clientPoolId") String clientPoolId, @Parameter(description="The ID of the client to add") @PathParam(value="clientId") String clientId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
        resourceIdentifiers.add(new Identifier(IdentifierType.CLIENT_POOL_ID, clientPoolId));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY) && !this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY_CHILDREN)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)(clientPoolId + " " + clientId));
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        ClientPool originalClientPool = this.clientPools.get(clientPoolId);
        if (originalClientPool == null) {
            return ExceptionUtils.toResponse((String)"invalidClientPoolId", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        ClientPool clientPool = this.clientPools.get(clientPoolId);
        if (clientPool.getClientIds().contains(clientId)) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        ClientPool clonedClientPool = clientPool.clone();
        clonedClientPool.getClientIds().add(clientId);
        Response errorResponse = this.verifyNoClientPoolParameterConflicts(user, clonedClientPool, iu.getString("ClientPool.Action.AddClient"));
        if (errorResponse != null) {
            return errorResponse;
        }
        clientPool.getClientIds().add(clientId);
        try {
            this.schedulerApplication.getClientMatterDao().addClientPoolIdClientId(clientPoolId, clientId);
        }
        catch (StatementException statementException) {
            // empty catch block
        }
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENT_POOLS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENT_POOL, clientPoolId);
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENTS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENTS_ENABLED, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.MATTERS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENT_MATTERS_ENABLED, "");
        ClientPool result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalClientPool);
        ClientPool eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalClientPool);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.CLIENT_POOL_MODIFIED, eventResult, user.getName());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Clients"}, operationId="AddClientInClientPool", summary="Add Client in Client Pool", description="Add a new client in a client pool", responses={@ApiResponse(description="The client that was added", content={@Content(schema=@Schema(implementation=Client.class))}), @ApiResponse(responseCode="400", description="Client name is missing, or a client with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{clientPoolId}/client")
    @POST
    public Response addClientInClientPool(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The ID of the client pool in which to add the client") @PathParam(value="clientPoolId") String clientPoolId, @Parameter(description="The client to add", schema=@Schema(implementation=ClientSubmission.class)) Client client) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
        resourceIdentifiers.add(new Identifier(IdentifierType.CLIENT_POOL_ID, clientPoolId));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY) && !this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY_CHILDREN)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)clientPoolId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        if (client.getName() == null || client.getName().length() == 0) {
            return ExceptionUtils.toResponse((String)"clientNameMissing", (Map)null);
        }
        for (Client existingClient : this.schedulerApplication.getClientMatterDao().getClients()) {
            if (!existingClient.getName().equalsIgnoreCase(client.getName())) continue;
            return ExceptionUtils.toResponse((String)"clientNameInvalid", (Map)null);
        }
        Client result = this.schedulerApplication.getClientResource().addClientInternal(user, client, ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request));
        this.addClientToClientPool(user, clientPoolId, result.getId());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Clients"}, operationId="DeleteClientPool", summary="Delete Client Pool", description="Delete the client pool with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="404", description="Cannot find client pool with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{clientPoolId}")
    @DELETE
    public Response deleteClientPool(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The ID of the client pool to delete") @PathParam(value="clientPoolId") String clientPoolId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
        resourceIdentifiers.add(new Identifier(IdentifierType.CLIENT_POOL_ID, clientPoolId));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)clientPoolId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        ClientPool clientPool = this.clientPools.get(clientPoolId);
        if (clientPool.getClientIds().size() > 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotDeleteClientPool")).build();
        }
        ClientPool deletedClientPool = this.clientPools.remove(clientPoolId);
        this.schedulerApplication.getClientMatterDao().deleteClientPool(clientPoolId);
        this.schedulerApplication.getClientMatterDao().deleteClientPoolClients(clientPoolId);
        if (deletedClientPool == null) {
            return ExceptionUtils.toResponse((String)"clientPoolNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("clientPoolId", clientPoolId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENT_POOLS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENT_POOL, clientPoolId);
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENTS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENTS_ENABLED, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.MATTERS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENT_MATTERS_ENABLED, "");
        ClientPool eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, deletedClientPool);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.CLIENT_POOL_DELETED, eventResult, user.getName());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("resourcePoolDeleted")).build();
    }

    public Response verifyNoClientPoolParameterConflicts(BearerUser user, String clientPoolId, String action) {
        ClientPool modifiedClientPool = this.clientPools.get(clientPoolId);
        if (modifiedClientPool == null) {
            return null;
        }
        return this.verifyNoClientPoolParameterConflicts(user, modifiedClientPool, action);
    }

    public Response verifyNoClientPoolParameterConflicts(BearerUser user, ClientPool modifiedClientPool, String action) {
        List<String> messages = this.getClientPoolParameterConflicts(user, modifiedClientPool);
        if (messages.size() > 0) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("performedAction", action);
            if (messages.size() <= 10) {
                properties.put("conflictingPoolParameters", String.join((CharSequence)"\n", messages));
            } else {
                List<String> trimmedMessages = messages.subList(0, 10);
                trimmedMessages.add("\n" + iu.getNumeralFormattedString("ClientPool.OmittedMessage", (long)(messages.size() - 10), new Object[0]));
                properties.put("conflictingPoolParameters", String.join((CharSequence)"\n", trimmedMessages));
            }
            return ExceptionUtils.toResponse((String)"clientPoolConflictingParameters", properties);
        }
        return null;
    }

    public Response verifyJobNoClientPoolParameterConflicts(BearerUser user, String clientId) {
        if (clientId == null) {
            return null;
        }
        ArrayList<String> messages = new ArrayList<String>();
        String clientName = this.schedulerApplication.getClientResource().getClientName(user, clientId);
        List<ClientPool> jobClientPools = this.getClientPoolsContainingClientId(clientId);
        for (ClientPool clientPool : jobClientPools) {
            messages.addAll(this.getClientPoolParameterConflicts(user, clientPool));
        }
        if (messages.size() > 0) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("clientName", clientName);
            return ExceptionUtils.toResponse((String)"jobClientPoolConflictingParameters", properties);
        }
        return null;
    }

    public List<String> getClientPoolParameterConflicts(BearerUser user, ClientPool modifiedClientPool) {
        ArrayList<String> messages = new ArrayList<String>();
        if (modifiedClientPool != null) {
            Set modifiedClientPoolClientIds = modifiedClientPool.getClientIds();
            HashSet modifiedClientPoolWorkflowParametersNames = new HashSet();
            if (modifiedClientPool.getWorkflowParameters() != null) {
                modifiedClientPoolWorkflowParametersNames.addAll(modifiedClientPool.getWorkflowParameters().keySet());
            }
            if (modifiedClientPoolWorkflowParametersNames.size() == 0 || modifiedClientPoolClientIds == null || modifiedClientPoolClientIds.size() == 0) {
                return messages;
            }
            for (ClientPool clientPool : this.clientPools.values()) {
                if (clientPool.getId().equals(modifiedClientPool.getId()) || clientPool.getClientIds() == null || clientPool.getWorkflowParameters() == null) continue;
                HashSet clientPoolSameClients = new HashSet(clientPool.getClientIds());
                clientPoolSameClients.retainAll(modifiedClientPoolClientIds);
                HashSet conflictingParameters = new HashSet(modifiedClientPoolWorkflowParametersNames);
                conflictingParameters.retainAll(clientPool.getWorkflowParameters().keySet());
                if (clientPoolSameClients.size() <= 0 || conflictingParameters.size() <= 0) continue;
                String clientPoolName = this.getClientPoolName(user, clientPool);
                boolean canViewClientPool = this.canViewClientPool(user, clientPool);
                for (String parameterName : conflictingParameters) {
                    for (String clientId : clientPoolSameClients) {
                        String clientName = this.schedulerApplication.getClientResource().getClientName(user, clientId);
                        if (canViewClientPool) {
                            messages.add("  \u2022 " + iu.getFormattedString("ClientPool.ConflictingParametersDetailed", new Object[]{parameterName, clientPoolName, clientName}));
                            continue;
                        }
                        messages.add("  \u2022 " + iu.getFormattedString("ClientPool.ConflictingParameters", new Object[]{parameterName, clientName}));
                    }
                }
            }
        }
        return messages;
    }

    private boolean canViewClientPool(BearerUser user, ClientPool pool) {
        if (user == null || pool == null) {
            return false;
        }
        Set permissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, pool).getUserPermissions();
        return permissions.contains(Permission.VIEW);
    }

    private String getClientPoolName(BearerUser user, ClientPool pool) {
        if (this.canViewClientPool(user, pool)) {
            return pool.getName();
        }
        return iu.getString("ClientPool.Name.Other");
    }
}

