/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.utils.allowedvalues.AllowedValueUtils;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.general.ResponseUtils;
import com.nuix.automate.utils.general.SortingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.services.LicenceSession;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.client.ClientSubmission;
import com.nuix.automate.utils.models.api.client.Matter;
import com.nuix.automate.utils.models.api.client.MatterSubmission;
import com.nuix.automate.utils.models.api.dataset.Dataset;
import com.nuix.automate.utils.models.api.dataset.DatasetState;
import com.nuix.automate.utils.models.api.dataset.DatasetType;
import com.nuix.automate.utils.models.api.general.ConciseObject;
import com.nuix.automate.utils.models.api.job.AllowedValueItem;
import com.nuix.automate.utils.models.api.job.Job;
import com.nuix.automate.utils.models.api.legalhold.LegalHold;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldState;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobQueueState;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import com.nuix.automate.utils.workflow.StaticParameter;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Path(value="/v1/scheduler/client")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ClientResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ClientResource.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private SchedulerApplication schedulerApplication;
    private Map<String, Client> clients;
    private Map<String, Matter> matters;
    private Map<String, Map<String, Matter>> clientMatters;

    public ClientResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.initializeClientMattersFromStore();
        this.trackUndefinedClientMatter();
    }

    private void initializeClientMattersFromStore() {
        LOGGER.info("Initializing Clients from store");
        this.clients = new HashMap<String, Client>();
        List<Client> clients = this.schedulerApplication.getClientMatterDao().getClients();
        for (Client client : clients) {
            this.clients.put(client.getId(), client);
        }
        LOGGER.info("Initializing Matters from store");
        this.matters = new HashMap<String, Matter>();
        this.clientMatters = new HashMap<String, Map<String, Matter>>();
        List<Matter> matters = this.schedulerApplication.getClientMatterDao().getMatters();
        for (Matter matter : matters) {
            this.matters.put(matter.getId(), matter);
            Map<String, Matter> clientMap = this.clientMatters.get(matter.getClientId());
            if (clientMap == null) {
                clientMap = new HashMap<String, Matter>();
                this.clientMatters.put(matter.getClientId(), clientMap);
            }
            clientMap.put(matter.getId(), matter);
        }
    }

    public Collection<Client> getClients() {
        return this.clients.values();
    }

    public Collection<Matter> getMatters() {
        return this.matters.values();
    }

    @Operation(tags={"Clients", "Job Submission"}, operationId="ListClients", summary="List Clients", description="List all active clients", responses={@ApiResponse(description="The list of clients", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConciseObject.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/list")
    public Response listClients(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The max number of items to return") @QueryParam(value="maxCount") Integer maxCount) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.CLIENTS_ENABLED, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            List allowedClients = ResponseUtils.getConciseList(this.getVisibleClientModels(user, false), (Integer)maxCount);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)allowedClients).build();
        }
    }

    @Operation(tags={"Clients"}, operationId="GetClients", summary="Get Clients", description="Get full information of all clients. Only use this method if the information returned by ListClients is not sufficient", responses={@ApiResponse(description="The list of clients", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Client.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getClients(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="Include disabled clients") @QueryParam(value="includeDisabled") boolean includeDisabled) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(includeDisabled ? CacheKey.CLIENTS : CacheKey.CLIENTS_ENABLED, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            List<Client> allowedClients = this.getVisibleClientModels(user, includeDisabled);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedClients).build();
        }
    }

    public List<Client> getVisibleClientModels(BearerUser user, boolean includeDisabled) {
        ArrayList<Client> clients = new ArrayList<Client>();
        for (Client client : this.clients.values()) {
            if (includeDisabled) {
                clients.add(client);
                continue;
            }
            if (!client.getEnabled().booleanValue()) continue;
            clients.add(client);
        }
        ArrayList<Client> allowedClients = new ArrayList<Client>();
        for (Client client : clients) {
            Client result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, client);
            if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
            allowedClients.add(result);
        }
        SortingUtils.sortList(allowedClients, Client::getName);
        return allowedClients;
    }

    @Operation(tags={"Clients", "Job Submission"}, operationId="ListMatters", summary="List Matters", description="List all active matters of the client with the specified ID", responses={@ApiResponse(description="The list of matters", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConciseObject.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{clientId}/matters/list")
    @GET
    public Response listMatters(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The client ID") @PathParam(value="clientId") String clientId, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The max number of items to return") @QueryParam(value="maxCount") Integer maxCount) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.CLIENT_MATTERS_ENABLED, clientId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            Client client = this.clients.get(clientId);
            if (client == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindClient", (Map)new HashMap<String, String>(){
                    {
                        this.put("clientId", clientId);
                    }
                })).build();
            }
            ArrayList<Matter> matters = new ArrayList<Matter>();
            for (Matter matter : this.getClientMatters(clientId)) {
                if (!client.getEnabled().booleanValue() || !matter.getEnabled().booleanValue()) continue;
                matters.add(matter);
            }
            ArrayList<Matter> allowedMatters = new ArrayList<Matter>();
            for (Matter matter : matters) {
                Matter result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter);
                if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                allowedMatters.add(result);
            }
            SortingUtils.sortList(allowedMatters, Matter::getName);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)ResponseUtils.getConciseList(allowedMatters, (Integer)maxCount)).build();
        }
    }

    @Operation(tags={"Clients"}, operationId="GetMatters", summary="Get Matters", description="Get full information of all matters of the client with the specified ID. Only use this method if the information returned by ListMatters is not sufficient", responses={@ApiResponse(description="The list of matters", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Matter.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{clientId}/matters")
    @GET
    public Response getMatters(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The client ID") @PathParam(value="clientId") String clientId, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="Include disabled matters") @QueryParam(value="includeDisabled") boolean includeDisabled) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(includeDisabled ? CacheKey.CLIENT_MATTERS : CacheKey.CLIENT_MATTERS_ENABLED, clientId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            Client client = this.clients.get(clientId);
            if (client == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindClient", (Map)new HashMap<String, String>(){
                    {
                        this.put("clientId", clientId);
                    }
                })).build();
            }
            ArrayList<Matter> matters = new ArrayList<Matter>();
            for (Matter matter : this.getClientMatters(clientId)) {
                if (includeDisabled) {
                    matters.add(matter);
                    continue;
                }
                if (!client.getEnabled().booleanValue() || !matter.getEnabled().booleanValue()) continue;
                matters.add(matter);
            }
            ArrayList<Matter> allowedMatters = new ArrayList<Matter>();
            for (Matter matter : matters) {
                Matter result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter);
                if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                allowedMatters.add(result);
            }
            SortingUtils.sortList(allowedMatters, Matter::getName);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedMatters).build();
        }
    }

    public Client getClient(String clientId) {
        if (clientId != null) {
            return this.clients.get(clientId);
        }
        return null;
    }

    public Collection<Matter> getClientMatters(String clientId) {
        Map<String, Matter> clientMap = this.clientMatters.get(clientId);
        if (clientMap == null) {
            return new ArrayList<Matter>();
        }
        return clientMap.values();
    }

    @Operation(tags={"Clients"}, operationId="GetClient", summary="Get Client", description="Get the client with the specified ID", responses={@ApiResponse(description="The client", content={@Content(schema=@Schema(implementation=Client.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{clientId}")
    @GET
    public Response getClient(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The client ID") @PathParam(value="clientId") String clientId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.CLIENT, clientId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            Client client = this.clients.get(clientId);
            if (client == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindClient", (Map)new HashMap<String, String>(){
                    {
                        this.put("clientId", clientId);
                    }
                })).build();
            }
            Client result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, client);
            if (!result.getUserPermissions().contains(Permission.VIEW)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
        }
    }

    @Operation(tags={"Clients"}, operationId="UpdateClient", summary="Update Client", description="Update the client with the specified ID", responses={@ApiResponse(description="The updated client", content={@Content(schema=@Schema(implementation=Client.class))}), @ApiResponse(responseCode="400", description="Client name is missing, or a client with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{clientId}")
    @PUT
    public Response updateClient(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The ID of the client to update") @PathParam(value="clientId") String clientId, @Parameter(description="The information to update the client with", schema=@Schema(implementation=ClientSubmission.class)) Client client) {
        String normalizedParameterName;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Client originalClient = this.clients.get(clientId);
        FormattingUtils.trimAllStrings((Object)client);
        if (client.getName() == null) {
            client.setName(originalClient.getName());
        }
        if (client.getDescription() == null) {
            client.setDescription(originalClient.getDescription());
        }
        if (client.getEnabled() == null) {
            client.setEnabled(originalClient.getEnabled());
        }
        if (client.getDefaultExecutionProfileId() == null) {
            client.setDefaultExecutionProfileId(originalClient.getDefaultExecutionProfileId());
        }
        if (client.getDefaultResourcePoolId() == null) {
            client.setDefaultResourcePoolId(originalClient.getDefaultResourcePoolId());
        }
        if (client.getReference() == null) {
            client.setReference(originalClient.getReference());
        }
        if (client.getName().length() == 0) {
            return ExceptionUtils.toResponse((String)"clientNameMissing", (Map)null);
        }
        for (final Client existingClient : this.clients.values()) {
            if (!existingClient.getName().equalsIgnoreCase(client.getName()) || existingClient.getId().equals(clientId)) continue;
            return ExceptionUtils.toResponse((String)"clientNamedExists", (Map)new HashMap<String, String>(){
                {
                    this.put("existingClientModel", existingClient.getName());
                }
            });
        }
        if (client.getAllowedParameterValues() == null) {
            client.setAllowedParameterValues(originalClient.getAllowedParameterValues());
        } else {
            Map allowedParameters = client.getAllowedParameterValues();
            TreeMap<String, List> normalizedAllowedParameters = new TreeMap<String, List>();
            if (allowedParameters != null) {
                for (final String parameterName : allowedParameters.keySet()) {
                    normalizedParameterName = FormattingUtils.normalizeParameterName((String)parameterName);
                    StaticParameter dummyParameter = new StaticParameter(normalizedParameterName, "");
                    if (dummyParameter.isEffectiveTypeMaskedOrProtected()) {
                        return ExceptionUtils.toResponse((String)"unsupportedProtectedParameterValues", (Map)new HashMap<String, String>(){
                            {
                                this.put("parameterName", parameterName);
                            }
                        }, (Response.Status)Response.Status.BAD_REQUEST);
                    }
                    normalizedAllowedParameters.put(normalizedParameterName, (List)allowedParameters.get(parameterName));
                }
            }
            client.setAllowedParameterValues(normalizedAllowedParameters);
        }
        client.getStatus().reset();
        if (client.getWorkflowParameters() == null) {
            client.setWorkflowParameters(originalClient.getWorkflowParameters());
        } else {
            LinkedHashMap originalWorkflowParameters = originalClient.getWorkflowParameters();
            LinkedHashMap updatedWorkflowParameters = client.getWorkflowParameters();
            for (final String parameterName : updatedWorkflowParameters.keySet()) {
                normalizedParameterName = FormattingUtils.normalizeParameterName((String)parameterName);
                String parameterValue = (String)updatedWorkflowParameters.get(parameterName);
                if (parameterValue != null) continue;
                updatedWorkflowParameters.put(normalizedParameterName, (String)originalWorkflowParameters.get(normalizedParameterName));
            }
            Response errorResponse = this.schedulerApplication.getLibraryResource().verifyNoBuiltInParameters(updatedWorkflowParameters.keySet());
            if (errorResponse != null) {
                return errorResponse;
            }
            client.setWorkflowParameters(updatedWorkflowParameters);
        }
        if (client.getRequiredMetadataHeaders() == null) {
            client.setRequiredMetadataHeaders(originalClient.getRequiredMetadataHeaders());
        } else {
            HashMap<String, String> normalizedMap = new HashMap<String, String>();
            for (String key : client.getRequiredMetadataHeaders().keySet()) {
                if (key.trim().length() <= 0) continue;
                normalizedMap.put(key, (String)client.getRequiredMetadataHeaders().get(key));
            }
            client.setRequiredMetadataHeaders(normalizedMap);
        }
        client.setId(clientId);
        client.setDefaults();
        Client result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, client);
        if (!result.getUserPermissions().contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        this.schedulerApplication.getClientMatterDao().updateClient(client);
        this.clients.put(clientId, client);
        Client updatedClient = client.clone();
        StringBuilder details = new StringBuilder();
        if (originalClient.getName() == null || !originalClient.getName().equals(updatedClient.getName())) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ClientResource.Details.Name", (Object)updatedClient.getName()));
        }
        if (originalClient.getDescription() == null || !originalClient.getDescription().equals(updatedClient.getDescription())) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ClientResource.Details.Description", (Object)updatedClient.getDescription()));
        }
        if (originalClient.getEnabled() == null || !originalClient.getEnabled().equals(updatedClient.getEnabled())) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ClientResource.Details.Enabled", (Object)updatedClient.getEnabled()));
        }
        if (!(updatedClient.getReference() == null || originalClient.getReference() != null && originalClient.getReference().equals(updatedClient.getReference()))) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ClientResource.Details.Reference", (Object)updatedClient.getReference()));
        }
        if (!(updatedClient.getDefaultResourcePoolId() == null || originalClient.getDefaultResourcePoolId() != null && originalClient.getDefaultResourcePoolId().equals(updatedClient.getDefaultResourcePoolId()))) {
            if (details.length() > 0) {
                details.append("\n");
            }
            String resourcePoolId = updatedClient.getDefaultResourcePoolId();
            ResourcePoolModel resourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(resourcePoolId);
            if (resourcePool != null) {
                details.append(this.iu.getFormattedString("ClientResource.Details.DefaultResourcePool", (Object)resourcePool.getName()));
            } else {
                details.append(this.iu.getFormattedString("ClientResource.Details.DefaultResourcePoolId", (Object)resourcePoolId));
            }
        }
        if (!(updatedClient.getDefaultExecutionProfileId() == null || originalClient.getDefaultExecutionProfileId() != null && originalClient.getDefaultExecutionProfileId().equals(updatedClient.getDefaultExecutionProfileId()))) {
            if (details.length() > 0) {
                details.append("\n");
            }
            String executionProfileId = updatedClient.getDefaultExecutionProfileId();
            ExecutionProfileModel executionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(executionProfileId);
            if (executionProfile != null) {
                details.append(this.iu.getFormattedString("ClientResource.Details.DefaultExecutionProfile", (Object)executionProfile.getName()));
            } else {
                details.append(this.iu.getFormattedString("ClientResource.Details.DefaultExecutionProfileId", (Object)executionProfileId));
            }
        }
        if (details.length() > 0) {
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), clientId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.CLIENT_MODIFIED, details.toString(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        }
        this.updateClientUtilization(updatedClient);
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENTS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENTS_ENABLED, "");
        result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, updatedClient);
        Client eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, updatedClient);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.CLIENT_MODIFIED, eventResult, user.getName());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    public Client addClientInternal(BearerUser user, Client client, String remoteAddress) {
        String clientId = UidUtils.getRandom();
        client.setId(clientId);
        client.setDefaults();
        FormattingUtils.trimAllStrings((Object)client);
        this.clients.put(clientId, client);
        this.clientMatters.put(clientId, new HashMap());
        this.schedulerApplication.getClientMatterDao().addClient(client);
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENTS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENTS_ENABLED, "");
        Client createdClient = client.clone();
        if (createdClient != null) {
            StringBuilder details = new StringBuilder();
            if (createdClient.getName() != null) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(this.iu.getFormattedString("ClientResource.Details.Name", (Object)createdClient.getName()));
            }
            if (createdClient.getDescription() != null) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(this.iu.getFormattedString("ClientResource.Details.Description", (Object)createdClient.getDescription()));
            }
            if (createdClient.getEnabled() != null) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(this.iu.getFormattedString("ClientResource.Details.Enabled", (Object)createdClient.getEnabled()));
            }
            if (createdClient.getReference() == null) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(this.iu.getFormattedString("ClientResource.Details.Reference", (Object)createdClient.getReference()));
            }
            if (createdClient.getDefaultResourcePoolId() != null) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                String resourcePoolId = createdClient.getDefaultResourcePoolId();
                ResourcePoolModel resourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(resourcePoolId);
                if (resourcePool != null) {
                    details.append(this.iu.getFormattedString("ClientResource.Details.DefaultResourcePool", (Object)resourcePool.getName()));
                } else {
                    details.append(this.iu.getFormattedString("ClientResource.Details.DefaultResourcePoolId", (Object)resourcePoolId));
                }
            }
            if (createdClient.getDefaultExecutionProfileId() != null) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                String executionProfileId = createdClient.getDefaultExecutionProfileId();
                ExecutionProfileModel executionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(executionProfileId);
                if (executionProfile != null) {
                    details.append(this.iu.getFormattedString("ClientResource.Details.DefaultExecutionProfile", (Object)executionProfile.getName()));
                } else {
                    details.append(this.iu.getFormattedString("ClientResource.Details.DefaultExecutionProfileId", (Object)executionProfileId));
                }
            }
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), clientId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.CLIENT_ADDED, details.toString(), remoteAddress));
        }
        this.updateClientUtilization(createdClient);
        Client result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, createdClient);
        Client eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, createdClient);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.CLIENT_ADDED, eventResult, user.getName());
        return result;
    }

    @Operation(tags={"Clients"}, operationId="AddClient", summary="Add Client", description="Add a new client", responses={@ApiResponse(description="The client that was added", content={@Content(schema=@Schema(implementation=Client.class))}), @ApiResponse(responseCode="400", description="Client name is missing, or a client with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    public Response addClient(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The client to add", schema=@Schema(implementation=ClientSubmission.class)) Client client) {
        Response errorResponse;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)client);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        if (client.getName() == null || client.getName().length() == 0) {
            return ExceptionUtils.toResponse((String)"clientNameMissing", (Map)null);
        }
        for (final Client existingClient : this.clients.values()) {
            if (!existingClient.getName().equalsIgnoreCase(client.getName())) continue;
            return ExceptionUtils.toResponse((String)"clientExists", (Map)new HashMap<String, String>(){
                {
                    this.put("existingClientModel", existingClient.getName());
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        Map allowedParameters = client.getAllowedParameterValues();
        TreeMap<Object, List> normalizedAllowedParameters = new TreeMap<Object, List>();
        if (allowedParameters != null) {
            for (final String parameterName : allowedParameters.keySet()) {
                String normalizedParameterName = FormattingUtils.normalizeParameterName((String)parameterName);
                StaticParameter dummyParameter = new StaticParameter(normalizedParameterName, "");
                if (dummyParameter.isEffectiveTypeMaskedOrProtected()) {
                    return ExceptionUtils.toResponse((String)"unsupportedProtectedParameterValues", (Map)new HashMap<String, String>(){
                        {
                            this.put("parameterName", parameterName);
                        }
                    }, (Response.Status)Response.Status.BAD_REQUEST);
                }
                normalizedAllowedParameters.put(normalizedParameterName, (List)allowedParameters.get(parameterName));
            }
        }
        client.setAllowedParameterValues(normalizedAllowedParameters);
        Map requiredMetadataHeaders = client.getRequiredMetadataHeaders();
        HashMap<String, String> normalizedMap = new HashMap<String, String>();
        if (requiredMetadataHeaders != null) {
            for (String key : client.getRequiredMetadataHeaders().keySet()) {
                if (key.trim().length() <= 0) continue;
                normalizedMap.put(key, (String)client.getRequiredMetadataHeaders().get(key));
            }
        }
        client.setRequiredMetadataHeaders(normalizedMap);
        LinkedHashMap workflowParameters = client.getWorkflowParameters();
        LinkedHashMap<String, String> normalizedWorkflowParameters = new LinkedHashMap<String, String>();
        if (workflowParameters != null) {
            for (String parameterName : workflowParameters.keySet()) {
                String normalizedParameterName = FormattingUtils.normalizeParameterName((String)parameterName);
                normalizedWorkflowParameters.put(normalizedParameterName, (String)workflowParameters.get(parameterName));
            }
        }
        if ((errorResponse = this.schedulerApplication.getLibraryResource().verifyNoBuiltInParameters(normalizedWorkflowParameters.keySet())) != null) {
            return errorResponse;
        }
        client.setWorkflowParameters(normalizedWorkflowParameters);
        Client result = this.addClientInternal(user, client, ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request));
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Clients"}, operationId="DeleteClient", summary="Delete Client", description="Delete the client with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="400", description="Cannot find client with the specified ID or client has matters associated")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{clientId}")
    @DELETE
    public Response deleteClient(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The ID of the client to delete") @PathParam(value="clientId") String clientId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Client client = this.clients.get(clientId);
        if (client == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindClient", (Map)new HashMap<String, String>(){
                {
                    this.put("clientId", clientId);
                }
            })).build();
        }
        Client result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, client);
        if (!result.getUserPermissions().contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        Collection<Matter> matters = this.getClientMatters(clientId);
        if (matters.size() > 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotDeleteClient")).build();
        }
        this.schedulerApplication.getClientMatterDao().deleteClient(clientId);
        this.clients.remove(clientId);
        Client eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, client);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.CLIENT_DELETED, eventResult, user.getName());
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), clientId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.CLIENT_DELETED, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENTS, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENTS_ENABLED, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENT, clientId);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("clientDeleted", (Map)new HashMap<String, String>(){
            {
                this.put("clientId", clientId);
            }
        })).build();
    }

    private void trackUndefinedClientMatter() {
        com.nuix.automate.utils.utilization.Client client = new com.nuix.automate.utils.utilization.Client();
        client.setClientName("_Undefined");
        client.setClientIsActive(true);
        client.setClientId(UidUtils.fromString((String)"_Undefined", (String)"client").toString());
        com.nuix.automate.utils.utilization.Matter matter = new com.nuix.automate.utils.utilization.Matter();
        matter.setMatterName("_Undefined");
        matter.setMatterIsActive(true);
        matter.setMatterId(UidUtils.fromString((String)"_Undefined", (String)"matter").toString());
        matter.setClientId(client.getClientId());
        this.schedulerApplication.getUtilizationDaoV2().replaceClient(client);
        this.schedulerApplication.getUtilizationDaoV2().replaceMatter(matter);
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<com.nuix.automate.utils.utilization.Client> clients = new HashSet<com.nuix.automate.utils.utilization.Client>();
        utilizationRecords.setClients(clients);
        clients.add(client);
        HashSet<com.nuix.automate.utils.utilization.Matter> matters = new HashSet<com.nuix.automate.utils.utilization.Matter>();
        utilizationRecords.setMatters(matters);
        matters.add(matter);
        LicenceSession licenseSession = this.schedulerApplication.getAutomateLicenceResource().getLicenceSession();
        if (licenseSession != null) {
            licenseSession.tryTrackUtilizationRecordsAsync(utilizationRecords);
        }
    }

    private void updateClientUtilization(Client clientModel) {
        com.nuix.automate.utils.utilization.Client client = new com.nuix.automate.utils.utilization.Client();
        client.setClientId(clientModel.getId());
        client.setClientIsActive(clientModel.getEnabled().booleanValue());
        client.setClientName(clientModel.getName());
        this.schedulerApplication.getUtilizationDaoV2().replaceClient(client);
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<com.nuix.automate.utils.utilization.Client> clients = new HashSet<com.nuix.automate.utils.utilization.Client>();
        utilizationRecords.setClients(clients);
        clients.add(client);
        this.schedulerApplication.getAutomateLicenceResource().getLicenceSession().tryTrackUtilizationRecordsAsync(utilizationRecords);
    }

    private void updateMatterUtilization(Matter matterModel) {
        com.nuix.automate.utils.utilization.Matter matter = new com.nuix.automate.utils.utilization.Matter();
        matter.setMatterId(matterModel.getId());
        matter.setMatterIsActive(matterModel.getEnabled().booleanValue());
        matter.setClientId(matterModel.getClientId());
        matter.setMatterName(matterModel.getName());
        this.schedulerApplication.getUtilizationDaoV2().replaceMatter(matter);
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<com.nuix.automate.utils.utilization.Matter> matters = new HashSet<com.nuix.automate.utils.utilization.Matter>();
        utilizationRecords.setMatters(matters);
        matters.add(matter);
        this.schedulerApplication.getAutomateLicenceResource().getLicenceSession().tryTrackUtilizationRecordsAsync(utilizationRecords);
    }

    public Matter getMatter(String matterId) {
        return this.matters.get(matterId);
    }

    @Operation(tags={"Clients"}, operationId="GetMatter", summary="Get Matter", description="Get the matter with the specified ID", responses={@ApiResponse(description="The matter", content={@Content(schema=@Schema(implementation=Matter.class))}), @ApiResponse(responseCode="400", description="Cannot find matter with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/matter/{matterId}")
    @GET
    public Response getMatter(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The ID of the matter to get") @PathParam(value="matterId") String matterId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.MATTER, matterId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            Matter matter = this.matters.get(matterId);
            if (matter == null) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindMatter", (Map)new HashMap<String, String>(){
                    {
                        this.put("matterId", matterId);
                    }
                })).build();
            }
            Matter result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter);
            if (!result.getUserPermissions().contains(Permission.VIEW)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
            }
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
        }
    }

    @Operation(tags={"Datasets"}, operationId="GetMatterDatasets", summary="Get Datasets", description="Get full information of all datasets assigned to the matter with the specified ID", responses={@ApiResponse(description="The list of datasets", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Dataset.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="matter/{matterId}/datasets")
    @GET
    public Response getMatterDatasets(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The matter ID") @PathParam(value="matterId") String matterId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.MATTER_DATASETS, matterId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            Matter matter = this.matters.get(matterId);
            if (matter == null) {
                return ExceptionUtils.toResponse((String)"cannotFindMatter", (Map)new HashMap<String, String>(){
                    {
                        this.put("matterId", matterId);
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
            matter = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter);
            if (!matter.getUserPermissions().contains(Permission.VIEW)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)matter);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
            }
            ArrayList<Dataset> datasets = new ArrayList<Dataset>();
            for (Dataset dataset : this.getMatterDatasets(matterId)) {
                Dataset clone = dataset.clone();
                if (clone.getType() == DatasetType.ECC) {
                    clone.setFileMetadataHeaders(null);
                }
                datasets.add(clone);
            }
            datasets.sort(Comparator.comparing(Dataset::getNumber));
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(datasets).build();
        }
    }

    public List<Dataset> getMatterDatasets(String matterId) {
        return this.schedulerApplication.getDatasetResource().getDatasets().stream().filter(dataset -> dataset.getMatterId().equals(matterId) && !dataset.getState().equals((Object)DatasetState.DELETED)).collect(Collectors.toList());
    }

    public List<LegalHold> getNonFinishedLegalHoldsForMatter(String matterId) {
        return this.schedulerApplication.getLegalHoldResource().getLegalHolds().stream().filter(legalHold -> matterId.equals(legalHold.getMatterId()) && legalHold.getState() != LegalHoldState.ARCHIVED).collect(Collectors.toList());
    }

    @Operation(tags={"Clients"}, operationId="GetMatterAllowedParameterValues", summary="Get Matter Allowed Parameter Values", description="Get the parameter values which are allowed for the matter with the specified ID", responses={@ApiResponse(description="The allowed parameter values", content={@Content(array=@ArraySchema(schema=@Schema(ref="#/components/schemas/ParametersValue")))}), @ApiResponse(responseCode="404", description="Client with the specified ID does not exist")})
    @SecurityRequirement(name="Bearer_Token")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/matter/{matterId}/allowedSessionParameterValues")
    @POST
    public Response getAllowedMatterParameterValues(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the matter for which to get the required parameters") @PathParam(value="matterId") String matterId, @Parameter(description="The names of the parameters for which to get the allowed values") Set<String> parameterNames) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Matter matter = this.matters.get(matterId);
        Matter result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter);
        if (!result.getUserPermissions().contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        try {
            Map<String, List<String>> values = AllowedValueUtils.getInstance(this.schedulerApplication).getAllowedSessionParameterValues(user, matterId, null, parameterNames, null);
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(values).build();
        }
        catch (IllegalArgumentException e) {
            return ExceptionUtils.toResponse((String)"parameterValueError", (Map)new HashMap<String, String>(){
                {
                    this.put("message", e.getMessage());
                }
            }, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Operation(tags={"Clients"}, operationId="GetMatterWorkflowAllowedParameterValues", summary="Get Matter and Workflow Allowed Parameter Values", description="Get the parameter values which are allowed for the matter with the specified ID and for the workflow with the specified ID", responses={@ApiResponse(description="The allowed parameter value items", content={@Content(array=@ArraySchema(schema=@Schema(ref="#/components/schemas/ParametersValue")))}), @ApiResponse(responseCode="404", description="Job with the specified ID does not exist")})
    @SecurityRequirement(name="Bearer_Token")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/matter/{matterId}/allowedSessionParameterValues/workflow/{workflowId}")
    @POST
    public Response getMatterWorkflowAllowedParameterValues(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the matter for which to get the required parameters") @PathParam(value="matterId") String matterId, final @Parameter(description="The ID of the workflow for which to get the required parameters") @PathParam(value="workflowId") String workflowId, @Parameter(description="The Parameters for which to get the allowed values") LinkedHashMap<String, String> parameterNameValueMap, @Parameter(description="The queue state of job for which to get the allowed values") @QueryParam(value="queueState") JobQueueState queueState, @Context HttpServletRequest request) {
        Matter matterResult;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Matter matter = this.matters.get(matterId);
        if (matter != null && !(matterResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter)).getUserPermissions().contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)matterResult);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        Workflow workflowModel = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(workflowId);
        if (workflowModel == null) {
            return ExceptionUtils.toResponse((String)"cannotFindWorkflow", (Map)new HashMap<String, String>(){
                {
                    this.put("workflowId", workflowId);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        Workflow workflowResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflowModel);
        if (!workflowResult.getUserPermissions().contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)workflowResult);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        Permission allowedValuesScopePermission = queueState == JobQueueState.STAGING ? Permission.STAGE_JOB : Permission.SUBMIT_JOB;
        try {
            Map<String, List<AllowedValueItem>> values = AllowedValueUtils.getInstance(this.schedulerApplication).getAllowedSessionParameterValueItems(user, matterId, workflowId, workflowResult.getSessionParameters(), parameterNameValueMap, allowedValuesScopePermission, false);
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(values).build();
        }
        catch (IllegalArgumentException e) {
            return ExceptionUtils.toResponse((String)"parameterValueError", (Map)new HashMap<String, String>(){
                {
                    this.put("message", e.getMessage());
                }
            }, (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @Operation(tags={"Clients"}, operationId="AddMatter", summary="Add Matter", description="Add a new matter", responses={@ApiResponse(description="The matter that was added", content={@Content(schema=@Schema(implementation=Matter.class))}), @ApiResponse(responseCode="400", description="Matter name is missing, or a matter with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/matter")
    @POST
    public Response addMatter(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The matter to add", schema=@Schema(implementation=MatterSubmission.class)) Matter matter) {
        Response errorResponse;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (matter.getName() == null || matter.getName().length() == 0) {
            return ExceptionUtils.toResponse((String)"matterNameMissing", (Response.Status)Response.Status.BAD_REQUEST);
        }
        final Client client = this.clients.get(matter.getClientId());
        if (client == null) {
            return ExceptionUtils.toResponse((String)"clientIdNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("clientId", matter.getClientId());
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Client clientResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, client);
        if (!clientResult.getUserPermissions().contains(Permission.MODIFY) && !clientResult.getUserPermissions().contains(Permission.MODIFY_CHILDREN)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)matter);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        Collection<Matter> existingMatters = this.getClientMatters(matter.getClientId());
        for (final Matter existingMatter : existingMatters) {
            if (!existingMatter.getName().equalsIgnoreCase(matter.getName())) continue;
            return ExceptionUtils.toResponse((String)"matterExists", (Map)new HashMap<String, String>(){
                {
                    this.put("existingMatterModel", existingMatter.getName());
                    this.put("clientModel", client.getName());
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        Map allowedParameters = matter.getAllowedParameterValues();
        TreeMap<Object, List> normalizedAllowedParameters = new TreeMap<Object, List>();
        if (allowedParameters != null) {
            for (final String parameterName : allowedParameters.keySet()) {
                String normalizedParameterName = FormattingUtils.normalizeParameterName((String)parameterName);
                StaticParameter dummyParameter = new StaticParameter(normalizedParameterName, "");
                if (dummyParameter.isEffectiveTypeMaskedOrProtected()) {
                    return ExceptionUtils.toResponse((String)"unsupportedProtectedParameterValues", (Map)new HashMap<String, String>(){
                        {
                            this.put("parameterName", parameterName);
                        }
                    }, (Response.Status)Response.Status.BAD_REQUEST);
                }
                normalizedAllowedParameters.put(normalizedParameterName, (List)allowedParameters.get(parameterName));
            }
        }
        matter.setAllowedParameterValues(normalizedAllowedParameters);
        matter.normalizeRequiredMetadataHeaders();
        LinkedHashMap workflowParameters = matter.getWorkflowParameters();
        LinkedHashMap<String, String> normalizedWorkflowParameters = new LinkedHashMap<String, String>();
        if (workflowParameters != null) {
            for (String parameterName : workflowParameters.keySet()) {
                String normalizedParameterName = FormattingUtils.normalizeParameterName((String)parameterName);
                normalizedWorkflowParameters.put(normalizedParameterName, (String)workflowParameters.get(parameterName));
            }
        }
        if ((errorResponse = this.schedulerApplication.getLibraryResource().verifyNoBuiltInParameters(normalizedWorkflowParameters.keySet())) != null) {
            return errorResponse;
        }
        matter.setWorkflowParameters(normalizedWorkflowParameters);
        String matterId = UidUtils.getRandom();
        matter.setId(matterId);
        matter.setDefaults();
        FormattingUtils.trimAllStrings((Object)matter);
        this.schedulerApplication.getClientMatterDao().addMatter(matter);
        this.matters.put(matterId, matter);
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENT_MATTERS, client.getId());
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENT_MATTERS_ENABLED, client.getId());
        Map<String, Matter> clientMap = this.clientMatters.get(matter.getClientId());
        if (clientMap == null) {
            clientMap = new HashMap<String, Matter>();
            this.clientMatters.put(matter.getClientId(), clientMap);
        }
        clientMap.put(matterId, matter);
        Matter createdMatter = matter.clone();
        if (createdMatter != null) {
            StringBuilder details = new StringBuilder();
            if (createdMatter.getName() != null) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(this.iu.getFormattedString("ClientResource.Details.Name", (Object)createdMatter.getName()));
            }
            if (createdMatter.getDescription() != null) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(this.iu.getFormattedString("ClientResource.Details.Description", (Object)createdMatter.getDescription()));
            }
            if (createdMatter.getClientId() != null) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(this.iu.getFormattedString("ClientResource.Details.ClientId", (Object)createdMatter.getClientId()));
            }
            if (createdMatter.getEnabled() != null) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(this.iu.getFormattedString("ClientResource.Details.Enabled", (Object)createdMatter.getEnabled()));
            }
            if (createdMatter.getSynchronizeJobs() != null) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(this.iu.getFormattedString("ClientResource.Details.SynchronizeJobs", (Object)createdMatter.getSynchronizeJobs()));
            }
            if (createdMatter.getReference() == null) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(this.iu.getFormattedString("ClientResource.Details.Reference", (Object)createdMatter.getReference()));
            }
            if (createdMatter.getDefaultResourcePoolId() != null) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                String resourcePoolId = createdMatter.getDefaultResourcePoolId();
                ResourcePoolModel resourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(resourcePoolId);
                if (resourcePool != null) {
                    details.append(this.iu.getFormattedString("ClientResource.Details.DefaultResourcePool", (Object)resourcePool.getName()));
                } else {
                    details.append(this.iu.getFormattedString("ClientResource.Details.DefaultResourcePoolId", (Object)resourcePoolId));
                }
            }
            if (createdMatter.getDefaultExecutionProfileId() != null) {
                if (details.length() > 0) {
                    details.append("\n");
                }
                String executionProfileId = createdMatter.getDefaultExecutionProfileId();
                ExecutionProfileModel executionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(executionProfileId);
                if (executionProfile != null) {
                    details.append(this.iu.getFormattedString("ClientResource.Details.DefaultExecutionProfile", (Object)executionProfile.getName()));
                } else {
                    details.append(this.iu.getFormattedString("ClientResource.Details.DefaultExecutionProfileId", (Object)executionProfileId));
                }
            }
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), matterId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.MATTER_ADDED, details.toString(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        }
        this.updateMatterUtilization(createdMatter);
        Matter result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, createdMatter);
        Matter eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, createdMatter);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.MATTER_ADDED, eventResult, user.getName());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Clients"}, operationId="DeleteMatter", summary="Delete Matter", description="Delete the matter with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="400", description="Cannot find matter with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/matter/{matterId}")
    @DELETE
    public Response deleteMatter(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The ID of the matter to delete") @PathParam(value="matterId") String matterId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Matter matter = this.matters.get(matterId);
        if (matter == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindMatter", (Map)new HashMap<String, String>(){
                {
                    this.put("matterId", matterId);
                }
            })).build();
        }
        Matter result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter);
        if (!result.getUserPermissions().contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)matter);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        final ArrayList<String> causeMessages = new ArrayList<String>();
        int datasetsSize = this.getMatterDatasets(matterId).size();
        if (datasetsSize > 0) {
            causeMessages.add(this.iu.getNumeralString("ClientResource.CannotDeleteMatter.DatasetCause", (long)datasetsSize));
        }
        int hiddenJobCount = 0;
        for (JobDetailsModel jobDetailsModel : this.schedulerApplication.getJobResource().getNonFinishedJobsUsingMatter(matterId)) {
            Job permissionsJob = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobDetailsModel.getSettings());
            if (permissionsJob.getUserPermissions().contains(Permission.VIEW)) {
                causeMessages.add(this.iu.getFormattedString("ClientResource.CannotDeleteMatter.JobCause", new Object[]{permissionsJob.getName(), permissionsJob.getExecutionState().getLocalizedString()}));
                continue;
            }
            ++hiddenJobCount;
        }
        if (hiddenJobCount > 0) {
            causeMessages.add(this.iu.getNumeralString("ClientResource.CannotDeleteMatter.ProcessingJobCauseHidden", (long)hiddenJobCount));
        }
        int hiddenLegalHoldCount = 0;
        for (LegalHold legalHold : this.getNonFinishedLegalHoldsForMatter(matterId)) {
            LegalHold permissionsLegalHold = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold);
            if (permissionsLegalHold.canView()) {
                causeMessages.add(this.iu.getFormattedString("ClientResource.CannotDeleteMatter.LegalHoldCause", new Object[]{permissionsLegalHold.getName(), permissionsLegalHold.getState().getLocalizedString()}));
                continue;
            }
            ++hiddenLegalHoldCount;
        }
        if (hiddenLegalHoldCount > 0) {
            causeMessages.add(this.iu.getNumeralString("ClientResource.CannotDeleteMatter.LegalHoldCauseHidden", (long)hiddenLegalHoldCount));
        }
        if (causeMessages.size() > 0) {
            return ExceptionUtils.toResponse((String)"cannotDeleteMatter", (Map)new HashMap<String, String>(){
                {
                    this.put("message", String.join((CharSequence)"\n", causeMessages));
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        this.schedulerApplication.getClientMatterDao().deleteMatter(matterId);
        this.matters.remove(matterId);
        Map<String, Matter> map = this.clientMatters.get(matter.getClientId());
        if (map != null) {
            map.remove(matterId);
        }
        Matter eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.MATTER_DELETED, eventResult, user.getName());
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), matterId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.MATTER_DELETED, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENT_MATTERS, matter.getClientId());
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENT_MATTERS_ENABLED, matter.getClientId());
        ResponseCache.getInstance().resetKeyId(CacheKey.MATTER, matter.getId());
        ResponseCache.getInstance().resetKeyId(CacheKey.MATTER_DATASETS, matter.getId());
        ResponseCache.getInstance().resetKeyId(CacheKey.MATTERS, "");
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("matterDeleted", (Map)new HashMap<String, String>(){
            {
                this.put("matterId", matterId);
            }
        })).build();
    }

    public void updateMatterByUserInternal(Matter matter, BearerUser user) {
        this.updateMatterInternal(matter);
        Matter eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.MATTER_MODIFIED, eventResult, user.getName());
    }

    public void updateMatterInternal(Matter matter) {
        FormattingUtils.trimAllStrings((Object)matter);
        this.schedulerApplication.getClientMatterDao().updateMatter(matter);
        this.matters.put(matter.getId(), matter);
        Map<String, Matter> clientMap = this.clientMatters.get(matter.getClientId());
        if (clientMap == null) {
            clientMap = new HashMap<String, Matter>();
            this.clientMatters.put(matter.getClientId(), clientMap);
        }
        clientMap.put(matter.getId(), matter);
    }

    @Operation(tags={"Clients"}, operationId="UpdateMatter", summary="Update Matter", description="Update the matter with the specified ID", responses={@ApiResponse(description="The updated matter", content={@Content(schema=@Schema(implementation=Client.class))}), @ApiResponse(responseCode="400", description="Client name is missing, or a matter with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/matter/{matterId}")
    @PUT
    public Response updateMatter(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The ID of the matter to update") @PathParam(value="matterId") String matterId, final @Parameter(description="The information to update the matter with", schema=@Schema(implementation=MatterSubmission.class)) Matter matter) {
        String normalizedParameterName;
        Client client;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Matter originalMatter = this.matters.get(matterId);
        if (originalMatter == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindMatter", (Map)new HashMap<String, String>(){
                {
                    this.put("matterId", matterId);
                }
            })).build();
        }
        Matter result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalMatter);
        if (!result.getUserPermissions().contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)originalMatter);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        if (matter.getName() == null) {
            matter.setName(originalMatter.getName());
        }
        if (matter.getName().length() == 0) {
            return ExceptionUtils.toResponse((String)"matterNameMissing", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (matter.getDescription() == null) {
            matter.setDescription(originalMatter.getDescription());
        }
        if (matter.getDefaultExecutionProfileId() == null) {
            matter.setDefaultExecutionProfileId(originalMatter.getDefaultExecutionProfileId());
        }
        if (matter.getDefaultResourcePoolId() == null) {
            matter.setDefaultResourcePoolId(originalMatter.getDefaultResourcePoolId());
        }
        if (matter.getReference() == null) {
            matter.setReference(originalMatter.getReference());
        }
        if (matter.getClientId() != null && !originalMatter.getClientId().equals(matter.getClientId())) {
            client = this.clients.get(matter.getClientId());
            if (client == null) {
                return ExceptionUtils.toResponse((String)"cannotFindClient", (Map)new HashMap<String, String>(){
                    {
                        this.put("clientId", matter.getClientId());
                    }
                });
            }
            client = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, client);
            if (!client.getUserPermissions().contains(Permission.MODIFY) && !client.getUserPermissions().contains(Permission.MODIFY_CHILDREN)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)client);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
        }
        if (matter.getClientId() == null) {
            matter.setClientId(originalMatter.getClientId());
        }
        if (matter.getEnabled() == null) {
            matter.setEnabled(originalMatter.getEnabled());
        }
        if (matter.getSynchronizeJobs() == null) {
            matter.setSynchronizeJobs(originalMatter.getSynchronizeJobs());
        }
        matter.getStatus().reset();
        if (matter.getAllowedParameterValues() == null) {
            matter.setAllowedParameterValues(originalMatter.getAllowedParameterValues());
        } else {
            Map allowedParameters = matter.getAllowedParameterValues();
            TreeMap<String, List> normalizedAllowedParameters = new TreeMap<String, List>();
            if (allowedParameters != null) {
                for (final String parameterName : allowedParameters.keySet()) {
                    normalizedParameterName = FormattingUtils.normalizeParameterName((String)parameterName);
                    StaticParameter dummyParameter = new StaticParameter(normalizedParameterName, "");
                    if (dummyParameter.isEffectiveTypeMaskedOrProtected()) {
                        return ExceptionUtils.toResponse((String)"unsupportedProtectedParameterValues", (Map)new HashMap<String, String>(){
                            {
                                this.put("parameterName", parameterName);
                            }
                        }, (Response.Status)Response.Status.BAD_REQUEST);
                    }
                    normalizedAllowedParameters.put(normalizedParameterName, (List)allowedParameters.get(parameterName));
                }
            }
            matter.setAllowedParameterValues(normalizedAllowedParameters);
        }
        if (matter.getWorkflowParameters() == null) {
            matter.setWorkflowParameters(originalMatter.getWorkflowParameters());
        } else {
            LinkedHashMap originalWorkflowParameters = originalMatter.getWorkflowParameters();
            LinkedHashMap updatedWorkflowParameters = matter.getWorkflowParameters();
            for (final String parameterName : updatedWorkflowParameters.keySet()) {
                normalizedParameterName = FormattingUtils.normalizeParameterName((String)parameterName);
                String parameterValue = (String)updatedWorkflowParameters.get(parameterName);
                if (parameterValue != null) continue;
                updatedWorkflowParameters.put(normalizedParameterName, (String)originalWorkflowParameters.get(normalizedParameterName));
            }
            Response errorResponse = this.schedulerApplication.getLibraryResource().verifyNoBuiltInParameters(updatedWorkflowParameters.keySet());
            if (errorResponse != null) {
                return errorResponse;
            }
            matter.setWorkflowParameters(updatedWorkflowParameters);
        }
        if (matter.getRequiredMetadataHeaders() == null) {
            matter.setRequiredMetadataHeaders(originalMatter.getRequiredMetadataHeaders());
        } else {
            matter.normalizeRequiredMetadataHeaders();
        }
        matter.setDatasetCounter(originalMatter.getDatasetCounter());
        client = this.clients.get(matter.getClientId());
        if (client == null) {
            return ExceptionUtils.toResponse((String)"clientIdNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("clientId", matter.getClientId());
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Collection<Matter> existingMatters = this.clientMatters.get(matter.getClientId()).values();
        for (final Matter existingMatter : existingMatters) {
            if (!existingMatter.getName().equalsIgnoreCase(matter.getName()) || existingMatter.getId().equals(matterId)) continue;
            return ExceptionUtils.toResponse((String)"matterNamedExistsInClient", (Map)new HashMap<String, String>(){
                {
                    this.put("existingMatterModel", existingMatter.getName());
                    this.put("clientModel", client.getName());
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        matter.setId(matterId);
        matter.setDefaults();
        this.updateMatterByUserInternal(matter, user);
        Matter updatedMatter = matter.clone();
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENT_MATTERS, matter.getClientId());
        ResponseCache.getInstance().resetKeyId(CacheKey.CLIENT_MATTERS_ENABLED, matter.getClientId());
        ResponseCache.getInstance().resetKeyId(CacheKey.MATTER, matter.getId());
        ResponseCache.getInstance().resetKeyId(CacheKey.MATTERS, "");
        if (!originalMatter.getClientId().equals(matter.getClientId())) {
            LOGGER.info("Matter " + matterId + " moved from Client " + FormattingUtils.encodeForLog((String)originalMatter.getClientId()) + " to Client " + FormattingUtils.encodeForLog((String)matter.getClientId()));
            Map<String, Matter> clientMap = this.clientMatters.get(originalMatter.getClientId());
            if (clientMap != null) {
                clientMap.remove(matterId);
            }
            ResponseCache.getInstance().resetKeyId(CacheKey.CLIENT_MATTERS, originalMatter.getClientId());
            ResponseCache.getInstance().resetKeyId(CacheKey.CLIENT_MATTERS_ENABLED, originalMatter.getClientId());
            clientMap = this.clientMatters.get(matter.getClientId());
            if (clientMap != null) {
                clientMap.put(matterId, matter);
            }
        }
        StringBuilder details = new StringBuilder();
        if (originalMatter.getName() == null || !originalMatter.getName().equals(updatedMatter.getName())) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ClientResource.Details.Name", (Object)originalMatter.getName()));
        }
        if (originalMatter.getDescription() == null || !originalMatter.getDescription().equals(updatedMatter.getDescription())) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ClientResource.Details.Description", (Object)originalMatter.getDescription()));
        }
        if (originalMatter.getClientId() == null || !originalMatter.getClientId().equals(updatedMatter.getClientId())) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ClientResource.Details.ClientId", (Object)originalMatter.getClientId()));
        }
        if (originalMatter.getEnabled() == null || !originalMatter.getEnabled().equals(updatedMatter.getEnabled())) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ClientResource.Details.Enabled", (Object)originalMatter.getEnabled()));
        }
        if (!(updatedMatter.getSynchronizeJobs() == null || originalMatter.getSynchronizeJobs() != null && originalMatter.getSynchronizeJobs().equals(updatedMatter.getSynchronizeJobs()))) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ClientResource.Details.SynchronizeJobs", (Object)originalMatter.getSynchronizeJobs()));
        }
        if (!(updatedMatter.getReference() == null || originalMatter.getReference() != null && originalMatter.getReference().equals(updatedMatter.getReference()))) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ClientResource.Details.Reference", (Object)updatedMatter.getReference()));
        }
        if (!(updatedMatter.getDefaultResourcePoolId() == null || originalMatter.getDefaultResourcePoolId() != null && originalMatter.getDefaultResourcePoolId().equals(updatedMatter.getDefaultResourcePoolId()))) {
            if (details.length() > 0) {
                details.append("\n");
            }
            String resourcePoolId = updatedMatter.getDefaultResourcePoolId();
            ResourcePoolModel resourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(resourcePoolId);
            if (resourcePool != null) {
                details.append(this.iu.getFormattedString("ClientResource.Details.DefaultResourcePool", (Object)resourcePool.getName()));
            } else {
                details.append(this.iu.getFormattedString("ClientResource.Details.DefaultResourcePoolId", (Object)resourcePoolId));
            }
        }
        if (!(updatedMatter.getDefaultExecutionProfileId() == null || originalMatter.getDefaultExecutionProfileId() != null && originalMatter.getDefaultExecutionProfileId().equals(updatedMatter.getDefaultExecutionProfileId()))) {
            if (details.length() > 0) {
                details.append("\n");
            }
            String executionProfileId = updatedMatter.getDefaultExecutionProfileId();
            ExecutionProfileModel executionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(executionProfileId);
            if (executionProfile != null) {
                details.append(this.iu.getFormattedString("ClientResource.Details.DefaultExecutionProfile", (Object)executionProfile.getName()));
            } else {
                details.append(this.iu.getFormattedString("ClientResource.Details.DefaultExecutionProfileId", (Object)executionProfileId));
            }
        }
        if (details.length() > 0) {
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), matterId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.MATTER_MODIFIED, details.toString(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        }
        this.updateMatterUtilization(updatedMatter);
        result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, updatedMatter);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    public String getClientName(BearerUser user, String clientId) {
        if (user == null || clientId == null) {
            return this.iu.getString("Client.Name.Other");
        }
        Client client = this.clients.get(clientId);
        if (client == null) {
            return this.iu.getString("Client.Name.Other");
        }
        Set permissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, client).getUserPermissions();
        if (permissions.contains(Permission.VIEW)) {
            return client.getName();
        }
        return this.iu.getString("ClientPool.Name.Other");
    }
}

