/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.scheduler.Command;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.HashSet;
import java.util.Set;

@Path(value="/v1/scheduler/command")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CommandResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CommandResource.class);
    private final SchedulerApplication schedulerApplication;

    public CommandResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
    }

    @Operation(tags={"Utils"}, operationId="Command", summary="Command", description="Sends command to Scheduler", responses={@ApiResponse(description="The command result", content={@Content(schema=@Schema(implementation=String.class, example="OK"))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response executeCommand(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The command to run", example="SHUTDOWN") Command command) {
        String result;
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        Set<Permission> permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), scopeIdentifiers);
        if (!permissions.contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)command);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        LOGGER.info("Got command " + String.valueOf(command));
        switch (command) {
            case SHUTDOWN: {
                this.schedulerApplication.closeWithDelay(1000L, "Received Shutdown command");
                result = "Shutting down in 1s";
                break;
            }
            default: {
                return ExceptionUtils.toResponse((String)"commandNotImplemented", (Response.Status)Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }
}

