/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.azure.storage.blob.BlobServiceAsyncClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobContainerItem;
import com.azure.storage.blob.models.BlobServiceProperties;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.persistance.utilization.UtilizationDao;
import com.nuix.automate.scheduler.utils.AzureStorageAccountUtils;
import com.nuix.automate.scheduler.utils.DatasetUtils;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.ResponseUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.SortingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.client.Matter;
import com.nuix.automate.utils.models.api.dataset.AzureStorageAccount;
import com.nuix.automate.utils.models.api.dataset.DataRepository;
import com.nuix.automate.utils.models.api.dataset.DataRepositoryCommand;
import com.nuix.automate.utils.models.api.dataset.DataRepositoryFile;
import com.nuix.automate.utils.models.api.dataset.DataRepositorySubmission;
import com.nuix.automate.utils.models.api.dataset.Dataset;
import com.nuix.automate.utils.models.api.dataset.DatasetPathFormat;
import com.nuix.automate.utils.models.api.dataset.DatasetType;
import com.nuix.automate.utils.models.api.dataset.FileNode;
import com.nuix.automate.utils.models.api.general.ConciseObject;
import com.nuix.automate.utils.models.api.legalhold.LegalHold;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.internal.cache.CachedObjectMap;
import com.nuix.automate.utils.models.internal.dataset.UsableSpace;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@jakarta.ws.rs.Path(value="/v1/scheduler/resources/dataRepository")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DataRepositoryResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DataRepositoryResource.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;
    private final Map<String, DataRepository> dataRepositories;
    private final DatasetUtils datasetUtils;
    private final AzureStorageAccountUtils azureStorageAccountUtils;
    private final CachedObjectMap<Lock> userSessionLocks;

    public DataRepositoryResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.dataRepositories = new ConcurrentHashMap<String, DataRepository>();
        this.datasetUtils = DatasetUtils.getDatasetUtils(schedulerApplication);
        this.azureStorageAccountUtils = AzureStorageAccountUtils.getInstance();
        this.userSessionLocks = new CachedObjectMap(120000L);
        schedulerApplication.getScheduledExecutorService().scheduleWithFixedDelay(() -> this.userSessionLocks.clearExpired(), 0L, 1L, TimeUnit.HOURS);
    }

    public void initializeDataRepositoriesFromStore() {
        LOGGER.info("Initializing Data Repositories from store");
        List<DataRepository> dataRepositories = this.schedulerApplication.getSchedulerConfigurationDao().getDataRepositories();
        for (DataRepository dataRepository : dataRepositories) {
            if (dataRepository.getType() != DatasetType.AZURE_STORAGE_ACCOUNT && dataRepository.getComputeFileSystemUsableSpace() == null) {
                dataRepository.setComputeFileSystemUsableSpace(Boolean.valueOf(true));
                this.schedulerApplication.getSchedulerConfigurationDao().updateDataRepository(dataRepository);
            }
            this.dataRepositories.put(dataRepository.getId(), dataRepository);
        }
    }

    public void initializeDataRepositoryHealthCheck() {
        this.schedulerApplication.getScheduledExecutorService().submit(() -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Data Repository Health Check - testing azure storage account credentials with a get containers request");
            }
            for (DataRepository dataRepository : this.dataRepositories.values()) {
                if (dataRepository.getType() != DatasetType.AZURE_STORAGE_ACCOUNT) continue;
                try {
                    BlobServiceAsyncClient blobServiceAsyncClient = this.azureStorageAccountUtils.getBlobServiceAsyncClient(dataRepository.getAzureStorageAccount());
                    blobServiceAsyncClient.getProperties().subscribe(null, error -> dataRepository.getStatus().setError(this.iu.getFormattedString("DataRepositoryResource.ErrorAccessingAzureStorageAccount", error)));
                }
                catch (Exception e) {
                    dataRepository.getStatus().setError(this.iu.getFormattedString("DataRepositoryResource.ErrorAccessingAzureStorageAccount", (Object)e));
                }
            }
        });
        this.schedulerApplication.getScheduledExecutorService().scheduleWithFixedDelay(() -> {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Data Repository Health Check - updating usable space for all managed repositories");
            }
            for (DataRepository dataRepository : this.dataRepositories.values()) {
                if (dataRepository.getType() != DatasetType.MANAGED) continue;
                this.updateUsableSpace(dataRepository);
            }
        }, 0L, this.schedulerApplication.getConfiguration().getDataRepositoryUsableSpaceInterval(), TimeUnit.MILLISECONDS);
    }

    public void updateUsableSpace(DataRepository dataRepository) {
        boolean changed;
        try {
            UsableSpace oldUsableSpace = dataRepository.getUsableSpace();
            dataRepository.setUsableSpace(this.datasetUtils.getRepositoryUsableSpace(dataRepository));
            UsableSpace usableSpace = dataRepository.getUsableSpace();
            boolean bl = changed = oldUsableSpace == null || usableSpace.getEffectiveUsableSpace() != null && !usableSpace.getEffectiveUsableSpace().equals(oldUsableSpace.getEffectiveUsableSpace()) || oldUsableSpace.getEffectiveUsableSpace() != null && !oldUsableSpace.getEffectiveUsableSpace().equals(usableSpace.getEffectiveUsableSpace());
            if (dataRepository.getStatus().getCode() == State.ERROR) {
                dataRepository.getStatus().reset();
                changed = true;
            }
        }
        catch (IOException e) {
            LOGGER.error("Exception calculating usableSpace for data repository: " + dataRepository.getId(), (Throwable)e);
            dataRepository.getStatus().setError(this.iu.getFormattedString("DataRepositoryResource.ExceptionGettingUsableSpace", (Object)e));
            changed = true;
        }
        if (changed) {
            this.schedulerApplication.getSchedulerConfigurationDao().updateDataRepository(dataRepository);
            ResponseCache.getInstance().resetKeyId(CacheKey.DATA_REPOSITORY, dataRepository.getId());
            ResponseCache.getInstance().resetKeyId(CacheKey.DATA_REPOSITORIES, "");
        }
    }

    private void trackDataRepositoryUtilization(DataRepository dataRepositoryModel) {
        com.nuix.automate.utils.utilization.DataRepository dataRepository = new com.nuix.automate.utils.utilization.DataRepository();
        dataRepository.setDataRepositoryId(dataRepositoryModel.getId());
        dataRepository.setDataRepositoryName(dataRepositoryModel.getName());
        dataRepository.setDataRepositoryLocation(dataRepositoryModel.getPath());
        UtilizationDao utilization = this.schedulerApplication.getUtilizationDaoV2();
        utilization.replaceDataRepository(dataRepository);
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<com.nuix.automate.utils.utilization.DataRepository> dataRepositories = new HashSet<com.nuix.automate.utils.utilization.DataRepository>();
        utilizationRecords.setDataRepositories(dataRepositories);
        dataRepositories.add(dataRepository);
        this.schedulerApplication.getAutomateLicenceResource().getLicenceSession().tryTrackUtilizationRecordsAsync(utilizationRecords);
    }

    public DataRepository getDataRepository(String id) {
        if (id != null) {
            return this.dataRepositories.get(id);
        }
        return null;
    }

    public Collection<DataRepository> getDataRepositories() {
        return this.dataRepositories.values();
    }

    @Operation(tags={"Resources"}, operationId="UpdateDataRepositoryUsableSpace", summary="Update Data Repository Usable Space", description="Update the usable space of the supplied data repository", responses={@ApiResponse(description="The repository with the updated usable space", content={@Content(schema=@Schema(implementation=DataRepository.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @jakarta.ws.rs.Path(value="/usableSpace")
    @POST
    public Response testRepositoryUsableSpace(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The Data Repository to test", schema=@Schema(implementation=DataRepositorySubmission.class)) DataRepository dataRepository) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (dataRepository.getType().equals((Object)DatasetType.AZURE_STORAGE_ACCOUNT)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.AZURE_STORAGE);
        } else {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_UPLOAD);
        }
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_DATA_REPOSITORIES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)dataRepository);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        final String path = dataRepository.getPath().trim();
        if (!FileUtils.isPathAbsolute((String)path)) {
            return ExceptionUtils.toResponse((String)"dataRepositoryInvalidPath", (Map)new HashMap<String, String>(){
                {
                    this.put("path", path);
                }
            });
        }
        try {
            dataRepository.setUsableSpace(this.datasetUtils.getRepositoryUsableSpace(dataRepository));
        }
        catch (IOException e) {
            LOGGER.error("Exception calculating usableSpace for data repository: " + dataRepository.getId(), (Throwable)e);
            dataRepository.getStatus().setError(this.iu.getFormattedString("DataRepositoryResource.ExceptionGettingUsableSpace", (Object)e));
            return ExceptionUtils.toResponse((String)"errorGettingDatasetUsableSpace", (Map)new HashMap<String, String>(){
                {
                    this.put("exception", dataRepository.getStatus().getMessage());
                }
            }, (Response.Status)Response.Status.SERVICE_UNAVAILABLE);
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)dataRepository).build();
    }

    @Operation(tags={"Resources"}, operationId="UpdateDataRepositoryIDUsableSpace", summary="Update Data Repository ID Usable Space", description="Update the usable space of the data repository with the supplied ID", responses={@ApiResponse(description="The repository with the updated usable space", content={@Content(schema=@Schema(implementation=DataRepository.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @jakarta.ws.rs.Path(value="/{dataRepositoryId}/usableSpace")
    @GET
    public Response computeRepositoryUsableSpace(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The ID of the Data Repository to update") @PathParam(value="dataRepositoryId") String dataRepositoryId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        final DataRepository originalDataRepository = this.dataRepositories.get(dataRepositoryId);
        if (originalDataRepository == null) {
            return ExceptionUtils.toResponse((String)"cannotFindDataRepository", (Map)new HashMap<String, String>(){
                {
                    this.put("dataRepositoryId", dataRepositoryId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        if (originalDataRepository.getType().equals((Object)DatasetType.AZURE_STORAGE_ACCOUNT)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.AZURE_STORAGE);
        } else {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_UPLOAD);
        }
        Set dataRepositoryPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalDataRepository).getUserPermissions();
        if (!dataRepositoryPermissions.contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)dataRepositoryId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        this.updateUsableSpace(originalDataRepository);
        if (originalDataRepository.getStatus().getCode() == State.ERROR) {
            LOGGER.error("Failed to get repository usable space");
            return ExceptionUtils.toResponse((String)"errorGettingDatasetUsableSpace", (Map)new HashMap<String, String>(){
                {
                    this.put("exception", originalDataRepository.getStatus().getMessage());
                }
            }, (Response.Status)Response.Status.SERVICE_UNAVAILABLE);
        }
        DataRepository result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalDataRepository);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Resources"}, operationId="SendDataRepositoryCommand", summary="Send Command to Data Repository", description="Send a command to a data repository")
    @SecurityRequirement(name="Bearer_Token")
    @jakarta.ws.rs.Path(value="/{dataRepositoryId}/command")
    @POST
    public Response sendDataRepositoryCommand(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @PathParam(value="dataRepositoryId") String dataRepositoryId, @Parameter(description="The command") DataRepositoryCommand command) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        DataRepository dataRepository = this.dataRepositories.get(dataRepositoryId);
        if (dataRepository == null) {
            return ExceptionUtils.toResponse((String)"cannotFindDataRepository", (Map)new HashMap<String, String>(){
                {
                    this.put("dataRepositoryId", dataRepositoryId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Set dataRepositoryPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, dataRepository).getUserPermissions();
        if (!dataRepositoryPermissions.contains(Permission.MODIFY)) {
            return ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)dataRepositoryId);
        }
        try {
            switch (command.getCommand()) {
                case CREATE_FOLDER: {
                    String folderPath = (String)command.getBody().get("path");
                    final Path newFolderPath = FileUtils.safeResolveParent((String)dataRepository.getPath(), (String[])new String[]{folderPath});
                    if (Files.exists(newFolderPath, new LinkOption[0])) {
                        return ExceptionUtils.toResponse((String)"dataRepositoryFileExistsAtPath", (Map)new HashMap<String, String>(){
                            {
                                this.put("path", newFolderPath.toString());
                            }
                        }, (Response.Status)Response.Status.BAD_REQUEST);
                    }
                    Files.createDirectories(newFolderPath, new FileAttribute[0]);
                    DataRepositoryFile newFolder = new DataRepositoryFile(newFolderPath);
                    return Response.status((Response.Status)Response.Status.OK).entity((Object)newFolder).build();
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error handling data repository command " + String.valueOf(command.getCommand()) + " for " + dataRepositoryId, (Throwable)e);
            return ExceptionUtils.toResponse((String)"errorHandlingDataRepositoryCommand", (Exception)e, (Response.Status)Response.Status.BAD_REQUEST);
        }
        return ExceptionUtils.toResponse((String)"invalidDataRepositoryCommand", (Response.Status)Response.Status.BAD_REQUEST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(tags={"Resources", "Job Submission"}, operationId="ListDataRepositoryFiles", summary="List Data Repository Files", description="List the data repository files. If the path is not set, the root of the data repository will be used", responses={@ApiResponse(description="The list of files", content={@Content(array=@ArraySchema(schema=@Schema(implementation=DataRepositoryFile.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @jakarta.ws.rs.Path(value="/{dataRepositoryId}/files/list")
    @GET
    public Response listDataRepositoryFiles(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @PathParam(value="dataRepositoryId") String dataRepositoryId, final @QueryParam(value="path") String path, @QueryParam(value="includeFiles") boolean includeFiles, @QueryParam(value="allowedFileExtensions") String allowedFileExtensions) {
        Path parentPath;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        DataRepository dataRepository = this.dataRepositories.get(dataRepositoryId);
        if (dataRepository == null) {
            return ExceptionUtils.toResponse((String)"cannotFindDataRepository", (Map)new HashMap<String, String>(){
                {
                    this.put("dataRepositoryId", dataRepositoryId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        if (!dataRepository.getType().equals((Object)DatasetType.IN_PLACE)) {
            LOGGER.error("Could not get files for dataRepository: " + dataRepositoryId + " path: " + path + " because dataRepository is of type " + String.valueOf(dataRepository.getType()));
            return ExceptionUtils.buildForbiddenResponse();
        }
        Set dataRepositoryPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, dataRepository).getUserPermissions();
        if (!dataRepositoryPermissions.contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)dataRepositoryId);
            return ExceptionUtils.buildForbiddenResponse();
        }
        Path dataRepositoryPath = Paths.get(dataRepository.getPath(), new String[0]);
        if (path == null || path.trim().length() == 0) {
            parentPath = dataRepositoryPath;
        } else {
            try {
                parentPath = Paths.get(path, new String[0]).normalize().toAbsolutePath();
            }
            catch (RuntimeException e) {
                LOGGER.error("Could not get files for dataRepository: " + dataRepositoryId + " path: " + path, (Throwable)e);
                return ExceptionUtils.toResponse((String)"errorScanningDataRepository", (Exception)e);
            }
        }
        if (!parentPath.startsWith(dataRepositoryPath)) {
            return ExceptionUtils.toResponse((String)"pathDoesNotBelongToRepository", (Map)new HashMap<String, String>(){
                {
                    this.put("path", path);
                }
            }, (Response.Status)Response.Status.FORBIDDEN);
        }
        if (!Files.exists(parentPath, new LinkOption[0])) {
            return ExceptionUtils.toResponse((String)"pathDoesNotExist", (Map)new HashMap<String, String>(){
                {
                    this.put("path", path);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (!Files.isDirectory(parentPath, new LinkOption[0])) {
            return ExceptionUtils.toResponse((String)"pathIsNotADirectory", (Map)new HashMap<String, String>(){
                {
                    this.put("path", path);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        HashSet<String> fileExtensions = new HashSet<String>();
        if (allowedFileExtensions != null && allowedFileExtensions.trim().length() > 0) {
            fileExtensions.addAll(Arrays.asList(allowedFileExtensions.split(";")));
        }
        ArrayList<DataRepositoryFile> files = new ArrayList<DataRepositoryFile>();
        Lock userSessionLock = this.getUserSessionLock(user);
        if (userSessionLock.tryLock()) {
            try {
                DataRepositoryFile fileAggregate = new DataRepositoryFile();
                fileAggregate.setAggregate(true);
                try (Stream<Path> dirStream = Files.list(parentPath);){
                    List dirPaths = dirStream.sorted(Comparator.comparing(p -> !Files.isDirectory(p, new LinkOption[0]))).collect(Collectors.toList());
                    for (Path childPath : dirPaths) {
                        try {
                            if (Files.isDirectory(childPath, new LinkOption[0])) {
                                DataRepositoryFile file = new DataRepositoryFile(childPath);
                                files.add(file);
                                continue;
                            }
                            if (includeFiles) {
                                boolean passesFilter = true;
                                if (fileExtensions.size() > 0) {
                                    String extension = FileUtils.getFileExtension((String)childPath.getFileName().toString());
                                    passesFilter = fileExtensions.contains(extension);
                                }
                                if (!passesFilter) continue;
                                DataRepositoryFile file = new DataRepositoryFile(childPath);
                                files.add(file);
                                continue;
                            }
                            BasicFileAttributes attr = Files.readAttributes(childPath, BasicFileAttributes.class, new LinkOption[0]);
                            if (!attr.isRegularFile() || attr.isSymbolicLink() || attr.isOther()) continue;
                            fileAggregate.addFile(attr);
                        }
                        catch (IOException e) {
                            LOGGER.error("Failed to read file: " + String.valueOf(childPath), (Throwable)e);
                        }
                    }
                }
                files.sort(Comparator.comparing(DataRepositoryFile::getDirectory, Comparator.reverseOrder()).thenComparing(DataRepositoryFile::getName, String.CASE_INSENSITIVE_ORDER));
                if (!includeFiles && fileAggregate.getFileCount() > 0) {
                    fileAggregate.generateName();
                    files.add(0, fileAggregate);
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not get files for path: " + path, (Throwable)e);
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("exception", ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true));
                Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("errorGettingFilesForPath", values)).build();
                return response;
            }
            finally {
                userSessionLock.unlock();
            }
        }
        return Response.status((Response.Status)Response.Status.OK).entity(files).build();
    }

    @Operation(tags={"Resources"}, operationId="GetStreamingDataRepositoryFiles", summary="Get Streaming Data Repository Files", description="Get the data repository files. If the path is not set, the root of the data repository will be used. Only use this method to receive streaming results. Alternatively, use the ListDataRepositoryFiles method.", responses={@ApiResponse(description="The list of files", content={@Content(array=@ArraySchema(schema=@Schema(implementation=DataRepositoryFile.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @jakarta.ws.rs.Path(value="/{dataRepositoryId}/files")
    @Produces(value={"application/octet-stream"})
    @GET
    public Response getDataRepositoryFiles(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @PathParam(value="dataRepositoryId") String dataRepositoryId, final @QueryParam(value="path") String path, @QueryParam(value="includeFiles") boolean includeFiles, @QueryParam(value="allowedFileExtensions") String allowedFileExtensions) {
        Path parentPath;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        DataRepository dataRepository = this.dataRepositories.get(dataRepositoryId);
        if (dataRepository == null) {
            return ExceptionUtils.toResponse((String)"cannotFindDataRepository", (Map)new HashMap<String, String>(){
                {
                    this.put("dataRepositoryId", dataRepositoryId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        if (!dataRepository.getType().equals((Object)DatasetType.IN_PLACE)) {
            LOGGER.error("Could not get files for dataRepository: " + dataRepositoryId + " path: " + path + " because dataRepository is of type " + String.valueOf(dataRepository.getType()));
            return ExceptionUtils.buildForbiddenResponse();
        }
        Set dataRepositoryPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, dataRepository).getUserPermissions();
        if (!dataRepositoryPermissions.contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)dataRepositoryId);
            return ExceptionUtils.buildForbiddenResponse();
        }
        Path dataRepositoryPath = Paths.get(dataRepository.getPath(), new String[0]);
        if (path == null || path.trim().length() == 0) {
            parentPath = dataRepositoryPath;
        } else {
            try {
                parentPath = Paths.get(path, new String[0]).normalize().toAbsolutePath();
            }
            catch (RuntimeException e) {
                LOGGER.error("Could not get files for dataRepository: " + dataRepositoryId + " path: " + path, (Throwable)e);
                return ExceptionUtils.toResponse((String)"errorScanningDataRepository", (Exception)e);
            }
        }
        if (!parentPath.startsWith(dataRepositoryPath)) {
            return ExceptionUtils.toResponse((String)"pathDoesNotBelongToRepository", (Map)new HashMap<String, String>(){
                {
                    this.put("path", path);
                }
            }, (Response.Status)Response.Status.FORBIDDEN);
        }
        if (!Files.exists(parentPath, new LinkOption[0])) {
            return ExceptionUtils.toResponse((String)"pathDoesNotExist", (Map)new HashMap<String, String>(){
                {
                    this.put("path", path);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (!Files.isDirectory(parentPath, new LinkOption[0])) {
            return ExceptionUtils.toResponse((String)"pathIsNotADirectory", (Map)new HashMap<String, String>(){
                {
                    this.put("path", path);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        HashSet<String> fileExtensions = new HashSet<String>();
        if (allowedFileExtensions != null && allowedFileExtensions.trim().length() > 0) {
            fileExtensions.addAll(Arrays.asList(allowedFileExtensions.split(";")));
        }
        StreamingOutput streamingOutput = outputStream -> {
            Lock userSessionLock = this.getUserSessionLock(user);
            ReentrantLock writeLock = new ReentrantLock();
            ScheduledFuture<?> streamWriteCheckFuture = null;
            AtomicBoolean streamEncounteredException = new AtomicBoolean(false);
            Consumer<String> outputStreamWrite = output -> {
                try {
                    writeLock.lock();
                    outputStream.write(output.getBytes(StandardCharsets.UTF_8));
                    outputStream.flush();
                }
                catch (Exception e) {
                    LOGGER.error("Error writing to outputStream", (Throwable)e);
                    streamEncounteredException.set(true);
                }
                finally {
                    writeLock.unlock();
                }
            };
            try {
                userSessionLock.lock();
                ArrayList<DataRepositoryFile> files = new ArrayList<DataRepositoryFile>();
                streamWriteCheckFuture = this.schedulerApplication.getScheduledExecutorService().scheduleAtFixedRate(() -> outputStreamWrite.accept(" "), 0L, 1000L, TimeUnit.MILLISECONDS);
                DataRepositoryFile fileAggregate = new DataRepositoryFile();
                fileAggregate.setAggregate(true);
                try (Stream<Path> dirStream = Files.list(parentPath);){
                    List dirPaths = dirStream.sorted(Comparator.comparing(p -> !Files.isDirectory(p, new LinkOption[0]))).collect(Collectors.toList());
                    for (Path childPath : dirPaths) {
                        if (streamEncounteredException.get()) {
                            break;
                        }
                        try {
                            if (Files.isDirectory(childPath, new LinkOption[0])) {
                                DataRepositoryFile file = new DataRepositoryFile(childPath);
                                files.add(file);
                                continue;
                            }
                            if (includeFiles) {
                                boolean passesFilter = true;
                                if (fileExtensions.size() > 0) {
                                    String extension = FileUtils.getFileExtension((String)childPath.getFileName().toString());
                                    passesFilter = fileExtensions.contains(extension);
                                }
                                if (!passesFilter) continue;
                                DataRepositoryFile file = new DataRepositoryFile(childPath);
                                files.add(file);
                                continue;
                            }
                            BasicFileAttributes attr = Files.readAttributes(childPath, BasicFileAttributes.class, new LinkOption[0]);
                            if (!attr.isRegularFile() || attr.isSymbolicLink() || attr.isOther()) continue;
                            fileAggregate.addFile(attr);
                        }
                        catch (IOException e) {
                            LOGGER.error("Failed to read file: " + String.valueOf(childPath), (Throwable)e);
                        }
                    }
                }
                if (!streamEncounteredException.get()) {
                    files.sort(Comparator.comparing(DataRepositoryFile::getDirectory, Comparator.reverseOrder()).thenComparing(DataRepositoryFile::getName, String.CASE_INSENSITIVE_ORDER));
                    if (!includeFiles && fileAggregate.getFileCount() > 0) {
                        fileAggregate.generateName();
                        files.add(0, fileAggregate);
                    }
                    outputStreamWrite.accept(SerializationUtils.toJson(files));
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not get files for path: " + path, (Throwable)e);
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("exception", ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true));
                outputStreamWrite.accept(SerializationUtils.toJson((Object)new TranslationResponseStatus("errorGettingFilesForPath", values)));
            }
            finally {
                if (streamWriteCheckFuture != null) {
                    streamWriteCheckFuture.cancel(true);
                }
                userSessionLock.unlock();
            }
        };
        return Response.status((Response.Status)Response.Status.OK).entity((Object)streamingOutput).build();
    }

    @SecurityRequirement(name="Bearer_Token")
    @jakarta.ws.rs.Path(value="/{dataRepositoryId}/fileSize")
    @Produces(value={"application/octet-stream"})
    @GET
    public Response getDataRepositoryFileSize(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(hidden=true) @Context HttpServletResponse response, final @PathParam(value="dataRepositoryId") String dataRepositoryId, @QueryParam(value="path") String path) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        DataRepository dataRepository = this.dataRepositories.get(dataRepositoryId);
        if (dataRepository == null) {
            return ExceptionUtils.toResponse((String)"cannotFindDataRepository", (Map)new HashMap<String, String>(){
                {
                    this.put("dataRepositoryId", dataRepositoryId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Set dataRepositoryPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, dataRepository).getUserPermissions();
        if (!dataRepositoryPermissions.contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)dataRepositoryId);
            return ExceptionUtils.buildForbiddenResponse();
        }
        if (path == null || path.trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"pathMissing", (Response.Status)Response.Status.BAD_REQUEST);
        }
        Path dataRepositoryPath = Paths.get(dataRepository.getPath(), new String[0]);
        final Path filePath = Paths.get(path, new String[0]).normalize().toAbsolutePath();
        if (!filePath.startsWith(dataRepositoryPath)) {
            return ExceptionUtils.toResponse((String)"pathDoesNotBelongToRepository", (Response.Status)Response.Status.FORBIDDEN);
        }
        StreamingOutput streamingOutput = outputStream -> {
            Lock userSessionLock = this.getUserSessionLock(user);
            ReentrantLock writeLock = new ReentrantLock();
            ScheduledFuture<?> streamWriteCheckFuture = null;
            final AtomicBoolean streamEncounteredException = new AtomicBoolean(false);
            Consumer<String> outputStreamWrite = output -> {
                try {
                    writeLock.lock();
                    outputStream.write(output.getBytes(StandardCharsets.UTF_8));
                    outputStream.flush();
                }
                catch (Exception e) {
                    LOGGER.error("Error writing to outputStream", (Throwable)e);
                    streamEncounteredException.set(true);
                }
                finally {
                    writeLock.unlock();
                }
            };
            try {
                userSessionLock.lock();
                final FileSize fileSizeSum = new FileSize();
                streamWriteCheckFuture = this.schedulerApplication.getScheduledExecutorService().scheduleAtFixedRate(() -> outputStreamWrite.accept(" "), 0L, 1000L, TimeUnit.MILLISECONDS);
                Files.walkFileTree(filePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        if (attrs.isSymbolicLink() || attrs.isOther()) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        return super.preVisitDirectory(dir, attrs);
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (streamEncounteredException.get()) {
                            return FileVisitResult.TERMINATE;
                        }
                        fileSizeSum.add(attrs.size());
                        return super.visitFile(file, attrs);
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        if (file.equals(filePath)) {
                            fileSizeSum.setError(true);
                            return FileVisitResult.TERMINATE;
                        }
                        if (!(exc instanceof AccessDeniedException)) {
                            LOGGER.error("Exception getting file size for path: " + String.valueOf(file), (Throwable)exc);
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                });
                if (!streamEncounteredException.get()) {
                    outputStreamWrite.accept(SerializationUtils.toJson((Object)fileSizeSum));
                }
            }
            catch (Exception e) {
                LOGGER.error("Could not get file size for path: " + path, (Throwable)e);
                HashMap<String, String> values = new HashMap<String, String>();
                values.put("exception", ExceptionUtils.getExceptionPrintableMessage((Throwable)e, (boolean)true));
                outputStreamWrite.accept(SerializationUtils.toJson((Object)new TranslationResponseStatus("errorGettingFileSizeForPath", values)));
            }
            finally {
                if (streamWriteCheckFuture != null) {
                    streamWriteCheckFuture.cancel(true);
                }
                userSessionLock.unlock();
            }
        };
        return Response.status((Response.Status)Response.Status.OK).entity((Object)streamingOutput).build();
    }

    @Operation(tags={"Resources"}, operationId="GetAzureStorageAccountContainers", summary="Get Azure Storage Account Containers", description="Get the azure storage account containers", responses={@ApiResponse(description="The list of data file notes in the repository", content={@Content(array=@ArraySchema(schema=@Schema(implementation=FileNode.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @jakarta.ws.rs.Path(value="/{dataRepositoryId}/azureStorageAccountContainers")
    @GET
    public Response getAzureStorageAccountContainers(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @PathParam(value="dataRepositoryId") String dataRepositoryId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        DataRepository dataRepository = this.dataRepositories.get(dataRepositoryId);
        if (dataRepository == null) {
            return ExceptionUtils.toResponse((String)"cannotFindDataRepository", (Map)new HashMap<String, String>(){
                {
                    this.put("dataRepositoryId", dataRepositoryId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        DataRepository permissionedDataRepository = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, dataRepository);
        Set dataRepositoryPermissions = permissionedDataRepository.getUserPermissions();
        if (!dataRepositoryPermissions.contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)dataRepositoryId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        if (dataRepositoryPermissions.contains(Permission.VIEW_LIMITED)) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(new ArrayList()).build();
        }
        try {
            AzureStorageAccount azureStorageAccount = dataRepository.getAzureStorageAccount();
            BlobServiceClient blobServiceClient = this.azureStorageAccountUtils.getBlobServiceClient(azureStorageAccount);
            List blobContainers = blobServiceClient.listBlobContainers().stream().collect(Collectors.toList());
            if (dataRepository.getStatus().getCode() == State.ERROR) {
                dataRepository.getStatus().reset();
                ResponseCache.getInstance().resetKeyId(CacheKey.DATA_REPOSITORY, dataRepositoryId);
                ResponseCache.getInstance().resetKeyId(CacheKey.DATA_REPOSITORIES, "");
            }
            SortingUtils.sortList(blobContainers, BlobContainerItem::getName);
            String lastHash = ResponseCache.getInstance().hashObject(blobContainers);
            try {
                return ResponseCache.getInstance().getResponse(lastHash, request);
            }
            catch (CacheException cacheException) {
                return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(blobContainers).build();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to get Azure storage account containers for: " + dataRepository.getName(), (Throwable)e);
            dataRepository.getStatus().setError(this.iu.getFormattedString("DataRepositoryResource.ErrorAccessingAzureStorageAccount", (Object)e));
            ResponseCache.getInstance().resetKeyId(CacheKey.DATA_REPOSITORY, dataRepositoryId);
            ResponseCache.getInstance().resetKeyId(CacheKey.DATA_REPOSITORIES, "");
            return ExceptionUtils.toResponse((String)"errorGettingAzureStorageAccountContainers", (Map)new HashMap<String, String>(){
                {
                    this.put("exception", ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                }
            });
        }
    }

    @Operation(tags={"Resources"}, operationId="GetDataRepositoryFileTree", summary="Get Data Repository File Tree", description="Get the data repository file tree", responses={@ApiResponse(description="The list of data file notes in the repository", content={@Content(array=@ArraySchema(schema=@Schema(implementation=FileNode.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @jakarta.ws.rs.Path(value="/{dataRepositoryId}/fileTree")
    @GET
    public Response getDataRepositoryFileTree(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @PathParam(value="dataRepositoryId") String dataRepositoryId, @QueryParam(value="viewPaths") boolean viewPaths) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        DataRepository dataRepository = this.dataRepositories.get(dataRepositoryId);
        if (dataRepository == null) {
            return ExceptionUtils.toResponse((String)"cannotFindDataRepository", (Map)new HashMap<String, String>(){
                {
                    this.put("dataRepositoryId", dataRepositoryId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Set dataRepositoryPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, dataRepository).getUserPermissions();
        if (!dataRepositoryPermissions.contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)dataRepositoryId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        ArrayList<FileNode> clientNodes = new ArrayList<FileNode>();
        ArrayList<Client> clients = new ArrayList<Client>(this.schedulerApplication.getClientResource().getClients());
        clients.sort(Comparator.comparing(Client::getName, String.CASE_INSENSITIVE_ORDER));
        boolean addNonViewableClient = false;
        for (Client client : clients) {
            Path clientPath;
            HashSet<DatasetPathFormat> clientDatasetPathFormats = new HashSet<DatasetPathFormat>();
            ArrayList<Matter> matters = new ArrayList<Matter>(this.schedulerApplication.getClientResource().getClientMatters(client.getId()));
            matters.sort(Comparator.comparing(Matter::getName, String.CASE_INSENSITIVE_ORDER));
            Set clientPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, client).getUserPermissions();
            if (!clientPermissions.contains(Permission.VIEW)) {
                boolean hasDatasets = matters.stream().anyMatch(matterModel -> this.schedulerApplication.getClientResource().getMatterDatasets(matterModel.getId()).stream().anyMatch(datasetModel -> !datasetModel.isExpired() && dataRepositoryId.equals(datasetModel.getDataRepositoryId())));
                if (!hasDatasets) continue;
                addNonViewableClient = true;
                continue;
            }
            FileNode clientNode = new FileNode(client.getName(), true);
            boolean addClientNode = false;
            long clientSize = 0L;
            long clientFileCount = 0L;
            boolean addNonViewableMatter = false;
            for (Matter matter : matters) {
                Path matterPath;
                HashSet<DatasetPathFormat> matterDatasetPathFormats = new HashSet<DatasetPathFormat>();
                List datasets = this.schedulerApplication.getClientResource().getMatterDatasets(matter.getId()).stream().filter(datasetModel -> !datasetModel.isExpired() && dataRepositoryId.equals(datasetModel.getDataRepositoryId())).sorted(Comparator.comparing(Dataset::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
                if (datasets.size() == 0) continue;
                addClientNode = true;
                Set matterPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter).getUserPermissions();
                if (!matterPermissions.contains(Permission.VIEW)) {
                    addNonViewableMatter = true;
                    continue;
                }
                FileNode matterNode = new FileNode(matter.getName(), true);
                clientNode.getChildren().add(matterNode);
                long matterSize = 0L;
                long matterFileCount = 0L;
                for (Dataset dataset : datasets) {
                    FileNode datasetNode = new FileNode(dataset.getName(), false);
                    matterNode.getChildren().add(datasetNode);
                    DatasetPathFormat pathFormat = dataset.getPathFormat();
                    if (pathFormat == null) {
                        pathFormat = DatasetPathFormat.IDS_FULL;
                    }
                    matterDatasetPathFormats.add(pathFormat);
                    clientDatasetPathFormats.add(pathFormat);
                    if (viewPaths) {
                        datasetNode.setPath(DatasetUtils.getDatasetUtils(this.schedulerApplication).getDatasetPath(dataset).toAbsolutePath().toString());
                    }
                    datasetNode.setSize(Long.valueOf(this.datasetUtils.getDatasetSize(dataset.getId())));
                    matterSize += datasetNode.getSize().longValue();
                    datasetNode.setFileCount(Long.valueOf(this.datasetUtils.getDatasetFilesCount(dataset.getId())));
                    matterFileCount += datasetNode.getFileCount().longValue();
                }
                if (viewPaths && matterDatasetPathFormats.size() == 1 && (matterPath = DatasetUtils.getDatasetUtils(this.schedulerApplication).getMatterPath(dataRepository, matter, (DatasetPathFormat)matterDatasetPathFormats.iterator().next())) != null) {
                    matterNode.setPath(matterPath.toAbsolutePath().toString());
                }
                matterNode.setSize(Long.valueOf(matterSize));
                clientSize += matterNode.getSize().longValue();
                matterNode.setFileCount(Long.valueOf(matterFileCount));
                clientFileCount += matterNode.getFileCount().longValue();
            }
            if (addNonViewableMatter) {
                clientNode.getChildren().add(new FileNode());
            }
            clientNode.setSize(Long.valueOf(clientSize));
            clientNode.setFileCount(Long.valueOf(clientFileCount));
            if (!addClientNode) continue;
            clientNodes.add(clientNode);
            if (!viewPaths || clientDatasetPathFormats.size() != 1 || (clientPath = DatasetUtils.getDatasetUtils(this.schedulerApplication).getClientPath(dataRepository, client, (DatasetPathFormat)clientDatasetPathFormats.iterator().next())) == null) continue;
            clientNode.setPath(clientPath.toAbsolutePath().toString());
        }
        if (addNonViewableClient) {
            clientNodes.add(new FileNode());
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(clientNodes).build();
    }

    @Operation(tags={"Resources", "Job Submission"}, operationId="ListDataRepositories", summary="List Data Repositories", description="List data repositories", responses={@ApiResponse(description="The list of data repositories", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConciseObject.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @jakarta.ws.rs.Path(value="/list")
    @GET
    public Response listDataRepositories(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.DATA_REPOSITORIES, "", this.schedulerApplication.getConfiguration().getDataRepositoryResponseCacheMaxValidity());
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ArrayList<DataRepository> allowedDataRepositories = new ArrayList<DataRepository>();
            for (DataRepository dataRepository : this.dataRepositories.values()) {
                DataRepository result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, dataRepository);
                if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                allowedDataRepositories.add(result);
            }
            SortingUtils.sortList(allowedDataRepositories, DataRepository::getName);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)ResponseUtils.getConciseList(allowedDataRepositories)).build();
        }
    }

    @Operation(tags={"Resources"}, operationId="GetDataRepositories", summary="Get Data Repositories", description="Get full information of all data repositories. Only use this method if the information returned by ListDataRepositories is not sufficient", responses={@ApiResponse(description="The list of data repositories", content={@Content(array=@ArraySchema(schema=@Schema(implementation=DataRepository.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getDataRepositories(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.DATA_REPOSITORIES, "", this.schedulerApplication.getConfiguration().getDataRepositoryResponseCacheMaxValidity());
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ArrayList<DataRepository> allowedDataRepositories = new ArrayList<DataRepository>();
            for (DataRepository dataRepository : this.dataRepositories.values()) {
                DataRepository result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, dataRepository);
                if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                allowedDataRepositories.add(result);
            }
            SortingUtils.sortList(allowedDataRepositories, DataRepository::getName);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedDataRepositories).build();
        }
    }

    @Operation(tags={"Resources"}, summary="Add a Data Repository", operationId="AddDataRepository", description="Add a new data repository", responses={@ApiResponse(description="The data repository that was added", content={@Content(schema=@Schema(implementation=DataRepository.class))}), @ApiResponse(responseCode="400", description="A data repository with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Consumes(value={"application/json"})
    public Response addDataRepository(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The data repository to add", schema=@Schema(implementation=DataRepositorySubmission.class)) DataRepository dataRepository) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.assertModuleLicensed(dataRepository.getType());
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_DATA_REPOSITORIES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)dataRepository);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        FormattingUtils.trimAllStrings((Object)dataRepository);
        if (dataRepository.getName() == null || dataRepository.getName().trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"errorAddingDataRepository", (Response.Status)Response.Status.BAD_REQUEST);
        }
        for (DataRepository existingDataRepository : this.dataRepositories.values()) {
            if (!existingDataRepository.getName().equals(dataRepository.getName())) continue;
            return ExceptionUtils.toResponse((String)"dataRepositoryNameExists", (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (dataRepository.getType() == DatasetType.MANAGED || dataRepository.getType() == DatasetType.IN_PLACE) {
            final String path = dataRepository.getPath();
            if (!FileUtils.isPathAbsolute((String)path)) {
                return ExceptionUtils.toResponse((String)"dataRepositoryInvalidPath", (Map)new HashMap<String, String>(){
                    {
                        this.put("path", path);
                    }
                });
            }
            final Long quota = dataRepository.getQuota();
            if (quota != null && quota < 0L) {
                return ExceptionUtils.toResponse((String)"dataRepositoryNegativeQuota", (Map)new HashMap<String, String>(){
                    {
                        this.put("quota", String.valueOf(quota));
                    }
                });
            }
            final Long datasetMaxSize = dataRepository.getDatasetMaxSize();
            if (datasetMaxSize != null && datasetMaxSize < 0L) {
                return ExceptionUtils.toResponse((String)"dataRepositoryNegativeDatasetMaxSize", (Map)new HashMap<String, String>(){
                    {
                        this.put("datasetMaxSize", String.valueOf(datasetMaxSize));
                    }
                });
            }
            final Long uploadMaxSize = dataRepository.getUploadMaxSize();
            if (uploadMaxSize != null && uploadMaxSize < 0L) {
                return ExceptionUtils.toResponse((String)"dataRepositoryNegativeUploadMaxSize", (Map)new HashMap<String, String>(){
                    {
                        this.put("uploadMaxSize", String.valueOf(uploadMaxSize));
                    }
                });
            }
            final Long autoExpireInterval = dataRepository.getDatasetAutoExpireInterval();
            if (autoExpireInterval != null && autoExpireInterval < 0L) {
                return ExceptionUtils.toResponse((String)"dataRepositoryNegativeAutoExpireInterval", (Map)new HashMap<String, String>(){
                    {
                        this.put("autoExpireInterval", String.valueOf(autoExpireInterval));
                    }
                });
            }
            Path repositoryPath = Paths.get(path, new String[0]).normalize();
            dataRepository.setPath(repositoryPath.toAbsolutePath().toString());
        }
        switch (dataRepository.getType()) {
            case MANAGED: {
                final Path repositoryPath = Paths.get(dataRepository.getPath(), new String[0]);
                try {
                    Files.createDirectories(repositoryPath, new FileAttribute[0]);
                    this.datasetUtils.verifyWritePermissions(repositoryPath);
                    break;
                }
                catch (FileAlreadyExistsException e) {
                    return ExceptionUtils.toResponse((String)"pathExistsAndIsNotADirectory", (Map)new HashMap<String, String>(){
                        {
                            this.put("path", repositoryPath.toString());
                        }
                    }, (Exception)e);
                }
                catch (InvalidPathException e) {
                    return ExceptionUtils.toResponse((String)"dataRepositoryInvalidPath", (Map)new HashMap<String, String>(){
                        {
                            this.put("path", repositoryPath.toString());
                        }
                    });
                }
                catch (IOException e) {
                    return ExceptionUtils.toResponse((String)"errorCreatingDataRepository", (Exception)e);
                }
            }
            case IN_PLACE: {
                final Path repositoryPath = Paths.get(dataRepository.getPath(), new String[0]);
                if (!Files.exists(repositoryPath, new LinkOption[0])) {
                    return ExceptionUtils.toResponse((String)"pathNotFound", (Map)new HashMap<String, String>(){
                        {
                            this.put("path", repositoryPath.toString());
                        }
                    });
                }
                dataRepository.setQuotaEnabled(Boolean.valueOf(false));
                dataRepository.setAllowedFileExtensions(null);
                break;
            }
            case AZURE_STORAGE_ACCOUNT: {
                try {
                    AzureStorageAccount azureStorageAccount = dataRepository.getAzureStorageAccount();
                    BlobServiceClient blobServiceClient = this.azureStorageAccountUtils.getBlobServiceClient(azureStorageAccount);
                    BlobServiceProperties properties = blobServiceClient.getProperties();
                    LOGGER.info("Connected to Azure storage account: " + azureStorageAccount.getAccountUrl());
                    break;
                }
                catch (Exception e) {
                    return ExceptionUtils.toResponse((String)"errorAccessingAzureStorageAccount", (Map)new HashMap<String, String>(){
                        {
                            this.put("exception", ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                        }
                    });
                }
            }
        }
        try {
            dataRepository.setUsableSpace(this.datasetUtils.getRepositoryUsableSpace(dataRepository));
        }
        catch (IOException e) {
            return ExceptionUtils.toResponse((String)"errorCreatingDataRepository", (Exception)e);
        }
        dataRepository.setId(UidUtils.getRandom());
        dataRepository.setDefaults();
        this.schedulerApplication.getSchedulerConfigurationDao().addDataRepository(dataRepository);
        this.dataRepositories.put(dataRepository.getId(), dataRepository);
        DataRepository eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, dataRepository);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_REPOSITORY_ADDED, eventResult, user.getName());
        ResponseCache.getInstance().resetKeyId(CacheKey.DATA_REPOSITORIES, "");
        this.trackDataRepositoryUtilization(dataRepository);
        DataRepository result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, dataRepository);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Resources"}, operationId="UpdateDataRepository", summary="Update Data Repository", description="Update the data repository with the specified ID", responses={@ApiResponse(description="The updated data repository", content={@Content(schema=@Schema(implementation=DataRepository.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @jakarta.ws.rs.Path(value="/{dataRepositoryId}")
    @PUT
    public Response updateDataRepository(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The ID of the data repository to update") @PathParam(value="dataRepositoryId") String dataRepositoryId, @Parameter(description="The information to update the data repository with", schema=@Schema(implementation=DataRepositorySubmission.class)) DataRepository dataRepository) {
        Long quota;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        DataRepository originalDataRepository = this.dataRepositories.get(dataRepositoryId);
        if (originalDataRepository == null) {
            return ExceptionUtils.toResponse((String)"cannotFindDataRepository", (Map)new HashMap<String, String>(){
                {
                    this.put("dataRepositoryId", dataRepositoryId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        this.assertModuleLicensed(originalDataRepository.getType());
        Set dataRepositoryPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalDataRepository).getUserPermissions();
        if (!dataRepositoryPermissions.contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)dataRepositoryId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        FormattingUtils.trimAllStrings((Object)dataRepository);
        String name = dataRepository.getName();
        if (name != null && name.trim().length() > 0) {
            name = name.trim();
            for (DataRepository existingDataRepository : this.dataRepositories.values()) {
                if (existingDataRepository.getId().equals(dataRepositoryId) || !existingDataRepository.getName().equals(name)) continue;
                return ExceptionUtils.toResponse((String)"dataRepositoryNameExists", (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        if ((quota = dataRepository.getQuota()) != null && quota < 0L) {
            return ExceptionUtils.toResponse((String)"dataRepositoryNegativeQuota", (Map)new HashMap<String, String>(){
                {
                    this.put("quota", String.valueOf(quota));
                }
            });
        }
        final Long datasetMaxSize = dataRepository.getDatasetMaxSize();
        if (datasetMaxSize != null && datasetMaxSize < 0L) {
            return ExceptionUtils.toResponse((String)"dataRepositoryNegativeDatasetMaxSize", (Map)new HashMap<String, String>(){
                {
                    this.put("datasetMaxSize", String.valueOf(datasetMaxSize));
                }
            });
        }
        final Long uploadMaxSize = dataRepository.getUploadMaxSize();
        if (uploadMaxSize != null && uploadMaxSize < 0L) {
            return ExceptionUtils.toResponse((String)"dataRepositoryNegativeUploadMaxSize", (Map)new HashMap<String, String>(){
                {
                    this.put("uploadMaxSize", String.valueOf(uploadMaxSize));
                }
            });
        }
        final Long autoExpireInterval = dataRepository.getDatasetAutoExpireInterval();
        if (autoExpireInterval != null && autoExpireInterval < 0L) {
            return ExceptionUtils.toResponse((String)"dataRepositoryNegativeAutoExpireInterval", (Map)new HashMap<String, String>(){
                {
                    this.put("autoExpireInterval", String.valueOf(autoExpireInterval));
                }
            });
        }
        AzureStorageAccount azureStorageAccount = dataRepository.getAzureStorageAccount();
        AzureStorageAccount originalAzureStorageAccount = originalDataRepository.getAzureStorageAccount();
        if (!(originalDataRepository.getType() != DatasetType.AZURE_STORAGE_ACCOUNT || azureStorageAccount == null || originalAzureStorageAccount != null && originalAzureStorageAccount.equals((Object)azureStorageAccount))) {
            if (azureStorageAccount.getAccountKey() == null) {
                return ExceptionUtils.toResponse((String)"missingAzureStorageAccountKey", (Response.Status)Response.Status.BAD_REQUEST);
            }
            try {
                BlobServiceClient blobServiceClient = this.azureStorageAccountUtils.getBlobServiceClient(azureStorageAccount);
                BlobServiceProperties properties = blobServiceClient.getProperties();
                LOGGER.info("Connected to Azure storage account: " + azureStorageAccount.getAccountUrl());
                if (originalDataRepository.getStatus().getCode() == State.ERROR) {
                    originalDataRepository.getStatus().reset();
                }
            }
            catch (Exception e) {
                dataRepository.getStatus().setError(this.iu.getFormattedString("DataRepositoryResource.ErrorAccessingAzureStorageAccount", (Object)e));
                ResponseCache.getInstance().resetKeyId(CacheKey.DATA_REPOSITORY, dataRepositoryId);
                ResponseCache.getInstance().resetKeyId(CacheKey.DATA_REPOSITORIES, "");
                return ExceptionUtils.toResponse((String)"errorAccessingAzureStorageAccount", (Map)new HashMap<String, String>(){
                    {
                        this.put("exception", ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                    }
                });
            }
            originalDataRepository.setAzureStorageAccount(azureStorageAccount);
        }
        if (name != null) {
            originalDataRepository.setName(name);
        }
        if (dataRepository.getDescription() != null) {
            originalDataRepository.setDescription(dataRepository.getDescription());
        }
        if (dataRepository.getType() == DatasetType.MANAGED || dataRepository.getType() == DatasetType.IN_PLACE) {
            Set allowedFileExtensions;
            if (dataRepository.getQuotaEnabled() != null) {
                originalDataRepository.setQuotaEnabled(dataRepository.getQuotaEnabled());
            }
            if (quota != null) {
                originalDataRepository.setQuota(quota);
            }
            boolean recalculateDatasetUsableSpace = false;
            if (dataRepository.getDatasetMaxSizeEnabled() != null) {
                originalDataRepository.setDatasetMaxSizeEnabled(dataRepository.getDatasetMaxSizeEnabled());
                recalculateDatasetUsableSpace = true;
            }
            if (datasetMaxSize != null) {
                originalDataRepository.setDatasetMaxSize(datasetMaxSize);
                recalculateDatasetUsableSpace = true;
            }
            if (dataRepository.getUploadMaxSizeEnabled() != null) {
                originalDataRepository.setUploadMaxSizeEnabled(dataRepository.getUploadMaxSizeEnabled());
            }
            if (uploadMaxSize != null) {
                originalDataRepository.setUploadMaxSize(uploadMaxSize);
            }
            if (dataRepository.getComputeFileSystemUsableSpace() != null) {
                originalDataRepository.setComputeFileSystemUsableSpace(dataRepository.getComputeFileSystemUsableSpace());
            }
            if (dataRepository.getDatasetAutoHide() != null) {
                originalDataRepository.setDatasetAutoHide(dataRepository.getDatasetAutoHide());
            }
            if (dataRepository.getDatasetAutoArchive() != null) {
                originalDataRepository.setDatasetAutoArchive(dataRepository.getDatasetAutoArchive());
            }
            if (dataRepository.getDatasetAutoArchiveJobError() != null) {
                originalDataRepository.setDatasetAutoArchiveJobError(dataRepository.getDatasetAutoArchiveJobError());
            }
            if (dataRepository.getDatasetAutoArchiveJobSoftError() != null) {
                originalDataRepository.setDatasetAutoArchiveJobSoftError(dataRepository.getDatasetAutoArchiveJobSoftError());
            }
            if (dataRepository.getDatasetAutoArchiveJobWarning() != null) {
                originalDataRepository.setDatasetAutoArchiveJobWarning(dataRepository.getDatasetAutoArchiveJobWarning());
            }
            if ((allowedFileExtensions = dataRepository.getAllowedFileExtensions()) != null) {
                HashSet<String> normalizedFileExtensions = new HashSet<String>();
                for (String fileExtension : allowedFileExtensions) {
                    String normalizedExtension = this.normalizeFileExtension(fileExtension);
                    if (normalizedExtension.length() <= 0) continue;
                    normalizedFileExtensions.add(normalizedExtension);
                }
                originalDataRepository.setAllowedFileExtensions(normalizedFileExtensions);
            }
            originalDataRepository.setDatasetAutoExpireInterval(autoExpireInterval);
            if (originalDataRepository.getType() == DatasetType.IN_PLACE) {
                originalDataRepository.setQuotaEnabled(Boolean.valueOf(false));
                originalDataRepository.setAllowedFileExtensions(null);
            }
            this.updateUsableSpace(originalDataRepository);
            if (recalculateDatasetUsableSpace) {
                HashSet<String> matterIds = new HashSet<String>();
                for (Dataset dataset : this.schedulerApplication.getDatasetResource().getDatasets()) {
                    if (!dataRepositoryId.equals(dataset.getDataRepositoryId())) continue;
                    dataset.setUsableSpace(this.datasetUtils.getDatasetUsableSpace(dataset));
                    matterIds.add(dataset.getMatterId());
                }
                for (String matterId : matterIds) {
                    ResponseCache.getInstance().resetKeyId(CacheKey.MATTER_DATASETS, matterId);
                }
            }
        }
        this.schedulerApplication.getSchedulerConfigurationDao().updateDataRepository(originalDataRepository);
        this.trackDataRepositoryUtilization(originalDataRepository);
        DataRepository eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalDataRepository);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_REPOSITORY_MODIFIED, eventResult, user.getName());
        ResponseCache.getInstance().resetKeyId(CacheKey.DATA_REPOSITORY, dataRepositoryId);
        ResponseCache.getInstance().resetKeyId(CacheKey.DATA_REPOSITORIES, "");
        DataRepository result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalDataRepository);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    private String normalizeFileExtension(String fileExtension) {
        String normalizedFileExtension = fileExtension.trim().toLowerCase();
        if (normalizedFileExtension.startsWith("*.")) {
            return normalizedFileExtension.substring(2);
        }
        if (normalizedFileExtension.startsWith(".")) {
            return normalizedFileExtension.substring(1);
        }
        return normalizedFileExtension;
    }

    @Operation(tags={"Resources"}, operationId="DeleteDataRepository", summary="Delete Data Repository", description="Delete the data repository with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="404", description="Cannot find data repository with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @jakarta.ws.rs.Path(value="/{dataRepositoryId}")
    @DELETE
    public Response deleteDataRepository(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The ID of the data repository to delete") @PathParam(value="dataRepositoryId") String dataRepositoryId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        DataRepository dataRepository = this.getDataRepository(dataRepositoryId);
        if (dataRepository == null) {
            return ExceptionUtils.toResponse((String)"cannotFindDataRepository", (Map)new HashMap<String, String>(){
                {
                    this.put("dataRepositoryId", dataRepositoryId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Set dataRepositoryPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, dataRepository).getUserPermissions();
        if (!dataRepositoryPermissions.contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)dataRepositoryId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        boolean doesRepositoryHaveDatasets = this.schedulerApplication.getDatasetResource().getDatasets().stream().anyMatch(dataset -> !dataset.isDeleted() && !dataset.isExpired() && dataRepositoryId.equals(dataset.getDataRepositoryId()));
        if (doesRepositoryHaveDatasets) {
            if (dataRepository.getType() == DatasetType.MANAGED) {
                return ExceptionUtils.toResponse((String)"cannotDeleteManagedDataRepositoryUsedInDataset", (Response.Status)Response.Status.BAD_REQUEST);
            }
            return ExceptionUtils.toResponse((String)"cannotDeleteDataRepositoryUsedInDataset", (Response.Status)Response.Status.BAD_REQUEST);
        }
        boolean isRepositoryUsedInLegalHolds = this.schedulerApplication.getLegalHoldResource().getLegalHolds().stream().anyMatch(legalHold -> dataRepositoryId.equals(legalHold.getDataRepositoryId()) && LegalHold.editableStates.contains(legalHold.getState()));
        if (isRepositoryUsedInLegalHolds) {
            return ExceptionUtils.toResponse((String)"cannotDeleteDataRepositoryUsedInLegalHolds", (Response.Status)Response.Status.BAD_REQUEST);
        }
        try {
            this.verifyNotUsedInJobs(user, dataRepositoryId);
        }
        catch (ResponseException e) {
            return e.getResponse();
        }
        this.schedulerApplication.getSchedulerConfigurationDao().deleteDataRepository(dataRepositoryId);
        this.dataRepositories.remove(dataRepositoryId);
        DataRepository eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, dataRepository);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_REPOSITORY_DELETED, eventResult, user.getName());
        ResponseCache.getInstance().resetKeyId(CacheKey.DATA_REPOSITORY, dataRepositoryId);
        ResponseCache.getInstance().resetKeyId(CacheKey.DATA_REPOSITORIES, "");
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("dataRepositoryDeleted")).build();
    }

    private void verifyNotUsedInJobs(BearerUser user, String dataRepositoryId) throws ResponseException {
        Set<String> jobNames = this.getNamesOfJobsUsingDataRepository(user, dataRepositoryId);
        if (jobNames.isEmpty()) {
            return;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("jobNames", String.join((CharSequence)", ", jobNames));
        String errorResponseKey = jobNames.size() == 1 ? "errorDeletingDataRepositoryUsedByJob" : "errorDeletingDataRepositoryUsedByJobs";
        throw new ResponseException(ExceptionUtils.toResponse((String)errorResponseKey, properties));
    }

    private Set<String> getNamesOfJobsUsingDataRepository(BearerUser user, String dataRepositoryId) {
        TreeSet<String> jobNames = new TreeSet<String>();
        ArrayList<JobDetailsModel> nonFinishedJobs = new ArrayList<JobDetailsModel>();
        for (JobDetailsModel jobDetailsModel : this.schedulerApplication.getJobResource().getNonFinishedJobs()) {
            for (com.nuix.automate.utils.models.api.job.Parameter sessionParameter : jobDetailsModel.getSettings().getSessionParameters()) {
                String parameterDataRepositoryId = null;
                if (sessionParameter.isAzureStorageAccount()) {
                    parameterDataRepositoryId = sessionParameter.getValue();
                }
                if (sessionParameter.isServerFile() || sessionParameter.isServerFolder()) {
                    parameterDataRepositoryId = sessionParameter.getDataRepositoryId();
                }
                if (!dataRepositoryId.equals(parameterDataRepositoryId)) continue;
                nonFinishedJobs.add(jobDetailsModel);
            }
        }
        if (nonFinishedJobs.isEmpty()) {
            return jobNames;
        }
        if (user == null) {
            jobNames.add(this.iu.getString("Job.Name.Other"));
        } else {
            for (JobDetailsModel jobDetailsModel : nonFinishedJobs) {
                JobModel jobModel = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissionsInternal(user, jobDetailsModel.getSettings());
                if (jobModel.getUserPermissions().contains(Permission.VIEW)) {
                    jobNames.add(jobModel.getName());
                    continue;
                }
                jobNames.add(this.iu.getString("Job.Name.Other"));
            }
        }
        return jobNames;
    }

    private synchronized Lock getUserSessionLock(BearerUser user) {
        if (user.getSessionId() != null) {
            return this.getUserSessionLock(user.getSessionId());
        }
        return this.getUserSessionLock(user.getId());
    }

    private synchronized Lock getUserSessionLock(String sessionId) {
        Lock lock = (Lock)this.userSessionLocks.get(sessionId);
        if (lock == null) {
            lock = new ReentrantLock();
            this.userSessionLocks.put(sessionId, (Object)lock);
        }
        return lock;
    }

    private void assertModuleLicensed(DatasetType datasetType) {
        switch (datasetType) {
            case AZURE_STORAGE_ACCOUNT: {
                this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.AZURE_STORAGE);
            }
            case MANAGED: {
                this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.MANAGED_DATA_REPOSITORIES);
            }
            case IN_PLACE: {
                this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.IN_PLACE_DATA_REPOSITORIES);
            }
        }
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_UPLOAD);
    }

    private static final class FileSize {
        long size;
        boolean error;

        private FileSize() {
        }

        void add(long size) {
            this.size += size;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public boolean getError() {
            return this.error;
        }

        public void setError(boolean error) {
            this.error = error;
        }
    }
}

