/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import com.nuix.automate.dropwizard.utils.security.bearer.ApiBearerUser;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.persistance.utilization.UtilizationDao;
import com.nuix.automate.scheduler.security.bearer.SystemBearerUser;
import com.nuix.automate.scheduler.tus.TusFileUploadService;
import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.models.UploadInfoModel;
import com.nuix.automate.scheduler.tus.upload.UploadId;
import com.nuix.automate.scheduler.tus.upload.UploadInfo;
import com.nuix.automate.scheduler.tus.upload.scheduler.SchedulerStorageService;
import com.nuix.automate.scheduler.tus.utils.Utils;
import com.nuix.automate.scheduler.utils.DatasetUtils;
import com.nuix.automate.scheduler.utils.FileInfoCache;
import com.nuix.automate.scheduler.utils.FileNameUtils;
import com.nuix.automate.utils.api.internal.automatelicense.AutomateLicenceModel;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.exceptions.AuthenticationResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileTraversalException;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.InterruptibleCharSequence;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.client.Matter;
import com.nuix.automate.utils.models.api.dataset.DataRepository;
import com.nuix.automate.utils.models.api.dataset.Dataset;
import com.nuix.automate.utils.models.api.dataset.DatasetCommand;
import com.nuix.automate.utils.models.api.dataset.DatasetState;
import com.nuix.automate.utils.models.api.dataset.DatasetSubmission;
import com.nuix.automate.utils.models.api.dataset.DatasetType;
import com.nuix.automate.utils.models.api.dataset.FileInfo;
import com.nuix.automate.utils.models.api.dataset.FileUploadFilter;
import com.nuix.automate.utils.models.api.dataset.FileUploadHistory;
import com.nuix.automate.utils.models.api.notice.NoticeEvent;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.internal.dataset.DatasetEvent;
import com.nuix.automate.utils.models.internal.dataset.UploadInfoState;
import com.nuix.automate.utils.models.internal.dataset.UsableSpace;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.utilization.ActivityDetails;
import com.nuix.automate.utils.utilization.ActivityType;
import com.nuix.automate.utils.utilization.DataSet;
import com.nuix.automate.utils.utilization.DataSetType;
import com.nuix.automate.utils.utilization.Transfer;
import com.nuix.automate.utils.utilization.TransferType;
import com.nuix.automate.utils.utilization.TransferVolume;
import com.nuix.automate.utils.utilization.User;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import io.dropwizard.auth.Auth;
import io.dropwizard.jersey.PATCH;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@jakarta.ws.rs.Path(value="/v1/scheduler/resources/dataset")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class DatasetResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DatasetResource.class);
    private static final String[] builtInMetadataHeaders = new String[]{"Relative Path", "Added By", "Added Date (UTC)", "Size (display)", "Size (bytes)", "Type", "Files"};
    public static final String datasetIdRegex = "[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}";
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;
    private final TusFileUploadService tusFileUploadService;
    private final DatasetUtils datasetUtils;
    private final Map<String, Dataset> datasets;
    private final Map<String, Integer> datasetFailCount;
    private final SchedulerStorageService storageService;
    private final Map<String, FileInfo> fileInfos;

    public DatasetResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.datasetUtils = DatasetUtils.getDatasetUtils(schedulerApplication);
        this.datasets = new ConcurrentHashMap<String, Dataset>();
        this.datasetFailCount = new HashMap<String, Integer>();
        this.fileInfos = new ConcurrentHashMap<String, FileInfo>();
        this.storageService = new SchedulerStorageService(schedulerApplication);
        this.tusFileUploadService = new TusFileUploadService(schedulerApplication).withUploadStorageDao(this.storageService).withUploadURI("/api/v1/scheduler/resources/dataset/[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}/upload").withThreadLocalCache(true).withUploadExpirationPeriod(schedulerApplication.getConfiguration().getExpireIdleUploadAfter());
        if (schedulerApplication.getConfiguration().isCacheDatasetFileInfos()) {
            LOGGER.info("Preparing cache for FileInfos");
            List<FileInfo> dbFileInfos = schedulerApplication.getSchedulerConfigurationDao().getAllFileInfos();
            for (FileInfo fileInfo : dbFileInfos) {
                this.fileInfos.put(fileInfo.getId(), fileInfo);
            }
        }
        schedulerApplication.getScheduledExecutorService().scheduleWithFixedDelay(() -> {
            try {
                this.tusFileUploadService.cleanup();
            }
            catch (IOException e) {
                LOGGER.error("Failed to clean up TusFileUploadService", (Throwable)e);
            }
        }, 0L, schedulerApplication.getConfiguration().getDatasetTusFileUploadCleanupInterval(), TimeUnit.MILLISECONDS);
        schedulerApplication.getScheduledExecutorService().scheduleWithFixedDelay(() -> {
            for (Dataset dataset : this.datasets.values()) {
                Integer failCount = this.datasetFailCount.getOrDefault(dataset.getId(), 0);
                if (failCount > 10 || !dataset.isArchived()) continue;
                try {
                    DataRepository dataRepository = schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
                    Long expirationPeriod = dataRepository.getDatasetAutoExpireInterval();
                    if (expirationPeriod == null) continue;
                    long expirationTime = dataset.getArchivedDate() + expirationPeriod;
                    long currentTime = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
                    if (currentTime <= expirationTime) continue;
                    Response errorResponse = this.verifyNotUsedInJobs(null, dataset.getId());
                    if (errorResponse != null) {
                        LOGGER.error("Dataset is being used by a job, skipping auto-expire for dataset: " + dataset.getName());
                        continue;
                    }
                    switch (dataRepository.getType()) {
                        case MANAGED: {
                            this.datasetUtils.deleteDatasetDirectory(dataset);
                            break;
                        }
                    }
                    dataset.setLastModifiedDate(Long.valueOf(currentTime));
                    dataset.setState(DatasetState.EXPIRED);
                    ResponseCache.getInstance().resetKeyId(CacheKey.MATTER_DATASETS, dataset.getMatterId());
                    schedulerApplication.getSchedulerConfigurationDao().updateDataset(dataset);
                    schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), dataset.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.DATA_SET_EXPIRED, this.iu.getFormattedString("DatasetResource.AuditLog.DataSet.Name", (Object)dataset.getName()), "N/A"));
                    schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_SET_EXPIRED, dataset);
                }
                catch (Exception e) {
                    LOGGER.error("Failed to expire dataset: " + dataset.getName(), (Throwable)e);
                    this.datasetFailCount.put(dataset.getId(), failCount + 1);
                }
            }
        }, 0L, schedulerApplication.getConfiguration().getDatasetAutoExpireInterval(), TimeUnit.MILLISECONDS);
    }

    public void initializeDatasetsFromStore() {
        LOGGER.info("Initializing Datasets from store");
        List<Dataset> datasets = this.schedulerApplication.getSchedulerConfigurationDao().getDatasets();
        for (Dataset dataset : datasets) {
            dataset.setUsableSpace(this.datasetUtils.getDatasetUsableSpace(dataset));
            this.datasets.put(dataset.getId(), dataset);
        }
    }

    public SchedulerStorageService getStorageService() {
        return this.storageService;
    }

    public Dataset getDataset(String id) {
        return this.datasets.get(id);
    }

    public boolean containsDataset(String id) {
        return this.datasets.containsKey(id);
    }

    public Collection<Dataset> getDatasets() {
        return this.datasets.values();
    }

    public Set<String> getDatasetNames() {
        HashSet<String> datasetNames = new HashSet<String>();
        for (Dataset dataset : this.getDatasets()) {
            datasetNames.add(dataset.getName());
        }
        return datasetNames;
    }

    public void addOrUpdateFileInfo(FileInfo fileInfo) {
        if (this.schedulerApplication.getConfiguration().isCacheDatasetFileInfos()) {
            this.fileInfos.put(fileInfo.getId(), fileInfo);
        }
    }

    public void addOrUpdateFileInfo(Collection<FileInfo> fileInfoList) {
        if (this.schedulerApplication.getConfiguration().isCacheDatasetFileInfos()) {
            for (FileInfo fileInfo : fileInfoList) {
                this.fileInfos.put(fileInfo.getId(), fileInfo);
            }
        }
    }

    public List<FileInfo> getDataSetFileInfos(String datasetId, boolean isRootFile) {
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        for (FileInfo info : this.fileInfos.values()) {
            if (!info.getDatasetId().equals(datasetId)) continue;
            if (isRootFile) {
                if (info.getRootFileId() != null) continue;
                fileInfos.add(info);
                continue;
            }
            fileInfos.add(info);
        }
        return fileInfos;
    }

    public FileInfo getFileInfo(String fileInfoId) {
        return this.fileInfos.get(fileInfoId);
    }

    public List<FileInfo> filterFileInfos(Set<String> dataSetIds, Long beforeDate, Long afterDate) {
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        if (dataSetIds == null || dataSetIds.isEmpty()) {
            return fileInfos;
        }
        for (FileInfo info : this.fileInfos.values()) {
            if (info.getDirectory() != null && info.getDirectory().booleanValue() || afterDate != null && info.getAddedDate() < afterDate || beforeDate != null && info.getAddedDate() > beforeDate) continue;
            fileInfos.add(info);
        }
        return fileInfos;
    }

    public void deleteFilesWithRootFile(String rootFileId) {
        for (FileInfo info : this.fileInfos.values()) {
            if (info.getRootFileId() == null || !info.getRootFileId().equals(rootFileId)) continue;
            this.fileInfos.remove(info.getId());
        }
    }

    public void deleteFilesWithDatasetId(String datasetId) {
        for (FileInfo info : this.fileInfos.values()) {
            if (!info.getDatasetId().equals(datasetId)) continue;
            this.fileInfos.remove(info.getId());
        }
    }

    @Operation(tags={"Datasets"}, operationId="GetDataset", summary="Get Dataset", description="Get the Dataset with the specified ID", responses={@ApiResponse(description="The Dataset", content={@Content(schema=@Schema(implementation=Dataset.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @jakarta.ws.rs.Path(value="/{datasetId}")
    @GET
    public Response getDataset(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the dataset") @PathParam(value="datasetId") String datasetId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_UPLOAD);
        Response errorResponse = this.verifyMatterAndDatasetPermissions(user, datasetId, Permission.VIEW);
        if (errorResponse != null) {
            return errorResponse;
        }
        Dataset dataset = this.datasets.get(datasetId);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)dataset).build();
    }

    @Operation(tags={"Datasets"}, operationId="AddDataset", summary="Add Dataset", description="Add a new Dataset", responses={@ApiResponse(description="The Dataset that was added", content={@Content(schema=@Schema(implementation=Dataset.class))}), @ApiResponse(responseCode="400", description="A Dataset with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Consumes(value={"application/json"})
    public Response addDataset(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The Dataset to add", schema=@Schema(implementation=DatasetSubmission.class)) Dataset dataset) {
        Set<Permission> noticeDatasetPermissions;
        boolean hasAddPermission;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_UPLOAD);
        if (dataset.getName() == null || dataset.getName().isEmpty()) {
            return ExceptionUtils.toResponse((String)"datasetNameMissing", (Response.Status)Response.Status.BAD_REQUEST);
        }
        Matter matter = this.schedulerApplication.getClientResource().getMatter(dataset.getMatterId());
        if (matter == null) {
            return ExceptionUtils.toResponse((String)"cannotFindMatter", (Map)new HashMap<String, String>(){
                {
                    this.put("matterId", dataset.getMatterId());
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
        if (dataRepository == null) {
            return ExceptionUtils.toResponse((String)"cannotFindDataRepository", (Map)new HashMap<String, String>(){
                {
                    this.put("dataRepositoryId", dataset.getDataRepositoryId());
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Set dataRepositoryPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, dataRepository).getUserPermissions();
        Set matterPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter).getUserPermissions();
        boolean bl = hasAddPermission = matterPermissions.contains(Permission.MODIFY) || matterPermissions.contains(Permission.MODIFY_CHILDREN);
        if (!(hasAddPermission && dataRepositoryPermissions.contains(Permission.VIEW) || (noticeDatasetPermissions = this.schedulerApplication.getSecurityPolicyUtil().getNoticeDatasetPermissions(user, dataset)).contains(Permission.RESPOND) || noticeDatasetPermissions.contains(Permission.MANAGE))) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)dataset);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        List<Dataset> matterDatasets = this.schedulerApplication.getClientResource().getMatterDatasets(dataset.getMatterId());
        for (Dataset matterDataset : matterDatasets) {
            String existingName = matterDataset.getName();
            if (!existingName.equalsIgnoreCase(dataset.getName())) continue;
            return ExceptionUtils.toResponse((String)"datasetNameExists");
        }
        dataset.setDatasetCustodian(null);
        dataset.setCollectionId(null);
        dataset.setNoticeEventId(null);
        dataset.setArchivedDate(null);
        dataset.setCreatedDate(null);
        dataset.setFileMetadataHeaders(null);
        dataset.setFinalizedDate(null);
        dataset.setState(DatasetState.DRAFT);
        return this.addDataSetInternal(user, dataset, ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request));
    }

    public Response addDataSetInternal(BearerUser user, final Dataset dataset, String remoteAddress) {
        dataset.setId(UidUtils.getRandom());
        dataset.setPathFormat(this.schedulerApplication.getConfiguration().getDatasetPathFormat());
        dataset.setDefaults();
        Matter matter = this.schedulerApplication.getClientResource().getMatter(dataset.getMatterId());
        if (matter == null) {
            return ExceptionUtils.toResponse((String)"cannotFindMatter", (Map)new HashMap<String, String>(){
                {
                    this.put("matterId", dataset.getMatterId());
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
        if (dataRepository == null) {
            return ExceptionUtils.toResponse((String)"cannotFindDataRepository", (Map)new HashMap<String, String>(){
                {
                    this.put("dataRepositoryId", dataset.getDataRepositoryId());
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        if (!dataRepository.isCompatible(dataset)) {
            return ExceptionUtils.toResponse((String)"datasetIncompatibleWithDataRepository", (Response.Status)Response.Status.BAD_REQUEST);
        }
        switch (dataRepository.getType()) {
            case MANAGED: {
                try {
                    if (dataRepository.getDatasetMaxSizeEnabled() == Boolean.TRUE) {
                        dataset.setUsableSpace(dataRepository.getDatasetMaxSize());
                    }
                    this.datasetUtils.createDataset(dataset);
                    break;
                }
                catch (IOException e) {
                    return ExceptionUtils.toResponse((String)"errorAddingDataset", (Exception)e);
                }
            }
            case IN_PLACE: {
                final String path = dataset.getPath();
                if (path == null || path.trim().length() == 0) {
                    return ExceptionUtils.toResponse((String)"inPlaceDatasetPathMissing", (Response.Status)Response.Status.BAD_REQUEST);
                }
                Path datasetPath = Paths.get(path, new String[0]).normalize().toAbsolutePath();
                if (!Files.exists(datasetPath, new LinkOption[0])) {
                    return ExceptionUtils.toResponse((String)"pathNotFound", (Map)new HashMap<String, String>(){
                        {
                            this.put("path", path);
                        }
                    });
                }
                if (!Files.isDirectory(datasetPath, new LinkOption[0])) {
                    return ExceptionUtils.toResponse((String)"invalidInPlacePathNotAFolder", (Response.Status)Response.Status.BAD_REQUEST);
                }
                Path dataRepositoryPath = Paths.get(dataRepository.getPath(), new String[0]).normalize().toAbsolutePath();
                Path datasetParentPath = datasetPath.getParent();
                if (datasetParentPath == null || !datasetParentPath.startsWith(dataRepositoryPath)) {
                    return ExceptionUtils.toResponse((String)"DatasetPathNotInRepository", (Response.Status)Response.Status.BAD_REQUEST);
                }
                dataset.setPath(datasetPath.toString());
                try {
                    Map<String, FileInfo> rootFileInfos = this.datasetUtils.scanDatasetRootFiles(user, dataset);
                    this.datasetUtils.batchInsertFileInfos(rootFileInfos.values());
                    ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_FILES, dataset.getId());
                    ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_FILES, "");
                    break;
                }
                catch (IOException e) {
                    LOGGER.error("Error scanning dataset", (Throwable)e);
                    return ExceptionUtils.toResponse((String)"errorScanningDataset", (Exception)e);
                }
            }
        }
        dataset.setCreatedDate(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
        int matterDatasetCounter = matter.getDatasetCounter() + 1;
        dataset.setNumber(Integer.valueOf(matterDatasetCounter));
        matter.setDatasetCounter(matterDatasetCounter);
        this.schedulerApplication.getClientResource().updateMatterInternal(matter);
        this.schedulerApplication.getSchedulerConfigurationDao().addDataset(dataset);
        this.datasets.put(dataset.getId(), dataset);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_SET_ADDED, dataset, user.getName());
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), dataset.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.DATA_SET_ADDED, "", remoteAddress));
        ResponseCache.getInstance().resetKeyId(CacheKey.MATTER_DATASETS, dataset.getMatterId());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)dataset).build();
    }

    @Operation(tags={"Datasets"}, operationId="DeleteDataset", summary="Delete Dataset", description="Delete the dataset with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="400", description="Cannot find dataset with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @jakarta.ws.rs.Path(value="/{datasetId}")
    @DELETE
    public Response deleteDataset(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the dataset to delete") @PathParam(value="datasetId") String datasetId, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="Force deletion of dataset with active or idle uploads?") @QueryParam(value="force") boolean force) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Response errorResponse = this.verifyMatterAndDatasetPermissions(user, datasetId, Permission.MODIFY, true);
        if (errorResponse != null) {
            return errorResponse;
        }
        errorResponse = this.verifyActiveIdleUploads(datasetId, force);
        if (errorResponse != null) {
            return errorResponse;
        }
        errorResponse = this.verifyNotUsedInJobs(user, datasetId);
        if (errorResponse != null) {
            return errorResponse;
        }
        Dataset dataset = this.datasets.get(datasetId);
        DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
        switch (dataRepository.getType()) {
            case MANAGED: {
                try {
                    this.datasetUtils.deleteDatasetDirectory(dataset);
                    break;
                }
                catch (IOException e) {
                    LOGGER.error("Error deleting dataset", (Throwable)e);
                    String eventDetails = this.iu.getFormattedString("DatasetResource.AuditLog.Error.Operation", (Object)EventType.Type.DATA_SET_DELETED) + "\n" + this.iu.getFormattedString("DatasetResource.AuditLog.Error.Message", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                    this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), dataset.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.DATA_SET_ERROR, eventDetails, ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                    this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_SET_ERROR, dataset, user.getName());
                    return ExceptionUtils.toResponse((String)"errorDeletingDataset", (Exception)e);
                }
            }
        }
        dataset.setState(DatasetState.DELETED);
        dataset.setLastModifiedDate(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
        this.schedulerApplication.getSchedulerConfigurationDao().updateDataset(dataset);
        if (this.schedulerApplication.getConfiguration().isCacheDatasetFileInfos()) {
            this.deleteFilesWithDatasetId(datasetId);
        }
        this.schedulerApplication.getClientMatterDao().deleteDatasetFileInfos(datasetId);
        for (UploadInfo uploadInfo : this.storageService.getDatasetUploadInfos(datasetId)) {
            try {
                this.storageService.terminateUpload(uploadInfo);
            }
            catch (IOException iOException) {}
        }
        ResponseCache.getInstance().resetKeyId(CacheKey.MATTER_DATASETS, dataset.getMatterId());
        ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_FILES, datasetId);
        ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_FILES, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_FILES_METADATA, datasetId);
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), dataset.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.DATA_SET_DELETED, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_SET_DELETED, dataset, user.getName());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("datasetDeleted")).build();
    }

    @POST
    @jakarta.ws.rs.Path(value="/proxy/uploadInfoFromId")
    public Response getUploadInfo(@Auth BearerUser user, String serializedUploadId) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        UploadId uploadId = new UploadId(serializedUploadId);
        UploadInfo uploadInfo = this.storageService.getUploadInfo(uploadId);
        UploadInfo copyUploadInfo = uploadInfo.clone();
        copyUploadInfo.setDigests(null);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)copyUploadInfo).build();
    }

    @PUT
    @jakarta.ws.rs.Path(value="/proxy/uploadInfo")
    public Response updateUploadInfo(@Auth BearerUser user, String uploadInfoSerialization) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        UploadInfo uploadInfo = (UploadInfo)SerializationUtils.fromJson((String)uploadInfoSerialization, UploadInfo.class);
        this.storageService.update(uploadInfo);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)"").build();
    }

    @GET
    @jakarta.ws.rs.Path(value="/proxy/dataset/{datasetId}")
    public Response getUserWithPermissionsOnDataSet(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="datasetId") String datasetId) throws IOException {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request, true);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.verifyMatterAndDatasetPermissions(user, datasetId, response)) {
            response.flushBuffer();
            return null;
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)user.getName()).build();
    }

    @GET
    @jakarta.ws.rs.Path(value="/proxy/setting/uploadHashAlgorithms")
    public Response getUploadHashAlgorithms(@Auth BearerUser user, @Context HttpServletResponse response) {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.schedulerApplication.getConfiguration().getUploadHashAlgorithms()).build();
    }

    @GET
    @jakarta.ws.rs.Path(value="/{datasetId}/usableSpace")
    public Response getUsableSpace(@Auth BearerUser user, @PathParam(value="datasetId") String datasetId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Response errorResponse = this.verifyMatterAndDatasetPermissions(user, datasetId, Permission.VIEW);
        if (errorResponse != null) {
            return errorResponse;
        }
        Dataset dataset = this.datasets.get(datasetId);
        final DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
        this.schedulerApplication.getDataRepositoryResource().updateUsableSpace(dataRepository);
        if (dataRepository.getStatus().getCode() == State.ERROR) {
            LOGGER.error("Failed to get repository usable space");
            return ExceptionUtils.toResponse((String)"errorGettingDatasetUsableSpace", (Map)new HashMap<String, String>(){
                {
                    this.put("exception", dataRepository.getStatus().getMessage());
                }
            });
        }
        UsableSpace datasetUsableSpace = new UsableSpace(dataRepository.getUsableSpace());
        Long quotaUsableSpace = datasetUsableSpace.getQuotaUsableSpace();
        Long usableSpace = dataset.getUsableSpace();
        if (dataRepository.getDatasetMaxSizeEnabled() == Boolean.TRUE && (quotaUsableSpace == null || usableSpace < quotaUsableSpace)) {
            datasetUsableSpace.setQuotaUsableSpace(usableSpace);
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)datasetUsableSpace).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @jakarta.ws.rs.Path(value="/{datasetId}/sizeOfFiles")
    public Response getSizeOfFiles(@Auth BearerUser user, @PathParam(value="datasetId") String datasetId, Set<String> fileRelativePaths) throws FileTraversalException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Response errorResponse = this.verifyMatterAndDatasetPermissions(user, datasetId, Permission.VIEW);
        if (errorResponse != null) {
            return errorResponse;
        }
        Dataset dataset = this.datasets.get(datasetId);
        Path datasetDraftPath = this.datasetUtils.getDatasetDraftPath(dataset);
        AtomicLong totalSize = new AtomicLong();
        ExecutorService executorService = null;
        try {
            executorService = Executors.newFixedThreadPool(4);
            ArrayList fileSizeFutures = new ArrayList();
            for (String string : fileRelativePaths) {
                Path draftFilePath;
                if (string == null || string.trim().length() <= 0 || !Files.exists(draftFilePath = FileUtils.safeResolveParent((Path)datasetDraftPath, (String[])new String[]{string}), new LinkOption[0])) continue;
                fileSizeFutures.add(executorService.submit(() -> {
                    try {
                        totalSize.addAndGet(Files.size(draftFilePath));
                    }
                    catch (IOException e) {
                        LOGGER.error("Error calculating size for file: " + String.valueOf(draftFilePath), (Throwable)e);
                    }
                }));
            }
            for (Future future : fileSizeFutures) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    LOGGER.error((Throwable)e);
                }
            }
        }
        finally {
            if (executorService != null) {
                executorService.shutdownNow();
            }
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)totalSize.get()).build();
    }

    @POST
    @jakarta.ws.rs.Path(value="/{datasetId}/restrictions")
    public Response getRestrictions(@Auth BearerUser user, @PathParam(value="datasetId") String datasetId, Set<String> fileRelativePaths) throws FileTraversalException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Response errorResponse = this.verifyMatterAndDatasetPermissions(user, datasetId, Permission.VIEW);
        if (errorResponse != null) {
            return errorResponse;
        }
        Dataset dataset = this.datasets.get(datasetId);
        DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
        Path datasetDraftPath = this.datasetUtils.getDatasetDraftPath(dataset);
        Set allowedFileExtensions = dataRepository.getAllowedFileExtensions();
        DatasetRestrictions datasetRestrictions = new DatasetRestrictions();
        for (String fileRelativePath : fileRelativePaths) {
            String fileExtension;
            if (fileRelativePath == null || fileRelativePath.trim().length() <= 0) continue;
            if (allowedFileExtensions != null && allowedFileExtensions.size() > 0 && !allowedFileExtensions.contains(fileExtension = FilenameUtils.getExtension((String)fileRelativePath).toLowerCase())) {
                datasetRestrictions.getInvalidExtensionPaths().add(fileRelativePath);
                continue;
            }
            Path draftFilePath = FileUtils.safeResolveParent((Path)datasetDraftPath, (String[])new String[]{fileRelativePath});
            if (!Files.exists(draftFilePath, new LinkOption[0])) continue;
            datasetRestrictions.getDuplicatePaths().add(fileRelativePath);
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)datasetRestrictions).build();
    }

    @Operation(tags={"Datasets"}, operationId="GetDatasetFiles", summary="Get Dataset Files", description="Get full information of all files from the dataset", responses={@ApiResponse(description="The list of files", content={@Content(array=@ArraySchema(schema=@Schema(implementation=FileInfo.class)))}), @ApiResponse(responseCode="400", description="Cannot find dataset with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @jakarta.ws.rs.Path(value="/{datasetId}/files")
    public Response getFiles(@Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @PathParam(value="datasetId") String datasetId, @QueryParam(value="showNested") boolean showNested) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.DATA_SET_FILES, datasetId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            Response errorResponse = this.verifyMatterAndDatasetPermissions(user, datasetId, Permission.VIEW);
            if (errorResponse != null) {
                return errorResponse;
            }
            Dataset dataset = this.getDataset(datasetId);
            List<FileInfo> datasetFileInfos = showNested ? FileInfoCache.getInstance().getDatasetFileInfos(datasetId) : FileInfoCache.getInstance().getDatasetRootFileInfos(datasetId);
            if (dataset.getType() == DatasetType.ECC) {
                for (FileInfo fileInfo : datasetFileInfos) {
                    fileInfo.setMetadata(null);
                }
            }
            datasetFileInfos.sort(Comparator.comparing(FileInfo::getRelativePath, String.CASE_INSENSITIVE_ORDER));
            datasetFileInfos.sort(Comparator.comparing(FileInfo::getDirectory, (dir1, dir2) -> {
                if (dir1 == null && dir2 == null) {
                    return 0;
                }
                if (dir1 != null && dir1.equals(dir2)) {
                    return 0;
                }
                if (dir1 != null && dir1.booleanValue()) {
                    return -1;
                }
                return 1;
            }));
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(datasetFileInfos).build();
        }
    }

    @POST
    @jakarta.ws.rs.Path(value="/{datasetId}/files:batchDelete")
    public Response deleteFiles(@Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @PathParam(value="datasetId") String datasetId, String[] fileIds) throws FileTraversalException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Response errorResponse = this.verifyMatterAndDatasetPermissions(user, datasetId, Permission.MODIFY);
        if (errorResponse != null) {
            return errorResponse;
        }
        Dataset dataset = this.datasets.get(datasetId);
        if (!dataset.isDraft()) {
            return ExceptionUtils.toResponse((String)"datasetIsNotDraft", (Response.Status)Response.Status.BAD_REQUEST);
        }
        DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
        if (dataRepository.getType() == DatasetType.IN_PLACE) {
            return ExceptionUtils.toResponse((String)"cannotModifyInPlaceDataset", (Response.Status)Response.Status.BAD_REQUEST);
        }
        Path datasetDraftPath = this.datasetUtils.getDatasetDraftPath(dataset);
        boolean fileDeleted = false;
        for (String fileId : fileIds) {
            FileInfo fileInfo = FileInfoCache.getInstance().getFileInfo(fileId);
            if (fileInfo == null || !fileInfo.isRoot() || !datasetId.equals(fileInfo.getDatasetId())) {
                LOGGER.error("Cannot delete file " + fileId + " because it is not a root file, was not found or belongs to a different dataset");
                continue;
            }
            Path filePath = FileUtils.safeResolveParent((Path)datasetDraftPath, (String[])new String[]{fileInfo.getRelativePath()});
            try {
                if (Files.isDirectory(filePath, new LinkOption[0])) {
                    org.apache.commons.io.FileUtils.deleteDirectory((File)filePath.toFile());
                    if (this.schedulerApplication.getConfiguration().isCacheDatasetFileInfos()) {
                        this.deleteFilesWithRootFile(fileId);
                    }
                    this.schedulerApplication.getClientMatterDao().deleteFileInfosWithRootFileId(fileId);
                } else {
                    FileUtils.deleteRecursively((Path)filePath);
                }
                if (this.schedulerApplication.getConfiguration().isCacheDatasetFileInfos()) {
                    this.fileInfos.remove(fileId);
                }
                this.schedulerApplication.getClientMatterDao().deleteFileInfo(fileId);
                fileDeleted = true;
                this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), datasetId, Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.DATA_SET_FILE_DELETED, this.iu.getFormattedString("DatasetResource.AuditLog.File.RelativePath", (Object)fileInfo.getRelativePath()), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_SET_FILE_DELETED, fileInfo, user.getName());
            }
            catch (IOException e) {
                LOGGER.error("Error deleting dataset files", (Throwable)e);
                String eventDetails = this.iu.getFormattedString("DatasetResource.AuditLog.Error.Operation", (Object)EventType.Type.DATA_SET_FILE_DELETED) + "\n" + this.iu.getFormattedString("DatasetResource.AuditLog.Error.Message", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), dataset.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.DATA_SET_ERROR, eventDetails, ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_SET_ERROR, dataset, user.getName());
                LOGGER.error("Could not delete file: " + fileInfo.getRelativePath(), (Throwable)e);
            }
        }
        if (fileDeleted) {
            dataset.setLastModifiedDate(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
            this.schedulerApplication.getSchedulerConfigurationDao().updateDataset(dataset);
            dataset.setUsableSpace(this.datasetUtils.getDatasetUsableSpace(dataset));
            this.schedulerApplication.getDataRepositoryResource().updateUsableSpace(dataRepository);
            ResponseCache.getInstance().resetKeyId(CacheKey.MATTER_DATASETS, dataset.getMatterId());
            ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_FILES, datasetId);
            ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_FILES, "");
            ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_FILES_METADATA, datasetId);
        }
        return this.getFiles(user, request, datasetId, false);
    }

    @POST
    @Consumes(value={"text/plain"})
    @jakarta.ws.rs.Path(value="/{datasetId}/files/metadata")
    public Response updateFileInfoMetadata(@Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @PathParam(value="datasetId") String datasetId, String csvText) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Response errorResponse = this.verifyMatterAndDatasetPermissions(user, datasetId, Permission.MODIFY, true);
        if (errorResponse != null) {
            return errorResponse;
        }
        Dataset dataset = this.datasets.get(datasetId);
        if (dataset.isFinalized()) {
            return ExceptionUtils.toResponse((String)"datasetIsFinalized", (Response.Status)Response.Status.BAD_REQUEST);
        }
        List metadataHeaders = dataset.getFileMetadataHeaders();
        HashSet<CallSite> currentFilesMetadataAuditLog = new HashSet<CallSite>();
        HashMap<String, FileInfo> relativePathToFileInfo = new HashMap<String, FileInfo>();
        for (FileInfo fileInfo : FileInfoCache.getInstance().getDatasetRootFileInfos(datasetId)) {
            if (metadataHeaders != null) {
                for (int i = 0; i < metadataHeaders.size(); ++i) {
                    List fileMetadata = fileInfo.getMetadata();
                    if (fileMetadata == null || fileMetadata.size() <= i) continue;
                    String header = (String)metadataHeaders.get(i);
                    String value = (String)fileMetadata.get(i);
                    String metadataLogLine = fileInfo.getRelativePath() + "\t" + header + "\t" + value;
                    currentFilesMetadataAuditLog.add((CallSite)((Object)metadataLogLine));
                }
            }
            relativePathToFileInfo.put(fileInfo.getRelativePath(), fileInfo);
            fileInfo.setMetadata(null);
        }
        LinkedHashSet<String> builtInHeaderSet = new LinkedHashSet<String>(Arrays.asList(builtInMetadataHeaders));
        try (CSVReader csvReader = new CSVReader((Reader)new StringReader(csvText));){
            int i;
            String[] values;
            List<String> headers = Arrays.asList(csvReader.readNext());
            ArrayList<String> nonBuiltInHeaders = new ArrayList<String>();
            ArrayList<Boolean> skipHeader = new ArrayList<Boolean>();
            skipHeader.add(true);
            for (int i2 = 1; i2 < headers.size(); ++i2) {
                String header = headers.get(i2);
                if (header.trim().length() == 0) {
                    skipHeader.add(true);
                    continue;
                }
                if (builtInHeaderSet.contains(header)) {
                    skipHeader.add(true);
                    continue;
                }
                if (header.startsWith("Hash (") && header.endsWith(")")) {
                    skipHeader.add(true);
                    continue;
                }
                if (nonBuiltInHeaders.contains(header)) {
                    skipHeader.add(true);
                    continue;
                }
                skipHeader.add(false);
                nonBuiltInHeaders.add(header);
            }
            dataset.setFileMetadataHeaders(nonBuiltInHeaders);
            while ((values = csvReader.readNext()) != null) {
                String relativePath = Paths.get(values[0], new String[0]).toString();
                FileInfo fileInfo = (FileInfo)relativePathToFileInfo.get(relativePath);
                if (fileInfo == null) continue;
                List<String> metadata = Arrays.asList(values);
                ArrayList<String> nonBuiltInMetadata = new ArrayList<String>();
                fileInfo.setMetadata(nonBuiltInMetadata);
                for (i = 1; i < skipHeader.size(); ++i) {
                    if (((Boolean)skipHeader.get(i)).booleanValue()) continue;
                    if (metadata.size() > i) {
                        nonBuiltInMetadata.add(metadata.get(i));
                        continue;
                    }
                    nonBuiltInMetadata.add("");
                }
            }
            metadataHeaders = dataset.getFileMetadataHeaders();
            for (FileInfo fileInfo : relativePathToFileInfo.values()) {
                StringBuilder eventDetails = null;
                List fileMetadata = fileInfo.getMetadata();
                if (fileMetadata != null) {
                    for (i = 0; i < metadataHeaders.size(); ++i) {
                        if (fileMetadata.size() <= i) continue;
                        String header = (String)metadataHeaders.get(i);
                        String value = (String)fileMetadata.get(i);
                        String metadataLogLine = fileInfo.getRelativePath() + "\t" + header + "\t" + value;
                        if (currentFilesMetadataAuditLog.contains(metadataLogLine)) continue;
                        if (eventDetails == null) {
                            eventDetails = new StringBuilder();
                            eventDetails.append(this.iu.getFormattedString("DatasetResource.AuditLog.File.Name", (Object)fileInfo.getName()));
                        }
                        eventDetails.append("\n");
                        eventDetails.append(this.iu.getFormattedString("DatasetResource.AuditLog.File.RelativePath", (Object)fileInfo.getRelativePath()));
                        eventDetails.append("\n");
                        eventDetails.append(this.iu.getFormattedString("DatasetResource.AuditLog.File.Metadata", (Object[])new String[]{header, value}));
                    }
                }
                if (eventDetails != null) {
                    this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), dataset.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.DATA_SET_FILE_METADATA_UPDATED, eventDetails.toString(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                    this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_SET_FILE_METADATA_UPDATED, fileInfo, user.getName());
                }
                this.schedulerApplication.getClientMatterDao().updateFileInfo(fileInfo);
            }
            dataset.setLastModifiedDate(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
            this.schedulerApplication.getSchedulerConfigurationDao().updateDataset(dataset);
            ResponseCache.getInstance().resetKeyId(CacheKey.MATTER_DATASETS, dataset.getMatterId());
            ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_FILES, datasetId);
            ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_FILES, "");
            ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_FILES_METADATA, datasetId);
        }
        catch (IOException e) {
            return ExceptionUtils.toResponse((String)"errorReadingCsv", (Exception)e, (Response.Status)Response.Status.BAD_REQUEST);
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @GET
    @jakarta.ws.rs.Path(value="/{datasetId}/files/metadata")
    public Response downloadFileInfoMetadata(@Auth BearerUser user, @PathParam(value="datasetId") String datasetId, @QueryParam(value="showNested") boolean showNested) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Response errorResponse = this.verifyMatterAndDatasetPermissions(user, datasetId, Permission.VIEW);
        if (errorResponse != null) {
            return errorResponse;
        }
        Dataset dataset = this.datasets.get(datasetId);
        List<FileInfo> fileInfos = showNested ? FileInfoCache.getInstance().getDatasetFileInfos(datasetId) : FileInfoCache.getInstance().getDatasetRootFileInfos(datasetId);
        fileInfos.sort(Comparator.comparing(FileInfo::getRelativePath, String.CASE_INSENSITIVE_ORDER));
        LinkedHashSet hashAlgorithms = new LinkedHashSet();
        for (FileInfo fileInfo : fileInfos) {
            if (fileInfo.getHashes() == null) continue;
            hashAlgorithms.addAll(fileInfo.getHashes().keySet());
        }
        DateTimeFormatter excelDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.of("UTC"));
        try (StringWriter writer = new StringWriter();){
            Iterator<Object> iterator;
            try (CSVWriter csvWriter = new CSVWriter((Writer)writer);){
                ArrayList<String> headers = new ArrayList<String>(Arrays.asList(builtInMetadataHeaders));
                for (String hashAlgorithm : hashAlgorithms) {
                    headers.add("Hash (" + hashAlgorithm + ")");
                }
                if (dataset.getFileMetadataHeaders() != null) {
                    headers.addAll(dataset.getFileMetadataHeaders());
                }
                csvWriter.writeNext(headers.toArray(new String[0]));
                for (FileInfo fileInfo : fileInfos) {
                    ArrayList<String> metadata = new ArrayList<String>();
                    metadata.add(fileInfo.getRelativePath());
                    metadata.add(fileInfo.getAddedBy());
                    metadata.add(excelDateTimeFormatter.format(Instant.ofEpochMilli(fileInfo.getAddedDate())));
                    metadata.add(FormattingUtils.sizeToDisplaySize((long)fileInfo.getSize()));
                    metadata.add(String.valueOf(fileInfo.getSize()));
                    if (fileInfo.getDirectory() == Boolean.TRUE) {
                        metadata.add("Folder");
                        metadata.add(String.valueOf(fileInfo.getFileCount()));
                    } else {
                        metadata.add("File");
                        metadata.add("");
                    }
                    for (String hashAlgorithm : hashAlgorithms) {
                        String hashValue = "";
                        if (fileInfo.getHashes() != null && (hashValue = (String)fileInfo.getHashes().get(hashAlgorithm)) == null) {
                            hashValue = "";
                        }
                        metadata.add(hashValue);
                    }
                    if (fileInfo.getMetadata() != null) {
                        metadata.addAll(fileInfo.getMetadata());
                    }
                    csvWriter.writeNext(metadata.toArray(new String[0]));
                }
                iterator = Response.status((Response.Status)Response.Status.OK).type("text/plain").entity((Object)((Object)writer).toString()).build();
            }
            return iterator;
        }
        catch (IOException e) {
            return ExceptionUtils.toResponse((String)"errorWritingCsv", (Exception)e, (Response.Status)Response.Status.BAD_REQUEST);
        }
    }

    @GET
    @jakarta.ws.rs.Path(value="/{datasetId}/files/requiredMetadataHeaders")
    public Response getRequiredMetadataHeaders(@Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @PathParam(value="datasetId") String datasetId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.DATA_SET_REQUIRED_METADATA, datasetId);
        long clientsLastModified = ResponseCache.getInstance().getLastModified(CacheKey.CLIENTS, "");
        long clientPoolsLastModified = ResponseCache.getInstance().getLastModified(CacheKey.CLIENT_POOLS, "");
        long mattersLastModified = ResponseCache.getInstance().getLastModified(CacheKey.MATTERS, "");
        if (clientsLastModified > lastModified || clientPoolsLastModified > lastModified || mattersLastModified > lastModified) {
            ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_REQUIRED_METADATA, datasetId);
            lastModified = ResponseCache.getInstance().getLastModified(CacheKey.DATA_SET_REQUIRED_METADATA, datasetId);
        }
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            Response errorResponse = this.verifyMatterAndDatasetPermissions(user, datasetId, Permission.VIEW);
            if (errorResponse != null) {
                return errorResponse;
            }
            Dataset dataset = this.datasets.get(datasetId);
            Map<String, Set<String>> datasetRequiredMetadataHeaders = this.datasetUtils.getRequiredMetadataHeaders(dataset);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(datasetRequiredMetadataHeaders).build();
        }
    }

    @Operation(tags={"Datasets"}, operationId="SendDataSetCommand", summary="Send Dataset Command", description="Send a command to the dataset with the specified IDs, for example to archive the dataset", responses={@ApiResponse(responseCode="200", description="The updated dataset", content={@Content(schema=@Schema(implementation=Dataset.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @jakarta.ws.rs.Path(value="/{datasetId}/command")
    public Response sendDatasetCommand(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The ID of the dataset to send the command to") @PathParam(value="datasetId") String datasetId, @Parameter(description="Force the command execution?") @QueryParam(value="force") boolean force, @Parameter(description="The commands to send to the dataset") DatasetCommand datasetCommand) throws FileTraversalException {
        EventType.Type eventType;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Response errorResponse = this.verifyMatterAndDatasetPermissions(user, datasetId, Permission.MODIFY, datasetCommand.getCommand() != DatasetCommand.Command.FINALIZE);
        if (errorResponse != null) {
            return errorResponse;
        }
        Dataset dataset = this.datasets.get(datasetId);
        DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
        DatasetStatusWrapper datasetStatusWrapper = new DatasetStatusWrapper(dataset);
        long lastModifiedDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        switch (datasetCommand.getCommand()) {
            case FINALIZE: {
                if (dataset.getCollectionId() == null) {
                    if (!dataset.isDraft()) {
                        return ExceptionUtils.toResponse((String)"datasetIsNotDraft", (Response.Status)Response.Status.BAD_REQUEST);
                    }
                } else if (!dataset.isActiveCollection()) {
                    return ExceptionUtils.toResponse((String)"datasetIsNotActiveCollection", (Response.Status)Response.Status.BAD_REQUEST);
                }
                if (dataRepository.getType() == DatasetType.IN_PLACE) {
                    try {
                        Map<String, FileInfo> newRootFileInfos = this.datasetUtils.scanDatasetRootFiles(user, dataset);
                        ArrayList<String> warnings = new ArrayList<String>();
                        HashSet<String> oldFileInfoIds = new HashSet<String>();
                        for (FileInfo fileInfo : FileInfoCache.getInstance().getDatasetRootFileInfos(datasetId)) {
                            FileInfo newRootFileInfo = newRootFileInfos.get(fileInfo.getId());
                            oldFileInfoIds.add(fileInfo.getId());
                            String relativePath = fileInfo.getRelativePath();
                            if (newRootFileInfo == null) {
                                warnings.add(this.iu.getFormattedString("Dataset.MissingFile", (Object)relativePath));
                                continue;
                            }
                            if (fileInfo.getSize() != newRootFileInfo.getSize()) {
                                String oldSize = FormattingUtils.sizeToDisplaySize((long)fileInfo.getSize(), (int)4);
                                String newSize = FormattingUtils.sizeToDisplaySize((long)newRootFileInfo.getSize(), (int)4);
                                warnings.add(this.iu.getFormattedString("Dataset.UnexpectedFileSize", new Object[]{relativePath, oldSize, newSize}));
                            }
                            if (fileInfo.getFileCount() != newRootFileInfo.getFileCount()) {
                                warnings.add(this.iu.getFormattedString("Dataset.UnexpectedFileCount", new Object[]{relativePath, newRootFileInfo.getFileCount(), fileInfo.getFileCount()}));
                            }
                            if (fileInfo.getMetadata() == null || fileInfo.getMetadata().size() == 0) continue;
                            newRootFileInfo.setMetadata(fileInfo.getMetadata());
                        }
                        HashSet<String> newRootFileInfoIds = new HashSet<String>(newRootFileInfos.keySet());
                        newRootFileInfoIds.removeAll(oldFileInfoIds);
                        for (String newRootFileInfoId : newRootFileInfoIds) {
                            warnings.add(this.iu.getFormattedString("Dataset.UnexpectedFile", (Object)newRootFileInfos.get(newRootFileInfoId).getRelativePath()));
                        }
                        if (warnings.size() > 0) {
                            String string = String.join((CharSequence)"\n", warnings);
                            datasetStatusWrapper.getStatus().setWarningMessage(string, "inPlaceDatasetFinalizeIntegrityWarning");
                        }
                        if (this.schedulerApplication.getConfiguration().isCacheDatasetFileInfos()) {
                            this.deleteFilesWithDatasetId(datasetId);
                        }
                        this.schedulerApplication.getClientMatterDao().deleteDatasetFileInfos(datasetId);
                        this.datasetUtils.batchInsertFileInfos(newRootFileInfos.values());
                        ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_FILES, datasetId);
                        ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_FILES, "");
                        ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_FILES_METADATA, datasetId);
                    }
                    catch (IOException e) {
                        LOGGER.error("Error scanning dataset", (Throwable)e);
                        return ExceptionUtils.toResponse((String)"errorScanningDataset", (Exception)e);
                    }
                }
                if ((errorResponse = this.finalizeDataset(user, dataset, force, ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request))) != null) {
                    return errorResponse;
                }
                dataset.setState(DatasetState.FINALIZED);
                dataset.setFinalizedDate(Long.valueOf(lastModifiedDate));
                eventType = EventType.Type.DATA_SET_FINALIZED;
                this.schedulerApplication.getScheduleWorker().triggerDatasetEvent(dataset, DatasetEvent.DATA_SET_FINALIZED);
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_SET_FINALIZED, dataset, user.getName());
                break;
            }
            case HIDE: {
                if (!dataset.isFinalized()) {
                    return ExceptionUtils.toResponse((String)"datasetIsNotFinalized", (Response.Status)Response.Status.BAD_REQUEST);
                }
                dataset.setState(DatasetState.HIDDEN);
                eventType = EventType.Type.DATA_SET_HIDDEN;
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_SET_HIDDEN, dataset, user.getName());
                break;
            }
            case SHOW: {
                if (!dataset.isHidden()) {
                    return ExceptionUtils.toResponse((String)"datasetIsNotHidden", (Response.Status)Response.Status.BAD_REQUEST);
                }
                dataset.setState(DatasetState.FINALIZED);
                eventType = EventType.Type.DATA_SET_UNHIDDEN;
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_SET_UNHIDDEN, dataset, user.getName());
                break;
            }
            case ARCHIVE: {
                if (!dataset.isHidden()) {
                    return ExceptionUtils.toResponse((String)"datasetIsNotHidden", (Response.Status)Response.Status.BAD_REQUEST);
                }
                errorResponse = this.verifyNotUsedInJobs(user, datasetId);
                if (errorResponse != null) {
                    return errorResponse;
                }
                dataset.setState(DatasetState.ARCHIVED);
                dataset.setArchivedDate(Long.valueOf(lastModifiedDate));
                eventType = EventType.Type.DATA_SET_ARCHIVED;
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_SET_ARCHIVED, dataset, user.getName());
                break;
            }
            case UNARCHIVE: {
                if (!dataset.isArchived()) {
                    return ExceptionUtils.toResponse((String)"datasetIsNotArchived", (Response.Status)Response.Status.BAD_REQUEST);
                }
                dataset.setState(DatasetState.FINALIZED);
                eventType = EventType.Type.DATA_SET_UNARCHIVED;
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_SET_UNARCHIVED, dataset, user.getName());
                break;
            }
            case EXPIRE: {
                if (!dataset.isArchived()) {
                    return ExceptionUtils.toResponse((String)"datasetIsNotArchived", (Response.Status)Response.Status.BAD_REQUEST);
                }
                errorResponse = this.verifyNotUsedInJobs(user, datasetId);
                if (errorResponse != null) {
                    return errorResponse;
                }
                switch (dataRepository.getType()) {
                    case MANAGED: {
                        try {
                            this.datasetUtils.deleteDatasetDirectory(dataset);
                            break;
                        }
                        catch (IOException e) {
                            return ExceptionUtils.toResponse((String)"errorUpdatingDatasetState", (Exception)e);
                        }
                    }
                }
                dataset.setState(DatasetState.EXPIRED);
                eventType = EventType.Type.DATA_SET_EXPIRED;
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_SET_EXPIRED, dataset, user.getName());
                break;
            }
            default: {
                return ExceptionUtils.toResponse((String)"noSuchCommand");
            }
        }
        dataset.setLastModifiedDate(Long.valueOf(lastModifiedDate));
        this.schedulerApplication.getSchedulerConfigurationDao().updateDataset(dataset);
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), dataset.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), eventType, this.iu.getFormattedString("DatasetResource.AuditLog.DataSet.Name", (Object)dataset.getName()), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        ResponseCache.getInstance().resetKeyId(CacheKey.MATTER_DATASETS, dataset.getMatterId());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)datasetStatusWrapper).build();
    }

    @GET
    @jakarta.ws.rs.Path(value="/{datasetId}/uploadInfos")
    public Response getUploadInfos(@Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @PathParam(value="datasetId") String datasetId, @QueryParam(value="showNested") boolean showNested) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.DATA_SET_UPLOAD_INFOS, datasetId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            Response errorResponse = this.verifyMatterAndDatasetPermissions(user, datasetId, Permission.VIEW);
            if (errorResponse != null) {
                return errorResponse;
            }
            List uploadInfos = this.storageService.getDatasetUploadInfos(datasetId).stream().filter(info -> showNested || info.isRoot()).map(info -> new UploadInfoModel((UploadInfo)info, this.tusFileUploadService)).sorted(Comparator.comparing(UploadInfoModel::getName, String.CASE_INSENSITIVE_ORDER)).collect(Collectors.toList());
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(uploadInfos).build();
        }
    }

    @POST
    @jakarta.ws.rs.Path(value="/{datasetId}/uploadInfos:batchDelete")
    public Response deleteUploadInfos(@Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @PathParam(value="datasetId") String datasetId, String[] uploadIds) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Response errorResponse = this.verifyMatterAndDatasetPermissions(user, datasetId, Permission.MODIFY);
        if (errorResponse != null) {
            return errorResponse;
        }
        for (String uploadId : uploadIds) {
            UploadInfo uploadInfo = this.storageService.getUploadInfo(new UploadId(uploadId));
            if (uploadInfo == null || !uploadInfo.getLocationIdentifier().equals(datasetId)) {
                LOGGER.error("Skipping uploadId: " + uploadId + " because could not find or does not belong to dataset");
                continue;
            }
            if (this.tusFileUploadService.isLocked(uploadInfo)) {
                LOGGER.error("Skipping uploadId: " + uploadId + " because it is active");
                continue;
            }
            try {
                this.tusFileUploadService.deleteUpload(uploadInfo);
            }
            catch (TusException | IOException e) {
                LOGGER.error("Could not delete uploadInfo: " + uploadId);
            }
        }
        Dataset dataset = this.datasets.get(datasetId);
        DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
        dataset.setUsableSpace(this.datasetUtils.getDatasetUsableSpace(dataset));
        this.schedulerApplication.getDataRepositoryResource().updateUsableSpace(dataRepository);
        ResponseCache.getInstance().resetKeyId(CacheKey.MATTER_DATASETS, dataset.getMatterId());
        return this.getUploadInfos(user, request, datasetId, false);
    }

    @Operation(tags={"Dataset"}, operationId="GetFilteredUploadInfos", summary="Get Upload Infos With Filter", description="Get upload infos that match the query filter", responses={@ApiResponse(description="The filtered upload infos", content={@Content(array=@ArraySchema(schema=@Schema(implementation=UploadInfoModel.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @jakarta.ws.rs.Path(value="/uploadInfos")
    public Response getAllUploadInfos(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The file upload filter") FileUploadFilter fileUploadFilter) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.DATA_SET_UPLOAD_INFOS, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
            scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            boolean hasResourcesPermission = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), scopeIdentifiers).contains(Permission.VIEW);
            ArrayList<UploadInfoModel> uploadInfoModels = new ArrayList<UploadInfoModel>();
            for (UploadInfo uploadInfo : this.storageService.getUploadInfos()) {
                boolean hasDatasetPermissions;
                Matter matter;
                Dataset dataset;
                if (this.existsAndDoesNotContain(fileUploadFilter.getUsernames(), uploadInfo.getOwnerKey()) || this.existsAndDoesNotContain(fileUploadFilter.getDatasetIds(), uploadInfo.getLocationIdentifier()) || (dataset = this.datasets.get(uploadInfo.getLocationIdentifier())) == null || this.existsAndDoesNotContain(fileUploadFilter.getDataRepositoryIds(), dataset.getDataRepositoryId()) || this.existsAndDoesNotContain(fileUploadFilter.getMatterIds(), dataset.getMatterId()) || (matter = this.schedulerApplication.getClientResource().getMatter(dataset.getMatterId())) == null || this.existsAndDoesNotContain(fileUploadFilter.getClientIds(), matter.getClientId())) continue;
                boolean bl = hasDatasetPermissions = this.verifyMatterAndDatasetPermissions(user, uploadInfo.getLocationIdentifier(), Permission.VIEW) == null;
                if (!hasResourcesPermission && !hasDatasetPermissions) continue;
                UploadInfoModel uploadInfoModel = !hasDatasetPermissions ? new UploadInfoModel(uploadInfo, this.tusFileUploadService, true) : new UploadInfoModel(uploadInfo, this.tusFileUploadService);
                uploadInfoModel.setClientId(matter.getClientId());
                uploadInfoModel.setMatterId(matter.getId());
                uploadInfoModel.setDataRepositoryId(dataset.getDataRepositoryId());
                uploadInfoModels.add(uploadInfoModel);
            }
            uploadInfoModels.sort(Comparator.comparing(UploadInfoModel::getOwnerKey, String.CASE_INSENSITIVE_ORDER).thenComparing(DatasetResource::computeUniqueKey, String.CASE_INSENSITIVE_ORDER).thenComparing(UploadInfoModel::getRelativePath, String.CASE_INSENSITIVE_ORDER));
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(uploadInfoModels).build();
        }
    }

    public static String computeUniqueKey(UploadInfoModel info) {
        return info.getOwnerKey() + info.getClientIpAddresses() + info.getServerIpAddress() + info.getServerName() + info.getServerRole() + info.getClientId() + info.getMatterId() + info.getDatasetId() + info.getDataRepositoryId();
    }

    private <T> boolean existsAndDoesNotContain(Set<T> set, T val) {
        return set != null && set.size() != 0 && !set.contains(val);
    }

    @Operation(tags={"Dataset"}, operationId="GetFileUploadHistories", summary="Get File Upload Histories With Filter", description="Get file upload histories that match the query filter", responses={@ApiResponse(description="The filtered file upload histories", content={@Content(array=@ArraySchema(schema=@Schema(implementation=FileUploadHistory.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @jakarta.ws.rs.Path(value="/fileUploadHistory")
    public Response getFileUploadHistories(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The file upload filter") FileUploadFilter fileUploadFilter) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.DATA_SET_FILES, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            HashSet<String> datasetIds = new HashSet<String>();
            for (Client client : this.schedulerApplication.getClientResource().getClients()) {
                if (this.existsAndDoesNotContain(fileUploadFilter.getClientIds(), client.getId())) continue;
                for (Matter matter : this.schedulerApplication.getClientResource().getClientMatters(client.getId())) {
                    if (this.existsAndDoesNotContain(fileUploadFilter.getMatterIds(), matter.getId())) continue;
                    for (Dataset dataset : this.schedulerApplication.getClientResource().getMatterDatasets(matter.getId())) {
                        if (dataset.getType() != DatasetType.MANAGED || this.existsAndDoesNotContain(fileUploadFilter.getDatasetIds(), dataset.getId()) || this.existsAndDoesNotContain(fileUploadFilter.getDataRepositoryIds(), dataset.getDataRepositoryId()) || this.verifyMatterAndDatasetPermissions(user, dataset.getId(), Permission.VIEW) != null) continue;
                        datasetIds.add(dataset.getId());
                    }
                }
            }
            ArrayList<Object> fileUploadHistoryList = new ArrayList<Object>();
            if (datasetIds.size() > 0) {
                List<FileInfo> fileInfos = FileInfoCache.getInstance().getFileInfos(datasetIds, fileUploadFilter.getBeforeDate(), fileUploadFilter.getAfterDate());
                HashMap<String, FileUploadHistory> fileUploadHistories = new HashMap<String, FileUploadHistory>();
                for (FileInfo fileInfo : fileInfos) {
                    Dataset dataset;
                    if (this.existsAndDoesNotContain(fileUploadFilter.getUsernames(), fileInfo.getAddedBy())) continue;
                    dataset = this.datasets.get(fileInfo.getDatasetId());
                    Matter matter = this.schedulerApplication.getClientResource().getMatter(dataset.getMatterId());
                    String historyKey = FileUploadHistory.computeUniqueKey((FileInfo)fileInfo, (Dataset)dataset, (Matter)matter);
                    FileUploadHistory fileUploadHistory = fileUploadHistories.computeIfAbsent(historyKey, key -> new FileUploadHistory(fileInfo, dataset, matter));
                    fileUploadHistory.addFileInfo(fileInfo);
                }
                fileUploadHistoryList.addAll(new ArrayList(fileUploadHistories.values()));
            }
            fileUploadHistoryList.sort(Comparator.comparing(FileUploadHistory::getUsername, String.CASE_INSENSITIVE_ORDER).thenComparing(FileUploadHistory::getId, String.CASE_INSENSITIVE_ORDER));
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(fileUploadHistoryList).build();
        }
    }

    private BearerUser getUser(HttpServletRequest request, HttpServletResponse response, String authorizationHeaderName) throws IOException {
        try {
            if (authorizationHeaderName == null) {
                return this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request, true);
            }
            return this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request, authorizationHeaderName, true);
        }
        catch (AuthenticationResponseException e) {
            response.sendError(401);
            response.flushBuffer();
            return null;
        }
    }

    private BearerUser getUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.getUser(request, response, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @jakarta.ws.rs.Path(value="/{datasetId}/upload")
    public void processPost(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="datasetId") String datasetId) throws IOException {
        Object updatedRequest;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_UPLOAD);
        BearerUser user = this.getUser(request, response);
        if (user == null) {
            return;
        }
        if (user instanceof ApiBearerUser) {
            updatedRequest = request;
            user = this.getUser(request, response, "X-Forwarded-Authorization");
        } else {
            updatedRequest = new HttpServletRequestWrapper(request){

                public String getHeader(String name) {
                    switch (name) {
                        case "X-Forwarded-Authorization": 
                        case "X-Forwarded-Client-IP": 
                        case "X-Forwarded-Server-IP": 
                        case "X-Forwarded-Server-Name": 
                        case "X-Forwarded-Server-Role": {
                            return null;
                        }
                    }
                    return super.getHeader(name);
                }
            };
        }
        if (!this.verifyMatterAndDatasetPermissions(user, datasetId, response)) {
            response.flushBuffer();
            return;
        }
        Dataset dataset = this.datasets.get(datasetId);
        DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
        if (dataRepository.getType() != DatasetType.MANAGED) {
            response.setStatus(400);
            response.getWriter().write(this.iu.getString("Dataset.NotManaged"));
            response.flushBuffer();
            return;
        }
        if (dataRepository.getStatus().getCode() == State.ERROR) {
            response.setStatus(400);
            response.getWriter().write(this.iu.getFormattedString("DataRepositoryResource.ExceptionGettingUsableSpace", (Object)dataRepository.getStatus().getMessage()));
            response.flushBuffer();
            return;
        }
        Long uploadSize = Utils.getLongHeader(request, "Upload-Length");
        if (uploadSize == null) {
            response.setStatus(400);
            response.getWriter().write(this.iu.getString("Dataset.NullUploadSize"));
            response.flushBuffer();
            return;
        }
        Long uploadMaxSize = dataRepository.getUploadMaxSize();
        if (dataRepository.getUploadMaxSizeEnabled() == Boolean.TRUE && uploadMaxSize != null && uploadSize > uploadMaxSize) {
            response.setStatus(400);
            response.getWriter().write(this.iu.getFormattedString("Dataset.UploadSizeGreaterThanMaxSize", (Object[])new String[]{FormattingUtils.sizeToDisplaySize((long)uploadSize), FormattingUtils.sizeToDisplaySize((long)uploadMaxSize)}));
            response.flushBuffer();
            return;
        }
        UploadInfo temp = new UploadInfo();
        temp.setEncodedMetadata(Utils.getHeader(request, "Upload-Metadata"));
        Map<String, String> metadata = temp.getMetadata();
        String fileName = temp.getFileName(metadata);
        String relativePath = temp.getRelativePath(metadata);
        boolean overwrite = Boolean.parseBoolean(metadata.get("overwrite"));
        Path datasetDraftPath = this.datasetUtils.getDatasetDraftPath(dataset);
        Path draftFilePath = FileUtils.safeResolveParent((Path)datasetDraftPath, (String[])new String[]{relativePath});
        if (!overwrite && Files.exists(draftFilePath, new LinkOption[0])) {
            response.setStatus(400);
            response.getWriter().write(this.iu.getString("Dataset.FileExistsForName"));
            response.flushBuffer();
            return;
        }
        boolean activeUploadInfoWithSameRelativePathExists = false;
        for (UploadInfo uploadInfo : this.storageService.getUploadInfos()) {
            if (!datasetId.equals(uploadInfo.getLocationIdentifier()) || !uploadInfo.getRelativePath().equalsIgnoreCase(relativePath)) continue;
            if (uploadInfo.getState() == UploadInfoState.ACTIVE) {
                activeUploadInfoWithSameRelativePathExists = true;
                continue;
            }
            this.storageService.terminateUpload(uploadInfo);
        }
        if (activeUploadInfoWithSameRelativePathExists) {
            response.setStatus(400);
            response.getWriter().write(this.iu.getString("Dataset.UploadExistsForName"));
            response.flushBuffer();
            return;
        }
        Set allowedFileExtensions = dataRepository.getAllowedFileExtensions();
        String fileExtension = FilenameUtils.getExtension((String)fileName).toLowerCase();
        if (allowedFileExtensions != null && allowedFileExtensions.size() > 0 && !allowedFileExtensions.contains(fileExtension)) {
            response.setStatus(400);
            response.getWriter().write(this.iu.getFormattedString("Dataset.RestrictedFileExtension", (Object)fileExtension));
            response.flushBuffer();
            return;
        }
        DatasetResource datasetResource = this;
        synchronized (datasetResource) {
            UsableSpace repositoryUsableSpace = dataRepository.getUsableSpace();
            Long fileSystemUsableSpace = repositoryUsableSpace.getFileSystemUsableSpace();
            if (dataRepository.getComputeFileSystemUsableSpace() == Boolean.TRUE && fileSystemUsableSpace != null && uploadSize > fileSystemUsableSpace) {
                response.setStatus(400);
                response.getWriter().write(this.iu.getFormattedString("Dataset.NotEnoughDiskSpace", (Object[])new String[]{FormattingUtils.sizeToDisplaySize((long)uploadSize), FormattingUtils.sizeToDisplaySize((long)fileSystemUsableSpace)}));
                response.flushBuffer();
                return;
            }
            Long quotaUsableSpace = repositoryUsableSpace.getQuotaUsableSpace();
            Long datasetUsableSpace = dataset.getUsableSpace();
            Long usableSpace = dataRepository.getDatasetMaxSizeEnabled() != Boolean.TRUE ? quotaUsableSpace : (quotaUsableSpace == null ? datasetUsableSpace : Long.valueOf(Math.min(datasetUsableSpace, quotaUsableSpace)));
            if (usableSpace != null) {
                long oldFileSize = 0L;
                if (overwrite && Files.exists(draftFilePath, new LinkOption[0])) {
                    oldFileSize = Files.size(draftFilePath);
                    usableSpace = usableSpace + oldFileSize;
                }
                if (uploadSize > usableSpace) {
                    response.setStatus(400);
                    response.getWriter().write(this.iu.getFormattedString("Dataset.NotEnoughQuotaSpace", (Object[])new String[]{FormattingUtils.sizeToDisplaySize((long)uploadSize), FormattingUtils.sizeToDisplaySize((long)usableSpace)}));
                    response.flushBuffer();
                    return;
                }
                repositoryUsableSpace.takeSpace(uploadSize - oldFileSize);
                dataset.takeSpace(uploadSize - oldFileSize);
                ResponseCache.getInstance().resetKeyId(CacheKey.DATA_REPOSITORY, dataRepository.getId());
                ResponseCache.getInstance().resetKeyId(CacheKey.DATA_REPOSITORIES, "");
            }
        }
        final String uploadLocation = datasetDraftPath.getParent().toString();
        updatedRequest = new HttpServletRequestWrapper((HttpServletRequest)updatedRequest){

            public String getHeader(String name) {
                if (name.equals("Upload-Location")) {
                    return uploadLocation;
                }
                if (name.equals("Hash-Algorithm")) {
                    return DatasetResource.this.schedulerApplication.getConfiguration().getUploadHashAlgorithms();
                }
                return super.getHeader(name);
            }
        };
        try {
            this.processRequest(user, datasetId, (HttpServletRequest)updatedRequest, response);
        }
        finally {
            ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_UPLOAD_INFOS, datasetId);
            ResponseCache.getInstance().resetKeyId(CacheKey.DATA_SET_UPLOAD_INFOS, "");
        }
    }

    @PUT
    @jakarta.ws.rs.Path(value="/{datasetId}/upload/{id}")
    public void processUploadFinish(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="datasetId") String datasetId) throws IOException, TusException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        BearerUser user = this.getUser(request, response);
        if (user == null) {
            return;
        }
        if (!this.verifyMatterAndDatasetPermissions(user, datasetId, response)) {
            response.flushBuffer();
            return;
        }
        String ownerKey = user.getName();
        this.tusFileUploadService.finalizeUpload(datasetId, request.getRequestURI(), ownerKey, null);
    }

    @PUT
    @jakarta.ws.rs.Path(value="/{datasetId}/proxyUpload/{id}")
    public void processProxyUploadFinish(@Auth BearerUser user, @Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="datasetId") String datasetId, Map<String, String> hashes) throws IOException, TusException {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            response.setStatus(401);
            response.flushBuffer();
            return;
        }
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        String username = request.getHeader("X-Forwarded-For-User");
        this.tusFileUploadService.finalizeUpload(datasetId, request.getRequestURI().replace("proxyUpload", "upload"), username, hashes);
    }

    @OPTIONS
    @jakarta.ws.rs.Path(value="/{datasetId}/upload")
    public void processOptions(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="datasetId") String datasetId) throws IOException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        BearerUser user = this.getUser(request, response);
        if (user == null) {
            return;
        }
        this.processRequest(user, datasetId, request, response);
    }

    @HEAD
    @jakarta.ws.rs.Path(value="/{datasetId}/upload/{id}")
    public void processHead(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="datasetId") String datasetId) throws IOException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        BearerUser user = this.getUser(request, response);
        if (user == null) {
            return;
        }
        this.processRequest(user, datasetId, request, response);
    }

    @POST
    @jakarta.ws.rs.Path(value="/{datasetId}/upload/{id}")
    public void processPostWithId(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="datasetId") String datasetId) throws IOException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        BearerUser user = this.getUser(request, response);
        if (user == null) {
            return;
        }
        this.processRequest(user, datasetId, request, response);
    }

    @PATCH
    @jakarta.ws.rs.Path(value="/{datasetId}/upload/{id}")
    @Consumes(value={"*/*"})
    public void processPatch(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="datasetId") String datasetId) throws IOException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        BearerUser user = this.getUser(request, response);
        if (user == null) {
            return;
        }
        this.processRequest(user, datasetId, request, response);
    }

    @DELETE
    @jakarta.ws.rs.Path(value="/{datasetId}/upload/{id}")
    public void processDelete(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="datasetId") String datasetId) throws IOException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        BearerUser user = this.getUser(request, response);
        if (user == null) {
            return;
        }
        this.processRequest(user, datasetId, request, response);
    }

    private void processRequest(BearerUser user, String datasetId, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.verifyMatterAndDatasetPermissions(user, datasetId, response)) {
            response.flushBuffer();
            return;
        }
        String ownerKey = user.getName();
        this.tusFileUploadService.process(request, response, ownerKey);
    }

    private void trackFinalizedDataSetUtilization(Dataset dataset, Collection<FileInfo> fileInfos) {
        DataSet utilizationDataSet = new DataSet();
        utilizationDataSet.setDataSetId(dataset.getId());
        utilizationDataSet.setDataSetName(dataset.getName());
        utilizationDataSet.setMatterId(dataset.getMatterId());
        utilizationDataSet.setDataSetType(DataSetType.valueOf((String)dataset.getType().name()));
        utilizationDataSet.setDataRepositoryId(dataset.getDataRepositoryId());
        UtilizationDao utilization = null;
        utilization = this.schedulerApplication.getUtilizationDaoV2();
        utilization.addDataSet(utilizationDataSet);
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<DataSet> dataSets = new HashSet<DataSet>();
        utilizationRecords.setDataSets(dataSets);
        dataSets.add(utilizationDataSet);
        HashSet<TransferVolume> transferVolumes = new HashSet<TransferVolume>();
        HashMap<String, Transfer> transfersByUser = new HashMap<String, Transfer>();
        HashMap<String, ActivityDetails> activityDetailsByUser = new HashMap<String, ActivityDetails>();
        HashMap<String, Long> transferDurations = new HashMap<String, Long>();
        HashMap transferVolumesByExtension = new HashMap();
        AutomateLicenceModel automateLicense = this.schedulerApplication.getAutomateLicenceResource().getRampivaLicence();
        LicenceInfo licenceInfo = automateLicense.getLicenceInfo();
        String legalHoldNoticeUsername = null;
        NoticeEvent noticeEvent = null;
        Object legalHold = null;
        Object target = null;
        for (FileInfo fileInfo : fileInfos) {
            String extension;
            TransferVolume transferVolume;
            HashMap<String, TransferVolume> transferVolumesByTransferId;
            if (fileInfo.getDirectory() == Boolean.TRUE) continue;
            if (noticeEvent == null && dataset.getNoticeEventId() != null && (noticeEvent = this.schedulerApplication.getSchedulerConfigurationDao().getNoticeNoticeEvent(dataset.getNoticeEventId())) != null) {
                UserAccount legalHoldUser = this.schedulerApplication.getUserServiceResource().getUser(noticeEvent.getUserId());
                legalHoldNoticeUsername = legalHoldUser.getName();
            }
            String username = fileInfo.getAddedBy();
            if (legalHoldNoticeUsername != null) {
                username = legalHoldNoticeUsername;
            }
            Transfer transfer2 = (Transfer)transfersByUser.get(username);
            ActivityDetails activityDetails = (ActivityDetails)activityDetailsByUser.get(username);
            if (transfer2 == null) {
                transfer2 = new Transfer();
                transfer2.setTransferId(UidUtils.getRandom());
                transfersByUser.put(username, transfer2);
                transfer2.setTransferType(TransferType.DATA_UPLOAD);
                ActivityType activityType = ActivityType.DATA_UPLOAD;
                if (noticeEvent != null) {
                    this.schedulerApplication.getNoticeUtils().trackDataSetUtilization(transfer2, noticeEvent);
                    activityType = ActivityType.LEGAL_HOLD_UPLOAD;
                }
                transfer2.setDataSetId(utilizationDataSet.getDataSetId());
                if (licenceInfo != null) {
                    transfer2.setLicenseId(licenceInfo.getId());
                }
                transferDurations.put(transfer2.getTransferId(), 0L);
                activityDetails = new ActivityDetails();
                activityDetails.setActivityType(activityType);
                String userId = User.getIdFromName((String)username, (String)this.schedulerApplication.getSettingsResource().getDiagnosticKey().getSecret());
                activityDetails.setUserId(userId);
                activityDetails.setMatterId(dataset.getMatterId());
                activityDetails.setActivityKey(transfer2.getActivityKey());
                activityDetailsByUser.put(username, activityDetails);
            }
            if ((transferVolumesByTransferId = (HashMap<String, TransferVolume>)transferVolumesByExtension.get(transfer2.getTransferId())) == null) {
                transferVolumesByTransferId = new HashMap<String, TransferVolume>();
                transferVolumesByExtension.put(transfer2.getTransferId(), transferVolumesByTransferId);
            }
            if ((transferVolume = (TransferVolume)transferVolumesByTransferId.get(extension = FileNameUtils.getFilenameKnownExtension(fileInfo.getName()))) == null) {
                transferVolume = new TransferVolume();
                transferVolume.setFileExtension(extension);
                transferVolume.setTransferId(transfer2.getTransferId());
                transferVolumesByTransferId.put(extension, transferVolume);
                transferVolumes.add(transferVolume);
            }
            transferVolume.addItemsCount(1L);
            transferVolume.addFileSize(fileInfo.getSize());
            long fileStartEpoch = fileInfo.getAddedDate() - fileInfo.getUploadDuration();
            long fileEndEpoch = fileInfo.getAddedDate();
            if (transfer2.getTransferStartEpoch() == 0L || transfer2.getTransferStartEpoch() > fileStartEpoch) {
                transfer2.setTransferStartEpoch(fileStartEpoch);
            }
            if (transfer2.getTransferEndEpoch() == 0L || transfer2.getTransferEndEpoch() < fileEndEpoch) {
                transfer2.setTransferEndEpoch(fileEndEpoch);
            }
            if (activityDetails.getStartEpoch() == 0L || activityDetails.getStartEpoch() > fileStartEpoch) {
                activityDetails.setStartEpoch(fileStartEpoch);
            }
            if (activityDetails.getLastEpoch() == 0L || activityDetails.getLastEpoch() < fileEndEpoch) {
                activityDetails.setLastEpoch(fileEndEpoch);
            }
            transfer2.setFilesCount(transfer2.getFilesCount() + 1L);
            transfer2.setTransferVolume(transfer2.getTransferVolume() + fileInfo.getSize());
            transferDurations.put(transfer2.getTransferId(), (Long)transferDurations.get(transfer2.getTransferId()) + fileInfo.getUploadDuration());
        }
        HashSet<Transfer> transfers = new HashSet<Transfer>();
        for (String user : transfersByUser.keySet()) {
            Transfer transfer = (Transfer)transfersByUser.get(user);
            double durationSeconds = (double)((Long)transferDurations.get(transfer.getTransferId())).longValue() / 1000.0;
            if (durationSeconds == 0.0) {
                durationSeconds = 1.0;
            }
            double transferSpeed = (double)transfer.getTransferVolume() / durationSeconds;
            transfer.setTransferSpeed(transferSpeed);
            transfers.add(transfer);
        }
        HashSet hashSet = new HashSet();
        for (ActivityDetails activityDetails : activityDetailsByUser.values()) {
            this.schedulerApplication.getUserResource().trackFinishedActivity(activityDetails);
        }
        hashSet.addAll(activityDetailsByUser.values());
        for (Transfer transfer : transfers) {
            this.schedulerApplication.getUtilizationDaoV2().addTransfer(transfer);
        }
        for (TransferVolume transferVolume : transferVolumes) {
            this.schedulerApplication.getUtilizationDaoV2().addTransferVolume(transferVolume);
        }
        utilizationRecords.setActivityDetails(hashSet);
        utilizationRecords.setTransfers(transfers);
        utilizationRecords.setTransferVolumes(transferVolumes);
        this.schedulerApplication.getAutomateLicenceResource().getLicenceSession().tryTrackUtilizationRecordsAsync(utilizationRecords);
    }

    private Response finalizeDataset(BearerUser user, Dataset dataset, boolean force, String remoteAddress) {
        Response errorResponse;
        String datasetId = dataset.getId();
        DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
        Map<String, FileInfo> relativePathToFileInfo = FileInfoCache.getInstance().getDatasetFileInfos(datasetId).stream().collect(Collectors.toMap(FileInfo::getRelativePath, fileInfo -> fileInfo));
        switch (dataRepository.getType()) {
            case MANAGED: {
                errorResponse = this.verifyActiveIdleUploads(datasetId, force);
                if (errorResponse != null) {
                    return errorResponse;
                }
                errorResponse = this.verifyManagedDatasetIntegrity(user, dataset, relativePathToFileInfo, remoteAddress);
                if (errorResponse == null) break;
                return errorResponse;
            }
            case IN_PLACE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("DatasetType not yet implemented");
            }
        }
        if ((errorResponse = this.verifyDatasetMetadata(dataset, relativePathToFileInfo)) != null) {
            return errorResponse;
        }
        switch (dataRepository.getType()) {
            case MANAGED: {
                try {
                    org.apache.commons.io.FileUtils.deleteDirectory((File)this.datasetUtils.getDatasetInProgressPath(dataset).toFile());
                    Path datasetDraftPath = this.datasetUtils.getDatasetDraftPath(dataset);
                    Path datasetFinalPath = this.datasetUtils.getDatasetFinalPath(dataset);
                    Files.move(datasetDraftPath, datasetFinalPath, new CopyOption[0]);
                    this.trackFinalizedDataSetUtilization(dataset, relativePathToFileInfo.values());
                    break;
                }
                catch (IOException e) {
                    LOGGER.error("Error finalizing dataset", (Throwable)e);
                    String eventDetails = this.iu.getFormattedString("DatasetResource.AuditLog.Error.Operation", (Object)EventType.Type.DATA_SET_FINALIZED) + "\n" + this.iu.getFormattedString("DatasetResource.AuditLog.Error.Message", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                    this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), dataset.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.DATA_SET_ERROR, eventDetails, remoteAddress));
                    this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_SET_ERROR, dataset, user.getName());
                    return ExceptionUtils.toResponse((String)"renameDraftToFinalError", (Exception)e);
                }
            }
            case IN_PLACE: {
                this.trackFinalizedDataSetUtilization(dataset, relativePathToFileInfo.values());
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Response verifyManagedDatasetIntegrity(BearerUser user, Dataset dataset, Map<String, FileInfo> relativePathToFileInfo, String remoteAddress) {
        try {
            Path datasetPath = this.datasetUtils.getDatasetPath(dataset);
            try (Stream<Path> datasetList = Files.list(datasetPath);){
                List datasetFolderPaths = datasetList.collect(Collectors.toList());
                boolean onlyContainsDraftAndProgress = datasetFolderPaths.stream().allMatch(path -> {
                    String fileName = path.getFileName().toString();
                    return Files.isDirectory(path, new LinkOption[0]) && (fileName.equals("Draft") || fileName.equals("InProgress"));
                });
                if (!(dataset.getType() == DatasetType.ECC || datasetFolderPaths.size() != 0 && onlyContainsDraftAndProgress)) {
                    LOGGER.error("Cannot finalize, Data Set contains files and/or folders other than the Draft and InProgress folders");
                    String eventDetails = this.iu.getFormattedString("DatasetResource.AuditLog.Error.Operation", (Object)EventType.Type.DATA_SET_FINALIZED) + "\n" + this.iu.getFormattedString("DatasetResource.AuditLog.Error.Message", (Object)"Unexpected folders detected in the Data Set");
                    this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), dataset.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.DATA_SET_ERROR, eventDetails, remoteAddress));
                    this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_SET_ERROR, dataset, user.getName());
                    Response response = ExceptionUtils.toResponse((String)"datasetUnexpectedInDirectory");
                    return response;
                }
            }
            ArrayList<String> missingFilePaths = new ArrayList<String>();
            ArrayList<String> unexpectedFilePaths = new ArrayList<String>();
            ArrayList<String> unexpectedFileSizes = new ArrayList<String>();
            Path datasetDraftPath = FileUtils.safeResolve((Path)datasetPath, (String)"Draft");
            try (Stream<Path> draftFilePathStream = Files.walk(datasetDraftPath, new FileVisitOption[0]);){
                Iterator it = draftFilePathStream.iterator();
                it.next();
                while (it.hasNext()) {
                    long actualSize;
                    Path draftFilePath = (Path)it.next();
                    if (!Files.isRegularFile(draftFilePath, new LinkOption[0])) continue;
                    String relativePath = datasetDraftPath.relativize(draftFilePath).toString();
                    FileInfo fileInfo = relativePathToFileInfo.get(relativePath);
                    if (fileInfo == null) {
                        unexpectedFilePaths.add(relativePath);
                        continue;
                    }
                    long expectedSize = fileInfo.getSize();
                    if (expectedSize == (actualSize = Files.size(draftFilePath))) continue;
                    String expected = FormattingUtils.sizeToDisplaySize((long)expectedSize);
                    String actual = FormattingUtils.sizeToDisplaySize((long)actualSize);
                    unexpectedFileSizes.add(this.iu.getFormattedString("Dataset.UnexpectedFileSize", (Object[])new String[]{relativePath, expected, actual}));
                }
            }
            for (FileInfo fileInfo : relativePathToFileInfo.values()) {
                String relativePath = fileInfo.getRelativePath();
                Path draftFilePath = datasetDraftPath.resolve(relativePath);
                if (Files.exists(draftFilePath, new LinkOption[0])) continue;
                missingFilePaths.add(relativePath);
            }
            String errorKey = null;
            Object errorMessage = null;
            HashMap<String, String> values = null;
            if (missingFilePaths.size() > 0) {
                values = new HashMap<String, String>();
                values.put("fileNames", String.join((CharSequence)"\n", missingFilePaths));
                errorMessage = this.iu.getFormattedString("Dataset.MissingDraftFile", (Object)String.join((CharSequence)", ", missingFilePaths));
                errorKey = "datasetMissingFiles";
            }
            if (unexpectedFilePaths.size() > 0) {
                values = new HashMap();
                values.put("fileNames", String.join((CharSequence)"\n", unexpectedFilePaths));
                errorMessage = this.iu.getFormattedString("Dataset.UnexpectedDraftFile", (Object)String.join((CharSequence)", ", unexpectedFilePaths));
                errorKey = "datasetUnexpectedFiles";
            }
            if (unexpectedFileSizes.size() > 0) {
                values = new HashMap();
                values.put("unexpectedFileSizes", String.join((CharSequence)"\n", unexpectedFileSizes));
                errorMessage = "Found file size mismatches: " + String.join((CharSequence)", ", unexpectedFileSizes);
                errorKey = "datasetUnexpectedFileSizes";
            }
            if (errorKey == null) return null;
            String eventDetails = this.iu.getFormattedString("DatasetResource.AuditLog.Error.Operation", (Object)EventType.Type.DATA_SET_FINALIZED) + "\n" + this.iu.getFormattedString("DatasetResource.AuditLog.Error.Message", errorMessage);
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), dataset.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.DATA_SET_ERROR, eventDetails, remoteAddress));
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_SET_ERROR, dataset, user.getName());
            LOGGER.error((String)errorMessage);
            if (dataset.getType() != DatasetType.ECC) return ExceptionUtils.toResponse((String)errorKey, values);
            return null;
        }
        catch (IOException e) {
            LOGGER.error("Error finalizing dataset", (Throwable)e);
            String eventDetails = this.iu.getFormattedString("DatasetResource.AuditLog.Error.Operation", (Object)EventType.Type.DATA_SET_FINALIZED) + "\n" + this.iu.getFormattedString("DatasetResource.AuditLog.Error.Message", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), dataset.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.DATA_SET_ERROR, eventDetails, remoteAddress));
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.DATA_SET_ERROR, dataset, user.getName());
            if (dataset.getType() != DatasetType.ECC) return ExceptionUtils.toResponse((String)"datasetErrorVerifyingIntegrity", (Exception)e);
            return null;
        }
    }

    private Response verifyDatasetMetadata(Dataset dataset, Map<String, FileInfo> relativePathToFileInfo) {
        Map<String, Set<String>> requiredMetadataHeaders = this.datasetUtils.getRequiredMetadataHeaders(dataset);
        if (requiredMetadataHeaders.size() > 0) {
            ArrayList<String> datasetMetadataHeaders = new ArrayList<String>();
            if (dataset.getFileMetadataHeaders() != null) {
                datasetMetadataHeaders.addAll(dataset.getFileMetadataHeaders());
            }
            ArrayList<Integer> requiredHeaderIndices = new ArrayList<Integer>();
            for (String requiredHeader : requiredMetadataHeaders.keySet()) {
                int index = datasetMetadataHeaders.indexOf(requiredHeader);
                if (index < 0) {
                    datasetMetadataHeaders.add(requiredHeader);
                    index = datasetMetadataHeaders.size() - 1;
                }
                requiredHeaderIndices.add(index);
            }
            ExecutorService regexExecutor = Executors.newFixedThreadPool(2);
            ArrayList regexFutures = new ArrayList();
            Map fileErrorsMap = Collections.synchronizedMap(new HashMap());
            for (FileInfo fileInfo : relativePathToFileInfo.values()) {
                ArrayList<String> fileMetadata = new ArrayList<String>();
                if (fileInfo.getMetadata() != null) {
                    fileMetadata.addAll(fileInfo.getMetadata());
                }
                while (fileMetadata.size() < requiredHeaderIndices.size()) {
                    fileMetadata.add("");
                }
                Iterator iterator = requiredHeaderIndices.iterator();
                while (iterator.hasNext()) {
                    int requiredHeaderIndex = (Integer)iterator.next();
                    String metadata = (String)fileMetadata.get(requiredHeaderIndex);
                    String requiredHeader = (String)datasetMetadataHeaders.get(requiredHeaderIndex);
                    Set<String> regexps = requiredMetadataHeaders.get(requiredHeader);
                    boolean empty = regexps.stream().allMatch(regex -> regex == null || regex.length() == 0);
                    if (empty) continue;
                    regexFutures.add(regexExecutor.submit(() -> {
                        boolean matches = regexps.stream().allMatch(regex -> {
                            try {
                                return Pattern.matches(regex, (CharSequence)new InterruptibleCharSequence((CharSequence)metadata));
                            }
                            catch (Exception e) {
                                LOGGER.info("Exception matching regex", (Throwable)e);
                                return false;
                            }
                        });
                        if (!matches) {
                            Set invalidValues = fileErrorsMap.computeIfAbsent(fileInfo.getRelativePath(), k -> new HashSet());
                            invalidValues.add(requiredHeader);
                        }
                    }));
                }
            }
            for (Future future : regexFutures) {
                try {
                    future.get(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    LOGGER.info("Regex matching task exception", (Throwable)e);
                }
                if (future.isDone()) continue;
                future.cancel(true);
            }
            regexExecutor.shutdown();
            if (fileErrorsMap.keySet().size() > 0) {
                final StringBuilder sb = new StringBuilder();
                for (String relativePath : fileErrorsMap.keySet()) {
                    String invalidMetadataString = this.iu.getFormattedString("Dataset.InvalidMetadata", new Object[]{relativePath, String.join((CharSequence)", ", (Iterable)fileErrorsMap.get(relativePath))});
                    sb.append("  ").append("\u2022 ").append(invalidMetadataString).append("\n");
                }
                return ExceptionUtils.toResponse((String)"filesMetadataErrors", (Map)new HashMap<String, String>(){
                    {
                        this.put("fileErrors", sb.toString());
                    }
                });
            }
        }
        return null;
    }

    public Set<String> getNamesOfJobsUsingDataset(BearerUser user, String datasetId) {
        TreeSet<String> jobNames = new TreeSet<String>();
        List<JobDetailsModel> nonFinishedJobsUsingDataSet = this.schedulerApplication.getJobResource().getNonFinishedJobsUsingDataSet(datasetId);
        if (nonFinishedJobsUsingDataSet.size() == 0) {
            return jobNames;
        }
        if (user == null) {
            jobNames.add(this.iu.getString("Job.Name.Other"));
        } else {
            for (JobDetailsModel jobDetailsModel : nonFinishedJobsUsingDataSet) {
                JobModel jobModel = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissionsInternal(user, jobDetailsModel.getSettings());
                if (jobModel.getUserPermissions().contains(Permission.VIEW)) {
                    jobNames.add(jobModel.getName());
                    continue;
                }
                jobNames.add(this.iu.getString("Job.Name.Other"));
            }
        }
        return jobNames;
    }

    private Response verifyNotUsedInJobs(BearerUser user, String datasetId) {
        Set<String> jobNames = this.getNamesOfJobsUsingDataset(user, datasetId);
        if (jobNames.size() == 0) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("jobNames", String.join((CharSequence)", ", jobNames));
        if (jobNames.size() == 1) {
            return ExceptionUtils.toResponse((String)"errorDeletingDataSetUsedByJob", properties);
        }
        return ExceptionUtils.toResponse((String)"errorDeletingDataSetUsedByJobs", properties);
    }

    private Response verifyActiveIdleUploads(String datasetId, boolean force) {
        HashMap<String, String> values;
        List<UploadInfo> datasetUploadInfos = this.storageService.getDatasetUploadInfos(datasetId);
        int activeUploads = 0;
        int idleUploads = 0;
        for (UploadInfo uploadInfo : datasetUploadInfos) {
            if (!uploadInfo.isUploadInProgress()) continue;
            if (uploadInfo.getState() == UploadInfoState.ACTIVE || this.tusFileUploadService.isLocked(uploadInfo)) {
                ++activeUploads;
                continue;
            }
            ++idleUploads;
        }
        if (activeUploads > 0) {
            values = new HashMap<String, String>();
            values.put("count", String.valueOf(activeUploads));
            return ExceptionUtils.toResponse((String)"datasetHasActiveUploads", values);
        }
        if (idleUploads > 0 && !force) {
            values = new HashMap();
            values.put("count", String.valueOf(idleUploads));
            return ExceptionUtils.toResponse((String)"datasetHasIdleUploads", values);
        }
        for (UploadInfo uploadInfo : datasetUploadInfos) {
            try {
                this.tusFileUploadService.deleteUpload(uploadInfo);
            }
            catch (TusException | IOException e) {
                LOGGER.error("Failed to delete upload: " + String.valueOf(uploadInfo));
            }
        }
        return null;
    }

    private boolean verifyMatterAndDatasetPermissions(BearerUser user, String datasetId, HttpServletResponse response) throws IOException {
        Set<Permission> noticeDatasetPermissions;
        Dataset dataset = this.datasets.get(datasetId);
        if (dataset == null) {
            response.setStatus(404);
            response.getWriter().write(this.iu.getFormattedString("Dataset.CannotFind", (Object)datasetId));
            return false;
        }
        String dataRepositoryId = dataset.getDataRepositoryId();
        DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataRepositoryId);
        if (dataRepository == null) {
            response.setStatus(404);
            response.getWriter().write(this.iu.getFormattedString("DataRepository.CannotFind", (Object)dataRepositoryId));
            return false;
        }
        String matterId = dataset.getMatterId();
        Matter matter = this.schedulerApplication.getClientResource().getMatter(matterId);
        if (matter == null) {
            response.setStatus(404);
            response.getWriter().write(this.iu.getFormattedString("Matter.CannotFind", (Object)matterId));
            return false;
        }
        Set datasetPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, dataset).getUserPermissions();
        if (!datasetPermissions.contains(Permission.MODIFY) && !(noticeDatasetPermissions = this.schedulerApplication.getSecurityPolicyUtil().getNoticeDatasetPermissions(user, dataset)).contains(Permission.RESPOND)) {
            response.setStatus(403);
            response.getWriter().write(this.iu.getString("User.DoesNotHavePermissions"));
            return false;
        }
        if (!dataRepository.isCompatible(dataset)) {
            response.setStatus(400);
            response.getWriter().write(this.iu.getString("Dataset.IncompatibleWithDataRepository"));
            return false;
        }
        if (!dataset.isDraft()) {
            response.setStatus(400);
            response.getWriter().write(this.iu.getString("Dataset.NotFinalized"));
            return false;
        }
        return true;
    }

    private Response verifyMatterAndDatasetPermissions(BearerUser user, String datasetId, Permission permission) {
        return this.verifyMatterAndDatasetPermissions(user, datasetId, permission, false);
    }

    private Response verifyMatterAndDatasetPermissions(BearerUser user, final String datasetId, Permission permission, boolean ignoreNoticePermissions) {
        final Dataset dataset = this.datasets.get(datasetId);
        if (dataset == null) {
            return ExceptionUtils.toResponse((String)"cannotFindDataset", (Map)new HashMap<String, String>(){
                {
                    this.put("datasetId", datasetId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(dataset.getDataRepositoryId());
        if (dataRepository == null) {
            return ExceptionUtils.toResponse((String)"cannotFindDataRepository", (Map)new HashMap<String, String>(){
                {
                    this.put("dataRepositoryId", dataset.getDataRepositoryId());
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Matter matter = this.schedulerApplication.getClientResource().getMatter(dataset.getMatterId());
        if (matter == null) {
            return ExceptionUtils.toResponse((String)"cannotFindMatter", (Map)new HashMap<String, String>(){
                {
                    this.put("matterId", dataset.getMatterId());
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Set datasetPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, dataset).getUserPermissions();
        if (!(user instanceof SystemBearerUser) && !datasetPermissions.contains(permission)) {
            boolean hasNoticePermission = false;
            if (!ignoreNoticePermissions) {
                Set<Permission> noticeDatasetPermissions = this.schedulerApplication.getSecurityPolicyUtil().getNoticeDatasetPermissions(user, dataset);
                switch (permission) {
                    case MODIFY: {
                        hasNoticePermission = DatasetState.DRAFT.equals((Object)dataset.getState()) && noticeDatasetPermissions.contains(Permission.RESPOND);
                        break;
                    }
                    case VIEW: {
                        boolean bl = hasNoticePermission = noticeDatasetPermissions.contains(Permission.RESPOND) || noticeDatasetPermissions.contains(Permission.MANAGE) || noticeDatasetPermissions.contains(Permission.VIEW);
                    }
                }
            }
            if (!hasNoticePermission) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)datasetId);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
            }
        }
        if (!dataRepository.isCompatible(dataset)) {
            return ExceptionUtils.toResponse((String)"datasetIncompatibleWithDataRepository", (Response.Status)Response.Status.BAD_REQUEST);
        }
        return null;
    }

    private static class DatasetRestrictions {
        private List<String> duplicatePaths = new ArrayList<String>();
        private List<String> invalidExtensionPaths = new ArrayList<String>();

        DatasetRestrictions() {
        }

        public List<String> getDuplicatePaths() {
            return this.duplicatePaths;
        }

        public void setDuplicatePaths(List<String> duplicatePaths) {
            this.duplicatePaths = duplicatePaths;
        }

        public List<String> getInvalidExtensionPaths() {
            return this.invalidExtensionPaths;
        }

        public void setInvalidExtensionPaths(List<String> invalidExtensionPaths) {
            this.invalidExtensionPaths = invalidExtensionPaths;
        }
    }

    public static class DatasetStatusWrapper {
        private final Dataset dataset;
        private final Status status;

        DatasetStatusWrapper(Dataset dataset) {
            this.dataset = dataset;
            this.status = new Status();
        }

        public Dataset getDataset() {
            return this.dataset;
        }

        public Status getStatus() {
            return this.status;
        }
    }
}

