/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.scheduler.security.bearer.SystemBearerUser;
import com.nuix.automate.utils.api.configuration.Setting;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileLibraryUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.ResponseUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.SortingUtils;
import com.nuix.automate.utils.general.SystemUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.executionprofile.AdditionalFile;
import com.nuix.automate.utils.models.api.executionprofile.AdditionalFiles;
import com.nuix.automate.utils.models.api.executionprofile.ExecutionProfileSubmission;
import com.nuix.automate.utils.models.api.executionprofile.JobProgressSettings;
import com.nuix.automate.utils.models.api.executionprofile.JobTimeoutSettings;
import com.nuix.automate.utils.models.api.executionprofile.NuixProfiles;
import com.nuix.automate.utils.models.api.filelibrary.FileLibrary;
import com.nuix.automate.utils.models.api.filelibrary.FileLibraryFile;
import com.nuix.automate.utils.models.api.filelibrary.LibraryNuixFileType;
import com.nuix.automate.utils.models.api.general.ConciseObject;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.user.UserSettings;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.executionprofile.WorkerTempFolder;
import com.nuix.automate.utils.resources.Versionable;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.utilization.ExecutionProfile;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.StaticParameter;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Path(value="/v1/scheduler/resources/executionProfiles")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ExecutionProfileResource
extends Versionable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ExecutionProfileResource.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;
    private Map<String, ExecutionProfileModel> executionProfiles;

    public ExecutionProfileResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.executionProfiles = new LinkedHashMap<String, ExecutionProfileModel>();
        this.initializeExecutionProfilesFromConfiguration();
        this.initializeExecutionProfilesFromStore();
        this.resetVersion();
    }

    public ExecutionProfileModel getExecutionProfile(String id) {
        ExecutionProfileModel executionProfile = this.executionProfiles.get(id);
        return executionProfile;
    }

    public ExecutionProfileModel createDefaultExecutionProfile() {
        ExecutionProfileModel executionProfileModel = new ExecutionProfileModel();
        executionProfileModel.getStatus().reset();
        executionProfileModel.setId("1000947c-0001-4825-8f3f-f1a071e1dcf8");
        executionProfileModel.setName("Default Profile");
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        this.schedulerApplication.getConfiguration();
        if (SchedulerConfiguration.getOsWindows()) {
            executionProfileModel.setDescription("This profile allocates 16GB of memory to the Nuix Engine and redirects the logs to C:\\Temp\\logs.");
            executionProfileModel.setEngineCommandLineParameters("-Xmx16g -Dnuix.logdir=c:\\Temp\\logs -Duser.language=en -Duser.country=US");
            parameters.put("{base_data_folder}", "C:\\Data");
            parameters.put("{base_case_folder}", "C:\\Cases");
            executionProfileModel.setEngineLogFolder("C:\\Temp\\Logs");
            executionProfileModel.setNuixEngineFolder(SystemUtils.getProgramFilesDir() + "\\Nuix\\Nuix Engine");
        } else {
            executionProfileModel.setDescription("This profile allocates 16GB of memory to the Nuix Engine and redirects the logs to /var/log/nuix/automate");
            executionProfileModel.setEngineCommandLineParameters("-Xmx16g -Dnuix.logdir=/var/log/nuix/automate");
            parameters.put("{base_data_folder}", "/mnt/source-data");
            parameters.put("{base_case_folder}", "/mnt/cases");
            executionProfileModel.setEngineLogFolder("/var/log/nuix/automate");
            executionProfileModel.setNuixEngineFolder("/opt/nuix/engine");
        }
        JobProgressSettings jobProgressSettings = new JobProgressSettings();
        jobProgressSettings.setUpdateOperationsProgressWeightLastRunWeightPercentage(Double.valueOf(33.0));
        executionProfileModel.setJobProgressSettings(jobProgressSettings);
        executionProfileModel.setWorkflowParameters(parameters);
        executionProfileModel.setNuixEngineFolder(this.schedulerApplication.getConfiguration().getNuixEnginePath());
        JobTimeoutSettings jobTimeoutSettings = new JobTimeoutSettings();
        jobTimeoutSettings.setJobProgressMinPercentage(null);
        jobTimeoutSettings.setJobProgressTimeoutHours(null);
        jobTimeoutSettings.setOperationProgressMinPercentage(Double.valueOf(1.0));
        jobTimeoutSettings.setOperationProgressTimeoutHours(Double.valueOf(24.0));
        jobTimeoutSettings.setSkipOperationProgressMinPercentage(null);
        jobTimeoutSettings.setSkipOperationProgressMinPercentage(null);
        executionProfileModel.setJobTimeoutSettings(jobTimeoutSettings);
        HashMap nuixProfiles = new HashMap();
        executionProfileModel.setNuixProfiles(nuixProfiles);
        HashMap additionalFiles = new HashMap();
        executionProfileModel.setAdditionalFiles(additionalFiles);
        this.executionProfiles.put(executionProfileModel.getId(), executionProfileModel);
        this.schedulerApplication.getSchedulerConfigurationDao().addExecutionProfile(executionProfileModel);
        return executionProfileModel;
    }

    public void updateExecutionProfilesCertificateFingerprints() {
        for (ExecutionProfileModel executionProfileModel : this.executionProfiles.values()) {
            executionProfileModel.setSchedulerCertFingeprint(this.schedulerApplication.getConfiguration().getLoopbackFingerprint());
        }
        this.resetVersion();
    }

    public void initializeExecutionProfilesFromConfiguration() {
        ExecutionProfileModel executionProfile = this.schedulerApplication.getConfiguration().getExecutionProfile();
        if (executionProfile != null) {
            this.executionProfiles.put(executionProfile.getId(), executionProfile);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void initializeExecutionProfilesFromStore() {
        LOGGER.info("Initializing Execution Profiles from store");
        List<ExecutionProfileModel> executionProfiles = this.schedulerApplication.getSchedulerConfigurationDao().getExecutionProfiles();
        for (ExecutionProfileModel executionProfileModel : executionProfiles) {
            FileLibrary library = null;
            boolean didUpdate = false;
            HashMap<String, FileLibraryFile> existingFiles = new HashMap<String, FileLibraryFile>();
            if (executionProfileModel.getNuixProfiles() != null && executionProfileModel.getNuixProfiles().containsKey("UPDATE_V1")) {
                FileLibraryFile addedFile;
                FileLibraryFile file;
                NuixProfiles nuixProfiles = (NuixProfiles)SerializationUtils.fromJson((String)((String)executionProfileModel.getNuixProfiles().get("UPDATE_V1")), NuixProfiles.class);
                HashMap<String, String> updatedNuixProfiles = new HashMap<String, String>();
                if (nuixProfiles.getConfigurationProfiles() != null) {
                    for (Map.Entry entry : nuixProfiles.getConfigurationProfiles().entrySet()) {
                        file = this.addLibraryFile((String)entry.getKey(), (String)entry.getValue(), LibraryNuixFileType.CONFIGURATION_PROFILE, existingFiles);
                        if (file.getFileLibraryId() == null) {
                            if (library == null) {
                                library = this.addFileLibrary(executionProfileModel.getName() + "-File Library", "The file library automatically created during migration for the execution profile " + executionProfileModel.getName() + ".", "N/A");
                            }
                            file.setFileLibraryId(library.getId());
                            addedFile = this.schedulerApplication.getFileLibraryResource().addLibraryFileInternalSystem(file.getFileLibraryId(), file, "N/A");
                            existingFiles.put(addedFile.getId(), addedFile);
                        }
                        updatedNuixProfiles.put((String)entry.getKey(), file.getId());
                    }
                }
                if (nuixProfiles.getImagingProfiles() != null) {
                    for (Map.Entry entry : nuixProfiles.getImagingProfiles().entrySet()) {
                        file = this.addLibraryFile((String)entry.getKey(), (String)entry.getValue(), LibraryNuixFileType.IMAGING_PROFILE, existingFiles);
                        if (file.getFileLibraryId() == null) {
                            if (library == null) {
                                library = this.addFileLibrary(executionProfileModel.getName() + "-File Library", "The file library automatically created during migration for the execution profile " + executionProfileModel.getName() + ".", "N/A");
                            }
                            file.setFileLibraryId(library.getId());
                            addedFile = this.schedulerApplication.getFileLibraryResource().addLibraryFileInternalSystem(file.getFileLibraryId(), file, "N/A");
                            existingFiles.put(addedFile.getId(), addedFile);
                        }
                        updatedNuixProfiles.put((String)entry.getKey(), file.getId());
                    }
                }
                if (nuixProfiles.getOcrProfiles() != null) {
                    for (Map.Entry entry : nuixProfiles.getOcrProfiles().entrySet()) {
                        file = this.addLibraryFile((String)entry.getKey(), (String)entry.getValue(), LibraryNuixFileType.OCR_PROFILE, existingFiles);
                        if (file.getFileLibraryId() == null) {
                            if (library == null) {
                                library = this.addFileLibrary(executionProfileModel.getName() + "-File Library", "The file library automatically created during migration for the execution profile " + executionProfileModel.getName() + ".", "N/A");
                            }
                            file.setFileLibraryId(library.getId());
                            addedFile = this.schedulerApplication.getFileLibraryResource().addLibraryFileInternalSystem(file.getFileLibraryId(), file, "N/A");
                            existingFiles.put(addedFile.getId(), addedFile);
                        }
                        updatedNuixProfiles.put((String)entry.getKey(), file.getId());
                    }
                }
                if (nuixProfiles.getProcessingProfiles() != null) {
                    for (Map.Entry entry : nuixProfiles.getProcessingProfiles().entrySet()) {
                        file = this.addLibraryFile((String)entry.getKey(), (String)entry.getValue(), LibraryNuixFileType.PROCESSING_PROFILE, existingFiles);
                        if (file.getFileLibraryId() == null) {
                            if (library == null) {
                                library = this.addFileLibrary(executionProfileModel.getName() + "-File Library", "The file library automatically created during migration for the execution profile " + executionProfileModel.getName() + ".", "N/A");
                            }
                            file.setFileLibraryId(library.getId());
                            addedFile = this.schedulerApplication.getFileLibraryResource().addLibraryFileInternalSystem(file.getFileLibraryId(), file, "N/A");
                            existingFiles.put(addedFile.getId(), addedFile);
                        }
                        updatedNuixProfiles.put((String)entry.getKey(), file.getId());
                    }
                }
                if (nuixProfiles.getProductionProfiles() != null) {
                    for (Map.Entry entry : nuixProfiles.getProductionProfiles().entrySet()) {
                        file = this.addLibraryFile((String)entry.getKey(), (String)entry.getValue(), LibraryNuixFileType.PRODUCTION_PROFILE, existingFiles);
                        if (file.getFileLibraryId() == null) {
                            if (library == null) {
                                library = this.addFileLibrary(executionProfileModel.getName() + "-File Library", "The file library automatically created during migration for the execution profile " + executionProfileModel.getName() + ".", "N/A");
                            }
                            file.setFileLibraryId(library.getId());
                            addedFile = this.schedulerApplication.getFileLibraryResource().addLibraryFileInternalSystem(file.getFileLibraryId(), file, "N/A");
                            existingFiles.put(addedFile.getId(), addedFile);
                        }
                        updatedNuixProfiles.put((String)entry.getKey(), file.getId());
                    }
                }
                if (nuixProfiles.getMetadataProfiles() != null) {
                    for (Map.Entry entry : nuixProfiles.getMetadataProfiles().entrySet()) {
                        file = this.addLibraryFile((String)entry.getKey(), (String)entry.getValue(), LibraryNuixFileType.METADATA_PROFILE, existingFiles);
                        if (file.getFileLibraryId() == null) {
                            if (library == null) {
                                library = this.addFileLibrary(executionProfileModel.getName() + "-File Library", "The file library automatically created during migration for the execution profile " + executionProfileModel.getName() + ".", "N/A");
                            }
                            file.setFileLibraryId(library.getId());
                            addedFile = this.schedulerApplication.getFileLibraryResource().addLibraryFileInternalSystem(file.getFileLibraryId(), file, "N/A");
                            existingFiles.put(addedFile.getId(), addedFile);
                        }
                        updatedNuixProfiles.put((String)entry.getKey(), file.getId());
                    }
                }
                if (nuixProfiles.getMetadataImportProfiles() != null) {
                    for (Map.Entry entry : nuixProfiles.getMetadataImportProfiles().entrySet()) {
                        file = this.addLibraryFile((String)entry.getKey(), (String)entry.getValue(), LibraryNuixFileType.METADATA_IMPORT_PROFILE, existingFiles);
                        if (file.getFileLibraryId() == null) {
                            if (library == null) {
                                library = this.addFileLibrary(executionProfileModel.getName() + "-File Library", "The file library automatically created during migration for the execution profile " + executionProfileModel.getName() + ".", "N/A");
                            }
                            file.setFileLibraryId(library.getId());
                            addedFile = this.schedulerApplication.getFileLibraryResource().addLibraryFileInternalSystem(file.getFileLibraryId(), file, "N/A");
                            existingFiles.put(addedFile.getId(), addedFile);
                        }
                        updatedNuixProfiles.put((String)entry.getKey(), file.getId());
                    }
                }
                if (nuixProfiles.getPlaybooks() != null) {
                    for (Map.Entry entry : nuixProfiles.getPlaybooks().entrySet()) {
                        file = this.addLibraryFile((String)entry.getKey(), (String)entry.getValue(), LibraryNuixFileType.PLAYBOOK, existingFiles);
                        if (file.getFileLibraryId() == null) {
                            if (library == null) {
                                library = this.addFileLibrary(executionProfileModel.getName() + "-File Library", "The file library automatically created during migration for the execution profile " + executionProfileModel.getName() + ".", "N/A");
                            }
                            file.setFileLibraryId(library.getId());
                            addedFile = this.schedulerApplication.getFileLibraryResource().addLibraryFileInternalSystem(file.getFileLibraryId(), file, "N/A");
                            existingFiles.put(addedFile.getId(), addedFile);
                        }
                        updatedNuixProfiles.put((String)entry.getKey(), file.getId());
                    }
                }
                executionProfileModel.setNuixProfiles(updatedNuixProfiles);
                didUpdate = true;
            }
            if (executionProfileModel.getAdditionalFiles() != null && executionProfileModel.getAdditionalFiles().containsKey("UPDATE_V1")) {
                HashMap<String, String> updatedAdditionalFiles = new HashMap<String, String>();
                AdditionalFiles additionalFiles = (AdditionalFiles)SerializationUtils.fromJson((String)((String)executionProfileModel.getAdditionalFiles().get("UPDATE_V1")), AdditionalFiles.class);
                if (additionalFiles != null) {
                    Map existingAdditionalFiles = additionalFiles.getFiles();
                    if (existingAdditionalFiles == null) {
                        existingAdditionalFiles = additionalFiles.getFileParameters();
                    }
                    if (existingAdditionalFiles != null) {
                        for (Map.Entry entry2 : existingAdditionalFiles.entrySet()) {
                            FileLibraryFile file = this.addLibraryFile(((AdditionalFile)entry2.getValue()).getFileName(), ((AdditionalFile)entry2.getValue()).getFileData(), LibraryNuixFileType.CUSTOM_FILE, existingFiles);
                            if (file.getFileLibraryId() == null) {
                                if (library == null) {
                                    library = this.addFileLibrary(executionProfileModel.getName() + "-File Library", "The file library automatically created during migration for the execution profile " + executionProfileModel.getName() + ".", "N/A");
                                }
                                file.setFileLibraryId(library.getId());
                                FileLibraryFile addedFile = this.schedulerApplication.getFileLibraryResource().addLibraryFileInternalSystem(file.getFileLibraryId(), file, "N/A");
                                existingFiles.put(addedFile.getId(), addedFile);
                            }
                            updatedAdditionalFiles.put((String)entry2.getKey(), file.getId());
                        }
                    }
                    executionProfileModel.setAdditionalFiles(updatedAdditionalFiles);
                    didUpdate = true;
                }
            }
            if (executionProfileModel.getNuixProfiles() != null && executionProfileModel.getNuixProfiles().size() > 0) {
                HashMap<void, String> updatedNuixProfiles = new HashMap<void, String>();
                Map<String, FileLibraryFile> libraryFiles = this.schedulerApplication.getFileLibraryResource().getAllLibraryFiles();
                for (String string : executionProfileModel.getNuixProfiles().keySet()) {
                    void var10_22;
                    if (!libraryFiles.containsKey(string)) {
                        String string2 = (String)executionProfileModel.getNuixProfiles().get(string);
                        didUpdate = true;
                    }
                    if (!libraryFiles.containsKey(var10_22)) continue;
                    String fileName = libraryFiles.get(var10_22).getName();
                    updatedNuixProfiles.put(var10_22, fileName);
                }
                executionProfileModel.setNuixProfiles(updatedNuixProfiles);
            }
            if (executionProfileModel.getJobProgressSettings() == null) {
                JobProgressSettings defaultJobProgressSettings = new JobProgressSettings();
                defaultJobProgressSettings.setUpdateOperationsProgressWeightLastRunWeightPercentage(Double.valueOf(33.0));
                executionProfileModel.setJobProgressSettings(defaultJobProgressSettings);
                didUpdate = true;
            }
            if (executionProfileModel.getWorkerTempFolder() == null) {
                this.schedulerApplication.getConfiguration();
                if (SchedulerConfiguration.getOsWindows()) {
                    executionProfileModel.setWorkerTempFolder(WorkerTempFolder.WINDOWS.getPath());
                } else {
                    executionProfileModel.setWorkerTempFolder(WorkerTempFolder.OTHER.getPath());
                }
                didUpdate = true;
            }
            if (didUpdate) {
                this.schedulerApplication.getSchedulerConfigurationDao().updateExecutionProfile(executionProfileModel);
            }
            this.executionProfiles.put(executionProfileModel.getId(), executionProfileModel);
        }
        this.resetVersion();
    }

    public FileLibrary addFileLibrary(String name, String description, String remoteAddress) {
        FileLibrary fileLibrary = new FileLibrary();
        fileLibrary.setName(name);
        fileLibrary.setDescription(description);
        return this.schedulerApplication.getFileLibraryResource().addFileLibraryInternal(new SystemBearerUser(), fileLibrary, remoteAddress);
    }

    public FileLibraryFile addLibraryFile(String name, String data, LibraryNuixFileType type, Map<String, FileLibraryFile> existingFiles) {
        FileLibraryUtils libraryUtils = FileLibraryUtils.getInstance();
        FileLibraryFile fileToAdd = new FileLibraryFile();
        String extension = libraryUtils.getExtension(type);
        fileToAdd.setName(name + extension);
        fileToAdd.setData(data);
        fileToAdd.setDescription("File created during migration of execution profile");
        fileToAdd.setNuixFileType(type);
        for (FileLibraryFile existingFile : existingFiles.values()) {
            if (!libraryUtils.isSameFile(fileToAdd, existingFile)) continue;
            return existingFile;
        }
        return fileToAdd;
    }

    public Collection<ExecutionProfileModel> getExecutionProfiles() {
        return this.executionProfiles.values();
    }

    public Map<LibraryNuixFileType, Set<String>> getExecutionProfileNuixProfiles(String executionProfileId) {
        ExecutionProfileModel executionProfileModel = this.executionProfiles.get(executionProfileId);
        HashMap<LibraryNuixFileType, Set<String>> executionProfileProfiles = new HashMap<LibraryNuixFileType, Set<String>>();
        executionProfileProfiles.put(LibraryNuixFileType.CONFIGURATION_PROFILE, new HashSet());
        executionProfileProfiles.put(LibraryNuixFileType.PROCESSING_PROFILE, new HashSet());
        executionProfileProfiles.put(LibraryNuixFileType.PRODUCTION_PROFILE, new HashSet());
        executionProfileProfiles.put(LibraryNuixFileType.METADATA_PROFILE, new HashSet());
        executionProfileProfiles.put(LibraryNuixFileType.METADATA_IMPORT_PROFILE, new HashSet());
        executionProfileProfiles.put(LibraryNuixFileType.PLAYBOOK, new HashSet());
        executionProfileProfiles.put(LibraryNuixFileType.IMAGING_PROFILE, new HashSet());
        executionProfileProfiles.put(LibraryNuixFileType.OCR_PROFILE, new HashSet());
        if (executionProfileModel != null && executionProfileModel.getNuixProfiles() != null && executionProfileModel.getNuixProfiles().size() > 0) {
            Map<String, FileLibraryFile> files = this.schedulerApplication.getFileLibraryResource().getAllLibraryFiles();
            for (String fileLibraryFileId : executionProfileModel.getNuixProfiles().keySet()) {
                FileLibraryFile executionProfileFile = files.get(fileLibraryFileId);
                String fileName = executionProfileFile.getName();
                if (fileName.contains(".")) {
                    fileName = executionProfileFile.getName().substring(0, executionProfileFile.getName().lastIndexOf("."));
                }
                ((Set)executionProfileProfiles.get(executionProfileFile.getNuixFileType())).add(fileName);
            }
        }
        return executionProfileProfiles;
    }

    public String isUnique(Set<String> list, Map<String, FileLibraryFile> existingFiles, LibraryNuixFileType type) {
        if (list != null && existingFiles != null) {
            HashSet<String> set = new HashSet<String>();
            for (String item : list) {
                FileLibraryFile file = existingFiles.get(item);
                if (file.getNuixFileType() != type || set.add(file.getName())) continue;
                return file.getName();
            }
        }
        return "";
    }

    @Operation(tags={"Resources", "Job Submission"}, operationId="ListExecutionProfiles", summary="List Execution Profiles", description="List the execution profiles", responses={@ApiResponse(description="The list of execution profiles", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConciseObject.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/list")
    @GET
    public Response listExecutionProfiles(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.EXECUTION_PROFILES, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ArrayList<com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile> allowedExecutionProfiles = new ArrayList<com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile>();
            for (ExecutionProfileModel executionProfile : this.executionProfiles.values()) {
                com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, executionProfile);
                if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                allowedExecutionProfiles.add(result);
            }
            SortingUtils.sortList(allowedExecutionProfiles, com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile::getName);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)ResponseUtils.getConciseList(allowedExecutionProfiles)).build();
        }
    }

    public String getDefaultExecutionProfileId(@Parameter(hidden=true) @Auth BearerUser user) {
        Object defaultExecutionProfileId;
        ArrayList<com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile> allowedExecutionProfiles = new ArrayList<com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile>();
        for (ExecutionProfileModel executionProfile : this.executionProfiles.values()) {
            com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, executionProfile);
            if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
            allowedExecutionProfiles.add(result);
        }
        if (allowedExecutionProfiles.size() == 1) {
            return ((com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile)allowedExecutionProfiles.get(0)).getId();
        }
        UserSettings userSettings = this.schedulerApplication.getUserSettingsResource().getUserSettingsInternal(user);
        Setting defaultValues = (Setting)userSettings.get((Object)"defaultValues");
        if (defaultValues != null && (defaultExecutionProfileId = defaultValues.get((Object)"executionProfileId")) != null) {
            String candidateExecutionProfileId = String.valueOf(defaultExecutionProfileId);
            for (com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile executionProfile : allowedExecutionProfiles) {
                if (!executionProfile.getId().equals(candidateExecutionProfileId)) continue;
                return candidateExecutionProfileId;
            }
        }
        return null;
    }

    @Operation(tags={"Resources"}, operationId="GetExecutionProfiles", summary="Get Execution Profiles", description="Get full information of all execution profiles. Use ListExecutionProfiles unless full information is required", responses={@ApiResponse(description="The list of execution profiles", content={@Content(array=@ArraySchema(schema=@Schema(implementation=com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getExecutionProfiles(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.EXECUTION_PROFILES, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ArrayList<com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile> allowedExecutionProfiles = new ArrayList<com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile>();
            for (ExecutionProfileModel executionProfile : this.executionProfiles.values()) {
                com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, executionProfile);
                if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                allowedExecutionProfiles.add(result);
            }
            SortingUtils.sortList(allowedExecutionProfiles, com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile::getName);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedExecutionProfiles).build();
        }
    }

    @Operation(tags={"Resources"}, operationId="AddExecutionProfile", summary="Add Execution Profile", description="Add a new execution profile", responses={@ApiResponse(description="The execution profile that was added", content={@Content(schema=@Schema(implementation=com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile.class))}), @ApiResponse(responseCode="400", description="An execution profile with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Consumes(value={"application/json"})
    public Response addExecutionProfile(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The execution profile to add", schema=@Schema(implementation=ExecutionProfileSubmission.class)) ExecutionProfileModel executionProfileModel) {
        Response errorResponse;
        Set<String> executionProfileRequiredParameters;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_EXECUTION_PROFILES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)executionProfileModel);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        if (this.executionProfiles.size() == 0) {
            executionProfileModel.setId("1000947c-0001-4825-8f3f-f1a071e1dcf8");
        } else {
            executionProfileModel.setId(UidUtils.getRandom());
        }
        executionProfileModel.setDefaults();
        FormattingUtils.trimAllStrings((Object)executionProfileModel);
        if (executionProfileModel.getName() == null || executionProfileModel.getName().trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"errorAddingExecutionProfile", (Response.Status)Response.Status.BAD_REQUEST);
        }
        for (ExecutionProfileModel existingExecutionProfileModel : this.executionProfiles.values()) {
            if (!existingExecutionProfileModel.getName().equals(executionProfileModel.getName())) continue;
            return ExceptionUtils.toResponse((String)"executionProfileSameNameExists", (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (executionProfileModel.getEngineLogFolder() == null || executionProfileModel.getEngineLogFolder().length() == 0) {
            return ExceptionUtils.toResponse((String)"executionProfileMissingLog", (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (executionProfileModel.getWorkerTempFolder() == null || executionProfileModel.getWorkerTempFolder().length() == 0) {
            return ExceptionUtils.toResponse((String)"executionProfileMissingWorkerTempDirectory", (Response.Status)Response.Status.BAD_REQUEST);
        }
        Map fileParameters = executionProfileModel.getAdditionalFiles();
        if (fileParameters != null) {
            String[] builtInFileParameters = new String[]{"{last_metadata_export_file}", "{last_report_file}"};
            HashSet<String> fileNames = new HashSet<String>();
            for (final String parameterName : fileParameters.keySet()) {
                final FileLibraryFile additionalFile = this.schedulerApplication.getFileLibraryResource().resolveFileId((String)fileParameters.get(parameterName));
                boolean isBuiltInParameter = Arrays.asList(builtInFileParameters).contains(parameterName);
                if (isBuiltInParameter) {
                    return ExceptionUtils.toResponse((String)"parameterNameNotAllowed", (Map)new HashMap<String, String>(){
                        {
                            this.put("existingParameter", parameterName);
                        }
                    });
                }
                if (!fileNames.add(additionalFile.getName())) {
                    return ExceptionUtils.toResponse((String)"duplicateFileName", (Map)new HashMap<String, String>(){
                        {
                            this.put("fileName", additionalFile.getName());
                        }
                    });
                }
                byte[] fileData = FileUtils.decodeFileData((String)additionalFile.getData());
                long fileSize = fileData.length;
                if (fileSize <= this.schedulerApplication.getConfiguration().getLibraryFileMaxSize()) continue;
                return ExceptionUtils.toResponse((String)"additionalFileTooLarge");
            }
        }
        ExecutionProfileModel referenceProfile = this.executionProfiles.get(executionProfileModel.getDuplicateReferenceId());
        String engineAccountUsername = executionProfileModel.getEngineAccountUsername();
        HashSet<String> protectedParameterNames = new HashSet<String>();
        LinkedHashMap workflowParameters = executionProfileModel.getWorkflowParameters();
        for (String parameterName : workflowParameters.keySet()) {
            StaticParameter staticParameter = new StaticParameter(parameterName, "");
            String parameterValue = (String)workflowParameters.get(parameterName);
            if (staticParameter.isEffectiveTypeMaskedOrProtected() && parameterValue == null && referenceProfile != null && referenceProfile.getWorkflowParameters().containsKey(parameterName)) {
                parameterValue = (String)referenceProfile.getWorkflowParameters().get(parameterName);
                workflowParameters.put(parameterName, parameterValue);
            }
            if (staticParameter.getEffectiveParameterType() != ParameterType.TEXT_PROTECTED) continue;
            protectedParameterNames.add(parameterName);
        }
        if (protectedParameterNames.size() > 0 && (executionProfileRequiredParameters = this.getExecutionProfileRequiredParameters(executionProfileModel, false)).size() > 0) {
            for (final String parameterName : executionProfileRequiredParameters) {
                if (!protectedParameterNames.contains(parameterName)) continue;
                return ExceptionUtils.toResponse((String)"executionProfileInvalidRequiredParameter", (Map)new HashMap<String, String>(){
                    {
                        this.put("parameterName", parameterName);
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        if ((errorResponse = this.schedulerApplication.getLibraryResource().verifyNoBuiltInParameters(executionProfileModel.getWorkflowParameters().keySet())) != null) {
            return errorResponse;
        }
        if (executionProfileModel.getNuixProfiles() != null) {
            Map nuixProfiles = executionProfileModel.getNuixProfiles();
            Map<String, FileLibraryFile> existingFiles = this.schedulerApplication.getFileLibraryResource().getAllLibraryFiles();
            HashSet<String> fileIds = new HashSet<String>(nuixProfiles.keySet());
            final String duplicateConfigurationProfileName = this.isUnique(fileIds, existingFiles, LibraryNuixFileType.CONFIGURATION_PROFILE);
            if (duplicateConfigurationProfileName.length() > 0) {
                return ExceptionUtils.toResponse((String)"duplicateNuixProfileName", (Map)new HashMap<String, String>(){
                    {
                        this.put("existingProfileType", "Configuration");
                        this.put("existingProfileName", duplicateConfigurationProfileName);
                    }
                });
            }
            final String duplicateProductionProfileName = this.isUnique(fileIds, existingFiles, LibraryNuixFileType.PRODUCTION_PROFILE);
            if (duplicateProductionProfileName.length() > 0) {
                return ExceptionUtils.toResponse((String)"duplicateNuixProfileName", (Map)new HashMap<String, String>(){
                    {
                        this.put("existingProfileType", "Production");
                        this.put("existingProfileName", duplicateProductionProfileName);
                    }
                });
            }
            final String duplicateProcessingProfileName = this.isUnique(fileIds, existingFiles, LibraryNuixFileType.PROCESSING_PROFILE);
            if (duplicateProcessingProfileName.length() > 0) {
                return ExceptionUtils.toResponse((String)"duplicateNuixProfileName", (Map)new HashMap<String, String>(){
                    {
                        this.put("existingProfileType", "Processing");
                        this.put("existingProfileName", duplicateProcessingProfileName);
                    }
                });
            }
            final String duplicateMetadataProfileName = this.isUnique(fileIds, existingFiles, LibraryNuixFileType.METADATA_PROFILE);
            if (duplicateMetadataProfileName.length() > 0) {
                return ExceptionUtils.toResponse((String)"duplicateNuixProfileName", (Map)new HashMap<String, String>(){
                    {
                        this.put("existingProfileType", "Metadata");
                        this.put("existingProfileName", duplicateMetadataProfileName);
                    }
                });
            }
            final String duplicateMetadataImportProfileName = this.isUnique(fileIds, existingFiles, LibraryNuixFileType.METADATA_IMPORT_PROFILE);
            if (duplicateMetadataImportProfileName.length() > 0) {
                return ExceptionUtils.toResponse((String)"duplicateNuixProfileName", (Map)new HashMap<String, String>(){
                    {
                        this.put("existingProfileType", "Metadata");
                        this.put("existingProfileName", duplicateMetadataImportProfileName);
                    }
                });
            }
            final String duplicatePlaybookName = this.isUnique(fileIds, existingFiles, LibraryNuixFileType.PLAYBOOK);
            if (duplicatePlaybookName.length() > 0) {
                return ExceptionUtils.toResponse((String)"duplicateNuixProfileName", (Map)new HashMap<String, String>(){
                    {
                        this.put("existingProfileType", "Metadata");
                        this.put("existingProfileName", duplicatePlaybookName);
                    }
                });
            }
            final String duplicateImagingProfileName = this.isUnique(fileIds, existingFiles, LibraryNuixFileType.IMAGING_PROFILE);
            if (duplicateImagingProfileName.length() > 0) {
                return ExceptionUtils.toResponse((String)"duplicateNuixProfileName", (Map)new HashMap<String, String>(){
                    {
                        this.put("existingProfileType", "Imaging");
                        this.put("existingProfileName", duplicateImagingProfileName);
                    }
                });
            }
            final String duplicateOcrProfileName = this.isUnique(fileIds, existingFiles, LibraryNuixFileType.OCR_PROFILE);
            if (duplicateOcrProfileName.length() > 0) {
                return ExceptionUtils.toResponse((String)"duplicateNuixProfileName", (Map)new HashMap<String, String>(){
                    {
                        this.put("existingProfileType", "OCR");
                        this.put("existingProfileName", duplicateOcrProfileName);
                    }
                });
            }
        }
        this.executionProfiles.put(executionProfileModel.getId(), executionProfileModel);
        if (this.schedulerApplication.getSchedulerConfigurationDao().updateExecutionProfile(executionProfileModel) == 0) {
            this.schedulerApplication.getSchedulerConfigurationDao().addExecutionProfile(executionProfileModel);
        }
        executionProfileModel.setSchedulerCertFingeprint(this.schedulerApplication.getConfiguration().getLoopbackFingerprint());
        com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, executionProfileModel);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.EXECUTION_PROFILE_ADDED, eventResult, user.getName());
        this.trackExecutionProfileUtilization(executionProfileModel);
        ResponseCache.getInstance().resetKeyId(CacheKey.EXECUTION_PROFILES, "");
        com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, executionProfileModel);
        this.resetVersion();
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Resources"}, operationId="UpdateExecutionProfile", summary="Update Execution Profile", description="Update the execution profile with the specified ID", responses={@ApiResponse(description="The updated execution profile", content={@Content(schema=@Schema(implementation=com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{executionProfileId}")
    @PUT
    public Response updateExecutionProfileId(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the execution profile to update") @PathParam(value="executionProfileId") String executionProfileId, @Parameter(description="The information to update the execution profile with", schema=@Schema(implementation=ExecutionProfileSubmission.class)) ExecutionProfileModel executionProfileModel) {
        Set<String> executionProfileRequiredParameters;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_EXECUTION_PROFILES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)executionProfileModel);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        ExecutionProfileModel originalExecutionProfile = this.executionProfiles.get(executionProfileId);
        if (originalExecutionProfile == null) {
            return ExceptionUtils.toResponse((String)"invalidExecutionProfileId", (Response.Status)Response.Status.BAD_REQUEST);
        }
        FormattingUtils.trimAllStrings((Object)executionProfileModel);
        if (executionProfileModel.getName() != null) {
            for (ExecutionProfileModel existingExecutionProfile : this.executionProfiles.values()) {
                if (existingExecutionProfile.getId().equals(executionProfileId) || !executionProfileModel.getName().equals(existingExecutionProfile.getName())) continue;
                return ExceptionUtils.toResponse((String)"executionProfileSameNameExists", (Response.Status)Response.Status.BAD_REQUEST);
            }
            originalExecutionProfile.setName(executionProfileModel.getName());
        }
        if (executionProfileModel.getDescription() != null) {
            originalExecutionProfile.setDescription(executionProfileModel.getDescription());
        }
        if (executionProfileModel.getEngineAccountUsername() != null) {
            originalExecutionProfile.setEngineAccountUsername(executionProfileModel.getEngineAccountUsername());
        }
        if (executionProfileModel.getEngineAccountPassword() != null) {
            originalExecutionProfile.setEngineAccountPassword(executionProfileModel.getEngineAccountPassword());
        }
        if (executionProfileModel.getEngineCommandLineParameters() != null) {
            originalExecutionProfile.setEngineCommandLineParameters(executionProfileModel.getEngineCommandLineParameters());
        }
        if (executionProfileModel.getEngineLogFolder() != null) {
            if (executionProfileModel.getEngineLogFolder().length() == 0) {
                return ExceptionUtils.toResponse((String)"executionProfileMissingLog", (Response.Status)Response.Status.BAD_REQUEST);
            }
            String logFolder = executionProfileModel.getEngineLogFolder().trim();
            originalExecutionProfile.setEngineLogFolder(logFolder);
        }
        if (executionProfileModel.getWorkerTempFolder() != null) {
            if (executionProfileModel.getWorkerTempFolder().length() == 0) {
                return ExceptionUtils.toResponse((String)"executionProfileMissingWorkerTempDirectory", (Response.Status)Response.Status.BAD_REQUEST);
            }
            String workerTempFolder = executionProfileModel.getWorkerTempFolder().trim();
            originalExecutionProfile.setWorkerTempFolder(workerTempFolder);
        }
        if (executionProfileModel.getJobProgressSettings() != null) {
            originalExecutionProfile.setJobProgressSettings(executionProfileModel.getJobProgressSettings());
        }
        if (executionProfileModel.getJobTimeoutSettings() != null) {
            originalExecutionProfile.setJobTimeoutSettings(executionProfileModel.getJobTimeoutSettings());
        }
        if (executionProfileModel.getNuixProfiles() != null) {
            Map originalNuixProfiles = originalExecutionProfile.getNuixProfiles();
            Map updatedNuixProfiles = executionProfileModel.getNuixProfiles();
            Map<String, FileLibraryFile> existingFiles = this.schedulerApplication.getFileLibraryResource().getAllLibraryFiles();
            HashSet<String> fileIds = new HashSet<String>(updatedNuixProfiles.keySet());
            final String duplicateConfigurationProfileName = this.isUnique(fileIds, existingFiles, LibraryNuixFileType.CONFIGURATION_PROFILE);
            if (duplicateConfigurationProfileName.length() > 0) {
                return ExceptionUtils.toResponse((String)"duplicateNuixProfileName", (Map)new HashMap<String, String>(){
                    {
                        this.put("existingProfileType", "Configuration");
                        this.put("existingProfileName", duplicateConfigurationProfileName);
                    }
                });
            }
            final String duplicateProductionProfileName = this.isUnique(fileIds, existingFiles, LibraryNuixFileType.PRODUCTION_PROFILE);
            if (duplicateProductionProfileName.length() > 0) {
                return ExceptionUtils.toResponse((String)"duplicateNuixProfileName", (Map)new HashMap<String, String>(){
                    {
                        this.put("existingProfileType", "Production");
                        this.put("existingProfileName", duplicateProductionProfileName);
                    }
                });
            }
            final String duplicateProcessingProfileName = this.isUnique(fileIds, existingFiles, LibraryNuixFileType.PROCESSING_PROFILE);
            if (duplicateProcessingProfileName.length() > 0) {
                return ExceptionUtils.toResponse((String)"duplicateNuixProfileName", (Map)new HashMap<String, String>(){
                    {
                        this.put("existingProfileType", "Processing");
                        this.put("existingProfileName", duplicateProcessingProfileName);
                    }
                });
            }
            final String duplicateMetadataProfileName = this.isUnique(fileIds, existingFiles, LibraryNuixFileType.METADATA_PROFILE);
            if (duplicateMetadataProfileName.length() > 0) {
                return ExceptionUtils.toResponse((String)"duplicateNuixProfileName", (Map)new HashMap<String, String>(){
                    {
                        this.put("existingProfileType", "Metadata");
                        this.put("existingProfileName", duplicateMetadataProfileName);
                    }
                });
            }
            final String duplicateMetadataImportProfileName = this.isUnique(fileIds, existingFiles, LibraryNuixFileType.METADATA_IMPORT_PROFILE);
            if (duplicateMetadataImportProfileName.length() > 0) {
                return ExceptionUtils.toResponse((String)"duplicateNuixProfileName", (Map)new HashMap<String, String>(){
                    {
                        this.put("existingProfileType", "Metadata");
                        this.put("existingProfileName", duplicateMetadataImportProfileName);
                    }
                });
            }
            final String duplicatePlaybookName = this.isUnique(fileIds, existingFiles, LibraryNuixFileType.PLAYBOOK);
            if (duplicatePlaybookName.length() > 0) {
                return ExceptionUtils.toResponse((String)"duplicateNuixProfileName", (Map)new HashMap<String, String>(){
                    {
                        this.put("existingProfileType", "Metadata");
                        this.put("existingProfileName", duplicatePlaybookName);
                    }
                });
            }
            final String duplicateImagingProfileName = this.isUnique(fileIds, existingFiles, LibraryNuixFileType.IMAGING_PROFILE);
            if (duplicateImagingProfileName.length() > 0) {
                return ExceptionUtils.toResponse((String)"duplicateNuixProfileName", (Map)new HashMap<String, String>(){
                    {
                        this.put("existingProfileType", "Imaging");
                        this.put("existingProfileName", duplicateImagingProfileName);
                    }
                });
            }
            final String duplicateOcrProfileName = this.isUnique(fileIds, existingFiles, LibraryNuixFileType.OCR_PROFILE);
            if (duplicateOcrProfileName.length() > 0) {
                return ExceptionUtils.toResponse((String)"duplicateNuixProfileName", (Map)new HashMap<String, String>(){
                    {
                        this.put("existingProfileType", "OCR");
                        this.put("existingProfileName", duplicateOcrProfileName);
                    }
                });
            }
            if (originalExecutionProfile.getNuixProfiles() != null) {
                originalExecutionProfile.setNuixProfiles(this.mergeProfiles(originalNuixProfiles, updatedNuixProfiles));
            }
            originalExecutionProfile.setNuixProfiles(updatedNuixProfiles);
        }
        if (executionProfileModel.getAdditionalFiles() != null) {
            Map originalAdditionalFiles = originalExecutionProfile.getAdditionalFiles();
            Map updatedAdditionalFiles = executionProfileModel.getAdditionalFiles();
            String[] builtInFileParameters = new String[]{"{last_metadata_export_file}", "{last_report_file}"};
            HashSet<String> fileNames = new HashSet<String>();
            for (final String parameterName : updatedAdditionalFiles.keySet()) {
                byte[] fileData;
                long fileSize;
                final FileLibraryFile additionalFile = this.schedulerApplication.getFileLibraryResource().resolveFileId((String)updatedAdditionalFiles.get(parameterName));
                boolean isBuiltInParameter = Arrays.asList(builtInFileParameters).contains(parameterName);
                if (isBuiltInParameter) {
                    return ExceptionUtils.toResponse((String)"parameterNameNotAllowed", (Map)new HashMap<String, String>(){
                        {
                            this.put("existingParameter", parameterName);
                        }
                    });
                }
                if (!fileNames.add(additionalFile.getName())) {
                    return ExceptionUtils.toResponse((String)"duplicateFileName", (Map)new HashMap<String, String>(){
                        {
                            this.put("fileName", additionalFile.getName());
                        }
                    });
                }
                if (additionalFile.getData() == null || (fileSize = (long)(fileData = FileUtils.decodeFileData((String)additionalFile.getData())).length) <= this.schedulerApplication.getConfiguration().getLibraryFileMaxSize()) continue;
                return ExceptionUtils.toResponse((String)"additionalFileTooLarge");
            }
            Map<String, String> merged = this.mergeProfiles(originalAdditionalFiles, updatedAdditionalFiles);
            originalExecutionProfile.setAdditionalFiles(merged);
        }
        originalExecutionProfile.getStatus().reset();
        if (executionProfileModel.getNuixEngineFolder() != null) {
            originalExecutionProfile.setNuixEngineFolder(executionProfileModel.getNuixEngineFolder());
        }
        if (executionProfileModel.getJavaFolder() != null) {
            originalExecutionProfile.setJavaFolder(executionProfileModel.getJavaFolder());
        }
        if (executionProfileModel.getSchedulerUrl() != null) {
            originalExecutionProfile.setSchedulerUrl(executionProfileModel.getSchedulerUrl());
        }
        if (executionProfileModel.getWorkflowParameters() != null) {
            LinkedHashMap originalWorkflowParameters = originalExecutionProfile.getWorkflowParameters();
            LinkedHashMap updatedWorkflowParameters = executionProfileModel.getWorkflowParameters();
            for (final String parameterName : updatedWorkflowParameters.keySet()) {
                String normalizedParameterName = FormattingUtils.normalizeParameterName((String)parameterName);
                String parameterValue = (String)updatedWorkflowParameters.get(normalizedParameterName);
                if (parameterValue != null) continue;
                updatedWorkflowParameters.put(normalizedParameterName, (String)originalWorkflowParameters.get(parameterName));
            }
            Response errorResponse = this.schedulerApplication.getLibraryResource().verifyNoBuiltInParameters(updatedWorkflowParameters.keySet());
            if (errorResponse != null) {
                return errorResponse;
            }
            originalExecutionProfile.setWorkflowParameters(updatedWorkflowParameters);
        }
        if (executionProfileModel.getNotificationRuleIds() != null) {
            originalExecutionProfile.setNotificationRuleIds(executionProfileModel.getNotificationRuleIds());
        }
        if (originalExecutionProfile.getEngineAccountUsername() != null && originalExecutionProfile.getEngineAccountUsername().length() > 0 && (originalExecutionProfile.getEngineAccountPassword() == null || originalExecutionProfile.getEngineAccountPassword().length() == 0)) {
            originalExecutionProfile.getStatus().setError(this.iu.getString("ExecutionProfile.ReenterPassword"));
        }
        HashSet<Object> protectedParameterNames = new HashSet<Object>();
        for (Object param : originalExecutionProfile.getWorkflowParameters().keySet()) {
            StaticParameter staticParameter = new StaticParameter((String)param, "");
            if (staticParameter.getEffectiveParameterType() != ParameterType.TEXT_PROTECTED) continue;
            protectedParameterNames.add(param);
        }
        if (protectedParameterNames.size() > 0 && (executionProfileRequiredParameters = this.getExecutionProfileRequiredParameters(executionProfileModel, false)).size() > 0) {
            for (final String parameterName : executionProfileRequiredParameters) {
                if (!protectedParameterNames.contains(parameterName)) continue;
                return ExceptionUtils.toResponse((String)"executionProfileInvalidRequiredParameter", (Map)new HashMap<String, String>(){
                    {
                        this.put("parameterName", parameterName);
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        if (this.schedulerApplication.getSchedulerConfigurationDao().updateExecutionProfile(originalExecutionProfile) == 0) {
            this.schedulerApplication.getSchedulerConfigurationDao().addExecutionProfile(originalExecutionProfile);
        }
        executionProfileModel.setSchedulerCertFingeprint(this.schedulerApplication.getConfiguration().getLoopbackFingerprint());
        com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalExecutionProfile);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.EXECUTION_PROFILE_MODIFIED, eventResult, user.getName());
        this.trackExecutionProfileUtilization(originalExecutionProfile);
        com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalExecutionProfile);
        Map workflowParameters = result.getWorkflowParameters();
        for (String workflowParameterName : workflowParameters.keySet()) {
            StaticParameter dummyParameter = new StaticParameter(workflowParameterName, "");
            if (!dummyParameter.isEffectiveTypeMaskedOrProtected()) continue;
            workflowParameters.put(workflowParameterName, null);
        }
        ResponseCache.getInstance().resetKeyId(CacheKey.EXECUTION_PROFILES, "");
        this.resetVersion();
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    public void updateExecutionProfileInternal(ExecutionProfileModel executionProfile) {
        if (this.schedulerApplication.getSchedulerConfigurationDao().updateExecutionProfile(executionProfile) == 0) {
            this.schedulerApplication.getSchedulerConfigurationDao().addExecutionProfile(executionProfile);
        }
        executionProfile.setSchedulerCertFingeprint(this.schedulerApplication.getConfiguration().getLoopbackFingerprint());
        this.resetVersion();
        ResponseCache.getInstance().resetKeyId(CacheKey.EXECUTION_PROFILES, "");
    }

    @Operation(tags={"Resources"}, operationId="DeleteExecutionProfile", summary="Delete Execution Profile", description="Delete the execution profile with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="404", description="Cannot find the execution profile with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{executionProfileId}")
    @DELETE
    public Response deleteExecutionProfile(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The ID of the execution profile to delete") @PathParam(value="executionProfileId") String executionProfileId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_EXECUTION_PROFILES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)executionProfileId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        ExecutionProfileModel deletedExecutionProfile = this.executionProfiles.remove(executionProfileId);
        if (deletedExecutionProfile == null) {
            return ExceptionUtils.toResponse((String)"executionProfileNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("executionProfileId", executionProfileId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        this.schedulerApplication.getSchedulerConfigurationDao().deleteExecutionProfile(executionProfileId);
        com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, deletedExecutionProfile);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.EXECUTION_PROFILE_DELETED, eventResult, user.getName());
        ResponseCache.getInstance().resetKeyId(CacheKey.EXECUTION_PROFILES, "");
        this.resetVersion();
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("executionProfileDeleted")).build();
    }

    /*
     * WARNING - void declaration
     */
    @Operation(tags={"Resources"}, operationId="DuplicateExecutionProfile", summary="Duplicate Execution Profile", description="Duplicate the execution profile with the specified ID for each Nuix version on system", responses={@ApiResponse(description="Duplication Status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="404", description="Cannot find the execution profile with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{executionProfileId}/duplicate")
    @PUT
    public Response duplicateExecutionProfile(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The ID of the execution profile to duplicate") @PathParam(value="executionProfileId") String executionProfileId, @QueryParam(value="force") boolean force) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_EXECUTION_PROFILES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)executionProfileId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        ExecutionProfileModel baseProfile = this.executionProfiles.get(executionProfileId);
        if (baseProfile == null) {
            return ExceptionUtils.toResponse((String)"executionProfileNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("executionProfileId", executionProfileId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Object engineInstallScanPath = "";
        String engineInstallPath = this.schedulerApplication.getConfiguration().getNuixEnginePath();
        if (engineInstallPath.equalsIgnoreCase(SystemUtils.getProgramFilesDir() + "\\Nuix\\Nuix Engine")) {
            engineInstallScanPath = SystemUtils.getProgramFilesDir() + "\\Nuix";
        } else if (engineInstallPath.equalsIgnoreCase("/opt/nuix/engine")) {
            engineInstallScanPath = "/opt/nuix/";
        }
        if (!force) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            values.put("folder", engineInstallScanPath);
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("propagateAllNuixVersions", values)).build();
        }
        String referenceId = "";
        if (baseProfile.getReference() != null) {
            referenceId = baseProfile.getReference();
            ExecutionProfileModel referenceProfile = this.executionProfiles.get(referenceId);
            if (referenceProfile != null) {
                baseProfile = referenceProfile;
                referenceId = baseProfile.getId();
            }
        } else {
            referenceId = baseProfile.getId();
        }
        Object cloneSafeProfileName = "";
        if (baseProfile.getName().matches("[^\\d]*\\d.*")) {
            String[] engineSplit;
            String engineVersion = null;
            if (baseProfile.getReferenceVersion() != null && !baseProfile.getReferenceVersion().isEmpty()) {
                engineVersion = baseProfile.getReferenceVersion();
            } else if (baseProfile.getNuixEngineFolder() != null && !baseProfile.getNuixEngineFolder().isEmpty() && (engineSplit = new File(baseProfile.getNuixEngineFolder()).getName().split("(?i)Nuix.?Engine")).length == 2) {
                engineVersion = engineSplit[1];
            }
            if (engineVersion != null && !engineVersion.isEmpty()) {
                if (!Character.isAlphabetic(engineVersion.charAt(0)) && !Character.isDigit(engineVersion.charAt(0)) && engineVersion.length() >= 2) {
                    engineVersion = engineVersion.substring(1);
                }
                cloneSafeProfileName = baseProfile.getName().replace(engineVersion, "{version}");
            } else {
                cloneSafeProfileName = baseProfile.getName() + " ({version})";
            }
        } else {
            cloneSafeProfileName = baseProfile.getName() + " {version}";
        }
        HashSet<String> existingProfileVersions = new HashSet<String>();
        for (ExecutionProfileModel model : this.executionProfiles.values()) {
            void var14_15;
            if (model.getReference() == null || !model.getReference().equals(referenceId)) continue;
            existingProfileVersions.add(model.getReferenceVersion());
            ExecutionProfileModel clonedObject = baseProfile.clone();
            clonedObject.setId(model.getId());
            String string = model.getReferenceVersion();
            if (!(string == null || string.isEmpty() || Character.isAlphabetic(string.charAt(0)) || Character.isDigit(string.charAt(0)) || string.length() < 2)) {
                String string2 = string.substring(1);
            }
            clonedObject.setName(((String)cloneSafeProfileName).replace("{version}", (CharSequence)var14_15));
            clonedObject.setNuixEngineFolder(model.getNuixEngineFolder());
            clonedObject.setReference(model.getReference());
            clonedObject.setReferenceVersion(model.getReferenceVersion());
            this.executionProfiles.put(clonedObject.getId(), clonedObject);
            this.schedulerApplication.getSchedulerConfigurationDao().updateExecutionProfile(clonedObject);
        }
        File[] nuixInstallations = new File((String)engineInstallScanPath).listFiles();
        if (nuixInstallations == null) {
            return ExceptionUtils.toResponse((String)"cannotDuplicate");
        }
        HashSet<String> profileVersionsAdded = new HashSet<String>();
        HashSet<String> validSubFolders = new HashSet<String>(Arrays.asList("bin", "lib", "doc", "user-data"));
        for (File nuixFolder : nuixInstallations) {
            String[] engineFolder = nuixFolder.getName().split("(?i)Nuix.?Engine");
            if (engineFolder.length != 2) continue;
            String engineVersion = engineFolder[1].trim();
            if (baseProfile.getNuixEngineFolder() != null && nuixFolder.getAbsolutePath().equals(baseProfile.getNuixEngineFolder()) || !this.isValidNuixEngineInstallation(nuixFolder, validSubFolders) || existingProfileVersions.contains(engineVersion)) continue;
            ExecutionProfileModel clonedExecutionProfile = baseProfile.clone();
            clonedExecutionProfile.setReferenceVersion(engineVersion);
            clonedExecutionProfile.setId(UidUtils.getRandom());
            clonedExecutionProfile.setNuixEngineFolder(nuixFolder.getAbsolutePath());
            clonedExecutionProfile.setReference(referenceId);
            if (!Character.isAlphabetic(engineVersion.charAt(0)) && !Character.isDigit(engineVersion.charAt(0)) && engineVersion.length() >= 2) {
                engineVersion = engineVersion.substring(1);
            }
            String versionedProfileName = ((String)cloneSafeProfileName).replace("{version}", engineVersion);
            if (baseProfile.getName().equals(versionedProfileName)) continue;
            clonedExecutionProfile.setName(versionedProfileName);
            ExecutionProfileModel clonedExecutionProfileModel = clonedExecutionProfile.clone();
            LinkedHashMap workflowParameters = clonedExecutionProfile.getWorkflowParameters();
            this.executionProfiles.put(clonedExecutionProfileModel.getId(), clonedExecutionProfileModel);
            this.schedulerApplication.getSchedulerConfigurationDao().addExecutionProfile(clonedExecutionProfile);
            clonedExecutionProfile.setSchedulerCertFingeprint(this.schedulerApplication.getConfiguration().getLoopbackFingerprint());
            com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, clonedExecutionProfile);
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.EXECUTION_PROFILE_ADDED, eventResult, user.getName());
            profileVersionsAdded.add(engineVersion);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String translationKey = "";
        translationKey = profileVersionsAdded.size() == 0 ? "executionProfilesUpdated" : (profileVersionsAdded.size() == 1 ? "executionProfileDuplicatedSingle" : "executionProfileDuplicated");
        hashMap.put("versionList", String.join((CharSequence)", ", profileVersionsAdded));
        ResponseCache.getInstance().resetKeyId(CacheKey.EXECUTION_PROFILES, "");
        this.resetVersion();
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus(translationKey, hashMap)).build();
    }

    @Operation(tags={"Resources"}, operationId="DeleteDuplicateExecutionProfiles", summary="Delete Duplicates of Execution Profile", description="Delete duplicates of the execution profile with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="404", description="Cannot find the execution profile with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{executionProfileId}/duplicate")
    @DELETE
    public Response deleteDuplicateExecutionProfiles(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The ID of the execution profile to duplicate") @PathParam(value="executionProfileId") String executionProfileId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_EXECUTION_PROFILES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)executionProfileId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        ExecutionProfileModel baseProfile = this.executionProfiles.get(executionProfileId);
        if (baseProfile == null) {
            return ExceptionUtils.toResponse((String)"executionProfileNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("executionProfileId", executionProfileId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        String referenceId = "";
        HashSet<String> deletedVersions = new HashSet<String>();
        referenceId = baseProfile.getReference() == null && baseProfile.getReferenceVersion() == null ? baseProfile.getId() : baseProfile.getReference();
        ConcurrentHashMap<String, ExecutionProfileModel> existingExecutionProfiles = new ConcurrentHashMap<String, ExecutionProfileModel>(this.executionProfiles);
        for (ExecutionProfileModel model : existingExecutionProfiles.values()) {
            if (model.getReference() == null || !model.getReference().equals(referenceId)) continue;
            this.executionProfiles.remove(model.getId());
            this.schedulerApplication.getSchedulerConfigurationDao().deleteExecutionProfile(model.getId());
            com.nuix.automate.utils.models.api.executionprofile.ExecutionProfile eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, model);
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.EXECUTION_PROFILE_ADDED, eventResult, user.getName());
            String version = model.getReferenceVersion();
            if (!Character.isAlphabetic(version.charAt(0)) && !Character.isDigit(version.charAt(0)) && version.length() >= 2) {
                version = version.substring(1);
            }
            deletedVersions.add(version);
        }
        HashMap<String, String> executionProfileDuplicatesDeleted = new HashMap<String, String>();
        String translationKey = "";
        if (deletedVersions.size() == 0) {
            return ExceptionUtils.toResponse((String)"executionProfileNoDuplicates");
        }
        translationKey = deletedVersions.size() == 1 ? "executionProfileDuplicateDeletedSingle" : "executionProfileDuplicateDeleted";
        executionProfileDuplicatesDeleted.put("deletedVersions", String.join((CharSequence)", ", deletedVersions));
        ResponseCache.getInstance().resetKeyId(CacheKey.EXECUTION_PROFILES, "");
        this.resetVersion();
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus(translationKey, executionProfileDuplicatesDeleted)).build();
    }

    private boolean isValidNuixEngineInstallation(File nuixInstallationFolder, Set<String> validSubFolders) {
        if (!nuixInstallationFolder.isDirectory()) {
            return false;
        }
        File[] subFolders = nuixInstallationFolder.listFiles();
        HashSet<String> subFolderNames = new HashSet<String>();
        if (subFolders == null) {
            return false;
        }
        for (File subFolder : subFolders) {
            subFolderNames.add(subFolder.getName());
        }
        return subFolderNames.containsAll(validSubFolders);
    }

    public void removeNotificationRuleId(String notificationRuleId) {
        for (ExecutionProfileModel executionProfile : this.executionProfiles.values()) {
            List notificationRuleIds = executionProfile.getNotificationRuleIds();
            if (notificationRuleIds != null) {
                notificationRuleIds.remove(notificationRuleId);
            }
            this.schedulerApplication.getSchedulerConfigurationDao().updateExecutionProfile(executionProfile);
        }
    }

    public Map<String, String> mergeProfiles(Map<String, String> original, Map<String, String> updated) {
        if (original != null) {
            original.forEach((key, value) -> updated.computeIfAbsent((String)key, n -> {
                if (updated.containsKey(n)) {
                    return value;
                }
                return null;
            }));
            return new LinkedHashMap<String, String>(updated);
        }
        return updated;
    }

    public Set<String> getExecutionProfileRequiredParameters(String id) {
        ExecutionProfileModel executionProfileModel = this.executionProfiles.get(id);
        if (executionProfileModel == null) {
            return new HashSet<String>();
        }
        return this.getExecutionProfileRequiredParameters(executionProfileModel, true);
    }

    public Set<String> getExecutionProfileRequiredParameters(ExecutionProfileModel executionProfileModel, boolean excludeExecutionProfileParameters) {
        HashSet<String> requiredParameters = new HashSet<String>();
        HashSet executionProfileParameters = new HashSet(executionProfileModel.getWorkflowParameters().keySet());
        Object parameterText = "";
        if (executionProfileModel.getEngineLogFolder() != null) {
            parameterText = (String)parameterText + executionProfileModel.getEngineLogFolder();
        }
        if (executionProfileModel.getEngineCommandLineParameters() != null) {
            parameterText = (String)parameterText + executionProfileModel.getEngineCommandLineParameters();
        }
        if (executionProfileModel.getNuixEngineFolder() != null) {
            parameterText = (String)parameterText + executionProfileModel.getNuixEngineFolder();
        }
        Pattern parameterPattern = Pattern.compile("\\{[a-z0-9_]+\\}");
        Matcher matcher = parameterPattern.matcher((CharSequence)parameterText);
        while (matcher.find()) {
            String parameterName = matcher.group().trim();
            if (excludeExecutionProfileParameters) {
                if (executionProfileParameters.contains(parameterName)) continue;
                requiredParameters.add(matcher.group());
                continue;
            }
            requiredParameters.add(matcher.group());
        }
        return requiredParameters;
    }

    private static boolean hasParameter(String text) {
        Pattern parameterPattern = Pattern.compile("\\{[a-z0-9_]+\\}");
        Matcher matcher = parameterPattern.matcher(text);
        return matcher.find();
    }

    private void trackExecutionProfileUtilization(ExecutionProfileModel executionProfileModel) {
        ExecutionProfile executionProfile = new ExecutionProfile();
        executionProfile.setExecutionProfileId(executionProfileModel.getId());
        executionProfile.setExecutionProfileName(executionProfileModel.getName());
        this.schedulerApplication.getUtilizationDaoV2().replaceExecutionProfile(executionProfile);
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<ExecutionProfile> executionProfiles = new HashSet<ExecutionProfile>();
        utilizationRecords.setExecutionProfiles(executionProfiles);
        executionProfiles.add(executionProfile);
        this.schedulerApplication.getAutomateLicenceResource().getLicenceSession().tryTrackUtilizationRecordsAsync(utilizationRecords);
    }
}

