/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.resources.NuixLicenceSourceResource;
import com.nuix.automate.scheduler.security.bearer.SystemBearerUser;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.exceptions.MissingScriptsPermissionException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileLibraryUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.general.SortingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.filelibrary.FileLibrary;
import com.nuix.automate.utils.models.api.filelibrary.FileLibraryFile;
import com.nuix.automate.utils.models.api.filelibrary.FileLibraryFileSubmission;
import com.nuix.automate.utils.models.api.filelibrary.FileLibrarySubmission;
import com.nuix.automate.utils.models.api.filelibrary.LibraryNuixFileType;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.workflow.ParameterType;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Path(value="/v1/scheduler/resources/fileLibraries")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class FileLibraryResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NuixLicenceSourceResource.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final String scriptLibraryId = "a2138cbd-d89e-4c6f-929a-00faecf2860a";
    private SchedulerApplication schedulerApplication;
    private Map<String, FileLibrary> fileLibraries;
    private FileLibraryUtils libraryUtils;

    public FileLibraryResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.fileLibraries = new TreeMap<String, FileLibrary>();
        this.libraryUtils = FileLibraryUtils.getInstance();
    }

    public FileLibrary createDefaultFileLibrary() {
        FileLibrary defaultFileLibrary = new FileLibrary();
        SystemBearerUser user = new SystemBearerUser();
        defaultFileLibrary.setName("Default Library");
        defaultFileLibrary.setDescription("Default File Library");
        defaultFileLibrary.setId(UidUtils.getRandom());
        defaultFileLibrary.setCreatedBy(user.getName());
        defaultFileLibrary.setCreatedDate(new DateTime(DateTimeZone.UTC).getMillis());
        defaultFileLibrary.setLastStateChangedDate(defaultFileLibrary.getCreatedDate());
        defaultFileLibrary.setFiles(new HashMap());
        this.fileLibraries.put(defaultFileLibrary.getId(), defaultFileLibrary);
        this.schedulerApplication.getSchedulerConfigurationDao().addFileLibrary(defaultFileLibrary);
        return defaultFileLibrary;
    }

    public FileLibrary createDefaultScriptedFileLibrary() {
        FileLibrary scriptedFileLibrary = new FileLibrary();
        SystemBearerUser user = new SystemBearerUser();
        scriptedFileLibrary.setName("Script Library");
        scriptedFileLibrary.setDescription("The default location for scripts");
        scriptedFileLibrary.setId("a2138cbd-d89e-4c6f-929a-00faecf2860a");
        scriptedFileLibrary.setCreatedBy(user.getName());
        scriptedFileLibrary.setCreatedDate(new DateTime(DateTimeZone.UTC).getMillis());
        scriptedFileLibrary.setLastStateChangedDate(scriptedFileLibrary.getCreatedDate());
        scriptedFileLibrary.setFiles(new HashMap());
        this.fileLibraries.put(scriptedFileLibrary.getId(), scriptedFileLibrary);
        this.schedulerApplication.getSchedulerConfigurationDao().addFileLibrary(scriptedFileLibrary);
        ResponseCache.getInstance().resetKeyId(CacheKey.FILE_LIBRARIES, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.FILE_LIBRARY_FILES, "a2138cbd-d89e-4c6f-929a-00faecf2860a");
        return scriptedFileLibrary;
    }

    public void initializeFileLibrariesFromStore() {
        LOGGER.info("Initializing File Libraries from store");
        List<FileLibrary> fileLibraries = this.schedulerApplication.getSchedulerConfigurationDao().getFileLibraries();
        for (FileLibrary library : fileLibraries) {
            HashMap<String, FileLibraryFile> fileLibraryFiles = new HashMap<String, FileLibraryFile>();
            List<FileLibraryFile> libraryFiles = this.schedulerApplication.getSchedulerConfigurationDao().getFilesForFileLibrary(library.getId());
            for (FileLibraryFile libraryFile : libraryFiles) {
                if (libraryFile.getVersion() == 0) {
                    libraryFile.setVersion(1);
                    this.schedulerApplication.getSchedulerConfigurationDao().updateFileLibraryFile(libraryFile);
                }
                fileLibraryFiles.put(libraryFile.getId(), libraryFile);
            }
            library.setFiles(fileLibraryFiles);
            this.fileLibraries.put(library.getId(), library);
        }
    }

    public FileLibrary getFileLibrary(String id) {
        return this.fileLibraries.get(id);
    }

    public FileLibraryFile getScriptFile(String fileId) {
        for (FileLibrary library : this.fileLibraries.values()) {
            FileLibraryFile script = (FileLibraryFile)library.getFiles().get(fileId);
            if (script == null) continue;
            return script;
        }
        return null;
    }

    public FileLibraryFile getFileFromLibrary(String id, String fileId) {
        FileLibrary library = this.fileLibraries.get(id);
        if (library != null) {
            return (FileLibraryFile)library.getFiles().get(fileId);
        }
        return null;
    }

    public FileLibraryFile resolveFileId(String id) {
        for (FileLibrary library : this.fileLibraries.values()) {
            if (library.getFiles() == null || library.getFiles().size() <= 0) continue;
            for (FileLibraryFile libraryFile : library.getFiles().values()) {
                if (!libraryFile.getId().equals(id)) continue;
                return libraryFile.clone();
            }
        }
        return null;
    }

    public Map<String, FileLibraryFile> getAllLibraryFiles() {
        HashMap<String, FileLibraryFile> files = new HashMap<String, FileLibraryFile>();
        for (FileLibrary library : this.fileLibraries.values()) {
            if (library.getFiles() == null || library.getFiles().size() <= 0) continue;
            files.putAll(library.getFiles());
        }
        return files;
    }

    public FileLibrary getDefaultLibrary() {
        for (FileLibrary library : this.fileLibraries.values()) {
            if (!library.getName().equalsIgnoreCase("Default Library")) continue;
            return library;
        }
        return null;
    }

    public Collection<FileLibrary> getFileLibraries() {
        return this.fileLibraries.values();
    }

    @Operation(tags={"File Libraries"}, operationId="GetFileLibraries", summary="Get File Libraries", description="Get full information of all file libraries", responses={@ApiResponse(description="The list of file libraries", content={@Content(array=@ArraySchema(schema=@Schema(implementation=FileLibrary.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getFileLibraries(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @QueryParam(value="includeFiles") boolean includeFiles, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.FILE_LIBRARIES, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ArrayList<FileLibrary> allowedFileLibraries = new ArrayList<FileLibrary>();
            for (FileLibrary library : this.fileLibraries.values()) {
                FileLibrary result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, library);
                if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                FileLibrary clonedLibrary = result.clone();
                if (!includeFiles) {
                    clonedLibrary.setFiles(null);
                } else if (clonedLibrary.getFiles() != null && !clonedLibrary.getFiles().isEmpty()) {
                    clonedLibrary.getFiles().forEach((k, v) -> v.setData(null));
                }
                allowedFileLibraries.add(clonedLibrary);
            }
            SortingUtils.sortList(allowedFileLibraries, FileLibrary::getName);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedFileLibraries).build();
        }
    }

    @Operation(tags={"File Libraries"}, operationId="GetFileLibrary", summary="Get File Library", description="Get the File Library with the specified ID", responses={@ApiResponse(description="The File Library", content={@Content(schema=@Schema(implementation=FileLibrary.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{fileLibraryId}")
    @GET
    public Response getFileLibrary(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the file library") @PathParam(value="fileLibraryId") String fileLibraryId, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.FILE_LIBRARY, fileLibraryId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            HashSet<Identifier> resourceIdentifier = new HashSet<Identifier>();
            resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_FILE_LIBRARIES));
            resourceIdentifier.add(new Identifier(IdentifierType.FILE_LIBRARY_ID, fileLibraryId));
            if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifier, Permission.VIEW)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)fileLibraryId);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
            FileLibrary library = this.fileLibraries.get(fileLibraryId);
            if (library == null) {
                return ExceptionUtils.toResponse((String)"fileLibraryNotFound", (Map)new HashMap<String, String>(){
                    {
                        this.put("fileLibraryId", fileLibraryId);
                    }
                }, (Response.Status)Response.Status.NOT_FOUND);
            }
            FileLibrary result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, library);
            if (!result.getUserPermissions().contains(Permission.VIEW)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
            result.setFiles(null);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
        }
    }

    @Operation(tags={"File Libraries"}, operationId="AddFileLibrary", summary="Add File Library", description="Add a new File Library", responses={@ApiResponse(description="The file library that was added", content={@Content(schema=@Schema(implementation=FileLibrary.class))}), @ApiResponse(responseCode="400", description="A file library with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Consumes(value={"application/json"})
    public synchronized Response addFileLibrary(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, @io.swagger.v3.oas.annotations.Parameter(description="The file library to add", schema=@Schema(implementation=FileLibrarySubmission.class)) FileLibrary fileLibrary) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifier = new HashSet<Identifier>();
        resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_FILE_LIBRARIES));
        if (!(user instanceof SystemBearerUser) && !this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifier, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)fileLibrary);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        FormattingUtils.trimAllStrings((Object)fileLibrary);
        if (fileLibrary.getName() == null || fileLibrary.getName().length() == 0) {
            return ExceptionUtils.toResponse((String)"errorAddingFileLibraryName", (Map)null);
        }
        for (final FileLibrary existingFileLibrary : this.fileLibraries.values()) {
            if (!existingFileLibrary.getName().equalsIgnoreCase(fileLibrary.getName())) continue;
            return ExceptionUtils.toResponse((String)"fileLibraryExists", (Map)new HashMap<String, String>(){
                {
                    this.put("existingFileLibrary", existingFileLibrary.getName());
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        FileLibrary result = this.addFileLibraryInternal(user, fileLibrary, ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request));
        if (!this.fileLibraries.containsKey(result.getId())) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        ResponseCache.getInstance().resetKeyId(CacheKey.FILE_LIBRARIES, "");
        result.setFiles(null);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    public FileLibrary addFileLibraryInternal(BearerUser user, FileLibrary fileLibrary, String remoteAddress) {
        fileLibrary.setId(UidUtils.getRandom());
        fileLibrary.setCreatedBy(user.getName());
        fileLibrary.setCreatedDate(new DateTime(DateTimeZone.UTC).getMillis());
        fileLibrary.setLastStateChangedDate(fileLibrary.getCreatedDate());
        fileLibrary.setFiles(new HashMap());
        FileLibrary result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, fileLibrary);
        if (user instanceof SystemBearerUser || result.getUserPermissions().contains(Permission.MODIFY)) {
            this.fileLibraries.put(result.getId(), fileLibrary);
            this.schedulerApplication.getSchedulerConfigurationDao().addFileLibrary(fileLibrary);
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.FILE_LIBRARY_ADDED, result, user.getName());
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), result.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.FILE_LIBRARY_ADDED, "", remoteAddress));
        }
        return result;
    }

    @Operation(tags={"File Libraries"}, operationId="UpdateFileLibrary", summary="Update File Library", description="Update the file library with the specified ID", responses={@ApiResponse(description="The updated file library", content={@Content(schema=@Schema(implementation=FileLibrary.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{fileLibraryId}")
    @PUT
    public Response updateFileLibrary(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the file library to update") @PathParam(value="fileLibraryId") String fileLibraryId, @io.swagger.v3.oas.annotations.Parameter(description="The information to update the file library with", schema=@Schema(implementation=FileLibrarySubmission.class)) FileLibrary fileLibrary) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifier = new HashSet<Identifier>();
        resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_FILE_LIBRARIES));
        resourceIdentifier.add(new Identifier(IdentifierType.FILE_LIBRARY_ID, fileLibraryId));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifier, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)fileLibraryId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        FileLibrary originalFileLibrary = this.fileLibraries.get(fileLibraryId);
        if (originalFileLibrary == null) {
            return ExceptionUtils.toResponse((String)"fileLibraryNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("fileLibraryId", fileLibraryId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        FormattingUtils.trimAllStrings((Object)fileLibrary);
        if (fileLibrary.getName() != null) {
            for (FileLibrary existingFileLibrary : this.fileLibraries.values()) {
                if (existingFileLibrary.getId().equals(fileLibraryId) || !fileLibrary.getName().equals(existingFileLibrary.getName())) continue;
                return ExceptionUtils.toResponse((String)"fileLibrarySameName", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
            }
            originalFileLibrary.setName(fileLibrary.getName());
        }
        if (fileLibrary.getDescription() != null) {
            originalFileLibrary.setDescription(fileLibrary.getDescription());
        }
        originalFileLibrary.setLastStateChangedDate(new DateTime(DateTimeZone.UTC).getMillis());
        if (this.schedulerApplication.getSchedulerConfigurationDao().updateFileLibrary(originalFileLibrary) == 0) {
            this.schedulerApplication.getSchedulerConfigurationDao().addFileLibrary(originalFileLibrary);
        }
        FileLibrary result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, fileLibrary);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.FILE_LIBRARY_MODIFIED, result, user.getName());
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), result.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.FILE_LIBRARY_MODIFIED, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        ResponseCache.getInstance().resetKeyId(CacheKey.FILE_LIBRARIES, "");
        result.setFiles(null);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"File Libraries"}, operationId="DeleteFileLibrary", summary="Delete File Library", description="Delete the file library with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="404", description="Cannot find file library with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{fileLibraryId}")
    @DELETE
    public Response deleteFileLibrary(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the file library to delete") @PathParam(value="fileLibraryId") String fileLibraryId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifier = new HashSet<Identifier>();
        resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_FILE_LIBRARIES));
        resourceIdentifier.add(new Identifier(IdentifierType.FILE_LIBRARY_ID, fileLibraryId));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifier, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)fileLibraryId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        FileLibrary deletedFileLibrary = this.fileLibraries.get(fileLibraryId);
        if (deletedFileLibrary == null) {
            return ExceptionUtils.toResponse((String)"fileLibraryNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("fileLibraryId", fileLibraryId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        if (deletedFileLibrary.getFiles() != null && deletedFileLibrary.getFiles().size() > 0) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotDeleteFileLibrary")).build();
        }
        deletedFileLibrary = this.fileLibraries.remove(fileLibraryId);
        this.schedulerApplication.getSchedulerConfigurationDao().deleteFileLibrary(fileLibraryId);
        if (deletedFileLibrary.getFiles() != null && deletedFileLibrary.getFiles().size() > 0) {
            for (FileLibraryFile file : deletedFileLibrary.getFiles().values()) {
                this.schedulerApplication.getSchedulerConfigurationDao().deleteFileLibraryFile(file.getId());
            }
        }
        FileLibrary result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, deletedFileLibrary);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.FILE_LIBRARY_DELETED, result, user.getName());
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), result.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.FILE_LIBRARY_DELETED, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        ResponseCache.getInstance().resetKeyId(CacheKey.FILE_LIBRARIES, "");
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("fileLibraryDeleted")).build();
    }

    @Operation(tags={"File Libraries"}, operationId="GetFileLibraryFiles", summary="Get File Library Files", description="Get full information of all file library files", responses={@ApiResponse(description="The list of file library files", content={@Content(array=@ArraySchema(schema=@Schema(implementation=FileLibraryFile.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{fileLibraryId}/files")
    @GET
    public Response getLibraryFiles(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the file library") @PathParam(value="fileLibraryId") String fileLibraryId, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.FILE_LIBRARY_FILES, fileLibraryId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            HashSet<Identifier> resourceIdentifier = new HashSet<Identifier>();
            resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_FILE_LIBRARIES));
            resourceIdentifier.add(new Identifier(IdentifierType.FILE_LIBRARY_ID, fileLibraryId));
            if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifier, Permission.VIEW)) {
                if (this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifier, Permission.VIEW_LIMITED)) {
                    return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(new ArrayList()).build();
                }
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)fileLibraryId);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
            FileLibrary library = this.fileLibraries.get(fileLibraryId);
            if (library == null) {
                return ExceptionUtils.toResponse((String)"fileLibraryNotFound", (Map)new HashMap<String, String>(){
                    {
                        this.put("fileLibraryId", fileLibraryId);
                    }
                }, (Response.Status)Response.Status.NOT_FOUND);
            }
            ArrayList<FileLibraryFile> files = new ArrayList<FileLibraryFile>();
            if (library.getFiles() != null && library.getFiles().size() > 0) {
                for (FileLibraryFile libraryFile : library.getFiles().values()) {
                    FileLibraryFile cloned = libraryFile.clone();
                    cloned.setData(null);
                    files.add(cloned);
                }
                SortingUtils.sortList(files, FileLibraryFile::getName);
            }
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(files).build();
        }
    }

    @Operation(tags={"File Libraries"}, operationId="GetFileLibraryFile", summary="Get File Library File", description="Get the File Library File with the specified ID", responses={@ApiResponse(description="The File Library File", content={@Content(schema=@Schema(implementation=FileLibraryFile.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{fileLibraryId}/files/{fileId}")
    @GET
    public Response getLibraryFile(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the file library") @PathParam(value="fileLibraryId") String fileLibraryId, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the library file") @PathParam(value="fileId") String fileId, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.FILE_LIBRARY_FILES, fileLibraryId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            HashSet<Identifier> resourceIdentifier = new HashSet<Identifier>();
            resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_FILE_LIBRARIES));
            resourceIdentifier.add(new Identifier(IdentifierType.FILE_LIBRARY_ID, fileLibraryId));
            Set<Permission> permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifier);
            if (!permissions.contains(Permission.VIEW)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)fileLibraryId);
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
            FileLibrary library = this.fileLibraries.get(fileLibraryId);
            if (library == null) {
                return ExceptionUtils.toResponse((String)"fileLibraryNotFound", (Map)new HashMap<String, String>(){
                    {
                        this.put("fileLibraryId", fileLibraryId);
                    }
                }, (Response.Status)Response.Status.NOT_FOUND);
            }
            FileLibraryFile file = (FileLibraryFile)library.getFiles().get(fileId);
            if (file == null) {
                return ExceptionUtils.toResponse((String)"fileLibraryFileNotFound", (Map)new HashMap<String, String>(){
                    {
                        this.put("fileLibraryFileId", fileId);
                    }
                }, (Response.Status)Response.Status.NOT_FOUND);
            }
            FileLibraryFile cloned = file.clone();
            if (permissions.contains(Permission.VIEW_SENSITIVE)) {
                cloned.getAuditLog().addAll(this.schedulerApplication.getAuditLogDao().getAuditEvents(cloned.getId()));
                cloned.getAuditLog().sort(Comparator.comparing(AuditEvent::getDate));
            }
            cloned.setData(null);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)cloned).build();
        }
    }

    @Operation(tags={"File Libraries"}, operationId="AddFileLibraryFile", summary="Add File Library File", description="Add a new File Library File", responses={@ApiResponse(description="The File Library File that was added", content={@Content(schema=@Schema(implementation=FileLibraryFile.class))}), @ApiResponse(responseCode="400", description="A file library file with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Path(value="/{fileLibraryId}/files")
    @Consumes(value={"application/json"})
    public synchronized Response addLibraryFile(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the file library") @PathParam(value="fileLibraryId") String fileLibraryId, @io.swagger.v3.oas.annotations.Parameter(description="The file library file to add", schema=@Schema(implementation=FileLibraryFileSubmission.class)) FileLibraryFile fileLibraryFile) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifier = new HashSet<Identifier>();
        resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_FILE_LIBRARIES));
        resourceIdentifier.add(new Identifier(IdentifierType.FILE_LIBRARY_ID, fileLibraryId));
        if (!(user instanceof SystemBearerUser) && !this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifier, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)fileLibraryId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        FileLibrary library = this.fileLibraries.get(fileLibraryId);
        if (library == null) {
            return ExceptionUtils.toResponse((String)"fileLibraryNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("fileLibraryId", fileLibraryId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        if (fileLibraryFile.getName() == null || fileLibraryFile.getName().length() == 0) {
            return ExceptionUtils.toResponse((String)"errorAddingFileLibraryFileName", (Map)null);
        }
        final String libraryFileName = fileLibraryFile.getName();
        try {
            fileLibraryFile = this.addLibraryFileInternal(user, fileLibraryId, fileLibraryFile, ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request));
        }
        catch (MissingScriptsPermissionException e) {
            return ExceptionUtils.toResponse((String)"missingLibraryFileScriptsPermission", (Map)new HashMap<String, String>(){
                {
                    this.put("libraryFileName", libraryFileName);
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        ResponseCache.getInstance().resetKeyId(CacheKey.FILE_LIBRARY_FILES, fileLibraryId);
        FileLibraryFile cloned = fileLibraryFile.clone();
        cloned.setData(null);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)cloned).build();
    }

    public FileLibraryFile addScriptedLibraryFile(FileLibraryFile fileLibraryFile, int copyNumber) {
        if (!this.fileLibraries.containsKey("a2138cbd-d89e-4c6f-929a-00faecf2860a")) {
            this.createDefaultScriptedFileLibrary();
        }
        fileLibraryFile.setFileLibraryId("a2138cbd-d89e-4c6f-929a-00faecf2860a");
        FileLibrary scriptFileLibrary = this.fileLibraries.get("a2138cbd-d89e-4c6f-929a-00faecf2860a");
        if (scriptFileLibrary.getFiles().size() > 0) {
            for (FileLibraryFile file : scriptFileLibrary.getFiles().values()) {
                if (!file.getName().equals(fileLibraryFile.getName())) continue;
                if (file.getData().equals(fileLibraryFile.getData())) {
                    return file;
                }
                fileLibraryFile.setName(fileLibraryFile.getName() + " (" + ++copyNumber + ")");
                this.addScriptedLibraryFile(fileLibraryFile, copyNumber);
            }
        }
        ResponseCache.getInstance().resetKeyId(CacheKey.FILE_LIBRARY_FILES, "a2138cbd-d89e-4c6f-929a-00faecf2860a");
        return this.addLibraryFileInternalSystem("a2138cbd-d89e-4c6f-929a-00faecf2860a", fileLibraryFile, "N/A");
    }

    public synchronized FileLibraryFile addLibraryFileInternalSystem(String fileLibraryId, FileLibraryFile fileLibraryFile, String remoteAddress) {
        SystemBearerUser user = new SystemBearerUser();
        try {
            fileLibraryFile = this.addLibraryFileInternal(user, fileLibraryId, fileLibraryFile, remoteAddress);
        }
        catch (Exception e) {
            LOGGER.error("Unable to to add file " + fileLibraryFile.getName(), (Throwable)e);
        }
        return fileLibraryFile;
    }

    public synchronized FileLibraryFile addLibraryFileInternal(BearerUser user, String fileLibraryId, FileLibraryFile fileLibraryFile, String remoteAddress) throws MissingScriptsPermissionException {
        fileLibraryFile.setId(UidUtils.getRandom());
        fileLibraryFile.setCreatedBy(user.getName());
        fileLibraryFile.setCreatedDate(new DateTime(DateTimeZone.UTC).getMillis());
        fileLibraryFile.setLastStateChangedDate(fileLibraryFile.getCreatedDate());
        byte[] fileData = FileUtils.decodeFileData((String)fileLibraryFile.getData());
        fileLibraryFile.setSize((long)fileData.length);
        fileLibraryFile.setNuixFileType(this.libraryUtils.getNuixFileType(fileLibraryFile));
        fileLibraryFile.setVersion(1);
        if (this.libraryUtils.isScriptedFile(fileLibraryFile)) {
            HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
            scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.SCRIPTS));
            Set<Permission> scriptParameterPermissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), scopeIdentifiers);
            if (!(user instanceof SystemBearerUser) && !scriptParameterPermissions.contains(Permission.MODIFY)) {
                throw new MissingScriptsPermissionException();
            }
        }
        ArrayList<String> eventAttributes = new ArrayList<String>();
        eventAttributes.add(this.iu.getFormattedString("FileLibrary.Audit.FileName", (Object)fileLibraryFile.getName()));
        eventAttributes.add(this.iu.getFormattedString("FileLibrary.Audit.FileType", (Object)this.iu.getString("FileLibrary.Audit.FileType." + fileLibraryFile.getNuixFileType().name())));
        eventAttributes.add(this.iu.getFormattedString("FileLibrary.Audit.FileSize", (Object)FormattingUtils.sizeToDisplaySize((long)fileLibraryFile.getSize())));
        eventAttributes.add(this.iu.getFormattedString("FileLibrary.Audit.FileVersion", (Object)String.valueOf(fileLibraryFile.getVersion())));
        if (fileLibraryFile.getDescription() != null && fileLibraryFile.getDescription().length() > 0) {
            eventAttributes.add(this.iu.getFormattedString("FileLibrary.Audit.FileNotes", (Object)fileLibraryFile.getDescription()));
        }
        this.fileLibraries.get(fileLibraryId).getFiles().put(fileLibraryFile.getId(), fileLibraryFile);
        this.schedulerApplication.getSchedulerConfigurationDao().addFileLibraryFile(fileLibraryFile);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.FILE_LIBRARY_FILE_ADDED, fileLibraryFile, user.getName());
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), fileLibraryFile.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.FILE_LIBRARY_FILE_ADDED, String.join((CharSequence)"\n", eventAttributes), remoteAddress));
        return fileLibraryFile;
    }

    @Operation(tags={"File Libraries"}, operationId="UpdateFileLibraryFile", summary="Update File Library File", description="Update the file library file with the specified ID", responses={@ApiResponse(description="The updated file libray file", content={@Content(schema=@Schema(implementation=FileLibraryFile.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{fileLibraryId}/files/{fileId}")
    @PUT
    public Response updateLibraryFile(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the file library") @PathParam(value="fileLibraryId") String fileLibraryId, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the file library file to update") @PathParam(value="fileId") String fileId, @io.swagger.v3.oas.annotations.Parameter(description="The information to update the file library file with", schema=@Schema(implementation=FileLibraryFileSubmission.class)) FileLibraryFile fileLibraryFile) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifier = new HashSet<Identifier>();
        resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_FILE_LIBRARIES));
        resourceIdentifier.add(new Identifier(IdentifierType.FILE_LIBRARY_ID, fileLibraryId));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifier, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)fileLibraryId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        FileLibrary library = this.fileLibraries.get(fileLibraryId);
        if (library == null) {
            return ExceptionUtils.toResponse((String)"fileLibraryNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("fileLibraryId", fileLibraryId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        final FileLibraryFile originalFileLibraryFile = (FileLibraryFile)library.getFiles().get(fileId);
        if (originalFileLibraryFile == null) {
            return ExceptionUtils.toResponse((String)"fileLibraryFileNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("fileLibraryFileId", fileId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        if (!originalFileLibraryFile.getName().equals(fileLibraryFile.getName())) {
            return ExceptionUtils.toResponse((String)"fileLibraryFileNameChanged", (Map)new HashMap<String, String>(){
                {
                    this.put("originalFileName", originalFileLibraryFile.getName());
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        if (this.libraryUtils.isScriptedFile(originalFileLibraryFile)) {
            HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
            scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.SCRIPTS));
            Set<Permission> scriptParameterPermissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), scopeIdentifiers);
            if (!scriptParameterPermissions.contains(Permission.MODIFY)) {
                return ExceptionUtils.toResponse((String)"missingLibraryFileScriptsPermission", (Map)new HashMap<String, String>(){
                    {
                        this.put("libraryFileName", originalFileLibraryFile.getName());
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        ArrayList<String> eventAttributes = new ArrayList<String>();
        if (fileLibraryFile.getData() != null) {
            final LibraryNuixFileType nuixFileType = this.libraryUtils.getNuixFileType(fileLibraryFile);
            if (nuixFileType != originalFileLibraryFile.getNuixFileType()) {
                return ExceptionUtils.toResponse((String)"cannotUpdateLibraryFile", (Map)new HashMap<String, String>(){
                    {
                        this.put("originalType", FileLibraryResource.this.iu.getString("FileLibrary.Audit.FileType." + String.valueOf(originalFileLibraryFile.getNuixFileType())));
                        this.put("updatedType", FileLibraryResource.this.iu.getString("FileLibrary.Audit.FileType." + String.valueOf(nuixFileType)));
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
            originalFileLibraryFile.setData(fileLibraryFile.getData());
            if (originalFileLibraryFile.getNuixFileType() != nuixFileType) {
                eventAttributes.add(this.iu.getFormattedString("FileLibrary.Audit.FileType", (Object)this.iu.getString("FileLibrary.Audit.FileType." + nuixFileType.name())));
            }
            originalFileLibraryFile.setNuixFileType(nuixFileType);
            byte[] fileData = FileUtils.decodeFileData((String)fileLibraryFile.getData());
            long size = fileData.length;
            if (originalFileLibraryFile.getSize() != size) {
                eventAttributes.add(this.iu.getFormattedString("FileLibrary.Audit.FileSize", (Object)FormattingUtils.sizeToDisplaySize((long)size)));
            }
            originalFileLibraryFile.setSize(size);
        }
        originalFileLibraryFile.setVersion(originalFileLibraryFile.getVersion() + 1);
        eventAttributes.add(this.iu.getFormattedString("FileLibrary.Audit.FileVersion", (Object)String.valueOf(originalFileLibraryFile.getVersion())));
        if (fileLibraryFile.getDescription() != null) {
            if (!fileLibraryFile.getDescription().equals(originalFileLibraryFile.getDescription())) {
                eventAttributes.add(this.iu.getFormattedString("FileLibrary.Audit.FileNotes", (Object)fileLibraryFile.getDescription()));
            }
            originalFileLibraryFile.setDescription(fileLibraryFile.getDescription());
        }
        originalFileLibraryFile.setLastStateChangedDate(new DateTime(DateTimeZone.UTC).getMillis());
        if (this.schedulerApplication.getSchedulerConfigurationDao().updateFileLibraryFile(originalFileLibraryFile) == 0) {
            this.schedulerApplication.getSchedulerConfigurationDao().addFileLibraryFile(originalFileLibraryFile);
        }
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.FILE_LIBRARY_FILE_MODIFIED, originalFileLibraryFile, user.getName());
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), originalFileLibraryFile.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.FILE_LIBRARY_FILE_MODIFIED, eventAttributes.size() > 0 ? String.join((CharSequence)"\n", eventAttributes) : "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        ResponseCache.getInstance().resetKeyId(CacheKey.FILE_LIBRARY_FILES, fileLibraryId);
        FileLibraryFile cloned = originalFileLibraryFile.clone();
        cloned.setData(null);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)cloned).build();
    }

    @Operation(tags={"File Libraries"}, operationId="UpdateFileLibraryFileContent", summary="Update File Library File Content", description="Update the contents of the file library file with the specified ID", responses={@ApiResponse(description="The updated file libray file", content={@Content(schema=@Schema(implementation=FileLibraryFile.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{fileLibraryId}/files/{fileId}/content")
    @PUT
    public Response updateLibraryFileContent(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the file library") @PathParam(value="fileLibraryId") String fileLibraryId, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the file library file to update") @PathParam(value="fileId") String fileId, @io.swagger.v3.oas.annotations.Parameter(description="The information to update the file library file content with") String content) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifier = new HashSet<Identifier>();
        resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_FILE_LIBRARIES));
        resourceIdentifier.add(new Identifier(IdentifierType.FILE_LIBRARY_ID, fileLibraryId));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifier, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)fileLibraryId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        FileLibrary library = this.fileLibraries.get(fileLibraryId);
        if (library == null) {
            return ExceptionUtils.toResponse((String)"fileLibraryNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("fileLibraryId", fileLibraryId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        FileLibraryFile originalFileLibraryFile = (FileLibraryFile)library.getFiles().get(fileId);
        if (originalFileLibraryFile == null) {
            return ExceptionUtils.toResponse((String)"fileLibraryFileNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("fileLibraryFileId", fileId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        ArrayList<String> eventAttributes = new ArrayList<String>();
        byte[] contentBytes = content.getBytes(StandardCharsets.UTF_8);
        long size = contentBytes.length;
        if (originalFileLibraryFile.getSize() != size) {
            eventAttributes.add(this.iu.getFormattedString("FileLibrary.Audit.FileSize", (Object)FormattingUtils.sizeToDisplaySize((long)size)));
        }
        originalFileLibraryFile.setSize(size);
        originalFileLibraryFile.setVersion(originalFileLibraryFile.getVersion() + 1);
        eventAttributes.add(this.iu.getFormattedString("FileLibrary.Audit.FileVersion", (Object)String.valueOf(originalFileLibraryFile.getVersion())));
        originalFileLibraryFile.setLastStateChangedDate(new DateTime(DateTimeZone.UTC).getMillis());
        originalFileLibraryFile.setData(Base64.getEncoder().encodeToString(contentBytes));
        if (this.schedulerApplication.getSchedulerConfigurationDao().updateFileLibraryFile(originalFileLibraryFile) == 0) {
            this.schedulerApplication.getSchedulerConfigurationDao().addFileLibraryFile(originalFileLibraryFile);
        }
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.FILE_LIBRARY_FILE_MODIFIED, originalFileLibraryFile, user.getName());
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), originalFileLibraryFile.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.FILE_LIBRARY_FILE_MODIFIED, eventAttributes.size() > 0 ? String.join((CharSequence)"\n", eventAttributes) : "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        ResponseCache.getInstance().resetKeyId(CacheKey.FILE_LIBRARY_FILES, fileLibraryId);
        FileLibraryFile cloned = originalFileLibraryFile.clone();
        cloned.setData(null);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)cloned).build();
    }

    @Operation(tags={"File Libraries"}, operationId="DeleteFileLibraryFile", summary="Delete File Library File", description="Delete the file library file with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="404", description="Cannot find file library file with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{fileLibraryId}/files/{fileId}")
    @DELETE
    public Response deleteLibraryFile(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the file library") @PathParam(value="fileLibraryId") String fileLibraryId, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the file library file to delete") @PathParam(value="fileId") String fileId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifier = new HashSet<Identifier>();
        resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_FILE_LIBRARIES));
        resourceIdentifier.add(new Identifier(IdentifierType.FILE_LIBRARY_ID, fileLibraryId));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifier, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)fileLibraryId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        FileLibrary library = this.fileLibraries.get(fileLibraryId);
        if (library == null) {
            return ExceptionUtils.toResponse((String)"fileLibraryNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("fileLibraryId", fileLibraryId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        FileLibraryFile deletedFileLibraryFile = (FileLibraryFile)library.getFiles().get(fileId);
        if (deletedFileLibraryFile == null) {
            return ExceptionUtils.toResponse((String)"fileLibraryFileNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("fileLibraryFileId", fileId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        final String deletedFileName = deletedFileLibraryFile.getName();
        for (final ExecutionProfileModel executionProfile : this.schedulerApplication.getExecutionProfileResource().getExecutionProfiles()) {
            if ((executionProfile.getNuixProfiles() == null || !executionProfile.getNuixProfiles().containsKey(fileId)) && (executionProfile.getAdditionalFiles() == null || !executionProfile.getAdditionalFiles().containsValue(fileId))) continue;
            return ExceptionUtils.toResponse((String)"cannotDeleteLibraryFile", (Map)new HashMap<String, String>(){
                {
                    this.put("fileName", deletedFileName);
                    this.put("executionProfileName", executionProfile.getName());
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Response workflowErrorResponse = this.verifyNotUsedInWorkflow(user, fileId);
        if (workflowErrorResponse != null) {
            return workflowErrorResponse;
        }
        Response jobErrorResponse = this.verifyNotUsedInJobs(user, fileId);
        if (jobErrorResponse != null) {
            return jobErrorResponse;
        }
        deletedFileLibraryFile = (FileLibraryFile)library.getFiles().remove(fileId);
        this.schedulerApplication.getSchedulerConfigurationDao().deleteFileLibraryFile(fileId);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.FILE_LIBRARY_FILE_DELETED, deletedFileLibraryFile, user.getName());
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), deletedFileLibraryFile.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.FILE_LIBRARY_FILE_DELETED, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        ResponseCache.getInstance().resetKeyId(CacheKey.FILE_LIBRARY_FILES, fileLibraryId);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("fileLibraryFileDeleted")).build();
    }

    @Operation(tags={"File Libraries"}, operationId="DownloadFileLibraryFile", summary="Download File Library File", description="Download the File Library File with the specified ID", responses={@ApiResponse(description="The File Library File Data", content={@Content(schema=@Schema(implementation=String.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{fileLibraryId}/files/{fileId}/download")
    @GET
    public Response downloadLibraryFile(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the file library") @PathParam(value="fileLibraryId") String fileLibraryId, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the library file") @PathParam(value="fileId") String fileId, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifier = new HashSet<Identifier>();
        resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifier.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_FILE_LIBRARIES));
        resourceIdentifier.add(new Identifier(IdentifierType.FILE_LIBRARY_ID, fileLibraryId));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifier, Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)fileLibraryId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        FileLibrary library = this.fileLibraries.get(fileLibraryId);
        if (library == null) {
            return ExceptionUtils.toResponse((String)"fileLibraryNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("fileLibraryId", fileLibraryId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        FileLibraryFile file = (FileLibraryFile)library.getFiles().get(fileId);
        if (file == null) {
            return ExceptionUtils.toResponse((String)"fileLibraryFileNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("fileLibraryFileId", fileId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)file.getData()).build();
    }

    private Set<String> getNamesOfWorkflowsUsingLibraryFileId(BearerUser user, String libraryFileId) {
        TreeSet<String> workflowNames = new TreeSet<String>();
        for (Workflow workflow : this.schedulerApplication.getLibraryResource().getWorkflowsUsingLibraryFileId(libraryFileId)) {
            Set workflowPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflow).getUserPermissions();
            if (workflowPermissions.contains(Permission.VIEW)) {
                workflowNames.add(workflow.getName());
                continue;
            }
            workflowNames.add(this.iu.getString("Schedule.Name.Other"));
        }
        return workflowNames;
    }

    private Response verifyNotUsedInWorkflow(BearerUser user, String libraryFileId) {
        Set<String> workflowNames = this.getNamesOfWorkflowsUsingLibraryFileId(user, libraryFileId);
        if (workflowNames.size() > 0) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("workflowNames", String.join((CharSequence)"\n", workflowNames));
            return ExceptionUtils.toResponse((String)"errorDeletingLibraryFileUsedByWorkflow", properties);
        }
        return null;
    }

    private Set<String> getNamesOfJobsUsingFileLibraryFile(BearerUser user, String libraryFileId) {
        HashSet<String> jobNames = new HashSet<String>();
        for (JobDetailsModel job : this.schedulerApplication.getJobResource().getNonFinishedJobs()) {
            AtomicBoolean containsLibraryFile = new AtomicBoolean(false);
            for (Parameter sessionParameter : job.getSettings().getSessionParameters()) {
                if (!sessionParameter.getDisplayCondition().getDisplayable() || ParameterType.LIBRARY_FILE != sessionParameter.getParameterType()) continue;
                containsLibraryFile.set(libraryFileId.equals(sessionParameter.getValue()));
                break;
            }
            if (!containsLibraryFile.get()) continue;
            if (user == null) {
                jobNames.add(this.iu.getString("Job.Name.Other"));
                continue;
            }
            JobModel jobModel = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissionsInternal(user, job.getSettings());
            if (jobModel.getUserPermissions().contains(Permission.VIEW)) {
                jobNames.add(jobModel.getName());
                continue;
            }
            jobNames.add(this.iu.getString("Job.Name.Other"));
        }
        return jobNames;
    }

    private Response verifyNotUsedInJobs(BearerUser user, String libraryFileId) {
        Set<String> jobNames = this.getNamesOfJobsUsingFileLibraryFile(user, libraryFileId);
        if (jobNames.size() > 0) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("jobNames", String.join((CharSequence)"\n", jobNames));
            return ExceptionUtils.toResponse((String)"errorDeletingLibraryFileUsedByJob", properties);
        }
        return null;
    }
}

