/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.bearer.OfflineBearerUser;
import com.nuix.automate.scheduler.security.bearer.OfflineUser;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.schedule.HttpVerb;
import com.nuix.automate.utils.models.api.schedule.Run;
import com.nuix.automate.utils.models.api.schedule.Schedule;
import com.nuix.automate.utils.models.api.schedule.WebhookSignatureException;
import com.nuix.automate.utils.models.api.schedule.WebhookTriggerHeader;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.security.SecurityUtils;
import com.nuix.automate.utils.workflow.ExecutionState;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Path(value="/webhook")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class IncomingWebhookResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(IncomingWebhookResource.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;

    public IncomingWebhookResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
    }

    @PUT
    @Path(value="/{scheduleId}/{accessKey}")
    @Consumes(value={"*/*"})
    public Response webhookPut(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, @Context UriInfo uriInfo, @PathParam(value="scheduleId") String scheduleId, @PathParam(value="accessKey") String accessKey, @QueryParam(value="silent") boolean silent, String body) {
        return this.webhookRequest(request, uriInfo, scheduleId, accessKey, silent, body, HttpVerb.PUT);
    }

    @POST
    @Path(value="/{scheduleId}/{accessKey}")
    @Consumes(value={"*/*"})
    public Response webhookPost(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, @Context UriInfo uriInfo, @PathParam(value="scheduleId") String scheduleId, @PathParam(value="accessKey") String accessKey, @QueryParam(value="silent") boolean silent, String body) {
        return this.webhookRequest(request, uriInfo, scheduleId, accessKey, silent, body, HttpVerb.POST);
    }

    @GET
    @Path(value="/{scheduleId}/{accessKey}")
    @Consumes(value={"*/*"})
    public Response webhookGet(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, @Context UriInfo uriInfo, @PathParam(value="scheduleId") String scheduleId, @PathParam(value="accessKey") String accessKey, @QueryParam(value="silent") boolean silent) {
        return this.webhookRequest(request, uriInfo, scheduleId, accessKey, silent, null, HttpVerb.GET);
    }

    private Response webhookRequest(HttpServletRequest request, UriInfo uriInfo, String scheduleId, String accessKey, boolean silent, String body, HttpVerb httpVerb) {
        Run run;
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        Schedule schedule = this.getWebhookSchedule(scheduleId, accessKey, httpVerb);
        if (schedule == null) {
            responseData.put("status", "Error");
            responseData.put("errorMessage", "Cannot find Schedule with the specified path");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(responseData).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        if (!this.schedulerApplication.getScheduleWorker().scheduleConditionsMet(schedule)) {
            responseData.put("status", "Error");
            responseData.put("errorMessage", "Schedule not active or conditions not met");
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity(responseData).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        responseData.put("scheduleId", schedule.getId());
        if (schedule.getWebhookTrigger().getSignatureKey() != null && schedule.getWebhookTrigger().getSignatureKey().length() > 0) {
            try {
                this.checkSignature(request, body, schedule);
            }
            catch (WebhookSignatureException e) {
                responseData.put("status", "Error");
                responseData.put("errorMessage", e.getMessage());
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity(responseData).type(MediaType.APPLICATION_JSON_TYPE).build();
            }
        }
        try {
            run = this.queueJob(request, schedule, body);
            if (run.getJobState() == ExecutionState.ERROR) {
                responseData.put("status", "Error");
                responseData.put("errorMessage", run.getError());
                responseData.put("runId", run.getId());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(responseData).build();
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot add Job from WebHook Schedule " + schedule.getId(), (Throwable)e);
            responseData.put("status", "Error");
            responseData.put("errorMessage", e.getMessage());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).entity(responseData).build();
        }
        if (silent) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        String responseBody = "{\"jobId\":\"{job_id}\",\"runId\":\"{run_id}\",\"scheduleId\":\"{schedule_id}\",\"status\":\"{status}\"}";
        if (schedule.getWebhookTrigger().getBody() != null && schedule.getWebhookTrigger().getBody().length() > 0) {
            responseBody = schedule.getWebhookTrigger().getBody();
        }
        responseBody = responseBody.replace("{job_id}", run.getJobId());
        responseBody = responseBody.replace("{run_id}", run.getId());
        responseBody = responseBody.replace("{status}", "OK");
        responseBody = responseBody.replace("{schedule_id}", scheduleId);
        String libraryId = "";
        if (schedule.getLibraryId() != null) {
            libraryId = schedule.getLibraryId();
        }
        responseBody = responseBody.replace("{library_id}", libraryId);
        String libraryWorkflowId = "";
        if (schedule.getLibraryWorkflowId() != null) {
            libraryWorkflowId = schedule.getLibraryWorkflowId();
        }
        responseBody = responseBody.replace("{workflow_id}", libraryWorkflowId);
        String clientId = "";
        if (schedule.getClientId() != null) {
            clientId = schedule.getClientId();
        }
        responseBody = responseBody.replace("{client_id}", clientId);
        String matterId = "";
        if (schedule.getMatterId() != null) {
            matterId = schedule.getMatterId();
        }
        responseBody = responseBody.replace("{matter_id}", matterId);
        ArrayList<WebhookTriggerHeader> headers = new ArrayList<WebhookTriggerHeader>(schedule.getWebhookTrigger().getHeaders());
        String contentType = "application/json";
        if (headers.size() == 0) {
            headers.add(new WebhookTriggerHeader("Content-Type", "application/json", ""));
        } else {
            for (WebhookTriggerHeader header : headers) {
                if (!header.getName().equalsIgnoreCase("Content-Type")) continue;
                contentType = header.getValue();
            }
        }
        int responseCode = 200;
        if (schedule.getWebhookTrigger().getResponseCode() != null && schedule.getWebhookTrigger().getResponseCode() > 0) {
            responseCode = schedule.getWebhookTrigger().getResponseCode();
        }
        Response.ResponseBuilder builder = Response.status((int)responseCode);
        for (WebhookTriggerHeader header : headers) {
            builder.header(header.getName(), (Object)header.getValue());
        }
        builder.type(contentType);
        builder.entity((Object)responseBody);
        return builder.build();
    }

    private Schedule getWebhookSchedule(String scheduleId, String accessKey, HttpVerb httpVerb) {
        Schedule schedule = this.schedulerApplication.getScheduleResource().getSchedule(scheduleId);
        if (schedule != null && schedule.getWebhookTrigger() != null && schedule.getWebhookTrigger().getAccessKey().equals(accessKey) && schedule.getWebhookTrigger().getHttpVerb().equals((Object)httpVerb)) {
            return schedule;
        }
        return null;
    }

    private void checkSignature(HttpServletRequest request, String postBody, Schedule schedule) throws WebhookSignatureException {
        if (schedule.getWebhookTrigger().getHttpVerb().equals((Object)HttpVerb.GET)) {
            throw new WebhookSignatureException(this.iu.getString("WebhookSignatureException.SignatureNotSupportedWithGet"));
        }
        String suppliedSignature = request.getHeader("X-Hmac-Sha512");
        if (suppliedSignature == null) {
            throw new WebhookSignatureException(this.iu.getString("WebhookSignatureException.MissingHmacHeader"));
        }
        String expectedSignature = null;
        try {
            expectedSignature = SecurityUtils.computeHmacHex((String)postBody, (String)schedule.getWebhookTrigger().getSignatureKey());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            LOGGER.error("Cannot compute signature", (Throwable)e);
            throw new WebhookSignatureException(this.iu.getString("WebhookSignatureException.CannotComputeHmac"));
        }
        if (!expectedSignature.equals(suppliedSignature)) {
            throw new WebhookSignatureException(this.iu.getString("WebhookSignatureException.InvalidHmac"));
        }
    }

    private Run queueJob(HttpServletRequest request, Schedule schedule, String body) {
        JobModel queueJob = new JobModel();
        Run run = new Run();
        try {
            queueJob.setScheduleId(schedule.getId());
            queueJob.setName(schedule.getName());
            queueJob.setNotes(schedule.getDescription());
            queueJob.setMatterId(schedule.getMatterId());
            queueJob.setLibraryWorkflowId(schedule.getLibraryWorkflowId());
            List scheduleParameters = schedule.getSessionParameters();
            queueJob.setSessionParameters(new ArrayList(scheduleParameters));
            queueJob.setPriority(schedule.getPriority());
            queueJob.setResourcePoolId(schedule.getResourcePoolId());
            queueJob.setExecutionProfileId(schedule.getExecutionProfileId());
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.API_ADVANCED);
        }
        catch (Exception e) {
            LOGGER.error("Cannot queue job from schedule", (Throwable)e);
            run.setJobState(ExecutionState.ERROR);
            run.setError((Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
        }
        List sessionParamters = queueJob.getSessionParameters();
        sessionParamters.add(new Parameter("{webhook_body}", body));
        sessionParamters.add(new Parameter("{webhook_schedule_id}", schedule.getId()));
        sessionParamters.add(new Parameter("{webhook_schedule_name}", schedule.getName()));
        sessionParamters.add(new Parameter("{webhook_parameters}", SerializationUtils.toJson((Object)request.getParameterMap())));
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (headerName.equalsIgnoreCase("Authorization")) continue;
            headers.put(headerName, request.getHeader(headerName));
        }
        sessionParamters.add(new Parameter("{webhook_headers}", SerializationUtils.toJson(headers)));
        String description = this.iu.getString("ScheduleResource.SubmissionDescriptionWebhook");
        run.setTriggerDescription(description);
        long runDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        this.queueScheduleRun(schedule, queueJob, run, runDate);
        return run;
    }

    private void queueScheduleRun(Schedule schedule, JobModel queueJob, Run run, long runDate) {
        LOGGER.info(String.valueOf(schedule) + " queuing job");
        if (run.getJobState() != ExecutionState.ERROR) {
            try {
                if (schedule.getLastModifiedByUserId() == null) {
                    throw new IllegalStateException("Schedule is missing lastModifiedByUserId property");
                }
                OfflineUser offlineUser = this.schedulerApplication.getSecurityDao().getOfflineUser(schedule.getLastModifiedByUserId());
                OfflineBearerUser offlineBearerUser = new OfflineBearerUser(offlineUser);
                Response response = this.schedulerApplication.getJobResource().addProcessingJob(offlineBearerUser, null, null, queueJob);
                if (response.getStatus() != 200) {
                    LOGGER.error("Cannot queue job from schedule, " + String.valueOf(response));
                    queueJob.setId(null);
                    run.setJobState(ExecutionState.ERROR);
                    run.setError(ExceptionUtils.fromResponse((Response)response));
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot queue job from schedule", (Throwable)e);
                run.setJobState(ExecutionState.ERROR);
                run.setError((Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
            }
        }
        run.setDate(Long.valueOf(runDate));
        if (run.getJobState() != ExecutionState.ERROR) {
            run.setJobId(queueJob.getId());
        }
        run.setScheduleId(schedule.getId());
        run.setId(UidUtils.getRandom());
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.SCHEDULE_TRIGGERED, run, schedule.getLastModifiedBy());
        this.schedulerApplication.getJobsDao().addScheduleRun(run);
    }
}

