/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.lock.Lock;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Path(value="/v1/scheduler/lock")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class LockResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LockResource.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;
    private final Map<String, Lock> activeLocks;

    public LockResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.activeLocks = new HashMap<String, Lock>();
    }

    public void initializeFromStore() {
        LOGGER.info("Initializing Locks from store");
        List<Lock> locks = this.schedulerApplication.getSchedulerConfigurationDao().getLocks();
        for (Lock lock : locks) {
            this.activeLocks.put(lock.getName(), lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(tags={"Lock"}, operationId="TryAcquireLock", summary="Try Acquire Lock", description="Try to acquire a lock for the job", responses={@ApiResponse(description="The status of the acquire command", content={@Content(schema=@Schema(implementation=Boolean.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Path(value="/{jobId}")
    @Consumes(value={"application/json"})
    public Response tryAcquireLock(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The job ID") @PathParam(value="jobId") String jobId, @Parameter(description="The name of the lock") @QueryParam(value="lockName") String lockName) {
        boolean result;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        LOGGER.info("Locks - Try acquire lock " + lockName + " for job " + jobId);
        LockResource lockResource = this;
        synchronized (lockResource) {
            Lock activeLock;
            block12: {
                activeLock = this.activeLocks.get(lockName);
                if (activeLock == null) {
                    LOGGER.info("Lock was not previously set");
                    activeLock = new Lock(lockName);
                    activeLock.getJobIds().add(jobId);
                    this.activeLocks.put(lockName, activeLock);
                    result = true;
                } else {
                    List lockJobIds = activeLock.getJobIds();
                    while (true) {
                        if (lockJobIds.isEmpty()) {
                            LOGGER.info("Lock was not previously set");
                            lockJobIds.add(jobId);
                            result = true;
                            break block12;
                        }
                        String firstJobId = (String)lockJobIds.get(0);
                        if (firstJobId.equals(jobId)) {
                            LOGGER.info("Lock was previously set and this job is first in line");
                            result = true;
                            break block12;
                        }
                        JobDetailsModel firstJobInLine = this.schedulerApplication.getJobResource().getRunningJobModel(firstJobId);
                        if (firstJobInLine != null) break;
                        LOGGER.info("Lock was previously set and previous job is not running anymore");
                        lockJobIds.remove(0);
                    }
                    if (!lockJobIds.contains(jobId)) {
                        LOGGER.info("Lock was previously set and other jobs are in line, adding this job to the queue");
                        lockJobIds.add(jobId);
                    }
                    result = false;
                }
            }
            if (result) {
                LOGGER.info("Lock acquired");
            } else {
                LOGGER.info("Lock not acquired");
            }
            if (activeLock.getJobIds().isEmpty()) {
                this.activeLocks.remove(activeLock.getName());
            }
            this.updateLockDatabase(activeLock);
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(tags={"Lock"}, operationId="ReleaseLock", summary="Release Lock", description="Release the lock for the job", responses={@ApiResponse(description="The status of the release command", content={@Content(schema=@Schema(implementation=Boolean.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @DELETE
    @Path(value="/{jobId}")
    @Consumes(value={"application/json"})
    public Response releaseLock(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The job ID") @PathParam(value="jobId") String jobId, @Parameter(description="The name of the lock") @QueryParam(value="lockName") String lockName) {
        boolean result;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        LOGGER.info("Locks - Release lock " + lockName + " for job " + jobId);
        LockResource lockResource = this;
        synchronized (lockResource) {
            Lock activeLock = this.activeLocks.get(lockName);
            if (activeLock == null) {
                LOGGER.info("Lock was not previously set");
                result = false;
            } else {
                List lockJobIds = activeLock.getJobIds();
                if (lockJobIds.isEmpty()) {
                    LOGGER.info("Lock was not previously set");
                    result = false;
                } else {
                    String firstJobId = (String)lockJobIds.get(0);
                    result = firstJobId.equals(jobId);
                    if (result) {
                        LOGGER.info("Lock released");
                    } else {
                        LOGGER.info("Lock was not held by this job");
                    }
                    lockJobIds.remove(jobId);
                }
            }
            if (activeLock != null && activeLock.getJobIds().isEmpty()) {
                this.activeLocks.remove(activeLock.getName());
            }
            if (activeLock != null) {
                this.updateLockDatabase(activeLock);
            }
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    private void updateLockDatabase(Lock lock) {
        if (lock.getJobIds().isEmpty()) {
            String lockId = UidUtils.fromString((String)lock.getName());
            this.schedulerApplication.getSchedulerConfigurationDao().deleteLock(lockId);
        } else {
            this.schedulerApplication.getSchedulerConfigurationDao().addOrUpdateLock(lock);
        }
    }
}

