/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.persistance.logging.LoggingDao;
import com.nuix.automate.scheduler.persistance.logging.LoggingDataSourceDetails;
import com.nuix.automate.scheduler.persistance.logging.RolloverLoggingHelper;
import com.nuix.automate.scheduler.utils.LogWriter;
import com.nuix.automate.scheduler.utils.ZippedLogsStreamingOutput;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.ResponseUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.Auth;
import io.dropwizard.auth.AuthenticationException;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Path(value="/v1/scheduler/resources/logs")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class LogsResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LogsResource.class);
    private SchedulerApplication schedulerApplication;
    private LogWriter writer;
    private final RolloverLoggingHelper rolloverLoggingHelper;
    private final long maxDatabaseSize;
    private final int databaseSizeCheckInterval;
    private final int retentionPeriod;
    private long earliestLog;
    private Semaphore daoLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogsResource(SchedulerApplication schedulerApplication, LoggingDataSourceDetails details) {
        this.schedulerApplication = schedulerApplication;
        this.rolloverLoggingHelper = new RolloverLoggingHelper(schedulerApplication, this, details);
        this.rolloverLoggingHelper.loadExistingDatabases();
        this.writer = new LogWriter(this, 1);
        this.writer.start();
        this.retentionPeriod = schedulerApplication.getConfiguration().getCentralizedLoggingRetention();
        this.maxDatabaseSize = this.rolloverLoggingHelper.isDatabaseRollable() ? schedulerApplication.getConfiguration().getCentralizedLoggingMaxSize() / (long)schedulerApplication.getConfiguration().getMaxRollingLoggingDatabases() : schedulerApplication.getConfiguration().getCentralizedLoggingMaxSize();
        this.databaseSizeCheckInterval = schedulerApplication.getConfiguration().getCentralizedLoggingSizeCheckInterval();
        LoggingDao loggingDao = this.rolloverLoggingHelper.getActiveLoggingDao();
        synchronized (loggingDao) {
            this.updateEarliestLog();
        }
        this.initializeDeleteTask();
        this.initializeSizeCheckTask();
        this.daoLock = new Semaphore(1);
    }

    public Semaphore getDaoLock() {
        return this.daoLock;
    }

    public void stopWriter() {
        this.writer.stop();
    }

    public void resetWriter() {
        this.writer = new LogWriter(this, 1);
        this.writer.start();
    }

    public LoggingDao getActiveLoggingDao() {
        return this.rolloverLoggingHelper.getActiveLoggingDao();
    }

    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/system")
    public Response getSystemLogs(@Auth BearerUser user, @QueryParam(value="afterEpoch") Long afterEpoch, @QueryParam(value="beforeEpoch") Long beforeEpoch) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.DOWNLOAD_LOGS)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        if (beforeEpoch == null) {
            beforeEpoch = Instant.now().toEpochMilli();
        }
        if (afterEpoch == null) {
            afterEpoch = Instant.ofEpochMilli(beforeEpoch).minus(this.retentionPeriod, ChronoUnit.DAYS).toEpochMilli();
        }
        if (beforeEpoch == 0L && afterEpoch != 0L) {
            beforeEpoch = Instant.now().toEpochMilli();
        } else if (beforeEpoch != 0L && afterEpoch == 0L) {
            afterEpoch = Instant.ofEpochMilli(beforeEpoch).minus(this.retentionPeriod, ChronoUnit.DAYS).toEpochMilli();
        }
        if (beforeEpoch == 0L && afterEpoch == 0L) {
            beforeEpoch = Instant.now().toEpochMilli();
            afterEpoch = Instant.ofEpochMilli(beforeEpoch).minus(this.retentionPeriod, ChronoUnit.DAYS).toEpochMilli();
        }
        String filenameRange = this.getFilenameRange(afterEpoch, beforeEpoch);
        String fileName = "automate-logs (" + filenameRange + ").zip";
        ZippedLogsStreamingOutput stream = new ZippedLogsStreamingOutput(this.rolloverLoggingHelper.getLoggingDaos(), null, afterEpoch, beforeEpoch, this.schedulerApplication);
        return ResponseUtils.buildStreamingOutputResponse((StreamingOutput)stream, (String)fileName);
    }

    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/job")
    public Response getJobLogs(@Auth BearerUser user, final @QueryParam(value="jobId") String jobId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        JobDetailsModel existingJobDetails = this.schedulerApplication.getJobResource().getJobDetailsModel(jobId);
        if (existingJobDetails == null) {
            return ExceptionUtils.toResponse((String)"cannotFindJobIdNotExists", (Map)new HashMap<String, String>(){
                {
                    this.put("jobId", jobId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        JobDetailsModel jobDetailsModel = new JobDetailsModel(existingJobDetails);
        LOGGER.info("Job logs preparing " + String.valueOf(jobDetailsModel) + " logs ...");
        if (jobDetailsModel.getSettings().getExecutionProfileId() != null && this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(jobDetailsModel.getSettings().getExecutionProfileId()) == null) {
            jobDetailsModel.getSettings().setExecutionProfileId(null);
        }
        if (jobDetailsModel.getSettings().getResourcePoolId() != null && this.schedulerApplication.getResourcePoolResource().getResourcePool(jobDetailsModel.getSettings().getResourcePoolId()) == null) {
            jobDetailsModel.getSettings().setResourcePoolId(null);
        }
        JobModel jobModel = jobDetailsModel.getSettings();
        JobModel result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissionsInternal(user, jobModel);
        if (!result.getUserPermissions().contains(Permission.VIEW) || !result.getUserPermissions().contains(Permission.DOWNLOAD_LOGS)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        jobDetailsModel.setSettings(result);
        String fileName = "job-" + this.getShortId(jobId) + ".zip";
        LOGGER.info("Job logs preparing file name: " + fileName);
        ZippedLogsStreamingOutput stream = new ZippedLogsStreamingOutput(this.rolloverLoggingHelper.getLoggingDaos(), jobDetailsModel, 0L, 0L, this.schedulerApplication);
        return ResponseUtils.buildStreamingOutputResponse((StreamingOutput)stream, (String)fileName);
    }

    @POST
    @Path(value="/system")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response getSystemLogStreams(@Parameter(hidden=true) @Context HttpServletRequest req, @FormParam(value="token") String token, @FormParam(value="afterDate") Long afterEpoch, @FormParam(value="beforeDate") Long beforeEpoch) throws ParseException, AuthenticationException {
        Optional<BearerUser> user;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (beforeEpoch == null) {
            beforeEpoch = Instant.now().toEpochMilli();
        }
        if (afterEpoch == null) {
            afterEpoch = Instant.ofEpochMilli(beforeEpoch).minus(this.retentionPeriod, ChronoUnit.DAYS).toEpochMilli();
        }
        if (beforeEpoch > 0L) {
            beforeEpoch = Instant.ofEpochMilli(beforeEpoch).plus(1L, ChronoUnit.DAYS).minus(1L, ChronoUnit.MILLIS).toEpochMilli();
        }
        if ((user = this.schedulerApplication.getBearerAuthenticator().authenticateWithUiToken(token, req)).isPresent()) {
            return this.getSystemLogs(user.get(), afterEpoch, beforeEpoch);
        }
        ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @POST
    @Path(value="/job")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response getJobLogStreams(@Parameter(hidden=true) @Context HttpServletRequest req, @FormParam(value="token") String token, @FormParam(value="jobId") String jobId) throws AuthenticationException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Optional<BearerUser> user = this.schedulerApplication.getBearerAuthenticator().authenticateWithUiToken(token, req);
        if (user.isPresent()) {
            return this.getJobLogs(user.get(), jobId);
        }
        ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)jobId);
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    private void updateEarliestLog() {
        Long tempEarliestLog = this.rolloverLoggingHelper.getActiveLoggingDao().getEarliestLogs();
        this.earliestLog = tempEarliestLog != null ? tempEarliestLog.longValue() : Instant.now().toEpochMilli();
    }

    public Long getEarliestLog() {
        return this.earliestLog;
    }

    public void cleanup() {
        this.writer.stop();
    }

    public String getShortId(String id) {
        String[] idSplit;
        if (id != null && (idSplit = id.split("-")).length == 5) {
            return idSplit[0];
        }
        return null;
    }

    private String getFilenameRange(long afterEpoch, long beforeEpoch) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyyMMdd");
        return formatter.print(afterEpoch) + "-" + formatter.print(beforeEpoch);
    }

    private String getFilenameDate(long epoch) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyyMMdd-HHmmss");
        return formatter.print(epoch);
    }

    private long getDatabaseSize() {
        return this.rolloverLoggingHelper.getActiveLoggingDao().getDatabaseSize();
    }

    private void initializeSizeCheckTask() {
        LOGGER.info("Centralized logging database initializing monitor ...");
        if (this.schedulerApplication.getConfiguration().getEnableCentralizedLogging()) {
            ScheduledExecutorService sizeSchedule = Executors.newScheduledThreadPool(1);
            sizeSchedule.scheduleWithFixedDelay(() -> {
                block17: {
                    LOGGER.info("Centralized logging database monitor task ...");
                    Long databaseSize = 0L;
                    Long previousDatabaseSize = 0L;
                    try {
                        LOGGER.info("Centralized logging database monitor task acquiring lock...");
                        LoggingDao loggingDao = this.rolloverLoggingHelper.getActiveLoggingDao();
                        synchronized (loggingDao) {
                            LOGGER.info("Centralized logging database monitor task acquired lock");
                            databaseSize = this.getDatabaseSize();
                            LOGGER.info("Centralized logging database size: " + FormattingUtils.sizeToDisplaySize((long)databaseSize) + ". Max allowed size " + FormattingUtils.sizeToDisplaySize((long)this.maxDatabaseSize));
                        }
                        if (databaseSize <= this.maxDatabaseSize) break block17;
                        if (this.rolloverLoggingHelper.isDatabaseRollable()) {
                            try {
                                this.daoLock.acquire();
                                this.rolloverLoggingHelper.rollActiveLoggingDao();
                                break block17;
                            }
                            catch (Throwable e) {
                                LOGGER.error("Unexpected error while rolling database", e);
                                break block17;
                            }
                            finally {
                                this.daoLock.release();
                            }
                        }
                        LOGGER.info("Centralized logging database deleting old log lines ...");
                        LoggingDao e = this.rolloverLoggingHelper.getActiveLoggingDao();
                        synchronized (e) {
                            for (int i = 0; i < 1024; ++i) {
                                this.rolloverLoggingHelper.getActiveLoggingDao().deleteEarliestLogs();
                                databaseSize = this.getDatabaseSize();
                                LOGGER.info("Centralized logging database new size: " + FormattingUtils.sizeToDisplaySize((long)databaseSize));
                                if (databaseSize < this.maxDatabaseSize) {
                                    LOGGER.info("Centralized logging database new size within acceptable limits");
                                    break;
                                }
                                if (databaseSize.equals(previousDatabaseSize)) {
                                    LOGGER.info("Centralized logging database deletion did not reduce the size, skipping additional deletions");
                                    break;
                                }
                                previousDatabaseSize = databaseSize;
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Unexpected error occurred handling Centralized logging database", (Throwable)e);
                    }
                }
                this.updateEarliestLog();
            }, 30L, this.databaseSizeCheckInterval, TimeUnit.SECONDS);
        }
    }

    public LogWriter getWriter() {
        return this.writer;
    }

    private void initializeDeleteTask() {
        if (this.schedulerApplication.getConfiguration().getEnableCentralizedLogging()) {
            ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
            long midnight = LocalDateTime.now().until(LocalDate.now().plusDays(1L).atStartOfDay(), ChronoUnit.MINUTES);
            long midnightEpoch = LocalDateTime.now().until(LocalDate.now().plusDays(1L).atStartOfDay(), ChronoUnit.MINUTES);
            scheduler.scheduleAtFixedRate(() -> {
                LoggingDao loggingDao = this.rolloverLoggingHelper.getActiveLoggingDao();
                synchronized (loggingDao) {
                    long range = Instant.now().minus(this.retentionPeriod, ChronoUnit.DAYS).toEpochMilli();
                    LOGGER.info("Running clean-up task on logging store, deleting entries after " + Instant.now().minus(this.retentionPeriod, ChronoUnit.DAYS).toString());
                    try {
                        int deletedLogs = this.rolloverLoggingHelper.getActiveLoggingDao().deleteLogs(range);
                        LOGGER.info("Deleted " + deletedLogs + " logs");
                    }
                    catch (Exception e) {
                        LOGGER.error("Unexpected error occurred while deleting logs", (Throwable)e);
                    }
                    try {
                        int deletedHistoryComponents = this.rolloverLoggingHelper.getActiveLoggingDao().deleteComponentHistoryAfter(range);
                        LOGGER.info("Deleted " + deletedHistoryComponents + " history components");
                    }
                    catch (Exception e) {
                        LOGGER.error("Unexpected error occurred while history components", (Throwable)e);
                    }
                    try {
                        int deletedJobHistory = this.rolloverLoggingHelper.getActiveLoggingDao().deleteJobHistoryAfter(range);
                        LOGGER.info("Deleted " + deletedJobHistory + " job history entries");
                    }
                    catch (Exception e) {
                        LOGGER.error("Unexpected error while deleting job history", (Throwable)e);
                    }
                    this.updateEarliestLog();
                }
            }, midnightEpoch, 1440L, TimeUnit.MINUTES);
        }
    }
}

