/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.api.configuration.NetworkConfiguration;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.general.WsRsRestClientFactory;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.resources.Versionable;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Path(value="/v1/scheduler/resources/networkConfiguration")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class NetworkConfigurationResource
extends Versionable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NetworkConfigurationResource.class);
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;
    private final NetworkConfiguration networkConfiguration;

    public NetworkConfigurationResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.resetVersion();
        LOGGER.info("Initializing Network Configuration from store");
        List<NetworkConfiguration> networkConfigurations = schedulerApplication.getSchedulerConfigurationDao().getNetworkConfigurations();
        if (!networkConfigurations.isEmpty()) {
            this.networkConfiguration = networkConfigurations.get(0);
        } else {
            LOGGER.info("Network Configuration not found, initializing default from System properties");
            this.networkConfiguration = NetworkConfiguration.fromSystemProperties();
            this.networkConfiguration.setId(UidUtils.getRandom());
            schedulerApplication.getSchedulerConfigurationDao().addNetworkConfiguration(this.networkConfiguration);
        }
        this.networkConfiguration.updateNetworkSystemProperties();
        LOGGER.info(this.networkConfiguration.proxySettingsToString());
        DropwizardRestClientFactory.restartClients();
        WsRsRestClientFactory.restartClients();
    }

    @Operation(tags={"Resources"}, summary="Get Network Configuration", operationId="GetNetworkConfiguration", description="Get Automates network configuration", responses={@ApiResponse(description="The network configuration", content={@Content(schema=@Schema(implementation=NetworkConfiguration.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getNetworkConfiguration(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.NETWORK_CONFIGURATION);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            NetworkConfiguration result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, NetworkConfiguration.fromSystemProperties());
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
        }
    }

    @Operation(tags={"Resources"}, operationId="UpdateNetworkConfiguration", summary="Update Network Configuration", description="Update Automates network configuration", responses={@ApiResponse(description="The updated network configuration", content={@Content(schema=@Schema(implementation=NetworkConfiguration.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @PUT
    public Response updateNetworkConfiguration(@Parameter(hidden=true) @Auth BearerUser user, NetworkConfiguration configurationUpdate) {
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.NETWORK_CONFIGURATION));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            return ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)"");
        }
        try {
            this.networkConfiguration.validateUpdate(configurationUpdate);
            this.networkConfiguration.update(configurationUpdate);
        }
        catch (ResponseException e) {
            return e.getResponse();
        }
        this.updateAndReset();
        LOGGER.info("Updated network configuration");
        LOGGER.info(this.networkConfiguration.proxySettingsToString());
        NetworkConfiguration eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, this.networkConfiguration);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.NETWORK_CONFIGURATION_UPDATED, eventResult, user.getName());
        NetworkConfiguration result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, this.networkConfiguration);
        ResponseCache.getInstance().resetKeyId(CacheKey.NETWORK_CONFIGURATION);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Resources"}, operationId="ClearNetworkConfiguration", summary="Clear Network Configuration", description="Clear Automates network configuration")
    @SecurityRequirement(name="Bearer_Token")
    @DELETE
    public Response clearNetworkConfiguration(@Parameter(hidden=true) @Auth BearerUser user) {
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.NETWORK_CONFIGURATION));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            return ExceptionUtils.buildForbiddenResponse((String)user.toString(), (Object)"");
        }
        this.networkConfiguration.clear();
        this.updateAndReset();
        LOGGER.info("Cleared network configuration");
        LOGGER.info(this.networkConfiguration.proxySettingsToString());
        NetworkConfiguration eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, this.networkConfiguration);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.NETWORK_CONFIGURATION_CLEARED, eventResult, user.getName());
        NetworkConfiguration result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, this.networkConfiguration);
        ResponseCache.getInstance().resetKeyId(CacheKey.NETWORK_CONFIGURATION);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    private void updateAndReset() {
        this.schedulerApplication.getSchedulerConfigurationDao().updateNetworkConfiguration(this.networkConfiguration);
        this.resetVersion();
        DropwizardRestClientFactory.restartClients();
        WsRsRestClientFactory.restartClients();
    }
}

