/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.utils.NoticeUtils;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.SortingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.notice.FormElementType;
import com.nuix.automate.utils.models.api.notice.FormOption;
import com.nuix.automate.utils.models.api.notice.Notice;
import com.nuix.automate.utils.models.api.notice.NoticeConfiguration;
import com.nuix.automate.utils.models.api.notice.NoticeTemplate;
import com.nuix.automate.utils.models.api.notice.NoticeTemplateSubmission;
import com.nuix.automate.utils.models.api.notice.NoticeType;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;

@Path(value="/v1/scheduler/resources/noticeTemplate")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class NoticeTemplateResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NoticeTemplateResource.class);
    private static final String[] defaultNoticeTemplateResources = new String[]{"/templates/holdNoticeTemplate.json", "/templates/releaseNoticeTemplate.json", "/templates/reminderNoticeTemplate.json", "/templates/escalationNoticeTemplate.json", "/templates/sampleSurveyNoticeTemplate1.json", "/templates/sampleSurveyNoticeTemplate2.json", "/templates/recurringNoticeTemplate.json"};
    private final SchedulerApplication schedulerApplication;
    private final Map<String, NoticeTemplate> noticeTemplates;

    public NoticeTemplateResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.noticeTemplates = new HashMap<String, NoticeTemplate>();
    }

    public void initializeDefaults() {
        LOGGER.info("Setting default Notice Templates");
        for (String noticeTemplateResource : defaultNoticeTemplateResources) {
            try {
                InputStream stream = this.getClass().getResourceAsStream(noticeTemplateResource);
                String templateJson = IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8);
                NoticeTemplate noticeTemplate = (NoticeTemplate)SerializationUtils.fromJson((String)templateJson, NoticeTemplate.class);
                noticeTemplate.setId(UidUtils.getRandom());
                this.schedulerApplication.getSchedulerConfigurationDao().addNoticeTemplate(noticeTemplate);
            }
            catch (Exception e) {
                LOGGER.error("Error setting default Notice Template: " + noticeTemplateResource, (Throwable)e);
            }
        }
    }

    public void initializeNoticeTemplatesFromStore() {
        LOGGER.info("Initializing Notice Templates from store");
        List<NoticeTemplate> noticeTemplates = this.schedulerApplication.getSchedulerConfigurationDao().getNoticeTemplates();
        for (NoticeTemplate template : noticeTemplates) {
            this.noticeTemplates.put(template.getId(), template);
            if (template.getVersion() == null || template.getVersion().length() == 0) {
                template.resetVersion();
                this.schedulerApplication.getSchedulerConfigurationDao().updateNoticeTemplate(template);
            }
            if (template.getSurveyFormOptions() == null) continue;
            for (FormOption formOption : template.getSurveyFormOptions()) {
                if (formOption.getType() != FormElementType.DATA_UPLOAD || formOption.getModelNamingPattern() != null) continue;
                formOption.setModelNamingPattern("{custodian_name} - Files");
            }
        }
    }

    public NoticeTemplate getNoticeTemplate(String noticeTemplateId) {
        return this.noticeTemplates.get(noticeTemplateId);
    }

    @Operation(tags={"Resources"}, operationId="GetNoticeTemplatesSurveyFormOptions", summary="Get Notice Templates Survey Form Options", description="Get full information of all notice templates survey form options", responses={@ApiResponse(description="The list of notice templates survey form options", content={@Content(array=@ArraySchema(schema=@Schema(implementation=FormOption.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{noticeTemplateId}/surveyFormOptions/{noticeTemplateVersion}")
    @GET
    public Response getNoticeTemplateSurveyFormOptions(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the notice template") @PathParam(value="noticeTemplateId") String noticeTemplateId, @io.swagger.v3.oas.annotations.Parameter(description="The version of the notice template") @PathParam(value="noticeTemplateVersion") String noticeTemplateVersion) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        NoticeTemplate noticeTemplate = this.getNoticeTemplate(noticeTemplateId);
        if (noticeTemplate != null && !noticeTemplate.getVersion().equals(noticeTemplateVersion)) {
            noticeTemplate = null;
        }
        if (noticeTemplate == null) {
            for (Notice notice : this.schedulerApplication.getNoticeResource().getNotices()) {
                NoticeConfiguration configuration = notice.getConfiguration();
                if (configuration == null || configuration.getNoticeId() == null || !configuration.getNoticeTemplateId().equals(noticeTemplateId) || !configuration.getNoticeTemplateVersion().equals(noticeTemplateVersion)) continue;
                noticeTemplate = notice;
                break;
            }
        }
        if (noticeTemplate == null) {
            return ExceptionUtils.toResponse((String)"cannotFindNoticeTemplate", (Map)new HashMap<String, String>(){
                {
                    this.put("noticeTemplateId", noticeTemplateId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Set noticePermissions = noticeTemplate instanceof Notice ? this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, (Notice)noticeTemplate).getUserPermissions() : this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, noticeTemplate).getUserPermissions();
        if (!noticePermissions.contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)noticeTemplate);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)noticeTemplate.getSurveyFormOptions()).build();
    }

    @Operation(tags={"Resources"}, operationId="GetNoticeTemplates", summary="Get Notice Templates", description="Get full information of all notice templates", responses={@ApiResponse(description="The list of notice templates", content={@Content(array=@ArraySchema(schema=@Schema(implementation=NoticeTemplate.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getNoticeTemplates(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.NOTICE_TEMPLATES, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ArrayList<NoticeTemplate> viewableNoticeTemplates = new ArrayList<NoticeTemplate>();
            for (NoticeTemplate template : this.noticeTemplates.values()) {
                NoticeTemplate result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, template);
                if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                viewableNoticeTemplates.add(result);
            }
            SortingUtils.sortList(viewableNoticeTemplates, NoticeTemplate::getName);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(viewableNoticeTemplates).build();
        }
    }

    @Operation(tags={"Resources"}, operationId="AddNoticeTemplate", summary="Add Notice Template", description="Add a new notice template", responses={@ApiResponse(description="The notice template that was added", content={@Content(schema=@Schema(implementation=NoticeTemplate.class))}), @ApiResponse(responseCode="400", description="A notice template with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Consumes(value={"application/json"})
    public Response addNoticeTemplate(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(description="The notice template to create", schema=@Schema(implementation=NoticeTemplateSubmission.class)) NoticeTemplate noticeTemplate) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.LEGAL_HOLD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_NOTICE_TEMPLATES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)noticeTemplate);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        FormattingUtils.trimAllStrings((Object)noticeTemplate);
        String name = noticeTemplate.getName();
        if (name == null || name.trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"noticeTemplateNameMissing", (Response.Status)Response.Status.BAD_REQUEST);
        }
        name = name.trim();
        for (NoticeTemplate noticeTemplate2 : this.noticeTemplates.values()) {
            if (noticeTemplate2.getId().equals(noticeTemplate.getId()) || !name.equalsIgnoreCase(noticeTemplate2.getName())) continue;
            return ExceptionUtils.toResponse((String)"noticeTemplateNameExists", (Response.Status)Response.Status.BAD_REQUEST);
        }
        noticeTemplate.setName(name);
        String subject = noticeTemplate.getSubject();
        if (subject == null || subject.trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"noticeSubjectMissing", (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (noticeTemplate.getParameters() != null) {
            noticeTemplate.setParameters(this.schedulerApplication.getNoticeUtils().normalizeParameters(noticeTemplate.getParameters()));
            for (final String parameterName : noticeTemplate.getParameters().keySet()) {
                if (!NoticeUtils.builtInParameterNames.contains(parameterName)) continue;
                return ExceptionUtils.toResponse((String)"cannotUseBuiltInParameter", (Map)new HashMap<String, String>(){
                    {
                        this.put("parameter", parameterName);
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        if (noticeTemplate.getSurveyFormOptions() != null) {
            for (FormOption option : noticeTemplate.getSurveyFormOptions()) {
                if (option.getAllowedValues() == null) continue;
                option.getAllowedValues().removeIf(v -> v == null || v.trim().length() == 0);
            }
        }
        String string = UidUtils.getRandom();
        noticeTemplate.setId(string);
        noticeTemplate.resetVersion();
        this.schedulerApplication.getSchedulerConfigurationDao().addNoticeTemplate(noticeTemplate);
        this.noticeTemplates.put(string, noticeTemplate);
        NoticeTemplate result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, noticeTemplate);
        ResponseCache.getInstance().resetKeyId(CacheKey.NOTICE_TEMPLATES, "");
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Resources"}, operationId="UpdateNoticeTemplate", summary="Update Notice Template", description="Update the notice template with the specified ID", responses={@ApiResponse(description="The updated notice template", content={@Content(schema=@Schema(implementation=NoticeTemplate.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{noticeTemplateId}")
    @PUT
    public Response updateNoticeTemplate(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the notice template to update") @PathParam(value="noticeTemplateId") String noticeTemplateId, @io.swagger.v3.oas.annotations.Parameter(description="The information to update the notice template with", schema=@Schema(implementation=NoticeTemplateSubmission.class)) NoticeTemplate noticeTemplate) {
        String message;
        String subject;
        Boolean enabled;
        String description;
        NoticeType noticeType;
        List list;
        Map<String, Parameter> parameters;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.LEGAL_HOLD);
        NoticeTemplate originalNoticeTemplate = this.getNoticeTemplate(noticeTemplateId);
        if (originalNoticeTemplate == null) {
            return ExceptionUtils.toResponse((String)"cannotFindNoticeTemplate", (Map)new HashMap<String, String>(){
                {
                    this.put("noticeTemplateId", noticeTemplateId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Set noticeTemplatePermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalNoticeTemplate).getUserPermissions();
        if (!noticeTemplatePermissions.contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)noticeTemplateId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        FormattingUtils.trimAllStrings((Object)noticeTemplate);
        String name = noticeTemplate.getName();
        if (name != null) {
            for (NoticeTemplate noticeTemplate2 : this.noticeTemplates.values()) {
                if (noticeTemplate2.getId().equals(noticeTemplate.getId()) || !name.equalsIgnoreCase(noticeTemplate2.getName())) continue;
                return ExceptionUtils.toResponse((String)"noticeTemplateNameExists", (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        if ((parameters = noticeTemplate.getParameters()) != null) {
            parameters = this.schedulerApplication.getNoticeUtils().normalizeParameters(parameters);
            for (final String string : parameters.keySet()) {
                if (!NoticeUtils.builtInParameterNames.contains(string)) continue;
                return ExceptionUtils.toResponse((String)"cannotUseBuiltInParameter", (Map)new HashMap<String, String>(){
                    {
                        this.put("parameter", string);
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
            originalNoticeTemplate.setParameters(parameters);
        }
        if ((list = noticeTemplate.getSurveyFormOptions()) != null) {
            for (FormOption option : list) {
                if (option.getAllowedValues() == null) continue;
                option.getAllowedValues().removeIf(v -> v == null || v.trim().length() == 0);
            }
            originalNoticeTemplate.setSurveyFormOptions(list);
        }
        if (name != null && name.trim().length() > 0) {
            originalNoticeTemplate.setName(name.trim());
        }
        if ((noticeType = noticeTemplate.getType()) != null) {
            originalNoticeTemplate.setType(noticeType);
        }
        if ((description = noticeTemplate.getDescription()) != null) {
            originalNoticeTemplate.setDescription(description);
        }
        if ((enabled = noticeTemplate.getEnabled()) != null) {
            originalNoticeTemplate.setEnabled(enabled);
        }
        if ((subject = noticeTemplate.getSubject()) != null && subject.trim().length() > 0) {
            originalNoticeTemplate.setSubject(subject);
        }
        if ((message = noticeTemplate.getMessage()) != null) {
            originalNoticeTemplate.setMessage(message);
        }
        originalNoticeTemplate.resetVersion();
        this.schedulerApplication.getSchedulerConfigurationDao().updateNoticeTemplate(originalNoticeTemplate);
        NoticeTemplate result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalNoticeTemplate);
        ResponseCache.getInstance().resetKeyId(CacheKey.NOTICE_TEMPLATES, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.NOTICE_TEMPLATE, noticeTemplateId);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Resources"}, operationId="DeleteNoticeTemplate", summary="Delete Notice Template", description="Delete the notice template with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="400", description="Cannot find notice template with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{noticeTemplateId}")
    @DELETE
    public Response deleteNoticeTemplate(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, final @PathParam(value="noticeTemplateId") String noticeTemplateId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.LEGAL_HOLD);
        NoticeTemplate originalNoticeTemplate = this.getNoticeTemplate(noticeTemplateId);
        if (originalNoticeTemplate == null) {
            return ExceptionUtils.toResponse((String)"cannotFindNoticeTemplate", (Map)new HashMap<String, String>(){
                {
                    this.put("noticeTemplateId", noticeTemplateId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Set noticeTemplatePermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalNoticeTemplate).getUserPermissions();
        if (!noticeTemplatePermissions.contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)noticeTemplateId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Response.Status)Response.Status.FORBIDDEN);
        }
        boolean templateIsUsedInLegalHold = this.schedulerApplication.getLegalHoldResource().getLegalHolds().stream().anyMatch(legalHold -> {
            ArrayList<Object> configurations = new ArrayList<Object>();
            configurations.add(legalHold.getHoldNoticeConfiguration());
            configurations.add(legalHold.getReleaseNoticeConfiguration());
            configurations.addAll(legalHold.getSurveyNoticeConfigurations().values());
            for (NoticeConfiguration noticeConfiguration : configurations) {
                if (noticeConfiguration == null || !noticeTemplateId.equals(noticeConfiguration.getNoticeTemplateId())) continue;
                return true;
            }
            return false;
        });
        if (templateIsUsedInLegalHold) {
            return ExceptionUtils.toResponse((String)"cannotDeleteUsedNoticeTemplate", (Response.Status)Response.Status.BAD_REQUEST);
        }
        this.schedulerApplication.getSchedulerConfigurationDao().deleteNoticeTemplate(noticeTemplateId);
        this.noticeTemplates.remove(noticeTemplateId);
        ResponseCache.getInstance().resetKeyId(CacheKey.NOTICE_TEMPLATES, "");
        ResponseCache.getInstance().resetKeyId(CacheKey.NOTICE_TEMPLATE, noticeTemplateId);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("noticeTemplateDeleted")).build();
    }
}

