/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.utils.ClsUtils;
import com.nuix.automate.scheduler.workers.NuixLicenceSourceWorker;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.SortingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.nuixlicensesource.NuixLicenseSource;
import com.nuix.automate.utils.models.api.nuixlicensesource.NuixLicenseSourceSubmission;
import com.nuix.automate.utils.models.api.nuixlicensesource.RelayType;
import com.nuix.automate.utils.models.api.nuixlicensesource.SourceType;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.nuixlicensesource.NuixLicenseSourceModel;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.resources.Versionable;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

@Path(value="/v1/scheduler/resources/nuixLicenseSource")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class NuixLicenceSourceResource
extends Versionable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(NuixLicenceSourceResource.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private SchedulerApplication schedulerApplication;
    private Map<String, NuixLicenseSourceModel> nuixLicenceSources;
    private Map<String, NuixLicenceSourceWorker> nuixLicenceWorkers;

    public NuixLicenceSourceResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.nuixLicenceSources = new TreeMap<String, NuixLicenseSourceModel>();
        this.nuixLicenceWorkers = new TreeMap<String, NuixLicenceSourceWorker>();
        this.initializeNuixLicenceSourcesFromConfiguration();
        this.initializeNuixLicenceSourcesFromStore();
        this.resetVersion();
    }

    public void initializeNuixLicenceSourcesFromConfiguration() {
        NuixLicenseSourceModel nuixClsLicenseSource = this.schedulerApplication.getConfiguration().getNuixClsLicenseSource();
        if (nuixClsLicenseSource != null) {
            nuixClsLicenseSource.setStatus(new Status());
            nuixClsLicenseSource.getStatus().reset();
            nuixClsLicenseSource.setVersion(UidUtils.getRandom());
            if (nuixClsLicenseSource.getPassword() == null || nuixClsLicenseSource.getPassword().length() == 0) {
                nuixClsLicenseSource.getStatus().setError(this.iu.getString("LicenseUtils.ReenterPassword"));
            }
            this.nuixLicenceSources.put(nuixClsLicenseSource.getId(), nuixClsLicenseSource);
            this.nuixLicenceWorkers.put(nuixClsLicenseSource.getId(), new NuixLicenceSourceWorker(this.schedulerApplication, nuixClsLicenseSource));
        }
    }

    public void initializeNuixLicenceSourcesFromStore() {
        LOGGER.info("Initializing Engine Licence Location from store");
        List<NuixLicenseSourceModel> nuixLicenceSources = this.schedulerApplication.getSchedulerConfigurationDao().getNuixLicenceSources();
        for (NuixLicenseSourceModel nuixLicenseSource : nuixLicenceSources) {
            nuixLicenseSource.setStatus(new Status());
            nuixLicenseSource.getStatus().reset();
            nuixLicenseSource.setVersion(UidUtils.getRandom());
            if (this.nuixLicenceSources.containsKey(nuixLicenseSource.getId())) continue;
            this.nuixLicenceSources.put(nuixLicenseSource.getId(), nuixLicenseSource);
            if ((nuixLicenseSource.getSourceType().equals((Object)SourceType.NMS) || nuixLicenseSource.getSourceType().equals((Object)SourceType.CLS)) && (nuixLicenseSource.getPassword() == null || nuixLicenseSource.getPassword().length() == 0)) {
                nuixLicenseSource.getStatus().setError(this.iu.getString("LicenseUtils.ReenterPassword"));
            }
            this.nuixLicenceWorkers.put(nuixLicenseSource.getId(), new NuixLicenceSourceWorker(this.schedulerApplication, nuixLicenseSource));
        }
    }

    public Collection<NuixLicenseSourceModel> getNuixLicenceSources() {
        return this.nuixLicenceSources.values();
    }

    public NuixLicenseSourceModel getNuixLicenceSource(String id) {
        return this.nuixLicenceSources.get(id);
    }

    @Operation(tags={"Resources"}, operationId="GetEngineLicenseSources", summary="Get Engine License Sources", description="Get full information of all Engine license sources", responses={@ApiResponse(description="The list of Engine license sources", content={@Content(array=@ArraySchema(schema=@Schema(implementation=NuixLicenseSource.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getNuixLicenceSources(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.NUIX_LICENSE_SOURCES, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ArrayList<NuixLicenseSource> allowedNuixLicenceSources = new ArrayList<NuixLicenseSource>();
            for (NuixLicenseSourceModel licenceSource : this.nuixLicenceSources.values()) {
                NuixLicenseSource result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, licenceSource);
                if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                allowedNuixLicenceSources.add(result);
            }
            SortingUtils.sortList(allowedNuixLicenceSources, NuixLicenseSource::getName);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedNuixLicenceSources).build();
        }
    }

    @Operation(tags={"Resources"}, operationId="AddEngineLicenseSource", summary="Add Engine License Source", description="Add a new Engine license source", responses={@ApiResponse(description="The Engine license source that was added", content={@Content(schema=@Schema(implementation=NuixLicenseSource.class))}), @ApiResponse(responseCode="400", description="An Engine license source with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Consumes(value={"application/json"})
    public Response addNuixLicenceSource(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The license source to add", schema=@Schema(implementation=NuixLicenseSourceSubmission.class)) NuixLicenseSourceModel nuixLicenseSource) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)nuixLicenseSource);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        if (this.nuixLicenceSources.size() == 0) {
            nuixLicenseSource.setId("1000b202-0001-45ef-9ba7-24ad5deb779d");
        } else {
            nuixLicenseSource.setId(UidUtils.getRandom());
        }
        nuixLicenseSource.setDefaults();
        nuixLicenseSource.setVersion(UidUtils.getRandom());
        FormattingUtils.trimAllStrings((Object)nuixLicenseSource);
        if (nuixLicenseSource.getName() == null || nuixLicenseSource.getName().trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"invalidLicenceName", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        for (NuixLicenseSourceModel existingNuixLicenseSource : this.nuixLicenceSources.values()) {
            if (!existingNuixLicenseSource.getName().equals(nuixLicenseSource.getName())) continue;
            return ExceptionUtils.toResponse((String)"nuixLicenceSourceExists", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (nuixLicenseSource.getWhitelistedCertFingerprints() != null) {
            nuixLicenseSource.setWhitelistedCertFingerprints(FormattingUtils.normalizeCertificateFingerprints((Set)nuixLicenseSource.getWhitelistedCertFingerprints()));
        }
        this.nuixLicenceSources.put(nuixLicenseSource.getId(), nuixLicenseSource);
        this.nuixLicenceWorkers.put(nuixLicenseSource.getId(), new NuixLicenceSourceWorker(this.schedulerApplication, nuixLicenseSource));
        this.schedulerApplication.getSchedulerConfigurationDao().addNuixLicenceSource(nuixLicenseSource);
        NuixLicenseSource eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, nuixLicenseSource);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.NUIX_LICENSE_SOURCE_ADDED, eventResult, user.getName());
        NuixLicenseSource result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, nuixLicenseSource);
        this.resetVersion();
        ResponseCache.getInstance().resetKeyId(CacheKey.NUIX_LICENSE_SOURCES, "");
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Resources"}, operationId="UpdateEngineLicenseSource", summary="Update Engine License Source", description="Update the Engine license source with the specified ID", responses={@ApiResponse(description="The updated Engine license source", content={@Content(schema=@Schema(implementation=NuixLicenseSource.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{nuixLicenceSourceId}")
    @PUT
    public Response updateNuixLicenceSource(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the Engine license source to update") @PathParam(value="nuixLicenceSourceId") String nuixLicenceSourceId, @Parameter(description="The information to update the license source with", schema=@Schema(implementation=NuixLicenseSourceSubmission.class)) NuixLicenseSourceModel nuixLicenseSource) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)nuixLicenceSourceId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        NuixLicenseSourceModel originalLicenceSource = this.nuixLicenceSources.get(nuixLicenceSourceId);
        if (originalLicenceSource == null) {
            return ExceptionUtils.toResponse((String)"invalidNuixLicenceSourceId", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        FormattingUtils.trimAllStrings((Object)nuixLicenseSource);
        if (nuixLicenseSource.getName() != null) {
            for (NuixLicenseSourceModel existingNuixLicenceSource : this.nuixLicenceSources.values()) {
                if (existingNuixLicenceSource.getId().equals(nuixLicenceSourceId) || !nuixLicenseSource.getName().equals(existingNuixLicenceSource.getName())) continue;
                return ExceptionUtils.toResponse((String)"nuixLicenceSourceSameName", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
            }
            originalLicenceSource.setName(nuixLicenseSource.getName());
        }
        if (nuixLicenseSource.getDescription() != null) {
            originalLicenceSource.setDescription(nuixLicenseSource.getDescription());
        }
        switch (originalLicenceSource.getSourceType()) {
            case CLS: 
            case DONGLE: {
                originalLicenceSource.setRelayType(null);
                break;
            }
            case NMS: {
                if (originalLicenceSource.getRelayType() != null) break;
                originalLicenceSource.setRelayType(RelayType.NONE);
            }
        }
        if (nuixLicenseSource.getRelayType() != null) {
            originalLicenceSource.setRelayType(nuixLicenseSource.getRelayType());
        }
        if (nuixLicenseSource.getFilter() != null) {
            originalLicenceSource.setFilter(nuixLicenseSource.getFilter());
        }
        if (nuixLicenseSource.getUsername() != null) {
            originalLicenceSource.setUsername(nuixLicenseSource.getUsername());
        }
        if (nuixLicenseSource.getServerName() != null) {
            if (!nuixLicenseSource.getServerName().equals(originalLicenceSource.getServerName())) {
                originalLicenceSource.setPassword(null);
            }
            originalLicenceSource.setServerName(nuixLicenseSource.getServerName());
        }
        if (nuixLicenseSource.getServerPort() != null) {
            if (!nuixLicenseSource.getServerPort().equals(originalLicenceSource.getServerPort())) {
                originalLicenceSource.setPassword(null);
            }
            originalLicenceSource.setServerPort(nuixLicenseSource.getServerPort());
        }
        if (nuixLicenseSource.getWhitelistedCertFingerprints() != null) {
            Set normalizedFingerprints = FormattingUtils.normalizeCertificateFingerprints((Set)nuixLicenseSource.getWhitelistedCertFingerprints());
            if (!SerializationUtils.toJson((Object)normalizedFingerprints).equals(SerializationUtils.toJson((Object)originalLicenceSource.getWhitelistedCertFingerprints()))) {
                originalLicenceSource.setPassword(null);
            }
            originalLicenceSource.setWhitelistedCertFingerprints(normalizedFingerprints);
        }
        if (nuixLicenseSource.getPassword() != null) {
            originalLicenceSource.setPassword(nuixLicenseSource.getPassword());
        }
        originalLicenceSource.setVersion(UidUtils.getRandom());
        originalLicenceSource.setProfiles(null);
        if (originalLicenceSource.getSourceType().equals((Object)SourceType.NMS) || originalLicenceSource.getSourceType().equals((Object)SourceType.CLS)) {
            if (originalLicenceSource.getPassword() == null || originalLicenceSource.getPassword().length() == 0) {
                originalLicenceSource.getStatus().setError(this.iu.getString("LicenseUtils.ReenterPassword"));
            } else {
                originalLicenceSource.getStatus().resetOk();
            }
        } else {
            originalLicenceSource.getStatus().resetOk();
        }
        if (this.schedulerApplication.getSchedulerConfigurationDao().updateNuixLicenceSource(originalLicenceSource) == 0) {
            this.schedulerApplication.getSchedulerConfigurationDao().addNuixLicenceSource(originalLicenceSource);
        }
        this.testDraftNuixLicense(originalLicenceSource, true);
        NuixLicenceSourceWorker previousWorker = this.nuixLicenceWorkers.remove(nuixLicenceSourceId);
        try {
            previousWorker.close();
        }
        catch (IOException e) {
            LOGGER.warn("Cannot close previous client");
        }
        this.nuixLicenceWorkers.put(nuixLicenceSourceId, new NuixLicenceSourceWorker(this.schedulerApplication, nuixLicenseSource));
        NuixLicenseSource result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalLicenceSource);
        this.resetVersion();
        ResponseCache.getInstance().resetKeyId(CacheKey.NUIX_LICENSE_SOURCES, "");
        NuixLicenseSource eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalLicenceSource);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.NUIX_LICENSE_SOURCE_MODIFIED, eventResult, user.getName());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Resources"}, operationId="TestDraftEngineLicenseSource", summary="Test Draft Engine License Source", description="Attempt to connect to the license source and verify filter", responses={@ApiResponse(description="The test response", content={@Content(schema=@Schema(implementation=TranslationResponseStatus.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/test")
    @POST
    public Response testDraftNuixLicense(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The draft License Source to test", schema=@Schema(implementation=NuixLicenseSourceSubmission.class)) NuixLicenseSourceModel licenseSource) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)licenseSource);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        NuixLicenseSourceModel originalLicenceSource = null;
        boolean sameScope = false;
        if (licenseSource.getId() != null && (originalLicenceSource = this.nuixLicenceSources.get(licenseSource.getId())) != null && originalLicenceSource.getUsername().equals(licenseSource.getUsername()) && originalLicenceSource.getSourceType().equals((Object)licenseSource.getSourceType())) {
            if (originalLicenceSource.getSourceType().equals((Object)SourceType.CLS)) {
                sameScope = true;
            } else if (originalLicenceSource.getServerName().equals(licenseSource.getServerName()) && originalLicenceSource.getServerPort().equals(licenseSource.getServerPort())) {
                sameScope = true;
            }
        }
        if (sameScope && licenseSource.getPassword() == null) {
            licenseSource.setPassword(originalLicenceSource.getPassword());
        }
        licenseSource.setWhitelistedCertFingerprints(FormattingUtils.normalizeCertificateFingerprints((Set)licenseSource.getWhitelistedCertFingerprints()));
        Response testResult = this.testDraftNuixLicense(licenseSource, sameScope);
        if (originalLicenceSource != null) {
            originalLicenceSource.setStatus(licenseSource.getStatus());
        }
        return testResult;
    }

    private Response testDraftNuixLicense(NuixLicenseSourceModel licenseSource, boolean triggerEvents) {
        try {
            HashMap<String, Object> messages = new HashMap<String, Object>();
            switch (licenseSource.getSourceType()) {
                case NMS: {
                    if (licenseSource.getPassword() == null || licenseSource.getPassword().length() == 0) {
                        throw new IOException(this.iu.getString("LicenseUtils.ReenterPassword"));
                    }
                    Client client = DropwizardRestClientFactory.getClientWithWhitelistValidation((String)("NuixLicenseSourceWorker-" + licenseSource.getId() + "-test"), (Set)licenseSource.getWhitelistedCertFingerprints(), (AutomateApplication)this.schedulerApplication, (AutomateConfiguration)this.schedulerApplication.getConfiguration());
                    messages.put("response", this.schedulerApplication.getNmsUtils().testLicenceSource(licenseSource, client, triggerEvents));
                    return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("nuixLicenseSourceOk", messages)).build();
                }
                case CLS: {
                    if (licenseSource.getPassword() == null || licenseSource.getPassword().length() == 0) {
                        throw new IOException(this.iu.getString("LicenseUtils.ReenterPassword"));
                    }
                    messages.put("response", ClsUtils.testLicenceSource(licenseSource, triggerEvents));
                    return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("nuixLicenseSourceOk", messages)).build();
                }
                case DONGLE: {
                    break;
                }
            }
            messages.put("message", "Unsupported license type " + String.valueOf(licenseSource.getSourceType()));
            return ExceptionUtils.toResponse((String)"nuixLicenseSourceError", messages, null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            LOGGER.error("Cannot test Engine License Source", (Throwable)e);
            return ExceptionUtils.toResponse((String)"nuixLicenseSourceError", (Map)null, (Exception)e, (Response.Status)Response.Status.BAD_REQUEST);
        }
    }

    @Operation(tags={"Resources"}, operationId="TestEngineLicenseSource", summary="Test Engine License Source", description="Attempt to connect to the license source and verify filter", responses={@ApiResponse(description="The test response", content={@Content(schema=@Schema(implementation=TranslationResponseStatus.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{nuixLicenceSourceId}/test")
    @PUT
    public Response testNuixLicense(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the License Source to test") @PathParam(value="nuixLicenceSourceId") String nuixLicenceSourceId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)nuixLicenceSourceId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        NuixLicenseSourceModel licenseSource = this.nuixLicenceSources.get(nuixLicenceSourceId);
        if (licenseSource == null) {
            return ExceptionUtils.toResponse((String)"invalidNuixLicenceSourceId", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        ResponseCache.getInstance().resetKeyId(CacheKey.NUIX_LICENSE_SOURCES, "");
        return this.testDraftNuixLicense(licenseSource, true);
    }

    @Operation(tags={"Resources"}, operationId="DeleteEngineLicenseSource", summary="Delete Engine License Source", description="Delete the Engine license source with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="404", description="Cannot find Engine license source with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{nuixLicenceSourceId}")
    @DELETE
    public Response deleteNuixLicenseSource(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The ID of the Engine license source to delete") @PathParam(value="nuixLicenceSourceId") String nuixLicenceSourceId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)nuixLicenceSourceId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        NuixLicenseSourceModel deletedLicenceSource = this.nuixLicenceSources.remove(nuixLicenceSourceId);
        NuixLicenceSourceWorker worker = this.nuixLicenceWorkers.remove(nuixLicenceSourceId);
        if (worker != null) {
            try {
                worker.close();
            }
            catch (IOException e) {
                LOGGER.error(String.valueOf(deletedLicenceSource) + " cannot close", (Throwable)e);
            }
        }
        if (deletedLicenceSource == null) {
            return ExceptionUtils.toResponse((String)"nuixLicenceSourceNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("nuixLicenceSourceId", nuixLicenceSourceId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        this.schedulerApplication.getSchedulerConfigurationDao().deleteNuixLicenceSources(nuixLicenceSourceId);
        NuixLicenseSource eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, deletedLicenceSource);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.NUIX_LICENSE_SOURCE_DELETED, eventResult, user.getName());
        this.resetVersion();
        ResponseCache.getInstance().resetKeyId(CacheKey.NUIX_LICENSE_SOURCES, "");
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("nuixLicenceSourceDeleted")).build();
    }
}

