/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.scheduler.persistance.utilization.SessionCase;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.exceptions.AuthenticationResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SchedulerComponent;
import com.nuix.automate.utils.general.TimeUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.utilization.Activity;
import com.nuix.automate.utils.utilization.Client;
import com.nuix.automate.utils.utilization.Collection;
import com.nuix.automate.utils.utilization.CollectionTarget;
import com.nuix.automate.utils.utilization.CustodianActivity;
import com.nuix.automate.utils.utilization.CustodianNotice;
import com.nuix.automate.utils.utilization.DataRepository;
import com.nuix.automate.utils.utilization.DataSet;
import com.nuix.automate.utils.utilization.Engine;
import com.nuix.automate.utils.utilization.ExecutionProfile;
import com.nuix.automate.utils.utilization.Job;
import com.nuix.automate.utils.utilization.LegalHold;
import com.nuix.automate.utils.utilization.Library;
import com.nuix.automate.utils.utilization.License;
import com.nuix.automate.utils.utilization.Matter;
import com.nuix.automate.utils.utilization.MimeTypeVolume;
import com.nuix.automate.utils.utilization.Notice;
import com.nuix.automate.utils.utilization.NuixCase;
import com.nuix.automate.utils.utilization.NuixCaseStat;
import com.nuix.automate.utils.utilization.Operation;
import com.nuix.automate.utils.utilization.OperationSetting;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.utilization.Organization;
import com.nuix.automate.utils.utilization.OrganizationType;
import com.nuix.automate.utils.utilization.RelativityWorkspace;
import com.nuix.automate.utils.utilization.ResourcePool;
import com.nuix.automate.utils.utilization.Server;
import com.nuix.automate.utils.utilization.Session;
import com.nuix.automate.utils.utilization.Tranche;
import com.nuix.automate.utils.utilization.Transfer;
import com.nuix.automate.utils.utilization.TransferVolume;
import com.nuix.automate.utils.utilization.User;
import com.nuix.automate.utils.utilization.Workflow;
import com.nuix.automate.utils.utilization.consumption.ConsumptionEvent;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Path(value="/v2/reporting/odata")
@Produces(value={"application/json"})
public class ODataV4UtilizationResource {
    protected transient InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"WorkflowText");
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ODataV4UtilizationResource.class);
    private SchedulerApplication schedulerApplication;
    private SchedulerConfiguration schedulerConfiguration;

    public ODataV4UtilizationResource(SchedulerApplication schedulerApplication) {
        this.schedulerConfiguration = schedulerApplication.getConfiguration();
        this.schedulerApplication = schedulerApplication;
    }

    @GET
    public Response getServiceRoot(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        try {
            BearerUser user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        Object dateRangeUrl = "";
        if (afterDate != null) {
            dateRangeUrl = "?after=" + afterDate;
            if (beforeDate != null) {
                dateRangeUrl = (String)dateRangeUrl + "&before=" + beforeDate;
            }
        } else if (beforeDate != null) {
            dateRangeUrl = (String)dateRangeUrl + "?before=" + beforeDate;
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER) && !this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER) && !this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata");
        ArrayList values = new ArrayList();
        ((Dictionary)response).put("value", values);
        Hashtable<String, Object> dictionary = new Hashtable<String, Object>();
        ((Dictionary)dictionary).put("name", "Activities");
        ((Dictionary)dictionary).put("url", "Activities" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "Clients");
        ((Dictionary)dictionary).put("url", "Clients" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "DataSets");
        ((Dictionary)dictionary).put("url", "DataSets" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "Transfers");
        ((Dictionary)dictionary).put("url", "Transfers" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "TransferVolumes");
        ((Dictionary)dictionary).put("url", "TransferVolumes" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "LegalHolds");
        ((Dictionary)dictionary).put("url", "LegalHolds" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "Notices");
        ((Dictionary)dictionary).put("url", "Notices" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "CustodianNotices");
        ((Dictionary)dictionary).put("url", "CustodianNotices" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "CustodianActivities");
        ((Dictionary)dictionary).put("url", "CustodianActivities" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "Collections");
        ((Dictionary)dictionary).put("url", "Collections" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "CollectionTargets");
        ((Dictionary)dictionary).put("url", "CollectionTargets" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "DataRepositories");
        ((Dictionary)dictionary).put("url", "DataRepositories" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "Engines");
        ((Dictionary)dictionary).put("url", "Engines" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "ExecutionProfiles");
        ((Dictionary)dictionary).put("url", "ExecutionProfiles" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "Jobs");
        ((Dictionary)dictionary).put("url", "Jobs" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "Consumption");
        ((Dictionary)dictionary).put("url", "Consumption" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "Libraries");
        ((Dictionary)dictionary).put("url", "Libraries" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "Matters");
        ((Dictionary)dictionary).put("url", "Matters" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "MimeTypes");
        ((Dictionary)dictionary).put("url", "MimeTypes" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "MimeTypeVolumes");
        ((Dictionary)dictionary).put("url", "MimeTypeVolumes" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "OperationSettings");
        ((Dictionary)dictionary).put("url", "OperationSettings" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "Tranches");
        ((Dictionary)dictionary).put("url", "Tranches" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "NuixCases");
        ((Dictionary)dictionary).put("url", "NuixCases" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "RelativityWorkspaces");
        ((Dictionary)dictionary).put("url", "RelativityWorkspaces" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "NuixCaseStats");
        ((Dictionary)dictionary).put("url", "NuixCaseStats" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "Operations");
        ((Dictionary)dictionary).put("url", "Operations" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "ResourcePools");
        ((Dictionary)dictionary).put("url", "ResourcePools" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "Servers");
        ((Dictionary)dictionary).put("url", "Servers" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "Sessions");
        ((Dictionary)dictionary).put("url", "Sessions" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "Workflows");
        ((Dictionary)dictionary).put("url", "Workflows" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "Organizations");
        ((Dictionary)dictionary).put("url", "Organizations" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "Licenses");
        ((Dictionary)dictionary).put("url", "Licenses" + (String)dateRangeUrl);
        values.add(dictionary);
        dictionary = new Hashtable();
        ((Dictionary)dictionary).put("name", "Users");
        ((Dictionary)dictionary).put("url", "Users" + (String)dateRangeUrl);
        values.add(dictionary);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    private void checkPermissions(BearerUser user) throws AuthenticationResponseException {
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.UTILIZATION));
            if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
                Response response = ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
                throw new AuthenticationResponseException(response);
            }
        }
    }

    @GET
    @Produces(value={"application/xml"})
    @Path(value="/$metadata")
    public Response getMetadata(@Context HttpServletRequest request) throws IOException {
        try {
            BearerUser user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER) && !this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER) && !this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        InputStream inputStream = this.getClass().getResourceAsStream("/odata/v2/v4.xml");
        String metadata = new String(IOUtils.toByteArray((InputStream)inputStream), StandardCharsets.UTF_8);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_XML_TYPE).entity((Object)metadata).build();
    }

    @GET
    @Path(value="/Clients")
    public Response getClients(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER) && !this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER) && !this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#Clients");
        Set<String> allowedClientIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedUtilizationClientIds(user);
        ArrayList<Client> allowedClients = new ArrayList<Client>();
        for (Client client : this.schedulerApplication.getUtilizationDaoV2().getClients()) {
            if (allowedClientIds != null && !allowedClientIds.contains(client.getClientId())) continue;
            allowedClients.add(client);
        }
        ((Dictionary)response).put("value", allowedClients);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/DataSets")
    public Response getDataSets(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#DataSets");
        Set<String> allowedMatterIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedUtilizationMatterIds(user);
        ArrayList<DataSet> allowedDatasets = new ArrayList<DataSet>();
        for (DataSet dataset : this.schedulerApplication.getUtilizationDaoV2().getDataSets()) {
            if (allowedMatterIds != null && !allowedMatterIds.contains(dataset.getMatterId())) continue;
            allowedDatasets.add(dataset);
        }
        ((Dictionary)response).put("value", allowedDatasets);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/Transfers")
    public Response getTransfers(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#Transfers");
        Set<String> allowedDataSetIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedDataSetIds(user);
        ArrayList<Transfer> allowedTransfers = new ArrayList<Transfer>();
        for (Transfer transfer : this.schedulerApplication.getUtilizationDaoV2().getTransfersWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
            if (allowedDataSetIds != null && !allowedDataSetIds.contains(transfer.getDataSetId())) continue;
            allowedTransfers.add(transfer);
        }
        ((Dictionary)response).put("value", allowedTransfers);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/TransferVolumes")
    public Response getTransferVolumes(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#TransferVolumes");
        Set<String> allowedTransferIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedTransferIds(user);
        HashSet<String> dateRangeTransferIds = new HashSet<String>();
        for (Transfer transfer : this.schedulerApplication.getUtilizationDaoV2().getTransfersWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
            dateRangeTransferIds.add(transfer.getTransferId());
        }
        ArrayList<TransferVolume> allowedTransferVolumes = new ArrayList<TransferVolume>();
        if (allowedTransferIds == null) {
            for (TransferVolume transferVolume : this.schedulerApplication.getUtilizationDaoV2().getTransferVolumes()) {
                if (!dateRangeTransferIds.contains(transferVolume.getTransferId())) continue;
                allowedTransferVolumes.add(transferVolume);
            }
        } else {
            for (String allowedTransferId : allowedTransferIds) {
                for (TransferVolume transferVolume : this.schedulerApplication.getUtilizationDaoV2().getTransferVolumes(allowedTransferId)) {
                    if (!dateRangeTransferIds.contains(transferVolume.getTransferId())) continue;
                    allowedTransferVolumes.add(transferVolume);
                }
            }
        }
        ((Dictionary)response).put("value", allowedTransferVolumes);
        Response response2 = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        response2.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return response2;
    }

    @GET
    @Path(value="/LegalHolds")
    public Response getLegalHolds(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#LegalHolds");
        Set<String> allowedMatterIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedUtilizationMatterIds(user);
        ArrayList<LegalHold> allowedLegalHolds = new ArrayList<LegalHold>();
        for (LegalHold legalHold : this.schedulerApplication.getUtilizationDaoV2().getLegalHoldsWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
            if (allowedMatterIds != null && !allowedMatterIds.contains(legalHold.getMatterId())) continue;
            allowedLegalHolds.add(legalHold);
        }
        ((Dictionary)response).put("value", allowedLegalHolds);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/Notices")
    public Response getNotices(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#Notices");
        Set<String> allowedLegalHoldIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedLegalHoldIds(user);
        HashSet<String> dateRangeLegalHoldIds = new HashSet<String>();
        for (LegalHold legalHold : this.schedulerApplication.getUtilizationDaoV2().getLegalHoldsWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
            dateRangeLegalHoldIds.add(legalHold.getLegalHoldId());
        }
        ArrayList<Notice> allowedNotices = new ArrayList<Notice>();
        for (Notice notice : this.schedulerApplication.getUtilizationDaoV2().getNotices()) {
            if (allowedLegalHoldIds != null && !allowedLegalHoldIds.contains(notice.getLegalHoldId()) || !dateRangeLegalHoldIds.contains(notice.getLegalHoldId())) continue;
            allowedNotices.add(notice);
        }
        ((Dictionary)response).put("value", allowedNotices);
        Response response2 = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        response2.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return response2;
    }

    @GET
    @Path(value="/CustodianNotices")
    public Response getCustodianNotices(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#CustodianNotices");
        Set<String> allowedLegalHoldIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedLegalHoldIds(user);
        HashSet<String> dateRangeLegalHoldIds = new HashSet<String>();
        for (LegalHold legalHold : this.schedulerApplication.getUtilizationDaoV2().getLegalHoldsWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
            dateRangeLegalHoldIds.add(legalHold.getLegalHoldId());
        }
        ArrayList<CustodianNotice> allowedCustodianNotices = new ArrayList<CustodianNotice>();
        for (CustodianNotice custodianNotice : this.schedulerApplication.getUtilizationDaoV2().getCustodianNotices()) {
            if (allowedLegalHoldIds != null && !allowedLegalHoldIds.contains(custodianNotice.getLegalHoldId()) || !dateRangeLegalHoldIds.contains(custodianNotice.getLegalHoldId())) continue;
            allowedCustodianNotices.add(custodianNotice);
        }
        ((Dictionary)response).put("value", allowedCustodianNotices);
        Response response2 = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        response2.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return response2;
    }

    @GET
    @Path(value="/CustodianActivities")
    public Response getCustodianActivities(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#CustodianActivities");
        Set<String> allowedLegalHoldIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedLegalHoldIds(user);
        HashSet<String> dateRangeLegalHoldIds = new HashSet<String>();
        for (LegalHold legalHold : this.schedulerApplication.getUtilizationDaoV2().getLegalHoldsWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
            dateRangeLegalHoldIds.add(legalHold.getLegalHoldId());
        }
        ArrayList<CustodianActivity> allowedCustodianActivities = new ArrayList<CustodianActivity>();
        for (CustodianActivity custodianActivity : this.schedulerApplication.getUtilizationDaoV2().getCustodianActivities()) {
            if (allowedLegalHoldIds != null && !allowedLegalHoldIds.contains(custodianActivity.getLegalHoldId()) || !dateRangeLegalHoldIds.contains(custodianActivity.getLegalHoldId())) continue;
            allowedCustodianActivities.add(custodianActivity);
        }
        ((Dictionary)response).put("value", allowedCustodianActivities);
        Response response2 = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        response2.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return response2;
    }

    @GET
    @Path(value="/Collections")
    public Response getCollections(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#Collections");
        Set<String> allowedMatterIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedUtilizationMatterIds(user);
        ArrayList<Collection> allowedCollections = new ArrayList<Collection>();
        for (Collection collection : this.schedulerApplication.getUtilizationDaoV2().getCollectionsWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
            if (allowedMatterIds != null && !allowedMatterIds.contains(collection.getMatterId())) continue;
            allowedCollections.add(collection);
        }
        ((Dictionary)response).put("value", allowedCollections);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/CollectionTargets")
    public Response getCollectionTargets(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#CollectionTargets");
        HashSet<String> dateRangeCollectionIds = new HashSet<String>();
        for (Collection collection : this.schedulerApplication.getUtilizationDaoV2().getCollectionsWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
            dateRangeCollectionIds.add(collection.getCollectionId());
        }
        Set<String> allowedCollectionIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedCollectionIds(user);
        ArrayList<CollectionTarget> allowedCollectionTargets = new ArrayList<CollectionTarget>();
        if (allowedCollectionIds == null) {
            for (CollectionTarget collectionTarget : this.schedulerApplication.getUtilizationDaoV2().getCollectionTargets()) {
                if (!dateRangeCollectionIds.contains(collectionTarget.getCollectionId())) continue;
                allowedCollectionTargets.add(collectionTarget);
            }
        } else {
            for (String allowedCollectionId : allowedCollectionIds) {
                for (CollectionTarget collectionTarget : this.schedulerApplication.getUtilizationDaoV2().getCollectionTargets(allowedCollectionId)) {
                    if (!dateRangeCollectionIds.contains(collectionTarget.getCollectionId())) continue;
                    allowedCollectionTargets.add(collectionTarget);
                }
            }
        }
        ((Dictionary)response).put("value", allowedCollectionTargets);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/DataRepositories")
    public Response getDataRepositories(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        boolean isAllowedAll = false;
        if (this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            isAllowedAll = true;
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#DataSets");
        ArrayList<DataRepository> allowedDataRepositories = new ArrayList<DataRepository>();
        for (DataRepository dataRepository : this.schedulerApplication.getUtilizationDaoV2().getDataRepositories()) {
            if (!isAllowedAll && !this.schedulerApplication.getSecurityPolicyUtil().isUserAllowedDataRepositoryId(user, dataRepository.getDataRepositoryId())) continue;
            allowedDataRepositories.add(dataRepository);
        }
        ((Dictionary)response).put("value", allowedDataRepositories);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/Engines")
    public Response getEngines(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#Engines");
        ArrayList<Engine> allowedEngines = new ArrayList<Engine>();
        for (Engine engine : this.schedulerApplication.getUtilizationDaoV2().getEngines()) {
            if (!this.schedulerApplication.getSecurityPolicyUtil().isUserAllowedResources(user)) continue;
            allowedEngines.add(engine);
        }
        ((Dictionary)response).put("value", allowedEngines);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/ExecutionProfiles")
    public Response getExecutionProfiles(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#ExecutionProfiles");
        boolean isAllowedAll = false;
        if (this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            isAllowedAll = true;
        }
        ArrayList<ExecutionProfile> allowedExecutionProfiles = new ArrayList<ExecutionProfile>();
        for (ExecutionProfile executionProfile : this.schedulerApplication.getUtilizationDaoV2().getExecutionProfiles()) {
            if (!isAllowedAll && !this.schedulerApplication.getSecurityPolicyUtil().isUserAllowedExecutionProfileId(user, executionProfile.getExecutionProfileId())) continue;
            allowedExecutionProfiles.add(executionProfile);
        }
        ((Dictionary)response).put("value", allowedExecutionProfiles);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/Jobs")
    public Response getJobs(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#Jobs");
        Set<String> allowedJobIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedUtilizationJobIds(user);
        ArrayList<Job> allowedJobs = new ArrayList<Job>();
        for (Job job : this.schedulerApplication.getUtilizationDaoV2().getJobsWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
            if (allowedJobIds != null && !allowedJobIds.contains(job.getJobId())) continue;
            allowedJobs.add(job);
        }
        ((Dictionary)response).put("value", allowedJobs);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/Consumption")
    public Response getConsumption(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#Consumption");
        ArrayList<ConsumptionEvent> allowedConsumption = new ArrayList<ConsumptionEvent>();
        if (this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedConsumption(user)) {
            for (ConsumptionEvent consumptionEvent : this.schedulerApplication.getUtilizationDaoV2().getConsumptionsWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
                allowedConsumption.add(consumptionEvent);
            }
        }
        ((Dictionary)response).put("value", allowedConsumption);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/Libraries")
    public Response getLibraries(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#Libraries");
        boolean isAllowedAll = false;
        if (this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            isAllowedAll = true;
        }
        ArrayList<Library> allowedLibraries = new ArrayList<Library>();
        for (Library library : this.schedulerApplication.getUtilizationDaoV2().getLibraries()) {
            if (!isAllowedAll && !this.schedulerApplication.getSecurityPolicyUtil().isUserAllowedLibraryId(user, library.getLibraryId())) continue;
            allowedLibraries.add(library);
        }
        ((Dictionary)response).put("value", allowedLibraries);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/Matters")
    public Response getMatters(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#Matters");
        Set<String> allowedMatterIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedUtilizationMatterIds(user);
        ArrayList<Matter> allowedMatters = new ArrayList<Matter>();
        for (Matter matter : this.schedulerApplication.getUtilizationDaoV2().getMatters()) {
            if (allowedMatterIds != null && !allowedMatterIds.contains(matter.getMatterId())) continue;
            allowedMatters.add(matter);
        }
        ((Dictionary)response).put("value", allowedMatters);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/MimeTypes")
    public Response getMimeTypes(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#MimeTypes");
        ((Dictionary)response).put("value", this.schedulerApplication.getUtilizationDaoV2().getMimeTypes());
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/MimeTypeVolumes")
    public Response getMimeTypeVolumes(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        String operationId;
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#MimeTypeVolumes");
        Set<String> allowedOperationIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedUtilizationOperationIds(user, this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate));
        ArrayList<MimeTypeVolume> allowedMimeTypeVolumes = new ArrayList<MimeTypeVolume>();
        List<String> operationIdsInDateRangeList = this.schedulerApplication.getUtilizationDaoV2().getOperationIdsWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate));
        HashSet<String> operationIdsInDateRange = new HashSet<String>(operationIdsInDateRangeList);
        HashMap<String, ArrayList<MimeTypeVolume>> operationsMimeTypeVolumes = new HashMap<String, ArrayList<MimeTypeVolume>>();
        HashMap<String, AtomicLong> operationsTotalItems = new HashMap<String, AtomicLong>();
        HashSet<String> problematicOperationIds = new HashSet<String>();
        List<MimeTypeVolume> originalMimeTypeVolumes = this.schedulerApplication.getUtilizationDaoV2().getMimeTypeVolumes();
        for (MimeTypeVolume item : originalMimeTypeVolumes) {
            if (!operationIdsInDateRange.contains(item.getOperationId()) || item.getItemsCount() >= item.getAuditedCount()) continue;
            operationId = item.getOperationId();
            problematicOperationIds.add(operationId);
        }
        if (problematicOperationIds.size() > 0) {
            for (MimeTypeVolume item : originalMimeTypeVolumes) {
                operationId = item.getOperationId();
                if (!operationIdsInDateRange.contains(item.getOperationId()) || !problematicOperationIds.contains(operationId)) continue;
                ArrayList<MimeTypeVolume> operationMimeTypeVolumes = (ArrayList<MimeTypeVolume>)operationsMimeTypeVolumes.get(operationId);
                if (operationMimeTypeVolumes == null) {
                    operationMimeTypeVolumes = new ArrayList<MimeTypeVolume>();
                    operationsMimeTypeVolumes.put(operationId, operationMimeTypeVolumes);
                }
                operationMimeTypeVolumes.add(item);
                AtomicLong operationTotalItems = (AtomicLong)operationsTotalItems.get(operationId);
                if (operationTotalItems == null) {
                    operationTotalItems = new AtomicLong(0L);
                    operationsTotalItems.put(operationId, operationTotalItems);
                }
                operationTotalItems.addAndGet(item.getItemsCount());
            }
            for (String operationId2 : operationsMimeTypeVolumes.keySet()) {
                if (!operationIdsInDateRange.contains(operationId2)) continue;
                long totalItems = ((AtomicLong)operationsTotalItems.get(operationId2)).get();
                for (MimeTypeVolume item : (List)operationsMimeTypeVolumes.get(operationId2)) {
                    double ratio = (double)item.getItemsCount() / (double)totalItems;
                    item.setAuditedCount(Math.round(ratio * (double)item.getAuditedCount()));
                    item.setAuditedSize(Math.round(ratio * (double)item.getAuditedSize()));
                    item.setDigestSize(Math.round(ratio * (double)item.getDigestSize()));
                    item.setPagesCount(Math.round(ratio * (double)item.getPagesCount()));
                    item.setPhysicalCount(Math.round(ratio * (double)item.getPhysicalCount()));
                    item.setPhysicalSize(Math.round(ratio * (double)item.getPhysicalSize()));
                }
            }
        }
        for (MimeTypeVolume mimeTypeVolume : originalMimeTypeVolumes) {
            if (!operationIdsInDateRange.contains(mimeTypeVolume.getOperationId()) || allowedOperationIds != null && !allowedOperationIds.contains(mimeTypeVolume.getOperationId())) continue;
            allowedMimeTypeVolumes.add(mimeTypeVolume);
        }
        ((Dictionary)response).put("value", allowedMimeTypeVolumes);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    /*
     * WARNING - void declaration
     */
    @GET
    @Path(value="/Tranches")
    public Response getTranches(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#Tranches");
        ArrayList<Tranche> tranches = new ArrayList<Tranche>();
        Set<String> allowedSessionIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedUtilizationSessionIds(user, this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate));
        HashMap casesOperations = new HashMap();
        ArrayList<Operation> allowedOperations = new ArrayList<Operation>();
        HashSet<String> allowedOperationIds = new HashSet<String>();
        for (Operation operation : this.schedulerApplication.getUtilizationDaoV2().getOperationsWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
            void var14_18;
            if (allowedSessionIds != null && !allowedSessionIds.contains(operation.getSessionId())) continue;
            allowedOperations.add(operation);
            allowedOperationIds.add(operation.getOperationId());
            if (operation.getNuixCaseId() == null) continue;
            List list = (List)casesOperations.get(operation.getNuixCaseId());
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                casesOperations.put(operation.getNuixCaseId(), arrayList);
            }
            var14_18.add(operation);
        }
        HashMap<String, MimeTypeVolume> operationsMimeTypeVolume = new HashMap<String, MimeTypeVolume>();
        for (MimeTypeVolume mimeTypeVolume : this.schedulerApplication.getUtilizationDaoV2().getMimeTypeVolumes()) {
            if (!allowedOperationIds.contains(mimeTypeVolume.getOperationId())) continue;
            String operationId = mimeTypeVolume.getOperationId();
            MimeTypeVolume operationMimeTypeVolume = (MimeTypeVolume)operationsMimeTypeVolume.get(operationId);
            if (operationMimeTypeVolume == null) {
                operationMimeTypeVolume = new MimeTypeVolume();
                operationsMimeTypeVolume.put(operationId, operationMimeTypeVolume);
            }
            operationMimeTypeVolume.addAuditedSize(mimeTypeVolume.getAuditedSize());
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (SessionCase sessionCase : this.schedulerApplication.getUtilizationDaoV2().getSessionCases()) {
            if (allowedSessionIds != null && !allowedSessionIds.contains(sessionCase.getSessionId())) continue;
            hashSet.add(sessionCase.getNuixCaseId());
        }
        for (NuixCase nuixCase : this.schedulerApplication.getUtilizationDaoV2().getNuixCases()) {
            List caseOperations;
            if (!hashSet.contains(nuixCase.getNuixCaseId()) || (caseOperations = (List)casesOperations.get(nuixCase.getNuixCaseId())) == null) continue;
            caseOperations.sort(Comparator.comparingLong(Operation::getOperationStartEpoch));
            tranches.addAll(this.getTranches(caseOperations, nuixCase.getNuixCaseId(), operationsMimeTypeVolume));
        }
        ((Dictionary)response).put("value", tranches);
        Response response2 = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        response2.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return response2;
    }

    private List<Tranche> getTranches(List<Operation> caseOperations, String normalizedCaseId, Map<String, MimeTypeVolume> operationsMimeTypeVolume) {
        ArrayList<Tranche> tranches = new ArrayList<Tranche>();
        int tranchePosition = 0;
        Tranche currentTranche = null;
        Tranche lastTranche = null;
        for (Operation operation : caseOperations) {
            if (currentTranche == null) {
                currentTranche = new Tranche();
                tranches.add(currentTranche);
                currentTranche.setTranchePosition(++tranchePosition);
                currentTranche.setNuixCaseId(normalizedCaseId);
                currentTranche.setTrancheId(normalizedCaseId + "-" + tranchePosition);
                if (tranchePosition == 1) {
                    currentTranche.setTrancheIsFirst(true);
                }
                currentTranche.setTrancheStartEpoch(operation.getOperationStartEpoch());
                lastTranche = currentTranche;
            }
            currentTranche.setTrancheEndEpoch(operation.getOperationEndEpoch());
            currentTranche.setTrancheEndOperationType(operation.getOperationType());
            long auditedSize = 0L;
            MimeTypeVolume operationMimeTypeVolume = operationsMimeTypeVolume.get(operation.getOperationId());
            if (operationMimeTypeVolume != null && (auditedSize = operationMimeTypeVolume.getAuditedSize()) == 0L) {
                auditedSize = operationMimeTypeVolume.getPhysicalSize();
            }
            if (operation.getOperationType() == OperationType.NATIVE_EXPORT || operation.getOperationType() == OperationType.LEGAL_EXPORT || operation.getOperationType() == OperationType.OTHER_EXPORT) {
                currentTranche.setVolumeExported(currentTranche.getVolumeExported() + auditedSize);
            } else if (operation.getOperationType() == OperationType.OCR) {
                currentTranche.setVolumeOcred(currentTranche.getVolumeOcred() + auditedSize);
            } else if (operation.getOperationType() == OperationType.LOAD) {
                currentTranche.setVolumeLoaded(currentTranche.getVolumeLoaded() + auditedSize);
            }
            if (operation.getOperationType() != OperationType.NATIVE_EXPORT && operation.getOperationType() != OperationType.LEGAL_EXPORT && operation.getOperationType() != OperationType.OTHER_EXPORT) continue;
            currentTranche = null;
        }
        lastTranche.setTrancheIsLast(true);
        return tranches;
    }

    @GET
    @Path(value="/OperationSettings")
    public Response getOperationSettings(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#OperationSettings");
        List<String> operationIdsInDateRangeList = this.schedulerApplication.getUtilizationDaoV2().getOperationIdsWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate));
        HashSet<String> operationIdsInDateRange = new HashSet<String>(operationIdsInDateRangeList);
        Set<String> allowedOperationIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedUtilizationOperationIds(user, this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate));
        ArrayList<OperationSetting> allowedOperationSettings = new ArrayList<OperationSetting>();
        for (OperationSetting operationSetting : this.schedulerApplication.getUtilizationDaoV2().getOperationSettings()) {
            if (allowedOperationIds != null && !allowedOperationIds.contains(operationSetting.getOperationId()) || !operationIdsInDateRange.contains(operationSetting.getOperationId())) continue;
            allowedOperationSettings.add(operationSetting);
        }
        ((Dictionary)response).put("value", allowedOperationSettings);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/NuixCases")
    public Response getCases(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#NuixCases");
        HashSet<String> allowedCaseIds = new HashSet<String>();
        Set<String> allowedSessionIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedUtilizationSessionIds(user, this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate));
        for (SessionCase sessionCase : this.schedulerApplication.getUtilizationDaoV2().getSessionCasesWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
            if (allowedSessionIds != null && !allowedSessionIds.contains(sessionCase.getSessionId())) continue;
            allowedCaseIds.add(sessionCase.getNuixCaseId());
        }
        ArrayList<NuixCase> allowedCases = new ArrayList<NuixCase>();
        for (NuixCase nuixCase : this.schedulerApplication.getUtilizationDaoV2().getNuixCasesWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
            if (!allowedCaseIds.contains(nuixCase.getNuixCaseId())) continue;
            allowedCases.add(nuixCase);
        }
        ((Dictionary)response).put("value", allowedCases);
        Response response2 = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        response2.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return response2;
    }

    @GET
    @Path(value="/RelativityWorkspaces")
    public Response getRelativityWorkspaces(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#RelativityWorkspaces");
        HashSet<String> allowedWorkspaceArtifactIds = new HashSet<String>();
        Set<String> allowedSessionIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedUtilizationSessionIds(user, this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate));
        for (SessionCase sessionCase : this.schedulerApplication.getUtilizationDaoV2().getSessionCasesWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
            if (allowedSessionIds != null && !allowedSessionIds.contains(sessionCase.getSessionId())) continue;
            allowedWorkspaceArtifactIds.add(sessionCase.getRelativityWorkspaceArtifactId());
        }
        ArrayList<RelativityWorkspace> allowedWorkspaceIds = new ArrayList<RelativityWorkspace>();
        for (RelativityWorkspace relativityWorkspace : this.schedulerApplication.getUtilizationDaoV2().getRelativityWorkspaces()) {
            if (!allowedWorkspaceArtifactIds.contains(relativityWorkspace.getRelativityWorkspaceArtifactId())) continue;
            allowedWorkspaceIds.add(relativityWorkspace);
        }
        ((Dictionary)response).put("value", allowedWorkspaceIds);
        Response response2 = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        response2.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return response2;
    }

    @GET
    @Path(value="/NuixCaseStats")
    public Response getCaseStatss(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#NuixCaseStats");
        HashSet<String> allowedCaseIds = new HashSet<String>();
        Set<String> allowedSessionIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedUtilizationSessionIds(user, this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate));
        for (SessionCase sessionCase : this.schedulerApplication.getUtilizationDaoV2().getSessionCasesWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
            if (allowedSessionIds != null && !allowedSessionIds.contains(sessionCase.getSessionId())) continue;
            allowedCaseIds.add(sessionCase.getNuixCaseId());
        }
        ArrayList<NuixCaseStat> allowedCaseStats = new ArrayList<NuixCaseStat>();
        for (NuixCaseStat nuixCaseStat : this.schedulerApplication.getUtilizationDaoV2().getNuixCaseStats()) {
            if (!allowedCaseIds.contains(nuixCaseStat.getNuixCaseId())) continue;
            allowedCaseStats.add(nuixCaseStat);
        }
        ((Dictionary)response).put("value", allowedCaseStats);
        Response response2 = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        response2.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return response2;
    }

    @GET
    @Path(value="/Operations")
    public Response getOperations(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        MimeTypeVolume operationMimeTypeVolume;
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#Operations");
        HashMap<String, String> userTimeZone = new HashMap<String, String>();
        for (User user2 : this.schedulerApplication.getUtilizationDaoV2().getUsers()) {
            userTimeZone.put(user2.getUserId(), user2.getUserTimeZone());
        }
        HashMap<String, String> jobTimeZone = new HashMap<String, String>();
        for (Job job : this.schedulerApplication.getUtilizationDaoV2().getJobs()) {
            String userId = job.getJobSubmittedByUserId();
            if (userId == null) continue;
            String timeZone = (String)userTimeZone.get(job.getJobSubmittedByUserId());
            jobTimeZone.put(job.getJobId(), timeZone);
        }
        Set<String> set = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedUtilizationSessionIds(user, this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate));
        HashMap<String, String> sessionTimeZone = new HashMap<String, String>();
        HashMap<String, Integer> sessionWorkers = new HashMap<String, Integer>();
        for (Session session : this.schedulerApplication.getUtilizationDaoV2().getSessionsWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
            String jobId;
            if (set != null && !set.contains(session.getSessionId()) || (jobId = session.getJobId()) == null) continue;
            String timeZone = (String)jobTimeZone.get(jobId);
            sessionTimeZone.put(session.getSessionId(), timeZone);
            sessionWorkers.put(session.getSessionId(), session.getSessionWorkers());
        }
        List<String> operationIdsInDateRangeList = this.schedulerApplication.getUtilizationDaoV2().getOperationIdsWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate));
        HashSet<String> operationIdsInDateRange = new HashSet<String>(operationIdsInDateRangeList);
        HashSet<String> problematicOperationIds = new HashSet<String>();
        List<MimeTypeVolume> originalMimeTypeVolumes = this.schedulerApplication.getUtilizationDaoV2().getMimeTypeVolumes();
        for (MimeTypeVolume item : originalMimeTypeVolumes) {
            if (!operationIdsInDateRange.contains(item.getOperationId()) || item.getItemsCount() >= item.getAuditedCount()) continue;
            String operationId = item.getOperationId();
            problematicOperationIds.add(operationId);
        }
        HashMap<String, MimeTypeVolume> operationsMimeTypeVolume = new HashMap<String, MimeTypeVolume>();
        Set<String> allowedOperationIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedUtilizationOperationIds(user, this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate));
        ArrayList allowedMimeTypeVolumes = new ArrayList();
        for (MimeTypeVolume mimeTypeVolume : originalMimeTypeVolumes) {
            if (allowedOperationIds != null && !allowedOperationIds.contains(mimeTypeVolume.getOperationId()) || !operationIdsInDateRange.contains(mimeTypeVolume.getOperationId())) continue;
            String operationId = mimeTypeVolume.getOperationId();
            operationMimeTypeVolume = (MimeTypeVolume)operationsMimeTypeVolume.get(operationId);
            boolean operationFirstMimeType = false;
            if (operationMimeTypeVolume == null) {
                operationMimeTypeVolume = new MimeTypeVolume();
                operationsMimeTypeVolume.put(operationId, operationMimeTypeVolume);
                operationFirstMimeType = true;
            }
            if (!operationFirstMimeType && problematicOperationIds.contains(operationId)) continue;
            operationMimeTypeVolume.addAuditedSize(mimeTypeVolume.getAuditedSize());
            operationMimeTypeVolume.addDigestSize(mimeTypeVolume.getDigestSize());
            operationMimeTypeVolume.addAuditedCount(mimeTypeVolume.getAuditedCount());
            operationMimeTypeVolume.addItemsCount(mimeTypeVolume.getItemsCount());
            operationMimeTypeVolume.addPagesCount(mimeTypeVolume.getPagesCount());
            operationMimeTypeVolume.addPhysicalCount(mimeTypeVolume.getPhysicalCount());
            operationMimeTypeVolume.addPhysicalSize(mimeTypeVolume.getPhysicalSize());
        }
        ArrayList<Operation> allowedOperations = new ArrayList<Operation>();
        for (Operation operation : this.schedulerApplication.getUtilizationDaoV2().getOperationsWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
            DateTimeZone dateTimeZone;
            String timeZone;
            if (set != null && !set.contains(operation.getSessionId())) continue;
            allowedOperations.add(operation);
            operationMimeTypeVolume = (MimeTypeVolume)operationsMimeTypeVolume.get(operation.getOperationId());
            if (operationMimeTypeVolume != null) {
                operation.setItemsCount(operationMimeTypeVolume.getItemsCount());
                operation.setPagesCount(operationMimeTypeVolume.getPagesCount());
                operation.setPhysicalCount(operationMimeTypeVolume.getPhysicalCount());
                operation.setPhysicalSize(operationMimeTypeVolume.getPhysicalSize());
                operation.setAuditedCount(operationMimeTypeVolume.getAuditedCount());
                operation.setAuditedSize(operationMimeTypeVolume.getAuditedSize());
                operation.setDigestSize(operationMimeTypeVolume.getDigestSize());
            }
            if ((timeZone = (String)sessionTimeZone.get(operation.getSessionId())) == null) {
                timeZone = TimeZone.getDefault().getID();
            }
            try {
                dateTimeZone = DateTimeZone.forID((String)timeZone);
            }
            catch (IllegalArgumentException e) {
                dateTimeZone = DateTimeZone.getDefault();
            }
            double onShiftPercentage = 100.0 * TimeUtils.getOnShiftPercentage((long)operation.getOperationStartEpoch(), (long)operation.getOperationEndEpoch(), (DateTimeZone)dateTimeZone);
            operation.setOperationPercentageOnShift(Double.valueOf(onShiftPercentage));
            Integer nuixWorkers = (Integer)sessionWorkers.get(operation.getSessionId());
            if (nuixWorkers == null) {
                nuixWorkers = 1;
            }
            operation.setNuixWorkers(nuixWorkers.intValue());
        }
        ((Dictionary)response).put("value", allowedOperations);
        Response response2 = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        response2.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return response2;
    }

    @GET
    @Path(value="/ResourcePools")
    public Response getResourcePools(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#ResourcePools");
        ArrayList<ResourcePool> allowedPools = new ArrayList<ResourcePool>();
        for (ResourcePool resourcePool : this.schedulerApplication.getUtilizationDaoV2().getResourcePools()) {
            if (!this.schedulerApplication.getSecurityPolicyUtil().isUserAllowedResourcePoolId(user, resourcePool.getResourcePoolId())) continue;
            allowedPools.add(resourcePool);
        }
        ((Dictionary)response).put("value", allowedPools);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/Servers")
    public Response getServers(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#Servers");
        ArrayList<Server> allowedServers = new ArrayList<Server>();
        for (Server engine : this.schedulerApplication.getUtilizationDaoV2().getServers()) {
            if (!this.schedulerApplication.getSecurityPolicyUtil().isUserAllowedResources(user)) continue;
            allowedServers.add(engine);
        }
        ((Dictionary)response).put("value", allowedServers);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    private long parseAfterDate(String afterDate) {
        if (afterDate == null) {
            return 0L;
        }
        return DateTime.parse((String)afterDate).getMillis();
    }

    private long parseBeforeDate(String beforeDate) {
        if (beforeDate == null) {
            return 2208988800000L;
        }
        return DateTime.parse((String)beforeDate).getMillis();
    }

    @GET
    @Path(value="/Sessions")
    public Response getSessions(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#Sessions");
        HashSet<String> sessionIds = new HashSet<String>();
        Set<String> allowedSessionIds = this.schedulerApplication.getSecurityPolicyUtil().getUserAllowedUtilizationSessionIds(user, this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate));
        ArrayList<Session> allowedSessions = new ArrayList<Session>();
        for (Session session : this.schedulerApplication.getUtilizationDaoV2().getSessionsWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
            if (allowedSessionIds != null && !allowedSessionIds.contains(session.getSessionId())) continue;
            session.normalize();
            allowedSessions.add(session);
            sessionIds.add(session.getSessionId());
        }
        HashMap<String, TreeMap<Integer, Operation>> sessionsOperations = new HashMap<String, TreeMap<Integer, Operation>>();
        for (Operation operation : this.schedulerApplication.getUtilizationDaoV2().getOperationsWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
            String sessionId = operation.getSessionId();
            if (!sessionIds.contains(sessionId)) continue;
            TreeMap<Integer, Operation> sessionOperations = (TreeMap<Integer, Operation>)sessionsOperations.get(sessionId);
            if (sessionOperations == null) {
                sessionOperations = new TreeMap<Integer, Operation>();
                sessionsOperations.put(sessionId, sessionOperations);
            }
            sessionOperations.put(operation.getOperationExecutionPosition(), operation);
        }
        for (Session session : allowedSessions) {
            long millisIdle;
            long sessionStartIdle;
            long idleBeforeExport = 0L;
            long idleAfterExport = 0L;
            long idleBeforeLegalExport = 0L;
            long idleAfterLegalExport = 0L;
            long idleBeforeOtherExport = 0L;
            long idleAfterOtherExport = 0L;
            long idleBeforeNativeExport = 0L;
            long idleAfterNativeExport = 0L;
            Map sessionOperations = (Map)sessionsOperations.get(session.getSessionId());
            if (sessionOperations == null) continue;
            boolean exportDetected = false;
            boolean legalExportDetected = false;
            boolean otherExportDetected = false;
            boolean nativeExportDetected = false;
            boolean isOperationFirst = true;
            Operation firstOperation = null;
            Operation lastOperation = null;
            long lastEpoch = session.getSessionEndEpoch();
            for (Map.Entry entry : sessionOperations.entrySet()) {
                OperationType operationType;
                Operation operation = (Operation)entry.getValue();
                if (isOperationFirst) {
                    firstOperation = operation;
                    isOperationFirst = false;
                }
                if ((operationType = operation.getOperationType()) == OperationType.LEGAL_EXPORT) {
                    exportDetected = true;
                    legalExportDetected = true;
                }
                if (operationType == OperationType.OTHER_EXPORT) {
                    exportDetected = true;
                    otherExportDetected = true;
                }
                if (operationType == OperationType.NATIVE_EXPORT) {
                    exportDetected = true;
                    nativeExportDetected = true;
                }
                if (session.getSessionEndEpoch() < operation.getOperationEndEpoch()) {
                    session.setSessionEndEpoch(operation.getOperationNextEventEpoch());
                }
                long millisIdle2 = 0L;
                millisIdle2 = session.getSessionEndEpoch() < operation.getOperationNextEventEpoch() ? session.getSessionEndEpoch() - operation.getOperationEndEpoch() : operation.getOperationNextEventEpoch() - operation.getOperationEndEpoch();
                if (exportDetected) {
                    idleAfterExport += millisIdle2 / 1000L;
                } else {
                    idleBeforeExport += millisIdle2 / 1000L;
                }
                if (legalExportDetected) {
                    idleAfterLegalExport += millisIdle2 / 1000L;
                } else {
                    idleBeforeLegalExport += millisIdle2 / 1000L;
                }
                if (otherExportDetected) {
                    idleAfterOtherExport += millisIdle2 / 1000L;
                } else {
                    idleBeforeOtherExport += millisIdle2 / 1000L;
                }
                if (nativeExportDetected) {
                    idleAfterNativeExport += millisIdle2 / 1000L;
                } else {
                    idleBeforeNativeExport += millisIdle2 / 1000L;
                }
                lastOperation = operation;
            }
            if (firstOperation != null && (sessionStartIdle = firstOperation.getOperationStartEpoch() - session.getSessionStartEpoch()) >= 0L) {
                idleBeforeExport += sessionStartIdle / 1000L;
                idleBeforeNativeExport += sessionStartIdle / 1000L;
                idleBeforeLegalExport += sessionStartIdle / 1000L;
            }
            if (lastOperation != null && (millisIdle = session.getSessionEndEpoch() - lastOperation.getOperationNextEventEpoch()) > 0L) {
                if (exportDetected) {
                    idleAfterExport += millisIdle / 1000L;
                } else {
                    idleBeforeExport += millisIdle / 1000L;
                }
                if (legalExportDetected) {
                    idleAfterLegalExport += millisIdle / 1000L;
                } else {
                    idleBeforeLegalExport += millisIdle / 1000L;
                }
                if (otherExportDetected) {
                    idleAfterOtherExport += millisIdle / 1000L;
                } else {
                    idleBeforeOtherExport += millisIdle / 1000L;
                }
                if (nativeExportDetected) {
                    idleAfterNativeExport += millisIdle / 1000L;
                } else {
                    idleBeforeNativeExport += millisIdle / 1000L;
                }
            }
            session.setSessionIdleTimeAfterExport(idleAfterExport);
            session.setSessionIdleTimeBeforeExport(idleBeforeExport);
            session.setSessionIdleTimeAfterLegalExport(idleAfterLegalExport);
            session.setSessionIdleTimeBeforeLegalExport(idleBeforeLegalExport);
            session.setSessionIdleTimeAfterOtherExport(idleAfterOtherExport);
            session.setSessionIdleTimeBeforeOtherExport(idleBeforeOtherExport);
            session.setSessionIdleTimeAfterNativeExport(idleAfterNativeExport);
            session.setSessionIdleTimeBeforeNativeExport(idleBeforeNativeExport);
        }
        ((Dictionary)response).put("value", allowedSessions);
        Response response2 = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        response2.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return response2;
    }

    @GET
    @Path(value="/Workflows")
    public Response getWorkflows(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#Workflows");
        boolean isAllowedAll = false;
        if (this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            isAllowedAll = true;
        }
        ArrayList<Workflow> allowedWorkflows = new ArrayList<Workflow>();
        for (Workflow workflow : this.schedulerApplication.getUtilizationDaoV2().getWorkflows()) {
            if (!isAllowedAll && !this.schedulerApplication.getSecurityPolicyUtil().isUserAllowedWorkflowId(user, workflow.getWorkflowId())) continue;
            allowedWorkflows.add(workflow);
        }
        ((Dictionary)response).put("value", allowedWorkflows);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/Organizations")
    public Response getOrganizations(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#Organizations");
        ArrayList<Organization> allowedOrganizations = new ArrayList<Organization>();
        for (Organization organization : this.schedulerApplication.getUtilizationDaoV2().getOrganizations()) {
            if (!this.schedulerApplication.getSecurityPolicyUtil().isUserAllowedResources(user)) continue;
            organization.setOrganizationType(OrganizationType.UNDEFINED.name());
            allowedOrganizations.add(organization);
        }
        ((Dictionary)response).put("value", allowedOrganizations);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/Licenses")
    public Response getLicenses(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#Licenses");
        ArrayList<License> allowedLicenses = new ArrayList<License>();
        for (License license : this.schedulerApplication.getUtilizationDaoV2().getLicenses()) {
            if (!this.schedulerApplication.getSecurityPolicyUtil().isUserAllowedResources(user)) continue;
            allowedLicenses.add(license);
        }
        ((Dictionary)response).put("value", allowedLicenses);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/Users")
    public Response getUsers(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#Users");
        ArrayList<User> allowedUsers = new ArrayList<User>();
        boolean isAllowedAll = this.schedulerApplication.getSecurityPolicyUtil().isUserAllowedResources(user);
        HashSet<String> allowedUserIds = new HashSet<String>();
        if (!isAllowedAll) {
            for (Job job : this.schedulerApplication.getUtilizationDaoV2().getJobs()) {
                if (!this.schedulerApplication.getSecurityPolicyUtil().isUserAllowedJob(user, job)) continue;
                allowedUserIds.add(job.getJobModifiedByUserId());
                allowedUserIds.add(job.getJobSubmittedByUserId());
            }
            allowedUserIds.add(User.getIdFromName((String)user.getName(), (String)this.schedulerApplication.getSettingsResource().getDiagnosticKey().getSecret()));
        }
        for (User utilizationUser : this.schedulerApplication.getUtilizationDaoV2().getUsers()) {
            if (!isAllowedAll && !allowedUserIds.contains(utilizationUser.getUserId())) continue;
            allowedUsers.add(utilizationUser);
        }
        ((Dictionary)response).put("value", allowedUsers);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }

    @GET
    @Path(value="/Activities")
    public Response getActivities(@Context HttpServletRequest request, @Context UriInfo uriInfo, @QueryParam(value="after") String afterDate, @QueryParam(value="before") String beforeDate) {
        boolean isAllowedAll;
        BearerUser user;
        try {
            user = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        try {
            this.checkPermissions(user);
        }
        catch (AuthenticationResponseException e) {
            return e.getResponse();
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        }
        if (!this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        }
        Hashtable<String, Object> response = new Hashtable<String, Object>();
        ((Dictionary)response).put("@odata.context", String.valueOf(uriInfo.getBaseUri()) + "v2/reporting/odata/$metadata#Activities");
        ArrayList<Activity> allowedActivities = new ArrayList<Activity>();
        String currentUserId = null;
        if (this.schedulerApplication.getConfiguration().getRole().equals((Object)SchedulerComponent.ODATA_SERVER)) {
            isAllowedAll = true;
        } else {
            isAllowedAll = this.schedulerApplication.getSecurityPolicyUtil().isUserAllowedAllClients(user);
            currentUserId = User.getIdFromName((String)user.getName(), (String)this.schedulerApplication.getSettingsResource().getDiagnosticKey().getSecret());
        }
        for (Activity activity : this.schedulerApplication.getUtilizationDaoV2().getActivitesWithDateRange(this.parseAfterDate(afterDate), this.parseBeforeDate(beforeDate))) {
            if (!isAllowedAll && !activity.getUserId().equals(currentUserId) && (activity.getMatterId() == null || activity.getMatterId().length() <= 0 || !this.schedulerApplication.getSecurityPolicyUtil().isUserAllowedMatterId(user, activity.getMatterId()))) continue;
            allowedActivities.add(activity);
            if (activity.getActivityKey() == null) {
                activity.setActivityKey(activity.getMatterId());
            }
            if (activity.getLicenseId() != null) continue;
            try {
                activity.setLicenseId(this.schedulerApplication.getLicenceUtils().getLicenceInfo().getId());
            }
            catch (Exception exception) {}
        }
        ((Dictionary)response).put("value", allowedActivities);
        Response serviceResponse = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(response).build();
        serviceResponse.getHeaders().putSingle((Object)"OData-Version", (Object)"4.0");
        return serviceResponse;
    }
}

