/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.scheduler.resources.MediaResources;
import com.nuix.automate.scheduler.security.thirdparty.ThirdPartyServiceSession;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.general.SortingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.LinkService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyServiceDefinition;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyServiceType;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.ui.Icons;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

@Path(value="/v1/platform")
@Produces(value={"application/json"})
public class PlatformResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(PlatformResource.class);
    private SchedulerApplication schedulerApplication;
    private SchedulerConfiguration schedulerConfiguration;

    public PlatformResource(SchedulerApplication schedulerApplication, SchedulerConfiguration schedulerConfiguration) {
        this.schedulerApplication = schedulerApplication;
        this.schedulerConfiguration = schedulerConfiguration;
        LOGGER.info("Initializing PlatformLinksResource");
    }

    @Operation(tags={"Platform"}, operationId="GetApplicationMenuImage", summary="Get Application Menu Image", description="Get the menu image of an application from the platform", responses={@ApiResponse(description="The SVG image", content={@Content(schema=@Schema(implementation=String.class))})})
    @GET
    @Path(value="/application/{serviceType}")
    public Response getApplicationMenuImage(@PathParam(value="serviceType") ThirdPartyServiceType serviceType) {
        long expirationMs = 86400000L;
        String base64Image = Icons.getInstance().getImageBase64(serviceType.getMenuImageUrl());
        return MediaResources.getImageResponse(expirationMs, base64Image);
    }

    @Operation(tags={"Platform"}, operationId="GetApplications", summary="Get Applications", description="Get full information of all platform applications along with their URL", responses={@ApiResponse(description="The list of platform applications", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ThirdPartyServiceDefinition.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/applications")
    public Response getPlatformApplications(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(hidden=true) @Context UriInfo uriInfo) {
        HashMap<ThirdPartyServiceType, List<ThirdPartyServiceDefinition>> typeToApplications = new HashMap<ThirdPartyServiceType, List<ThirdPartyServiceDefinition>>();
        for (ThirdPartyService thirdPartyService : this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServices()) {
            if (!Boolean.TRUE.equals(thirdPartyService.getEnabled()) || !thirdPartyService.isPlatformApplication()) continue;
            try {
                List<ThirdPartyServiceDefinition> servicesDefinition;
                ThirdPartyServiceSession<?, ?> thirdPartyServiceSession;
                Set thirdPartyServicePermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, thirdPartyService).getUserPermissions();
                if (!thirdPartyServicePermissions.contains(Permission.VIEW) && !thirdPartyServicePermissions.contains(Permission.VIEW_LIMITED) || (thirdPartyServiceSession = this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServiceSession(thirdPartyService.getId(), user.getId())) == null || (servicesDefinition = thirdPartyServiceSession.getServicesDefinition(user.getBearerToken())) == null || servicesDefinition.isEmpty()) continue;
                for (ThirdPartyServiceDefinition definition : servicesDefinition) {
                    List applicationsOfType = typeToApplications.computeIfAbsent(definition.getType(), k -> new ArrayList());
                    applicationsOfType.add(definition);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Cannot get service definition", (Throwable)e);
            }
        }
        ThirdPartyServiceDefinition defaultAutomateDefinition = new ThirdPartyServiceDefinition(ThirdPartyServiceType.NUIX_AUTOMATE);
        defaultAutomateDefinition.setDefaultName();
        defaultAutomateDefinition.setUrl(ResourceUtils.getSchedulerUrl((HttpServletRequest)request, (UriInfo)uriInfo, (boolean)true));
        defaultAutomateDefinition.setConfigured(true);
        defaultAutomateDefinition.setConnected(true);
        typeToApplications.put(ThirdPartyServiceType.NUIX_AUTOMATE, List.of(defaultAutomateDefinition));
        for (ThirdPartyServiceType serviceType : ThirdPartyServiceType.values()) {
            if (!serviceType.isPlatformApplication() || typeToApplications.containsKey(serviceType)) continue;
            ThirdPartyServiceDefinition defaultAppDefinition = new ThirdPartyServiceDefinition(serviceType);
            defaultAppDefinition.setDefaultName();
            defaultAppDefinition.setConfigured(false);
            defaultAppDefinition.setConnected(false);
            typeToApplications.put(serviceType, List.of(defaultAppDefinition));
        }
        ArrayList<ThirdPartyServiceDefinition> arrayList = new ArrayList<ThirdPartyServiceDefinition>();
        for (ThirdPartyServiceType serviceType : typeToApplications.keySet()) {
            List applicationsOfType = (List)typeToApplications.get(serviceType);
            if (applicationsOfType.size() > 1 && serviceType.isPlatformApplication()) {
                arrayList.addAll(applicationsOfType);
                continue;
            }
            ((ThirdPartyServiceDefinition)applicationsOfType.get(0)).setDefaultName();
            arrayList.add((ThirdPartyServiceDefinition)applicationsOfType.get(0));
        }
        arrayList.sort(Comparator.comparing(o -> o.getType().getOrder()));
        String lastHash = ResponseCache.getInstance().hashObject(typeToApplications);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(arrayList).build();
        }
    }

    @Operation(tags={"Platform"}, operationId="GetExternalApplications", summary="Get External Applications", description="Get full information of all external applications along with their URL", responses={@ApiResponse(description="The list of external applications", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ThirdPartyServiceDefinition.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/externalApplications")
    public Response getExternalApplications(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(hidden=true) @Context UriInfo uriInfo) {
        ArrayList<ThirdPartyServiceDefinition> externalApplications = new ArrayList<ThirdPartyServiceDefinition>();
        for (ThirdPartyService thirdPartyService : this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServices()) {
            if (!Boolean.TRUE.equals(thirdPartyService.getEnabled()) || !(thirdPartyService instanceof LinkService)) continue;
            try {
                ThirdPartyServiceSession<?, ?> thirdPartyServiceSession;
                Set thirdPartyServicePermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, thirdPartyService).getUserPermissions();
                if (!thirdPartyServicePermissions.contains(Permission.VIEW) && !thirdPartyServicePermissions.contains(Permission.VIEW_LIMITED) || (thirdPartyServiceSession = this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServiceSession(thirdPartyService.getId(), user.getId())) == null) continue;
                List<ThirdPartyServiceDefinition> servicesDefinition = thirdPartyServiceSession.getServicesDefinition(user.getBearerToken());
                externalApplications.addAll(servicesDefinition);
            }
            catch (Exception e) {
                LOGGER.warn("Cannot get external service definition", (Throwable)e);
            }
        }
        SortingUtils.sortList(externalApplications, ThirdPartyServiceDefinition::getServiceName);
        String lastHash = ResponseCache.getInstance().hashObject(externalApplications);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(externalApplications).build();
        }
    }
}

