/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.tus.utils.Utils;
import com.nuix.automate.scheduler.workers.Proxy.ProxyWorker;
import com.nuix.automate.utils.exceptions.ServerException;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.user.PasswordAuthenticationSubmission;
import io.dropwizard.jersey.PATCH;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ProxyResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ProxyResource.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    public static final String datasetIdRegex = "[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}";
    private final SchedulerApplication schedulerApplication;
    private final ProxyWorker proxyWorker;

    public ProxyResource(SchedulerApplication schedulerApplication) throws GeneralSecurityException {
        this.schedulerApplication = schedulerApplication;
        this.proxyWorker = new ProxyWorker(schedulerApplication);
    }

    public ProxyWorker getProxyWorker() {
        return this.proxyWorker;
    }

    @POST
    @Path(value="/v1/users/oidcMicrosoftAuth")
    @Consumes(value={"application/json", "application/x-www-form-urlencoded"})
    public Response postOidcMicrosoftAuth(@Parameter(hidden=true) @Context HttpServletRequest request, @Context UriInfo uriInfo, MultivaluedMap<String, String> form) {
        String[] configAllowedAuthenticationServices = this.schedulerApplication.getConfiguration().getAllowedAuthenticationServices();
        if (configAllowedAuthenticationServices != null) {
            HashSet<String> configAllowedAuthenticationServicesSet = new HashSet<String>(List.of(configAllowedAuthenticationServices));
            List scopes = (List)form.get((Object)"scope");
            if (scopes.size() != 1) {
                throw new IllegalArgumentException("Cannot authenticate with more than 1 scope");
            }
            if (!configAllowedAuthenticationServicesSet.contains(scopes.get(0))) {
                throw new IllegalArgumentException("Specified scope " + (String)scopes.get(0) + " is not allowed");
            }
        }
        return this.proxyWorker.callApi(request, null, form, uriInfo, false);
    }

    @POST
    @Path(value="/v1/users/oidcAuth")
    @Consumes(value={"application/json", "application/x-www-form-urlencoded"})
    public Response postOidcAuth(@Parameter(hidden=true) @Context HttpServletRequest request, @Context UriInfo uriInfo, MultivaluedMap<String, String> form) {
        String[] configAllowedAuthenticationServices = this.schedulerApplication.getConfiguration().getAllowedAuthenticationServices();
        if (configAllowedAuthenticationServices != null) {
            HashSet<String> configAllowedAuthenticationServicesSet = new HashSet<String>(List.of(configAllowedAuthenticationServices));
            List scopes = (List)form.get((Object)"scope");
            if (scopes.size() != 1) {
                throw new IllegalArgumentException("Cannot authenticate with more than 1 scope");
            }
            if (!configAllowedAuthenticationServicesSet.contains(scopes.get(0))) {
                throw new IllegalArgumentException("Specified scope " + (String)scopes.get(0) + " is not allowed");
            }
        }
        return this.proxyWorker.callApi(request, null, form, uriInfo, false);
    }

    @POST
    @Path(value="/v1/users/oidcResponse")
    @Consumes(value={"application/json", "application/x-www-form-urlencoded"})
    public Response postOidcResponse(@Parameter(hidden=true) @Context HttpServletRequest request, @Context UriInfo uriInfo, MultivaluedMap<String, String> form) {
        return this.proxyWorker.callApi(request, null, form, uriInfo, false);
    }

    @POST
    @Path(value="v1/users/password")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response authenticateWithPassword(@Context HttpServletRequest request, @Context UriInfo uriInfo, PasswordAuthenticationSubmission passwordAuthenticationSubmission) {
        HashSet<String> configAllowedAuthenticationServicesSet;
        String[] configAllowedAuthenticationServices = this.schedulerApplication.getConfiguration().getAllowedAuthenticationServices();
        if (configAllowedAuthenticationServices != null && !(configAllowedAuthenticationServicesSet = new HashSet<String>(List.of(configAllowedAuthenticationServices))).contains(passwordAuthenticationSubmission.getScope())) {
            throw new IllegalArgumentException("Specified scope " + passwordAuthenticationSubmission.getScope() + " is not allowed");
        }
        return this.proxyWorker.callApi(request, SerializationUtils.toJson((Object)passwordAuthenticationSubmission), null, uriInfo);
    }

    @POST
    @Path(value="/v1/scheduler/resources/logs/job")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postLogsJob(@Parameter(hidden=true) @Context HttpServletRequest request, @Context UriInfo uriInfo, MultivaluedMap<String, String> form) {
        return this.proxyWorker.callApi(request, null, form, uriInfo);
    }

    @POST
    @Path(value="/v1/scheduler/resources/logs/system")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response postLogsSystem(@Parameter(hidden=true) @Context HttpServletRequest request, @Context UriInfo uriInfo, MultivaluedMap<String, String> form) {
        return this.proxyWorker.callApi(request, null, form, uriInfo);
    }

    @POST
    @Path(value="/v1/scheduler/resources/dataset/{datasetId}/upload")
    public Response processPost(final @Context HttpServletRequest request, @Context HttpServletResponse response, @Context UriInfo uriInfo, @PathParam(value="datasetId") String datasetId) {
        HttpServletRequestWrapper updatedRequest = new HttpServletRequestWrapper(request){

            public String getHeader(String name) {
                switch (name) {
                    case "Authorization": {
                        return "Bearer " + ProxyResource.this.proxyWorker.getAuthToken();
                    }
                    case "X-Forwarded-Authorization": {
                        return super.getHeader("Authorization");
                    }
                    case "X-Forwarded-Client-IP": {
                        return Utils.buildRemoteIpList(request);
                    }
                    case "X-Forwarded-Server-IP": {
                        return request.getLocalAddr();
                    }
                    case "X-Forwarded-Server-Name": {
                        return request.getServerName();
                    }
                    case "X-Forwarded-Server-Role": {
                        return ProxyResource.this.schedulerApplication.getConfiguration().getRole().name();
                    }
                }
                return super.getHeader(name);
            }
        };
        return this.proxyWorker.callApi((HttpServletRequest)updatedRequest, null, null, uriInfo);
    }

    @PATCH
    @Path(value="/v1/scheduler/resources/dataset/{datasetId}/upload/{id}")
    @Consumes(value={"*/*"})
    public void processPatch(@Context HttpServletRequest request, @Context HttpServletResponse response, @PathParam(value="datasetId") String datasetId) throws IOException {
        this.proxyWorker.processDataSetRequest(datasetId, request, response);
    }

    @HEAD
    @Path(value="/v1/scheduler/resources/dataset/{datasetId}/upload/{id}")
    @Consumes(value={"*/*"})
    public Response processHead(@Parameter(hidden=true) @Context HttpServletRequest request, @Context UriInfo uriInfo, String body) {
        return this.proxyWorker.callApi(request, body, null, uriInfo);
    }

    @PUT
    @Path(value="/v1/scheduler/resources/dataset/{datasetId}/upload/{id}")
    @Consumes(value={"*/*"})
    public Response processPut(@Parameter(hidden=true) @Context HttpServletRequest request, @Context UriInfo uriInfo, @PathParam(value="datasetId") String datasetId, @PathParam(value="id") String id) {
        String username = this.proxyWorker.getUsernameAllowedDataset(datasetId, request);
        if (username == null) {
            LOGGER.error("Cannot finalize upload, user not authorized");
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        TreeMap<String, String> additionalHeaders = new TreeMap<String, String>();
        additionalHeaders.put("X-Forwarded-For-User", username);
        Map<String, String> hashes = this.proxyWorker.getProxyStorageService().getUploadIdDigests(id);
        String finalizeUploadResponse = null;
        try {
            finalizeUploadResponse = this.proxyWorker.callApi("/v1/scheduler/resources/dataset/" + datasetId + "/proxyUpload/" + id, "PUT", hashes, additionalHeaders, new GenericType<String>(){});
        }
        catch (ServerException e) {
            LOGGER.error("Cannot finalize upload", (Throwable)e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        this.proxyWorker.getProxyStorageService().clearUploadIdDigests(id);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @DELETE
    @Path(value="/v1/scheduler/resources/dataset/{datasetId}/upload/{id}")
    @Consumes(value={"*/*"})
    public Response processDelete(@Parameter(hidden=true) @Context HttpServletRequest request, @Context UriInfo uriInfo, @PathParam(value="id") String id, String body) {
        Response response = this.proxyWorker.callApi(request, body, null, uriInfo);
        if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
            this.proxyWorker.getProxyStorageService().clearUploadIdDigests(id);
        }
        return response;
    }

    @GET
    @Path(value="/v1/authMethods")
    @Consumes(value={"*/*"})
    public Response getAuthMethods(@Parameter(hidden=true) @Context HttpServletRequest request, @Context UriInfo uriInfo) {
        Response response = this.proxyWorker.callApi(request, null, null, uriInfo);
        if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
            String responseString = (String)response.readEntity(String.class);
            Map schedulerAuthMethods = (Map)SerializationUtils.fromJson((String)responseString);
            HashMap<String, String> proxyAuthMethods = new HashMap<String, String>();
            String[] configAllowedAuthenticationServices = this.schedulerApplication.getConfiguration().getAllowedAuthenticationServices();
            if (configAllowedAuthenticationServices == null) {
                proxyAuthMethods.putAll(schedulerAuthMethods);
            } else {
                HashSet<String> configAllowedAuthenticationServicesSet = new HashSet<String>(List.of(configAllowedAuthenticationServices));
                for (String key : schedulerAuthMethods.keySet()) {
                    if (!configAllowedAuthenticationServicesSet.contains(key)) continue;
                    proxyAuthMethods.put(key, (String)schedulerAuthMethods.get(key));
                }
            }
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(proxyAuthMethods).build();
        }
        return response;
    }

    @GET
    @Path(value="{any: .*}")
    @Consumes(value={"application/json", "application/x-www-form-urlencoded"})
    public Response proxyGet(@Parameter(hidden=true) @Context HttpServletRequest request, @Context UriInfo uriInfo) {
        return this.proxyWorker.callApi(request, null, null, uriInfo);
    }

    @HEAD
    @Path(value="{any: .*}")
    @Consumes(value={"application/json", "application/x-www-form-urlencoded"})
    public Response proxyHead(@Parameter(hidden=true) @Context HttpServletRequest request, @Context UriInfo uriInfo, String body) {
        return this.proxyWorker.callApi(request, body, null, uriInfo);
    }

    @DELETE
    @Path(value="{any: .*}")
    @Consumes(value={"application/json", "application/x-www-form-urlencoded"})
    public Response proxyDelete(@Parameter(hidden=true) @Context HttpServletRequest request, @Context UriInfo uriInfo, String body) {
        return this.proxyWorker.callApi(request, body, null, uriInfo);
    }

    @PUT
    @Path(value="{any: .*}")
    @Consumes(value={"application/json", "application/x-www-form-urlencoded"})
    public Response proxyPut(@Parameter(hidden=true) @Context HttpServletRequest request, @Context UriInfo uriInfo, String body) {
        return this.proxyWorker.callApi(request, body, null, uriInfo);
    }

    @POST
    @Path(value="{any: .*}")
    @Consumes(value={"application/json", "text/plain"})
    public Response proxyPost(@Parameter(hidden=true) @Context HttpServletRequest request, @Context UriInfo uriInfo, String body) {
        return this.proxyWorker.callApi(request, body, null, uriInfo);
    }

    @POST
    @Path(value="{any: .*}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response proxyPost(@Parameter(hidden=true) @Context HttpServletRequest request, @Context UriInfo uriInfo, MultivaluedMap<String, String> form) {
        return this.proxyWorker.callApi(request, null, form, uriInfo);
    }

    @PATCH
    @Path(value="{any: .*}")
    @Consumes(value={"application/json", "application/x-www-form-urlencoded"})
    public Response postPatch(@Parameter(hidden=true) @Context HttpServletRequest request, @Context UriInfo uriInfo, String body) {
        return this.proxyWorker.callApi(request, body, null, uriInfo);
    }
}

