/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.utils.TagsUtil;
import com.nuix.automate.scheduler.workers.AwsResourcePoolWorker;
import com.nuix.automate.scheduler.workers.AzureResourcePoolWorker;
import com.nuix.automate.scheduler.workers.EngineErrorExecutionWorker;
import com.nuix.automate.scheduler.workers.LocalResourcePoolWorker;
import com.nuix.automate.scheduler.workers.ResourcePoolWorker;
import com.nuix.automate.scheduler.workers.ServerWorker;
import com.nuix.automate.utils.api.configuration.Setting;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.exceptions.ServerException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.general.ResponseUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.SortingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.engine.Engine;
import com.nuix.automate.utils.models.api.engine.EngineRole;
import com.nuix.automate.utils.models.api.general.ConciseObject;
import com.nuix.automate.utils.models.api.job.Priority;
import com.nuix.automate.utils.models.api.resourcepool.ResourcePool;
import com.nuix.automate.utils.models.api.resourcepool.ResourcePoolSubmission;
import com.nuix.automate.utils.models.api.resourcepool.Type;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.server.Server;
import com.nuix.automate.utils.models.api.server.ServerSubmission;
import com.nuix.automate.utils.models.api.user.UserSettings;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.resourcepool.AutoRegistrationSettings;
import com.nuix.automate.utils.models.internal.resourcepool.AwsResourcePoolSettings;
import com.nuix.automate.utils.models.internal.resourcepool.CloudResourcePoolSettings;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.SecurityUtils;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.NotImplementedException;
import org.jdbi.v3.core.statement.StatementException;

@Path(value="/v1/scheduler/resources/resourcePools")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ResourcePoolResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ResourcePoolResource.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private SchedulerApplication schedulerApplication;
    private Map<String, ResourcePoolModel> resourcePools;
    private Map<String, ResourcePoolWorker> resourcePoolWorkers;

    public ResourcePoolResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.resourcePools = new TreeMap<String, ResourcePoolModel>();
        this.resourcePoolWorkers = new HashMap<String, ResourcePoolWorker>();
        this.initializeResourcePoolsFromConfiguration();
        this.initializeResourcePoolsFromStore();
        this.initializeEngineErrorExecutionWorker();
    }

    private void addPoolWorker(ResourcePoolModel resourcePool) {
        ResourcePoolWorker resourcePoolWorker;
        switch (resourcePool.getType()) {
            case AWS: {
                resourcePoolWorker = new AwsResourcePoolWorker(this.schedulerApplication, this, resourcePool);
                break;
            }
            case LOCAL: {
                resourcePoolWorker = new LocalResourcePoolWorker(this.schedulerApplication, this, resourcePool);
                break;
            }
            case AZURE: {
                resourcePoolWorker = new AzureResourcePoolWorker(this.schedulerApplication, this, resourcePool);
                break;
            }
            default: {
                throw new NotImplementedException("Resource Pool type " + String.valueOf(resourcePool.getType()) + " is not supported");
            }
        }
        this.resourcePoolWorkers.put(resourcePool.getId(), resourcePoolWorker);
    }

    private void enforceSelfRegistrationSettings(ResourcePoolModel resourcePoolModel) {
        if (Boolean.TRUE.equals(resourcePoolModel.getAutoRegistrationEnabled())) {
            ResourcePoolWorker resourcePoolWorker;
            if (resourcePoolModel.getAutoRegistrationSettings().getAccessKey() == null) {
                resourcePoolModel.getAutoRegistrationSettings().setAccessKey(SecurityUtils.getSecureRandomSecret());
            }
            if ((resourcePoolWorker = this.resourcePoolWorkers.get(resourcePoolModel.getId())) != null) {
                resourcePoolModel.setEngineIds(resourcePoolWorker.getEngineIds(EngineRole.MAIN));
                resourcePoolModel.setRemoteEngineIds(resourcePoolWorker.getEngineIds(EngineRole.REMOTE));
            } else {
                resourcePoolModel.setEngineIds(new HashSet());
                resourcePoolModel.setRemoteEngineIds(new HashSet());
            }
        }
    }

    public void initializeResourcePoolsFromConfiguration() {
        ResourcePoolModel resourcePool = this.schedulerApplication.getConfiguration().getResourcePool();
        if (resourcePool != null) {
            resourcePool.getStatus().reset();
            this.resourcePools.put(resourcePool.getId(), resourcePool);
            this.addPoolWorker(resourcePool);
        }
    }

    public void initializeResourcePoolsFromStore() {
        LOGGER.info("Initializing Resource Pools from store");
        List<ResourcePoolModel> resourcePools = this.schedulerApplication.getSchedulerConfigurationDao().getResourcePools();
        for (ResourcePoolModel resourcePool : resourcePools) {
            resourcePool.getStatus().reset();
            if (resourcePool.getCloudSettings() != null && resourcePool.getCloudSettings().getAwsSettings() != null && (resourcePool.getCloudSettings().getAwsSettings().getSecretKey() == null || resourcePool.getCloudSettings().getAwsSettings().getSecretKey().length() == 0)) {
                resourcePool.getStatus().setError(this.iu.getString("CloudResourcePoolWorker.ReenterSecretKey"));
            }
            if (resourcePool.getCloudSettings() != null && resourcePool.getCloudSettings().getAzureSettings() != null && (resourcePool.getCloudSettings().getAzureSettings().getKey() == null || resourcePool.getCloudSettings().getAzureSettings().getKey().length() == 0)) {
                resourcePool.getStatus().setError(this.iu.getString("CloudResourcePoolWorker.ReenterKey"));
            }
            HashSet<String> engineIds = new HashSet<String>();
            Set<String> daoEngineIds = this.schedulerApplication.getSchedulerConfigurationDao().getEnginesIdsWithResourcePoolId(resourcePool.getId());
            if (daoEngineIds != null) {
                engineIds.addAll(daoEngineIds);
            }
            resourcePool.setEngineIds(engineIds);
            HashSet<String> remoteEngineIds = new HashSet<String>();
            Set<String> daoRemoteEngineIds = this.schedulerApplication.getSchedulerConfigurationDao().getRemoteEnginesIdsWithResourcePoolId(resourcePool.getId());
            if (daoRemoteEngineIds != null) {
                remoteEngineIds.addAll(daoRemoteEngineIds);
            }
            resourcePool.setRemoteEngineIds(remoteEngineIds);
            this.resourcePools.put(resourcePool.getId(), resourcePool);
            this.addPoolWorker(resourcePool);
        }
    }

    public void initializeEngineErrorExecutionWorker() {
        if (this.schedulerApplication.getConfiguration().isEnableEngineErrorJobWorker()) {
            LOGGER.info("Initializing Engine Error Job Worker");
            EngineErrorExecutionWorker engineErrorExecutionWorker = new EngineErrorExecutionWorker(this.schedulerApplication);
            Timer timer = new Timer("Engine Error Job Worker", true);
            timer.schedule((TimerTask)engineErrorExecutionWorker, 0L, this.schedulerApplication.getConfiguration().getEngineErrorJobCheckInterval());
        }
    }

    public void testEngineIdsLocal(Set<String> engineIds) throws IllegalStateException {
        if (engineIds != null) {
            TreeSet<String> engineNames = new TreeSet<String>();
            for (String engineId : engineIds) {
                EngineModel engineModel = this.schedulerApplication.getSchedulerEnginesResource().getEngineFromId(engineId);
                if (engineModel == null || TagsUtil.hasTagValue(TagsUtil.ELIGIBLE_FOR_LOCAL_POOL, "true", engineModel.getTags())) continue;
                engineNames.add(engineModel.getName());
            }
            if (engineNames.size() > 0) {
                throw new IllegalStateException(this.iu.getNumeralFormattedString("ResourcePoolResource.CannotAddEngineManagedBySystem", (long)engineNames.size(), (Object)String.join((CharSequence)", ", engineNames)));
            }
        }
    }

    public void setPoolEnginesIds(String poolId, Set<String> engineIds, Set<String> remoteEngineIds) {
        ResourcePoolModel resourcePool = this.resourcePools.get(poolId);
        if (engineIds != null) {
            HashSet<String> resourcePoolEngineIds = new HashSet<String>();
            resourcePoolEngineIds.addAll(engineIds);
            resourcePool.setEngineIds(resourcePoolEngineIds);
            this.schedulerApplication.getSchedulerConfigurationDao().deleteResourcePoolEngines(poolId);
            for (String engineId : engineIds) {
                if (engineId == null) continue;
                try {
                    this.schedulerApplication.getSchedulerConfigurationDao().addResourcePoolIdEngineId(poolId, engineId);
                }
                catch (StatementException statementException) {}
            }
        }
        if (remoteEngineIds != null) {
            HashSet<String> resourcePoolRemoteEngineIds = new HashSet<String>();
            resourcePoolRemoteEngineIds.addAll(remoteEngineIds);
            resourcePool.setRemoteEngineIds(resourcePoolRemoteEngineIds);
            this.schedulerApplication.getSchedulerConfigurationDao().deleteResourcePoolRemoteEngines(poolId);
            for (String remoteEngineId : remoteEngineIds) {
                if (remoteEngineId == null) continue;
                try {
                    this.schedulerApplication.getSchedulerConfigurationDao().addResourcePoolIdRemoteEngineId(poolId, remoteEngineId);
                }
                catch (StatementException statementException) {}
            }
        }
    }

    public void removeEnginePoolIds(String engineId) {
        for (ResourcePoolModel resourcePool : this.resourcePools.values()) {
            if (resourcePool.getEngineIds() != null) {
                resourcePool.getEngineIds().remove(engineId);
            }
            if (resourcePool.getRemoteEngineIds() == null) continue;
            resourcePool.getRemoteEngineIds().remove(engineId);
        }
        this.schedulerApplication.getSchedulerConfigurationDao().deleteEngineResourcePools(engineId);
        this.schedulerApplication.getSchedulerConfigurationDao().deleteRemoteEngineResourcePools(engineId);
    }

    public ResourcePoolModel getResourcePool(String id) {
        return this.resourcePools.get(id);
    }

    public List<ResourcePoolModel> getResourcePools() {
        ArrayList<ResourcePoolModel> allowedResourcePools = new ArrayList<ResourcePoolModel>();
        for (ResourcePoolModel resourcePoolModel : this.resourcePools.values()) {
            this.enforceSelfRegistrationSettings(resourcePoolModel);
            allowedResourcePools.add(resourcePoolModel);
        }
        allowedResourcePools.sort(Comparator.comparing(ResourcePoolModel::getName, String.CASE_INSENSITIVE_ORDER));
        return allowedResourcePools;
    }

    @Operation(tags={"Resources", "Job Submission"}, operationId="ListResourcePools", summary="List Resource Pools", description="List active resource pools", responses={@ApiResponse(description="The list of resource pools", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ConciseObject.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/list")
    @GET
    public Response listPools(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to list resource Pools");
        }
        ArrayList<ResourcePool> allowedResourcePools = new ArrayList<ResourcePool>();
        for (ResourcePoolModel resourcePool : this.resourcePools.values()) {
            if (resourcePool.getActive() == null || !resourcePool.getActive().booleanValue()) continue;
            this.enforceSelfRegistrationSettings(resourcePool);
            ResourcePool result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, resourcePool);
            if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
            result.removeSecrets();
            allowedResourcePools.add(result);
        }
        SortingUtils.sortList(allowedResourcePools, ResourcePool::getName);
        String lastHash = ResponseCache.getInstance().hashObject(allowedResourcePools);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)ResponseUtils.getConciseList(allowedResourcePools)).build();
        }
    }

    public String getDefaultResourcePoolId(@Parameter(hidden=true) @Auth BearerUser user) {
        Object defaultResourcePoolId;
        ArrayList<ResourcePool> allowedResourcePools = new ArrayList<ResourcePool>();
        for (ResourcePoolModel resourcePool : this.resourcePools.values()) {
            ResourcePool result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, resourcePool);
            if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
            result.removeSecrets();
            allowedResourcePools.add(result);
        }
        if (allowedResourcePools.size() == 1) {
            return ((ResourcePool)allowedResourcePools.get(0)).getId();
        }
        UserSettings userSettings = this.schedulerApplication.getUserSettingsResource().getUserSettingsInternal(user);
        Setting defaultValues = (Setting)userSettings.get((Object)"defaultValues");
        if (defaultValues != null && (defaultResourcePoolId = defaultValues.get((Object)"resourcePoolId")) != null) {
            String candidateResourcePoolId = String.valueOf(defaultResourcePoolId);
            for (ResourcePool resourcePool : allowedResourcePools) {
                if (!resourcePool.getId().equals(candidateResourcePoolId)) continue;
                return candidateResourcePoolId;
            }
        }
        return null;
    }

    @Operation(tags={"Resources"}, operationId="GetResourcePools", summary="Get Resource Pools", description="Get full information of all resource pools. Use ListResourcePools unless full information is required", responses={@ApiResponse(description="The list of resource pools", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ResourcePool.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getPools(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to list resource Pools");
        }
        ArrayList<ResourcePool> allowedResourcePools = new ArrayList<ResourcePool>();
        for (ResourcePoolModel resourcePool : this.resourcePools.values()) {
            this.enforceSelfRegistrationSettings(resourcePool);
            ResourcePool result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, resourcePool);
            if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
            result.removeSecrets();
            allowedResourcePools.add(result);
        }
        SortingUtils.sortList(allowedResourcePools, ResourcePool::getName);
        String lastHash = ResponseCache.getInstance().hashObject(allowedResourcePools);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedResourcePools).build();
        }
    }

    @Operation(tags={"Resources"}, operationId="AddResourcePool", summary="Add Resource Pool", description="Add a new resource pool", responses={@ApiResponse(description="The resource pool that was added", content={@Content(schema=@Schema(implementation=ResourcePool.class))}), @ApiResponse(responseCode="400", description="A resource pool with the same name")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Consumes(value={"application/json"})
    public Response addResourcePool(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The resource pool to add", schema=@Schema(implementation=ResourcePoolSubmission.class)) ResourcePoolModel resourcePool) {
        ResourcePoolModel existingPool;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)resourcePool);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        FormattingUtils.trimAllStrings((Object)resourcePool);
        if (!resourcePool.checkSettingsValid()) {
            return ExceptionUtils.toResponse((String)"invalidSelfRegistrationSetting", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (this.resourcePools.size() == 0) {
            resourcePool.setId("1000b196-09b3-4c2a-8b85-38863cf04aec");
        } else {
            resourcePool.setId(UidUtils.getRandom());
        }
        resourcePool.setDefaults();
        this.enforceSelfRegistrationSettings(resourcePool);
        if (resourcePool.getCloudSettings() != null && resourcePool.getCloudSettings().getWhitelistedCertFingerprints() != null) {
            resourcePool.getCloudSettings().setWhitelistedCertFingerprints(FormattingUtils.normalizeCertificateFingerprints((Set)resourcePool.getCloudSettings().getWhitelistedCertFingerprints()));
        }
        if (resourcePool.getName() == null || resourcePool.getName().trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"invalidResourcePoolName", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        for (ResourcePoolModel existingResourcePool : this.resourcePools.values()) {
            if (!existingResourcePool.getName().equals(resourcePool.getName())) continue;
            return ExceptionUtils.toResponse((String)"resourcePoolExists", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (resourcePool.getReferenceId() != null && !resourcePool.getReferenceId().trim().equals("") && (existingPool = this.resourcePools.get(resourcePool.getReferenceId())) != null) {
            if (resourcePool.getType() == Type.AWS) {
                if (resourcePool.getCloudSettings() != null && resourcePool.getCloudSettings().getAwsSettings() != null) {
                    if (resourcePool.getCloudSettings().getUseRemoteEngines().booleanValue()) {
                        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.REMOTE_ENGINES);
                    }
                    String duplicatedPoolAccessKey = resourcePool.getCloudSettings().getAwsSettings().getAccessKey();
                    String duplicatedPoolSecretKey = resourcePool.getCloudSettings().getAwsSettings().getSecretKey();
                    if (duplicatedPoolAccessKey != null && duplicatedPoolSecretKey != null && duplicatedPoolSecretKey.equals("") && existingPool.getCloudSettings() != null && existingPool.getCloudSettings().getAwsSettings() != null) {
                        String secretKey = existingPool.getCloudSettings().getAwsSettings().getSecretKey();
                        String accessKey = existingPool.getCloudSettings().getAwsSettings().getAccessKey();
                        if (duplicatedPoolAccessKey.equals(accessKey)) {
                            resourcePool.getCloudSettings().getAwsSettings().setSecretKey(secretKey);
                        }
                    }
                }
            } else if (resourcePool.getType() == Type.AZURE && resourcePool.getCloudSettings() != null && resourcePool.getCloudSettings().getAzureSettings() != null) {
                if (resourcePool.getCloudSettings().getUseRemoteEngines().booleanValue()) {
                    this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.REMOTE_ENGINES);
                }
                String duplicatedPoolTenant = resourcePool.getCloudSettings().getAzureSettings().getTenant();
                String duplicatedPoolKey = resourcePool.getCloudSettings().getAzureSettings().getKey();
                if (duplicatedPoolTenant != null && duplicatedPoolKey != null && duplicatedPoolKey.equals("") && existingPool.getCloudSettings() != null && existingPool.getCloudSettings().getAzureSettings() != null) {
                    String azureTenant = resourcePool.getCloudSettings().getAzureSettings().getTenant();
                    String azureKey = resourcePool.getCloudSettings().getAzureSettings().getKey();
                    if (duplicatedPoolTenant.equals(azureTenant)) {
                        resourcePool.getCloudSettings().getAzureSettings().setKey(azureKey);
                    }
                }
            }
        }
        if (resourcePool.getRemoteEngineIds() != null && resourcePool.getRemoteEngineIds().size() > 0) {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.REMOTE_ENGINES);
        }
        try {
            this.testEngineIdsLocal(resourcePool.getEngineIds());
            this.testEngineIdsLocal(resourcePool.getRemoteEngineIds());
            this.testResourcePoolInstanceIds(resourcePool);
        }
        catch (IllegalStateException e) {
            return ExceptionUtils.toResponse((String)"errorAddingResourcePool", (Map)new HashMap<String, String>(){
                {
                    this.put("exception", e.getLocalizedMessage());
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        resourcePool.getStatus().reset();
        this.resourcePools.put(resourcePool.getId(), resourcePool);
        if (this.schedulerApplication.getSchedulerConfigurationDao().updateResourcePool(resourcePool) == 0) {
            this.schedulerApplication.getSchedulerConfigurationDao().addResourcePool(resourcePool);
        }
        ResourcePool eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, resourcePool);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.RESOURCE_POOL_ADDED, eventResult, user.getName());
        this.setPoolEnginesIds(resourcePool.getId(), resourcePool.getEngineIds(), resourcePool.getRemoteEngineIds());
        this.addPoolWorker(resourcePool);
        this.trackResourcePoolUtilization(resourcePool);
        ResourcePool result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, resourcePool);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    private void trackResourcePoolUtilization(ResourcePoolModel resourcePoolModel) {
        com.nuix.automate.utils.utilization.ResourcePool resourcePool = new com.nuix.automate.utils.utilization.ResourcePool();
        resourcePool.setResourcePoolId(resourcePoolModel.getId());
        resourcePool.setResourcePoolName(resourcePoolModel.getName());
        this.schedulerApplication.getUtilizationDaoV2().replaceResourcePool(resourcePool);
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<com.nuix.automate.utils.utilization.ResourcePool> resourcePools = new HashSet<com.nuix.automate.utils.utilization.ResourcePool>();
        utilizationRecords.setResourcePools(resourcePools);
        resourcePools.add(resourcePool);
        this.schedulerApplication.getAutomateLicenceResource().getLicenceSession().tryTrackUtilizationRecordsAsync(utilizationRecords);
    }

    private void testResourcePoolInstanceIds(ResourcePoolModel resourcePool) {
        if (!resourcePool.getActive().booleanValue()) {
            return;
        }
        HashSet cofiguredInstanceIds = new HashSet();
        if (resourcePool.getType().equals((Object)Type.AWS)) {
            CloudResourcePoolSettings cloudSettings = resourcePool.getCloudSettings();
            if (cloudSettings != null) {
                Set instanceIds;
                AwsResourcePoolSettings remoteAwsSettings;
                Set instanceIds2;
                AwsResourcePoolSettings awsSettings = cloudSettings.getAwsSettings();
                if (awsSettings != null && (instanceIds2 = awsSettings.getInstanceIds()) != null) {
                    cofiguredInstanceIds.addAll(instanceIds2);
                }
                if (cloudSettings.getUseRemoteEngines().booleanValue() && (remoteAwsSettings = cloudSettings.getRemoteAwsSettings()) != null && (instanceIds = remoteAwsSettings.getInstanceIds()) != null) {
                    for (String instanceId : instanceIds) {
                        if (!cofiguredInstanceIds.contains(instanceId)) continue;
                        throw new IllegalStateException("Instance " + instanceId + " cannot be used for both the Engines and Remote Workers");
                    }
                    cofiguredInstanceIds.addAll(instanceIds);
                }
            }
            Map<String, String> otherConfiguredInstanceIds = this.getInstanceIdsForResourcePoolIds(resourcePool.getId());
            for (String instanceId : cofiguredInstanceIds) {
                String resourcePoolId = otherConfiguredInstanceIds.get(instanceId);
                if (resourcePoolId == null) continue;
                String resourcePoolName = this.resourcePools.get(resourcePoolId).getName();
                throw new IllegalStateException("Instance " + instanceId + " is already in use in Resource Pool " + resourcePoolName);
            }
        }
    }

    private Map<String, String> getInstanceIdsForResourcePoolIds(String excludeResourcePoolId) {
        HashMap<String, String> cofiguredInstanceIds = new HashMap<String, String>();
        for (ResourcePoolModel resourcePool : this.resourcePools.values()) {
            Set instanceIds;
            AwsResourcePoolSettings remoteAwsSettings;
            Set instanceIds2;
            CloudResourcePoolSettings cloudSettings;
            if (resourcePool.getId().equals(excludeResourcePoolId) || !resourcePool.getActive().booleanValue() || !resourcePool.getType().equals((Object)Type.AWS) || (cloudSettings = resourcePool.getCloudSettings()) == null) continue;
            AwsResourcePoolSettings awsSettings = cloudSettings.getAwsSettings();
            if (awsSettings != null && (instanceIds2 = awsSettings.getInstanceIds()) != null) {
                for (String instanceId : instanceIds2) {
                    cofiguredInstanceIds.put(instanceId, resourcePool.getId());
                }
            }
            if (!cloudSettings.getUseRemoteEngines().booleanValue() || (remoteAwsSettings = cloudSettings.getRemoteAwsSettings()) == null || (instanceIds = remoteAwsSettings.getInstanceIds()) == null) continue;
            for (String instanceId : instanceIds) {
                cofiguredInstanceIds.put(instanceId, resourcePool.getId());
            }
        }
        return cofiguredInstanceIds;
    }

    @Operation(tags={"Resources"}, operationId="SelfRegisterEngineServer", summary="Self-Register Engine Server", description="Initiate the auto-registration process for the Engine Server", responses={@ApiResponse(description="The engine that was added", content={@Content(schema=@Schema(implementation=Engine.class))}), @ApiResponse(responseCode="400", description="Invalid request")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{resourcePoolId}/selfRegistration")
    @POST
    public Response selfRegisterEngineServer(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The ID of the resource pool to register to") @PathParam(value="resourcePoolId") String resourcePoolId, @Parameter(description="The server details", schema=@Schema(implementation=ServerSubmission.class)) Server server, @Parameter(description="Set server roles") @QueryParam(value="roles") Set<EngineRole> roles) throws URISyntaxException, UnknownHostException, GeneralSecurityException, ServerException {
        if (!user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("userNotAllowedToUseApi")).build();
        }
        String accessKey = request.getHeader("X-Resource-Pool-Access-Key");
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        ResourcePoolModel resourcePoolModel = this.resourcePools.get(resourcePoolId);
        if (resourcePoolModel == null) {
            return ExceptionUtils.toResponse((String)"invalidResourcePoolId", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (!Boolean.TRUE.equals(resourcePoolModel.getActive())) {
            return ExceptionUtils.toResponse((String)"resourcePoolNotActive", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (!Boolean.TRUE.equals(resourcePoolModel.getAutoRegistrationEnabled())) {
            LOGGER.error("Cannot self-register Server to " + String.valueOf(resourcePoolModel) + " because it's not enabled for auto-registration");
            return ExceptionUtils.toResponse((String)"resourcePoolNotEnabledForSelfRegistration", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        String resourcePoolAccessKey = resourcePoolModel.getAutoRegistrationSettings().getAccessKey();
        if (!resourcePoolAccessKey.equals(accessKey)) {
            LOGGER.error("Cannot self-register Server to " + String.valueOf(resourcePoolModel) + " with invalid access key");
            return ExceptionUtils.toResponse((String)"invalidAccessKey", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (resourcePoolModel.getAutoRegistrationSettings().getStrictIp()) {
            String serverHostName = FormattingUtils.getHostnameFromUrl((String)server.getUrl());
            Set serverIps = this.schedulerApplication.getNameResolver().getHostIps(serverHostName);
            HashSet<String> expectedIp = new HashSet<String>();
            String requestIp = ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request);
            expectedIp.add(requestIp);
            if (!this.schedulerApplication.getNameResolver().namesNetworkEquivalent(serverIps, expectedIp)) {
                LOGGER.error("Cannot self-register Server to " + String.valueOf(resourcePoolModel) + " because URL " + server.getUrl() + " resolved to IPs " + String.join((CharSequence)"/", serverIps) + " which does not match " + requestIp);
                return ExceptionUtils.toResponse((String)"invalidServerUrl", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        Server addedServer = null;
        server.setDescription(this.iu.getFormattedString("Server.Description.ManagedByResourcePool", (Object)resourcePoolModel.getName()));
        if (server.getTags() == null) {
            server.setTags(new HashMap());
        }
        HashSet engineRoles = new HashSet();
        server.getTags().put(TagsUtil.AUTO_REGISTER_RESOURCE_POOL_ID, resourcePoolId);
        server.getTags().put(TagsUtil.ENGINE_ROLES, SerializationUtils.toJson(roles));
        Response response = this.schedulerApplication.getServerResource().addServer(user, server, false, false);
        if (response.getStatus() != 200) {
            if (response.getEntity() instanceof TranslationResponseStatus) {
                TranslationResponseStatus statusModel = (TranslationResponseStatus)response.getEntity();
                LOGGER.error("Cannot self-register Server to " + String.valueOf(resourcePoolModel) + " because of internal error " + String.valueOf(statusModel));
                return response;
            }
        } else if (response.getEntity() instanceof Server) {
            addedServer = (Server)response.getEntity();
            LOGGER.info("Self-registered " + String.valueOf(addedServer) + " to " + String.valueOf(resourcePoolModel));
        } else {
            LOGGER.error("Cannot self-register Server to " + String.valueOf(resourcePoolModel) + " because internal response is of type " + String.valueOf(response.getEntity().getClass()));
            return ExceptionUtils.toResponse((String)"internalError", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        ServerWorker serverWorker = this.schedulerApplication.getServerResource().getServerWorkers().get(addedServer.getId());
        serverWorker.run();
        serverWorker.removeAllEngines();
        EngineModel engineModel = new EngineModel();
        engineModel.setId(server.getId());
        engineModel.setName(addedServer.getName());
        engineModel.setServerId(addedServer.getId());
        engineModel.setTags(new HashMap());
        engineModel.getTags().put(TagsUtil.AUTO_REGISTER_RESOURCE_POOL_ID, resourcePoolId);
        AutoRegistrationSettings autoRegistrationSettings = resourcePoolModel.getAutoRegistrationSettings();
        engineModel.setSupportedExecutionMode(autoRegistrationSettings.getSupportedExecutionMode());
        engineModel.setPriority(Priority.MEDIUM);
        engineModel.setExecutionProfileId(autoRegistrationSettings.getExecutionProfileId());
        engineModel.setNuixLicenceSourceId(autoRegistrationSettings.getNuixLicenceSourceId());
        engineModel.setMinNuixWorkers(autoRegistrationSettings.getMinNuixWorkers());
        engineModel.setTargetNuixWorkers(autoRegistrationSettings.getTargetNuixWorkers());
        try {
            EngineModel addedEngine = serverWorker.addEngine(engineModel);
            LOGGER.info("Self-registered " + String.valueOf(addedEngine) + " to " + String.valueOf(resourcePoolModel));
        }
        catch (ServerException e) {
            LOGGER.error("Cannot self-register Engine to " + String.valueOf(resourcePoolModel) + " because of server exception", (Throwable)e);
            throw e;
        }
        Engine result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, engineModel);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Resources"}, operationId="UpdateResourcePool", summary="Update Resource Pool", description="Update the resource pool with the specified ID", responses={@ApiResponse(description="The updated resource pool", content={@Content(schema=@Schema(implementation=ResourcePool.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{resourcePoolId}")
    @PUT
    public Response updateResourcePool(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the resource pool to update") @PathParam(value="resourcePoolId") String resourcePoolId, @Parameter(description="The information to update the resource pool with", schema=@Schema(implementation=ResourcePoolSubmission.class)) ResourcePoolModel resourcePool) {
        HashSet<String> updatedEngineIds;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_RESOURCE_POOLS));
        resourceIdentifiers.add(new Identifier(IdentifierType.RESOURCE_POOL_ID, resourcePoolId));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)resourcePool);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        FormattingUtils.trimAllStrings((Object)resourcePool);
        ResourcePoolModel originalResourcePool = this.resourcePools.get(resourcePoolId);
        ResourcePoolModel copyOriginalResourcePool = new ResourcePoolModel(originalResourcePool);
        if (copyOriginalResourcePool == null) {
            return ExceptionUtils.toResponse((String)"invalidResourcePoolId", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (resourcePool.getAutoRegistrationEnabled() != null && !resourcePool.getAutoRegistrationEnabled().equals(copyOriginalResourcePool.getAutoRegistrationEnabled())) {
            return ExceptionUtils.toResponse((String)"cannotChangeSelfRegistrationSetting", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (resourcePool.getName() != null) {
            for (ResourcePoolModel existingResourcePool : this.resourcePools.values()) {
                if (existingResourcePool.getId().equals(resourcePoolId) || !resourcePool.getName().equals(existingResourcePool.getName())) continue;
                return ExceptionUtils.toResponse((String)"resourcePoolSameNameExists", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
            }
            copyOriginalResourcePool.setName(resourcePool.getName());
        }
        if (resourcePool.getDescription() != null) {
            copyOriginalResourcePool.setDescription(resourcePool.getDescription());
        }
        if (resourcePool.getEngineIds() != null) {
            updatedEngineIds = new HashSet<String>();
            updatedEngineIds.addAll(resourcePool.getEngineIds());
            copyOriginalResourcePool.setEngineIds(updatedEngineIds);
            try {
                this.testEngineIdsLocal(updatedEngineIds);
            }
            catch (IllegalStateException e) {
                return ExceptionUtils.toResponse((String)"errorEditingResourcePool", (Map)new HashMap<String, String>(){
                    {
                        this.put("exception", e.getLocalizedMessage());
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        if (resourcePool.getRemoteEngineIds() != null) {
            if (!this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.REMOTE_ENGINES)) {
                resourcePool.getRemoteEngineIds().clear();
            }
            updatedEngineIds = new HashSet();
            updatedEngineIds.addAll(resourcePool.getRemoteEngineIds());
            copyOriginalResourcePool.setRemoteEngineIds(updatedEngineIds);
            try {
                this.testEngineIdsLocal(updatedEngineIds);
            }
            catch (IllegalStateException e) {
                return ExceptionUtils.toResponse((String)"errorEditingResourcePool", (Map)new HashMap<String, String>(){
                    {
                        this.put("exception", e.getLocalizedMessage());
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
            }
        }
        this.setPoolEnginesIds(resourcePoolId, resourcePool.getEngineIds(), resourcePool.getRemoteEngineIds());
        if (resourcePool.getActive() != null) {
            copyOriginalResourcePool.setActive(resourcePool.getActive());
        }
        if (resourcePool.getAutoRegistrationEnabled() != null) {
            copyOriginalResourcePool.setAutoRegistrationEnabled(resourcePool.getAutoRegistrationEnabled());
        }
        if (resourcePool.getAutoRegistrationSettings() != null) {
            if (copyOriginalResourcePool.getAutoRegistrationSettings() != null) {
                String originalAccessKey = copyOriginalResourcePool.getAutoRegistrationSettings().getAccessKey();
                copyOriginalResourcePool.setAutoRegistrationSettings(resourcePool.getAutoRegistrationSettings());
                copyOriginalResourcePool.getAutoRegistrationSettings().setAccessKey(originalAccessKey);
            } else {
                throw new IllegalStateException("Cannot enable auto-registration if it was not originally enabled when the Resource Pool was created");
            }
        }
        if (resourcePool.getCloudSettings() != null) {
            CloudResourcePoolSettings originalCloudSettings = copyOriginalResourcePool.getCloudSettings();
            if (resourcePool.getCloudSettings().getNuixLicenceSourceId() != null) {
                originalCloudSettings.setNuixLicenceSourceId(resourcePool.getCloudSettings().getNuixLicenceSourceId());
            }
            if (resourcePool.getCloudSettings().getTargetNuixWorkers() != null) {
                originalCloudSettings.setTargetNuixWorkers(resourcePool.getCloudSettings().getTargetNuixWorkers());
            }
            if (resourcePool.getCloudSettings().getMinNuixWorkers() != null) {
                originalCloudSettings.setMinNuixWorkers(resourcePool.getCloudSettings().getMinNuixWorkers());
            }
            if (resourcePool.getCloudSettings().getRemoteInstanceIdleAction() != null) {
                originalCloudSettings.setRemoteInstanceIdleAction(resourcePool.getCloudSettings().getRemoteInstanceIdleAction());
            }
            if (resourcePool.getCloudSettings().getRemoteNuixLicenceSourceId() != null) {
                originalCloudSettings.setRemoteNuixLicenceSourceId(resourcePool.getCloudSettings().getRemoteNuixLicenceSourceId());
            }
            if (resourcePool.getCloudSettings().getRemoteTargetNuixWorkers() != null) {
                originalCloudSettings.setRemoteTargetNuixWorkers(resourcePool.getCloudSettings().getRemoteTargetNuixWorkers());
            }
            if (resourcePool.getCloudSettings().getRemoteMinNuixWorkers() != null) {
                originalCloudSettings.setRemoteMinNuixWorkers(resourcePool.getCloudSettings().getRemoteMinNuixWorkers());
            }
            if (resourcePool.getCloudSettings().getUseRemoteEngines() != null) {
                if (resourcePool.getCloudSettings().getUseRemoteEngines().booleanValue()) {
                    this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.REMOTE_ENGINES);
                }
                originalCloudSettings.setUseRemoteEngines(resourcePool.getCloudSettings().getUseRemoteEngines());
            }
            if (resourcePool.getCloudSettings().getRemoteNoIdleBeforeFirstJob() != null) {
                originalCloudSettings.setRemoteNoIdleBeforeFirstJob(resourcePool.getCloudSettings().getRemoteNoIdleBeforeFirstJob());
            }
            if (resourcePool.getCloudSettings().getRemoteNoIdleDuringJob() != null) {
                originalCloudSettings.setRemoteNoIdleDuringJob(resourcePool.getCloudSettings().getRemoteNoIdleDuringJob());
            }
            originalCloudSettings.setWhitelistedCertFingerprints(new HashSet());
            if (resourcePool.getCloudSettings().getWhitelistedCertFingerprints() != null) {
                originalCloudSettings.getWhitelistedCertFingerprints().addAll(FormattingUtils.normalizeCertificateFingerprints((Set)resourcePool.getCloudSettings().getWhitelistedCertFingerprints()));
            }
            String secretKey = null;
            String key = null;
            String customVmPassword = null;
            String remoteCustomVmPassword = null;
            if (originalCloudSettings != null) {
                if (originalCloudSettings.getAwsSettings() != null) {
                    secretKey = originalCloudSettings.getAwsSettings().getSecretKey();
                }
                if (originalCloudSettings.getAzureSettings() != null) {
                    key = originalCloudSettings.getAzureSettings().getKey();
                    customVmPassword = originalCloudSettings.getAzureSettings().getCustomVmPassword();
                }
                if (originalCloudSettings.getRemoteAzureSettings() != null) {
                    remoteCustomVmPassword = originalCloudSettings.getRemoteAzureSettings().getCustomVmPassword();
                }
            }
            copyOriginalResourcePool.setCloudSettings(resourcePool.getCloudSettings());
            originalCloudSettings = copyOriginalResourcePool.getCloudSettings();
            if (originalCloudSettings.getAwsSettings() != null && originalCloudSettings.getAwsSettings().getSecretKey() == null) {
                originalCloudSettings.getAwsSettings().setSecretKey(secretKey);
            }
            if (originalCloudSettings.getAzureSettings() != null) {
                if (originalCloudSettings.getAzureSettings().getKey() == null) {
                    originalCloudSettings.getAzureSettings().setKey(key);
                }
                if (originalCloudSettings.getAzureSettings().getCustomVmPassword() == null) {
                    originalCloudSettings.getAzureSettings().setCustomVmPassword(customVmPassword);
                }
            }
            if (originalCloudSettings.getRemoteAzureSettings() != null && originalCloudSettings.getRemoteAzureSettings().getCustomVmPassword() == null) {
                originalCloudSettings.getRemoteAzureSettings().setCustomVmPassword(remoteCustomVmPassword);
            }
        }
        try {
            this.testResourcePoolInstanceIds(copyOriginalResourcePool);
        }
        catch (IllegalStateException e) {
            return ExceptionUtils.toResponse((String)"errorEditingResourcePool", (Map)new HashMap<String, String>(){
                {
                    this.put("exception", e.getLocalizedMessage());
                }
            }, (Response.Status)Response.Status.BAD_REQUEST);
        }
        copyOriginalResourcePool.getStatus().reset();
        if (copyOriginalResourcePool.getCloudSettings() != null && copyOriginalResourcePool.getCloudSettings().getAwsSettings() != null && (copyOriginalResourcePool.getCloudSettings().getAwsSettings().getSecretKey() == null || copyOriginalResourcePool.getCloudSettings().getAwsSettings().getSecretKey().length() == 0)) {
            copyOriginalResourcePool.getStatus().setError(this.iu.getString("CloudResourcePoolWorker.ReenterSecretKey"));
        }
        if (copyOriginalResourcePool.getCloudSettings() != null && copyOriginalResourcePool.getCloudSettings().getAzureSettings() != null && (copyOriginalResourcePool.getCloudSettings().getAzureSettings().getKey() == null || copyOriginalResourcePool.getCloudSettings().getAzureSettings().getKey().length() == 0)) {
            copyOriginalResourcePool.getStatus().setError(this.iu.getString("CloudResourcePoolWorker.ReenterKey"));
        }
        this.enforceSelfRegistrationSettings(copyOriginalResourcePool);
        if (Boolean.TRUE.equals(copyOriginalResourcePool.getAutoRegistrationEnabled())) {
            copyOriginalResourcePool.setEngineIds(new HashSet());
            copyOriginalResourcePool.setRemoteEngineIds(new HashSet());
        }
        this.resourcePools.put(copyOriginalResourcePool.getId(), copyOriginalResourcePool);
        this.resourcePoolWorkers.get(copyOriginalResourcePool.getId()).setResourcePoolModel(copyOriginalResourcePool);
        if (this.schedulerApplication.getSchedulerConfigurationDao().updateResourcePool(copyOriginalResourcePool) == 0) {
            this.schedulerApplication.getSchedulerConfigurationDao().addResourcePool(copyOriginalResourcePool);
        }
        this.enforceSelfRegistrationSettings(copyOriginalResourcePool);
        ResourcePool eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, copyOriginalResourcePool);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.RESOURCE_POOL_MODIFIED, eventResult, user.getName());
        this.trackResourcePoolUtilization(copyOriginalResourcePool);
        ResourcePool result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, copyOriginalResourcePool);
        result.removeSecrets();
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Resources"}, operationId="DeleteResourcePool", summary="Delete Resource Pool", description="Delete the resource pool with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="404", description="Cannot find resource pool with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{resourcePoolId}")
    @DELETE
    public Response deletePool(@Parameter(hidden=true) @Auth BearerUser user, final @Parameter(description="The ID of the resource pool to delete") @PathParam(value="resourcePoolId") String resourcePoolId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_RESOURCE_POOLS));
        resourceIdentifiers.add(new Identifier(IdentifierType.RESOURCE_POOL_ID, resourcePoolId));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)resourcePoolId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        ResourcePoolModel deletedResourcePool = this.resourcePools.remove(resourcePoolId);
        if (deletedResourcePool == null) {
            return ExceptionUtils.toResponse((String)"resourcePoolNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("resourcePoolId", resourcePoolId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        ResourcePoolWorker resourcePoolWorker = this.resourcePoolWorkers.get(resourcePoolId);
        try {
            resourcePoolWorker.onBeforeDelete();
            this.schedulerApplication.getSchedulerConfigurationDao().deleteResourcePoolEngines(resourcePoolId);
            this.schedulerApplication.getSchedulerConfigurationDao().deleteResourcePool(resourcePoolId);
            ResourcePool eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, deletedResourcePool);
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.RESOURCE_POOL_DELETED, eventResult, user.getName());
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("resourcePoolDeleted")).build();
        }
        catch (IllegalStateException e) {
            return ExceptionUtils.toResponse((String)"cannotDeleteResourcePool", (Map)null, (Exception)e);
        }
    }
}

