/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.bearer.SystemBearerUser;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.client.Matter;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.schedule.Run;
import com.nuix.automate.utils.models.api.schedule.Schedule;
import com.nuix.automate.utils.models.api.schedule.ScheduleSubmission;
import com.nuix.automate.utils.models.api.schedule.WebhookTrigger;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowLibrary;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.SecurityUtils;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.BooleanUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Path(value="/v1/scheduler/schedules")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ScheduleResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ScheduleResource.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private SchedulerApplication schedulerApplication;
    private ConcurrentMap<String, Schedule> schedules;

    public ScheduleResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.schedules = new ConcurrentHashMap<String, Schedule>();
    }

    public Schedule getSchedule(String id) {
        return (Schedule)this.schedules.get(id);
    }

    public void initializeSchedulesFromStore() {
        LOGGER.info("Initializing Schedules from store");
        List<Schedule> schedules = this.schedulerApplication.getJobsDao().getSchedules();
        this.schedules = new ConcurrentHashMap<String, Schedule>();
        for (Schedule schedule : schedules) {
            if (schedule == null) continue;
            this.decryptKeys(schedule);
            this.decryptSensitiveParameters(schedule.getNonNullSessionParameters());
            this.normalizeSchedule(schedule);
            this.schedules.put(schedule.getId(), schedule);
        }
    }

    public Collection<Schedule> getSchedules() {
        return this.schedules.values();
    }

    @Operation(tags={"Schedules"}, operationId="GetSchedules", summary="Get Schedules", description="Get full information of all schedules", responses={@ApiResponse(description="The list of schedules", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Schedule.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getSchedules(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context UriInfo uriInfo) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.SCHEDULES, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            ArrayList<Schedule> allowedSchedules = new ArrayList<Schedule>();
            for (Schedule schedule : this.schedules.values()) {
                this.setScheduleDefaultParameters(schedule);
                Schedule result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, schedule);
                this.setScheduleUrl(request, uriInfo, result);
                for (Parameter parameterModel : result.getNonNullSessionParameters()) {
                    parameterModel.normalize();
                    if (!parameterModel.isProtected() && !parameterModel.isMasked() || parameterModel.getValue() == null || parameterModel.getValue().length() <= 0) continue;
                    parameterModel.setValue(null);
                }
                if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                allowedSchedules.add(result);
            }
            allowedSchedules.sort(Comparator.comparing(Schedule::getName, String.CASE_INSENSITIVE_ORDER));
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedSchedules).build();
        }
    }

    private void setScheduleDefaultParameters(Schedule schedule) {
        HashMap<String, Parameter> scheduleParameters = new HashMap<String, Parameter>();
        for (Parameter scheduleParameter : schedule.getNonNullSessionParameters()) {
            scheduleParameters.put(scheduleParameter.getName(), scheduleParameter);
        }
        ArrayList<Parameter> normalizedScheduleParameter = new ArrayList<Parameter>();
        Workflow workflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(schedule.getLibraryWorkflowId());
        if (workflow != null) {
            for (Parameter workflowParameter : workflow.getSessionParameters()) {
                Parameter scheduleParameter = (Parameter)scheduleParameters.get(workflowParameter.getName());
                if (scheduleParameter != null) {
                    normalizedScheduleParameter.add(scheduleParameter);
                    continue;
                }
                normalizedScheduleParameter.add(workflowParameter);
            }
            schedule.setSessionParameters(normalizedScheduleParameter);
        }
    }

    @Operation(tags={"Schedules"}, operationId="AddSchedule", summary="Add Schedule", description="Add a new schedule", responses={@ApiResponse(description="The schedule that was added", content={@Content(schema=@Schema(implementation=Schedule.class))}), @ApiResponse(responseCode="400", description="A schedule with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Consumes(value={"application/json"})
    public synchronized Response addSchedule(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context UriInfo uriInfo, @io.swagger.v3.oas.annotations.Parameter(description="The schedule to add", schema=@Schema(implementation=ScheduleSubmission.class)) Schedule schedule) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        schedule.setId(UidUtils.getRandom());
        schedule.setDefaults();
        if (schedule.getName() == null || schedule.getName().trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"errorAddingSchedule", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        for (Schedule existingSchedule : this.schedules.values()) {
            if (!existingSchedule.getName().equals(schedule.getName())) continue;
            return ExceptionUtils.toResponse((String)"scheduleSameNameExists", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (schedule.getWebhookTrigger() != null) {
            schedule.getWebhookTrigger().setAccessKey(SecurityUtils.getSecureRandomSecret());
        }
        this.normalizeSchedule(schedule);
        schedule.setCreatedBy(user.getName());
        schedule.setLastModifiedByUserId(user.getId());
        schedule.setCreatedDate(Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()));
        Schedule result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, schedule);
        if (!(user instanceof SystemBearerUser) && !result.getUserPermissions().contains(Permission.SUBMIT_JOB)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        Response errorResponse = this.schedulerApplication.getJobResource().getClientMatterLibraryWorkflowError(this.getScheduleDummyJob(schedule));
        if (errorResponse != null) {
            return errorResponse;
        }
        errorResponse = this.schedulerApplication.getJobResource().getClientMatterLibraryWorkflowError(this.getScheduleDummyJob(schedule));
        if (errorResponse != null) {
            return errorResponse;
        }
        try {
            this.validateScheduleParameters(user, schedule);
        }
        catch (ParameterException e) {
            return ExceptionUtils.toResponse((String)"invalidParameters", (Map)new HashMap<String, String>(){
                {
                    this.put("exception", e.getLocalizedMessage());
                }
            });
        }
        ResponseCache.getInstance().resetKeyId(CacheKey.SCHEDULES, "");
        for (Parameter parameterModel : result.getNonNullSessionParameters()) {
            parameterModel.normalize();
            if (!parameterModel.isProtected() && !parameterModel.isMasked() || parameterModel.getValue() == null || parameterModel.getValue().length() <= 0) continue;
            parameterModel.setValue(null);
        }
        StringBuilder details = new StringBuilder();
        if (schedule.getEnabled() != null && schedule.getEnabled().booleanValue()) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Enabled", (Object)schedule.getEnabled()));
        }
        if (schedule.getDescription() != null) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Description", (Object)schedule.getDescription()));
        }
        if (schedule.getConditions() != null) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getString("ScheduleResource.SubmissionDetails.Conditions"));
        }
        if (schedule.getScheduleTrigger() != null) {
            schedule.setEventTrigger(null);
            schedule.setWebhookTrigger(null);
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getString("ScheduleResource.SubmissionDetails.ScheduleTrigger"));
        }
        if (schedule.getEventTrigger() != null) {
            schedule.setScheduleTrigger(null);
            schedule.setWebhookTrigger(null);
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getString("ScheduleResource.SubmissionDetails.EventTrigger"));
        }
        if (schedule.getWebhookTrigger() != null) {
            schedule.setScheduleTrigger(null);
            schedule.setEventTrigger(null);
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getString("ScheduleResource.SubmissionDetails.WebhookTrigger"));
        }
        if (schedule.getSameMatterAsTriggerMatter() != null && schedule.getSameMatterAsTriggerMatter().booleanValue()) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getString("ScheduleResource.SubmissionDetails.SameMatterAsTrigger"));
            schedule.setSameMatterAsTriggerMatter(Boolean.valueOf(true));
            schedule.setClientId(null);
            schedule.setMatterId(null);
        } else if (schedule.getMatterId() != null) {
            Matter matter = this.schedulerApplication.getClientResource().getMatter(schedule.getMatterId());
            Client client = this.schedulerApplication.getClientResource().getClient(matter.getClientId());
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Matter", (Object)matter.getName()));
            details.append("\n");
            details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Client", (Object)client.getName()));
        } else {
            schedule.setMatterId(null);
            schedule.setClientId(null);
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Matter", (Object)this.iu.getString("JobResource.SubmissionDetails.Unassigned")));
            details.append("\n");
            details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Client", (Object)this.iu.getString("JobResource.SubmissionDetails.Unassigned")));
        }
        if (schedule.getSameWorkflowTemplateAsTriggerMatter() != null && schedule.getSameWorkflowTemplateAsTriggerMatter().booleanValue()) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getString("ScheduleResource.SubmissionDetails.SameWorkflowTemplateAsTrigger"));
            schedule.setSameWorkflowTemplateAsTriggerMatter(Boolean.valueOf(true));
            schedule.setLibraryWorkflowId(null);
            schedule.setLibraryId(null);
        } else if (schedule.getLibraryWorkflowId() != null) {
            schedule.setSameWorkflowTemplateAsTriggerMatter(Boolean.valueOf(false));
            Workflow workflowModel = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(schedule.getLibraryWorkflowId());
            WorkflowLibrary workflowLibrary = this.schedulerApplication.getLibraryResource().getWorkflowLibrary(workflowModel.getLibraryId());
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.WorkflowTemplate", (Object)workflowModel.getName()));
            details.append("\n");
            details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Library", (Object)workflowLibrary.getName()));
        }
        if (schedule.getSameExecutionProfileAsTriggerMatter() != null && schedule.getSameExecutionProfileAsTriggerMatter().booleanValue()) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getString("ScheduleResource.SubmissionDetails.SameExecutionProfileAsTriggerMatter"));
            schedule.setExecutionProfileId(null);
            schedule.setSameExecutionProfileAsTriggerMatter(Boolean.valueOf(true));
        } else if (schedule.getExecutionProfileId() != null) {
            schedule.setSameExecutionProfileAsTriggerMatter(Boolean.valueOf(false));
            ExecutionProfileModel executionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(schedule.getExecutionProfileId());
            if (details.length() > 0) {
                details.append("\n");
            }
            if (executionProfile != null) {
                details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.ExecutionProfile", (Object)executionProfile.getName()));
            } else {
                details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.ExecutionProfile", (Object)this.iu.getString("JobResource.SubmissionDetails.Unassigned")));
            }
        }
        if (schedule.getSameResourcePoolIdAsTriggerMatter() != null && schedule.getSameResourcePoolIdAsTriggerMatter().booleanValue()) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getString("ScheduleResource.SubmissionDetails.SameResourcePoolAsTrigger"));
            schedule.setResourcePoolId(null);
            schedule.setSameResourcePoolIdAsTriggerMatter(Boolean.valueOf(true));
        } else if (schedule.getResourcePoolId() != null) {
            schedule.setSameResourcePoolIdAsTriggerMatter(Boolean.valueOf(false));
            ResourcePoolModel resourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(schedule.getResourcePoolId());
            if (details.length() > 0) {
                details.append("\n");
            }
            if (resourcePool != null) {
                details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.ResourcePool", (Object)resourcePool.getName()));
            } else {
                details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.ResourcePool", (Object)this.iu.getString("JobResource.SubmissionDetails.Unassigned")));
            }
        }
        if (schedule.getSamePriorityAsTriggerMatter() != null && schedule.getSamePriorityAsTriggerMatter().booleanValue()) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getString("ScheduleResource.SubmissionDetails.SamePriorityAsTriggerMatter"));
            schedule.setPriority(null);
            schedule.setSamePriorityAsTriggerMatter(Boolean.valueOf(true));
        } else if (schedule.getPriority() != null) {
            schedule.setSamePriorityAsTriggerMatter(Boolean.valueOf(false));
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Priority", (Object)schedule.getPriority()));
        }
        List parameters = schedule.getNonNullSessionParameters();
        for (Parameter parameter : parameters) {
            parameter.normalize();
            if (details.length() > 0) {
                details.append("\n");
            }
            if ((parameter.isMasked() || parameter.isProtected()) && parameter.getValue() != null) {
                details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Parameter", (Object[])new String[]{parameter.getFriendlyNameAndName(), com.nuix.automate.utils.workflow.Parameter.MASKED_VALUE}));
                continue;
            }
            details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Parameter", (Object[])new String[]{parameter.getFriendlyNameAndName(), parameter.getValue()}));
        }
        result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, schedule);
        if (!(user instanceof SystemBearerUser) && !result.getUserPermissions().contains(Permission.SUBMIT_JOB)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        try {
            this.validateScheduleParameters(user, schedule);
        }
        catch (ParameterException e) {
            return ExceptionUtils.toResponse((String)"invalidParameters", (Map)new HashMap<String, String>(){
                {
                    this.put("exception", e.getLocalizedMessage());
                }
            });
        }
        Schedule encryptedSchedule = schedule.clone();
        this.encryptSensitiveData(encryptedSchedule);
        this.schedules.put(schedule.getId(), schedule);
        this.schedulerApplication.getJobsDao().addSchedule(encryptedSchedule);
        if (details.length() > 0) {
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), schedule.getId(), Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.SCHEDULE_ADDED, details.toString(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        }
        Schedule eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, schedule);
        this.setScheduleUrl(request, uriInfo, eventResult);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.SCHEDULE_ADDED, eventResult, user.getName());
        this.setScheduleUrl(request, uriInfo, result);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    private void setScheduleUrl(HttpServletRequest request, UriInfo uriInfo, Schedule schedule) {
        if (schedule.getWebhookTrigger() != null) {
            if (schedule.getUserPermissions().contains(Permission.SUBMIT_JOB)) {
                schedule.getWebhookTrigger().setUrl(ResourceUtils.getBaseUri((HttpServletRequest)request, (UriInfo)uriInfo) + "webhook/" + schedule.getId() + "/" + schedule.getWebhookTrigger().getAccessKey());
            } else {
                schedule.getWebhookTrigger().setUrl(null);
            }
            schedule.getWebhookTrigger().setAccessKey(null);
            if (schedule.getWebhookTrigger().getSignatureKey() != null && schedule.getWebhookTrigger().getSignatureKey().length() > 0) {
                schedule.getWebhookTrigger().setSignatureKey(null);
            }
        }
    }

    private JobModel getScheduleDummyJob(Schedule schedule) {
        JobModel dummyJob = new JobModel();
        dummyJob.setScheduleId(schedule.getId());
        dummyJob.setName(schedule.getName());
        dummyJob.setNotes(schedule.getDescription());
        dummyJob.setMatterId(schedule.getMatterId());
        dummyJob.setLibraryWorkflowId(schedule.getLibraryWorkflowId());
        dummyJob.setSessionParameters(schedule.getNonNullSessionParameters());
        dummyJob.setPriority(schedule.getPriority());
        dummyJob.setResourcePoolId(schedule.getResourcePoolId());
        dummyJob.setExecutionProfileId(schedule.getExecutionProfileId());
        return dummyJob;
    }

    private void validateScheduleParameters(BearerUser user, Schedule schedule) throws ParameterException {
        if (!Boolean.TRUE.equals(schedule.getSameWorkflowTemplateAsTriggerMatter())) {
            this.schedulerApplication.getJobResource().validateWorkflowSessionParameters(user, this.getScheduleDummyJob(schedule));
        }
    }

    @Operation(tags={"Schedules"}, operationId="GetScheduleRuns", summary="Get Schedule Runs", description="Get the historical runs of the schedule with the specified ID", responses={@ApiResponse(description="The list of runs", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Run.class)))}), @ApiResponse(responseCode="404", description="The schedule with the specified ID does not exist")})
    @SecurityRequirement(name="Bearer_Token")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{scheduleId}/runs")
    @GET
    public Response getRunsDetails(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, @io.swagger.v3.oas.annotations.Parameter(description="The ID of the schedule for which to get the runs") @PathParam(value="scheduleId") String scheduleId) {
        Schedule originalSchedule;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to get runs for scheduleId id " + scheduleId);
        }
        if ((originalSchedule = (Schedule)this.schedules.get(scheduleId)) == null) {
            return ExceptionUtils.toResponse((String)"invalidScheduleId", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        Schedule result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalSchedule);
        if (!(user instanceof SystemBearerUser) && !result.getUserPermissions().contains(Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        List<Run> runs = this.schedulerApplication.getJobsDao().getScheduleRuns(scheduleId);
        for (Run run : runs) {
            JobDetailsModel jobDetails;
            String jobId = run.getJobId();
            if (jobId == null || (jobDetails = this.schedulerApplication.getJobResource().getJobDetailsModel(jobId, 0)) == null) continue;
            run.setJobState(jobDetails.getSettings().getExecutionState());
            run.setJobPercentageComplete(Double.valueOf(jobDetails.getSettings().getPercentageComplete()));
            run.setHasWarnings(jobDetails.getSettings().getHasWarnings().booleanValue());
            run.setHasSoftErrors(jobDetails.getSettings().getHasSoftErrors().booleanValue());
        }
        runs.sort(Comparator.comparing(o -> -o.getDate().longValue()));
        while (runs.size() > this.schedulerApplication.getConfiguration().getMaxScheduleRunsDisplay()) {
            runs.remove(runs.size() - 1);
        }
        String lastHash = ResponseCache.getInstance().hashObject(runs);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(runs).build();
        }
    }

    public void updateRunState(JobModel jobModel) {
        List<Run> runs = this.schedulerApplication.getJobsDao().getScheduleRuns(jobModel.getScheduleId());
        for (Run run : runs) {
            String jobId = run.getJobId();
            if (!jobModel.getId().equals(jobId)) continue;
            run.setJobState(jobModel.getExecutionState());
            run.setJobPercentageComplete(Double.valueOf(jobModel.getPercentageComplete()));
            run.setHasWarnings(jobModel.getHasWarnings().booleanValue());
            run.setHasSoftErrors(jobModel.getHasSoftErrors().booleanValue());
            run.setError((Object)jobModel.getError());
            this.schedulerApplication.getJobsDao().updateScheduleRun(run);
        }
    }

    @Operation(tags={"Schedules"}, operationId="UpdateSchedule", summary="Update Schedule", description="Update the schedule with the specified ID", responses={@ApiResponse(description="The updated schedule", content={@Content(schema=@Schema(implementation=Schedule.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{scheduleId}")
    @PUT
    public Response updateSchedule(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context UriInfo uriInfo, @io.swagger.v3.oas.annotations.Parameter(description="The ID of the schedule to update") @PathParam(value="scheduleId") String scheduleId, @io.swagger.v3.oas.annotations.Parameter(description="The information to update the schedule with", schema=@Schema(implementation=ScheduleSubmission.class)) Schedule schedule) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Schedule originalSchedule = ((Schedule)this.schedules.get(scheduleId)).clone();
        if (originalSchedule == null) {
            return ExceptionUtils.toResponse((String)"invalidScheduleId", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        Schedule result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalSchedule);
        if (!(user instanceof SystemBearerUser) && !result.getUserPermissions().contains(Permission.SUBMIT_JOB)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        StringBuilder details = new StringBuilder();
        if (schedule.getName() != null && !schedule.getName().equals(originalSchedule.getName())) {
            for (Schedule existingSchedule : this.schedules.values()) {
                if (existingSchedule.getId().equals(scheduleId) || !schedule.getName().equals(existingSchedule.getName())) continue;
                return ExceptionUtils.toResponse((String)"scheduleSameNameExists", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
            }
            originalSchedule.setName(schedule.getName());
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Name", (Object)schedule.getName()));
        }
        if (schedule.getEnabled() != null && !schedule.getEnabled().equals(originalSchedule.getEnabled())) {
            originalSchedule.setEnabled(schedule.getEnabled());
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Enabled", (Object)schedule.getEnabled()));
        }
        if (schedule.getDescription() != null && !schedule.getDescription().equals(originalSchedule.getDescription())) {
            originalSchedule.setDescription(schedule.getDescription());
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Description", (Object)schedule.getDescription()));
        }
        if (schedule.getConditions() != null && !schedule.getConditions().equals((Object)originalSchedule.getConditions())) {
            originalSchedule.setConditions(schedule.getConditions());
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getString("ScheduleResource.SubmissionDetails.Conditions"));
        }
        if (schedule.getScheduleTrigger() != null && !schedule.getScheduleTrigger().equals((Object)originalSchedule.getScheduleTrigger())) {
            originalSchedule.setEventTrigger(null);
            originalSchedule.setWebhookTrigger(null);
            originalSchedule.setScheduleTrigger(schedule.getScheduleTrigger());
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getString("ScheduleResource.SubmissionDetails.ScheduleTrigger"));
        }
        if (schedule.getEventTrigger() != null && !schedule.getEventTrigger().equals((Object)originalSchedule.getEventTrigger())) {
            originalSchedule.setScheduleTrigger(null);
            originalSchedule.setWebhookTrigger(null);
            originalSchedule.setEventTrigger(schedule.getEventTrigger());
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getString("ScheduleResource.SubmissionDetails.EventTrigger"));
        }
        if (schedule.getWebhookTrigger() != null) {
            originalSchedule.setScheduleTrigger(null);
            originalSchedule.setEventTrigger(null);
            if (originalSchedule.getWebhookTrigger() == null) {
                originalSchedule.setWebhookTrigger(new WebhookTrigger());
                schedule.getWebhookTrigger().setAccessKey(SecurityUtils.getSecureRandomSecret());
                details.append(this.iu.getString("ScheduleResource.SubmissionDetails.WebhookTrigger"));
            }
            if (schedule.getWebhookTrigger().getHttpVerb() != null && !schedule.getWebhookTrigger().getHttpVerb().equals((Object)originalSchedule.getWebhookTrigger().getHttpVerb())) {
                originalSchedule.getWebhookTrigger().setHttpVerb(schedule.getWebhookTrigger().getHttpVerb());
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.WebhookVerb", (Object)schedule.getWebhookTrigger().getHttpVerb()));
            }
            if (schedule.getWebhookTrigger().getSignatureKey() != null && !schedule.getWebhookTrigger().getSignatureKey().equals(originalSchedule.getWebhookTrigger().getSignatureKey())) {
                originalSchedule.getWebhookTrigger().setSignatureKey(schedule.getWebhookTrigger().getSignatureKey());
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(this.iu.getString("ScheduleResource.SubmissionDetails.SignatureKey"));
            }
            if (schedule.getWebhookTrigger().getHeaders() != null && !schedule.getWebhookTrigger().getHeaders().equals(originalSchedule.getWebhookTrigger().getHeaders())) {
                originalSchedule.getWebhookTrigger().setHeaders(schedule.getWebhookTrigger().getHeaders());
            }
            if (schedule.getWebhookTrigger().getBody() != null && !schedule.getWebhookTrigger().getBody().equals(originalSchedule.getWebhookTrigger().getBody())) {
                originalSchedule.getWebhookTrigger().setBody(schedule.getWebhookTrigger().getBody());
            }
            if (schedule.getWebhookTrigger().getResponseCode() != null && !schedule.getWebhookTrigger().getResponseCode().equals(originalSchedule.getWebhookTrigger().getResponseCode())) {
                originalSchedule.getWebhookTrigger().setResponseCode(schedule.getWebhookTrigger().getResponseCode());
            }
        }
        if (schedule.getSameMatterAsTriggerMatter() != null && schedule.getSameMatterAsTriggerMatter().booleanValue()) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getString("ScheduleResource.SubmissionDetails.SameMatterAsTrigger"));
            originalSchedule.setSameMatterAsTriggerMatter(Boolean.valueOf(true));
            originalSchedule.setClientId(null);
            originalSchedule.setMatterId(null);
        } else if (schedule.getMatterId() != null) {
            originalSchedule.setSameMatterAsTriggerMatter(schedule.getSameMatterAsTriggerMatter());
            if (!schedule.getMatterId().equals(originalSchedule.getMatterId())) {
                Matter matter = this.schedulerApplication.getClientResource().getMatter(schedule.getMatterId());
                originalSchedule.setMatterId(schedule.getMatterId());
                Client client = this.schedulerApplication.getClientResource().getClient(matter.getClientId());
                originalSchedule.setClientId(matter.getClientId());
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Matter", (Object)matter.getName()));
                details.append("\n");
                details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Client", (Object)client.getName()));
            }
        } else if (schedule.getSameMatterAsTriggerMatter() != null) {
            originalSchedule.setSameMatterAsTriggerMatter(schedule.getSameMatterAsTriggerMatter());
            originalSchedule.setMatterId(null);
            originalSchedule.setClientId(null);
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Matter", (Object)this.iu.getString("JobResource.SubmissionDetails.Unassigned")));
            details.append("\n");
            details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Client", (Object)this.iu.getString("JobResource.SubmissionDetails.Unassigned")));
        }
        if (schedule.getSameWorkflowTemplateAsTriggerMatter() != null && schedule.getSameWorkflowTemplateAsTriggerMatter().booleanValue()) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getString("ScheduleResource.SubmissionDetails.SameWorkflowTemplateAsTrigger"));
            originalSchedule.setSameWorkflowTemplateAsTriggerMatter(Boolean.valueOf(true));
            originalSchedule.setLibraryWorkflowId(null);
            originalSchedule.setLibraryId(null);
        } else if (schedule.getLibraryWorkflowId() != null && !schedule.getLibraryWorkflowId().equals(originalSchedule.getLibraryWorkflowId())) {
            originalSchedule.setSameWorkflowTemplateAsTriggerMatter(Boolean.valueOf(false));
            Workflow workflowModel = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(schedule.getLibraryWorkflowId());
            originalSchedule.setLibraryWorkflowId(schedule.getLibraryWorkflowId());
            WorkflowLibrary workflowLibrary = this.schedulerApplication.getLibraryResource().getWorkflowLibrary(workflowModel.getLibraryId());
            originalSchedule.setLibraryId(workflowModel.getLibraryId());
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.WorkflowTemplate", (Object)workflowModel.getName()));
            details.append("\n");
            details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Library", (Object)workflowLibrary.getName()));
        }
        if (schedule.getSameExecutionProfileAsTriggerMatter() != null && schedule.getSameExecutionProfileAsTriggerMatter().booleanValue()) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getString("ScheduleResource.SubmissionDetails.SameExecutionProfileAsTriggerMatter"));
            originalSchedule.setExecutionProfileId(null);
            originalSchedule.setSameExecutionProfileAsTriggerMatter(Boolean.valueOf(true));
        } else if (schedule.getExecutionProfileId() != null && !schedule.getExecutionProfileId().equals(originalSchedule.getExecutionProfileId())) {
            originalSchedule.setSameExecutionProfileAsTriggerMatter(Boolean.valueOf(false));
            ExecutionProfileModel executionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(schedule.getExecutionProfileId());
            originalSchedule.setExecutionProfileId(schedule.getExecutionProfileId());
            if (details.length() > 0) {
                details.append("\n");
            }
            if (executionProfile != null) {
                details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.ExecutionProfile", (Object)executionProfile.getName()));
            } else {
                details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.ExecutionProfile", (Object)this.iu.getString("JobResource.SubmissionDetails.Unassigned")));
            }
        }
        if (schedule.getSameResourcePoolIdAsTriggerMatter() != null && schedule.getSameResourcePoolIdAsTriggerMatter().booleanValue()) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getString("ScheduleResource.SubmissionDetails.SameResourcePoolAsTrigger"));
            originalSchedule.setResourcePoolId(null);
            originalSchedule.setSameResourcePoolIdAsTriggerMatter(Boolean.valueOf(true));
        } else if (schedule.getResourcePoolId() != null && !schedule.getResourcePoolId().equals(originalSchedule.getResourcePoolId())) {
            originalSchedule.setSameResourcePoolIdAsTriggerMatter(Boolean.valueOf(false));
            ResourcePoolModel resourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(schedule.getResourcePoolId());
            originalSchedule.setResourcePoolId(schedule.getResourcePoolId());
            if (details.length() > 0) {
                details.append("\n");
            }
            if (resourcePool != null) {
                details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.ResourcePool", (Object)resourcePool.getName()));
            } else {
                details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.ResourcePool", (Object)this.iu.getString("JobResource.SubmissionDetails.Unassigned")));
            }
        }
        if (schedule.getSamePriorityAsTriggerMatter() != null && schedule.getSamePriorityAsTriggerMatter().booleanValue()) {
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getString("ScheduleResource.SubmissionDetails.SamePriorityAsTriggerMatter"));
            originalSchedule.setPriority(null);
            originalSchedule.setSamePriorityAsTriggerMatter(Boolean.valueOf(true));
        } else if (schedule.getPriority() != null && !schedule.getPriority().equals((Object)originalSchedule.getPriority())) {
            originalSchedule.setSamePriorityAsTriggerMatter(Boolean.valueOf(false));
            originalSchedule.setPriority(schedule.getPriority());
            if (details.length() > 0) {
                details.append("\n");
            }
            details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Priority", (Object)schedule.getPriority()));
        }
        if (schedule.getSessionParameters() != null) {
            Object originalParameter2;
            List originalParameters = originalSchedule.getNonNullSessionParameters();
            HashMap<String, Object> originalParametersMap = new HashMap<String, Object>();
            for (Object originalParameter2 : originalParameters) {
                originalParametersMap.put(originalParameter2.getName(), originalParameter2);
            }
            List parameters = schedule.getSessionParameters();
            originalParameter2 = parameters.iterator();
            while (originalParameter2.hasNext()) {
                Parameter originalParameter3;
                Parameter parameter = (Parameter)originalParameter2.next();
                parameter.normalize();
                if ((parameter.isMasked() || parameter.isProtected()) && parameter.getValue() == null && (originalParameter3 = (Parameter)originalParametersMap.get(parameter.getName())) != null) {
                    parameter.setValue(originalParameter3.getValue());
                }
                if ((parameter.isMasked() || parameter.isProtected()) && parameter.getValue() != null) {
                    if (details.length() > 0) {
                        details.append("\n");
                    }
                    details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Parameter", (Object[])new String[]{parameter.getFriendlyNameAndName(), com.nuix.automate.utils.workflow.Parameter.MASKED_VALUE}));
                }
                if (parameter.isMasked() || parameter.isProtected() || (originalParameter3 = (Parameter)originalParametersMap.get(parameter.getName())) != null && parameter.getValue().equals(originalParameter3.getValue())) continue;
                if (details.length() > 0) {
                    details.append("\n");
                }
                details.append(this.iu.getFormattedString("ScheduleResource.SubmissionDetails.Parameter", (Object[])new String[]{parameter.getFriendlyNameAndName(), parameter.getValue()}));
            }
            originalSchedule.setSessionParameters(parameters);
        }
        originalSchedule.setLastModifiedBy(user.getName());
        originalSchedule.setLastModifiedByUserId(user.getId());
        originalSchedule.setLastModifiedDate(Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()));
        result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalSchedule);
        if (!(user instanceof SystemBearerUser) && !result.getUserPermissions().contains(Permission.SUBMIT_JOB)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        Response errorResponse = this.schedulerApplication.getJobResource().getClientMatterLibraryWorkflowError(this.getScheduleDummyJob(originalSchedule));
        if (errorResponse != null) {
            return errorResponse;
        }
        try {
            this.validateScheduleParameters(user, originalSchedule);
        }
        catch (ParameterException e) {
            return ExceptionUtils.toResponse((String)"invalidParameters", (Map)new HashMap<String, String>(){
                {
                    this.put("exception", e.getLocalizedMessage());
                }
            });
        }
        Schedule encryptedSchedule = originalSchedule.clone();
        this.encryptSensitiveData(encryptedSchedule);
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), scheduleId, Long.valueOf(new DateTime(DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.SCHEDULE_MODIFIED, details.toString(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        this.schedules.put(originalSchedule.getId(), originalSchedule);
        this.schedulerApplication.getJobsDao().updateSchedule(encryptedSchedule);
        ResponseCache.getInstance().resetKeyId(CacheKey.SCHEDULES, "");
        for (Parameter parameterModel : result.getNonNullSessionParameters()) {
            parameterModel.normalize();
            if (!parameterModel.isProtected() && !parameterModel.isMasked() || parameterModel.getValue() == null || parameterModel.getValue().length() <= 0) continue;
            parameterModel.setValue(null);
        }
        Schedule eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalSchedule);
        this.setScheduleUrl(request, uriInfo, eventResult);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.SCHEDULE_MODIFIED, eventResult, user.getName());
        this.setScheduleUrl(request, uriInfo, result);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    public void encryptSensitiveData(Schedule schedule) {
        this.encryptKeys(schedule);
        this.encryptSensitiveParameters(schedule.getNonNullSessionParameters());
    }

    public void encryptKeys(Schedule schedule) {
        if (schedule.getWebhookTrigger() != null) {
            try {
                String encryptedValue;
                schedule.getWebhookTrigger().setUrl(null);
                if (schedule.getWebhookTrigger().getAccessKey() != null) {
                    encryptedValue = this.schedulerApplication.getEncryptor().encrypt(schedule.getWebhookTrigger().getAccessKey());
                    schedule.getWebhookTrigger().setAccessKey(encryptedValue);
                }
                if (schedule.getWebhookTrigger().getSignatureKey() != null) {
                    encryptedValue = this.schedulerApplication.getEncryptor().encrypt(schedule.getWebhookTrigger().getSignatureKey());
                    schedule.getWebhookTrigger().setSignatureKey(encryptedValue);
                }
            }
            catch (IOException e) {
                LOGGER.error("Cannot encrypt keys", (Throwable)e);
                schedule.getWebhookTrigger().setAccessKey(null);
                schedule.getWebhookTrigger().setSignatureKey(null);
            }
        }
    }

    public void encryptSensitiveParameters(List<Parameter> parameters) {
        for (Parameter parameterModel : parameters) {
            parameterModel.normalize();
            if (!parameterModel.isProtected() && !parameterModel.isMasked() || parameterModel.getValue() == null || parameterModel.getValue().length() <= 0) continue;
            String encryptedParameter = "";
            try {
                encryptedParameter = this.schedulerApplication.getEncryptor().encrypt(parameterModel.getValue());
                parameterModel.setValue(encryptedParameter);
            }
            catch (IOException e) {
                LOGGER.error("Cannot encrypt parameter " + parameterModel.getName(), (Throwable)e);
                parameterModel.setValue(null);
            }
        }
    }

    public void decryptKeys(Schedule schedule) {
        if (schedule.getWebhookTrigger() != null) {
            try {
                String decryptedValue;
                if (schedule.getWebhookTrigger().getAccessKey() != null) {
                    decryptedValue = this.schedulerApplication.getEncryptor().decrypt(schedule.getWebhookTrigger().getAccessKey());
                    schedule.getWebhookTrigger().setAccessKey(decryptedValue);
                }
                if (schedule.getWebhookTrigger().getSignatureKey() != null) {
                    decryptedValue = this.schedulerApplication.getEncryptor().decrypt(schedule.getWebhookTrigger().getSignatureKey());
                    schedule.getWebhookTrigger().setSignatureKey(decryptedValue);
                }
            }
            catch (IOException e) {
                LOGGER.error("Cannot decrypt keys", (Throwable)e);
                schedule.getWebhookTrigger().setAccessKey(null);
                schedule.getWebhookTrigger().setSignatureKey(null);
            }
        }
    }

    public void decryptSensitiveParameters(List<Parameter> parameters) {
        for (Parameter parameterModel : parameters) {
            parameterModel.normalize();
            if (!parameterModel.isProtected() && !parameterModel.isMasked() || parameterModel.getValue() == null || parameterModel.getValue().length() <= 0) continue;
            String decryptedParameter = "";
            try {
                decryptedParameter = this.schedulerApplication.getEncryptor().decrypt(parameterModel.getValue());
                parameterModel.setValue(decryptedParameter);
            }
            catch (IOException e) {
                LOGGER.warn("Cannot decrypt parameter " + parameterModel.getName(), (Throwable)e);
            }
        }
    }

    @Operation(tags={"Schedules"}, operationId="DeleteSchedule", summary="Delete Schedule", description="Delete the schedule with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="404", description="Cannot find schedule with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{scheduleId}")
    @DELETE
    public Response deleteSchedule(@io.swagger.v3.oas.annotations.Parameter(hidden=true) @Auth BearerUser user, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context HttpServletRequest request, @io.swagger.v3.oas.annotations.Parameter(hidden=true) @Context UriInfo uriInfo, final @io.swagger.v3.oas.annotations.Parameter(description="The ID of the schedule to delete") @PathParam(value="scheduleId") String scheduleId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Schedule deletedSchedule = (Schedule)this.schedules.remove(scheduleId);
        if (deletedSchedule == null) {
            return ExceptionUtils.toResponse((String)"scheduleNotFound", (Map)new HashMap<String, String>(){
                {
                    this.put("scheduleId", scheduleId);
                }
            }, (Response.Status)Response.Status.NOT_FOUND);
        }
        Schedule result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, deletedSchedule);
        if (!(user instanceof SystemBearerUser || result.getUserPermissions().contains(Permission.MODIFY) || result.getUserPermissions().contains(Permission.MODIFY_CHILDREN))) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        this.schedulerApplication.getJobsDao().deleteSchedule(scheduleId);
        this.schedulerApplication.getJobsDao().deleteScheduleRuns(scheduleId);
        ResponseCache.getInstance().resetKeyId(CacheKey.SCHEDULES, "");
        Schedule eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, deletedSchedule);
        this.setScheduleUrl(request, uriInfo, eventResult);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.SCHEDULE_DELETED, eventResult, user.getName());
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("scheduleDeleted")).build();
    }

    public Collection<Schedule> getActiveSchedulesUsingWorkflow(String workflowId) {
        ArrayList<Schedule> schedulesUsingWorkflow = new ArrayList<Schedule>();
        for (Schedule schedule : this.schedules.values()) {
            if (!Boolean.TRUE.equals(schedule.getEnabled()) || !workflowId.equals(schedule.getLibraryWorkflowId())) continue;
            schedulesUsingWorkflow.add(schedule);
        }
        return schedulesUsingWorkflow;
    }

    private void normalizeSchedule(Schedule schedule) {
        if (schedule.getEventTrigger() != null && schedule.getScheduleTrigger() != null) {
            LOGGER.warn("Schedule " + schedule.getId() + " has both an event trigger and a schedule trigger. Clearing out event trigger");
            schedule.setEventTrigger(null);
        }
        if (BooleanUtils.isTrue((Boolean)schedule.getSameMatterAsTriggerMatter())) {
            schedule.setMatterId(null);
            schedule.setClientId(null);
        }
        if (BooleanUtils.isTrue((Boolean)schedule.getSameExecutionProfileAsTriggerMatter())) {
            schedule.setExecutionProfileId(null);
        }
        if (BooleanUtils.isTrue((Boolean)schedule.getSameResourcePoolIdAsTriggerMatter())) {
            schedule.setResourcePoolId(null);
        }
        if (BooleanUtils.isTrue((Boolean)schedule.getSamePriorityAsTriggerMatter())) {
            schedule.setPriority(null);
        }
        if (BooleanUtils.isTrue((Boolean)schedule.getSameWorkflowTemplateAsTriggerMatter())) {
            schedule.setLibraryId(null);
            schedule.setLibraryWorkflowId(null);
        }
        schedule.setStatus(new Status());
        schedule.getStatus().resetOk();
        if (schedule.getWebhookTrigger() != null && schedule.getWebhookTrigger().getAccessKey() == null) {
            schedule.getStatus().setWarningMessage(this.iu.getString("Schedule.ReCreate"));
        }
    }
}

