/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.bearer.OfflineUser;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.general.SortingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.securitypolicy.IdentifierTypes;
import com.nuix.automate.utils.models.api.securitypolicy.SecurityPolicy;
import com.nuix.automate.utils.models.api.securitypolicy.SecurityPolicySubmission;
import com.nuix.automate.utils.models.api.securitypolicy.SymmetricKey;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Path(value="/v1/scheduler/security")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class SecurityResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SecurityResource.class);
    private SchedulerApplication schedulerApplication;

    public SecurityResource(SchedulerApplication schedulerApplication) {
        LOGGER.info("Initializing SecurityResource");
        this.schedulerApplication = schedulerApplication;
    }

    @Operation(tags={"Security"}, operationId="GetSecurityPolicies", summary="Get Security Policies", description="Get full information of all security policies", responses={@ApiResponse(description="The list of security policies", content={@Content(array=@ArraySchema(schema=@Schema(implementation=SecurityPolicy.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/policies")
    public Response getSecurityPolicies(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.SECURITY_POLICIES, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            List<SecurityPolicy> policies = this.schedulerApplication.getSecurityPolicyUtil().getPolicies();
            ArrayList<Object> securityPolicyModels = new ArrayList<Object>();
            for (SecurityPolicy securityPolicy : policies) {
                SecurityPolicy result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, securityPolicy);
                if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                securityPolicyModels.add(result);
                List auditLog = result.getAuditLog();
                if (!result.getUserPermissions().contains(Permission.VIEW_SENSITIVE)) continue;
                auditLog.addAll(this.schedulerApplication.getAuditLogDao().getAuditEvents(result.getId()));
                auditLog.sort(Comparator.comparing(AuditEvent::getDate));
            }
            SortingUtils.sortList(securityPolicyModels, SecurityPolicy::getName);
            ArrayList<SecurityPolicy> implicitPolicies = new ArrayList<SecurityPolicy>();
            for (SecurityPolicy implicitPolicy : this.schedulerApplication.getLegalHoldResource().getLegalHoldImplicitPolicies()) {
                SecurityPolicy result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, implicitPolicy);
                if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                result.getUserPermissions().clear();
                result.getUserPermissions().add(Permission.VIEW);
                implicitPolicies.add(result);
            }
            SortingUtils.sortList(implicitPolicies, SecurityPolicy::getName);
            securityPolicyModels.addAll(implicitPolicies);
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(securityPolicyModels).build();
        }
    }

    @Operation(tags={"Security"}, operationId="UpdateSecurityPolicy", summary="Update Security Policy", description="Update the security policy with the specified ID", responses={@ApiResponse(description="The updated security policy", content={@Content(schema=@Schema(implementation=SecurityPolicy.class))}), @ApiResponse(responseCode="400", description="Policy name is missing")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/policies/{policyId}")
    @PUT
    public Response updateSecurityPolicy(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The ID of the security policy to update") @PathParam(value="policyId") String policyId, @Parameter(description="The information to update the security policy with", schema=@Schema(implementation=SecurityPolicySubmission.class)) SecurityPolicy securityPolicy) {
        SecurityPolicy originalSecurityPolicy = this.schedulerApplication.getSecurityPolicyUtil().getPolicy(policyId);
        if (originalSecurityPolicy == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindPolicy", (Map)new HashMap<String, String>(){
                {
                    this.put("policyId", policyId);
                }
            })).build();
        }
        FormattingUtils.trimAllStrings((Object)securityPolicy);
        securityPolicy.setId(policyId);
        SecurityPolicy result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, securityPolicy);
        if (!result.getUserPermissions().contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)securityPolicy);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        if (securityPolicy.getName() == null) {
            for (SecurityPolicy existingPolicy : this.schedulerApplication.getSecurityPolicyUtil().getPolicies()) {
                if (existingPolicy.getId().equals(policyId) || !existingPolicy.getName().equals(securityPolicy.getName())) continue;
                return ExceptionUtils.toResponse((String)"securityPolicyNameExists", (Response.Status)Response.Status.BAD_REQUEST);
            }
            securityPolicy.setName(originalSecurityPolicy.getName());
        }
        if (securityPolicy.getDescription() == null) {
            securityPolicy.setDescription(originalSecurityPolicy.getDescription());
        }
        if (securityPolicy.getEnabled() == null) {
            securityPolicy.setEnabled(originalSecurityPolicy.getEnabled());
        }
        if (securityPolicy.getPermissions() == null) {
            securityPolicy.setPermissions((Set)originalSecurityPolicy.getPermissions());
        } else if (securityPolicy.getPermissions().contains(Permission.VIEW)) {
            securityPolicy.getPermissions().remove(Permission.VIEW_LIMITED);
        }
        if (securityPolicy.getScope() == null) {
            securityPolicy.setScope((Set)originalSecurityPolicy.getScope());
        }
        if (securityPolicy.getPrincipals() == null) {
            securityPolicy.setPrincipals((Set)originalSecurityPolicy.getPrincipals());
        }
        if (securityPolicy.getName().length() == 0) {
            return ExceptionUtils.toResponse((String)"policyNameMissing", (Map)null);
        }
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.SECURITY));
        Set<Permission> resultingPermissions = this.schedulerApplication.getSecurityPolicyUtil().whatIfGetPermissions(user.getIdentifiers(), scopeIdentifiers, null, securityPolicy);
        if (!resultingPermissions.contains(Permission.MODIFY) || !resultingPermissions.contains(Permission.VIEW)) {
            return ExceptionUtils.toResponse((String)"cannotRemoveCurrentUserAccess", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        this.schedulerApplication.getSecurityPolicyUtil().addOrUpdatePolicy(securityPolicy);
        SecurityPolicy eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, securityPolicy);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.SECURITY_POLICY_MODIFIED, eventResult, user.getName());
        String details = this.schedulerApplication.getSecurityPolicyUtil().policyChangesToString(originalSecurityPolicy, securityPolicy);
        if (details.length() > 0) {
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), policyId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.SECURITY_POLICY_MODIFIED, details, ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        }
        if ((securityPolicy.getId().equals("84884db3-ca7f-3f1a-068b-239374b82ba2") || securityPolicy.getName().equals("Default Policy") && securityPolicy.getDescription().equals("This policy allows any authenticated users to perform any action")) && (!securityPolicy.isHasWarnings() || securityPolicy.getWarnings() == null || securityPolicy.getWarnings().size() == 0)) {
            securityPolicy.setHasWarnings(originalSecurityPolicy.isHasWarnings());
            securityPolicy.setWarnings(originalSecurityPolicy.getWarnings());
        }
        result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, securityPolicy);
        ResponseCache.getInstance().resetAll();
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Security"}, operationId="DeleteSecurityPolicy", summary="Delete Security Policy", description="Delete the security policy with the specified ID", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="400", description="Cannot find the security policy with the specified ID or deletion would remove access to current user")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/policies/{policyId}")
    @DELETE
    public Response deleteSecurityPolicy(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, final @Parameter(description="The ID of the security policy to delete") @PathParam(value="policyId") String policyId) {
        SecurityPolicy securityPolicy = this.schedulerApplication.getSecurityPolicyUtil().getPolicy(policyId);
        if (securityPolicy == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotFindPolicy", (Map)new HashMap<String, String>(){
                {
                    this.put("policyId", policyId);
                }
            })).build();
        }
        SecurityPolicy result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, securityPolicy);
        if (!result.getUserPermissions().contains(Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)result);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        HashSet<Identifier> scopeIdentifiers = new HashSet<Identifier>();
        scopeIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.SECURITY));
        Set<Permission> resultingPermissions = this.schedulerApplication.getSecurityPolicyUtil().whatIfGetPermissions(user.getIdentifiers(), scopeIdentifiers, policyId, null);
        if (!resultingPermissions.contains(Permission.MODIFY) || !resultingPermissions.contains(Permission.VIEW)) {
            return ExceptionUtils.toResponse((String)"cannotRemoveCurrentUserAccess", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        this.schedulerApplication.getSecurityPolicyUtil().deletePolicy(policyId);
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), policyId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.SECURITY_POLICY_DELETED, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        SecurityPolicy eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, securityPolicy);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.SECURITY_POLICY_DELETED, eventResult, user.getName());
        ResponseCache.getInstance().resetAll();
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("policyDeleted", (Map)new HashMap<String, String>(){
            {
                this.put("policyId", policyId);
            }
        })).build();
    }

    @Operation(tags={"Security"}, operationId="AddSecurityPolicy", summary="Add Security Policy", description="Add a new security policy", responses={@ApiResponse(description="The security policy that was added", content={@Content(schema=@Schema(implementation=SecurityPolicy.class))}), @ApiResponse(responseCode="400", description="Policy name is missing")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Path(value="/policies")
    public Response addSecurityPolicy(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The security policy to add", schema=@Schema(implementation=SecurityPolicySubmission.class)) SecurityPolicy securityPolicy) {
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.SECURITY));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)securityPolicy);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        if (securityPolicy.getName() == null || securityPolicy.getName().length() == 0) {
            return ExceptionUtils.toResponse((String)"policyNameMissing", (Map)null);
        }
        FormattingUtils.trimAllStrings((Object)securityPolicy);
        for (SecurityPolicy existingPolicy : this.schedulerApplication.getSecurityPolicyUtil().getPolicies()) {
            if (!existingPolicy.getName().equals(securityPolicy.getName())) continue;
            return ExceptionUtils.toResponse((String)"securityPolicyNameExists", (Response.Status)Response.Status.BAD_REQUEST);
        }
        String policyId = this.schedulerApplication.getSecurityPolicyUtil().getPolicies().size() == 0 ? "100008a0-0001-49bc-a049-9ff82cf68d63" : UidUtils.getRandom();
        securityPolicy.setId(policyId);
        securityPolicy.setDefaults();
        this.schedulerApplication.getSecurityPolicyUtil().addOrUpdatePolicy(securityPolicy);
        SecurityPolicy eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, securityPolicy);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.SECURITY_POLICY_ADDED, eventResult, user.getName());
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), policyId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.SECURITY_POLICY_ADDED, this.schedulerApplication.getSecurityPolicyUtil().policyToString(securityPolicy), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        if (securityPolicy.getPermissions().contains(Permission.VIEW)) {
            securityPolicy.getPermissions().remove(Permission.VIEW_LIMITED);
        }
        SecurityPolicy result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, securityPolicy);
        ResponseCache.getInstance().resetAll();
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Security"}, operationId="GetIdentifierTypes", summary="Get Identifier Types", description="Get the types of identifiers possible for the security policy principals and scope, including the values allowed for the built-in types", responses={@ApiResponse(description="The list of allowed identifier types", content={@Content(schema=@Schema(implementation=IdentifierTypes.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/policies/identifierTypes")
    @GET
    public Response getIdentifierTypes(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        LinkedHashMap allowedIdentifiers = new LinkedHashMap();
        LinkedHashMap<String, BuiltInPrincipalIdentifiers[]> principalTypes = new LinkedHashMap<String, BuiltInPrincipalIdentifiers[]>();
        allowedIdentifiers.put("principal", principalTypes);
        principalTypes.put(IdentifierType.BUILTIN.name(), new BuiltInPrincipalIdentifiers[]{BuiltInPrincipalIdentifiers.AUTHENTICATED_USER, BuiltInPrincipalIdentifiers.INTERNAL_USER});
        if (this.schedulerApplication.getUserServiceResource().getEnabledMicrosoftOidcClients().size() > 0) {
            principalTypes.put(IdentifierType.AZURE_USERNAME.name(), null);
            principalTypes.put(IdentifierType.AZURE_GROUP_ID.name(), null);
        }
        if (this.schedulerApplication.getUserServiceResource().isOidcAuthenticationEnabled()) {
            principalTypes.put(IdentifierType.OIDC_USERNAME.name(), null);
            principalTypes.put(IdentifierType.OIDC_GROUP.name(), null);
        }
        if (this.schedulerApplication.getUserServiceResource().isLdapAuthenticationEnabled()) {
            principalTypes.put(IdentifierType.LDAP_USERNAME.name(), null);
            principalTypes.put(IdentifierType.LDAP_GROUP_DN.name(), null);
        }
        if (this.schedulerApplication.getUserServiceResource().isUmsAuthenticationEnabled()) {
            principalTypes.put(IdentifierType.UMS_USERNAME.name(), null);
            principalTypes.put(IdentifierType.UMS_GROUP.name(), null);
            principalTypes.put(IdentifierType.UMS_PRIVILEGE.name(), null);
            principalTypes.put(IdentifierType.UMS_ROLE.name(), null);
        }
        if (this.schedulerApplication.getConfiguration().getInternalCredentials() != null) {
            principalTypes.put(IdentifierType.INTERNAL_USERNAME.name(), null);
        }
        if (this.schedulerApplication.getUserServiceResource().getEnabledRelativityUserImpersonationService().size() > 0) {
            principalTypes.put(IdentifierType.RELATIVITY_USER_EMAIL.name(), null);
            principalTypes.put(IdentifierType.RELATIVITY_GROUP_ID.name(), null);
            principalTypes.put(IdentifierType.RELATIVITY_GROUP_NAME.name(), null);
        }
        LinkedHashMap<String, ArrayList<BuiltInScopeIdentifiers>> scopeTypes = new LinkedHashMap<String, ArrayList<BuiltInScopeIdentifiers>>();
        allowedIdentifiers.put("scope", scopeTypes);
        ArrayList<BuiltInScopeIdentifiers> builtInScopeIdentifiers = new ArrayList<BuiltInScopeIdentifiers>(Arrays.asList(BuiltInScopeIdentifiers.values()));
        SortingUtils.sortList(builtInScopeIdentifiers, Enum::toString);
        scopeTypes.put(IdentifierType.BUILTIN.name(), builtInScopeIdentifiers);
        String lastHash = ResponseCache.getInstance().hashObject(allowedIdentifiers);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedIdentifiers).build();
        }
    }

    @Operation(tags={"Security"}, operationId="GetOneTimeKey", summary="Get One-Time Key", description="Get a one-time key used to encrypt sensitive information", responses={@ApiResponse(description="The one-time key", content={@Content(schema=@Schema(implementation=SymmetricKey.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/oneTimeKey")
    @GET
    public Response getOneTimeKey(@Parameter(hidden=true) @Auth BearerUser user) {
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.schedulerApplication.getAesEncryptor().generateNewKey()).build();
    }

    public OfflineUser getOfflineUserFromId(String userId) {
        OfflineUser offlineUser = SchedulerApplication.getInstance().getSecurityDao().getOfflineUser(userId);
        return offlineUser;
    }
}

