/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.bearer.SystemBearerUser;
import com.nuix.automate.scheduler.utils.TagsUtil;
import com.nuix.automate.scheduler.workers.ServerWorker;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.exceptions.ServerException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.LocalizedEnum;
import com.nuix.automate.utils.general.SortingUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.engine.EngineStatus;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.server.Server;
import com.nuix.automate.utils.models.api.server.ServerCommand;
import com.nuix.automate.utils.models.api.server.ServerStatus;
import com.nuix.automate.utils.models.api.server.ServerSubmission;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;

@Path(value="/v1/scheduler/resources/servers")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ServerResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ServerResource.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private SchedulerApplication schedulerApplication;
    private Map<String, ServerWorker> serverWorkers;
    private UUID uuid;

    public ServerResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.uuid = UUID.randomUUID();
        this.serverWorkers = new HashMap<String, ServerWorker>();
    }

    @Operation(tags={"Resources"}, operationId="GetServers", summary="Get Servers", description="Get full information of all servers", responses={@ApiResponse(description="The list of servers", content={@Content(array=@ArraySchema(schema=@Schema(implementation=Server.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getServers(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        ArrayList<Server> allowedServers = new ArrayList<Server>();
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        for (ServerWorker serverWorker : this.serverWorkers.values()) {
            Server result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, serverWorker.getModel());
            if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
            allowedServers.add(result);
        }
        SortingUtils.sortList(allowedServers, Server::getName);
        String lastModified = ResponseCache.getInstance().hashObject(allowedServers);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(allowedServers).build();
        }
    }

    private void trackServerUtilization(Server serverModel) {
        com.nuix.automate.utils.utilization.Server server = new com.nuix.automate.utils.utilization.Server();
        server.setServerId(serverModel.getId());
        server.setServerName(serverModel.getName());
        this.schedulerApplication.getUtilizationDaoV2().replaceServer(server);
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        HashSet<com.nuix.automate.utils.utilization.Server> servers = new HashSet<com.nuix.automate.utils.utilization.Server>();
        utilizationRecords.setServers(servers);
        servers.add(server);
        this.schedulerApplication.getAutomateLicenceResource().getLicenceSession().tryTrackUtilizationRecordsAsync(utilizationRecords);
    }

    @Operation(tags={"Resources"}, operationId="DeleteServer", summary="Delete Server", description="Delete the server with the specified ID. If the servers has engines associated, the engines will be removed from the server, except for engines which are running jobs", responses={@ApiResponse(description="The deletion status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="400", description="Invalid server ID, or server has engines which cannot be deleted because they are running jobs")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{serverId}")
    @DELETE
    public Response deleteServer(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the server to delete") @PathParam(value="serverId") String serverId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        LOGGER.info("Received request to delete server " + serverId);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!(user instanceof SystemBearerUser) && !this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)serverId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        ServerWorker serverWorker = this.serverWorkers.get(serverId);
        if (serverWorker == null) {
            return ExceptionUtils.toResponse((String)"invalidServerId", (Map)null);
        }
        StringBuilder errorMessage = new StringBuilder();
        ArrayList<EngineModel> engineModels = new ArrayList<EngineModel>();
        if (serverWorker != null && serverWorker.getEngineModels() != null) {
            engineModels.addAll(serverWorker.getEngineModels());
        }
        for (EngineModel engineModel : engineModels) {
            if (!engineModel.getStatus().equals((Object)EngineStatus.RUNNING) && !engineModel.getStatus().equals((Object)EngineStatus.PENDING) && !engineModel.getStatus().equals((Object)EngineStatus.FINISHED)) continue;
            if (errorMessage.length() > 0) {
                errorMessage.append(", ");
            }
            errorMessage.append(this.iu.getFormattedString("ServerResource.EngineInState", new Object[]{engineModel.getName(), new LocalizedEnum("SchedulerText", (Enum)engineModel.getStatus()).toString()}));
        }
        if (TagsUtil.hasTag(TagsUtil.CLOUD_INSTANCE_ID, serverWorker.getModel().getTags())) {
            LOGGER.info("Removing all Engines before sending license to Cloud server");
            try {
                serverWorker.removeAllEngines();
            }
            catch (ServerException e) {
                LOGGER.error("Cannot remove engines", (Throwable)e);
            }
        }
        if (errorMessage.length() > 0) {
            final String finalErrorMessage = errorMessage.toString();
            return ExceptionUtils.toResponse((String)"errorDeletingServer", (Map)new HashMap<String, String>(){
                {
                    this.put("errorMessage", finalErrorMessage);
                }
            });
        }
        Server deletedServer = serverWorker.getModel();
        final String serverName = serverWorker.getModel().getName();
        serverWorker = this.serverWorkers.remove(serverId);
        if (serverWorker == null) {
            return ExceptionUtils.toResponse((String)"invalidServerId", (Map)null);
        }
        this.schedulerApplication.getSchedulerConfigurationDao().deleteServer(serverId);
        Server eventResults = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, deletedServer);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.ENGINE_SERVER_DELETED, eventResults, user.getName());
        serverWorker.cancel();
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("serverRemoved", (Map)new HashMap<String, String>(){
            {
                this.put("serverName", serverName);
            }
        })).build();
    }

    public void deleteManagedServerInternal(String serverId) {
        ServerWorker serverWorker = this.serverWorkers.remove(serverId);
        if (serverWorker == null) {
            throw new IllegalArgumentException("Cannot find serverWorker with ID " + serverId);
        }
        serverWorker.cancel();
    }

    @Operation(tags={"Resources"}, operationId="UpdateServer", summary="Update Server", description="Update the server with the specified ID", responses={@ApiResponse(description="The updated server", content={@Content(schema=@Schema(implementation=Client.class))}), @ApiResponse(responseCode="400", description="A server with the same name already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{serverId}")
    @PUT
    public Response updateServer(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the server to update") @PathParam(value="serverId") String serverId, @Parameter(description="The information to update the server with", schema=@Schema(implementation=ServerSubmission.class)) Server server) throws GeneralSecurityException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        server.normalize();
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)serverId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        ServerWorker originalServerWorker = this.serverWorkers.get(serverId);
        if (originalServerWorker == null) {
            return ExceptionUtils.toResponse((String)"invalidServerId", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        FormattingUtils.trimAllStrings((Object)server);
        Server originalServer = originalServerWorker.getModel();
        if (server.getName() != null) {
            for (ServerWorker serverWorker : this.serverWorkers.values()) {
                if (serverWorker == originalServerWorker || !serverWorker.getModel().getName().equals(server.getName())) continue;
                return ExceptionUtils.toResponse((String)"serverSameNameExists", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
            }
            originalServer.setName(server.getName());
        }
        if (server.getDescription() != null) {
            originalServer.setDescription(server.getDescription());
        }
        if (server.getWhitelistedCertFingerprints() != null) {
            originalServer.setWhitelistedCertFingerprints(FormattingUtils.normalizeCertificateFingerprints((Set)server.getWhitelistedCertFingerprints()));
            originalServerWorker.initializeClient();
        }
        if (this.schedulerApplication.getSchedulerConfigurationDao().updateServer(originalServer) == 0) {
            this.schedulerApplication.getSchedulerConfigurationDao().addServer(originalServer);
        }
        Server eventResults = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, originalServer);
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.ENGINE_SERVER_MODIFIED, eventResults, user.getName());
        this.trackServerUtilization(originalServer);
        Server responseServer = new Server(originalServer);
        Server result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, responseServer);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    @Operation(tags={"Resources"}, operationId="SendServerCommand", summary="Send Server Command", description="Send a command to the server with the specified ID, for example to enter maintenance", responses={@ApiResponse(responseCode="200", description="The command execution status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="400", description="Invalid server ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{serverId}/command")
    @PUT
    public Response sendServerCommand(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The ID of the server to send the command to") @PathParam(value="serverId") String serverId, @Parameter(description="The command") ServerCommand serverCommand) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        LOGGER.info("Received command " + String.valueOf(serverCommand) + " for server " + serverId);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)serverId);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        ServerWorker serverWorker = this.serverWorkers.get(serverId);
        if (serverWorker == null) {
            return ExceptionUtils.toResponse((String)"invalidServerId", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        try {
            ResponseStatus responseStatus = serverWorker.sendCommand(serverCommand);
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)responseStatus).build();
        }
        catch (ServerException e) {
            return ExceptionUtils.toResponse((String)"cannotSendServerCommand", (Map)null, (Exception)((Object)e));
        }
    }

    @Operation(tags={"Resources"}, operationId="AddServer", summary="Add Server", description="Add a new server", responses={@ApiResponse(description="The server that was added", content={@Content(schema=@Schema(implementation=Server.class))}), @ApiResponse(responseCode="400", description="Invalid server name or URL, or a server with the same name or URL already exists")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Consumes(value={"application/json"})
    public Response addServer(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The server to add", schema=@Schema(implementation=ServerSubmission.class)) Server server) throws GeneralSecurityException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        server.normalize();
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)server);
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        server.setId(null);
        FormattingUtils.trimAllStrings((Object)server);
        if (server.getWhitelistedCertFingerprints() != null) {
            server.setWhitelistedCertFingerprints(FormattingUtils.normalizeCertificateFingerprints((Set)server.getWhitelistedCertFingerprints()));
        }
        return this.addServer(user, server, false, true);
    }

    public Response addServer(BearerUser user, final Server server, boolean initializing, boolean persist) throws GeneralSecurityException {
        Server existingServer;
        LOGGER.info("Registering server " + server.getName());
        if (server.getName() == null || server.getName().trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"serverInvalidName", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        if (server.getUrl() == null || server.getUrl().trim().length() == 0) {
            return ExceptionUtils.toResponse((String)"serverInvalidUrl", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        for (ServerWorker serverWorker : this.serverWorkers.values()) {
            if (!serverWorker.getModel().getName().equals(server.getName())) continue;
            return ExceptionUtils.toResponse((String)"serverExists", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        for (ServerWorker existingServerWorker : this.serverWorkers.values()) {
            if (!existingServerWorker.getModel().getUrl().trim().equalsIgnoreCase(server.getUrl().trim())) continue;
            return ExceptionUtils.toResponse((String)"serverExists", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
        }
        server.setError(null);
        ServerWorker serverWorker = new ServerWorker(this.schedulerApplication, this, server);
        if (!initializing) {
            serverWorker.run();
        }
        if (server.getId() != null && (existingServer = this.getServerWithId(server.getId())) != null && existingServer != server) {
            server.setStatus(ServerStatus.ERROR);
            server.setError(this.iu.getFormattedString("ServerResource.ExistsWithDifferentName", (Object)existingServer.getName()));
        }
        server.setDefaults();
        if (server.getStatus() == ServerStatus.INITIALIZED || initializing) {
            Timer timer = new Timer(true);
            timer.schedule((TimerTask)serverWorker, 0L, this.schedulerApplication.getConfiguration().getServerPingInterval());
            if (persist) {
                if (this.schedulerApplication.getSchedulerConfigurationDao().updateServer(server) == 0) {
                    this.schedulerApplication.getSchedulerConfigurationDao().addServer(server);
                }
                Server eventResults = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, server);
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.ENGINE_SERVER_ADDED, eventResults, user.getName());
            }
            if (server.getId() == null) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("errorAddingServerNoId")).build();
            }
            this.serverWorkers.put(server.getId(), serverWorker);
            this.trackServerUtilization(server);
            Server result = user != null ? this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, server) : server;
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("errorAddingServer", (Map)new HashMap<String, String>(){
            {
                this.put("message", server.getError());
            }
        })).build();
    }

    public Map<String, ServerWorker> getServerWorkers() {
        return this.serverWorkers;
    }

    public void initializeServersFromStore() {
        LOGGER.info("Initializing Servers from store");
        List<Server> servers = this.schedulerApplication.getSchedulerConfigurationDao().getServers();
        for (Server server : servers) {
            if (server.getTags() != null && server.getTags().get(TagsUtil.CLOUD_INSTANCE_ID) != null) {
                this.schedulerApplication.getSchedulerConfigurationDao().deleteServer(server.getId());
            } else {
                try {
                    this.addServer(null, server, true, false);
                }
                catch (GeneralSecurityException e) {
                    LOGGER.error("Cannot add server " + String.valueOf(server), (Throwable)e);
                }
            }
            if (server.getTags() != null && server.getTags().get(TagsUtil.CLOUD_INSTANCE_ID) != null) {
                this.schedulerApplication.getSchedulerConfigurationDao().deleteServer(server.getId());
                continue;
            }
            try {
                this.addServer(null, server, true, false);
            }
            catch (GeneralSecurityException e) {
                LOGGER.error("Cannot add server " + String.valueOf(server), (Throwable)e);
            }
        }
    }

    public Server getServerWithId(String id) {
        ServerWorker serverWorker = this.getServerWorkerWithId(id);
        if (serverWorker != null) {
            return serverWorker.getModel();
        }
        return null;
    }

    public ServerWorker getServerWorkerWithId(String id) {
        if (id != null) {
            return this.serverWorkers.get(id);
        }
        return null;
    }
}

