/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.utils.api.internal.configuration.SettingModel;
import com.nuix.automate.utils.api.internal.configuration.SettingsModel;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.utilization.DiagnosticLevel;
import com.nuix.automate.utils.utilization.Key;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdbi.v3.core.statement.StatementException;

@Path(value="/v1/scheduler/settings")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class SettingsResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SettingsResource.class);
    private SchedulerApplication schedulerApplication;
    private SchedulerConfiguration schedulerConfiguration;
    public static final String DIAGNOSTIC_CATEGORY = "Diagnostic";
    public static final String DIAGNOSTIC_KEY_SETTING = "Key";
    public static final String DIAGNOSTIC_LEVEL_SETTING = "Level";
    public static final String LOGIN_LINK_CATEGORY = "LoginLink";
    public static final String LOGIN_LINK_KEY_SETTING = "Key";
    public static final String CLOUD_RESOURCE_POOL_INSTANCES = "CloudResourcePoolInstances";
    public static final String DATABASE = "Database";
    public static final String VERSION = "Version";
    public static final String OIDC = "ContainsOidcConfiguration";

    public SettingsResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.schedulerConfiguration = schedulerApplication.getConfiguration();
    }

    public <T> T getCategorySetting(String category, String settingKey, Class<T> type) {
        String value = this.schedulerApplication.getSchedulerConfigurationDao().getCategorySettingKeyValue(category, settingKey);
        if (value != null) {
            try {
                Object deserializedValue = SerializationUtils.fromJson((String)value, type);
                return (T)deserializedValue;
            }
            catch (Exception e) {
                LOGGER.warn("Cannot deserialize category " + category + " setting " + settingKey, (Throwable)e);
            }
        }
        return null;
    }

    public void putCategorySetting(String category, String setting, Object value) {
        String encodedValue = SerializationUtils.toJson((Object)value);
        try {
            this.schedulerApplication.getSchedulerConfigurationDao().addSetting(category, setting, encodedValue);
        }
        catch (StatementException e) {
            this.schedulerApplication.getSchedulerConfigurationDao().updateSetting(category, setting, encodedValue);
        }
    }

    @Operation(tags={"Settings"}, operationId="GetSystemSettings", summary="Get System Settings", description="Get full information of all of the system settings, or the default value if the current user does not define a specific setting", responses={@ApiResponse(description="The settings", content={@Content(schema=@Schema(ref="#/components/schemas/SettingsCategoriesNamesValues"))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    public Response getSettings(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received request to get settings");
        }
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.SYSTEM_SETTINGS, "");
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW_SENSITIVE)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
                return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
            }
            SettingsModel settingsModel = new SettingsModel();
            List<SettingModel> settings = this.schedulerApplication.getSchedulerConfigurationDao().getUserSettings();
            for (SettingModel settingModel : settings) {
                if (!settingsModel.containsKey((Object)settingModel.getCategory())) {
                    settingsModel.put((Object)settingModel.getCategory(), new HashMap());
                }
                Object value = SerializationUtils.fromJson((String)settingModel.getValue(), Object.class);
                ((Map)settingsModel.get((Object)settingModel.getCategory())).put(settingModel.getKey(), value);
            }
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)settingsModel).build();
        }
    }

    @Operation(tags={"Settings"}, operationId="UpdateSystemSetting", summary="Update System Setting", description="Update the system setting from the category with the specified name", responses={@ApiResponse(description="The update status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{category}/{setting}")
    @PUT
    public Response updateSetting(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The category from which to update the setting", example="CategoryA") @PathParam(value="category") String category, @Parameter(description="The name of the setting to update", example="SettingA1") @PathParam(value="setting") String setting, @Parameter(description="The new value of the setting", example="TOP_LEFT") Object value) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)(category + " " + setting));
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        this.putCategorySetting(category, setting, value);
        ResponseCache.getInstance().resetKeyId(CacheKey.SYSTEM_SETTINGS, "");
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("settingUpdatedSuccessfully")).build();
    }

    public Key getDiagnosticKey() {
        return this.getKey(DIAGNOSTIC_CATEGORY, "Key");
    }

    public Key getLoginLinkKey() {
        return this.getEncryptedKey(LOGIN_LINK_CATEGORY, "Key");
    }

    public Key getEncryptedKey(String category, String settingKey) {
        Key key = this.getCategorySetting(category, settingKey, Key.class);
        if (key != null) {
            try {
                key.setSecret(this.schedulerApplication.getEncryptor().decrypt(key.getSecret()));
            }
            catch (IOException e) {
                LOGGER.error("Failed to decrypt " + category + " " + settingKey + ": " + key.getId(), (Throwable)e);
                key = null;
            }
        }
        if (key == null) {
            key = Key.generate();
            String secret = key.getSecret();
            try {
                key.setSecret(this.schedulerApplication.getEncryptor().encrypt(secret));
            }
            catch (IOException e) {
                LOGGER.error("Failed to encrypt " + category + " " + settingKey + ": " + key.getId(), (Throwable)e);
            }
            LOGGER.info("Generated " + category + " " + settingKey + ": " + key.getId());
            this.putCategorySetting(category, settingKey, key);
            key.setSecret(secret);
        }
        return key;
    }

    public Key getKey(String category, String settingKey) {
        Key key = this.getCategorySetting(category, settingKey, Key.class);
        if (key == null) {
            key = Key.generate();
            LOGGER.info("Generated " + category + " " + settingKey + ": " + key.getId());
            this.putCategorySetting(category, settingKey, key);
        }
        return key;
    }

    public DiagnosticLevel getDiagnosticLevel() {
        DiagnosticLevel diagnosticLevel = this.getCategorySetting(DIAGNOSTIC_CATEGORY, DIAGNOSTIC_LEVEL_SETTING, DiagnosticLevel.class);
        if (diagnosticLevel == null) {
            diagnosticLevel = DiagnosticLevel.ENHANCED;
            this.setDiagnosticLevel(diagnosticLevel);
        }
        return diagnosticLevel;
    }

    public void setDiagnosticLevel(DiagnosticLevel diagnosticLevel) {
        this.putCategorySetting(DIAGNOSTIC_CATEGORY, DIAGNOSTIC_LEVEL_SETTING, diagnosticLevel);
    }

    public void setOidcMigrated() {
        this.putCategorySetting(DATABASE, OIDC, true);
    }

    public boolean getOidcMigrated() {
        return Boolean.TRUE.equals(this.getCategorySetting(DATABASE, OIDC, Boolean.class));
    }

    public void setDatabaseVersion(String version) {
        this.putCategorySetting(DATABASE, VERSION, version);
    }

    public String getDatabaseVersion() {
        return this.getCategorySetting(DATABASE, VERSION, String.class);
    }
}

