/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Path(value="/v1/scheduler/resources/webhook/soft")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class SoftWebhookResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SoftWebhookResource.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;

    public SoftWebhookResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
    }

    @Operation(tags={"Resources"}, operationId="SoftDeleteWebhook", summary="Soft Delete Webhook", description="Disable the webhook with the specified ID", responses={@ApiResponse(description="The status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))}), @ApiResponse(responseCode="404", description="Cannot find Webhook with the specified ID")})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{webhookId}")
    @DELETE
    public Response softDeleteWebhook(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @PathParam(value="webhookId") String webhookId) {
        return this.schedulerApplication.getWebhookResource().softDeleteWebhook(user, request, webhookId);
    }
}

