/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.bearer.OfflineUser;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.comment.ObjectType;
import com.nuix.automate.utils.models.api.comment.UserComment;
import com.nuix.automate.utils.models.internal.cache.CachedObjectMap;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Path(value="/v1/scheduler/userComment")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class UserCommentResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UserCommentResource.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private final SchedulerApplication schedulerApplication;
    private final CachedObjectMap<UserComments> cachedUserCommentInfos;

    public UserCommentResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        this.cachedUserCommentInfos = new CachedObjectMap(60000L);
        schedulerApplication.getScheduledExecutorService().scheduleWithFixedDelay(() -> this.cachedUserCommentInfos.clearExpired(), 0L, 1L, TimeUnit.MINUTES);
    }

    @Operation(tags={"UserComments"}, operationId="GetUserCommentsForObject", summary="Get User Comments For Object", description="Get user comments for object", responses={@ApiResponse(description="User notice comments", content={@Content(array=@ArraySchema(schema=@Schema(implementation=UserComment.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{objectType}/{objectId}")
    @GET
    public Response getUserComments(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The object type") @PathParam(value="objectType") String objectType, @Parameter(description="The object ID") @PathParam(value="objectId") String objectId) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        long lastModified = ResponseCache.getInstance().getLastModified(CacheKey.USER_COMMENTS, objectId);
        try {
            return ResponseCache.getInstance().getResponse(lastModified, request, user.getShortSessionId());
        }
        catch (CacheException cacheException) {
            Set<Permission> objectPermissions;
            try {
                objectPermissions = this.validateAndGetObjectPermissions(user, objectType, objectId, new Permission[0]);
            }
            catch (ResponseException e) {
                return e.getResponse();
            }
            ArrayList<UserComment> userComments = new ArrayList<UserComment>();
            if (objectPermissions.contains(Permission.VIEW)) {
                List<UserComment> cachedComments = this.getUserCommentsForObject(objectId);
                for (UserComment userComment : cachedComments) {
                    userComments.add(this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userComment, objectPermissions));
                }
                userComments.sort(Comparator.comparing(UserComment::getCreatedDate));
            }
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)(lastModified + "-" + user.getShortSessionId())).type(MediaType.APPLICATION_JSON_TYPE).entity(userComments).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(tags={"UserComments"}, operationId="PostUserCommentForObject", summary="Post User Comment For Object", description="Post user comment for object", responses={@ApiResponse(description="The user comment", content={@Content(schema=@Schema(implementation=UserComment.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{objectType}/{objectId}")
    @POST
    public Response postUserComment(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The object type") @PathParam(value="objectType") String objectType, @Parameter(description="The object ID") @PathParam(value="objectId") String objectId, @Parameter(description="The comment", schema=@Schema(implementation=UserComment.class)) UserComment userComment) {
        Set<Permission> objectPermissions;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        try {
            objectPermissions = this.validateAndGetObjectPermissions(user, objectType, objectId, Permission.VIEW, Permission.MODIFY);
        }
        catch (ResponseException e) {
            return e.getResponse();
        }
        String message = userComment.getMessage();
        if (message == null || message.trim().isEmpty()) {
            return ExceptionUtils.toResponse((String)"userCommentMessageEmpty", (Response.Status)Response.Status.BAD_REQUEST);
        }
        String id = UidUtils.getRandom();
        userComment.setId(id);
        userComment.setObjectId(objectId);
        userComment.setUserId(user.getId());
        userComment.getViewedByUserIds().add(user.getId());
        this.populateUsername(userComment);
        ObjectType type = ObjectType.fromString((String)objectType);
        userComment.setObjectType(type);
        long createdDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        userComment.setCreatedDate(Long.valueOf(createdDate));
        UserComments userComments = this.getUserComments(objectId);
        try {
            userComments.lock.lock();
            this.schedulerApplication.getSchedulerConfigurationDao().addUserComment(userComment);
            if (userComments.values != null) {
                userComments.values.add(userComment);
            }
            ResponseCache.getInstance().resetKeyId(CacheKey.USER_COMMENTS, objectId);
        }
        finally {
            userComments.lock.unlock();
        }
        EventType.Type eventType = null;
        switch (type) {
            case JOB: {
                eventType = EventType.Type.JOB_USER_COMMENT_ADDED;
            }
        }
        UserComment eventResult = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userComment, objectPermissions);
        if (eventType != null) {
            SchedulerApplication.getInstance().getWebhookWorker().triggerEvent(eventType, eventResult, user.getName());
        }
        UserComment result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userComment, objectPermissions);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Operation(tags={"UserComments"}, operationId="ViewUserComment", summary="View User Comment", description="View user comment", responses={@ApiResponse(description="The user comment", content={@Content(schema=@Schema(implementation=UserComment.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @Path(value="/{objectType}/{objectId}/{userCommentId}/viewed")
    @POST
    public Response postViewedUserComment(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The object type") @PathParam(value="objectType") String objectType, @Parameter(description="The object ID") @PathParam(value="objectId") String objectId, final @Parameter(description="The user comment ID") @PathParam(value="userCommentId") String userCommentId) {
        Set<Permission> objectPermissions;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        try {
            objectPermissions = this.validateAndGetObjectPermissions(user, objectType, objectId, Permission.VIEW);
        }
        catch (ResponseException e) {
            return e.getResponse();
        }
        UserComment userComment = null;
        UserComments userComments = this.getUserComments(objectId);
        try {
            userComments.lock.lock();
            if (userComments.values != null) {
                for (UserComment cachedComment : userComments.values) {
                    if (!cachedComment.getId().equals(userCommentId)) continue;
                    userComment = cachedComment;
                    break;
                }
            } else {
                userComment = this.schedulerApplication.getSchedulerConfigurationDao().getUserComment(userCommentId);
                this.populateUsername(userComment);
            }
            if (userComment == null) {
                Response response = ExceptionUtils.toResponse((String)"cannotFindUserComment", (Map)new HashMap<String, String>(){
                    {
                        this.put("id", userCommentId);
                    }
                }, (Response.Status)Response.Status.BAD_REQUEST);
                return response;
            }
            if (!userComment.getViewedByUserIds().contains(user.getId())) {
                userComment.getViewedByUserIds().add(user.getId());
                this.schedulerApplication.getSchedulerConfigurationDao().updateUserComment(userComment);
                ResponseCache.getInstance().resetKeyId(CacheKey.USER_COMMENTS, objectId);
            }
        }
        finally {
            userComments.lock.unlock();
        }
        UserComment result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userComment, objectPermissions);
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserComment> getUserCommentsForObject(String objectId) {
        UserComments userComments = this.getUserComments(objectId);
        try {
            userComments.lock.lock();
            if (userComments.values == null || userComments.trackingLatest) {
                userComments.values = this.schedulerApplication.getSchedulerConfigurationDao().getUserComments(objectId);
                userComments.trackingLatest = false;
                for (UserComment userComment : userComments.values) {
                    this.populateUsername(userComment);
                }
            }
            List<UserComment> list = userComments.values;
            return list;
        }
        finally {
            userComments.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserComment getLatestUserCommentForObject(String objectId) {
        UserComments userComments = this.getUserComments(objectId);
        try {
            UserComment userComment;
            userComments.lock.lock();
            if (userComments.values == null) {
                userComments.values = new ArrayList<UserComment>();
                userComments.trackingLatest = true;
                UserComment latestUserComment = this.schedulerApplication.getSchedulerConfigurationDao().getLatestUserComment(objectId);
                if (latestUserComment != null) {
                    userComments.values.add(latestUserComment);
                    this.populateUsername(latestUserComment);
                }
            }
            if (!userComments.values.isEmpty()) {
                userComment = userComments.values.get(userComments.values.size() - 1);
                return userComment;
            }
            userComment = null;
            return userComment;
        }
        finally {
            userComments.lock.unlock();
        }
    }

    private UserComments getUserComments(String objectId) {
        UserComments userComments = (UserComments)this.cachedUserCommentInfos.get(objectId, true);
        if (userComments == null) {
            userComments = this.createUserCommentInfo(objectId);
        }
        return userComments;
    }

    private void populateUsername(UserComment userComment) {
        OfflineUser offlineUser = this.schedulerApplication.getSecurityDao().getOfflineUser(userComment.getUserId());
        if (offlineUser != null) {
            userComment.setUsername(offlineUser.getMainIdentifier().getIdentifierName());
        }
    }

    private synchronized UserComments createUserCommentInfo(String objectId) {
        return (UserComments)this.cachedUserCommentInfos.computeIfAbsent(objectId, k -> new UserComments());
    }

    private Set<Permission> getObjectPermissions(BearerUser user, String objectType, final String objectId) throws ResponseException {
        Set objectPermissions;
        ObjectType type = ObjectType.fromString((String)objectType);
        if (type == null) {
            throw new ResponseException(ExceptionUtils.toResponse((String)"userCommentObjectTypeNotSupported"));
        }
        switch (type) {
            case JOB: {
                JobDetailsModel jobDetails = this.schedulerApplication.getJobResource().getJobDetailsModel(objectId);
                if (jobDetails == null) {
                    throw new ResponseException(ExceptionUtils.toResponse((String)"cannotFindJobIdNotExists", (Map)new HashMap<String, String>(){
                        {
                            this.put("jobId", objectId);
                        }
                    }, (Response.Status)Response.Status.NOT_FOUND));
                }
                objectPermissions = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, jobDetails.getSettings()).getUserPermissions();
                if (!objectPermissions.contains(Permission.SUBMIT_JOB)) break;
                objectPermissions.add(Permission.MODIFY);
                break;
            }
            default: {
                throw new ResponseException(ExceptionUtils.toResponse((String)"userCommentObjectTypeNotSupported"));
            }
        }
        if (objectPermissions.contains(Permission.MODIFY_CHILDREN)) {
            objectPermissions.add(Permission.MODIFY);
        }
        if (objectPermissions.contains(Permission.VIEW_LIMITED)) {
            objectPermissions.remove(Permission.VIEW);
        }
        return objectPermissions;
    }

    private Set<Permission> validateAndGetObjectPermissions(BearerUser user, String objectType, String objectId, Permission ... permissions) throws ResponseException {
        Set<Permission> objectPermissions = this.getObjectPermissions(user, objectType, objectId);
        for (Permission permission : permissions) {
            if (objectPermissions.contains(permission)) continue;
            throw new ResponseException(ExceptionUtils.buildForbiddenResponse());
        }
        return objectPermissions;
    }

    private static class UserComments {
        Lock lock = new ReentrantLock();
        List<UserComment> values;
        boolean trackingLatest;

        UserComments() {
        }
    }
}

