/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nuix.automate.dropwizard.utils.security.bearer.ApiBearerUser;
import com.nuix.automate.dropwizard.utils.security.bearer.AuthenticatedUser;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.SchedulerConfiguration;
import com.nuix.automate.scheduler.security.AuthType;
import com.nuix.automate.scheduler.security.bearer.BearerUserToken;
import com.nuix.automate.scheduler.security.bearer.LoginLinkBearerUser;
import com.nuix.automate.scheduler.security.internal.Credential;
import com.nuix.automate.scheduler.security.internal.InternalBearerUser;
import com.nuix.automate.scheduler.security.ldap.LdapBearerUser;
import com.nuix.automate.scheduler.security.ldap.LdapClient;
import com.nuix.automate.scheduler.security.oidc.OidcPartialUser;
import com.nuix.automate.scheduler.security.oidc.OidcUserServiceClient;
import com.nuix.automate.scheduler.security.oidc.generic.OidcBearerUser;
import com.nuix.automate.scheduler.security.oidc.generic.OidcJwtUser;
import com.nuix.automate.scheduler.security.oidc.microsoft.MicrosoftUserService;
import com.nuix.automate.scheduler.security.oidc.microsoft.OidcMicrosoftBearerUser;
import com.nuix.automate.scheduler.security.thirdparty.ThirdPartyServiceSession;
import com.nuix.automate.scheduler.security.ums.UmsUtil;
import com.nuix.automate.scheduler.utils.HttpAddressUtils;
import com.nuix.automate.scheduler.utils.LoginLinkUtils;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.ResponseStatus;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.OidcErrorInfo;
import com.nuix.automate.utils.general.ResourceUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenseException;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.licence.services.LicenceSession;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.legalhold.LegalHold;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.securitypolicy.SecurityPolicy;
import com.nuix.automate.utils.models.api.smtp.EmailType;
import com.nuix.automate.utils.models.api.smtp.SmtpEmail;
import com.nuix.automate.utils.models.api.thirdparty.InvestigateService;
import com.nuix.automate.utils.models.api.thirdparty.PurviewService;
import com.nuix.automate.utils.models.api.thirdparty.SmtpService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationScope;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.user.LoginAttempt;
import com.nuix.automate.utils.models.api.user.LoginFailure;
import com.nuix.automate.utils.models.api.user.LoginLinkScope;
import com.nuix.automate.utils.models.api.user.Logout;
import com.nuix.automate.utils.models.api.user.PasswordAuthenticationSubmission;
import com.nuix.automate.utils.models.api.user.SystemApiKeyAuthenticationSubmission;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.api.user.UserSession;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import com.nuix.automate.utils.models.internal.user.ErrorModel;
import com.nuix.automate.utils.models.internal.user.LoginLinkPayload;
import com.nuix.automate.utils.models.internal.user.OidcLoginMode;
import com.nuix.automate.utils.models.internal.user.OidcUserService;
import com.nuix.automate.utils.models.internal.user.UserService;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.SecurityUtils;
import com.nuix.automate.utils.security.policies.ApplicationFeatures;
import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.utilization.Activity;
import com.nuix.automate.utils.utilization.ActivityDetails;
import com.nuix.automate.utils.utilization.ActivityType;
import com.nuix.automate.utils.utilization.User;
import com.unboundid.ldap.sdk.LDAPException;
import io.dropwizard.auth.Auth;
import io.dropwizard.auth.AuthenticationException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeIn;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import jakarta.annotation.security.PermitAll;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.jdbi.v3.core.statement.StatementException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@SecurityScheme(name="Bearer_Token", type=SecuritySchemeType.APIKEY, in=SecuritySchemeIn.HEADER, paramName="Authorization", description="**Bearer** followed by token, for example:\n\n`Bearer bf46c49d-986a-b3bf4dd8582e:clOd6StgcRADPVpeGK`\n\n")
@Path(value="/v1/users")
public class UserResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UserResource.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private static final String OIDC_COMPLETE_COOKIE_NAME = "oidcComplete";
    private static final String OIDC_INIT_COOKIE_NAME = "oidcInit";
    private static final String OIDC_ELEVATE_COOKIE_NAME = "oidcElevate";
    private static final String OIDC_ERROR_COOKIE_NAME = "oidcError";
    private SchedulerApplication schedulerApplication;
    private SchedulerConfiguration schedulerConfiguration;
    private Map<String, ActivityDetails> userActivities;
    private final LoginLinkUtils loginLinkUtils;
    private final Set<String> loginLinks;
    private Map<String, OidcErrorInfo> oidcErrorMap;

    public UserResource(SchedulerApplication schedulerApplication, SchedulerConfiguration schedulerConfiguration) {
        this.schedulerApplication = schedulerApplication;
        this.schedulerConfiguration = schedulerConfiguration;
        this.userActivities = new HashMap<String, ActivityDetails>();
        this.loginLinkUtils = new LoginLinkUtils(schedulerApplication);
        this.loginLinks = ConcurrentHashMap.newKeySet();
        this.oidcErrorMap = new HashMap<String, OidcErrorInfo>();
        this.initializeLoginLinkExpireWorker();
    }

    public void initializeLoginLinkExpireWorker() {
        this.schedulerApplication.getScheduledExecutorService().scheduleWithFixedDelay(() -> this.loginLinks.removeIf(loginLink -> {
            LoginLinkPayload linkPayload = this.loginLinkUtils.parsePayload((String)loginLink);
            return !this.loginLinkUtils.isPayloadValid(linkPayload, false);
        }), 0L, 60L, TimeUnit.SECONDS);
    }

    public String createLegalHoldLoginLink(UserAccount userAccount, LegalHold legalHold, String navigationUrl) {
        UserService userService = this.schedulerApplication.getUserServiceResource().getUserService(userAccount.getUserServiceId());
        if (userService instanceof MicrosoftUserService) {
            Object url = legalHold.getSchedulerUrl();
            if (!((String)url).endsWith("/")) {
                url = (String)url + "/";
            }
            url = (String)url + "#/?oidcScope=" + URLEncoder.encode(userService.getName(), StandardCharsets.UTF_8) + "&redirectUrl=" + URLEncoder.encode(navigationUrl, StandardCharsets.UTF_8);
            return url;
        }
        if (this.loginLinkUtils.isLoginLinkEnabled(legalHold, userService, LoginLinkScope.LEGAL_HOLD)) {
            LoginLinkPayload linkPayload = new LoginLinkPayload(userAccount.getId(), legalHold.getId(), LoginLinkScope.LEGAL_HOLD);
            linkPayload.setRedirectUrl(navigationUrl);
            try {
                String loginLink = this.loginLinkUtils.createLoginLink(legalHold.getSchedulerUrl(), linkPayload);
                this.loginLinks.add(this.loginLinkUtils.getUrlFragment(loginLink));
                return loginLink;
            }
            catch (URISyntaxException | InvalidKeyException | NoSuchAlgorithmException e) {
                LOGGER.error("Failed to create login link", (Throwable)e);
            }
        }
        return legalHold.getSchedulerUrl() + "/#/" + navigationUrl;
    }

    @Operation(tags={"Security"}, operationId="AuthenticateWithLoginLink", summary="Authenticate With Login Link", description="Authenticate user with a login link", responses={@ApiResponse(description="The user session", content={@Content(schema=@Schema(implementation=UserSession.class))}), @ApiResponse(responseCode="401", description="Invalid login link, or user is not authorized to use this application"), @ApiResponse(responseCode="404", description="Login link was not be found"), @ApiResponse(responseCode="500", description="Error communicating with the authentication server")})
    @POST
    @Path(value="/loginLink")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response authenticateWithLoginLink(@Context UriInfo uriInfo, @Parameter(hidden=true) @Context HttpServletRequest request, String loginLink) {
        String sessionId;
        block17: {
            loginLink = loginLink.replace("\"", "");
            LOGGER.info("Received request to authenticate login link: " + loginLink);
            sessionId = UidUtils.getRandom();
            try {
                UserAccount userAccount;
                LoginLinkPayload linkPayload;
                LoginAttempt loginAttempt = new LoginAttempt("LoginLink", "LoginLink", "N/A", sessionId);
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_ATTEMPTED, loginAttempt, "N/A");
                boolean formatValid = true;
                String auditLoginLink = loginLink;
                try {
                    String[] ssoTokenSplit = this.loginLinkUtils.getSsoTokenSplit(loginLink);
                    auditLoginLink = ssoTokenSplit[0];
                }
                catch (Exception e) {
                    LOGGER.error("Exception parsing login link", (Throwable)e);
                    formatValid = false;
                }
                this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.AUTH_LOGIN_ATTEMPTED, this.iu.getFormattedString("UserResource.LoginLink", (Object)auditLoginLink), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                boolean userDisabled = false;
                if (!formatValid) break block17;
                String linkFragment = null;
                try {
                    linkFragment = this.loginLinkUtils.getUrlFragment(loginLink);
                }
                catch (URISyntaxException e) {
                    LOGGER.error("Invalid link fragment", (Throwable)e);
                }
                if (this.loginLinks.remove(linkFragment)) {
                    linkPayload = this.loginLinkUtils.parsePayload(loginLink);
                    userAccount = this.schedulerApplication.getUserServiceResource().getUser(linkPayload.getUserId());
                    boolean bl = userDisabled = !this.schedulerApplication.getUserServiceResource().getUserAndServiceIsEnabled(userAccount);
                    if (this.loginLinkUtils.isPayloadValid(linkPayload, false)) {
                        UserService userService;
                        String redirectUrl = linkPayload.getRedirectUrl();
                        if (!userDisabled && (userService = this.schedulerApplication.getUserServiceResource().getUserService(userAccount.getUserServiceId())).getAvailableForUrl(ResourceUtils.getRemoteRequestUrl((HttpServletRequest)request))) {
                            if (userService instanceof MicrosoftUserService) {
                                OidcRedirect oidcRedirect = new OidcRedirect(userService.getName());
                                oidcRedirect.setRedirectUrl(redirectUrl);
                                return Response.status((Response.Status)Response.Status.OK).entity((Object)oidcRedirect).build();
                            }
                            LoginLinkBearerUser user = new LoginLinkBearerUser(userAccount);
                            user.setSessionId(sessionId);
                            UserSession userSession = this.schedulerApplication.getBearerAuthenticator().registerUser(user);
                            userSession.setRedirectUrl(redirectUrl);
                            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), user.getName(), EventType.Type.AUTH_LOGIN_SUCCESSFUL, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                            LOGGER.info("User " + user.getName() + ", session " + user.getSessionId() + ", logged in");
                            loginAttempt = new LoginAttempt("LoginLink", "LoginLink", user.getName(), sessionId);
                            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_SUCCESSFUL, loginAttempt, user.getName());
                            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)userSession).cookie(new NewCookie[]{this.getUiCookieFromUserSession(request, uriInfo, userSession)}).build();
                        }
                    } else {
                        LOGGER.warn("Login link is not valid");
                    }
                } else {
                    LOGGER.warn("Login link is not valid: Link was not found in list of active links");
                }
                if (!userDisabled && this.loginLinkUtils.validateLinkSignature(loginLink)) {
                    linkPayload = this.loginLinkUtils.parsePayload(loginLink);
                    userAccount = this.schedulerApplication.getUserServiceResource().getUser(linkPayload.getUserId());
                    UserService userService = this.schedulerApplication.getUserServiceResource().getUserService(userAccount.getUserServiceId());
                    if (userService != null && userService.getAvailableForUrl(ResourceUtils.getRemoteRequestUrl((HttpServletRequest)request))) {
                        boolean bl = userDisabled = !this.schedulerApplication.getUserServiceResource().getUserAndServiceIsEnabled(userAccount);
                        if (!userDisabled) {
                            LoginFailure loginFailure;
                            if (this.loginLinkUtils.isPayloadValid(linkPayload, true)) {
                                this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.AUTH_LOGIN_FAILED, this.iu.getString("UserResource.ExpiredLoginLink"), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                                loginFailure = new LoginFailure("LoginLink", "LoginLink", "N/A", sessionId, this.iu.getString("UserResource.ExpiredLoginLink"));
                                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_FAILED, loginFailure, "N/A");
                                return ExceptionUtils.toResponse((String)"loginLinkExpired", (Response.Status)Response.Status.NOT_FOUND);
                            }
                            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.AUTH_LOGIN_FAILED, this.iu.getString("UserResource.LoginLinkNoLongerValid"), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                            loginFailure = new LoginFailure("LoginLink", "LoginLink", "N/A", sessionId, this.iu.getString("UserResource.LoginLinkNoLongerValid"));
                            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_FAILED, loginFailure, "N/A");
                            return ExceptionUtils.toResponse((String)"loginLinkNoLongerValid", (Response.Status)Response.Status.NOT_FOUND);
                        }
                    } else {
                        LOGGER.warn("Login link is not valid for access URL " + ResourceUtils.getRemoteRequestUrl((HttpServletRequest)request));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot authenticate with login link", (Throwable)e);
            }
        }
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.AUTH_LOGIN_FAILED, this.iu.getString("UserResource.InvalidLoginLink"), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        LoginFailure loginFailure = new LoginFailure("LoginLink", "LoginLink", "N/A", sessionId, this.iu.getString("UserResource.InvalidLoginLink"));
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_FAILED, loginFailure, "N/A");
        return ExceptionUtils.toResponse((String)"loginLinkInvalid", (Response.Status)Response.Status.UNAUTHORIZED);
    }

    @Operation(tags={"Security"}, operationId="RefreshLoginLink", summary="Refresh Login Link", description="Refresh and email a new login link to user", responses={@ApiResponse(responseCode="200", description="Login link refreshed and emailed to user"), @ApiResponse(responseCode="401", description="Invalid login link, or user is not authorized to use this application"), @ApiResponse(responseCode="404", description="Could not find smtpService used to send refreshed login link"), @ApiResponse(responseCode="500", description="Error communicating with the authentication server")})
    @POST
    @Path(value="/loginLink/refresh")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response refreshLoginLink(String loginLink) {
        loginLink = loginLink.replace("\"", "");
        LOGGER.info("Received request to refresh login link: " + loginLink);
        if (!this.loginLinkUtils.validateLinkSignature(loginLink)) {
            return ExceptionUtils.toResponse((String)"loginLinkInvalid", (Response.Status)Response.Status.UNAUTHORIZED);
        }
        String linkFragment = null;
        try {
            linkFragment = this.loginLinkUtils.getUrlFragment(loginLink);
        }
        catch (URISyntaxException e) {
            LOGGER.error("Invalid link fragment", (Throwable)e);
        }
        this.loginLinks.remove(linkFragment);
        LoginLinkPayload linkPayload = this.loginLinkUtils.parsePayload(loginLink);
        if (!this.loginLinkUtils.isPayloadValid(linkPayload, true)) {
            return ExceptionUtils.toResponse((String)"loginLinkNoLongerValid", (Response.Status)Response.Status.NOT_FOUND);
        }
        final LegalHold legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(linkPayload.getLegalHoldId());
        try {
            UserAccount userAccount = this.schedulerApplication.getUserServiceResource().getUser(linkPayload.getUserId());
            if (!this.schedulerApplication.getUserServiceResource().getUserAndServiceIsEnabled(userAccount)) {
                throw new IllegalStateException("User is not active");
            }
            SmtpService smtpService = (SmtpService)this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyService(legalHold.getSmtpServerId());
            if (smtpService == null) {
                return ExceptionUtils.toResponse((String)"smtpServiceCannotFind", (Map)new HashMap<String, String>(){
                    {
                        this.put("id", legalHold.getSmtpServerId());
                    }
                }, (Response.Status)Response.Status.NOT_FOUND);
            }
            LoginLinkPayload refreshedPayload = new LoginLinkPayload(linkPayload);
            SmtpEmail smtpEmail = new SmtpEmail(legalHold);
            smtpEmail.setType(EmailType.LOGIN_LINK_REFRESH);
            smtpEmail.setSubject("Automate - " + String.valueOf(EmailType.LOGIN_LINK_REFRESH));
            smtpEmail.setTo(userAccount.getEmail());
            smtpEmail.setSubmittedUserId(legalHold.getLastModifiedByUserId());
            String refreshedLoginLink = this.loginLinkUtils.createLoginLink(legalHold.getSchedulerUrl(), refreshedPayload);
            this.loginLinks.add(this.loginLinkUtils.getUrlFragment(refreshedLoginLink));
            String emailDescription = this.iu.getFormattedString("EmailResource.LoginLinkRefreshed", (Object)userAccount.getEmail());
            smtpEmail.setHtmlFormat(Boolean.valueOf(true));
            smtpEmail.setMessage(smtpEmail.buildTemplateHtmlMessage(null, emailDescription, refreshedLoginLink));
            this.schedulerApplication.getThirdPartyServiceResource().submitEmail(smtpEmail);
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (IllegalStateException | URISyntaxException | InvalidKeyException | NoSuchAlgorithmException e) {
            LOGGER.error("Failed to create and send refreshed login link", (Throwable)e);
            return ExceptionUtils.toResponse((String)"failedToRefreshLoginLink", (Exception)e);
        }
    }

    @Operation(tags={"Security"}, operationId="AuthenticateWithPassword", summary="Authenticate With Password", description="Authenticate user with username and password against the specified scope", responses={@ApiResponse(description="The user session", content={@Content(schema=@Schema(implementation=UserSession.class))}), @ApiResponse(responseCode="400", description="Authentication method not supported"), @ApiResponse(responseCode="401", description="Incorrect username/password, or user is not authorized to use this application"), @ApiResponse(responseCode="500", description="Error communicating with the authentication server")})
    @POST
    @Path(value="/password")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response authenticateWithPassword(@Context HttpServletRequest request, @Context UriInfo uriInfo, PasswordAuthenticationSubmission passwordAuthenticationSubmission) {
        String scope = passwordAuthenticationSubmission.getScope();
        if (scope == null) {
            scope = this.schedulerApplication.getUserServiceResource().getAuthScopeTypes().keySet().iterator().next();
            LOGGER.warn("Attempted to authenticate without a scope, defaulting to " + scope);
        }
        AuthType authType = this.schedulerApplication.getUserServiceResource().getAuthScopeTypes().get(scope);
        String method = "N/A";
        if (authType != null) {
            switch (authType) {
                case UMS: {
                    return this.authenticateUms(uriInfo, request, passwordAuthenticationSubmission);
                }
                case LDAP: {
                    return this.authenticateLdap(uriInfo, request, passwordAuthenticationSubmission);
                }
                case INTERNAL: {
                    return this.authenticateInternal(uriInfo, request, passwordAuthenticationSubmission, ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request));
                }
            }
        }
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), "N/A", Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), passwordAuthenticationSubmission.getUsername(), EventType.Type.AUTH_LOGIN_FAILED, this.iu.getString("UserResource.MethodNotSupported"), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_FAILED, new LoginFailure(method, passwordAuthenticationSubmission.getScope(), passwordAuthenticationSubmission.getUsername(), "N/A", this.iu.getString("UserResource.MethodNotSupported")), passwordAuthenticationSubmission.getUsername());
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("authenticationMethodNotSupported")).build();
    }

    @POST
    @Path(value="/internalCode")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response authenticateWithSystemApiKey(@Context UriInfo uriInfo, SystemApiKeyAuthenticationSubmission systemApiKeyAuthenticationSubmission, @Parameter(hidden=true) @Context HttpServletRequest request) {
        String username = systemApiKeyAuthenticationSubmission.getUsername() + "@" + ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request) + ":" + request.getRemotePort();
        String expectedCode = this.schedulerApplication.getBearerAuthenticator().getTokenFromApiSecret(systemApiKeyAuthenticationSubmission.getNonce());
        if (expectedCode.equals(systemApiKeyAuthenticationSubmission.getCode())) {
            ApiBearerUser user = new ApiBearerUser(username);
            user.setSessionId(UidUtils.getRandom());
            UserSession userSession = this.schedulerApplication.getBearerAuthenticator().registerUser((BearerUser)user);
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), user.getSessionId(), Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), username, EventType.Type.AUTH_LOGIN_SUCCESSFUL, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
            LOGGER.info("User " + user.getName() + ", session " + user.getSessionId() + ", logged in");
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_SUCCESSFUL, new LoginAttempt("SystemAPI", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request), systemApiKeyAuthenticationSubmission.getUsername(), user.getSessionId()), systemApiKeyAuthenticationSubmission.getUsername());
            LOGGER.info("Authenticated API user " + username);
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)userSession).cookie(new NewCookie[]{this.getUiCookieFromUserSession(request, uriInfo, userSession)}).build();
        }
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), "N/A", Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), username, EventType.Type.AUTH_LOGIN_FAILED, this.iu.getString("UserResource.InvalidSystemKey"), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_FAILED, new LoginFailure("SystemAPI", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request), systemApiKeyAuthenticationSubmission.getUsername(), "N/A", this.iu.getString("UserResource.InvalidSystemKey")), "N/A");
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)this.iu.getString("UserResource.InvalidCredentials")).build();
    }

    private Response authenticateUms(@Context UriInfo uriInfo, @Parameter(hidden=true) @Context HttpServletRequest request, PasswordAuthenticationSubmission passwordAuthenticationSubmission) {
        LOGGER.info("Received request to authenticate user " + passwordAuthenticationSubmission.getUsername());
        String sessionId = UidUtils.getRandom();
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), passwordAuthenticationSubmission.getUsername(), EventType.Type.AUTH_LOGIN_ATTEMPTED, this.iu.getString("UserResource.UmsUserPassword"), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_ATTEMPTED, new LoginAttempt("UMS", passwordAuthenticationSubmission.getScope(), passwordAuthenticationSubmission.getUsername(), sessionId), passwordAuthenticationSubmission.getUsername());
        try {
            UmsUtil umsClient = this.schedulerApplication.getUserServiceResource().getUmsClientForScope(passwordAuthenticationSubmission.getScope(), ResourceUtils.getRemoteRequestUrl((HttpServletRequest)request));
            if (umsClient == null) {
                this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), passwordAuthenticationSubmission.getUsername(), EventType.Type.AUTH_LOGIN_FAILED, this.iu.getString("UserResource.MethodNotSupported"), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_FAILED, new LoginFailure("UMS", passwordAuthenticationSubmission.getScope(), passwordAuthenticationSubmission.getUsername(), sessionId, this.iu.getString("UserResource.MethodNotSupported")), passwordAuthenticationSubmission.getUsername());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("authenticationMethodNotSupported")).build();
            }
            BearerUser user = umsClient.authenticateUser(passwordAuthenticationSubmission);
            if (user == null) {
                throw new Exception("User is null");
            }
            if (user.getName() == null) {
                throw new Exception("User name is null");
            }
            try {
                if (BuiltInPrincipalIdentifiers.valueOf((String)user.getName()) != null) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("invalidUsername")).build();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (BuiltInPrincipalIdentifiers.fromString((String)user.getName()) != null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("invalidUsername")).build();
            }
            user.setSessionId(sessionId);
            UserSession userSession = this.schedulerApplication.getBearerAuthenticator().registerUser(user);
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), passwordAuthenticationSubmission.getUsername(), EventType.Type.AUTH_LOGIN_SUCCESSFUL, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
            LOGGER.info("User " + user.getName() + ", session " + user.getSessionId() + ", logged in");
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_SUCCESSFUL, new LoginAttempt("UMS", passwordAuthenticationSubmission.getScope(), passwordAuthenticationSubmission.getUsername(), sessionId), passwordAuthenticationSubmission.getUsername());
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)userSession).cookie(new NewCookie[]{this.getUiCookieFromUserSession(request, uriInfo, userSession)}).build();
        }
        catch (Exception e) {
            LOGGER.error("Cannot authenticate user", (Throwable)e);
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), passwordAuthenticationSubmission.getUsername(), EventType.Type.AUTH_LOGIN_FAILED, e.getLocalizedMessage(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_FAILED, new LoginFailure("UMS", passwordAuthenticationSubmission.getScope(), passwordAuthenticationSubmission.getUsername(), sessionId, e.getLocalizedMessage()), passwordAuthenticationSubmission.getUsername());
            if (e instanceof com.nuix.automate.utils.exceptions.AuthenticationException) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("loginError")).build();
            }
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("errorCommunicatingWithAuthenticationServer")).build();
        }
    }

    private Response authenticateLdap(@Context UriInfo uriInfo, @Parameter(hidden=true) @Context HttpServletRequest request, PasswordAuthenticationSubmission passwordAuthenticationSubmission) {
        LOGGER.info("Received request to authenticate user against LDAP " + passwordAuthenticationSubmission.getUsername());
        String sessionId = UidUtils.getRandom();
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), passwordAuthenticationSubmission.getUsername(), EventType.Type.AUTH_LOGIN_ATTEMPTED, this.iu.getString("UserResource.LdapUserPassword"), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_ATTEMPTED, new LoginAttempt("LDAP", passwordAuthenticationSubmission.getScope(), passwordAuthenticationSubmission.getUsername(), sessionId), passwordAuthenticationSubmission.getUsername());
        LdapClient client = this.schedulerApplication.getUserServiceResource().getLdapClientForScope(passwordAuthenticationSubmission.getScope(), ResourceUtils.getRemoteRequestUrl((HttpServletRequest)request));
        if (client == null) {
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.AUTH_LOGIN_FAILED, this.iu.getString("UserResource.MethodNotSupported"), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_FAILED, new LoginFailure("LDAP", passwordAuthenticationSubmission.getScope(), passwordAuthenticationSubmission.getUsername(), sessionId, this.iu.getString("UserResource.MethodNotSupported")), passwordAuthenticationSubmission.getUsername());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("authenticationMethodNotSupported")).build();
        }
        try {
            LdapBearerUser user = client.authenticateUser(passwordAuthenticationSubmission);
            user.setSessionId(sessionId);
            UserSession userSession = this.schedulerApplication.getBearerAuthenticator().registerUser(user);
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), passwordAuthenticationSubmission.getUsername(), EventType.Type.AUTH_LOGIN_SUCCESSFUL, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
            LOGGER.info("User " + user.getName() + ", session " + user.getSessionId() + ", logged in");
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_SUCCESSFUL, new LoginAttempt("LDAP", passwordAuthenticationSubmission.getScope(), passwordAuthenticationSubmission.getUsername(), sessionId), passwordAuthenticationSubmission.getUsername());
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)userSession).cookie(new NewCookie[]{this.getUiCookieFromUserSession(request, uriInfo, userSession)}).build();
        }
        catch (Exception e) {
            LOGGER.error("Cannot authenticate user", (Throwable)e);
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), passwordAuthenticationSubmission.getUsername(), EventType.Type.AUTH_LOGIN_FAILED, e.getLocalizedMessage(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_FAILED, new LoginFailure("LDAP", passwordAuthenticationSubmission.getScope(), passwordAuthenticationSubmission.getUsername(), sessionId, e.getLocalizedMessage()), passwordAuthenticationSubmission.getUsername());
            if (e instanceof com.nuix.automate.utils.exceptions.AuthenticationException) {
                return ExceptionUtils.toResponse((String)"ldapAuthenticationException", (Response.Status)Response.Status.UNAUTHORIZED);
            }
            if (e instanceof LDAPException) {
                switch (((LDAPException)e).getResultCode().intValue()) {
                    case 49: {
                        return ExceptionUtils.toResponse((String)"ldapAuthenticationException", (Response.Status)Response.Status.UNAUTHORIZED);
                    }
                }
                return ExceptionUtils.toResponse((String)"ldapException", (Response.Status)Response.Status.UNAUTHORIZED);
            }
            return ExceptionUtils.toResponse((String)"ldapException", (Response.Status)Response.Status.UNAUTHORIZED);
        }
    }

    private Response authenticateInternal(@Context UriInfo uriInfo, @Parameter(hidden=true) @Context HttpServletRequest request, PasswordAuthenticationSubmission passwordAuthenticationSubmission, String remoteAddress) {
        LOGGER.info("Received request to authenticate user " + passwordAuthenticationSubmission.getUsername());
        String sessionId = UidUtils.getRandom();
        this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), passwordAuthenticationSubmission.getUsername(), EventType.Type.AUTH_LOGIN_ATTEMPTED, this.iu.getString("UserResource.InternalUserPassword"), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_ATTEMPTED, new LoginAttempt("Internal", passwordAuthenticationSubmission.getScope(), passwordAuthenticationSubmission.getUsername(), sessionId), passwordAuthenticationSubmission.getUsername());
        try {
            if (this.schedulerConfiguration.getInternalCredentials() == null) {
                this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), passwordAuthenticationSubmission.getUsername(), EventType.Type.AUTH_LOGIN_FAILED, this.iu.getString("UserResource.MethodNotSupported"), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_FAILED, new LoginFailure("Internal", passwordAuthenticationSubmission.getScope(), passwordAuthenticationSubmission.getUsername(), sessionId, this.iu.getString("UserResource.MethodNotSupported")), passwordAuthenticationSubmission.getUsername());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("authenticationMethodNotSupported")).build();
            }
            InternalBearerUser user = null;
            if (this.schedulerConfiguration.getInternalCredentials().getRestrictToLocalhost() && !HttpAddressUtils.isAddressLocalhost(remoteAddress)) {
                LOGGER.warn("Denied login for username " + passwordAuthenticationSubmission.getUsername() + " from " + remoteAddress + ". Internal authentication restricted to localhost.");
                throw new com.nuix.automate.utils.exceptions.AuthenticationException(this.iu.getString("InternalUtil.UserRestrictedToLocalhost"));
            }
            for (Credential credential : this.schedulerConfiguration.getInternalCredentials().getCredentials()) {
                if (!credential.getUsername().equalsIgnoreCase(passwordAuthenticationSubmission.getUsername()) || !credential.checkPassword(passwordAuthenticationSubmission.getPassword())) continue;
                user = new InternalBearerUser(credential.getUsername(), credential.getId());
                break;
            }
            if (user == null) {
                throw new com.nuix.automate.utils.exceptions.AuthenticationException(this.iu.getString("InternalUtil.IncorrectUsernamePassword"));
            }
            try {
                if (BuiltInPrincipalIdentifiers.valueOf((String)user.getName()) != null) {
                    return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("invalidUsername")).build();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (BuiltInPrincipalIdentifiers.fromString((String)user.getName()) != null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("invalidUsername")).build();
            }
            user.setSessionId(sessionId);
            UserSession userSession = this.schedulerApplication.getBearerAuthenticator().registerUser(user);
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), passwordAuthenticationSubmission.getUsername(), EventType.Type.AUTH_LOGIN_SUCCESSFUL, "", ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
            LOGGER.info("User " + user.getName() + ", session " + user.getSessionId() + ", logged in");
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_SUCCESSFUL, new LoginAttempt("Internal", passwordAuthenticationSubmission.getScope(), passwordAuthenticationSubmission.getUsername(), sessionId), passwordAuthenticationSubmission.getUsername());
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)userSession).cookie(new NewCookie[]{this.getUiCookieFromUserSession(request, uriInfo, userSession)}).build();
        }
        catch (com.nuix.automate.utils.exceptions.AuthenticationException e) {
            LOGGER.error("Cannot authenticate user", (Throwable)e);
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), passwordAuthenticationSubmission.getUsername(), EventType.Type.AUTH_LOGIN_FAILED, e.getLocalizedMessage(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_FAILED, new LoginFailure("Internal", passwordAuthenticationSubmission.getScope(), passwordAuthenticationSubmission.getUsername(), sessionId, e.getLocalizedMessage()), passwordAuthenticationSubmission.getUsername());
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("loginError")).build();
        }
        catch (Exception e) {
            LOGGER.error("Cannot authenticate user", (Throwable)e);
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), passwordAuthenticationSubmission.getUsername(), EventType.Type.AUTH_LOGIN_FAILED, e.getLocalizedMessage(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_FAILED, new LoginFailure("Internal", passwordAuthenticationSubmission.getScope(), passwordAuthenticationSubmission.getUsername(), sessionId, e.getLocalizedMessage()), passwordAuthenticationSubmission.getUsername());
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("errorCommunicatingWithAuthenticationServer")).build();
        }
    }

    @Operation(tags={"Security"}, operationId="Deauthenticate", summary="Deauthenticate", description="Log user out and destroy the session", responses={@ApiResponse(description="Deauthentication status", content={@Content(schema=@Schema(implementation=ResponseStatus.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @PermitAll
    @DELETE
    @Produces(value={"application/json"})
    public Response deauthenticate(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest req, @Context UriInfo uriInfo) {
        LOGGER.info("Received request to deauthenticate user " + user.getName());
        try {
            TranslationResponseStatus statusModel = new TranslationResponseStatus("userSignedOut");
            URI redirectUri = UriBuilder.fromUri((String)ResourceUtils.getBaseUri((HttpServletRequest)req, (UriInfo)uriInfo).replace("/api/", "/#login")).build(new Object[0]);
            if (user instanceof OidcMicrosoftBearerUser) {
                OidcMicrosoftBearerUser microsoftBearerUser = (OidcMicrosoftBearerUser)user;
                String idTokenHint = (String)microsoftBearerUser.getTokenResponse().get("id_token");
                statusModel.setRedirectUrl(microsoftBearerUser.getClient().getOAuthSignOutUrl(redirectUri.toString(), idTokenHint));
            } else if (user instanceof OidcBearerUser) {
                OidcBearerUser oidcBearerUser = (OidcBearerUser)user;
                OidcUserServiceClient oidcUserServiceClient = this.schedulerApplication.getUserServiceResource().getOidcUserServiceClient(oidcBearerUser.getUserServiceId());
                statusModel.setRedirectUrl(oidcUserServiceClient.getOAuthSignOutUrl(redirectUri.toString(), oidcBearerUser.getIdToken()));
            } else if (user instanceof OidcJwtUser) {
                OidcJwtUser oidcJwtUser = (OidcJwtUser)user;
                OidcUserServiceClient oidcUserServiceClient = this.schedulerApplication.getUserServiceResource().getOidcUserServiceClient(oidcJwtUser.getUserServiceId());
                boolean usingCustomGatewayLogout = false;
                for (ThirdPartyService thirdPartyService : this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServices()) {
                    if (!thirdPartyService.getEnabled().booleanValue() || !(thirdPartyService instanceof InvestigateService)) continue;
                    InvestigateService investigateService = (InvestigateService)thirdPartyService;
                    if (!oidcJwtUser.getUserServiceId().equals(investigateService.getAuthenticationServiceId())) continue;
                    usingCustomGatewayLogout = true;
                    statusModel.setRedirectUrl(investigateService.getUrl().replace("/INVESTIGATE", "") + "/logout");
                }
                if (!usingCustomGatewayLogout) {
                    statusModel.setRedirectUrl(oidcUserServiceClient.getOAuthSignOutUrl(null, null));
                }
            }
            try {
                if (user.getBearerToken() != null) {
                    this.schedulerApplication.getBearerAuthenticator().invalidateUserToken(user.getBearerToken());
                }
            }
            catch (Exception e) {
                LOGGER.error("Cannot invalidate user token", (Throwable)e);
            }
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)statusModel).cookie(new NewCookie[]{this.getClearCookie(uriInfo, OIDC_ELEVATE_COOKIE_NAME, ResourceUtils.getBaseUriPath((HttpServletRequest)req, (UriInfo)uriInfo) + "v1/users/oidcAuth")}).build();
        }
        catch (Exception e) {
            return ExceptionUtils.toResponse((String)"cannotDeauthenticateUser", (Exception)e);
        }
    }

    @Operation(tags={"Security"}, operationId="InitiateAuthenticationWithOidc", summary="Initiate Authentication With OIDC", description="Redirect to OIDC authentication page", responses={@ApiResponse(description="Redirect to OIDC"), @ApiResponse(responseCode="400", description="Authentication method not supported")})
    @Path(value="/oidcAuth")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response redirectToOidcAuthUrl(@Context HttpServletRequest request, @Context UriInfo uriInfo, @FormParam(value="scope") String scope, @FormParam(value="token") String uiToken, @FormParam(value="mode") OidcLoginMode loginMode, @FormParam(value="thirdPartyServiceId") String thirdPartyServiceId) {
        try {
            String oidcUserServiceId;
            BearerUser user2;
            String sessionId = UidUtils.getRandom();
            if (uiToken != null && (uiToken.length() == 0 || uiToken.equals("undefined"))) {
                uiToken = null;
            }
            if (uiToken != null) {
                String tokenCookieValue = this.getCookieValue(request, OIDC_ELEVATE_COOKIE_NAME);
                String expectedCookieValue = null;
                try {
                    expectedCookieValue = SecurityUtils.computeHmacHex((String)uiToken, (String)this.getHmacKey());
                }
                catch (InvalidKeyException | NoSuchAlgorithmException e) {
                    LOGGER.error("Cannot generate expectedCookieValue", (Throwable)e);
                }
                boolean performCookieValidation = true;
                try {
                    user2 = this.schedulerApplication.getAuthenticationUtil().getUserFromHeader(request);
                    if (user2 != null && user2 instanceof OidcJwtUser) {
                        performCookieValidation = false;
                    }
                }
                catch (Exception user2) {
                    // empty catch block
                }
                if (performCookieValidation && (expectedCookieValue == null || !expectedCookieValue.equals(tokenCookieValue))) {
                    throw new IllegalStateException("Invalid oidcElevate cookie");
                }
            }
            this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.AUTH_LOGIN_ATTEMPTED, this.iu.getString("UserResource.OpenIdConnect"), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_ATTEMPTED, new LoginAttempt("OIDC", scope, "N/A", sessionId), "N/A");
            HashMap<String, String> properties = null;
            if (loginMode != null) {
                Optional<BearerUser> userOptional = this.schedulerApplication.getBearerAuthenticator().authenticateWithUiToken(uiToken, request);
                if (userOptional.isEmpty()) {
                    LOGGER.error("Could not find user from provided token");
                    return ExceptionUtils.buildForbiddenResponse();
                }
                user2 = userOptional.get();
                try {
                    ThirdPartyService thirdPartyService = this.schedulerApplication.getThirdPartyServiceResource().getResponseThirdPartyService(thirdPartyServiceId);
                    this.schedulerApplication.getThirdPartyServiceResource().verifyUserCredentialAddPermissions(user2, thirdPartyService);
                    UserService oidcAuthenticationService = this.schedulerApplication.getUserServiceResource().getUserService(thirdPartyService.getAuthenticationServiceId());
                    if (oidcAuthenticationService == null) {
                        LOGGER.error("OIDC auth service is null");
                        return this.redirectToOidcError(request, uriInfo, new OidcErrorInfo("thirdPartyServiceInvalidOidc"), null);
                    }
                    if (!Boolean.TRUE.equals(oidcAuthenticationService.getAvailableForUrl(ResourceUtils.getRemoteRequestUrl((HttpServletRequest)request)))) {
                        LOGGER.error("OIDC auth service " + oidcAuthenticationService.getName() + " is not available for URL: " + ResourceUtils.getRemoteRequestUrl((HttpServletRequest)request));
                        return this.redirectToOidcError(request, uriInfo, new OidcErrorInfo("thirdPartyServiceInvalidOidc"), null);
                    }
                    if (!Boolean.TRUE.equals(oidcAuthenticationService.getEnabled())) {
                        LOGGER.error("OIDC auth service is not enabled: " + oidcAuthenticationService.getName());
                        return this.redirectToOidcError(request, uriInfo, new OidcErrorInfo("thirdPartyServiceOidcDisabled"), null);
                    }
                    if (thirdPartyService.getAuthenticationMethod() != ThirdPartyAuthenticationMethod.OIDC_AUTHORIZATION_CODE || !(oidcAuthenticationService instanceof OidcUserService) || thirdPartyService.getOidcAuthMethodType() != oidcAuthenticationService.getAuthMethodType()) {
                        LOGGER.error("OIDC auth service is not of a valid type: " + oidcAuthenticationService.getName());
                        return this.redirectToOidcError(request, uriInfo, new OidcErrorInfo("thirdPartyServiceInvalidOidcUserSignIn"), null);
                    }
                    oidcUserServiceId = oidcAuthenticationService.getId();
                    scope = oidcAuthenticationService.getName();
                    properties = new HashMap<String, String>();
                    properties.put("userToken", uiToken);
                    properties.put("thirdPartyServiceId", thirdPartyServiceId);
                }
                catch (ResponseException e) {
                    return e.getResponse();
                }
            } else {
                oidcUserServiceId = this.schedulerApplication.getUserServiceResource().getEnabledOidcUserServiceIdForDisplayName(scope, ResourceUtils.getRemoteRequestUrl((HttpServletRequest)request));
            }
            if (oidcUserServiceId == null) {
                this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.AUTH_LOGIN_FAILED, this.iu.getString("UserResource.MethodNotSupported"), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_FAILED, new LoginFailure("OIDC", scope, "N/A", sessionId, this.iu.getString("UserResource.MethodNotSupported")), "N/A");
                return this.redirectToOidcError(request, uriInfo, new OidcErrorInfo("authenticationMethodNotSupported"), null);
            }
            try {
                String stateFingerprint;
                String state = SecurityUtils.getSecureRandomSecret();
                OidcUserServiceClient oidcUserServiceClient = this.schedulerApplication.getUserServiceResource().getOidcUserServiceClient(oidcUserServiceId);
                String oAuthAuthorizeUrl = oidcUserServiceClient.getOAuthAuthorizeUrl(ResourceUtils.getBaseUri((HttpServletRequest)request, (UriInfo)uriInfo) + "v1/users/oidcResponse", state, sessionId, loginMode);
                if (properties != null) {
                    OidcPartialUser oidcPartialUser = oidcUserServiceClient.getPartialUser(state);
                    oidcPartialUser.setProperties(properties);
                }
                try {
                    stateFingerprint = SecurityUtils.computeHmacHex((String)state, (String)this.getHmacKey());
                }
                catch (InvalidKeyException e) {
                    throw new IllegalStateException("Cannot compute stateFingerprint", e);
                }
                NewCookie oidcInitCookie = this.getNewCookie(uriInfo, OIDC_INIT_COOKIE_NAME, stateFingerprint, ResourceUtils.getBaseUriPath((HttpServletRequest)request, (UriInfo)uriInfo) + "v1/users/oidcResponse", this.schedulerConfiguration.getOidcAuthInitTimeout());
                URI uri = UriBuilder.fromUri((String)oAuthAuthorizeUrl).build(new Object[0]);
                return Response.status((Response.Status)Response.Status.FOUND).location(uri).cookie(new NewCookie[]{oidcInitCookie}).build();
            }
            catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
                this.schedulerApplication.getAuditLogDao().addAuditEvent(new AuditEvent(UidUtils.getRandom(), sessionId, Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()), "N/A", EventType.Type.AUTH_LOGIN_FAILED, e.getLocalizedMessage(), ResourceUtils.getRemoteIpAddresses((HttpServletRequest)request)));
                this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.AUTH_LOGIN_FAILED, new LoginFailure("OIDC", scope, "N/A", sessionId, e.getLocalizedMessage()), "N/A");
                return this.redirectToOidcError(request, uriInfo, new OidcErrorInfo("cannotPrepareOAuthUrl", e), null);
            }
        }
        catch (Exception e) {
            return this.redirectToOidcError(request, uriInfo, new OidcErrorInfo(e), null);
        }
    }

    private String getHmacKey() {
        return this.schedulerApplication.getRunNonce();
    }

    @Path(value="/oidcResponse")
    @GET
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processGenericOAuthResponse(@Context HttpServletRequest req, @Context UriInfo uriInfo) {
        URI redirectUri = UriBuilder.fromUri((String)ResourceUtils.getBaseUri((HttpServletRequest)req, (UriInfo)uriInfo).replace("/api/", "")).build(new Object[0]);
        return Response.status((Response.Status)Response.Status.FOUND).location(redirectUri).build();
    }

    @Path(value="/oidcResponse")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response processGenericOAuthResponse(@Context HttpServletRequest req, @Context UriInfo uriInfo, @FormParam(value="access_token") String access_token, @FormParam(value="state") String state, @FormParam(value="code") String code, @FormParam(value="session_state") String session_state, @FormParam(value="error") String error, @FormParam(value="error_description") String error_description) throws AuthenticationException, IOException {
        String oidcInitToken = "";
        try {
            String stateFingerprint;
            try {
                stateFingerprint = SecurityUtils.computeHmacHex((String)state, (String)this.getHmacKey());
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new IllegalStateException("Cannot compute stateFingerprint", e);
            }
            oidcInitToken = this.getCookieValue(req, OIDC_INIT_COOKIE_NAME);
            if (oidcInitToken == null) {
                LOGGER.error("Missing oidcInit cookie");
                throw new IllegalStateException("The authentication did not complete within the allotted time");
            }
            if (!stateFingerprint.equals(oidcInitToken)) {
                LOGGER.error("Invalid oidcInit cookie value");
                throw new IllegalStateException("The authentication did not complete within the allotted time");
            }
            for (UserService userService : this.schedulerApplication.getUserServiceResource().getUserServices()) {
                OidcUserServiceClient oidcUserServiceClient = this.schedulerApplication.getUserServiceResource().getOidcUserServiceClient(userService.getId());
                if (!Boolean.TRUE.equals(userService.getEnabledForUserTriggerdAuth()) || !Boolean.TRUE.equals(userService.getAvailableForUrl(ResourceUtils.getRemoteRequestUrl((HttpServletRequest)req))) || oidcUserServiceClient == null || !oidcUserServiceClient.isStateTracked(state)) continue;
                oidcUserServiceClient.processOidcOAuthResponse(req, uriInfo, access_token, state, code, session_state, error, error_description);
                return this.getUserSessionFromAuthState(req, uriInfo, oidcUserServiceClient, state);
            }
            NewCookie clearOidcInitCookie = this.getClearCookie(uriInfo, OIDC_INIT_COOKIE_NAME, ResourceUtils.getBaseUriPath((HttpServletRequest)req, (UriInfo)uriInfo) + "v1/users/oidcResponse");
            return this.redirectToOidcError(req, uriInfo, new OidcErrorInfo("authenticationMethodNotSupported"), clearOidcInitCookie);
        }
        catch (Exception e) {
            return this.redirectToOidcError(req, uriInfo, new OidcErrorInfo(e), null);
        }
    }

    @Path(value="/oidcError")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getOidcError(@Context HttpServletRequest req, @Context UriInfo uriInfo) {
        String oidcErrorToken = this.getCookieValue(req, OIDC_ERROR_COOKIE_NAME);
        if (oidcErrorToken == null || oidcErrorToken.trim().length() == 0) {
            URI redirectUri = UriBuilder.fromUri((String)ResourceUtils.getBaseUri((HttpServletRequest)req, (UriInfo)uriInfo).replace("/api/", "/#login")).build(new Object[0]);
            LOGGER.error("unable to parse OIDC error, OIDC error cookie does not exist");
            return Response.seeOther((URI)redirectUri).build();
        }
        OidcErrorInfo oidcErrorInfo = this.oidcErrorMap.remove(oidcErrorToken);
        TranslationResponseStatus translationResponseStatus = new TranslationResponseStatus();
        translationResponseStatus.setKey("cannotAuthenticateUser");
        if (oidcErrorInfo != null) {
            HashMap<String, String> values = oidcErrorInfo.getValues();
            if (values == null) {
                values = new HashMap<String, String>();
            }
            if (oidcErrorInfo.getTranslationKey() != null) {
                translationResponseStatus.setKey(oidcErrorInfo.getTranslationKey());
            }
            if (oidcErrorInfo.getOidcException() != null) {
                String message = ExceptionUtils.getExceptionPrintableMessage((Throwable)oidcErrorInfo.getOidcException());
                values.put("exception", message);
            }
            translationResponseStatus.setValues(values);
        }
        NewCookie clearOidcErrorCookie = this.getClearCookie(uriInfo, OIDC_ERROR_COOKIE_NAME, ResourceUtils.getBaseUriPath((HttpServletRequest)req, (UriInfo)uriInfo) + "v1/users/oidcError");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)translationResponseStatus).cookie(new NewCookie[]{clearOidcErrorCookie}).build();
    }

    public Response redirectToOidcError(HttpServletRequest req, UriInfo uriInfo, OidcErrorInfo errorInfo, NewCookie clearCookie) {
        String errorId = UUID.randomUUID().toString();
        this.oidcErrorMap.put(errorId, errorInfo);
        if (errorInfo != null) {
            if (errorInfo.getOidcException() != null) {
                LOGGER.error("Unexpected error occurred during OIDC authentication", (Throwable)errorInfo.getOidcException());
            } else if (errorInfo.getTranslationKey() != null) {
                LOGGER.error("Unexpected error occurred during OIDC authentication, error key: " + errorInfo.getTranslationKey());
            } else {
                LOGGER.error("Unexpected error occurred during OIDC authentication");
            }
        }
        NewCookie oidcErrorCookie = this.getNewCookie(uriInfo, OIDC_ERROR_COOKIE_NAME, errorId, ResourceUtils.getBaseUriPath((HttpServletRequest)req, (UriInfo)uriInfo) + "v1/users/oidcError", this.schedulerConfiguration.getOidcAuthInitTimeout());
        URI redirectUri = UriBuilder.fromUri((String)ResourceUtils.getBaseUri((HttpServletRequest)req, (UriInfo)uriInfo).replace("/api/", "/#oidcError")).build(new Object[0]);
        if (clearCookie != null) {
            return Response.seeOther((URI)redirectUri).cookie(new NewCookie[]{oidcErrorCookie, clearCookie}).build();
        }
        return Response.seeOther((URI)redirectUri).cookie(new NewCookie[]{oidcErrorCookie}).build();
    }

    public Response getUserSessionFromAuthState(HttpServletRequest req, UriInfo uriInfo, OidcUserServiceClient oidcUserServiceClient, String state) throws AuthenticationException, IOException {
        OidcPartialUser oidcPartialUser = oidcUserServiceClient.getPartialUser(state);
        Exception e = oidcUserServiceClient.removeException(state);
        if (e != null) {
            oidcUserServiceClient.removeUser(state);
            final String message = this.getOidcErrorMessage(e, oidcPartialUser, req);
            return this.redirectToOidcError(req, uriInfo, new OidcErrorInfo(OIDC_ERROR_COOKIE_NAME, (Map)new HashMap<String, String>(){
                {
                    this.put("message", message);
                }
            }), null);
        }
        BearerUser user = oidcUserServiceClient.removeUser(state);
        OidcLoginMode loginMode = oidcPartialUser.getLoginMode();
        if (loginMode != null) {
            LOGGER.info("Login mode: " + String.valueOf(loginMode));
            Map<String, Object> properties = oidcPartialUser.getProperties();
            String token = (String)properties.get("userToken");
            Optional<BearerUser> userOptional = this.schedulerApplication.getBearerAuthenticator().authenticateWithUiToken(token, req);
            if (userOptional.isEmpty()) {
                return ExceptionUtils.buildForbiddenResponse();
            }
            BearerUser schedulerUser = userOptional.get();
            String thirdPartyServiceId = (String)properties.get("thirdPartyServiceId");
            try {
                ThirdPartyService thirdPartyService = this.schedulerApplication.getThirdPartyServiceResource().getResponseThirdPartyService(thirdPartyServiceId);
                if (loginMode == OidcLoginMode.E_DISCOVERY_DOWNLOADER) {
                    if (thirdPartyService instanceof PurviewService) {
                        this.schedulerApplication.getThirdPartyServiceResource().savePurviewDownloadUserCredential(thirdPartyService, user, schedulerUser);
                    }
                } else {
                    this.schedulerApplication.getThirdPartyServiceResource().createAndSaveOidcThirdPartyUserCredential(thirdPartyService, user, schedulerUser);
                }
                URI redirectUri = UriBuilder.fromUri((String)ResourceUtils.getBaseUri((HttpServletRequest)req, (UriInfo)uriInfo).replace("/api/", "/#oidcResponse")).build(new Object[0]);
                return Response.seeOther((URI)redirectUri).build();
            }
            catch (ResponseException ex) {
                return ex.getResponse();
            }
        }
        OidcUserService oidcUserService = oidcUserServiceClient.getOidcUserService();
        for (ThirdPartyService thirdPartyService : this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServicesUsingOidcAuthenticationService((UserService)oidcUserService)) {
            if (thirdPartyService.getAuthenticationScope() != ThirdPartyAuthenticationScope.USER) continue;
            try {
                this.schedulerApplication.getThirdPartyServiceResource().verifyUserCredentialAddPermissions(user, thirdPartyService);
                this.schedulerApplication.getThirdPartyServiceResource().createAndSaveOidcThirdPartyUserCredential(thirdPartyService, user, user);
            }
            catch (ResponseException ex) {
                LOGGER.error("Error saving third-party service user credential", (Throwable)ex);
            }
        }
        final UserSession userSession = this.schedulerApplication.getBearerAuthenticator().registerUser(user);
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                UserResource.this.schedulerApplication.getBearerAuthenticator().invalidateUserToken(userSession.getToken());
            }
        }, (long)this.schedulerConfiguration.getOidcAuthCompletionTimeout() * 1000L);
        NewCookie oidcCompleteCookie = this.getNewCookie(uriInfo, OIDC_COMPLETE_COOKIE_NAME, userSession.getToken(), ResourceUtils.getBaseUriPath((HttpServletRequest)req, (UriInfo)uriInfo) + "v1/users/oidcComplete", this.schedulerConfiguration.getOidcAuthCompletionTimeout());
        NewCookie clearOidcInitCookie = this.getClearCookie(uriInfo, OIDC_INIT_COOKIE_NAME, ResourceUtils.getBaseUriPath((HttpServletRequest)req, (UriInfo)uriInfo) + "v1/users/oidcResponse");
        URI redirectUri = UriBuilder.fromUri((String)ResourceUtils.getBaseUri((HttpServletRequest)req, (UriInfo)uriInfo).replace("/api/", "/#oidcResponse")).build(new Object[0]);
        return Response.seeOther((URI)redirectUri).cookie(new NewCookie[]{oidcCompleteCookie}).cookie(new NewCookie[]{clearOidcInitCookie}).build();
    }

    private String getOidcErrorMessage(Exception e, OidcPartialUser oidcPartialUser, HttpServletRequest req) throws AuthenticationException {
        String lowerCaseMessage;
        Map<String, Object> properties = oidcPartialUser.getProperties();
        OidcLoginMode loginMode = oidcPartialUser.getLoginMode();
        String message = e.getLocalizedMessage();
        if (e.getCause() != null) {
            message = e.getCause().getLocalizedMessage();
            ObjectMapper mapper = new ObjectMapper();
            try {
                ErrorModel errorModel = (ErrorModel)mapper.readValue(message, (TypeReference)new TypeReference<ErrorModel>(){});
                if (errorModel.getErrorDescription() != null) {
                    message = errorModel.getErrorDescription();
                }
            }
            catch (Throwable errorModel) {
                // empty catch block
            }
        }
        if (loginMode == OidcLoginMode.E_DISCOVERY_DOWNLOADER && (lowerCaseMessage = message.toLowerCase()).contains("b26e684c-5068-4120-a679-64a5d2c909d9") && (e instanceof com.nuix.automate.utils.exceptions.AuthenticationException || lowerCaseMessage.contains("access_denied") || lowerCaseMessage.contains("invalid resource"))) {
            String token = (String)properties.get("userToken");
            String thirdPartyServiceId = (String)properties.get("thirdPartyServiceId");
            Optional<BearerUser> userOptional = this.schedulerApplication.getBearerAuthenticator().authenticateWithUiToken(token, req);
            ThirdPartyService thirdPartyService = this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyService(thirdPartyServiceId);
            if (userOptional.isPresent() && thirdPartyService != null) {
                try {
                    ThirdPartyServiceSession<?, ?> session = this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyServiceSession(thirdPartyServiceId, userOptional.get().getId());
                    session.getLogger().addWarning(this.iu.getFormattedString("PurviewServiceSession.Error.CouldNotSignIntoDownloadUserMissingDownloadPermission", (Object)message));
                }
                catch (IOException ex) {
                    LOGGER.error("Client cannot be retrieved", (Throwable)e);
                }
            }
        }
        return message;
    }

    private NewCookie getNewCookie(UriInfo uriInfo, String cookieName, String cookieValue, String path, int timeout) {
        boolean cookieSecure = true;
        if (uriInfo.getBaseUri().getScheme().toLowerCase(Locale.ROOT).equals("http")) {
            cookieSecure = false;
        }
        NewCookie newCookie = new NewCookie(cookieName, cookieValue, path, null, null, timeout, cookieSecure, true);
        return newCookie;
    }

    private NewCookie getClearCookie(UriInfo uriInfo, String cookieName, String path) {
        boolean cookieSecure = true;
        if (uriInfo.getBaseUri().getScheme().toLowerCase(Locale.ROOT).equals("http")) {
            cookieSecure = false;
        }
        NewCookie clearCookie = new NewCookie(cookieName, null, path, null, null, 0, cookieSecure, true);
        return clearCookie;
    }

    private String getCookieValue(HttpServletRequest req, String cookieName) {
        if (req.getCookies() != null) {
            for (Cookie cookie : req.getCookies()) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    @Path(value="/oidcComplete")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response completeOidcAuth(@Context HttpServletRequest req, @Context UriInfo uriInfo) {
        try {
            String token = this.getCookieValue(req, OIDC_COMPLETE_COOKIE_NAME);
            if (token == null) {
                LOGGER.error("Request missing cookie oidcComplete");
                throw new IllegalStateException("The authentication did not complete within the allotted time");
            }
            UserSession userSession = this.schedulerApplication.getBearerAuthenticator().refreshUserToken(token);
            this.schedulerApplication.getBearerAuthenticator().invalidateUserToken(token);
            NewCookie clearOidcCompleteCookie = this.getClearCookie(uriInfo, OIDC_COMPLETE_COOKIE_NAME, ResourceUtils.getBaseUriPath((HttpServletRequest)req, (UriInfo)uriInfo) + "v1/users/oidcComplete");
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)userSession).cookie(new NewCookie[]{this.getUiCookieFromUserSession(req, uriInfo, userSession)}).cookie(new NewCookie[]{clearOidcCompleteCookie}).build();
        }
        catch (Exception e) {
            return this.redirectToOidcError(req, uriInfo, new OidcErrorInfo(e), null);
        }
    }

    private NewCookie getUiCookieFromUserSession(HttpServletRequest request, UriInfo uriInfo, UserSession userSession) {
        int timeout = this.schedulerConfiguration.getDisableAuthTokenExpiration() ? -1 : (int)this.schedulerConfiguration.getAuthTokenTtl();
        try {
            String cookieValue = SecurityUtils.computeHmacHex((String)userSession.getUiToken(), (String)this.getHmacKey());
            NewCookie uiCookie = this.getNewCookie(uriInfo, OIDC_ELEVATE_COOKIE_NAME, cookieValue, ResourceUtils.getBaseUriPath((HttpServletRequest)request, (UriInfo)uriInfo) + "v1/users/oidcAuth", timeout);
            return uiCookie;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Cannot compute uiTokenFingerprint", e);
        }
    }

    @Operation(tags={"Security"}, operationId="RefreshUserToken", summary="Refresh user token", description="Refresh user token", responses={@ApiResponse(responseCode="200", description="User token refreshed"), @ApiResponse(responseCode="500", description="Error communicating with the authentication server")})
    @POST
    @Path(value="/refresh")
    @Produces(value={"application/json"})
    public Response refreshUserToken(@Context UriInfo uriInfo, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(hidden=true) @Auth BearerUser user) {
        String authHeader = request.getHeader("Authorization");
        String token = authHeader.substring("Bearer".length()).trim();
        BearerUserToken bearerUserToken = this.schedulerApplication.getBearerAuthenticator().getBearerUserToken(token);
        Long invalidatedDate = bearerUserToken.getInvalidatedDate();
        long currentTime = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        if (invalidatedDate != null && currentTime - invalidatedDate > this.schedulerApplication.getConfiguration().getExpiredAuthTokenGracePeriod()) {
            LOGGER.error("Cannot refresh invalidated token");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("cannotRefreshInvalidatedToken")).build();
        }
        try {
            if (user instanceof OidcJwtUser) {
                return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).build();
            }
            UserSession userSession = this.schedulerApplication.getBearerAuthenticator().refreshUserToken(bearerUserToken.getToken());
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)userSession).cookie(new NewCookie[]{this.getUiCookieFromUserSession(request, uriInfo, userSession)}).build();
        }
        catch (Exception e) {
            LOGGER.error("Failed to refresh user session", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("couldNotRefreshToken")).build();
        }
    }

    @Operation(tags={"Security"}, operationId="GetUserApplicationFeatures", summary="Get User Application Features", description="Returns the list of application features that the current user has access to", responses={@ApiResponse(description="The list of application features available to the current user", content={@Content(array=@ArraySchema(schema=@Schema(implementation=ApplicationFeatures.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @PermitAll
    @GET
    @Path(value="/features")
    @Produces(value={"application/json"})
    public Response getFeatures(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        Set<ApplicationFeatures> result = this.getUserFeatures(user);
        String lastHash = ResponseCache.getInstance().hashObject(result);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(result).build();
        }
    }

    @Operation(tags={"Security"}, operationId="GetCurrentUser", summary="Get Current User", description="Returns the details of the currently logged in user", responses={@ApiResponse(description="The profile of the current user", content={@Content(schema=@Schema(implementation=AuthenticatedUser.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @PermitAll
    @GET
    @Path(value="/me")
    @Produces(value={"application/json"})
    public Response getMe(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        AuthenticatedUser authenticatedUser = new AuthenticatedUser(user);
        String lastHash = ResponseCache.getInstance().hashObject((Object)authenticatedUser);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)authenticatedUser).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SecurityRequirement(name="Bearer_Token")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/utilization/{activityType}")
    @POST
    public Response trackUserUtilization(@Auth BearerUser user, @PathParam(value="activityType") ActivityType activityType, String targetId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received User Utilization: user: " + user.getName() + ", session: " + user.getSessionId() + ", activityType: " + String.valueOf(activityType) + ", targetId: " + targetId);
        }
        long currentMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        String userId = User.getIdFromName((String)user.getName(), (String)this.schedulerApplication.getSettingsResource().getDiagnosticKey().getSecret());
        LicenceSession licenseSession = this.schedulerApplication.getAutomateLicenceResource().getLicenceSession();
        if (licenseSession.getLicenceInfo() == null) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)"NOP").build();
        }
        ActivityDetails dummyActivity = new ActivityDetails();
        dummyActivity.setUserId(userId);
        dummyActivity.setStartEpoch(currentMillis);
        dummyActivity.setActivityType(activityType);
        if (targetId != null && targetId.length() > 0) {
            targetId = targetId.replace("\"", "");
        }
        if (activityType == ActivityType.JOB_MONITORING && targetId != null && targetId.length() > 0) {
            JobDetailsModel job = this.schedulerApplication.getJobResource().getJobDetailsModel(targetId);
            if (job != null) {
                dummyActivity.setActivityKey(targetId);
                dummyActivity.setMatterId(job.getSettings().getMatterId());
            } else {
                LOGGER.warn("Cannot map utilization to matter: user: " + user.getName() + ", session: " + user.getSessionId() + ", activityType: " + String.valueOf(activityType) + ", targetId: " + targetId);
            }
        }
        licenseSession.handleActivityEvent(userId, dummyActivity.getMatterId(), dummyActivity.getActivityKey(), activityType);
        ActivityDetails finishedActivity = null;
        Map<String, ActivityDetails> map = this.userActivities;
        synchronized (map) {
            ActivityDetails activity = this.userActivities.get(userId);
            if (activity != null) {
                if (activity.isExpired(currentMillis)) {
                    finishedActivity = activity;
                    this.userActivities.remove(userId);
                    activity = null;
                } else {
                    activity.setLastEpoch(currentMillis);
                    if (!activity.getActivityType().equals((Object)activityType) || activity.getMatterId() != null && !activity.getMatterId().equals(dummyActivity.getMatterId()) || dummyActivity.getMatterId() != null && !dummyActivity.getMatterId().equals(activity.getMatterId()) || activity.getActivityKey() != null && !activity.getActivityKey().equals(dummyActivity.getActivityKey()) || dummyActivity.getActivityKey() != null && !dummyActivity.getActivityKey().equals(activity.getActivityKey())) {
                        finishedActivity = activity;
                        this.userActivities.remove(userId);
                        activity = null;
                    }
                }
            }
            if (activity == null) {
                activity = dummyActivity;
                activity.setLastEpoch(currentMillis);
                this.userActivities.put(activity.getUserId(), activity);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("START " + String.valueOf(activity));
                }
            }
        }
        if (finishedActivity != null) {
            this.trackFinishedActivity(finishedActivity);
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)"OK").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUtilizationUserLogOut(String username) {
        ActivityDetails activity;
        String userId = User.getIdFromName((String)username, (String)this.schedulerApplication.getSettingsResource().getDiagnosticKey().getSecret());
        long currentMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        LicenceSession licenseSession = this.schedulerApplication.getAutomateLicenceResource().getLicenceSession();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("handling logout: " + username);
        }
        boolean previousActivityExpired = true;
        Map<String, ActivityDetails> map = this.userActivities;
        synchronized (map) {
            activity = this.userActivities.remove(userId);
            if (activity != null && !activity.isExpired(currentMillis)) {
                activity.setLastEpoch(currentMillis);
                previousActivityExpired = false;
            }
        }
        if (activity != null) {
            if (!previousActivityExpired && licenseSession != null) {
                licenseSession.handleActivityEvent(activity.getUserId(), activity.getMatterId(), activity.getActivityKey(), activity.getActivityType());
            }
            this.trackFinishedActivity(activity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUtilizationShutdown() {
        long currentMillis = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        Map<String, ActivityDetails> map = this.userActivities;
        synchronized (map) {
            for (ActivityDetails activity : this.userActivities.values()) {
                if (!activity.isExpired(currentMillis)) {
                    activity.setLastEpoch(currentMillis);
                }
                this.trackFinishedActivity(activity);
            }
        }
        LicenceSession licenseSession = this.schedulerApplication.getAutomateLicenceResource().getLicenceSession();
        if (licenseSession != null) {
            licenseSession.finishAllActivities(null);
        }
    }

    public int trackFinishedActivity(ActivityDetails activityDetails, boolean onlyNewActivities) {
        int count = 0;
        try {
            LicenceInfo licenseInfo = this.schedulerApplication.getLicenceUtils().assertLicenceInfo();
            List<Activity> activities = this.getActivitiesFromActivityDetails(activityDetails);
            for (Activity activity : activities) {
                activity.setLicenseId(licenseInfo.getId());
                try {
                    this.schedulerApplication.getUtilizationDaoV2().addActivity(activity);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("first save of activity: " + String.valueOf(activity));
                    }
                    ++count;
                }
                catch (StatementException e) {
                    if (onlyNewActivities) continue;
                    this.schedulerApplication.getUtilizationDaoV2().addActivityDuration(activity);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("increased activity time: " + String.valueOf(activity));
                    }
                    ++count;
                }
            }
        }
        catch (LicenseException e) {
            LOGGER.warn("Skipping activities because of license error", (Throwable)e);
        }
        return count;
    }

    public int trackFinishedActivity(ActivityDetails activityDetails) {
        return this.trackFinishedActivity(activityDetails, false);
    }

    public List<Activity> getActivitiesFromActivityDetails(ActivityDetails activityDetails) {
        long nextHour;
        long startMillis = activityDetails.getStartEpoch();
        long endMillis = activityDetails.getLastEpoch();
        String userId = activityDetails.getUserId();
        String matterId = activityDetails.getMatterId();
        String activityKey = activityDetails.getActivityKey();
        ActivityType activityType = activityDetails.getActivityType();
        ArrayList<Activity> activities = new ArrayList<Activity>();
        do {
            long startHour;
            long duration = endMillis > (nextHour = (startHour = startMillis / 3600000L * 3600000L) + 3600000L) ? (nextHour - startMillis) / 1000L : (endMillis - startMillis) / 1000L;
            Activity activity = new Activity();
            activity.setUserId(userId);
            activity.setMatterId(matterId);
            activity.setActivityKey(activityKey);
            activity.setActivityType(activityType);
            activity.setActivityPeriodEpoch(startHour);
            activity.setActivityDuration(duration);
            activities.add(activity);
        } while ((startMillis = nextHour) < endMillis);
        return activities;
    }

    public Set<ApplicationFeatures> getUserFeatures(BearerUser user) {
        TreeSet<ApplicationFeatures> features = new TreeSet<ApplicationFeatures>();
        if (user.getIdentifiers().contains(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInPrincipalIdentifiers.API_USER))) {
            features.add(ApplicationFeatures.API_ACCESS);
        }
        HashSet<Object> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.AUTOMATE_LICENCE));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        Set<Permission> permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
        if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
            features.add(ApplicationFeatures.VIEW_AUTOMATE_LICENCE);
        }
        if (permissions.contains(Permission.MODIFY)) {
            features.add(ApplicationFeatures.MODIFY_AUTOMATE_LICENCE);
        }
        resourceIdentifiers = new HashSet();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.NETWORK_CONFIGURATION));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
        if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
            features.add(ApplicationFeatures.VIEW_NETWORK_CONFIGURATION);
        }
        if (permissions.contains(Permission.MODIFY)) {
            features.add(ApplicationFeatures.MODIFY_NETWORK_CONFIGURATION);
        }
        if (this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.ECC_COLLECTIONS)) {
            features.add(ApplicationFeatures.ECC);
        }
        if (this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.GEN_AI)) {
            features.add(ApplicationFeatures.GEN_AI);
        }
        if (this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.PURVIEW_COLLECTIONS)) {
            features.add(ApplicationFeatures.PURVIEW);
        }
        if (this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.GOOGLE_COLLECTIONS)) {
            features.add(ApplicationFeatures.VAULT);
        }
        if (this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.SCHEDULER_UPLOAD)) {
            features.add(ApplicationFeatures.SCHEDULER_UPLOAD);
        }
        if (this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.REMOTE_ENGINES)) {
            features.add(ApplicationFeatures.REMOTE_ENGINES);
        }
        if (this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.CLOUD_RESOURCE_POOLS)) {
            features.add(ApplicationFeatures.CLOUD_RESOURCE_POOLS);
        }
        if (this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.NEO_MANAGEMENT)) {
            features.add(ApplicationFeatures.OPERATION_PROGRESS);
        }
        try {
            LegalHold result;
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.SECURITY));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_SECURITY);
            }
            if (permissions.contains(Permission.MODIFY)) {
                features.add(ApplicationFeatures.ADD_SECURITY);
            }
            if (this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.NEO_MANAGEMENT)) {
                resourceIdentifiers = new HashSet();
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.USER_DATA_DIR));
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
                permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
                if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                    features.add(ApplicationFeatures.VIEW_USER_DATA_DIR);
                }
                if (permissions.contains(Permission.MODIFY)) {
                    features.add(ApplicationFeatures.MODIFY_USER_DATA_DIR);
                }
                features.add(ApplicationFeatures.VIEW_DERBY_CONTROL_SERVICE);
            }
            if (this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.DISCOVER_REVIEW)) {
                features.add(ApplicationFeatures.VIEW_DISCOVER_SERVICE);
            }
            if (this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.INVESTIGATE)) {
                features.add(ApplicationFeatures.VIEW_INVESTIGATE_SERVICE);
            }
            if (this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.SEMANTIC)) {
                features.add(ApplicationFeatures.VIEW_SEMANTIC_SERVICE);
            }
            if (this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.API_ADVANCED)) {
                resourceIdentifiers = new HashSet();
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.API_KEYS));
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_API_KEYS));
                permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
                if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                    features.add(ApplicationFeatures.VIEW_API_KEYS);
                }
                if (permissions.contains(Permission.MODIFY)) {
                    features.add(ApplicationFeatures.ADD_API_KEYS);
                }
                resourceIdentifiers = new HashSet();
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.WEBHOOKS));
                permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
                if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                    features.add(ApplicationFeatures.VIEW_WEBHOOKS);
                }
                if (permissions.contains(Permission.MODIFY)) {
                    features.add(ApplicationFeatures.ADD_WEBHOOKS);
                }
                features.add(ApplicationFeatures.API_ADVANCED);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.USER_SERVICES));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_USER_SERVICES);
            }
            if (permissions.contains(Permission.MODIFY)) {
                features.add(ApplicationFeatures.MODIFY_USER_SERVICES);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_DATA_REPOSITORIES));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_DATA_REPOSITORIES);
            }
            if (permissions.contains(Permission.MODIFY)) {
                features.add(ApplicationFeatures.ADD_DATA_REPOSITORY);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_NOTICE_TEMPLATES));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_NOTICE_TEMPLATES);
            }
            if (permissions.contains(Permission.MODIFY)) {
                features.add(ApplicationFeatures.ADD_NOTICE_TEMPLATE);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.LEGAL_HOLDS));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_LEGAL_HOLDS);
                features.add(ApplicationFeatures.VIEW_LEGAL_HOLD_NOTICES);
            }
            if (permissions.contains(Permission.CREATE)) {
                features.add(ApplicationFeatures.ADD_LEGAL_HOLD);
            }
            for (LegalHold legalHold : this.schedulerApplication.getLegalHoldResource().getLegalHolds()) {
                result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold);
                if (result.canViewSensitive()) {
                    features.add(ApplicationFeatures.VIEW_LEGAL_HOLD_NOTICES);
                }
                if (!result.canView()) continue;
                features.add(ApplicationFeatures.VIEW_LEGAL_HOLDS);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_FILE_LIBRARIES));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_FILE_LIBRARIES);
            }
            if (permissions.contains(Permission.MODIFY)) {
                features.add(ApplicationFeatures.ADD_FILE_LIBRARY);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_EXECUTION_PROFILES));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_EXECUTION_PROFILES);
            }
            if (permissions.contains(Permission.MODIFY)) {
                features.add(ApplicationFeatures.ADD_EXECUTION_PROFILE);
            }
            features.add(ApplicationFeatures.VIEW_USER_SETTINGS);
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_RESOURCES);
                features.add(ApplicationFeatures.VIEW_NUIX_LICENCE_SOURCES);
                features.add(ApplicationFeatures.VIEW_EXECUTION_PROFILES);
                features.add(ApplicationFeatures.VIEW_NOTIFICATION_RULES);
                features.add(ApplicationFeatures.VIEW_RESOURCE_POOLS);
                features.add(ApplicationFeatures.VIEW_DATA_REPOSITORIES);
                features.add(ApplicationFeatures.VIEW_SMTP_SERVERS);
                features.add(ApplicationFeatures.VIEW_AUTOMATE_LICENCE);
                features.add(ApplicationFeatures.VIEW_NETWORK_CONFIGURATION);
                features.add(ApplicationFeatures.VIEW_USER_SERVICES);
                features.add(ApplicationFeatures.VIEW_NOTICE_TEMPLATES);
                features.add(ApplicationFeatures.VIEW_THIRD_PARTY_SERVICES);
                features.add(ApplicationFeatures.VIEW_FILE_LIBRARIES);
            }
            if (permissions.contains(Permission.MODIFY)) {
                features.add(ApplicationFeatures.ADD_RESOURCE);
                features.add(ApplicationFeatures.ADD_NUIX_LICENCE_SOURCE);
                features.add(ApplicationFeatures.ADD_EXECUTION_PROFILE);
                features.add(ApplicationFeatures.ADD_NOTIFICATION_RULE);
                features.add(ApplicationFeatures.ADD_RESOURCE_POOLS);
                features.add(ApplicationFeatures.ADD_DATA_REPOSITORY);
                features.add(ApplicationFeatures.ADD_SMTP_SERVER);
                features.add(ApplicationFeatures.MODIFY_AUTOMATE_LICENCE);
                features.add(ApplicationFeatures.MODIFY_NETWORK_CONFIGURATION);
                features.add(ApplicationFeatures.MODIFY_USER_SERVICES);
                features.add(ApplicationFeatures.ADD_NOTICE_TEMPLATE);
                features.add(ApplicationFeatures.ADD_THIRD_PARTY_SERVICE);
                features.add(ApplicationFeatures.ADD_FILE_LIBRARY);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_NOTIFICATION_RULES));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_NOTIFICATION_RULES);
            }
            if (permissions.contains(Permission.MODIFY)) {
                features.add(ApplicationFeatures.ADD_NOTIFICATION_RULE);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_EXECUTION_PROFILES));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_EXECUTION_PROFILES);
            }
            if (permissions.contains(Permission.MODIFY)) {
                features.add(ApplicationFeatures.ADD_EXECUTION_PROFILE);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.SCHEDULES));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_SCHEDULES);
            }
            if (permissions.contains(Permission.SUBMIT_JOB)) {
                features.add(ApplicationFeatures.ADD_SCHEDULE);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_NUIX_LICENSE_SOURCES));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_NUIX_LICENCE_SOURCES);
            }
            if (permissions.contains(Permission.MODIFY)) {
                features.add(ApplicationFeatures.ADD_NUIX_LICENCE_SOURCE);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.COLLECTIONS));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_COLLECTIONS);
            }
            if (permissions.contains(Permission.CREATE)) {
                features.add(ApplicationFeatures.ADD_COLLECTION);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_COLLECTION_TEMPLATES));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_COLLECTION_TEMPLATES);
            }
            if (permissions.contains(Permission.MODIFY)) {
                features.add(ApplicationFeatures.ADD_COLLECTION_TEMPLATES);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_THIRD_PARTY_SERVICES));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_THIRD_PARTY_SERVICES);
            }
            if (permissions.contains(Permission.MODIFY)) {
                features.add(ApplicationFeatures.ADD_THIRD_PARTY_SERVICE);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_RESOURCE_POOLS));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_RESOURCE_POOLS);
            }
            if (permissions.contains(Permission.MODIFY)) {
                features.add(ApplicationFeatures.ADD_RESOURCE_POOLS);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.USER_SETTINGS));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.MODIFY)) {
                features.add(ApplicationFeatures.MODIFY_DEFAULT_USER_SETTINGS);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.MODIFY)) {
                features.add(ApplicationFeatures.ADD_CLIENT);
            }
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_CLIENTS);
                features.add(ApplicationFeatures.VIEW_JOBS);
            }
            if (permissions.contains(Permission.SUBMIT_JOB)) {
                features.add(ApplicationFeatures.ADD_JOB);
            }
            if (permissions.contains(Permission.STAGE_JOB)) {
                features.add(ApplicationFeatures.STAGE_JOB);
            }
            if (permissions.contains(Permission.VIEW_SENSITIVE)) {
                features.add(ApplicationFeatures.VIEW_SENSITIVE_JOB);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.MODIFY) || permissions.contains(Permission.CREATE)) {
                features.add(ApplicationFeatures.ADD_CLIENT_POOL);
            }
            if (permissions.contains(Permission.SUBMIT_JOB)) {
                features.add(ApplicationFeatures.ADD_JOB);
            }
            if (permissions.contains(Permission.STAGE_JOB)) {
                features.add(ApplicationFeatures.STAGE_JOB);
            }
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_CLIENT_POOLS);
                features.add(ApplicationFeatures.VIEW_CLIENTS);
                features.add(ApplicationFeatures.VIEW_JOBS);
            }
            if (permissions.contains(Permission.VIEW_NON_RECURSIVE)) {
                features.add(ApplicationFeatures.VIEW_CLIENT_POOLS);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_LIBRARIES));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.MODIFY)) {
                features.add(ApplicationFeatures.ADD_LIBRARY);
            }
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_LIBRARIES);
            }
            if (permissions.contains(Permission.VIEW_SENSITIVE)) {
                features.add(ApplicationFeatures.VIEW_SENSITIVE_WORKFLOW);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_FILE_LIBRARIES));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.VIEW) || permissions.contains(Permission.VIEW_LIMITED)) {
                features.add(ApplicationFeatures.VIEW_FILE_LIBRARIES);
            }
            if (permissions.contains(Permission.MODIFY)) {
                features.add(ApplicationFeatures.ADD_FILE_LIBRARY);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.UNASSIGNED_CLIENT));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.SUBMIT_JOB)) {
                features.add(ApplicationFeatures.ADD_JOB_UNASSIGNED_CLIENT);
            }
            for (ThirdPartyService thirdPartyService : SchedulerApplication.getInstance().getThirdPartyServiceResource().getThirdPartyServices()) {
                if (thirdPartyService.getViewFeature() == null || thirdPartyService.getAddFeature() == null) continue;
                result = this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, thirdPartyService);
                if (result.getUserPermissions().contains(Permission.SUBMIT_JOB) || result.getUserPermissions().contains(Permission.STAGE_JOB)) {
                    features.add(thirdPartyService.getAddFeature());
                }
                if (!result.getUserPermissions().contains(Permission.VIEW)) continue;
                features.add(thirdPartyService.getViewFeature());
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (permissions.contains(Permission.DOWNLOAD_LOGS)) {
                features.add(ApplicationFeatures.DOWNLOAD_SYSTEM_LOGS);
            }
            features.add(ApplicationFeatures.CENTRALIZED_LOGGING);
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
            Set<Permission> clientPermissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.UTILIZATION));
            permissions = this.schedulerApplication.getSecurityPolicyUtil().getPermissions(user.getIdentifiers(), resourceIdentifiers);
            if (clientPermissions.contains(Permission.VIEW) && permissions.contains(Permission.VIEW)) {
                features.add(ApplicationFeatures.DOWNLOAD_UTILIZATION_FULL);
                features.add(ApplicationFeatures.DOWNLOAD_UTILIZATION_ANONYMOUS);
            }
            if (clientPermissions.contains(Permission.MODIFY) && permissions.contains(Permission.MODIFY)) {
                features.add(ApplicationFeatures.UPLOAD_UTILIZATION);
            }
            resourceIdentifiers = new HashSet();
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            if (this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
                features.add(ApplicationFeatures.DOWNLOAD_UTILIZATION_ANONYMOUS);
            }
            for (SecurityPolicy securityPolicy : this.schedulerApplication.getSecurityPolicyUtil().getPolicies()) {
                if (!securityPolicy.getEnabled().booleanValue()) continue;
                boolean identityInScope = false;
                for (Identifier principalIdentity : user.getIdentifiers()) {
                    if (!securityPolicy.getPrincipals().contains(principalIdentity)) continue;
                    identityInScope = true;
                    break;
                }
                if (!identityInScope) continue;
                for (Identifier scopeIdentifier : securityPolicy.getScope()) {
                    if (!scopeIdentifier.getIdentifierType().equals((Object)IdentifierType.CLIENT_ID) && !scopeIdentifier.getIdentifierType().equals((Object)IdentifierType.CLIENT_ID_MATTERS) && !scopeIdentifier.getIdentifierType().equals((Object)IdentifierType.MATTER_ID) && !scopeIdentifier.getIdentifierType().equals((Object)IdentifierType.CLIENT_POOL_ID)) continue;
                    if (securityPolicy.getPermissions().contains(Permission.VIEW) || securityPolicy.getPermissions().contains(Permission.VIEW_LIMITED)) {
                        features.add(ApplicationFeatures.VIEW_CLIENTS);
                        features.add(ApplicationFeatures.VIEW_JOBS);
                    }
                    if (securityPolicy.getPermissions().contains(Permission.SUBMIT_JOB)) {
                        features.add(ApplicationFeatures.ADD_JOB);
                    }
                    if (!permissions.contains(Permission.STAGE_JOB)) continue;
                    features.add(ApplicationFeatures.STAGE_JOB);
                }
                for (Identifier scopeIdentifier : securityPolicy.getScope()) {
                    if (!scopeIdentifier.getIdentifierType().equals((Object)IdentifierType.LIBRARY_ID) && !scopeIdentifier.getIdentifierType().equals((Object)IdentifierType.WORKFLOW_ID) || !securityPolicy.getPermissions().contains(Permission.VIEW) && !securityPolicy.getPermissions().contains(Permission.VIEW_LIMITED)) continue;
                    features.add(ApplicationFeatures.VIEW_LIBRARIES);
                }
                for (Identifier scopeIdentifier : securityPolicy.getScope()) {
                    if (!scopeIdentifier.getIdentifierType().equals((Object)IdentifierType.DATA_REPOSITORY_ID) || !securityPolicy.getPermissions().contains(Permission.VIEW) && !securityPolicy.getPermissions().contains(Permission.VIEW_LIMITED)) continue;
                    features.add(ApplicationFeatures.VIEW_DATA_REPOSITORIES);
                }
                for (Identifier scopeIdentifier : securityPolicy.getScope()) {
                    if (!scopeIdentifier.getIdentifierType().equals((Object)IdentifierType.NOTICE_TEMPLATE_ID) || !securityPolicy.getPermissions().contains(Permission.VIEW) && !securityPolicy.getPermissions().contains(Permission.VIEW_LIMITED)) continue;
                    features.add(ApplicationFeatures.VIEW_NOTICE_TEMPLATES);
                }
                for (Identifier scopeIdentifier : securityPolicy.getScope()) {
                    if (!scopeIdentifier.getIdentifierType().equals((Object)IdentifierType.THIRD_PARTY_SERVICE_ID) || !securityPolicy.getPermissions().contains(Permission.VIEW) && !securityPolicy.getPermissions().contains(Permission.VIEW_LIMITED)) continue;
                    features.add(ApplicationFeatures.VIEW_THIRD_PARTY_SERVICES);
                }
                for (Identifier scopeIdentifier : securityPolicy.getScope()) {
                    if (!scopeIdentifier.getIdentifierType().equals((Object)IdentifierType.RESOURCE_POOL_ID) || !securityPolicy.getPermissions().contains(Permission.VIEW) && !securityPolicy.getPermissions().contains(Permission.VIEW_LIMITED)) continue;
                    features.add(ApplicationFeatures.VIEW_RESOURCE_POOLS);
                }
                for (Identifier scopeIdentifier : securityPolicy.getScope()) {
                    if (!scopeIdentifier.getIdentifierType().equals((Object)IdentifierType.EXECUTION_PROFILE_ID) || !securityPolicy.getPermissions().contains(Permission.VIEW) && !securityPolicy.getPermissions().contains(Permission.VIEW_LIMITED)) continue;
                    features.add(ApplicationFeatures.VIEW_EXECUTION_PROFILES);
                }
                for (Identifier scopeIdentifier : securityPolicy.getScope()) {
                    if (!scopeIdentifier.getIdentifierType().equals((Object)IdentifierType.USER_SERVICE_ID) || !securityPolicy.getPermissions().contains(Permission.VIEW) && !securityPolicy.getPermissions().contains(Permission.VIEW_LIMITED)) continue;
                    features.add(ApplicationFeatures.VIEW_USER_SERVICES);
                }
                for (Identifier scopeIdentifier : securityPolicy.getScope()) {
                    if (!scopeIdentifier.getIdentifierType().equals((Object)IdentifierType.NOTIFICATION_RULE_ID) || !securityPolicy.getPermissions().contains(Permission.VIEW) && !securityPolicy.getPermissions().contains(Permission.VIEW_LIMITED)) continue;
                    features.add(ApplicationFeatures.VIEW_NOTIFICATION_RULES);
                }
                for (Identifier scopeIdentifier : securityPolicy.getScope()) {
                    if (!scopeIdentifier.getIdentifierType().equals((Object)IdentifierType.CLIENT_POOL_ID) || !securityPolicy.getPermissions().contains(Permission.VIEW) && !securityPolicy.getPermissions().contains(Permission.VIEW_LIMITED)) continue;
                    features.add(ApplicationFeatures.VIEW_CLIENT_POOLS);
                }
            }
            if (!this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.PURVIEW_COLLECTIONS)) {
                features.remove(ApplicationFeatures.VIEW_PURVIEW_JOBS);
                features.remove(ApplicationFeatures.ADD_PURVIEW_JOB);
            }
            if (!this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.GOOGLE_COLLECTIONS)) {
                features.remove(ApplicationFeatures.VIEW_VAULT_JOBS);
                features.remove(ApplicationFeatures.ADD_VAULT_JOB);
            }
            if (!this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.THIRD_PARTY_SERVICES)) {
                features.remove(ApplicationFeatures.VIEW_THIRD_PARTY_SERVICES);
            }
            if (!this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.LEGAL_HOLD)) {
                features.remove(ApplicationFeatures.ADD_LEGAL_HOLD);
                features.remove(ApplicationFeatures.VIEW_LEGAL_HOLDS);
                features.remove(ApplicationFeatures.VIEW_LEGAL_HOLD_NOTICES);
            }
            if (this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.UTILIZATION_UPLOAD)) {
                features.clear();
                features.add(ApplicationFeatures.UPLOAD_UTILIZATION_RLS);
                features.add(ApplicationFeatures.ADD_SECURITY);
                features.add(ApplicationFeatures.VIEW_SECURITY);
                features.add(ApplicationFeatures.VIEW_AUTOMATE_LICENCE);
                features.add(ApplicationFeatures.MODIFY_AUTOMATE_LICENCE);
            }
        }
        catch (Exception e) {
            LOGGER.error("Scheduler is not licensed", (Throwable)e);
        }
        return features;
    }

    @Operation(tags={"Dummy"}, operationId="DummyUserEvent", summary="Dummy User Events", description="Dummy endpoints containing user events sample responses", responses={@ApiResponse(responseCode="501", description="Sample Event Response", content={@Content(schema=@Schema(implementation=LoginAttempt.class))}), @ApiResponse(responseCode="501", description="Sample Event Response", content={@Content(schema=@Schema(implementation=LoginFailure.class))}), @ApiResponse(responseCode="501", description="Sample Event Response", content={@Content(schema=@Schema(implementation=Logout.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/dummy")
    public Response dummy() {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private static final class OidcRedirect {
        private String redirectUrl;
        private String oidcScope;

        public OidcRedirect(String oidcScope) {
            this.oidcScope = oidcScope;
        }

        public String getRedirectUrl() {
            return this.redirectUrl;
        }

        public void setRedirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
        }

        public String getOidcScope() {
            return this.oidcScope;
        }

        public void setOidcScope(String oidcScope) {
            this.oidcScope = oidcScope;
        }
    }
}

