/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.amazonaws.regions.Regions;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.utils.AzureEnvironmentUtils;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.Ids;
import com.nuix.automate.utils.api.response.NameId;
import com.nuix.automate.utils.api.response.Names;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.client.Client;
import com.nuix.automate.utils.models.api.client.ClientPool;
import com.nuix.automate.utils.models.api.client.Matter;
import com.nuix.automate.utils.models.api.dataset.DataRepository;
import com.nuix.automate.utils.models.api.dataset.Dataset;
import com.nuix.automate.utils.models.api.filelibrary.FileLibrary;
import com.nuix.automate.utils.models.api.job.Job;
import com.nuix.automate.utils.models.api.legalhold.LegalHold;
import com.nuix.automate.utils.models.api.notice.NoticeTemplate;
import com.nuix.automate.utils.models.api.notificationrule.NotificationRule;
import com.nuix.automate.utils.models.api.service.ServiceInfo;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.workflowlibrary.Workflow;
import com.nuix.automate.utils.models.api.workflowlibrary.WorkflowLibrary;
import com.nuix.automate.utils.models.internal.executionprofile.ExecutionProfileModel;
import com.nuix.automate.utils.models.internal.nuixlicensesource.NuixLicenseSourceModel;
import com.nuix.automate.utils.models.internal.resourcepool.ResourcePoolModel;
import com.nuix.automate.utils.models.internal.user.UserService;
import com.nuix.automate.utils.responsecache.CacheException;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.dropwizard.auth.Auth;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;

@Path(value="/v1/scheduler/util")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class UtilResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UtilResource.class);
    private final SchedulerApplication schedulerApplication;

    public UtilResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
    }

    public String resolveId(String id, IdentifierType identifierType) {
        switch (identifierType) {
            case CLIENT_ID: 
            case CLIENT_ID_MATTERS: {
                Client client = this.schedulerApplication.getClientResource().getClient(id);
                if (client != null) {
                    return client.getName();
                }
                return null;
            }
            case MATTER_ID: {
                Matter matter = this.schedulerApplication.getClientResource().getMatter(id);
                if (matter != null) {
                    return matter.getName();
                }
                return null;
            }
            case LIBRARY_ID: {
                WorkflowLibrary workflowLibrary = this.schedulerApplication.getLibraryResource().getWorkflowLibrary(id);
                if (workflowLibrary != null) {
                    return workflowLibrary.getName();
                }
                return null;
            }
            case WORKFLOW_ID: {
                Workflow workflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(id);
                if (workflow != null) {
                    return workflow.getName();
                }
                return null;
            }
            case CLIENT_POOL_ID: {
                ClientPool clientPool = this.schedulerApplication.getClientPoolResource().getClientPool(id);
                if (clientPool != null) {
                    return clientPool.getName();
                }
                return null;
            }
            case RESOURCE_POOL_ID: {
                ResourcePoolModel resourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(id);
                if (resourcePool != null) {
                    return resourcePool.getName();
                }
                return null;
            }
            case DATA_REPOSITORY_ID: {
                DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(id);
                if (dataRepository != null) {
                    return dataRepository.getName();
                }
                return null;
            }
            case THIRD_PARTY_SERVICE_ID: {
                ThirdPartyService thirdPartyService = this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyService(id);
                if (thirdPartyService != null) {
                    return thirdPartyService.getName();
                }
                return null;
            }
            case EXECUTION_PROFILE_ID: {
                ExecutionProfileModel executionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(id);
                if (executionProfile != null) {
                    return executionProfile.getName();
                }
                return null;
            }
            case NOTIFICATION_RULE_ID: {
                NotificationRule notificationRule = this.schedulerApplication.getNotificationRuleResource().getNotificationRule(id);
                if (notificationRule != null) {
                    return notificationRule.getName();
                }
                return null;
            }
            case NUIX_LICENCE_SOURCE_ID: {
                NuixLicenseSourceModel nuixLicenceSource = this.schedulerApplication.getNuixLicenceSourceResource().getNuixLicenceSource(id);
                if (nuixLicenceSource != null) {
                    return nuixLicenceSource.getName();
                }
                return null;
            }
            case NOTICE_TEMPLATE_ID: {
                NoticeTemplate noticeTemplate = this.schedulerApplication.getNoticeTemplateResource().getNoticeTemplate(id);
                if (noticeTemplate != null) {
                    return noticeTemplate.getName();
                }
                return null;
            }
            case LEGAL_HOLD_ID: {
                LegalHold legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(id);
                if (legalHold != null) {
                    return legalHold.getName();
                }
                return null;
            }
        }
        if (identifierType.name().endsWith("_ID")) {
            LOGGER.error("Cannot resolve identifier type " + String.valueOf(identifierType));
        }
        return null;
    }

    @Operation(tags={"Utils"}, operationId="ResolveIds", summary="Resolve IDs", description="Resolves object IDs such as clients, jobs, resource pools, etc., to names", responses={@ApiResponse(description="Resolved IDs", content={@Content(schema=@Schema(ref="#/components/schemas/ResolvedIds"))})})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Path(value="/resolve")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resolveIds(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The list of IDs to resolve", example="[\"11111111-1111-1111-1111-111111111111\", \"22222222-2222-2222-2222-222222222222\"]") List<String> ids) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String id : ids) {
            Matter matter = this.schedulerApplication.getClientResource().getMatter(id);
            if (matter != null) {
                if (!this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter).getUserPermissions().contains(Permission.VIEW)) continue;
                result.put(id, matter.getName());
                continue;
            }
            Client client = this.schedulerApplication.getClientResource().getClient(id);
            if (client != null) {
                if (!this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, client).getUserPermissions().contains(Permission.VIEW)) continue;
                result.put(id, client.getName());
                continue;
            }
            ClientPool clientPool = this.schedulerApplication.getClientPoolResource().getClientPool(id);
            if (clientPool != null) {
                if (!this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, clientPool).getUserPermissions().contains(Permission.VIEW)) continue;
                result.put(id, clientPool.getName());
                continue;
            }
            WorkflowLibrary workflowLibrary = this.schedulerApplication.getLibraryResource().getWorkflowLibrary(id);
            if (workflowLibrary != null) {
                if (!this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflowLibrary).getUserPermissions().contains(Permission.VIEW)) continue;
                result.put(id, workflowLibrary.getName());
                continue;
            }
            Workflow workflow = this.schedulerApplication.getLibraryResource().getLibraryWorkflow(id);
            if (workflow != null) {
                if (!this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflow).getUserPermissions().contains(Permission.VIEW)) continue;
                result.put(id, workflow.getName());
                continue;
            }
            ResourcePoolModel resourcePool = this.schedulerApplication.getResourcePoolResource().getResourcePool(id);
            if (resourcePool != null) {
                if (!this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, resourcePool).getUserPermissions().contains(Permission.VIEW)) continue;
                result.put(id, resourcePool.getName());
                continue;
            }
            ExecutionProfileModel executionProfile = this.schedulerApplication.getExecutionProfileResource().getExecutionProfile(id);
            if (executionProfile != null) {
                if (!this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, executionProfile).getUserPermissions().contains(Permission.VIEW)) continue;
                result.put(id, executionProfile.getName());
                continue;
            }
            NuixLicenseSourceModel nuixLicenceSource = this.schedulerApplication.getNuixLicenceSourceResource().getNuixLicenceSource(id);
            if (nuixLicenceSource != null) {
                if (!this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, nuixLicenceSource).getUserPermissions().contains(Permission.VIEW)) continue;
                result.put(id, nuixLicenceSource.getName());
                continue;
            }
            NotificationRule notificationRule = this.schedulerApplication.getNotificationRuleResource().getNotificationRule(id);
            if (notificationRule != null) {
                if (!this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, notificationRule).getUserPermissions().contains(Permission.VIEW)) continue;
                result.put(id, notificationRule.getName());
                continue;
            }
            DataRepository dataRepository = this.schedulerApplication.getDataRepositoryResource().getDataRepository(id);
            if (dataRepository != null) {
                if (!this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, dataRepository).getUserPermissions().contains(Permission.VIEW)) continue;
                result.put(id, dataRepository.getName());
                continue;
            }
            UserService userService = this.schedulerApplication.getUserServiceResource().getUserService(id);
            if (userService != null) {
                if (!this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, userService).getUserPermissions().contains(Permission.VIEW)) continue;
                result.put(id, userService.getName());
                continue;
            }
            Dataset dataset = this.schedulerApplication.getDatasetResource().getDataset(id);
            if (dataset != null) {
                matter = this.schedulerApplication.getClientResource().getMatter(dataset.getMatterId());
                if (matter == null || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter).getUserPermissions().contains(Permission.VIEW)) continue;
                result.put(id, dataset.getName());
                continue;
            }
            NoticeTemplate noticeTemplate = this.schedulerApplication.getNoticeTemplateResource().getNoticeTemplate(id);
            if (noticeTemplate != null) {
                if (!this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, noticeTemplate).getUserPermissions().contains(Permission.VIEW)) continue;
                result.put(id, noticeTemplate.getName());
                continue;
            }
            LegalHold legalHold = this.schedulerApplication.getLegalHoldResource().getLegalHold(id);
            if (legalHold != null) {
                if (!this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold).canView()) continue;
                result.put(id, legalHold.getName());
                continue;
            }
            FileLibrary fileLibrary = this.schedulerApplication.getFileLibraryResource().getFileLibrary(id);
            if (fileLibrary != null) {
                if (!this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, fileLibrary).getUserPermissions().contains(Permission.VIEW)) continue;
                result.put(id, fileLibrary.getName());
                continue;
            }
            ThirdPartyService thirdPartyService = this.schedulerApplication.getThirdPartyServiceResource().getThirdPartyService(id);
            if (thirdPartyService == null || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, thirdPartyService).getUserPermissions().contains(Permission.VIEW)) continue;
            result.put(id, thirdPartyService.getName());
        }
        String lastHash = ResponseCache.getInstance().hashObject(result);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(result).build();
        }
    }

    @Operation(tags={"Utils"}, operationId="GetISO3Languages", summary="Get ISO3 languages", description="Get full information of all of the ISO3 languages", responses={@ApiResponse(description="The ISO3 languages", content={@Content(array=@ArraySchema(schema=@Schema(implementation=String.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/iso3Languages")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getIso3Languages(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        HashSet<String> iso3Languages = new HashSet<String>();
        for (Locale locale : Locale.getAvailableLocales()) {
            String iso3 = locale.getISO3Language();
            if (iso3 == null || iso3.trim().isEmpty()) continue;
            iso3Languages.add(iso3);
        }
        String lastHash = ResponseCache.getInstance().hashObject(iso3Languages);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(iso3Languages).build();
        }
    }

    @Operation(tags={"Utils"}, operationId="GetAwsRegions", summary="Get AWS regions", description="Get full information of all of the valid AWS regions", responses={@ApiResponse(description="The AWS regions", content={@Content(array=@ArraySchema(schema=@Schema(implementation=String.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/awsRegions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAwsRegions(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        Regions[] result = Regions.values();
        String lastHash = ResponseCache.getInstance().hashObject((Object)result);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)result).build();
        }
    }

    @Operation(tags={"Utils"}, operationId="GetAzureLocations", summary="Get Azure Locations", description="Get full information of all of the valid Azure locations", responses={@ApiResponse(description="The Azure locations", content={@Content(array=@ArraySchema(schema=@Schema(implementation=String.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/azureLocations")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAzureRegions(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(Arrays.asList(this.schedulerApplication.getConfiguration().getAzureLocations()));
        String lastHash = ResponseCache.getInstance().hashObject(result);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(result).build();
        }
    }

    @Operation(tags={"Utils"}, operationId="GetAzureEnvironments", summary="Get Azure Environments", description="Get full information of all of the valid Azure environments", responses={@ApiResponse(description="The Azure environments", content={@Content(array=@ArraySchema(schema=@Schema(implementation=String.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/azureEnvironments")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAzureEnvironments(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(Arrays.asList(AzureEnvironmentUtils.getAzureEnvironments()));
        String lastHash = ResponseCache.getInstance().hashObject(result);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(result).build();
        }
    }

    @Operation(tags={"Utils"}, operationId="GetAzureVmSizes", summary="Get Azure VM Sizes", description="Get full information of all of the valid Azure VM sizes", responses={@ApiResponse(description="The Azure VM size", content={@Content(array=@ArraySchema(schema=@Schema(implementation=String.class)))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/azureVmSizes")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getAzureVmSizes(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request) {
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(Arrays.asList(this.schedulerApplication.getConfiguration().getAzureVmSizes()));
        String lastHash = ResponseCache.getInstance().hashObject(result);
        try {
            return ResponseCache.getInstance().getResponse(lastHash, request);
        }
        catch (CacheException cacheException) {
            return Response.status((Response.Status)Response.Status.OK).header("ETag", (Object)lastHash).type(MediaType.APPLICATION_JSON_TYPE).entity(result).build();
        }
    }

    @Operation(tags={"Utils"}, operationId="ResolveJobByName", summary="Resolve Job by Name", description="Resolve job name to ID. If the exact spelling of the job name is not known, use the ListJobs method", responses={@ApiResponse(description="The ID", content={@Content(schema=@Schema(implementation=NameId.class))}), @ApiResponse(responseCode="404", description="The specified object could not be found or user does not have permissions to view the object"), @ApiResponse(responseCode="400", description="Multiple objects with the same name were found")})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/resolve/job/{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resolveProcessingJobId(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The name of the object") @PathParam(value="name") String name) {
        boolean getFirst = false;
        ArrayList<String> results = new ArrayList<String>();
        List<Job> jobs = this.schedulerApplication.getJobResource().getJobsVisibleBy(user);
        for (Job job : jobs) {
            if (!job.getName().trim().equals(name.trim())) continue;
            results.add(job.getId());
            if (!getFirst) continue;
            break;
        }
        if (results.size() == 0) {
            return ExceptionUtils.toResponse((String)"cannotFindObject", new HashMap(), (Response.Status)Response.Status.NOT_FOUND);
        }
        if (results.size() == 1 || getFirst) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new NameId(name, (String)results.get(0))).build();
        }
        return ExceptionUtils.toResponse((String)"multipleObjectsWithSameName", new HashMap(), (Response.Status)Response.Status.BAD_REQUEST);
    }

    @Operation(tags={"Utils"}, operationId="ResolveClientByName", summary="Resolve Client by Name", description="Resolve client name to ID. If the exact spelling of the client name is not known, use the ListClients method", responses={@ApiResponse(description="The ID", content={@Content(schema=@Schema(implementation=NameId.class))}), @ApiResponse(responseCode="404", description="The specified object could not be found or user does not have permissions to view the object")})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/resolve/client/{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resolveClientId(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The name of the object") @PathParam(value="name") String name) {
        boolean getFirst = true;
        ArrayList<String> results = new ArrayList<String>();
        for (Client client : this.schedulerApplication.getClientResource().getClients()) {
            if (!client.getName().trim().equals(name.trim()) || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, client).getUserPermissions().contains(Permission.VIEW)) continue;
            results.add(client.getId());
            if (!getFirst) continue;
            break;
        }
        if (results.size() == 0) {
            return ExceptionUtils.toResponse((String)"cannotFindObject", new HashMap(), (Response.Status)Response.Status.NOT_FOUND);
        }
        if (results.size() == 1 || getFirst) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new NameId(name, (String)results.get(0))).build();
        }
        return ExceptionUtils.toResponse((String)"multipleObjectsWithSameName", new HashMap(), (Response.Status)Response.Status.BAD_REQUEST);
    }

    @Operation(tags={"Utils"}, operationId="ResolveMatterByNameAndClientId", summary="Resolve Matter by Name and Client ID", description="Resolve matter name for the client with the specified ID. If the exact spelling of the matter name is not known, use the ListClients method", responses={@ApiResponse(description="The ID", content={@Content(schema=@Schema(implementation=NameId.class))}), @ApiResponse(responseCode="404", description="The specified object could not be found or user does not have permissions to view the object")})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/resolve/client/{clientId}/matter/{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resolveClientMatterId(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The ID of the client") @PathParam(value="clientId") String clientId, @Parameter(description="The name of the object") @PathParam(value="name") String name) {
        boolean getFirst = true;
        ArrayList<String> results = new ArrayList<String>();
        for (Matter matter : this.schedulerApplication.getClientResource().getClientMatters(clientId)) {
            if (!matter.getName().trim().equals(name.trim()) || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter).getUserPermissions().contains(Permission.VIEW)) continue;
            results.add(matter.getId());
            if (!getFirst) continue;
            break;
        }
        if (results.size() == 0) {
            return ExceptionUtils.toResponse((String)"cannotFindObject", new HashMap(), (Response.Status)Response.Status.NOT_FOUND);
        }
        if (results.size() == 1 || getFirst) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new NameId(name, (String)results.get(0))).build();
        }
        return ExceptionUtils.toResponse((String)"multipleObjectsWithSameName", new HashMap(), (Response.Status)Response.Status.BAD_REQUEST);
    }

    @Operation(tags={"Utils"}, operationId="ResolveMatterByName", summary="Resolve Matter by Name", description="Resolve matter name to ID. If the exact spelling of the client name is not known, use the ListMatters method", responses={@ApiResponse(description="The ID", content={@Content(schema=@Schema(implementation=NameId.class))}), @ApiResponse(responseCode="404", description="The specified object could not be found or user does not have permissions to view the object"), @ApiResponse(responseCode="400", description="Multiple objects with the same name were found")})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/resolve/matter/{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resolveMatterId(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The name of the object") @PathParam(value="name") String name) {
        boolean getFirst = false;
        ArrayList<String> results = new ArrayList<String>();
        block0: for (Client client : this.schedulerApplication.getClientResource().getClients()) {
            for (Matter matter : this.schedulerApplication.getClientResource().getClientMatters(client.getId())) {
                if (!matter.getName().trim().equals(name.trim()) || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter).getUserPermissions().contains(Permission.VIEW)) continue;
                results.add(matter.getId());
                if (!getFirst) continue;
                continue block0;
            }
        }
        if (results.size() == 0) {
            return ExceptionUtils.toResponse((String)"cannotFindObject", new HashMap(), (Response.Status)Response.Status.NOT_FOUND);
        }
        if (results.size() == 1 || getFirst) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new NameId(name, (String)results.get(0))).build();
        }
        return ExceptionUtils.toResponse((String)"multipleObjectsWithSameName", new HashMap(), (Response.Status)Response.Status.BAD_REQUEST);
    }

    @Operation(tags={"Utils"}, operationId="ResolveLibraryByName", summary="Resolve Library by Name", description="Resolve library name to ID. If the exact spelling of the library name is not known, use the ListWorkflowLibraries method", responses={@ApiResponse(description="The ID", content={@Content(schema=@Schema(implementation=NameId.class))}), @ApiResponse(responseCode="404", description="The specified object could not be found or user does not have permissions to view the object")})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/resolve/library/{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resolveLibraryId(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The name of the object") @PathParam(value="name") String name) {
        boolean getFirst = true;
        ArrayList<String> results = new ArrayList<String>();
        for (WorkflowLibrary library : this.schedulerApplication.getLibraryResource().getWorkflowLibraries()) {
            if (!library.getName().trim().equals(name.trim()) || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, library).getUserPermissions().contains(Permission.VIEW)) continue;
            results.add(library.getId());
            if (!getFirst) continue;
            break;
        }
        if (results.size() == 0) {
            return ExceptionUtils.toResponse((String)"cannotFindObject", new HashMap(), (Response.Status)Response.Status.NOT_FOUND);
        }
        if (results.size() == 1 || getFirst) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new NameId(name, (String)results.get(0))).build();
        }
        return ExceptionUtils.toResponse((String)"multipleObjectsWithSameName", new HashMap(), (Response.Status)Response.Status.BAD_REQUEST);
    }

    @Operation(tags={"Utils"}, operationId="ResolveWorkflowByNameAndLibraryId", summary="Resolve Workflow by Name and Library ID", description="Resolve workflow name for library with the specified ID. If the exact spelling of the workflow name is not known, use the ListWorkflowLibraryWorkflows method", responses={@ApiResponse(description="The ID", content={@Content(schema=@Schema(implementation=NameId.class))}), @ApiResponse(responseCode="404", description="The specified object could not be found or user does not have permissions to view the object")})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/resolve/library/{libraryId}/workflow/{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resolveLibraryWorkflowId(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The ID of the library") @PathParam(value="libraryId") String libraryId, @Parameter(description="The name of the object") @PathParam(value="name") String name) {
        boolean getFirst = true;
        ArrayList<String> results = new ArrayList<String>();
        for (Workflow workflow : this.schedulerApplication.getLibraryResource().getLibraryWorkflows(libraryId)) {
            if (!workflow.getName().trim().equals(name.trim()) || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflow).getUserPermissions().contains(Permission.VIEW)) continue;
            results.add(workflow.getId());
            if (!getFirst) continue;
            break;
        }
        if (results.size() == 0) {
            return ExceptionUtils.toResponse((String)"cannotFindObject", new HashMap(), (Response.Status)Response.Status.NOT_FOUND);
        }
        if (results.size() == 1 || getFirst) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new NameId(name, (String)results.get(0))).build();
        }
        return ExceptionUtils.toResponse((String)"multipleObjectsWithSameName", new HashMap(), (Response.Status)Response.Status.BAD_REQUEST);
    }

    @Operation(tags={"Utils"}, operationId="ResolveWorkflowByName", summary="Resolve Workflow by Name", description="Resolve workflow name to ID. If the exact spelling of the workflow name is not known, use the ListWorkflowLibraryWorkflows method", responses={@ApiResponse(description="The ID", content={@Content(schema=@Schema(implementation=NameId.class))}), @ApiResponse(responseCode="404", description="The specified object could not be found or user does not have permissions to view the object")})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/resolve/workflow/{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resolveWorkflowId(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The name of the object") @PathParam(value="name") String name) {
        boolean getFirst = false;
        ArrayList<String> results = new ArrayList<String>();
        block0: for (WorkflowLibrary library : this.schedulerApplication.getLibraryResource().getWorkflowLibraries()) {
            for (Workflow workflow : this.schedulerApplication.getLibraryResource().getLibraryWorkflows(library.getId())) {
                if (!workflow.getName().trim().equals(name.trim()) || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflow).getUserPermissions().contains(Permission.VIEW)) continue;
                results.add(workflow.getId());
                if (!getFirst) continue;
                continue block0;
            }
        }
        if (results.size() == 0) {
            return ExceptionUtils.toResponse((String)"cannotFindObject", new HashMap(), (Response.Status)Response.Status.NOT_FOUND);
        }
        if (results.size() == 1 || getFirst) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new NameId(name, (String)results.get(0))).build();
        }
        return ExceptionUtils.toResponse((String)"multipleObjectsWithSameName", new HashMap(), (Response.Status)Response.Status.BAD_REQUEST);
    }

    @Operation(tags={"Utils"}, operationId="ResolveLegalHoldByName", summary="Resolve Legal Hold by Name", description="Resolve legal hold name to ID", responses={@ApiResponse(description="The ID", content={@Content(schema=@Schema(implementation=NameId.class))}), @ApiResponse(responseCode="404", description="The specified object could not be found or user does not have permissions to view the object")})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/resolve/legalHold/{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resolveLegalHoldId(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The name of the object") @PathParam(value="name") String name) {
        boolean getFirst = true;
        ArrayList<String> results = new ArrayList<String>();
        for (LegalHold legalHold : this.schedulerApplication.getLegalHoldResource().getLegalHolds()) {
            if (!legalHold.getName().trim().equals(name.trim()) || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold).getUserPermissions().contains(Permission.VIEW)) continue;
            results.add(legalHold.getId());
            if (!getFirst) continue;
            break;
        }
        if (results.size() == 0) {
            return ExceptionUtils.toResponse((String)"cannotFindObject", new HashMap(), (Response.Status)Response.Status.NOT_FOUND);
        }
        if (results.size() == 1 || getFirst) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new NameId(name, (String)results.get(0))).build();
        }
        return ExceptionUtils.toResponse((String)"multipleObjectsWithSameName", new HashMap(), (Response.Status)Response.Status.BAD_REQUEST);
    }

    @Operation(tags={"Utils"}, operationId="ResolveExecutionProfileByName", summary="Resolve Execution Profile by Name", description="Resolve execution profile to ID. If the exact spelling of the execution profile name is not known, use the ListExecutionProfiles method", responses={@ApiResponse(description="The ID", content={@Content(schema=@Schema(implementation=NameId.class))}), @ApiResponse(responseCode="404", description="The specified object could not be found or user does not have permissions to view the object")})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/resolve/executionProfile/{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resolveExecutionProfileId(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The name of the object") @PathParam(value="name") String name) {
        boolean getFirst = true;
        ArrayList<String> results = new ArrayList<String>();
        for (ExecutionProfileModel executionProfileModel : this.schedulerApplication.getExecutionProfileResource().getExecutionProfiles()) {
            if (!executionProfileModel.getName().trim().equals(name.trim()) || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, executionProfileModel).getUserPermissions().contains(Permission.VIEW)) continue;
            results.add(executionProfileModel.getId());
            if (!getFirst) continue;
            break;
        }
        if (results.size() == 0) {
            return ExceptionUtils.toResponse((String)"cannotFindObject", new HashMap(), (Response.Status)Response.Status.NOT_FOUND);
        }
        if (results.size() == 1 || getFirst) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new NameId(name, (String)results.get(0))).build();
        }
        return ExceptionUtils.toResponse((String)"multipleObjectsWithSameName", new HashMap(), (Response.Status)Response.Status.BAD_REQUEST);
    }

    @Operation(tags={"Utils"}, operationId="ResolveResourcePoolByName", summary="Resolve Resource Pool by Name", description="Resolve resource pool to ID. If the exact spelling of the execution profile name is not known, use the ListResourcePools method", responses={@ApiResponse(description="The ID", content={@Content(schema=@Schema(implementation=NameId.class))}), @ApiResponse(responseCode="404", description="The specified object could not be found or user does not have permissions to view the object")})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Path(value="/resolve/resourcePool/{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resolveResourcePoolId(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The name of the object") @PathParam(value="name") String name) {
        boolean getFirst = true;
        ArrayList<String> results = new ArrayList<String>();
        for (ResourcePoolModel resourcePoolModel : this.schedulerApplication.getResourcePoolResource().getResourcePools()) {
            if (!resourcePoolModel.getName().trim().equals(name.trim()) || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, resourcePoolModel).getUserPermissions().contains(Permission.VIEW)) continue;
            results.add(resourcePoolModel.getId());
            if (!getFirst) continue;
            break;
        }
        if (results.size() == 0) {
            return ExceptionUtils.toResponse((String)"cannotFindObject", new HashMap(), (Response.Status)Response.Status.NOT_FOUND);
        }
        if (results.size() == 1 || getFirst) {
            return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new NameId(name, (String)results.get(0))).build();
        }
        return ExceptionUtils.toResponse((String)"multipleObjectsWithSameName", new HashMap(), (Response.Status)Response.Status.BAD_REQUEST);
    }

    @Operation(tags={"Utils"}, operationId="ResolveMultipleNames", summary="Resolve Multiple Names", description="Resolve the names of objects to IDs. This method requires the exact spelling of object names. If multiple objects match the same name, IDs will be returned comma-separated", responses={@ApiResponse(description="The ID", content={@Content(schema=@Schema(implementation=Ids.class))}), @ApiResponse(responseCode="404", description="The specified object could not be found or user does not have permissions to view the object")})
    @SecurityRequirement(name="Bearer_Token")
    @POST
    @Path(value="/resolve/multiple")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resolveMultipleIds(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(hidden=true) @Context HttpServletRequest request, @Parameter(description="The names to resolve") Names names) {
        ArrayList<String> results;
        Iterator<ResourcePoolModel> workflowIds;
        ArrayList<String> libraryIds;
        ArrayList<String> matterIds;
        ArrayList<String> clientIds;
        Ids ids = new Ids();
        if (names.getClientName() != null) {
            clientIds = new ArrayList<String>();
            matterIds = new ArrayList<String>();
            for (Client client : this.schedulerApplication.getClientResource().getClients()) {
                if (!client.getName().trim().equals(names.getClientName().trim()) || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, client).getUserPermissions().contains(Permission.VIEW)) continue;
                clientIds.add(client.getId());
                if (names.getMatterName() == null) continue;
                for (Matter matter : this.schedulerApplication.getClientResource().getClientMatters(client.getId())) {
                    if (!matter.getName().trim().equals(names.getMatterName().trim()) || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter).getUserPermissions().contains(Permission.VIEW)) continue;
                    matterIds.add(matter.getId());
                }
            }
            ids.setClientId(String.join((CharSequence)",", clientIds));
            if (names.getMatterName() != null) {
                ids.setMatterId(String.join((CharSequence)",", matterIds));
            }
        } else {
            clientIds = new ArrayList();
            if (names.getMatterName() != null) {
                matterIds = new ArrayList();
                for (Client client : this.schedulerApplication.getClientResource().getClients()) {
                    for (Matter matter : this.schedulerApplication.getClientResource().getClientMatters(client.getId())) {
                        if (!matter.getName().trim().equals(names.getMatterName().trim()) || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, matter).getUserPermissions().contains(Permission.VIEW)) continue;
                        matterIds.add(matter.getId());
                        clientIds.add(client.getId());
                    }
                }
                ids.setClientId(String.join((CharSequence)",", clientIds));
                ids.setMatterId(String.join((CharSequence)",", matterIds));
            }
        }
        if (names.getLibraryName() != null) {
            libraryIds = new ArrayList<String>();
            workflowIds = new ArrayList();
            for (WorkflowLibrary library : this.schedulerApplication.getLibraryResource().getWorkflowLibraries()) {
                if (!library.getName().trim().equals(names.getLibraryName().trim()) || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, library).getUserPermissions().contains(Permission.VIEW)) continue;
                libraryIds.add(library.getId());
                if (names.getWorkflowName() == null) continue;
                for (Workflow workflow : this.schedulerApplication.getLibraryResource().getLibraryWorkflows(library.getId())) {
                    if (!workflow.getName().trim().equals(names.getWorkflowName().trim()) || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflow).getUserPermissions().contains(Permission.VIEW)) continue;
                    workflowIds.add((ResourcePoolModel)workflow.getId());
                }
            }
            ids.setLibraryId(String.join((CharSequence)",", libraryIds));
            if (names.getWorkflowName() != null) {
                ids.setWorkflowId(String.join((CharSequence)",", workflowIds));
            }
        } else if (names.getWorkflowName() != null) {
            libraryIds = new ArrayList();
            workflowIds = new ArrayList();
            for (WorkflowLibrary library : this.schedulerApplication.getLibraryResource().getWorkflowLibraries()) {
                for (Workflow workflow : this.schedulerApplication.getLibraryResource().getLibraryWorkflows(library.getId())) {
                    if (!workflow.getName().trim().equals(names.getWorkflowName().trim()) || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, workflow).getUserPermissions().contains(Permission.VIEW)) continue;
                    workflowIds.add((ResourcePoolModel)workflow.getId());
                    libraryIds.add(library.getId());
                }
            }
            ids.setLibraryId(String.join((CharSequence)",", libraryIds));
            ids.setWorkflowId(String.join((CharSequence)",", workflowIds));
        }
        if (names.getExecutionProfileName() != null) {
            results = new ArrayList<String>();
            for (ExecutionProfileModel executionProfileModel : this.schedulerApplication.getExecutionProfileResource().getExecutionProfiles()) {
                if (!executionProfileModel.getName().trim().equals(names.getExecutionProfileName().trim()) || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, executionProfileModel).getUserPermissions().contains(Permission.VIEW)) continue;
                results.add(executionProfileModel.getId());
            }
            ids.setExecutionProfileId(String.join((CharSequence)",", results));
        }
        if (names.getResourcePoolName() != null) {
            results = new ArrayList();
            for (ResourcePoolModel resourcePoolModel : this.schedulerApplication.getResourcePoolResource().getResourcePools()) {
                if (!resourcePoolModel.getName().trim().equals(names.getResourcePoolName().trim()) || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, resourcePoolModel).getUserPermissions().contains(Permission.VIEW)) continue;
                results.add(resourcePoolModel.getId());
            }
            ids.setResourcePoolId(String.join((CharSequence)",", results));
        }
        if (names.getJobName() != null) {
            results = new ArrayList();
            List<Job> jobs = this.schedulerApplication.getJobResource().getJobsVisibleBy(user);
            for (Job job : jobs) {
                if (!job.getName().trim().equals(names.getJobName().trim())) continue;
                results.add(job.getId());
            }
            ids.setJobId(String.join((CharSequence)",", results));
        }
        if (names.getLegalHoldName() != null) {
            results = new ArrayList();
            for (LegalHold legalHold : this.schedulerApplication.getLegalHoldResource().getLegalHolds()) {
                if (!legalHold.getName().trim().equals(names.getLegalHoldName().trim()) || !this.schedulerApplication.getSecurityPolicyUtil().setUserPermissions(user, legalHold).getUserPermissions().contains(Permission.VIEW)) continue;
                results.add(legalHold.getId());
            }
            ids.setLegalHoldId(String.join((CharSequence)",", results));
        }
        return Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)ids).build();
    }

    @Operation(tags={"Dummy"}, operationId="DummyServiceEvents", summary="Dummy Service Events", description="Dummy endpoints containing service events sample responses", responses={@ApiResponse(responseCode="501", description="Sample Event Response", content={@Content(schema=@Schema(implementation=ServiceInfo.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/dummy")
    public Response dummy() {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).type(MediaType.APPLICATION_JSON_TYPE).build();
    }
}

