/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.resources;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.persistance.utilization.UtilizationDao;
import com.nuix.automate.utils.api.automatelicense.FileContents;
import com.nuix.automate.utils.api.internal.automatelicense.AutomateLicenceModel;
import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.response.TranslationResponseStatus;
import com.nuix.automate.utils.general.CountingZipInputStream;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.FrequentLogUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.ResponseUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.Licence;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.api.utilization.ImportResults;
import com.nuix.automate.utils.models.internal.event.EventType;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import com.nuix.automate.utils.utilization.Activity;
import com.nuix.automate.utils.utilization.ActivityDetails;
import com.nuix.automate.utils.utilization.ActivityType;
import com.nuix.automate.utils.utilization.Client;
import com.nuix.automate.utils.utilization.CollectionTarget;
import com.nuix.automate.utils.utilization.CustodianActivity;
import com.nuix.automate.utils.utilization.CustodianNotice;
import com.nuix.automate.utils.utilization.DataRepository;
import com.nuix.automate.utils.utilization.DataSet;
import com.nuix.automate.utils.utilization.Engine;
import com.nuix.automate.utils.utilization.ExecutionProfile;
import com.nuix.automate.utils.utilization.Job;
import com.nuix.automate.utils.utilization.LegalHold;
import com.nuix.automate.utils.utilization.Library;
import com.nuix.automate.utils.utilization.License;
import com.nuix.automate.utils.utilization.Matter;
import com.nuix.automate.utils.utilization.MimeTypeVolume;
import com.nuix.automate.utils.utilization.Notice;
import com.nuix.automate.utils.utilization.NuixCase;
import com.nuix.automate.utils.utilization.NuixCaseStat;
import com.nuix.automate.utils.utilization.OperationSetting;
import com.nuix.automate.utils.utilization.OperationType;
import com.nuix.automate.utils.utilization.Organization;
import com.nuix.automate.utils.utilization.RelativityWorkspace;
import com.nuix.automate.utils.utilization.ResourcePool;
import com.nuix.automate.utils.utilization.Server;
import com.nuix.automate.utils.utilization.Session;
import com.nuix.automate.utils.utilization.Transfer;
import com.nuix.automate.utils.utilization.TransferVolume;
import com.nuix.automate.utils.utilization.User;
import com.nuix.automate.utils.utilization.UtilizationProperty;
import com.nuix.automate.utils.utilization.UtilizationPropertyTiming;
import com.nuix.automate.utils.utilization.UtilizationRecords;
import com.nuix.automate.utils.utilization.Workflow;
import io.dropwizard.auth.Auth;
import io.dropwizard.auth.AuthenticationException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@jakarta.ws.rs.Path(value="/v1/scheduler/resources/utilization")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class UtilizationResource {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UtilizationResource.class);
    private InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private SchedulerApplication schedulerApplication;
    private AtomicReference<String> statusMessage = new AtomicReference();
    private static final String README_TXT = "ReadMe.txt";
    private static final String NUIX_CASES_CSV = "NuixCases.csv";
    private static final String NUIX_CASES_HEADER = "Case Name,Case Location,Case GUID,Matter ID";
    private static final String ALL_MATTERS_CSV = "AllMatters.csv";
    private static final String ALL_MATTERS_HEADER = "Matter ID,Matter Name,Client Name";

    public UtilizationResource(SchedulerApplication schedulerApplication) {
        this.schedulerApplication = schedulerApplication;
        String startUpExportFolderPath = schedulerApplication.getConfiguration().getUtilizationExportOnStartUpFolderPath();
        if (startUpExportFolderPath != null && !startUpExportFolderPath.trim().isEmpty()) {
            schedulerApplication.getScheduledExecutorService().submit(() -> {
                try {
                    schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
                    schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
                    Path exportFolderPath = Path.of(startUpExportFolderPath, new String[0]);
                    this.exportOnStartUp(exportFolderPath);
                }
                catch (Exception e) {
                    LOGGER.error("Error exporting utilization on start-up", (Throwable)e);
                }
            });
        }
    }

    private void exportOnStartUp(Path exportFolderPath) throws IOException {
        LOGGER.info("Writing utilization data to " + String.valueOf(exportFolderPath));
        if (!Files.exists(exportFolderPath, new LinkOption[0])) {
            Files.createDirectories(exportFolderPath, new FileAttribute[0]);
        }
        if (!Files.isDirectory(exportFolderPath, new LinkOption[0])) {
            LOGGER.error("Utilization export folder path is not a directory, " + String.valueOf(exportFolderPath));
            return;
        }
        String filename = this.getAnonymizedUtilizationFilename();
        Path exportPath = exportFolderPath.resolve(filename);
        try (OutputStream outputStream = Files.newOutputStream(exportPath, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            this.writeAnonymizedUtilizationZip(filename, outputStream);
        }
        LOGGER.info("Finished writing utilization data to " + String.valueOf(exportFolderPath));
    }

    private String getOrgId() {
        Licence legacyLicense;
        String orgId = this.schedulerApplication.getAutomateLicenceResource().getRampivaLicence().getLicenceInfo().getOrganizationId();
        if (orgId == null && (legacyLicense = this.schedulerApplication.getAutomateLicenceResource().getRampivaLicence().getLegacyLicence()) != null) {
            try {
                LicenceInfo licenceInfo = (LicenceInfo)SerializationUtils.fromJson((String)legacyLicense.licenseInfo, LicenceInfo.class);
                if (licenceInfo != null) {
                    orgId = licenceInfo.getOrganizationId();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Cannot deserialize LicenseInfo", (Throwable)e);
            }
        }
        if (orgId == null) {
            orgId = UidUtils.getRandom();
        }
        return orgId;
    }

    private String getOrgName() {
        Licence legacyLicense;
        String orgName = this.schedulerApplication.getAutomateLicenceResource().getRampivaLicence().getLicenceInfo().getOrganizationName();
        if (orgName == null && (legacyLicense = this.schedulerApplication.getAutomateLicenceResource().getRampivaLicence().getLegacyLicence()) != null) {
            try {
                LicenceInfo licenceInfo = (LicenceInfo)SerializationUtils.fromJson((String)legacyLicense.licenseInfo, LicenceInfo.class);
                if (licenceInfo != null) {
                    orgName = licenceInfo.getOrganizationName();
                }
            }
            catch (Exception e) {
                LOGGER.warn("Cannot deserialize LicenseInfo", (Throwable)e);
            }
        }
        if (orgName == null) {
            orgName = UidUtils.getRandom();
        }
        return orgName;
    }

    @Operation(tags={"Utilization"}, operationId="ExportAnonymizedUtilization", summary="Export anonymized utilization data", description="Export the utilization data in an anonymized format", responses={@ApiResponse(description="The utilization data", content={@Content(schema=@Schema(implementation=String.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @jakarta.ws.rs.Path(value="/anonymized")
    public Response exportAnomymizedUtilisation(@Parameter(hidden=true) @Auth BearerUser user) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        HashSet<Object> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        resourceIdentifiers = new HashSet();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.UTILIZATION));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        String filename = this.getAnonymizedUtilizationFilename();
        StreamingOutput stream = outputStream -> this.writeAnonymizedUtilizationZip(filename, outputStream);
        return ResponseUtils.buildStreamingOutputResponse((StreamingOutput)stream, (String)filename);
    }

    private String getAnonymizedUtilizationFilename() {
        String orgId = UidUtils.getShortId((String)this.getOrgId());
        return "Automate Utilization " + FormattingUtils.dateTimeToInternationalDateString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + " - " + orgId + ".zip";
    }

    private void writeAnonymizedUtilizationZip(String filename, OutputStream outputStream) throws IOException {
        LOGGER.info("Preparing anonymized utilization data");
        try (ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)new BufferedOutputStream(outputStream), StandardCharsets.UTF_8);){
            zipOutputStream.setLevel(1);
            ZipEntry zipEntry = new ZipEntry(FilenameUtils.getBaseName((String)filename) + ".json");
            zipOutputStream.putNextEntry(zipEntry);
            this.appendBOM(zipOutputStream);
            LOGGER.info("Getting utilization records");
            UtilizationRecords utilizationRecords = this.getUtilizationRecords();
            LOGGER.info("Anonymizing utilization records");
            utilizationRecords.encryptSensitiveProperties(null, null, true);
            LOGGER.info("Serializing utilization records");
            String text = SerializationUtils.toJson((Object)utilizationRecords);
            LOGGER.info("Zipping utilization records");
            zipOutputStream.write(text.getBytes(StandardCharsets.UTF_8));
            zipOutputStream.closeEntry();
            zipOutputStream.flush();
            LOGGER.info("Finished preparing anonymized utilization data");
        }
        catch (Exception e) {
            LOGGER.error("Error writing anonymized utilization zip to stream", (Throwable)e);
            throw e;
        }
    }

    @POST
    @jakarta.ws.rs.Path(value="/anonymized")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response getAnonymizedUtilizationStreams(@Parameter(hidden=true) @Context HttpServletRequest req, @FormParam(value="token") String token) throws ParseException, AuthenticationException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Optional<BearerUser> user = this.schedulerApplication.getBearerAuthenticator().authenticateWithUiToken(token, req);
        if (user.isPresent()) {
            return this.exportAnomymizedUtilisation(user.get());
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @Operation(tags={"Utilization"}, operationId="ExportFullUtilization", summary="Export Full Utilization", description="Export the utilization data including object names", responses={@ApiResponse(description="The utilization data", content={@Content(schema=@Schema(implementation=String.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @GET
    @jakarta.ws.rs.Path(value="/full")
    public Response exportFullUtilization(@Parameter(hidden=true) @Auth BearerUser user) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        HashSet<Object> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        resourceIdentifiers = new HashSet();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.UTILIZATION));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        String organizationName = this.getOrgName();
        String sanitizedOrganizationName = FormattingUtils.sanitizeFilename((String)organizationName);
        String fileName = "Automate Utilization " + FormattingUtils.dateTimeToInternationalDateString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + " - " + sanitizedOrganizationName + ".zip";
        StreamingOutput stream = outputStream -> {
            ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)new BufferedOutputStream(outputStream), StandardCharsets.UTF_8);
            zipOutputStream.setLevel(1);
            ZipEntry zipEntry = new ZipEntry("Automate Utilization " + FormattingUtils.dateTimeToInternationalDateString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + " - " + organizationName + ".json");
            zipOutputStream.putNextEntry(zipEntry);
            this.appendBOM(zipOutputStream);
            UtilizationRecords utilizationRecords = this.getUtilizationRecords();
            String text = SerializationUtils.toJson((Object)utilizationRecords);
            zipOutputStream.write(text.getBytes(StandardCharsets.UTF_8));
            zipOutputStream.closeEntry();
            zipOutputStream.close();
        };
        return ResponseUtils.buildStreamingOutputResponse((StreamingOutput)stream, (String)fileName);
    }

    private Map<NuixCase, Matter> getInferredCaseMatters() {
        HashMap<NuixCase, Matter> results = new HashMap<NuixCase, Matter>();
        List<Client> clients = this.schedulerApplication.getUtilizationDaoV2().getClients();
        HashMap<String, Client> clientsById = new HashMap<String, Client>();
        for (Client client : clients) {
            clientsById.put(client.getClientId(), client);
        }
        HashMap<String, Matter> mattersWithSameNameAsClientsByName = new HashMap<String, Matter>();
        List<Matter> matters = this.schedulerApplication.getUtilizationDaoV2().getMatters();
        HashMap mattersByClientId = new HashMap();
        for (Matter matter : matters) {
            Client client = (Client)clientsById.get(matter.getClientId());
            if (client == null || client.getClientName() == null || !client.getClientName().equals(matter.getMatterName())) continue;
            mattersWithSameNameAsClientsByName.put(matter.getMatterName(), matter);
        }
        for (NuixCase nuixCase : this.schedulerApplication.getUtilizationDaoV2().getNuixCases()) {
            Matter matter = (Matter)mattersWithSameNameAsClientsByName.get(nuixCase.getNuixCaseName());
            if (matter == null) continue;
            results.put(nuixCase, matter);
        }
        return results;
    }

    @POST
    @jakarta.ws.rs.Path(value="/inferred")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response getInferredUtilization(@Parameter(hidden=true) @Context HttpServletRequest req, @FormParam(value="token") String token) throws ParseException, AuthenticationException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Optional<BearerUser> user = this.schedulerApplication.getBearerAuthenticator().authenticateWithUiToken(token, req);
        if (user.isPresent()) {
            return this.getInferredUtilization(user.get());
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    @GET
    @jakarta.ws.rs.Path(value="/inferred")
    public Response getInferredUtilization(@Parameter(hidden=true) @Auth BearerUser user) {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        HashSet<Object> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        resourceIdentifiers = new HashSet();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.UTILIZATION));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        String organizationName = this.getOrgName();
        String sanitizedOrganizationName = FormattingUtils.sanitizeFilename((String)organizationName);
        String fileName = "Inferred Utilization " + FormattingUtils.dateTimeToInternationalDateString((DateTime)DateTime.now((DateTimeZone)DateTimeZone.UTC)) + " - " + sanitizedOrganizationName + ".zip";
        StreamingOutput stream = outputStream -> {
            ZipEntry zipEntry;
            ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)new BufferedOutputStream(outputStream), StandardCharsets.UTF_8);
            zipOutputStream.setLevel(1);
            Map<NuixCase, Matter> inferredCaseMatters = this.getInferredCaseMatters();
            if (inferredCaseMatters.size() == 0) {
                zipEntry = new ZipEntry(README_TXT);
                zipOutputStream.putNextEntry(zipEntry);
                this.appendBOM(zipOutputStream);
                zipOutputStream.write("There are no Nuix Cases with inferred Client/Matters".getBytes(StandardCharsets.UTF_8));
                zipOutputStream.closeEntry();
            }
            zipEntry = new ZipEntry(NUIX_CASES_CSV);
            zipOutputStream.putNextEntry(zipEntry);
            this.appendBOM(zipOutputStream);
            StringBuffer sb = new StringBuffer();
            sb.append(NUIX_CASES_HEADER);
            sb.append("\n");
            for (Map.Entry<NuixCase, Matter> entry : inferredCaseMatters.entrySet()) {
                NuixCase nuixCase = entry.getKey();
                Matter matter = entry.getValue();
                sb.append(FormattingUtils.encodeForCsv((String)nuixCase.getNuixCaseName()));
                sb.append(",");
                sb.append(FormattingUtils.encodeForCsv((String)nuixCase.getNuixCaseLocation()));
                sb.append(",");
                sb.append(FormattingUtils.encodeForCsv((String)nuixCase.getNuixCaseId()));
                sb.append(",");
                sb.append("\n");
            }
            zipOutputStream.write(sb.toString().getBytes(StandardCharsets.UTF_8));
            zipOutputStream.closeEntry();
            zipEntry = new ZipEntry(ALL_MATTERS_CSV);
            zipOutputStream.putNextEntry(zipEntry);
            this.appendBOM(zipOutputStream);
            sb = new StringBuffer();
            sb.append(ALL_MATTERS_HEADER);
            sb.append("\n");
            List<Client> clients = this.schedulerApplication.getUtilizationDaoV2().getClients();
            HashMap<String, Client> clientsById = new HashMap<String, Client>();
            for (Client client : clients) {
                clientsById.put(client.getClientId(), client);
            }
            List<Matter> matters = this.schedulerApplication.getUtilizationDaoV2().getMatters();
            for (Matter matter : matters) {
                sb.append(FormattingUtils.encodeForCsv((String)matter.getMatterId()));
                sb.append(",");
                sb.append(FormattingUtils.encodeForCsv((String)matter.getMatterName()));
                sb.append(",");
                Client client = (Client)clientsById.get(matter.getClientId());
                if (client != null) {
                    sb.append(FormattingUtils.encodeForCsv((String)client.getClientName()));
                }
                sb.append("\n");
            }
            zipOutputStream.write(sb.toString().getBytes(StandardCharsets.UTF_8));
            zipOutputStream.closeEntry();
            zipOutputStream.close();
        };
        return ResponseUtils.buildStreamingOutputResponse((StreamingOutput)stream, (String)fileName);
    }

    @SecurityRequirement(name="Bearer_Token")
    @GET
    @jakarta.ws.rs.Path(value="/statistics")
    public Response getStatistics(@Auth BearerUser user) {
        String message;
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.DASHBOARD);
        HashSet<Object> resourceIdentifiers = new HashSet<Identifier>();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        resourceIdentifiers = new HashSet();
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.UTILIZATION));
        resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
        if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.VIEW)) {
            ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
            return ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
        }
        LinkedHashMap<String, Object> statistics = new LinkedHashMap<String, Object>();
        statistics.put("sessionsCount", this.schedulerApplication.getUtilizationDaoV2().countSessions());
        if (this.statusMessage != null && (message = this.statusMessage.get()) != null && !message.isEmpty()) {
            statistics.put("statusMessage", message);
        }
        return Response.status((Response.Status)Response.Status.OK).type("application/json").entity(statistics).build();
    }

    @POST
    @jakarta.ws.rs.Path(value="/full")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response getFullUtilizationStreams(@Parameter(hidden=true) @Context HttpServletRequest req, @FormParam(value="token") String token) throws ParseException, AuthenticationException {
        this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.SCHEDULER_STANDARD);
        Optional<BearerUser> user = this.schedulerApplication.getBearerAuthenticator().authenticateWithUiToken(token, req);
        if (user.isPresent()) {
            return this.exportFullUtilization(user.get());
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    public ImportResults handleUtilizationRecords(UtilizationRecords utilizationRecords, String username) {
        Map sessionOperations;
        HashMap sessionsOperations = new HashMap();
        if (utilizationRecords.getOperations() != null) {
            for (com.nuix.automate.utils.utilization.Operation operation : utilizationRecords.getOperations()) {
                String sessionId = operation.getSessionId();
                sessionOperations = (SortedMap)sessionsOperations.get(sessionId);
                if (sessionOperations == null) {
                    sessionOperations = new TreeMap();
                    sessionsOperations.put(sessionId, sessionOperations);
                }
                sessionOperations.put(operation.getOperationExecutionPosition(), operation);
            }
        }
        if (utilizationRecords.getSessions() != null) {
            for (Session session : utilizationRecords.getSessions()) {
                com.nuix.automate.utils.utilization.Operation lastOperation = null;
                sessionOperations = (Map)sessionsOperations.get(session.getSessionId());
                if (sessionOperations == null) continue;
                for (Map.Entry entry : sessionOperations.entrySet()) {
                    com.nuix.automate.utils.utilization.Operation operation = (com.nuix.automate.utils.utilization.Operation)entry.getValue();
                    if (lastOperation != null) {
                        lastOperation.setOperationNextEventEpoch(operation.getOperationStartEpoch());
                    }
                    lastOperation = operation;
                }
                if (lastOperation == null) continue;
                long operationNextEventEpoch = Math.max(lastOperation.getOperationEndEpoch(), lastOperation.getOperationNextEventEpoch());
                operationNextEventEpoch = Math.max(operationNextEventEpoch, session.getSessionEndEpoch());
                lastOperation.setOperationNextEventEpoch(operationNextEventEpoch);
                session.setSessionEndEpoch(operationNextEventEpoch);
            }
        }
        LOGGER.info("Updating utilization");
        AtomicLong newRecords = new AtomicLong();
        AtomicLong existingRecords = new AtomicLong();
        if (utilizationRecords.getProperties() == null) {
            utilizationRecords.setProperties(new HashMap());
        }
        utilizationRecords.getProperties().put(UtilizationProperty.TIMING.name(), UtilizationPropertyTiming.PRE_RECORDED.name());
        if (this.schedulerApplication.getLicenceUtils().getModuleLicensed(ModuleType.UTILIZATION_UPLOAD) && !this.splitTrackUtilizationRecords(utilizationRecords, 512)) {
            throw new IllegalStateException("Cannot track utilization records");
        }
        this.updateUtilizationRecords(utilizationRecords, newRecords, existingRecords);
        ImportResults importResults = new ImportResults(existingRecords.get(), newRecords.get());
        this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.UTILIZATION_LOADED_EXTERNAL, importResults, username);
        return importResults;
    }

    private boolean splitTrackUtilizationRecords(UtilizationRecords utilizationRecords, int maxSize) {
        ArrayList<UtilizationRecords> utilizationsRecords = new ArrayList<UtilizationRecords>();
        utilizationsRecords.add(utilizationRecords);
        return this.splitTrackUtilizationRecords(utilizationsRecords, maxSize);
    }

    private boolean splitTrackUtilizationRecords(List<UtilizationRecords> utilizationsRecords, int maxSize) {
        LOGGER.info("Tracking utilizations records with max size " + maxSize);
        for (UtilizationRecords utilizationRecords : utilizationsRecords) {
            List splitRecords = utilizationRecords.split(maxSize);
            for (UtilizationRecords splitRecord : splitRecords) {
                String recordNotes = splitRecord.getId();
                if (splitRecord.getProperties() != null && splitRecord.getProperties().containsKey(UtilizationProperty.NOTES.name())) {
                    recordNotes = (String)splitRecord.getProperties().get(UtilizationProperty.NOTES.name());
                }
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Uploading", (Object)recordNotes));
                boolean success = SchedulerApplication.getInstance().getAutomateLicenceResource().getLicenceSession().tryTrackUtilizationRecords(splitRecord, false);
                if (success) continue;
                if (maxSize > 1) {
                    LOGGER.error("Cannot track utilization records, retrying with smaller size");
                    return this.splitTrackUtilizationRecords(splitRecords, maxSize / 2);
                }
                LOGGER.error("Cannot track utilization records");
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Operation(tags={"Utilization"}, operationId="LoadExternalUtilization", summary="Load External Utilization", description="Load utilization data exported from an external system", responses={@ApiResponse(description="The load result", content={@Content(schema=@Schema(implementation=ImportResults.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @jakarta.ws.rs.Path(value="/file")
    @PUT
    public Response uploadUtilizationFile(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The utilization file") FileContents fileContentsModel) {
        Response response;
        HashSet<Object> resourceIdentifiers;
        try {
            UtilizationResource utilizationResource = this;
            synchronized (utilizationResource) {
                UtilizationDao utilization = this.schedulerApplication.getUtilizationDaoV2();
                resourceIdentifiers = new HashSet<Identifier>();
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
                if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
                    ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
                    Response response2 = ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
                    // MONITOREXIT @DISABLED, blocks:[0, 21, 10] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
                    this.statusMessage.set("");
                    return response2;
                }
                resourceIdentifiers = new HashSet();
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            }
        }
        catch (Throwable throwable) {
            this.statusMessage.set("");
            throw throwable;
        }
        {
            resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.UTILIZATION));
            if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
                ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
                Response response3 = ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
                // MONITOREXIT @DISABLED, blocks:[20, 10] lbl27 : MonitorExitStatement: MONITOREXIT : var3_3
                this.statusMessage.set("");
                return response3;
            }
            UtilizationRecords utilizationRecords = null;
            String fileContents = fileContentsModel.getContents();
            byte[] decodedFileContents = Base64.getDecoder().decode(fileContents);
            LOGGER.info("Attempting to parse file as zip");
            this.statusMessage.set(this.iu.getString("UtilizationResource.Status.ParsingFile"));
            ByteArrayInputStream bais = new ByteArrayInputStream(decodedFileContents);
            try (CountingZipInputStream zis = new CountingZipInputStream((InputStream)bais);){
                byte[] buf = new byte[32768];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ZipEntry entry = zis.getNextEntry();
                if (entry != null) {
                    int numRead;
                    LOGGER.info("Detected file " + entry.getName() + " in zip");
                    while ((numRead = zis.read(buf)) >= 0) {
                        byteArrayOutputStream.write(buf, 0, numRead);
                    }
                    String jsonFileContents = byteArrayOutputStream.toString(StandardCharsets.UTF_8);
                    utilizationRecords = (UtilizationRecords)SerializationUtils.fromJson((String)jsonFileContents, UtilizationRecords.class);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Cannot parse file", (Throwable)e);
            }
            if (utilizationRecords == null) {
                try {
                    LOGGER.info("Attempting to parse file as base64 encoded json");
                    String jsonFileContents = new String(decodedFileContents, StandardCharsets.UTF_8);
                    jsonFileContents = this.stripBOM(jsonFileContents);
                    utilizationRecords = (UtilizationRecords)SerializationUtils.fromJson((String)jsonFileContents, UtilizationRecords.class);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot parse file", (Throwable)e);
                }
            }
            if (utilizationRecords == null) {
                LOGGER.error("Cannot decode file with any method");
                Response e = Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("invalidUtilizationData", new HashMap())).build();
                // MONITOREXIT @DISABLED, blocks:[18, 10] lbl68 : MonitorExitStatement: MONITOREXIT : var3_3
                this.statusMessage.set("");
                return e;
            }
            ImportResults importResults = this.handleUtilizationRecords(utilizationRecords, user.getName());
            response = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)importResults).build();
        }
        this.statusMessage.set("");
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Operation(tags={"Utilization"}, operationId="LoadUtilizationToRls", summary="Load Utilization to RLS", description="Load utilization data to RLS", responses={@ApiResponse(description="The load result", content={@Content(schema=@Schema(implementation=ImportResults.class))})})
    @SecurityRequirement(name="Bearer_Token")
    @jakarta.ws.rs.Path(value="/rlsFile")
    @PUT
    public Response uploadUtilizationFileRls(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The utilization file") FileContents fileContentsModel) {
        Response response;
        UtilizationDao utilization;
        try {
            UtilizationResource utilizationResource = this;
            synchronized (utilizationResource) {
                utilization = this.schedulerApplication.getUtilizationDaoV2();
                HashSet<Identifier> resourceIdentifiers = new HashSet<Identifier>();
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.UTILIZATION));
                if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
                    ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
                    Response response2 = ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
                    // MONITOREXIT @DISABLED, blocks:[0, 22, 10] lbl13 : MonitorExitStatement: MONITOREXIT : var3_3
                    this.statusMessage.set("");
                    return response2;
                }
            }
        }
        catch (Throwable throwable) {
            this.statusMessage.set("");
            throw throwable;
        }
        {
            this.schedulerApplication.getLicenceUtils().assertModuleLicensed(ModuleType.UTILIZATION_UPLOAD);
            if (utilization.countSessions() == null || utilization.countSessions() > 0) {
                Response response3 = ExceptionUtils.toResponse((String)"utilizationDatabaseAlreadyContainsSessions", (Map)null, (Response.Status)Response.Status.BAD_REQUEST);
                // MONITOREXIT @DISABLED, blocks:[20, 10] lbl23 : MonitorExitStatement: MONITOREXIT : var3_3
                this.statusMessage.set("");
                return response3;
            }
            UtilizationRecords utilizationRecords = null;
            String fileContents = fileContentsModel.getContents();
            byte[] decodedFileContents = Base64.getDecoder().decode(fileContents);
            LOGGER.info("Attempting to parse file as zip");
            this.statusMessage.set(this.iu.getString("UtilizationResource.Status.ParsingFile"));
            ByteArrayInputStream bais = new ByteArrayInputStream(decodedFileContents);
            try (CountingZipInputStream zis = new CountingZipInputStream((InputStream)bais);){
                byte[] buf = new byte[32768];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ZipEntry entry = zis.getNextEntry();
                if (entry != null) {
                    int numRead;
                    LOGGER.info("Detected file " + entry.getName() + " in zip");
                    while ((numRead = zis.read(buf)) >= 0) {
                        byteArrayOutputStream.write(buf, 0, numRead);
                    }
                    String jsonFileContents = byteArrayOutputStream.toString(StandardCharsets.UTF_8);
                    utilizationRecords = (UtilizationRecords)SerializationUtils.fromJson((String)jsonFileContents, UtilizationRecords.class);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Cannot parse file", (Throwable)e);
            }
            if (utilizationRecords == null) {
                try {
                    LOGGER.info("Attempting to parse file as base64 encoded json");
                    String jsonFileContents = new String(decodedFileContents, StandardCharsets.UTF_8);
                    jsonFileContents = this.stripBOM(jsonFileContents);
                    utilizationRecords = (UtilizationRecords)SerializationUtils.fromJson((String)jsonFileContents, UtilizationRecords.class);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot parse file", (Throwable)e);
                }
            }
            if (utilizationRecords == null) {
                LOGGER.error("Cannot decode file with any method");
                Response e = Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("invalidUtilizationData", new HashMap())).build();
                // MONITOREXIT @DISABLED, blocks:[18, 10] lbl64 : MonitorExitStatement: MONITOREXIT : var3_3
                this.statusMessage.set("");
                return e;
            }
            Session dummySession = new Session();
            dummySession.setSessionId(UidUtils.getRandom());
            utilization.addSession(dummySession);
            ImportResults importResults = this.handleUtilizationRecords(utilizationRecords, user.getName());
            response = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)importResults).build();
        }
        this.statusMessage.set("");
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @jakarta.ws.rs.Path(value="/inferred")
    @PUT
    public Response updateInferredUtilization(@Parameter(hidden=true) @Auth BearerUser user, @Parameter(description="The utilization file") FileContents fileContentsModel) {
        Response response;
        HashSet<Object> resourceIdentifiers;
        try {
            UtilizationResource utilizationResource = this;
            synchronized (utilizationResource) {
                resourceIdentifiers = new HashSet<Identifier>();
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENTS));
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.ALL_CLIENT_POOLS));
                if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
                    ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
                    Response response2 = ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
                    // MONITOREXIT @DISABLED, blocks:[0, 21, 10] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                    this.statusMessage.set("");
                    return response2;
                }
                resourceIdentifiers = new HashSet();
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.RESOURCES));
            }
        }
        catch (Throwable throwable) {
            this.statusMessage.set("");
            throw throwable;
        }
        {
            byte[] decodedFileContents;
            Integer updateUtilizationRecords;
            block23: {
                resourceIdentifiers.add(new Identifier(IdentifierType.BUILTIN, (Enum)BuiltInScopeIdentifiers.UTILIZATION));
                if (!this.schedulerApplication.getSecurityPolicyUtil().isAnyAllowed((Set<Identifier>)user.getIdentifiers(), (Set<Identifier>)resourceIdentifiers, Permission.MODIFY)) {
                    ExceptionUtils.logUserDoesNotHavePermissions((String)user.toString(), (Object)"");
                    Response response3 = ExceptionUtils.toResponse((String)"userDoesNotHavePermissions", (Map)null, (Response.Status)Response.Status.FORBIDDEN);
                    // MONITOREXIT @DISABLED, blocks:[20, 10] lbl26 : MonitorExitStatement: MONITOREXIT : var3_3
                    this.statusMessage.set("");
                    return response3;
                }
                updateUtilizationRecords = null;
                String fileContents = fileContentsModel.getContents();
                decodedFileContents = Base64.getDecoder().decode(fileContents);
                LOGGER.info("Attempting to parse file as zip");
                this.statusMessage.set(this.iu.getString("UtilizationResource.Status.ParsingFile"));
                ByteArrayInputStream bais = new ByteArrayInputStream(decodedFileContents);
                try (CountingZipInputStream zis = new CountingZipInputStream((InputStream)bais);){
                    int numRead;
                    byte[] buf = new byte[32768];
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ZipEntry entry = zis.getNextEntry();
                    if (entry == null) break block23;
                    LOGGER.info("Detected file " + entry.getName() + " in zip");
                    while ((numRead = zis.read(buf)) >= 0) {
                        byteArrayOutputStream.write(buf, 0, numRead);
                    }
                    if (entry.getName().equals(NUIX_CASES_CSV)) {
                        String csvFileContents = byteArrayOutputStream.toString(StandardCharsets.UTF_8.toString());
                        updateUtilizationRecords = this.updateInferredUtilization(csvFileContents);
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot parse file", (Throwable)e);
                }
            }
            if (updateUtilizationRecords == null) {
                try {
                    LOGGER.info("Attempting to parse file as base64 encoded csv");
                    String csvFileContents = new String(decodedFileContents, StandardCharsets.UTF_8);
                    csvFileContents = this.stripBOM(csvFileContents);
                    updateUtilizationRecords = this.updateInferredUtilization(csvFileContents);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot parse file", (Throwable)e);
                }
            }
            if (updateUtilizationRecords == null) {
                LOGGER.error("Cannot decode file with any method");
                Response e = Response.status((Response.Status)Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new TranslationResponseStatus("invalidInferredUtilizationData", new HashMap())).build();
                // MONITOREXIT @DISABLED, blocks:[18, 10] lbl68 : MonitorExitStatement: MONITOREXIT : var3_3
                this.statusMessage.set("");
                return e;
            }
            LOGGER.info("Updating utilization");
            ImportResults importResults = new ImportResults((long)updateUtilizationRecords.intValue(), 0L);
            this.schedulerApplication.getWebhookWorker().triggerEvent(EventType.Type.UTILIZATION_LOADED_EXTERNAL, importResults, user.getName());
            response = Response.status((Response.Status)Response.Status.OK).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)importResults).build();
        }
        this.statusMessage.set("");
        return response;
    }

    private Integer updateInferredUtilization(String csvContent) throws IOException {
        Object matterId;
        Integer updatedRecords = 0;
        LOGGER.info("Attempting to update inferred utilization data");
        if (!csvContent.startsWith(NUIX_CASES_HEADER)) {
            throw new IOException("CSV does not start with expected content Case Name,Case Location,Case GUID,Matter ID. Instead, CSV starts with " + csvContent.substring(0, NUIX_CASES_HEADER.length()));
        }
        LOGGER.info("Header matches");
        LOGGER.info("Querying utilization data");
        Map<NuixCase, Matter> inferredCaseMatters = this.getInferredCaseMatters();
        HashMap<String, NuixCase> inferredCasesById = new HashMap<String, NuixCase>();
        for (NuixCase nuixCase : inferredCaseMatters.keySet()) {
            inferredCasesById.put(nuixCase.getNuixCaseId(), nuixCase);
        }
        List<Client> clients = this.schedulerApplication.getUtilizationDaoV2().getClients();
        HashMap<String, Client> clientsById = new HashMap<String, Client>();
        for (Client client : clients) {
            clientsById.put(client.getClientId(), client);
        }
        List<Matter> matters = this.schedulerApplication.getUtilizationDaoV2().getMatters();
        HashMap<String, Matter> mattersById = new HashMap<String, Matter>();
        for (Matter matter : matters) {
            mattersById.put(matter.getMatterId(), matter);
        }
        ArrayList<Job> jobsWithUnknownMatters = new ArrayList<Job>();
        HashMap<String, String> jobIdToNewMatterId = new HashMap<String, String>();
        List<Job> jobs = this.schedulerApplication.getUtilizationDaoV2().getJobs();
        HashMap<String, Job> jobsById = new HashMap<String, Job>();
        HashMap<Object, HashSet<Job>> jobsByMatterId = new HashMap<Object, HashSet<Job>>();
        for (Job job : jobs) {
            jobsById.put(job.getJobId(), job);
            matterId = job.getMatterId();
            if (!mattersById.containsKey(matterId)) {
                jobsWithUnknownMatters.add(job);
            }
            if (matterId == null) continue;
            HashSet<Job> jobList = (HashSet<Job>)jobsByMatterId.get(matterId);
            if (jobList == null) {
                jobList = new HashSet<Job>();
                jobsByMatterId.put(matterId, jobList);
            }
            jobList.add(job);
        }
        HashMap<String, Session> allSessionsByIds = new HashMap<String, Session>();
        if (jobsWithUnknownMatters.size() > 0) {
            List<Session> allSessions = this.schedulerApplication.getUtilizationDaoV2().getSessions();
            matterId = allSessions.iterator();
            while (matterId.hasNext()) {
                Session session = (Session)matterId.next();
                allSessionsByIds.put(session.getSessionId(), session);
            }
        }
        for (Job job : jobsWithUnknownMatters) {
            LOGGER.info("Handling orphaned job " + job.getJobId());
            String resolvedJobMatterId = null;
            List<Session> sessions = this.schedulerApplication.getUtilizationDaoV2().getJobSession(job.getJobId());
            HashMap<String, Session> jobSessionsById = new HashMap<String, Session>();
            HashSet<String> nuixCaseIds = new HashSet<String>();
            for (Session session : sessions) {
                List<String> sessionNuixCaseIds = this.schedulerApplication.getUtilizationDaoV2().getSessionNuixCases(session.getSessionId());
                nuixCaseIds.addAll(sessionNuixCaseIds);
                jobSessionsById.put(session.getSessionId(), session);
            }
            block7: for (String nuixCaseId : nuixCaseIds) {
                if (resolvedJobMatterId != null) break;
                List<String> sessionIds = this.schedulerApplication.getUtilizationDaoV2().getNuixCaseSessions(nuixCaseId);
                for (String sessionId : sessionIds) {
                    String jobMatterId;
                    String jobId;
                    Job sessionJob;
                    Session session = (Session)allSessionsByIds.get(sessionId);
                    if (session == null || (sessionJob = (Job)jobsById.get(jobId = session.getJobId())) == null || !mattersById.containsKey(jobMatterId = sessionJob.getMatterId())) continue;
                    resolvedJobMatterId = jobMatterId;
                    LOGGER.info("Detected job matter " + jobMatterId);
                    continue block7;
                }
            }
            if (resolvedJobMatterId == null) continue;
            LOGGER.info("Switching job " + job.getJobId() + " matter from " + job.getMatterId() + " to " + job.getMatterId());
            job.setMatterId(resolvedJobMatterId);
            jobIdToNewMatterId.put(job.getJobId(), resolvedJobMatterId);
            this.schedulerApplication.getUtilizationDaoV2().updateJob(job);
        }
        List csv = FileUtils.loadVariableColumnCsv((String)csvContent);
        for (int i = 1; i < csv.size(); ++i) {
            LOGGER.info("Processing line " + i);
            Object[] line = (Object[])csv.get(i);
            if (line.length < 4) {
                LOGGER.info("Skipping line, columns: " + line.length);
                continue;
            }
            String caseId = line[2].toString().trim();
            String matterId2 = line[3].toString().trim();
            if (matterId2.length() == 0) {
                LOGGER.info("Skipping line, matter ID is blank");
                continue;
            }
            NuixCase nuixCase = (NuixCase)inferredCasesById.get(caseId);
            if (nuixCase == null) {
                LOGGER.info("Skipping line, cannot resolve Nuix case ID");
                continue;
            }
            Matter newMatter = (Matter)mattersById.get(matterId2);
            if (newMatter == null) {
                LOGGER.info("Skipping line, cannot resolve matter ID " + matterId2);
                continue;
            }
            Matter oldMatter = inferredCaseMatters.get(nuixCase);
            LOGGER.info("Deleting matter " + oldMatter.getMatterId());
            this.schedulerApplication.getUtilizationDaoV2().deleteMatter(oldMatter.getMatterId());
            LOGGER.info("Deleting client " + oldMatter.getClientId());
            this.schedulerApplication.getUtilizationDaoV2().deleteClient(oldMatter.getClientId());
            Set caseJobs = (Set)jobsByMatterId.get(oldMatter.getMatterId());
            for (Job caseJob : caseJobs) {
                LOGGER.info("Switching job " + caseJob.getJobId() + " matter from " + oldMatter.getMatterId() + " to " + newMatter.getMatterId());
                caseJob.setMatterId(newMatter.getMatterId());
                jobIdToNewMatterId.put(caseJob.getJobId(), newMatter.getMatterId());
                this.schedulerApplication.getUtilizationDaoV2().updateJob(caseJob);
            }
            Integer n = updatedRecords;
            updatedRecords = updatedRecords + 1;
        }
        for (String jobId : jobIdToNewMatterId.keySet()) {
            String newMatterId = (String)jobIdToNewMatterId.get(jobId);
            updatedRecords = updatedRecords + this.schedulerApplication.getUtilizationDaoV2().updateActivityMatterForJob(jobId, newMatterId);
        }
        return updatedRecords;
    }

    public Set<Session> getOverlappingSessionIds(UtilizationRecords utilizationRecords) {
        HashMap<String, Session> sessionMap = new HashMap<String, Session>();
        if (utilizationRecords.getSessions() != null) {
            for (Session session : utilizationRecords.getSessions()) {
                sessionMap.put(session.getSessionId(), session);
            }
        }
        HashMap nuixCaseSessions = new HashMap();
        Set operations = utilizationRecords.getOperations();
        if (operations != null) {
            for (com.nuix.automate.utils.utilization.Operation operation : operations) {
                Session session;
                if (operation.getNuixCaseId() == null) continue;
                HashSet<Session> sessions = (HashSet<Session>)nuixCaseSessions.get(operation.getNuixCaseId());
                if (sessions == null) {
                    sessions = new HashSet<Session>();
                    nuixCaseSessions.put(operation.getNuixCaseId(), sessions);
                }
                if ((session = (Session)sessionMap.get(operation.getSessionId())) == null) continue;
                sessions.add(session);
            }
        }
        UtilizationDao utilizationDao = this.schedulerApplication.getUtilizationDaoV2();
        HashSet<Session> overlappingSessions = new HashSet<Session>();
        for (String nuixCaseId : nuixCaseSessions.keySet()) {
            List<com.nuix.automate.utils.utilization.Operation> nuixCaseOperations = utilizationDao.getOperationsWithNuixCase(nuixCaseId);
            block3: for (Session session : (Set)nuixCaseSessions.get(nuixCaseId)) {
                for (com.nuix.automate.utils.utilization.Operation operation : nuixCaseOperations) {
                    if ((operation.getOperationStartEpoch() <= session.getSessionStartEpoch() || operation.getOperationStartEpoch() >= session.getSessionEndEpoch()) && (operation.getOperationEndEpoch() <= session.getSessionStartEpoch() || operation.getOperationEndEpoch() >= session.getSessionEndEpoch())) continue;
                    overlappingSessions.add(session);
                    LOGGER.info("Detected conflicting session " + session.getSessionId() + " in utilization database");
                    continue block3;
                }
            }
        }
        return overlappingSessions;
    }

    private void updateUtilizationRecords(UtilizationRecords utilizationRecords, AtomicLong newRecordsCount, AtomicLong existingRecordsCount) {
        Object record7;
        UtilizationDao utilization = this.schedulerApplication.getUtilizationDaoV2();
        Set<Session> overlappingSessions = this.getOverlappingSessionIds(utilizationRecords);
        HashSet<String> overlappingSessionIds = new HashSet<String>();
        HashSet<String> overlappingJobIds = new HashSet<String>();
        for (Session session : overlappingSessions) {
            overlappingSessionIds.add(session.getSessionId());
            overlappingJobIds.add(session.getJobId());
        }
        if (utilizationRecords.getOrganizations() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getOrganizations().size() + " organizations"));
            for (Object record2 : utilizationRecords.getOrganizations()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                FrequentLogUtils.info((String)this.statusMessage.get());
                utilization.replaceOrganization((Organization)record2);
                newRecordsCount.incrementAndGet();
            }
        }
        if (utilizationRecords.getLicenses() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getLicenses().size() + " licenses"));
            for (Object record2 : utilizationRecords.getLicenses()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                FrequentLogUtils.info((String)this.statusMessage.get());
                utilization.replaceLicense((License)record2);
                newRecordsCount.incrementAndGet();
            }
        }
        if (utilizationRecords.getClients() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getClients().size() + " clients"));
            for (Object record2 : utilizationRecords.getClients()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                FrequentLogUtils.info((String)this.statusMessage.get());
                utilization.replaceClient((Client)record2);
                newRecordsCount.incrementAndGet();
            }
        }
        if (utilizationRecords.getDataRepositories() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getDataRepositories().size() + " data repositories"));
            for (Object record2 : utilizationRecords.getDataRepositories()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                FrequentLogUtils.info((String)this.statusMessage.get());
                utilization.replaceDataRepository((DataRepository)record2);
                newRecordsCount.incrementAndGet();
            }
        }
        if (utilizationRecords.getDataSets() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getDataSets().size() + " data sets"));
            for (Object record2 : utilizationRecords.getDataSets()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                try {
                    FrequentLogUtils.info((String)this.statusMessage.get());
                    utilization.addDataSet((DataSet)record2);
                    newRecordsCount.incrementAndGet();
                }
                catch (Exception e) {
                    existingRecordsCount.incrementAndGet();
                }
            }
        }
        if (utilizationRecords.getTransfers() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getTransfers().size() + " transfers"));
            for (Object record2 : utilizationRecords.getTransfers()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                try {
                    FrequentLogUtils.info((String)this.statusMessage.get());
                    utilization.addTransfer((Transfer)record2);
                    newRecordsCount.incrementAndGet();
                }
                catch (Exception e) {}
            }
        }
        if (utilizationRecords.getTransferVolumes() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getTransferVolumes().size() + " transfer volumes"));
            for (Object record2 : utilizationRecords.getTransferVolumes()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                try {
                    FrequentLogUtils.info((String)this.statusMessage.get());
                    utilization.addTransferVolume((TransferVolume)record2);
                    newRecordsCount.incrementAndGet();
                }
                catch (Exception e) {}
            }
        }
        if (utilizationRecords.getEngines() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getEngines().size() + " engines"));
            for (Object record2 : utilizationRecords.getEngines()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                FrequentLogUtils.info((String)this.statusMessage.get());
                utilization.replaceEngine((Engine)record2);
                newRecordsCount.incrementAndGet();
            }
        }
        if (utilizationRecords.getExecutionProfiles() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getExecutionProfiles().size() + " execution profiles"));
            for (Object record2 : utilizationRecords.getExecutionProfiles()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                FrequentLogUtils.info((String)this.statusMessage.get());
                utilization.replaceExecutionProfile((ExecutionProfile)record2);
                newRecordsCount.incrementAndGet();
            }
        }
        if (utilizationRecords.getJobs() != null) {
            ActivityDetails jobSetupActivity;
            Object job2;
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getJobs().size() + " jobs"));
            Iterator<Job> jobs = new ArrayList();
            for (Object job2 : utilizationRecords.getJobs()) {
                if (overlappingJobIds.contains(job2.getJobId())) {
                    LOGGER.info("Skipping " + job2.getJobId() + " due to overlapping session");
                    continue;
                }
                jobs.add((Job)job2);
            }
            try {
                utilization.replaceJobs((Collection<Job>)((Object)jobs));
                newRecordsCount.addAndGet(jobs.size());
                ArrayList<Activity> allActivities = new ArrayList<Activity>();
                job2 = jobs.iterator();
                while (job2.hasNext()) {
                    record7 = (Job)job2.next();
                    if (record7.getJobSubmissionEpoch() == null) continue;
                    jobSetupActivity = new ActivityDetails();
                    jobSetupActivity.setStartEpoch(record7.getJobSubmissionEpoch().longValue());
                    jobSetupActivity.setLastEpoch(record7.getJobSubmissionEpoch() + 1L);
                    jobSetupActivity.setMatterId(record7.getMatterId());
                    jobSetupActivity.setActivityType(ActivityType.JOB_SETUP);
                    jobSetupActivity.setUserId(record7.getJobSubmittedByUserId());
                    jobSetupActivity.setActivityKey(record7.getJobId());
                    List<Activity> activities = this.schedulerApplication.getUserResource().getActivitiesFromActivityDetails(jobSetupActivity);
                    allActivities.addAll(activities);
                }
                utilization.replaceActivities(allActivities);
                newRecordsCount.addAndGet(allActivities.size());
            }
            catch (Exception e) {
                LOGGER.warn("Cannot mass replace jobs, " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                job2 = jobs.iterator();
                while (job2.hasNext()) {
                    record7 = (Job)job2.next();
                    this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                    FrequentLogUtils.info((String)this.statusMessage.get());
                    utilization.replaceJob((Job)record7);
                    newRecordsCount.incrementAndGet();
                    if (record7.getJobSubmissionEpoch() == null) continue;
                    jobSetupActivity = new ActivityDetails();
                    jobSetupActivity.setStartEpoch(record7.getJobSubmissionEpoch().longValue());
                    jobSetupActivity.setLastEpoch(record7.getJobSubmissionEpoch() + 1L);
                    jobSetupActivity.setMatterId(record7.getMatterId());
                    jobSetupActivity.setActivityType(ActivityType.JOB_SETUP);
                    jobSetupActivity.setUserId(record7.getJobSubmittedByUserId());
                    jobSetupActivity.setActivityKey(record7.getJobId());
                    int newActivitiesCount = this.schedulerApplication.getUserResource().trackFinishedActivity(jobSetupActivity, true);
                    newRecordsCount.addAndGet(newActivitiesCount);
                }
            }
        }
        if (utilizationRecords.getLibraries() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getLibraries().size() + " libraries"));
            for (Object record2 : utilizationRecords.getLibraries()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                FrequentLogUtils.info((String)this.statusMessage.get());
                utilization.replaceLibrary((Library)record2);
                newRecordsCount.incrementAndGet();
            }
        }
        if (utilizationRecords.getMatters() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getMatters().size() + " matters"));
            for (Object record2 : utilizationRecords.getMatters()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                FrequentLogUtils.info((String)this.statusMessage.get());
                utilization.replaceMatter((Matter)record2);
                newRecordsCount.incrementAndGet();
            }
        }
        if (utilizationRecords.getNuixCases() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getNuixCases().size() + " Nuix cases"));
            for (Object record2 : utilizationRecords.getNuixCases()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                FrequentLogUtils.info((String)this.statusMessage.get());
                utilization.replaceNuixCase((NuixCase)record2);
                newRecordsCount.incrementAndGet();
            }
        }
        if (utilizationRecords.getRelativityWorkspaces() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getRelativityWorkspaces().size() + " Relativity Workspaces"));
            for (Object record2 : utilizationRecords.getRelativityWorkspaces()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                FrequentLogUtils.info((String)this.statusMessage.get());
                utilization.replaceRelativityWorkspace((RelativityWorkspace)record2);
                newRecordsCount.incrementAndGet();
            }
        }
        HashMap<String, AtomicLong> sessionOcrVolumes = new HashMap<String, AtomicLong>();
        if (utilizationRecords.getOperations() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getOperations().size() + " operations"));
            Iterator allMimeTypeVolumes = new ArrayList();
            ArrayList<OperationSetting> allOperationSettings = new ArrayList<OperationSetting>();
            ArrayList<com.nuix.automate.utils.utilization.Operation> operations = new ArrayList<com.nuix.automate.utils.utilization.Operation>();
            for (com.nuix.automate.utils.utilization.Operation record3 : utilizationRecords.getOperations()) {
                if (overlappingSessionIds.contains(record3.getSessionId())) {
                    LOGGER.info("Skipping " + record3.getOperationId() + " due to overlapping session");
                    continue;
                }
                operations.add(record3);
            }
            for (com.nuix.automate.utils.utilization.Operation record4 : operations) {
                String sessionId = record4.getSessionId();
                if (record4.getOperationType().equals((Object)OperationType.OCR) || record4.getOperationName().toLowerCase().contains("ocr")) {
                    AtomicLong previousOcrVolume = (AtomicLong)sessionOcrVolumes.get(sessionId);
                    if (previousOcrVolume == null) {
                        previousOcrVolume = new AtomicLong(0L);
                    }
                    sessionOcrVolumes.put(sessionId, previousOcrVolume);
                    if (record4.getMimeTypeVolumes() != null) {
                        for (MimeTypeVolume mimeTypeVolume : record4.getMimeTypeVolumes()) {
                            previousOcrVolume.addAndGet(mimeTypeVolume.getAuditedSize());
                        }
                    } else {
                        previousOcrVolume.addAndGet(record4.getAuditedSize());
                    }
                }
                if (record4.getMimeTypeVolumes() == null) continue;
                allMimeTypeVolumes.addAll(record4.getMimeTypeVolumes());
            }
            try {
                utilization.replaceOperations(operations);
                utilization.replaceMimeTypeVolumes((Collection<MimeTypeVolume>)((Object)allMimeTypeVolumes));
                newRecordsCount.addAndGet(allMimeTypeVolumes.size());
                utilization.replaceOperationSettings(allOperationSettings);
                newRecordsCount.addAndGet(allOperationSettings.size());
            }
            catch (Exception e) {
                LOGGER.warn("Cannot mass replace operations, " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                for (com.nuix.automate.utils.utilization.Operation record5 : operations) {
                    List operationSettings;
                    this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                    FrequentLogUtils.info((String)this.statusMessage.get());
                    utilization.replaceOperation(record5);
                    newRecordsCount.incrementAndGet();
                    List mimeTypeVolumes = record5.getMimeTypeVolumes();
                    if (mimeTypeVolumes != null) {
                        for (MimeTypeVolume mimeTypeVolume : mimeTypeVolumes) {
                            utilization.replaceMimeTypeVolume(mimeTypeVolume);
                        }
                    }
                    if ((operationSettings = record5.getOperationSettings()) == null) continue;
                    for (OperationSetting operationSetting : operationSettings) {
                        utilization.replaceOperationSettings(operationSetting);
                    }
                }
            }
        }
        if (utilizationRecords.getResourcePools() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getResourcePools().size() + " resource pools"));
            for (Object record6 : utilizationRecords.getResourcePools()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                FrequentLogUtils.info((String)this.statusMessage.get());
                utilization.replaceResourcePool((ResourcePool)record6);
                newRecordsCount.incrementAndGet();
            }
        }
        if (utilizationRecords.getServers() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getServers().size() + " servers"));
            for (Object record6 : utilizationRecords.getServers()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                FrequentLogUtils.info((String)this.statusMessage.get());
                utilization.replaceServer((Server)record6);
                newRecordsCount.incrementAndGet();
            }
        }
        if (utilizationRecords.getSessions() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getSessions().size() + " sessions"));
            Iterator<Object> sessions = new ArrayList();
            for (Object record7 : utilizationRecords.getSessions()) {
                if (overlappingSessionIds.contains(record7.getSessionId())) {
                    LOGGER.info("Skipping " + record7.getSessionId() + " due to overlapping session");
                    continue;
                }
                if (record7.getVolumeOcred() == 0L && sessionOcrVolumes.containsKey(record7.getSessionId())) {
                    record7.setVolumeOcred(((AtomicLong)sessionOcrVolumes.get(record7.getSessionId())).get());
                }
                sessions.add(record7);
            }
            try {
                utilization.replaceSessions((Collection<Session>)((Object)sessions));
                newRecordsCount.addAndGet(sessions.size());
            }
            catch (Exception e) {
                LOGGER.warn("Cannot mass replace sessions, " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                record7 = sessions.iterator();
                while (record7.hasNext()) {
                    Session record8 = (Session)record7.next();
                    this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                    FrequentLogUtils.info((String)this.statusMessage.get());
                    utilization.replaceSession(record8);
                    newRecordsCount.incrementAndGet();
                }
            }
        }
        if (utilizationRecords.getWorkflows() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getWorkflows().size() + " workflows"));
            for (Object record6 : utilizationRecords.getWorkflows()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                FrequentLogUtils.info((String)this.statusMessage.get());
                utilization.replaceWorkflow((Workflow)record6);
                newRecordsCount.incrementAndGet();
            }
        }
        if (utilizationRecords.getUsers() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getUsers().size() + " users"));
            for (Object record6 : utilizationRecords.getUsers()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                FrequentLogUtils.info((String)this.statusMessage.get());
                utilization.replaceUser((User)record6);
                newRecordsCount.incrementAndGet();
            }
        }
        if (utilizationRecords.getNuixCaseStats() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getNuixCaseStats().size() + " Nuix case stats"));
            try {
                utilization.replaceNuixCaseStats(utilizationRecords.getNuixCaseStats());
                newRecordsCount.addAndGet(utilizationRecords.getNuixCaseStats().size());
            }
            catch (Exception e) {
                LOGGER.warn("Cannot mass replace Nuix case stats, " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                for (Object record7 : utilizationRecords.getNuixCaseStats()) {
                    this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                    FrequentLogUtils.info((String)this.statusMessage.get());
                    utilization.replaceNuixCaseStat((NuixCaseStat)record7);
                    newRecordsCount.incrementAndGet();
                }
            }
        }
        if (utilizationRecords.getActivities() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getActivities().size() + " activities"));
            try {
                ArrayList<Activity> activities = new ArrayList<Activity>();
                activities.addAll(utilizationRecords.getActivities());
                utilization.replaceActivities(activities);
                newRecordsCount.addAndGet(activities.size());
            }
            catch (Exception e) {
                LOGGER.warn("Cannot mass replace activities, " + ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
                for (Activity activity : utilizationRecords.getActivities()) {
                    this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                    try {
                        FrequentLogUtils.info((String)this.statusMessage.get());
                        utilization.addActivity(activity);
                        newRecordsCount.incrementAndGet();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (utilizationRecords.getCollections() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getCollections().size() + " collections"));
            for (Object record6 : utilizationRecords.getCollections()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                FrequentLogUtils.info((String)this.statusMessage.get());
                utilization.replaceCollection((com.nuix.automate.utils.utilization.Collection)record6);
                newRecordsCount.incrementAndGet();
            }
        }
        if (utilizationRecords.getCollectionTargets() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getCollectionTargets().size() + " collection targets"));
            for (Object record6 : utilizationRecords.getCollectionTargets()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                FrequentLogUtils.info((String)this.statusMessage.get());
                utilization.replaceCollectionTarget((CollectionTarget)record6);
                newRecordsCount.incrementAndGet();
            }
        }
        if (utilizationRecords.getLegalHolds() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getLegalHolds().size() + " legal holds"));
            for (Object record6 : utilizationRecords.getLegalHolds()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                FrequentLogUtils.info((String)this.statusMessage.get());
                utilization.replaceLegalHold((LegalHold)record6);
                newRecordsCount.incrementAndGet();
            }
        }
        if (utilizationRecords.getNotices() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getNotices().size() + " notices"));
            for (Object record6 : utilizationRecords.getNotices()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                try {
                    FrequentLogUtils.info((String)this.statusMessage.get());
                    utilization.addNotice((Notice)record6);
                    newRecordsCount.incrementAndGet();
                }
                catch (Exception exception) {}
            }
        }
        if (utilizationRecords.getCustodianNotices() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getCustodianNotices().size() + " custodian notices"));
            for (Object record6 : utilizationRecords.getCustodianNotices()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                FrequentLogUtils.info((String)this.statusMessage.get());
                utilization.replaceCustodianNotice((CustodianNotice)record6);
                newRecordsCount.incrementAndGet();
            }
        }
        if (utilizationRecords.getCustodianActivities() != null) {
            FrequentLogUtils.resetInfo((String)("Loading " + utilizationRecords.getCustodianActivities().size() + " custodian activities"));
            for (Object record6 : utilizationRecords.getCustodianActivities()) {
                this.statusMessage.set(this.iu.getFormattedString("UtilizationResource.Status.Loading", new Object[]{newRecordsCount.get(), existingRecordsCount.get()}));
                try {
                    FrequentLogUtils.info((String)this.statusMessage.get());
                    utilization.addCustodianActivity((CustodianActivity)record6);
                    newRecordsCount.incrementAndGet();
                }
                catch (Exception exception) {}
            }
        }
    }

    private UtilizationRecords getUtilizationRecords() {
        List<OperationSetting> operationSettings;
        List<MimeTypeVolume> mimeTypeVolumes;
        UtilizationDao utilization = this.schedulerApplication.getUtilizationDaoV2();
        UtilizationRecords utilizationRecords = new UtilizationRecords();
        utilizationRecords.setId(UidUtils.getRandom());
        utilizationRecords.setClients(new HashSet<Client>(utilization.getClients()));
        utilizationRecords.setDataRepositories(new HashSet<DataRepository>(utilization.getDataRepositories()));
        utilizationRecords.setDataSets(new HashSet<DataSet>(utilization.getDataSets()));
        utilizationRecords.setTransfers(new HashSet<Transfer>(utilization.getTransfers()));
        utilizationRecords.setTransferVolumes(new HashSet<TransferVolume>(utilization.getTransferVolumes()));
        utilizationRecords.setEngines(new HashSet<Engine>(utilization.getEngines()));
        utilizationRecords.setExecutionProfiles(new HashSet<ExecutionProfile>(utilization.getExecutionProfiles()));
        utilizationRecords.setJobs(new HashSet<Job>(utilization.getJobs()));
        utilizationRecords.setLibraries(new HashSet<Library>(utilization.getLibraries()));
        utilizationRecords.setMatters(new HashSet<Matter>(utilization.getMatters()));
        utilizationRecords.setNuixCases(new HashSet<NuixCase>(utilization.getNuixCases()));
        utilizationRecords.setCollections(new HashSet<com.nuix.automate.utils.utilization.Collection>(utilization.getCollections()));
        utilizationRecords.setCollectionTargets(new HashSet<CollectionTarget>(utilization.getCollectionTargets()));
        utilizationRecords.setLegalHolds(new HashSet<LegalHold>(utilization.getLegalHolds()));
        utilizationRecords.setNotices(new HashSet<Notice>(utilization.getNotices()));
        utilizationRecords.setCustodianNotices(new HashSet<CustodianNotice>(utilization.getCustodianNotices()));
        utilizationRecords.setCustodianActivities(new HashSet<CustodianActivity>(utilization.getCustodianActivities()));
        utilizationRecords.setRelativityWorkspaces(new HashSet<RelativityWorkspace>(utilization.getRelativityWorkspaces()));
        HashMap<String, com.nuix.automate.utils.utilization.Operation> operations = new HashMap<String, com.nuix.automate.utils.utilization.Operation>();
        List<com.nuix.automate.utils.utilization.Operation> utilizationOperations = utilization.getOperations();
        if (utilizationOperations != null) {
            for (com.nuix.automate.utils.utilization.Operation operation : utilizationOperations) {
                operations.put(operation.getOperationId(), operation);
            }
        }
        if ((mimeTypeVolumes = utilization.getMimeTypeVolumes()) != null) {
            for (MimeTypeVolume mimeTypeVolume : mimeTypeVolumes) {
                com.nuix.automate.utils.utilization.Operation operation = (com.nuix.automate.utils.utilization.Operation)operations.get(mimeTypeVolume.getOperationId());
                if (operation == null) continue;
                ArrayList<MimeTypeVolume> operationMimeTypeVolumes = operation.getMimeTypeVolumes();
                if (operationMimeTypeVolumes == null) {
                    operationMimeTypeVolumes = new ArrayList<MimeTypeVolume>();
                    operation.setMimeTypeVolumes(operationMimeTypeVolumes);
                }
                operationMimeTypeVolumes.add(mimeTypeVolume);
            }
        }
        if ((operationSettings = utilization.getOperationSettings()) != null) {
            for (OperationSetting operationSetting : operationSettings) {
                com.nuix.automate.utils.utilization.Operation operation = (com.nuix.automate.utils.utilization.Operation)operations.get(operationSetting.getOperationId());
                if (operation == null) continue;
                ArrayList<OperationSetting> operationOperationSettings = operation.getOperationSettings();
                if (operationOperationSettings == null) {
                    operationOperationSettings = new ArrayList<OperationSetting>();
                    operation.setOperationSettings(operationOperationSettings);
                }
                operationOperationSettings.add(operationSetting);
            }
        }
        utilizationRecords.setOperations(new HashSet<com.nuix.automate.utils.utilization.Operation>(utilizationOperations));
        utilizationRecords.setResourcePools(new HashSet<ResourcePool>(utilization.getResourcePools()));
        utilizationRecords.setServers(new HashSet<Server>(utilization.getServers()));
        utilizationRecords.setSessions(new HashSet<Session>(utilization.getSessions()));
        utilizationRecords.setWorkflows(new HashSet<Workflow>(utilization.getWorkflows()));
        utilizationRecords.setUsers(new HashSet<User>(utilization.getUsers()));
        utilizationRecords.setNuixCaseStats(utilization.getNuixCaseStats());
        utilizationRecords.setActivities(new HashSet<Activity>(utilization.getActivites()));
        AutomateLicenceModel rampivaLicense = this.schedulerApplication.getAutomateLicenceResource().getRampivaLicence();
        for (Session session : utilizationRecords.getSessions()) {
            session.setLicenseId(rampivaLicense.getLicenceInfo().getId());
        }
        License license = new License();
        license.setLicenseName(rampivaLicense.getLicenceInfo().getName());
        license.setLicenseEnvironment(String.valueOf(rampivaLicense.getLicenceInfo().getEnvironment()));
        license.setLicenseId(rampivaLicense.getLicenceInfo().getId());
        license.setOrganizationId(this.getOrgId());
        license.setLicenseIsActive(true);
        HashSet<License> licenses = new HashSet<License>();
        licenses.add(license);
        utilizationRecords.setLicenses(licenses);
        Organization organization = new Organization();
        organization.setOrganizationId(this.getOrgId());
        organization.setOrganizationName(this.getOrgName());
        organization.setOrganizationIsActive(true);
        HashSet<Organization> organizations = new HashSet<Organization>();
        organizations.add(organization);
        utilizationRecords.setOrganizations(organizations);
        return utilizationRecords;
    }

    private String stripBOM(String source) {
        String bom = "\ufeef\ufebb\ufebf";
        if (source.startsWith(bom)) {
            return source.substring(bom.length());
        }
        if (!source.startsWith("{")) {
            return source.substring(1);
        }
        return source;
    }

    private void appendBOM(OutputStream out) throws IOException {
        out.write(65263);
        out.write(65211);
        out.write(65215);
        out.flush();
    }
}

