/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.internal;

import com.nuix.automate.utils.general.PBKDFUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.user.UserAccountPlatform;

public class Credential {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(Credential.class);
    private String username;
    private String password;
    private String email;
    private String hash;
    private String salt;
    private Integer iterations;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean checkPassword(String password) {
        if (this.password != null) {
            return this.password.equals(password);
        }
        String submittedPasswordHash = PBKDFUtils.hashPassword((String)password, (String)this.salt, (int)this.iterations);
        if (submittedPasswordHash.equals(this.hash)) {
            this.password = password;
            return true;
        }
        return false;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getId() {
        return UidUtils.fromString((String)(UidUtils.fromString((String)UserAccountPlatform.INTERNAL.name()) + "_" + this.username)).toString();
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getSalt() {
        return this.salt;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public Integer getIterations() {
        return this.iterations;
    }

    public void setIterations(Integer iterations) {
        this.iterations = iterations;
    }
}

