/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.internal;

import com.nuix.automate.scheduler.security.internal.Credential;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.api.user.UserAccountPlatform;
import com.nuix.automate.utils.models.api.user.UserAccountState;
import java.util.ArrayList;
import java.util.List;

public class InternalCredentialsConfiguration {
    private String displayName;
    private List<Credential> credentials;
    private boolean restrictToLocalhost;
    private boolean usersEligibleLegalHoldAdministrator;
    private boolean usersEligibleLegalHoldCustodian;

    public boolean getRestrictToLocalhost() {
        return this.restrictToLocalhost;
    }

    public void setRestrictToLocalhost(boolean restrictToLocalhost) {
        this.restrictToLocalhost = restrictToLocalhost;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            return "Internal-Testing";
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public List<Credential> getCredentials() {
        return this.credentials;
    }

    public void setCredentials(List<Credential> credentials) {
        this.credentials = credentials;
    }

    public boolean getUsersEligibleLegalHoldAdministrator() {
        return this.usersEligibleLegalHoldAdministrator;
    }

    public void setUsersEligibleLegalHoldAdministrator(boolean usersEligibleLegalHoldAdministrator) {
        this.usersEligibleLegalHoldAdministrator = usersEligibleLegalHoldAdministrator;
    }

    public boolean getUsersEligibleLegalHoldCustodian() {
        return this.usersEligibleLegalHoldCustodian;
    }

    public void setUsersEligibleLegalHoldCustodian(boolean usersEligibleLegalHoldCustodian) {
        this.usersEligibleLegalHoldCustodian = usersEligibleLegalHoldCustodian;
    }

    public List<UserAccount> getUserAccounts() {
        ArrayList<UserAccount> userAccounts = new ArrayList<UserAccount>();
        if (this.credentials != null) {
            for (Credential credential : this.credentials) {
                if (credential.getEmail() == null) continue;
                UserAccount userAccount = new UserAccount();
                userAccount.setEmail(credential.getEmail());
                userAccount.setName(credential.getUsername());
                userAccount.setPlatform(UserAccountPlatform.INTERNAL);
                userAccount.setUserAccountState(UserAccountState.ACTIVE);
                userAccount.setUserServiceId(UidUtils.fromString((String)UserAccountPlatform.INTERNAL.name()).toString());
                userAccount.setId(credential.getId());
                userAccounts.add(userAccount);
            }
        }
        return userAccounts;
    }
}

