/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.ldap;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.internal.user.LdapUserService;
import com.nuix.automate.utils.models.internal.user.UserServiceUser;
import com.nuix.automate.utils.security.policies.IdentifierType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LdapBearerUser
extends BearerUser
implements UserServiceUser {
    private List<String> groupDns;
    private final LdapUserService ldapUserService;

    public LdapBearerUser(String id, String userName, LdapUserService ldapUserService) {
        super(new Identifier(IdentifierType.LDAP_USERNAME, userName));
        this.ldapUserService = ldapUserService;
        this.setId(id);
    }

    public Set<Identifier> getIdentifiers() {
        if (!this.ldapUserService.getEnabled().booleanValue()) {
            return new HashSet<Identifier>();
        }
        Set identifiers = super.getIdentifiers();
        identifiers.add(new Identifier(IdentifierType.LDAP_USERNAME, this.getName()));
        if (this.groupDns != null) {
            for (String group : this.groupDns) {
                identifiers.add(new Identifier(IdentifierType.LDAP_GROUP_DN, group));
            }
        }
        return identifiers;
    }

    public void invalidate() {
    }

    public boolean refresh() {
        return true;
    }

    public List<String> getGroupDns() {
        return this.groupDns;
    }

    public void setGroupDns(List<String> groupDns) {
        this.groupDns = groupDns;
    }

    public String getUserServiceId() {
        if (this.ldapUserService != null) {
            return this.ldapUserService.getId();
        }
        return null;
    }
}

