/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.oidc.generic;

import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.security.oidc.OidcUserServiceClient;
import com.nuix.automate.scheduler.security.oidc.generic.GenericOidcUserServiceClient;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import com.nuix.automate.utils.models.internal.user.OidcUserService;
import com.nuix.automate.utils.models.internal.user.UserServiceUser;
import com.nuix.automate.utils.security.policies.IdentifierType;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class OidcBearerUser
extends BearerUser
implements UserServiceUser {
    Map<String, Object> tokenInfo;
    Map<String, Object> userInfo;
    private String refreshToken;
    private Long expiresIn;
    OidcUserService oidcUserService;
    OidcUserServiceClient oidcUserServiceClient;

    public OidcBearerUser(String id, String username, Map<String, Object> userInfo, OidcUserServiceClient oidcUserServiceClient, OidcUserService oidcUserService, Map<String, Object> tokenInfo) {
        super(new Identifier(IdentifierType.OIDC_USERNAME, username));
        this.oidcUserService = oidcUserService;
        this.oidcUserServiceClient = oidcUserServiceClient;
        this.userInfo = userInfo;
        this.setTokenInfo(tokenInfo);
        this.setId(id);
    }

    public void invalidate() {
    }

    public boolean refresh() {
        return this.oidcUserServiceClient.refresh(this);
    }

    public String getAccessToken() {
        return (String)this.tokenInfo.get("access_token");
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setUserInfo(Map<String, Object> userInfo) {
        this.userInfo = userInfo;
    }

    public void setTokenInfo(Map<String, Object> tokenInfo) {
        this.tokenInfo = tokenInfo;
        if (tokenInfo.containsKey("expires_in")) {
            Object tokenExpiresIn = tokenInfo.get("expires_in");
            this.expiresIn = tokenExpiresIn instanceof Number ? Long.valueOf(((Number)tokenExpiresIn).longValue()) : Long.valueOf(Long.parseLong((String)tokenExpiresIn));
            this.expiresIn = this.expiresIn * 1000L;
        }
        if (tokenInfo.containsKey("refresh_token")) {
            this.refreshToken = (String)tokenInfo.get("refresh_token");
        }
    }

    public Set<Identifier> getIdentifiers() {
        if (!this.oidcUserServiceClient.getOidcUserService().getEnabled().booleanValue()) {
            return new HashSet<Identifier>();
        }
        HashSet<Identifier> identifiers = new HashSet<Identifier>(super.getIdentifiers());
        identifiers.add(new Identifier(IdentifierType.OIDC_USERNAME, this.userInfo.get(this.oidcUserService.getUsernameClaim()).toString().toLowerCase()));
        if (this.oidcUserService.getGroupClaim() != null && this.oidcUserServiceClient instanceof GenericOidcUserServiceClient) {
            GenericOidcUserServiceClient genericOidcUserServiceClient = (GenericOidcUserServiceClient)this.oidcUserServiceClient;
            Set<String> groups = genericOidcUserServiceClient.getGroupsFromClaim(this.oidcUserService.getGroupClaim(), this.userInfo);
            for (String groupName : groups) {
                identifiers.add(new Identifier(IdentifierType.OIDC_GROUP, groupName));
            }
        }
        return identifiers;
    }

    public String getIdToken() {
        return this.tokenInfo.get("id_token").toString();
    }

    public Map<String, Object> getTokenInfo() {
        return this.tokenInfo;
    }

    public String getUserServiceId() {
        return this.oidcUserService.getId();
    }

    public Long getExpiresIn() {
        return this.expiresIn;
    }
}

