/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.oidc.microsoft;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.scheduler.utils.AzureEnv;
import com.nuix.automate.scheduler.utils.AzureEnvironmentUtils;
import com.nuix.automate.utils.models.internal.user.AuthMethodType;
import com.nuix.automate.utils.models.internal.user.MicrosoftOAuthVersion;
import com.nuix.automate.utils.models.internal.user.OidcUserService;
import com.nuix.automate.utils.models.internal.user.UserService;

public class MicrosoftUserService
extends OidcUserService {
    private MicrosoftOAuthVersion oAuthVersion;
    private String environment;
    private String tenant;
    private String eDiscoveryManager;
    private String refreshToken;

    @JsonIgnore
    public AuthMethodType getAuthMethodType() {
        return AuthMethodType.OIDC_MICROSOFT;
    }

    public void update(UserService userServiceUpdate) {
        super.update(userServiceUpdate);
    }

    @JsonIgnore
    public boolean isSameScope(UserService userService) {
        if (!super.isSameScope(userService)) {
            return false;
        }
        if (!(userService instanceof MicrosoftUserService)) {
            return false;
        }
        MicrosoftUserService microsoftUserService = (MicrosoftUserService)userService;
        if (this.environment == null && microsoftUserService.getEnvironment() != null || this.environment != null && !this.environment.equals(microsoftUserService.getEnvironment())) {
            return false;
        }
        return this.tenant == null || this.tenant.equals(microsoftUserService.getTenant());
    }

    @JsonIgnore
    public String getAuthorityUrl() {
        AzureEnv azureEnv = AzureEnvironmentUtils.resolveEnvironmentFromName(this.getEnvironment());
        String authorityUrl = azureEnv.getAuthorityUrl();
        return authorityUrl.endsWith("/") ? authorityUrl : authorityUrl + "/";
    }

    @JsonIgnore
    public String getGraphUrl() {
        AzureEnv azureEnv = AzureEnvironmentUtils.resolveEnvironmentFromName(this.getEnvironment());
        return azureEnv.getGraphUrl();
    }

    public MicrosoftOAuthVersion getoAuthVersion() {
        return this.oAuthVersion;
    }

    public void setoAuthVersion(MicrosoftOAuthVersion oAuthVersion) {
        this.oAuthVersion = oAuthVersion;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getEDiscoveryManager() {
        return this.eDiscoveryManager;
    }

    public void setEDiscoveryManager(String eDiscoveryManager) {
        this.eDiscoveryManager = eDiscoveryManager;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public MicrosoftUserService cloneLimited() {
        MicrosoftUserService limited = new MicrosoftUserService();
        limited.id = this.id;
        limited.name = this.name;
        limited.description = this.description;
        limited.enabled = this.enabled;
        limited.setUserPermissions(this.cloneUserPermissions());
        if (this.status != null) {
            limited.setStatus(this.status.cloneLimited());
        }
        limited.userServiceType = this.userServiceType;
        limited.enableAuthentication = this.enableAuthentication;
        limited.setoAuthVersion(this.oAuthVersion);
        return limited;
    }
}

