/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.thirdparty;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.thirdparty.OidcJwtTokenThirdPartyServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.OidcThirdPartyServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.ThirdPartyServiceSession;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.licence.LicenceUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenseException;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ApiProxyRequest;
import com.nuix.automate.utils.models.api.thirdparty.DerbyControlService;
import com.nuix.automate.utils.models.api.thirdparty.JwtTokenUserCredential;
import com.nuix.automate.workflow.core.utils.derbycontrol.DerbyControlCaseInfo;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Map;

public class DerbyControlServiceSession
extends OidcJwtTokenThirdPartyServiceSession<DerbyControlService> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(DerbyControlServiceSession.class);

    public DerbyControlServiceSession(String userId, DerbyControlService service, JwtTokenUserCredential userCredential, SchedulerApplication schedulerApplication) {
        super(userId, service, userCredential, schedulerApplication);
    }

    public DerbyControlServiceSession(OidcThirdPartyServiceSession<DerbyControlService, JwtTokenUserCredential> thirdPartySession) {
        super(thirdPartySession);
    }

    @Override
    public void assertInstanceLicensed() throws LicenseException {
        LicenceInfo licenseInfo = SchedulerApplication.getInstance().getLicenceUtils().assertLicenceInfo();
        LicenceUtils licenceUtils = new LicenceUtils(licenseInfo);
        licenceUtils.assertModuleLicensed(ModuleType.NEO_MANAGEMENT, false);
    }

    @Override
    public Object proxy(ApiProxyRequest apiProxyRequest) throws IOException {
        Entity requestBody;
        this.refreshInvalidToken();
        if (apiProxyRequest.getBody() != null) {
            if (apiProxyRequest.getBody() instanceof DerbyControlCaseInfo) {
                requestBody = Entity.json((Object)apiProxyRequest.getBody());
            } else {
                try {
                    DerbyControlCaseInfo derbyControlCaseInfo = (DerbyControlCaseInfo)SerializationUtils.fromJson((String)SerializationUtils.toJson((Object)apiProxyRequest.getBody()), DerbyControlCaseInfo.class);
                    requestBody = Entity.json((Object)derbyControlCaseInfo);
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot deserialize " + apiProxyRequest.getBody().getClass().getSimpleName() + " as DerbyControlCaseInfo", (Throwable)e);
                    throw new IOException("Unexpected body type " + apiProxyRequest.getBody().getClass().getSimpleName());
                }
            }
        } else {
            throw new IOException("Missing proxy request body");
        }
        try (Response response = this.callApiResponse(((DerbyControlService)this.service).getUrl() + "/svc/derbyServers", "POST", requestBody, 201);){
            LOGGER.info("Derby Control service response " + response.getStatus());
        }
        return null;
    }

    @Override
    protected String testService(Map<String, Object> values) throws Exception {
        this.refreshToken();
        DerbyControlCaseInfo derbyControlCaseInfo = new DerbyControlCaseInfo("automate-connectivity-test", ".");
        try (Response response = this.callApiResponse(((DerbyControlService)this.service).getUrl() + "/svc/derbyServers", "POST", Entity.json((Object)derbyControlCaseInfo), 201);){
            LOGGER.info("Test Derby Control service response " + response.getStatus());
        }
        return null;
    }

    @Override
    public ThirdPartyServiceSession<DerbyControlService, JwtTokenUserCredential> clone() {
        return new DerbyControlServiceSession(this);
    }
}

