/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.thirdparty;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.thirdparty.ThirdPartyServiceSession;
import com.nuix.automate.scheduler.workers.MemgraphWorker;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.licence.LicenceUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenseException;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.models.api.thirdparty.ApiProxyRequest;
import com.nuix.automate.utils.models.api.thirdparty.GraphService;
import com.nuix.automate.utils.models.api.thirdparty.GraphUserCredential;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.workflow.core.utils.memgraph.MemgraphClient;
import com.nuix.automate.workflow.core.utils.memgraph.MemgraphJobInfo;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class GraphServiceSession
extends ThirdPartyServiceSession<GraphService, GraphUserCredential> {
    private MemgraphClient memgraphClient;

    public GraphServiceSession(String userId, GraphService graphService, GraphUserCredential userCredential, SchedulerApplication schedulerApplication) {
        super(userId, graphService, userCredential, schedulerApplication);
    }

    public GraphServiceSession(GraphServiceSession client) {
        super(client);
        this.memgraphClient = null;
    }

    public MemgraphClient getClient() {
        return this.memgraphClient;
    }

    @Override
    public String getLogKey() {
        return "logApiGraph";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object proxy(ApiProxyRequest apiProxyRequest) {
        MemgraphWorker memgraphWorker;
        MemgraphJobInfo memgraphJobInfo = (MemgraphJobInfo)SerializationUtils.fromJson((String)SerializationUtils.toJson((Object)apiProxyRequest.getBody()), MemgraphJobInfo.class);
        String jobId = memgraphJobInfo.getJobId();
        MemgraphWorker memgraphWorker2 = memgraphWorker = SchedulerApplication.getInstance().getMemgraphWorker();
        synchronized (memgraphWorker2) {
            if (memgraphJobInfo.getExecutionState().equals((Object)ExecutionState.NOT_STARTED)) {
                return memgraphWorker.getJobsInFront(jobId);
            }
            memgraphWorker.trackFinishedJob(jobId);
            return 0;
        }
    }

    @Override
    protected String testService(Map<String, Object> values) throws Exception {
        if (this.memgraphClient == null) {
            throw new IOException("Service is not enabled");
        }
        return this.memgraphClient.test((GraphUserCredential)this.userCredential);
    }

    @Override
    public boolean refreshToken() {
        try {
            this.testService();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    protected void startSession(LogChannel logChannel, Set<String> whitelistedCertFingerprints) throws Exception {
        this.memgraphClient = new MemgraphClient(((GraphService)this.service).getUrl());
    }

    @Override
    protected void closeSession() {
        if (this.memgraphClient != null) {
            this.memgraphClient.close();
        }
    }

    @Override
    public GraphServiceSession clone() {
        return new GraphServiceSession(this);
    }

    @Override
    public void assertInstanceLicensed() throws LicenseException {
        LicenceInfo licenseInfo = SchedulerApplication.getInstance().getLicenceUtils().assertLicenceInfo();
        LicenceUtils licenceUtils = new LicenceUtils(licenseInfo);
        licenceUtils.assertModuleLicensed(ModuleType.KNOWLEDGE_GRAPH, false);
    }
}

