/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.thirdparty;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.thirdparty.OidcJwtTokenThirdPartyServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.OidcThirdPartyServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.ThirdPartyServiceSession;
import com.nuix.automate.utils.licence.LicenceUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenseException;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ApiProxyRequest;
import com.nuix.automate.utils.models.api.thirdparty.InvestigateService;
import com.nuix.automate.utils.models.api.thirdparty.JwtTokenUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyServiceDefinition;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyServiceType;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InvestigateServiceSession
extends OidcJwtTokenThirdPartyServiceSession<InvestigateService> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(InvestigateServiceSession.class);

    public InvestigateServiceSession(String userId, InvestigateService service, JwtTokenUserCredential userCredential, SchedulerApplication schedulerApplication) {
        super(userId, service, userCredential, schedulerApplication);
    }

    public InvestigateServiceSession(OidcThirdPartyServiceSession<InvestigateService, JwtTokenUserCredential> thirdPartySession) {
        super(thirdPartySession);
    }

    @Override
    public ThirdPartyServiceSession<InvestigateService, JwtTokenUserCredential> clone() {
        return new InvestigateServiceSession(this);
    }

    @Override
    public Object proxy(ApiProxyRequest apiProxyRequest) throws IOException {
        this.refreshInvalidToken();
        Entity requestBody = apiProxyRequest.getBody() != null ? Entity.json((Object)apiProxyRequest.getBody()) : Entity.json(new HashMap());
        return this.callApiResponse(((InvestigateService)this.service).getServiceUrlOrUrl() + "/" + apiProxyRequest.getEndpoint(), apiProxyRequest.getMethod(), requestBody, apiProxyRequest.getExpectedStatus(), true);
    }

    @Override
    protected String testService(Map<String, Object> values) throws Exception {
        this.refreshToken();
        try (Response response = this.callApiResponse(((InvestigateService)this.service).getServiceUrlOrUrl() + "/svc/authenticatedUser", "GET", null, 200);){
            LOGGER.info("Test Investigate service response " + response.getStatus());
        }
        return null;
    }

    @Override
    public List<ThirdPartyServiceDefinition> getServicesDefinition(String bearerToken) {
        ArrayList<ThirdPartyServiceDefinition> serviceDefinitions = new ArrayList<ThirdPartyServiceDefinition>();
        ThirdPartyServiceDefinition investigateServiceDefinition = new ThirdPartyServiceDefinition(ThirdPartyServiceType.NUIX_INVESTIGATE, ((InvestigateService)this.service).getName());
        investigateServiceDefinition.setConfigured(true);
        investigateServiceDefinition.setUrl(((InvestigateService)this.service).getUrl());
        serviceDefinitions.add(investigateServiceDefinition);
        investigateServiceDefinition.setConnected(this.getConnected());
        return serviceDefinitions;
    }

    private boolean testUrlAccess(String url, String bearerToken) {
        if (bearerToken != null) {
            try {
                LOGGER.info("Testing URL " + url + " with access token");
                if (this.client == null) {
                    this.initialize();
                }
                WebTarget webTarget = this.client.target(url);
                Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + bearerToken));
                Response response = invocationBuilder.get();
                LOGGER.info("Received " + String.valueOf(response.getStatusInfo()));
                if (response.getStatusInfo().getFamily().equals((Object)Response.Status.Family.SUCCESSFUL)) {
                    return true;
                }
            }
            catch (Exception e) {
                LOGGER.info("Cannot test URL " + url + " access with token", (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public void assertInstanceLicensed() throws LicenseException {
        LicenceInfo licenseInfo = SchedulerApplication.getInstance().getLicenceUtils().assertLicenceInfo();
        LicenceUtils licenceUtils = new LicenceUtils(licenseInfo);
        licenceUtils.assertModuleLicensed(ModuleType.NEO_MANAGEMENT, false);
    }
}

