/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.thirdparty;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.thirdparty.OidcThirdPartyServiceSession;
import com.nuix.automate.scheduler.workers.OidcWellKnownConfigurationWorker;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.JwtUtils;
import com.nuix.automate.utils.general.TimeUtils;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.JwtTokenUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.UserCredential;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Base64;
import java.util.Map;
import java.util.Set;

public abstract class OidcJwtTokenThirdPartyServiceSession<T1 extends ThirdPartyService>
extends OidcThirdPartyServiceSession<T1, JwtTokenUserCredential> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(OidcJwtTokenThirdPartyServiceSession.class);

    public OidcJwtTokenThirdPartyServiceSession(String userId, T1 service, JwtTokenUserCredential userCredential, SchedulerApplication schedulerApplication) {
        super(userId, service, userCredential, schedulerApplication);
        this.reattemptEnabled = false;
    }

    public OidcJwtTokenThirdPartyServiceSession(OidcThirdPartyServiceSession<T1, JwtTokenUserCredential> thirdPartySession) {
        super(thirdPartySession);
        this.reattemptEnabled = false;
    }

    private String getToken() {
        if (this.userService == null) {
            throw new IllegalStateException("Authentication Service is not available");
        }
        if (!this.userService.getEnabled().booleanValue()) {
            throw new IllegalStateException("Authentication Service is not enabled");
        }
        OidcWellKnownConfigurationWorker oidcServiceWorker = this.schedulerApplication.getUserServiceResource().getOidcWellKnownConfigurationWorker(this.userService.getId());
        if (oidcServiceWorker == null) {
            throw new IllegalStateException("Authentication Service is not available");
        }
        Map<String, Object> wellKnownConfiguration = oidcServiceWorker.getWellKnownConfiguration();
        if (wellKnownConfiguration == null || wellKnownConfiguration.size() == 0) {
            throw new IllegalStateException("Authentication Service invalid well-known configuration");
        }
        Object tokenEndpointObject = oidcServiceWorker.getWellKnownConfiguration().get("token_endpoint");
        if (tokenEndpointObject == null) {
            throw new IllegalStateException("Authentication Service invalid token endpoint");
        }
        try {
            String tokenEndpoint = tokenEndpointObject.toString();
            String basicAuthCredentials = Base64.getEncoder().encodeToString((this.userService.getClientId() + ":" + this.userService.getClientSecret()).getBytes(StandardCharsets.UTF_8));
            MultivaluedHashMap formData = new MultivaluedHashMap();
            formData.add((Object)"grant_type", (Object)"client_credentials");
            formData.add((Object)"scope", (Object)this.userService.getScope());
            Response response = this.client.target(tokenEndpoint).request(new String[]{"application/json"}).header("Authorization", (Object)("Basic " + basicAuthCredentials)).post(Entity.form((MultivaluedMap)formData));
            if (response.getStatus() != 200) {
                String error = (String)response.readEntity(String.class);
                throw new IOException("Post Token Endpoint with Code HTTP/" + response.getStatus() + " " + error);
            }
            Map responseMap = (Map)response.readEntity(Map.class);
            Object token = responseMap.get("access_token");
            if (token == null) {
                token = responseMap.get("id_token");
            }
            return token.toString();
        }
        catch (Exception e) {
            throw new IllegalStateException("Authentication Service error", e);
        }
    }

    public JwtTokenUserCredential createOidcClientCredential() {
        String token = this.getToken();
        JwtTokenUserCredential clientUserCredential = new JwtTokenUserCredential();
        this.setCredentialsPropertiesFromToken((UserCredential)clientUserCredential, token);
        return clientUserCredential;
    }

    private void setCredentialsPropertiesFromToken(UserCredential userCredential, String token) {
        userCredential.setToken(token);
        Map claims = JwtUtils.getTokenClaimsNoVerify((String)token);
        Object sub = claims.get("sub");
        if (sub != null) {
            userCredential.setUsername(sub.toString());
            LOGGER.info(this.getClass().getSimpleName().toString() + " token sub " + String.valueOf(sub));
        }
        userCredential.setTokenExpiryDate(Long.valueOf(TimeUtils.getEpochWithNanos((long)((Number)claims.get("exp")).longValue())));
    }

    @Override
    protected synchronized void refreshToken(UserCredential userCredential) throws IOException {
        String token = this.getToken();
        this.setCredentialsPropertiesFromToken(userCredential, token);
    }

    protected void refreshInvalidToken() throws IOException {
        if (((JwtTokenUserCredential)this.userCredential).getToken() == null || ((JwtTokenUserCredential)this.userCredential).getExpired()) {
            this.logger.reset();
            try {
                this.refreshToken((UserCredential)this.userCredential);
            }
            catch (Exception e) {
                this.logger.addError(ExceptionUtils.getExceptionPrintableMessage((Throwable)e));
            }
        }
    }

    @Override
    protected void startSession(LogChannel logChannel, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        this.logChannel = logChannel;
        this.client = DropwizardRestClientFactory.getClientWithWhitelistValidation((String)this.getClientName(), whitelistedCertFingerprints, (AutomateApplication)this.schedulerApplication, (AutomateConfiguration)this.schedulerApplication.getConfiguration());
    }

    @Override
    protected void closeSession() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Override
    protected void updateExpiryWarning() {
    }
}

