/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.thirdparty;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.thirdparty.ThirdPartyServiceSession;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.licence.LicenceUtils;
import com.nuix.automate.utils.licence.ModuleType;
import com.nuix.automate.utils.licence.exceptions.LicenseException;
import com.nuix.automate.utils.licence.services.LicenceInfo;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.SemanticService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.workflow.core.utils.semantic.SemanticClient;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;
import java.util.Set;

public class SemanticServiceSession
extends ThirdPartyServiceSession<SemanticService, ThirdPartyUserCredential> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SemanticServiceSession.class);
    private SemanticClient semanticClient;

    public SemanticServiceSession(String userId, SemanticService semanticService, ThirdPartyUserCredential userCredential, SchedulerApplication schedulerApplication) {
        super(userId, semanticService, userCredential, schedulerApplication);
    }

    public SemanticServiceSession(SemanticServiceSession client) {
        super(client);
    }

    @Override
    public void assertInstanceLicensed() throws LicenseException {
        LicenceInfo licenseInfo = SchedulerApplication.getInstance().getLicenceUtils().assertLicenceInfo();
        LicenceUtils licenceUtils = new LicenceUtils(licenseInfo);
        licenceUtils.assertModuleLicensed(ModuleType.NEO_MANAGEMENT, false);
    }

    @Override
    protected String testService(Map<String, Object> values) throws Exception {
        if (this.semanticClient == null || this.closed) {
            this.initialize(true);
        }
        return this.semanticClient.test();
    }

    @Override
    protected void startSession(LogChannel logChannel, Set<String> whitelistedCertFingerprints) throws GeneralSecurityException {
        this.logChannel = logChannel;
        SchedulerApplication schedulerApplication = SchedulerApplication.getInstance();
        this.client = DropwizardRestClientFactory.getClientWithWhitelistValidation((String)this.getClientName(), whitelistedCertFingerprints, (AutomateApplication)schedulerApplication, (AutomateConfiguration)schedulerApplication.getConfiguration());
        this.semanticClient = new SemanticClient(this.getClientName(), ((SemanticService)this.service).getUrl(), whitelistedCertFingerprints);
    }

    @Override
    protected void closeSession() {
        if (this.semanticClient != null) {
            try {
                this.semanticClient.close();
            }
            catch (IOException e) {
                LOGGER.error("Cannot close client", (Throwable)e);
            }
        }
    }

    @Override
    public SemanticServiceSession clone() {
        return new SemanticServiceSession(this);
    }
}

