/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.thirdparty;

import au.com.bytecode.opencsv.CSVWriter;
import com.google.gson.JsonObject;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.persistance.application.ApplicationDao;
import com.nuix.automate.scheduler.security.thirdparty.OidcThirdPartyServiceSession;
import com.nuix.automate.scheduler.security.thirdparty.ThirdPartyServiceSession;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.general.EmailUtils;
import com.nuix.automate.utils.general.FileUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.ThreadPoolUtils;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.licence.exceptions.LicenseException;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.smtp.EmailState;
import com.nuix.automate.utils.models.api.smtp.EmailType;
import com.nuix.automate.utils.models.api.smtp.SmtpEmail;
import com.nuix.automate.utils.models.api.smtp.SmtpEmailCounter;
import com.nuix.automate.utils.models.api.smtp.SmtpEmailExportOptions;
import com.nuix.automate.utils.models.api.smtp.SmtpServiceAction;
import com.nuix.automate.utils.models.api.smtp.SmtpServiceActionOptions;
import com.nuix.automate.utils.models.api.smtp.SmtpServiceObjectType;
import com.nuix.automate.utils.models.api.thirdparty.ActionRequest;
import com.nuix.automate.utils.models.api.thirdparty.ApiProxyRequest;
import com.nuix.automate.utils.models.api.thirdparty.SmtpService;
import com.nuix.automate.utils.models.api.thirdparty.SmtpUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyRestException;
import com.nuix.automate.utils.models.internal.cache.CachedObjectMap;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import com.nuix.automate.utils.ui.IconType;
import com.nuix.automate.utils.ui.Icons;
import com.nuix.automate.utils.ui.PngIcon;
import com.nuix.automate.workflow.core.execution.workflow.Workflow;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.activation.URLDataSource;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import jakarta.ws.rs.client.Entity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class SmtpServiceSession
extends OidcThirdPartyServiceSession<SmtpService, SmtpUserCredential> {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(SmtpServiceSession.class);
    public static final String SYSTEM_USER_ID = UidUtils.fromString((String)"SYSTEM_SMTP_EMAIL_USER");
    public static final String SYSTEM_LEGAL_HOLD_USER_ID = UidUtils.fromString((String)"SYSTEM_LEGAL_HOLD_USER");
    private static final CachedObjectMap<SmtpEmailCounter> initiatorEmailCounters = new CachedObjectMap(90000L);
    private final SchedulerApplication schedulerApplication;
    private final Map<String, Future<SmtpEmail>> pendingSubmissions;
    private ThreadPoolExecutor workerPool;
    private Session session;

    public SmtpServiceSession(String userId, SmtpService smtpService, SmtpUserCredential userCredential, SchedulerApplication schedulerApplication) {
        super(userId, smtpService, userCredential, schedulerApplication);
        this.schedulerApplication = schedulerApplication;
        this.pendingSubmissions = new ConcurrentHashMap<String, Future<SmtpEmail>>();
        ((SmtpService)this.service).setEmailCounter(SmtpServiceSession.buildEmailCounter(null, ((SmtpService)this.service).getId()));
    }

    public SmtpServiceSession(SmtpServiceSession client) {
        super(client);
        this.schedulerApplication = client.schedulerApplication;
        this.pendingSubmissions = new ConcurrentHashMap<String, Future<SmtpEmail>>();
    }

    public Future<SmtpEmail> submitEmail(SmtpEmail smtpEmail) {
        return this.pendingSubmissions.computeIfAbsent(smtpEmail.getId(), id -> this.submit(smtpEmail));
    }

    private Future<SmtpEmail> submit(SmtpEmail smtpEmail) {
        SmtpServiceSession.getOrComputeInitiatorEmailCounter(smtpEmail.getInitiatorId()).trackSubmit(smtpEmail);
        ((SmtpService)this.service).getEmailCounter().trackSubmit(smtpEmail);
        this.prepareEmail(smtpEmail);
        SmtpServiceSession.resetInitiatorCache(smtpEmail);
        return this.workerPool.submit(() -> {
            try {
                if (smtpEmail.getState() == EmailState.PENDING) {
                    this.sendEmail(smtpEmail);
                } else {
                    LOGGER.error("SMTP Email not sent due to state: " + String.valueOf(smtpEmail.getState()) + ", " + smtpEmail.getStatus().getMessage());
                }
            }
            catch (Exception e) {
                LOGGER.error("Error sending email: " + smtpEmail.getId(), (Throwable)e);
                String errorMessage = iu.getFormattedString("SmtpServiceSession.Error.ErrorSendingSmtpEmail", (Object)e);
                this.logger.addError(errorMessage, false);
                smtpEmail.getStatus().setError(errorMessage);
                smtpEmail.setState(EmailState.ERROR);
            }
            this.pendingSubmissions.remove(smtpEmail.getId());
            this.schedulerApplication.getSchedulerConfigurationDao().updateSmtpEmail(smtpEmail);
            SmtpServiceSession.getOrComputeInitiatorEmailCounter(smtpEmail.getInitiatorId()).trackComplete(smtpEmail);
            ((SmtpService)this.service).getEmailCounter().trackComplete(smtpEmail);
            SmtpServiceSession.resetInitiatorCache(smtpEmail);
            return smtpEmail;
        });
    }

    private void prepareEmail(SmtpEmail smtpEmail) {
        smtpEmail.setSmtpServerId(((SmtpService)this.service).getId());
        smtpEmail.setSubmittedUserId(this.userId);
        smtpEmail.setFrom(((SmtpService)this.service).getFrom());
        if (Boolean.FALSE.equals(((SmtpService)this.service).getEnabled())) {
            smtpEmail.getStatus().setError(iu.getString("SmtpServiceSession.Error.SmtpServiceIsDisabled"));
            smtpEmail.setState(EmailState.ERROR);
        } else if (!this.getSignedIn()) {
            smtpEmail.getStatus().setError(iu.getString("SmtpServiceSession.Error.SmtpServiceNotSignedIn"));
            smtpEmail.setState(EmailState.ERROR);
        } else {
            Integer maxAttempts = ((SmtpService)this.service).getEmailMaxAttempts();
            if (maxAttempts == null) {
                maxAttempts = this.schedulerApplication.getConfiguration().getSmtpServiceEmailMaxAttempts();
            }
            if (smtpEmail.getAttempts() < maxAttempts) {
                smtpEmail.incrementAttempts();
                smtpEmail.setState(EmailState.PENDING);
            } else {
                smtpEmail.setState(EmailState.PURGED);
            }
        }
        if (this.schedulerApplication.getSchedulerConfigurationDao().updateSmtpEmail(smtpEmail) == 0) {
            this.schedulerApplication.getSchedulerConfigurationDao().addSmtpEmail(smtpEmail);
        }
    }

    @Override
    public Map<String, String> handleAction(ActionRequest<String> actionRequest) {
        SmtpServiceActionOptions actionOptions = (SmtpServiceActionOptions)SerializationUtils.fromJson((String)SerializationUtils.toJson((Object)actionRequest.getBody()), SmtpServiceActionOptions.class);
        actionOptions.normalize(((SmtpService)this.service).getId());
        SmtpServiceAction action = SmtpServiceAction.valueOf((String)((String)actionRequest.getAction()));
        HashMap<String, String> result = new HashMap<String, String>();
        switch (action) {
            case RESUBMIT_FAILED: {
                List<SmtpEmail> smtpEmails = this.schedulerApplication.getSchedulerConfigurationDao().getSmtpEmails(actionOptions.getInitiatorId(), actionOptions.getSmtpServiceId(), EmailState.ERROR);
                smtpEmails.forEach(this::submitEmail);
                this.logger.addLog(iu.getNumeralString(this.getTranslationKey("Log.ResubmittedSmtpEmails"), (long)smtpEmails.size()));
                result.put("count", String.valueOf(smtpEmails.size()));
                break;
            }
            case PURGE_FAILED: {
                int updated = this.schedulerApplication.getSchedulerConfigurationDao().changeEmailStateFromTo(actionOptions.getInitiatorId(), actionOptions.getSmtpServiceId(), EmailState.ERROR, EmailState.PURGED);
                initiatorEmailCounters.clear();
                ((SmtpService)this.service).setEmailCounter(SmtpServiceSession.buildEmailCounter(null, ((SmtpService)this.service).getId()));
                this.logger.addLog(iu.getNumeralString(this.getTranslationKey("Log.PurgedSmtpEmails"), (long)updated));
                result.put("count", String.valueOf(updated));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid SMTP Service action: " + String.valueOf(action));
            }
        }
        return result;
    }

    @Override
    public Object getObjects(String serviceObjectType, Map<String, Object> parameters) {
        SmtpServiceObjectType objectType = SmtpServiceObjectType.valueOf((String)serviceObjectType);
        String initiatorId = (String)parameters.get("initiatorId");
        switch (objectType) {
            case EMAIL_COUNTER: {
                if (initiatorId != null && !initiatorId.trim().isEmpty()) {
                    return SmtpServiceSession.getOrComputeInitiatorEmailCounter(initiatorId);
                }
                return ((SmtpService)this.service).getEmailCounter();
            }
        }
        throw new IllegalArgumentException("Invalid object type: " + String.valueOf(objectType));
    }

    @Override
    protected String testService(Map<String, Object> values) throws Exception {
        if (!((SmtpService)this.getService()).usingOidcAuthenticationMethod()) {
            if (this.session == null) {
                throw new IllegalStateException(iu.getFormattedString("ThirdPartySession.Error.SessionNotActive", new Object[0]));
            }
            try (Transport transport = this.session.getTransport();){
                transport.connect();
            }
        } else if (this.client == null) {
            throw new IllegalStateException(iu.getFormattedString("ThirdPartySession.Error.SessionNotActive", new Object[0]));
        }
        if (values != null) {
            String to = (String)values.get("to");
            String submittedBy = (String)values.get("submittedBy");
            SmtpEmail smtpEmail = new SmtpEmail(((SmtpService)this.service).getId(), ((SmtpService)this.service).getId());
            smtpEmail.setType(EmailType.TEST);
            smtpEmail.setFrom(((SmtpService)this.service).getFrom());
            smtpEmail.setTo(to);
            smtpEmail.setSubject("Automate SMTP Server Test");
            String emailDescription = iu.getFormattedString("SmtpServiceSession.Log.SmtpTestEmailDescription", (Object)((SmtpService)this.service).getName());
            smtpEmail.setHtmlFormat(Boolean.valueOf(true));
            smtpEmail.setMessage(smtpEmail.buildTemplateHtmlMessage(submittedBy, emailDescription, null));
            this.sendEmail(smtpEmail);
        }
        return null;
    }

    @Override
    public void exportAsCsv(CSVWriter csvWriter, String optionsJson) {
        SmtpEmailExportOptions exportOptions = (SmtpEmailExportOptions)SerializationUtils.fromJson((String)optionsJson, SmtpEmailExportOptions.class);
        exportOptions.normalize(((SmtpService)this.service).getId());
        HashSet<String> states = new HashSet<String>();
        if (exportOptions.getStates() != null) {
            for (EmailState state : exportOptions.getStates()) {
                states.add(state.name());
            }
        }
        if (states.isEmpty()) {
            states.add("__EMPTY_LIST_SENTINEL__");
        }
        List<SmtpEmail> smtpEmails = this.schedulerApplication.getSchedulerConfigurationDao().getSmtpEmails(exportOptions.getInitiatorId(), exportOptions.getSmtpServiceId(), states, exportOptions.getBeforeDate(), exportOptions.getAfterDate());
        DateTimeFormatter excelDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.of("UTC"));
        String[] headerKeys = new String[]{"Id", "Type", "InitiatorId", "InitiatorType", "CreatedDate", "SentDate", "Subject", "From", "To", "Cc", "Bcc", "State", "ErrorStatus"};
        CharSequence[] headers = new String[headerKeys.length];
        for (int i = 0; i < headerKeys.length; ++i) {
            headers[i] = iu.getString("SmtpServiceSession.ExportColumn." + headerKeys[i]);
        }
        LOGGER.info("Writing SMTP service CSV export headers: " + String.join((CharSequence)", ", headers));
        csvWriter.writeNext((String[])headers);
        for (SmtpEmail smtpEmail : smtpEmails) {
            Status emailStatus;
            String[] values = new String[]{smtpEmail.getId(), "", "", "", excelDateTimeFormatter.format(Instant.ofEpochMilli(smtpEmail.getCreatedDate())), "", smtpEmail.getSubject(), smtpEmail.getFrom(), smtpEmail.getTo(), "", "", smtpEmail.getState().toLocalizedString(), ""};
            if (smtpEmail.getType() != null) {
                values[1] = smtpEmail.getType().toLocalizedString();
            }
            if (smtpEmail.getInitiatorId() != null) {
                values[2] = smtpEmail.getInitiatorId();
            }
            if (smtpEmail.getInitiatorType() != null) {
                values[3] = smtpEmail.getInitiatorType().toLocalizedString();
            }
            if (smtpEmail.getSentDate() != null) {
                values[5] = excelDateTimeFormatter.format(Instant.ofEpochMilli(smtpEmail.getSentDate()));
            }
            if (smtpEmail.getCc() != null) {
                values[9] = smtpEmail.getCc();
            }
            if (smtpEmail.getBcc() != null) {
                values[10] = smtpEmail.getBcc();
            }
            if (State.ERROR.equals((Object)(emailStatus = smtpEmail.getStatus()).getCode())) {
                values[12] = excelDateTimeFormatter.format(Instant.ofEpochMilli(emailStatus.getLastUpdatedDate())) + ":\n" + emailStatus.getMessage();
            }
            csvWriter.writeNext(values);
        }
    }

    @Override
    protected void startSession(LogChannel logChannel, Set<String> whitelistedCertFingerprints) throws Exception {
        int poolSize = Math.max(ThreadPoolUtils.RUNTIME_AVAILABLE_PROCESSORS, this.schedulerApplication.getConfiguration().getSmtpServiceMaxThreadCount());
        this.workerPool = ThreadPoolUtils.createTimeoutThreadPool((String)("SMTPServicePool: " + ((SmtpService)this.service).getName()), (int)poolSize, (int)30);
        if (!((SmtpService)this.getService()).usingOidcAuthenticationMethod()) {
            this.session = this.createSmtpSession();
        }
        this.pendingSubmissions.clear();
        this.logChannel = logChannel;
        this.client = DropwizardRestClientFactory.getClientWithWhitelistValidation((String)this.getClientName(), whitelistedCertFingerprints, (AutomateApplication)this.schedulerApplication, (AutomateConfiguration)this.schedulerApplication.getConfiguration());
    }

    @Override
    protected void closeSession() {
        if (this.workerPool != null) {
            this.workerPool.shutdownNow();
        }
        if (this.client != null) {
            this.client.close();
        }
        this.pendingSubmissions.clear();
        this.workerPool = null;
        this.session = null;
    }

    @Override
    public void assertInstanceLicensed() throws LicenseException {
    }

    @Override
    public ThirdPartyServiceSession<SmtpService, SmtpUserCredential> clone() {
        return new SmtpServiceSession(this);
    }

    public static SmtpEmailCounter getInitiatorEmailCounter(String initiatorId) {
        if (initiatorId != null) {
            return SmtpServiceSession.getOrComputeInitiatorEmailCounter(initiatorId);
        }
        return null;
    }

    private static SmtpEmailCounter getOrComputeInitiatorEmailCounter(String initiatorId) {
        return (SmtpEmailCounter)initiatorEmailCounters.computeIfAbsent(initiatorId, key -> SmtpServiceSession.buildEmailCounter(key, null));
    }

    private static SmtpEmailCounter buildEmailCounter(String initiatorId, String smtpServiceId) {
        ApplicationDao configurationDao = SchedulerApplication.getInstance().getSchedulerConfigurationDao();
        SmtpEmailCounter emailCounter = new SmtpEmailCounter(initiatorId);
        emailCounter.setPendingEmailCount((long)configurationDao.getSmtpEmailStateCount(initiatorId, smtpServiceId, EmailState.PENDING));
        emailCounter.setSentEmailCount((long)configurationDao.getSmtpEmailStateCount(initiatorId, smtpServiceId, EmailState.SENT));
        emailCounter.setErrorEmailCount((long)configurationDao.getSmtpEmailStateCount(initiatorId, smtpServiceId, EmailState.ERROR));
        emailCounter.setPurgedEmailCount((long)configurationDao.getSmtpEmailStateCount(initiatorId, smtpServiceId, EmailState.PURGED));
        return emailCounter;
    }

    private static void resetInitiatorCache(SmtpEmail smtpEmail) {
        String initiatorId = smtpEmail.getInitiatorId();
        if (initiatorId != null && smtpEmail.getInitiatorType() != null) {
            switch (smtpEmail.getInitiatorType()) {
                case LEGAL_HOLD: {
                    ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLD, initiatorId);
                    ResponseCache.getInstance().resetKeyId(CacheKey.LEGAL_HOLDS, "");
                    break;
                }
                case NOTIFICATION_RULE: {
                    ResponseCache.getInstance().resetKeyId(CacheKey.NOTIFICATION_RULES, initiatorId);
                    ResponseCache.getInstance().resetKeyId(CacheKey.NOTIFICATION_RULES, "");
                }
            }
        } else {
            ResponseCache.getInstance().resetKeyId(CacheKey.THIRD_PARTY_SERVICES, smtpEmail.getSmtpServerId());
            ResponseCache.getInstance().resetKeyId(CacheKey.THIRD_PARTY_SERVICES, "");
        }
    }

    @Override
    public Object proxy(ApiProxyRequest apiProxyRequest) throws IOException {
        Status status = new Status();
        status.resetOk();
        if (apiProxyRequest != null && apiProxyRequest.getEndpoint().equals("/sendEmail")) {
            String json = SerializationUtils.toJson((Object)apiProxyRequest.getBody());
            SmtpEmail message = (SmtpEmail)SerializationUtils.fromJson((String)json, SmtpEmail.class);
            try {
                this.sendEmail(message);
            }
            catch (MessagingException e) {
                LOGGER.error("Failed to send email", (Throwable)e);
                status.setError(e.getMessage());
                return status;
            }
        }
        return status;
    }

    private void sendEmail(SmtpEmail smtpEmail) throws MessagingException {
        String[] recipientsTo;
        LOGGER.info("Sending email: " + smtpEmail.getId());
        MimeMessage message = new MimeMessage(this.session);
        message.setFrom((Address)new InternetAddress(smtpEmail.getFrom()));
        for (String to : recipientsTo = smtpEmail.getTo().split(";")) {
            if (to.trim().isEmpty()) continue;
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to.trim()));
        }
        if (smtpEmail.getCc() != null) {
            String[] recipientsCc;
            for (String cc : recipientsCc = smtpEmail.getCc().split(";")) {
                if (cc.trim().isEmpty()) continue;
                message.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(cc.trim()));
            }
        }
        if (smtpEmail.getBcc() != null) {
            String[] recipientsBcc;
            for (String bcc : recipientsBcc = smtpEmail.getBcc().split(";")) {
                if (bcc.trim().isEmpty()) continue;
                message.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bcc.trim()));
            }
        }
        message.setSubject(smtpEmail.getSubject());
        if (smtpEmail.getMessage() == null) {
            smtpEmail.setMessage("");
        }
        MimeMultipart mainMultipart = new MimeMultipart();
        MimeBodyPart bodyPart = new MimeBodyPart();
        if (Boolean.TRUE.equals(smtpEmail.getHtmlFormat())) {
            MimeMultipart htmlMultipart = new MimeMultipart("related");
            String emailMessage = smtpEmail.getMessage();
            ArrayList<IconType> iconsInMessage = new ArrayList<IconType>();
            boolean containsLogoIcon = emailMessage.contains("src=\"LOGO\"");
            if (containsLogoIcon) {
                emailMessage = emailMessage.replace("src=\"LOGO\"", "src=\"cid:automate-LOGO\"");
            }
            for (IconType iconType : IconType.values()) {
                String iconSrc = iconType.getIconSrc();
                if (!emailMessage.contains(iconSrc)) continue;
                emailMessage = emailMessage.replace(iconSrc, "src=\"cid:" + iconType.getIconContentId() + "\"");
                iconsInMessage.add(iconType);
            }
            MimeBodyPart htmlBodyPart = new MimeBodyPart();
            htmlBodyPart.setContent((Object)emailMessage, "text/html; charset=utf-8");
            htmlMultipart.addBodyPart((BodyPart)htmlBodyPart);
            if (containsLogoIcon) {
                MimeBodyPart iconBodyPart = new MimeBodyPart();
                iconBodyPart.setFileName("automate-logo.png");
                iconBodyPart.setContentID("<automate-LOGO>");
                iconBodyPart.setDisposition("inline");
                URL logoIconUrl = Workflow.class.getResource("/logo/neo_automate_dark.png");
                iconBodyPart.setDataHandler(new DataHandler(logoIconUrl));
                htmlMultipart.addBodyPart((BodyPart)iconBodyPart);
            }
            for (IconType iconType : iconsInMessage) {
                Icon icon;
                MimeBodyPart iconBodyPart = new MimeBodyPart();
                iconBodyPart.setFileName("automate-" + iconType.toString().toLowerCase() + ".png");
                iconBodyPart.setContentID("<" + iconType.getIconContentId() + ">");
                iconBodyPart.setDisposition("inline");
                int size = 80;
                if (iconType == IconType.LOGO) {
                    size = 0;
                }
                if ((icon = Icons.getInstance().getIcon(iconType, size)) instanceof PngIcon) {
                    PngIcon pngIcon = (PngIcon)icon;
                    ByteArrayOutputStream pngOutputStream = new ByteArrayOutputStream();
                    try {
                        pngIcon.getPngStream((OutputStream)pngOutputStream);
                        ByteArrayInputStream pngInputStream = new ByteArrayInputStream(pngOutputStream.toByteArray());
                        iconBodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource((InputStream)pngInputStream, "image/png")));
                    }
                    catch (IOException e) {
                        LOGGER.error("Cannot get PNG stream", (Throwable)e);
                        LOGGER.error("Unexpected error", (Throwable)e);
                    }
                } else {
                    URLDataSource dataSource = new URLDataSource(EmailUtils.class.getResource(Icons.getInstance().getIconUrl(iconType)));
                    iconBodyPart.setDataHandler(new DataHandler((DataSource)dataSource));
                }
                htmlMultipart.addBodyPart((BodyPart)iconBodyPart);
            }
            bodyPart.setContent((Multipart)htmlMultipart);
        } else {
            bodyPart.setText(smtpEmail.getMessage(), "utf-8");
        }
        mainMultipart.addBodyPart((BodyPart)bodyPart);
        if (smtpEmail.getWorkflowLog() != null) {
            try {
                LOGGER.info("Attaching workflow log");
                File workflowLogFile = FileUtils.createTempFile((String)"WorkflowLog", (String)".txt");
                Files.write(Paths.get(workflowLogFile.getAbsolutePath(), new String[0]), smtpEmail.getWorkflowLog().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                MimeBodyPart attachmentBodyPart = this.buildFileAttachmentBodyParts("WorkflowLog.txt", workflowLogFile);
                mainMultipart.addBodyPart((BodyPart)attachmentBodyPart);
            }
            catch (Exception e) {
                LOGGER.error("Cannot attach workflow log file", (Throwable)e);
            }
        }
        if (smtpEmail.getReportFilePath() != null) {
            try {
                LOGGER.info("Attaching report");
                MimeBodyPart attachmentBodyPart = this.buildFileAttachmentBodyParts(smtpEmail.getReportFilePath());
                mainMultipart.addBodyPart((BodyPart)attachmentBodyPart);
            }
            catch (Exception e) {
                LOGGER.error("Cannot attach report file", (Throwable)e);
            }
        }
        if (smtpEmail.getAdditionalAttachments() != null) {
            for (String additionalAttachment : smtpEmail.getAdditionalAttachments()) {
                try {
                    LOGGER.info("Attaching file " + additionalAttachment);
                    MimeBodyPart attachmentBodyPart = this.buildFileAttachmentBodyParts(additionalAttachment);
                    mainMultipart.addBodyPart((BodyPart)attachmentBodyPart);
                }
                catch (Exception e) {
                    LOGGER.error("Cannot attach file", (Throwable)e);
                }
            }
        }
        message.setContent((Multipart)mainMultipart);
        message.saveChanges();
        if (((SmtpService)this.service).getAuthenticationMethod() == ThirdPartyAuthenticationMethod.OIDC_AUTHORIZATION_CODE) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                message.writeTo((OutputStream)out);
                byte[] bytes = out.toByteArray();
                out.close();
                String encoded = Base64.getEncoder().encodeToString(bytes);
                Entity body = Entity.text((Object)encoded);
                this.callApiResponse("https://graph.microsoft.com/v1.0/me/sendMail", "POST", body, 202);
                LOGGER.info("Email sent successfully");
            }
            catch (Exception e) {
                JsonObject error;
                String jsonResponse;
                JsonObject obj;
                if (e instanceof ThirdPartyRestException && (obj = (JsonObject)SerializationUtils.fromJson((String)(jsonResponse = ((ThirdPartyRestException)((Object)e)).getResponse()), JsonObject.class)).has("error") && (error = obj.get("error").getAsJsonObject()).has("message")) {
                    String errorMessage = error.get("message").getAsString();
                    throw new MessagingException(errorMessage);
                }
                throw new MessagingException(e.getMessage());
            }
        } else {
            Transport.send((Message)message);
            LOGGER.info("Email sent successfully");
        }
        smtpEmail.setState(EmailState.SENT);
        smtpEmail.setSentDate(Long.valueOf(DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()));
        if (State.ERROR.equals((Object)smtpEmail.getStatus().getCode())) {
            smtpEmail.getStatus().reset();
        }
    }

    private MimeBodyPart buildFileAttachmentBodyParts(String path) throws MessagingException {
        File attachmentFile = new File(path);
        return this.buildFileAttachmentBodyParts(attachmentFile.getName(), attachmentFile);
    }

    private MimeBodyPart buildFileAttachmentBodyParts(String fileName, File attachmentFile) throws MessagingException {
        MimeBodyPart attachmentBodyPart = new MimeBodyPart();
        FileDataSource source = new FileDataSource(attachmentFile);
        attachmentBodyPart.setDataHandler(new DataHandler((DataSource)source));
        attachmentBodyPart.setFileName(fileName);
        attachmentBodyPart.setDisposition("attachment");
        return attachmentBodyPart;
    }

    private Session createSmtpSession() throws IOException {
        if (((SmtpService)this.service).getHost() == null || ((SmtpService)this.service).getHost().trim().isEmpty()) {
            throw new IllegalStateException(iu.getString("SmtpServiceSession.Error.CannotStartSmtpSessionMissingHost"));
        }
        if (((SmtpService)this.service).getPort() == null) {
            throw new IllegalStateException(iu.getString("SmtpServiceSession.Error.CannotStartSmtpSessionMissingPort"));
        }
        Properties properties = new Properties();
        properties.put("mail.smtp.host", ((SmtpService)this.service).getHost());
        properties.put("mail.smtp.port", String.valueOf(((SmtpService)this.service).getPort()));
        properties.put("mail.smtp.connectiontimeout", "30000");
        properties.put("mail.smtp.timeout", "30000");
        properties.put("mail.smtps.connectiontimeout", "30000");
        properties.put("mail.smtps.timeout", "30000");
        if (Boolean.TRUE.equals(((SmtpService)this.service).getTls())) {
            properties.put("mail.smtp.starttls.enable", "true");
        } else {
            properties.put("mail.smtp.starttls.enable", "false");
        }
        if (((SmtpService)this.service).getAuthenticationMethod() == ThirdPartyAuthenticationMethod.USERNAME_PASSWORD) {
            properties.put("mail.smtp.auth", "true");
            String username = ((SmtpUserCredential)this.userCredential).getUsername();
            String password = ((SmtpUserCredential)this.userCredential).getPassword();
            if (password == null) {
                throw new IOException(iu.getString("LicenseUtils.ReenterPassword"));
            }
            return Session.getInstance((Properties)properties, (Authenticator)new PasswordAuthenticator(username, password));
        }
        properties.put("mail.smtp.auth", "false");
        return Session.getInstance((Properties)properties);
    }

    static {
        ThreadPoolUtils.createScheduledThreadPoolExecutor((String)"SmtpServiceEmailCounterCleaner", (int)1).scheduleWithFixedDelay(() -> initiatorEmailCounters.clearExpired(), 120L, 120L, TimeUnit.SECONDS);
    }

    private static class PasswordAuthenticator
    extends Authenticator {
        private final String username;
        private final String password;

        private PasswordAuthenticator(String username, String password) {
            this.username = username;
            this.password = password;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.username, this.password);
        }
    }
}

