/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.thirdparty;

import au.com.bytecode.opencsv.CSVWriter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.bearer.OfflineUser;
import com.nuix.automate.utils.api.response.State;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.api.script.RestSSLException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.general.SerializationUtils;
import com.nuix.automate.utils.general.StatusLogger;
import com.nuix.automate.utils.general.WsRsRestClientFactory;
import com.nuix.automate.utils.licence.exceptions.LicenseException;
import com.nuix.automate.utils.logging.ApiClientsLogChannels;
import com.nuix.automate.utils.logging.CircularBufferLog;
import com.nuix.automate.utils.logging.LogChannel;
import com.nuix.automate.utils.logging.LogHandler;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.thirdparty.ActionRequest;
import com.nuix.automate.utils.models.api.thirdparty.ApiProxyRequest;
import com.nuix.automate.utils.models.api.thirdparty.ImportedObjectsParseResult;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyRestException;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyServiceDefinition;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.models.internal.cache.CachedObjectMap;
import com.nuix.automate.utils.models.internal.user.OidcUserService;
import com.nuix.automate.utils.models.internal.user.UserService;
import com.nuix.automate.utils.responsecache.CacheKey;
import com.nuix.automate.utils.responsecache.ResponseCache;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import org.glassfish.jersey.message.internal.OutboundJaxrsResponse;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class ThirdPartyServiceSession<T1 extends ThirdPartyService, T2 extends ThirdPartyUserCredential>
implements AutoCloseable,
Cloneable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ThirdPartyServiceSession.class);
    protected static final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    protected static final Pattern httpsPattern = Pattern.compile("(?i)^https?://");
    protected final SchedulerApplication schedulerApplication;
    protected final String userId;
    protected T1 service;
    protected T2 userCredential;
    protected Client client;
    protected boolean closed;
    protected String version;
    private LicenseException licenseException;
    protected boolean reattemptEnabled;
    protected int maxAttempts;
    protected int initialDelayBetweenAttempts;
    protected long expireWarningThreshold;
    protected final Status status;
    protected final StatusLogger logger;
    protected final CircularBufferLog log;
    protected final CachedObjectMap<Object> cachedObjects;
    private final Gson gson;
    private final transient LogHandler logHandler;
    protected LogChannel logChannel;

    private ThirdPartyServiceSession(String userId, final SchedulerApplication schedulerApplication, String serviceId) {
        this.schedulerApplication = schedulerApplication;
        this.userId = userId;
        this.client = null;
        this.closed = true;
        this.reattemptEnabled = false;
        this.maxAttempts = 3;
        this.initialDelayBetweenAttempts = 10;
        this.status = new Status();
        this.log = new CircularBufferLog();
        this.cachedObjects = new CachedObjectMap();
        this.logger = new StatusLogger(userId, this.status, this.log){

            public void onLogUpdated() {
                schedulerApplication.getThirdPartyServiceResource().resetCache(ThirdPartyServiceSession.this.service.getId());
            }
        };
        this.gson = new Gson();
        this.logHandler = LogHandler.getInstance();
        this.logChannel = null;
    }

    public ThirdPartyServiceSession(String userId, T1 service, T2 userCredential, SchedulerApplication schedulerApplication) {
        this(userId, schedulerApplication, service.getId());
        this.service = service;
        this.userCredential = userCredential;
    }

    public ThirdPartyServiceSession(ThirdPartyServiceSession<T1, T2> session) {
        this(session.getUserId(), session.schedulerApplication, session.getService().getId());
        this.service = session.getService().clone();
        this.userCredential = session.getUserCredential().clone();
        this.version = session.version;
        this.expireWarningThreshold = session.getExpireWarningThreshold();
        this.licenseException = session.getLicenseException();
    }

    public ThirdPartyService getUpdatedThirdPartyService() {
        return null;
    }

    public abstract void assertInstanceLicensed() throws LicenseException;

    protected abstract String testService(Map<String, Object> var1) throws Exception;

    protected abstract void startSession(LogChannel var1, Set<String> var2) throws Exception;

    protected abstract void closeSession();

    public abstract ThirdPartyServiceSession<T1, T2> clone();

    public Object proxy(ApiProxyRequest apiProxyRequest) throws Exception {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " proxy not supported");
    }

    public Map<String, String> handleAction(ActionRequest<String> actionRequest) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " handling actions not supported");
    }

    public void exportAsCsv(CSVWriter csvWriter, String optionsJson) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " CSV export not supported");
    }

    public Object getObjects(String serviceObjectType, Map<String, Object> parameters) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " objects not supported");
    }

    public ImportedObjectsParseResult<?> parseImportedObjects(String serviceObjectType, List<String[]> objectRows) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " parsing imported objects not supported");
    }

    public List<ThirdPartyServiceDefinition> getServicesDefinition(String bearerToken) {
        return null;
    }

    public boolean refreshToken() throws IOException {
        return true;
    }

    public String getLogKey() {
        return "logApi" + this.getClass().getSimpleName().replace("ServiceClient", "");
    }

    public Object getClient() {
        return this;
    }

    public void initialize() throws IOException {
        this.initialize(false);
    }

    public synchronized void initialize(boolean restart) throws IOException {
        try {
            this.assertInstanceLicensed();
            if (!this.closed) {
                if (restart) {
                    this.close();
                } else {
                    return;
                }
            }
            if (this.service.getEnabled().booleanValue() && this.getSignedIn()) {
                OfflineUser offlineUser = SchedulerApplication.getInstance().getSecurityResource().getOfflineUserFromId(this.userId);
                String username = offlineUser != null ? offlineUser.getMainIdentifier().getPrintableName() : this.userId;
                LogChannel logChannel = ApiClientsLogChannels.getInstance().getLogChannel(this.getLogKey(), username);
                Boolean logEnabled = SchedulerApplication.getInstance().getUserSettingsResource().getUserCategorySetting(username, "troubleshoot", this.getLogKey(), Boolean.class);
                logChannel.setEnabled(logEnabled != null && logEnabled != false);
                Set<String> whitelistedCertFingerprints = this.getWhitelistedCertFingerprints();
                this.startSession(logChannel, whitelistedCertFingerprints);
                this.closed = false;
            }
        }
        catch (Exception e) {
            LOGGER.error("Error initializing client", (Throwable)e);
            this.logger.addError(iu.getFormattedString("ThirdPartySession.Error.CannotInitializeClient", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
            throw new IOException(iu.getFormattedString("ThirdPartySession.Error.CannotInitializeClient", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)));
        }
    }

    public Set<String> getWhitelistedCertFingerprints() {
        OidcUserService oidcUserService;
        UserService userService;
        HashSet<String> whitelistedCertFingerprints = new HashSet<String>();
        if (this.service.getWhitelistedCertFingerprints() != null) {
            whitelistedCertFingerprints.addAll(this.service.getWhitelistedCertFingerprints());
        }
        if (this.service.usingOidcAuthenticationMethod() && this.service.getAuthenticationServiceId() != null && (userService = SchedulerApplication.getInstance().getUserServiceResource().getUserService(this.service.getAuthenticationServiceId())) instanceof OidcUserService && (oidcUserService = (OidcUserService)userService).getWhitelistedCertFingerprints() != null) {
            whitelistedCertFingerprints.addAll(oidcUserService.getWhitelistedCertFingerprints());
        }
        return whitelistedCertFingerprints;
    }

    public void testService() throws Exception {
        this.testService(null);
    }

    public String test(Map<String, Object> values) throws Exception {
        this.initialize();
        this.validateRequest();
        return this.testService(values);
    }

    @Override
    public void close() {
        this.cachedObjects.clear();
        this.logger.reset();
        try {
            this.closeSession();
        }
        catch (Exception e) {
            LOGGER.error("Error closing client", (Throwable)e);
        }
        this.closed = true;
    }

    public String getTranslationKey(String key) {
        return this.getClass().getSimpleName() + "." + key;
    }

    public String getUiTranslationKey(String text) {
        String simpleName = this.getClass().getSimpleName();
        String camelCaseName = simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1);
        return camelCaseName + text;
    }

    public void calculateAuthStatus() {
        LOGGER.debug("Computing status, before: " + String.valueOf(this.service.getAuthenticationMethod()) + ", " + this.userCredential.getUsername());
        if (ThirdPartyAuthenticationMethod.NONE.equals((Object)this.service.getAuthenticationMethod()) && this.userCredential != null) {
            this.userCredential.setToken("");
            this.userCredential.setUsername("");
            this.userCredential.updateSignedIn();
        }
        LOGGER.debug("Computing status, after: " + String.valueOf(this.service.getAuthenticationMethod()) + ", " + this.userCredential.getUsername());
    }

    public void calculateStatus() {
        this.calculateStatus(true);
    }

    public void calculateStatus(boolean reset) {
        if (reset) {
            this.status.reset();
        }
        if (!Boolean.TRUE.equals(this.service.getEnabled())) {
            this.status.reset();
            return;
        }
        try {
            this.assertInstanceLicensed();
            this.licenseException = null;
            if (this.getSignInRequired()) {
                if (!this.getSignedIn()) {
                    this.logger.addInfo(iu.getString("ThirdPartySession.Error.NotSignedIn"));
                } else if (this.getStale()) {
                    this.logger.addWarning(iu.getString("ThirdPartySession.Warning.Stale"));
                } else {
                    this.updateExpiryWarning();
                }
            }
        }
        catch (Exception e) {
            this.licenseException = new LicenseException((Throwable)e);
            this.logger.addWarning(e.getMessage());
        }
    }

    protected void updateExpiryWarning() {
        if (this.userCredential.getRefreshToken() != null && !this.userCredential.getRefreshToken().isBlank()) {
            return;
        }
        if (!this.service.getEnabled().booleanValue()) {
            return;
        }
        Long tokenExpiryDate = this.userCredential.getTokenExpiryDate();
        if (tokenExpiryDate != null) {
            long timeTillExpire;
            if (this.userCredential.getExpired()) {
                this.logger.addWarning(iu.getString("ThirdPartySession.Warning.Expired"));
            } else if (this.expireWarningThreshold > 0L && (timeTillExpire = tokenExpiryDate - DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis()) < this.expireWarningThreshold) {
                int hoursTillExpire = Math.max(1, (int)Math.ceil((double)timeTillExpire / 1000.0 / 60.0 / 60.0));
                if (hoursTillExpire > 24) {
                    int daysTillExpire = Math.max(1, (int)Math.ceil((double)hoursTillExpire / 24.0));
                    this.logger.addWarning(iu.getNumeralFormattedString("ThirdPartySession.Warning.TokenWillExpireWithinDays", (long)daysTillExpire, (Object)daysTillExpire));
                } else {
                    this.logger.addWarning(iu.getNumeralFormattedString("ThirdPartySession.Warning.TokenWillExpireWithinHours", (long)hoursTillExpire, (Object)hoursTillExpire));
                }
            }
        }
    }

    protected <RequestType> Response callApiResponse(String url, String method, Entity<RequestType> body, Integer expectedStatus) throws IOException {
        return this.callApiResponse(url, method, body, expectedStatus, false);
    }

    protected <RequestType> Response callApiResponse(String url, String method, Entity<RequestType> body, boolean proxyRequest) throws IOException {
        return this.callApiResponse(url, method, body, null, proxyRequest);
    }

    protected <RequestType> Response callApiResponse(String url, String method, Entity<RequestType> body, Integer expectedStatus, boolean proxyRequest) throws IOException {
        return this.callApiResponse(url, method, body, null, proxyRequest, false);
    }

    protected <RequestType> Response callApiResponse(String url, String method, Entity<RequestType> body, Integer expectedStatus, boolean proxyRequest, boolean originalResponse) throws IOException {
        this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent(method + " " + url));
        if (body != null) {
            this.logHandler.addLogEvent(this.logChannel.getLogEvent(this.gson.toJson(body) + "\n"));
        } else {
            this.logHandler.addLogEvent(this.logChannel.getLogEvent(""));
        }
        boolean updated = false;
        int delayFactorSeconds = this.initialDelayBetweenAttempts;
        int attempt = 1;
        try {
            String stringResponse;
            Response response;
            while (true) {
                try {
                    Invocation.Builder builder = this.prepareRequest(url);
                    switch (method) {
                        case "GET": {
                            response = builder.get();
                            break;
                        }
                        case "POST": {
                            response = builder.post(body);
                            break;
                        }
                        case "PUT": {
                            response = builder.put(body);
                            break;
                        }
                        case "PATCH": {
                            response = builder.method("PATCH", body);
                            break;
                        }
                        case "DELETE": {
                            response = builder.delete();
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("HTTP Method: " + method + " not implemented for " + this.getClass().getSimpleName());
                        }
                    }
                }
                catch (Exception e) {
                    if ((e.getCause() != null && e.getCause() instanceof SSLHandshakeException || e.getMessage().contains("SSLHandshakeException")) && (this.service.getWhitelistedCertFingerprints() == null || this.service.getWhitelistedCertFingerprints().stream().allMatch(cert -> cert.trim().isEmpty()))) {
                        HashSet<String> dummyFingerprints = new HashSet<String>();
                        dummyFingerprints.add("dummy-fingerprint");
                        try {
                            Client dummyClient = WsRsRestClientFactory.getClientWithWhitelistValidation((String)(this.getClientName() + "-dummyFingerprint"), dummyFingerprints, (boolean)true);
                            Response dummyResponse = dummyClient.target(url).request(new String[]{"application/json"}).get();
                            LOGGER.info("Got response code " + dummyResponse.getStatus());
                        }
                        catch (Exception ex) {
                            if (e.getCause() != null && e.getCause() instanceof SSLHandshakeException || e.getMessage().contains("SSLHandshakeException")) {
                                throw new RestSSLException(ex.getCause().getMessage());
                            }
                            throw e;
                        }
                    }
                    if (this.reattemptEnabled && attempt < this.maxAttempts) {
                        LOGGER.error("Exception during request", (Throwable)e);
                        this.logHandler.addLogEvent(this.logChannel.getLogEvent("Retrying ..."));
                        ++attempt;
                        continue;
                    }
                    throw e;
                }
                if (originalResponse) {
                    Response e = response;
                    return e;
                }
                stringResponse = (String)response.readEntity(String.class);
                stringResponse = stringResponse != null ? stringResponse.trim() : "";
                this.logHandler.addLogEvent(this.logChannel.getPreTimeStampedLogEvent("HTTP/" + response.getStatus()));
                this.logHandler.addLogEvent(this.logChannel.getLogEvent(stringResponse + "\n"));
                if (!this.reattemptResponse(response, stringResponse) || !this.reattemptEnabled || attempt >= this.maxAttempts) break;
                this.logHandler.addLogEvent(this.logChannel.getLogEvent("Retrying ..."));
                ++attempt;
                response.close();
                try {
                    Thread.sleep((long)delayFactorSeconds * 1000L);
                }
                catch (InterruptedException e) {
                    LOGGER.error((Throwable)e);
                    Thread.currentThread().interrupt();
                }
                delayFactorSeconds = Math.min(delayFactorSeconds * 2, 90);
            }
            this.logHandler.addLogEvent(this.logChannel.getSeparator());
            if (response.getStatus() >= 400 && !proxyRequest || expectedStatus != null && expectedStatus != 0 && response.getStatus() != expectedStatus.intValue()) {
                String errorMessage = method + " " + url + " HTTP/" + response.getStatus() + " " + stringResponse;
                throw new ThirdPartyRestException(errorMessage, response.getStatus(), stringResponse);
            }
            if (this.status.getCode() == State.ERROR || this.status.getCode() == State.WARNING) {
                this.userCredential.setStale(false);
                this.calculateStatus();
                updated = true;
            }
            Response proxyResponse = Response.status((int)response.getStatus()).location(response.getLocation()).type(response.getMediaType()).entity((Object)stringResponse).build();
            response.close();
            String string = proxyResponse;
            return string;
        }
        catch (Exception e) {
            this.logger.addError(iu.getFormattedString("ThirdPartySession.Error.Request", (Object)ExceptionUtils.getExceptionPrintableMessage((Throwable)e)), false);
            updated = true;
            throw e;
        }
        finally {
            if (updated) {
                ResponseCache.getInstance().resetKeyId(CacheKey.THIRD_PARTY_SERVICE, this.userCredential.getThirdPartyServiceId());
                ResponseCache.getInstance().resetKeyId(CacheKey.THIRD_PARTY_SERVICES);
            }
        }
    }

    protected synchronized Invocation.Builder prepareRequest(String url) throws IOException {
        this.validateRequest();
        return this.client.target(url).request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + this.userCredential.getToken()));
    }

    protected void validateRequest() throws IOException {
        try {
            this.assertInstanceLicensed();
            this.licenseException = null;
            if (this.getSignInRequired() && !this.getSignedIn()) {
                throw new IllegalStateException(iu.getFormattedString("ThirdPartySession.Error.NotSignedIn", new Object[0]));
            }
            if (this.closed) {
                this.initialize();
            }
            if (this.service.usingOidcAuthenticationMethod() && (this.userCredential.getToken() == null || this.userCredential.getExpired()) && !this.refreshToken()) {
                throw new IllegalStateException(iu.getFormattedString("ThirdPartySession.Warning.Expired", new Object[0]));
            }
        }
        catch (LicenseException e) {
            this.licenseException = e;
            throw e;
        }
    }

    protected boolean reattemptResponse(Response response, String responseString) {
        return response.getStatus() >= 500 && response.getStatus() < 600;
    }

    protected String parseErrorResponse(Response response, String responseString) {
        String result = responseString;
        try {
            Object endServiceResponseMessage;
            Map endServiceResponseMap = (Map)SerializationUtils.fromJson((String)responseString, Map.class);
            Object endServiceResponseError = endServiceResponseMap.get("error");
            if (endServiceResponseError instanceof Map && (endServiceResponseMessage = ((Map)endServiceResponseError).get("message")) != null) {
                result = endServiceResponseMessage.toString().replace(": .", ".").trim();
            }
        }
        catch (Exception e) {
            LOGGER.warn("Cannot parse " + this.service.getPrintableServiceType() + " error message", (Throwable)e);
        }
        return "HTTP/" + response.getStatus() + " " + result;
    }

    protected <ResponseType> ResponseType readResponseEntity(ObjectMapper objectMapper, Response response, GenericType<ResponseType> entityType) throws JsonProcessingException {
        if (response instanceof OutboundJaxrsResponse) {
            JavaType javaType = objectMapper.getTypeFactory().constructType(entityType.getType());
            String result = (String)response.getEntity();
            if (result != null && !result.trim().isEmpty()) {
                return (ResponseType)objectMapper.readValue(result, javaType);
            }
            return null;
        }
        return (ResponseType)response.readEntity(entityType);
    }

    public String getClientName() {
        return this.service.getPrintableServiceType() + " Client: " + this.getId();
    }

    public String getId() {
        return ThirdPartyServiceSession.getId(this.service, this.userId);
    }

    public static String getId(ThirdPartyService thirdPartyService, String userId) {
        if (thirdPartyService.getAuthenticationMethod() == ThirdPartyAuthenticationMethod.OIDC_CLIENT_CREDENTIALS) {
            return thirdPartyService.getId();
        }
        return thirdPartyService.getId() + userId + thirdPartyService.getAuthenticationScope().name();
    }

    public String getUserId() {
        return this.userId;
    }

    public void setService(ThirdPartyService service) {
        this.internalSetService(service);
    }

    public void setUserCredential(ThirdPartyUserCredential userCredential) {
        this.userCredential = userCredential;
    }

    public void signOut() {
        this.close();
        this.userCredential.signOut();
    }

    public String getServiceId() {
        return this.service.getId();
    }

    public boolean getConnected() {
        return this.getSignedIn() && this.status.getCode() != State.ERROR;
    }

    public boolean getSignedIn() {
        return this.userCredential.getSignedIn() || !this.getSignInRequired();
    }

    public boolean getSignInRequired() {
        return this.service.getAuthenticationMethod().getSignInRequired();
    }

    public boolean getStale() {
        return this.userCredential.getStale();
    }

    public void setStale(boolean stale) {
        this.userCredential.setStale(stale);
    }

    public void clearExpiredCache() {
        this.cachedObjects.clearExpired();
    }

    public T1 getService() {
        return this.service;
    }

    protected void internalSetService(T1 service) {
        this.service = service;
    }

    public T2 getUserCredential() {
        return this.userCredential;
    }

    public Status getStatus() {
        return this.status;
    }

    public CircularBufferLog getLog() {
        return this.log;
    }

    public StatusLogger getLogger() {
        return this.logger;
    }

    public boolean getClosed() {
        return this.closed;
    }

    public long getExpireWarningThreshold() {
        return this.expireWarningThreshold;
    }

    public void setExpireWarningThreshold(long expireWarningThreshold) {
        this.expireWarningThreshold = expireWarningThreshold;
    }

    public LicenseException getLicenseException() {
        return this.licenseException;
    }
}

