/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.security.ums;

import com.nuix.automate.dropwizard.utils.models.UserServiceClient;
import com.nuix.automate.dropwizard.utils.security.bearer.BearerUser;
import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.security.ums.UmsBearerUser;
import com.nuix.automate.scheduler.security.ums.UmsUser;
import com.nuix.automate.utils.exceptions.AuthenticationException;
import com.nuix.automate.utils.general.DropwizardRestClientFactory;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.user.PasswordAuthenticationSubmission;
import com.nuix.automate.utils.models.api.user.UserAccount;
import com.nuix.automate.utils.models.api.user.UserAccountPlatform;
import com.nuix.automate.utils.models.api.user.UserAccountState;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import com.nuix.automate.utils.models.internal.user.UmsUserService;
import com.nuix.automate.utils.models.internal.user.UserMessageModel;
import com.nuix.automate.utils.models.internal.user.UserService;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;

public class UmsUtil
extends UserServiceClient {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(UmsUtil.class);
    private final InternationalizationUtils iu = InternationalizationUtils.getInstance((String)"SchedulerText");
    private UmsUserService umsUserService;
    private Client client;

    public UmsUtil(UmsUserService umsUserService) {
        this.umsUserService = umsUserService;
        this.client = DropwizardRestClientFactory.getClient((String)this.getClientName(), (boolean)false, (boolean)true, (boolean)true, (AutomateApplication)SchedulerApplication.getInstance(), (AutomateConfiguration)SchedulerApplication.getInstance().getConfiguration());
    }

    private String getClientName() {
        if (this.umsUserService != null) {
            return "UmsUtil:" + this.umsUserService.getId();
        }
        return "UmsUtil";
    }

    public void update(UserService userService) {
        this.umsUserService = (UmsUserService)userService;
    }

    public void close() {
        block3: {
            try {
                if (this.client != null) {
                    this.client.close();
                }
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug("Unable to close client", (Throwable)e);
            }
        }
    }

    public boolean supportsPasswordAuthentication() {
        return true;
    }

    public BearerUser authenticateUser(PasswordAuthenticationSubmission passwordAuthenticationSubmission) throws AuthenticationException {
        LOGGER.info("Authenticating user " + passwordAuthenticationSubmission.getUsername() + " against the UMS");
        try (Response response = null;){
            WebTarget webTarget = this.client.target(this.umsUserService.getUrl() + "/v1/authenticatedUsers");
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"});
            response = invocationBuilder.post(Entity.json((Object)passwordAuthenticationSubmission));
            if (response.getStatus() == 401) {
                LOGGER.info("UMS returned HTTP/401 Unauthorized for user " + passwordAuthenticationSubmission.getUsername());
                throw new AuthenticationException(this.iu.getString("UmsUtil.IncorrectUsernamePassword"));
            }
            if (response.getStatus() == 403) {
                LOGGER.info("UMS returned HTTP/403 Unauthorized for user " + passwordAuthenticationSubmission.getUsername());
                UserMessageModel userMessageModel = null;
                try {
                    userMessageModel = (UserMessageModel)response.readEntity(UserMessageModel.class);
                }
                catch (Exception e) {
                    LOGGER.error("Cannot parse UMS 403 message", (Throwable)e);
                }
                if (userMessageModel != null) {
                    throw new AuthenticationException(userMessageModel.getUserMessage());
                }
                throw new AuthenticationException(this.iu.getString("UmsUtil.IncorrectUsernamePassword"));
            }
            try {
                UmsUser umsUser = (UmsUser)response.readEntity(UmsUser.class);
                UmsBearerUser umsBearerUser = new UmsBearerUser(umsUser, this, this.umsUserService);
                return umsBearerUser;
            }
            catch (Exception e) {
                try {
                    LOGGER.error("Cannot parse UMS response", (Throwable)e);
                    throw new ServerErrorException(response);
                }
                catch (ProcessingException ex) {
                    LOGGER.warn("Received ProcessingException while attempting to authenticate user", (Throwable)ex);
                    try {
                        this.client = DropwizardRestClientFactory.getClient((String)this.getClientName(), (AutomateApplication)SchedulerApplication.getInstance(), (AutomateConfiguration)SchedulerApplication.getInstance().getConfiguration());
                    }
                    catch (Exception e2) {
                        LOGGER.error("Cannot reset API client", (Throwable)e2);
                    }
                    throw ex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UmsUser getUserFromNuixToken(String nuixToken) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Getting user session from the UMS");
        }
        try (Response response = null;){
            WebTarget webTarget = this.client.target(this.umsUserService.getUrl() + "/v1/authenticatedUser");
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"}).header("nuix-auth-token", (Object)nuixToken);
            response = invocationBuilder.get();
            if (response.getStatus() == 401) {
                LOGGER.info("UMS returned HTTP/401 Unauthorized for user session");
                UmsUser umsUser = null;
                return umsUser;
            }
            UmsUser umsUser = (UmsUser)response.readEntity(UmsUser.class);
            return umsUser;
        }
    }

    public boolean validateUserSession(UmsBearerUser user) {
        UmsUser sessionUmsUser;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Refreshing UMS user " + user.getName());
        }
        if ((sessionUmsUser = this.getUserFromNuixToken(user.getUmsUser().getNuixToken())) != null) {
            user.setUmsUser(sessionUmsUser);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invalidateUserSession(UmsUser umsUser) {
        LOGGER.info("Invalidating user " + umsUser.getName() + " session against the UMS");
        try (Response response = null;){
            WebTarget webTarget = this.client.target(this.umsUserService.getUrl() + "/v1/authenticatedUser");
            Invocation.Builder invocationBuilder = webTarget.request(new String[]{"application/json"}).header("nuix-auth-token", (Object)umsUser.getNuixToken());
            response = invocationBuilder.delete();
            if (response.getStatus() == 401) {
                LOGGER.info("UMS returned HTTP/401 Unauthorized for user session " + umsUser.getName());
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    public List<UserAccount> getUserAccounts(UserService userService, boolean firstPageOnly) throws AuthenticationException {
        LOGGER.info("Getting UMS users");
        UmsUserService umsUserService = (UmsUserService)userService;
        if (umsUserService == null) {
            LOGGER.error("Missing umsUserService");
            throw new IllegalArgumentException("Missing umsUserService");
        }
        UmsBearerUser serviceAccount = null;
        try {
            serviceAccount = (UmsBearerUser)this.authenticateUser(new PasswordAuthenticationSubmission(umsUserService.getServiceAccountName(), umsUserService.getServiceAccountPassword()));
            Response response = this.client.target(umsUserService.getUrl() + "/v1/users").request(new String[]{"application/json"}).header("nuix-auth-token", (Object)serviceAccount.getUmsUser().getNuixToken()).get();
            ArrayList<UserAccount> userAccounts = new ArrayList<UserAccount>();
            if (response.getStatus() == 200) {
                List umsUsers = (List)response.readEntity((GenericType)new GenericType<List<UmsUser>>(){});
                for (UmsUser umsUser : umsUsers) {
                    String name = umsUser.getName();
                    if (name.equalsIgnoreCase("nuixroot")) continue;
                    UserAccount userAccount = new UserAccount();
                    userAccount.setPlatform(UserAccountPlatform.UMS);
                    userAccount.setId(name);
                    userAccount.setName(name);
                    userAccount.setEmail(umsUser.getEmailAddress());
                    userAccount.setUserAccountState(UserAccountState.ACTIVE);
                    userAccounts.add(userAccount);
                }
            } else {
                LOGGER.error("Response for UMS users query returned status: " + response.getStatus());
            }
            ArrayList<UserAccount> arrayList = userAccounts;
            return arrayList;
        }
        catch (ProcessingException ex) {
            LOGGER.warn("Received ProcessingException while attempting to authenticate user", (Throwable)ex);
            try {
                this.client = DropwizardRestClientFactory.getClient((String)this.getClientName(), (AutomateApplication)SchedulerApplication.getInstance(), (AutomateConfiguration)SchedulerApplication.getInstance().getConfiguration());
            }
            catch (Exception e) {
                LOGGER.error("Cannot reset API client", (Throwable)e);
            }
            throw ex;
        }
        finally {
            if (serviceAccount != null) {
                serviceAccount.invalidate();
            }
        }
    }

    public List<UserAccount> getUserAccounts(UserService userService, boolean firstPageOnly, boolean inactive) throws Exception {
        if (!inactive) {
            return this.getUserAccounts(userService, firstPageOnly);
        }
        return new ArrayList<UserAccount>();
    }
}

