/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.transport;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;

public class ConciseResponseFilter
implements Filter {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(ConciseResponseFilter.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)req;
        HttpServletResponse httpResponse = (HttpServletResponse)res;
        String conciseHeader = httpRequest.getHeader("X-Response-Concise");
        if ("true".equalsIgnoreCase(conciseHeader) && httpRequest.getRequestURI().startsWith("/api/")) {
            ResponseWrapper responseWrapper = new ResponseWrapper(httpResponse);
            chain.doFilter(req, (ServletResponse)responseWrapper);
            String contentType = responseWrapper.getContentType();
            if (contentType != null && contentType.contains("application/json")) {
                try {
                    String originalContent = responseWrapper.getCapturedContent();
                    if (originalContent != null && !originalContent.trim().isEmpty()) {
                        String filteredContent = this.filterJsonResponse(originalContent);
                        httpResponse.setContentLength(filteredContent.getBytes().length);
                        httpResponse.getWriter().write(filteredContent);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error filtering JSON response", (Throwable)e);
                    httpResponse.getWriter().write(responseWrapper.getCapturedContent());
                }
            } else {
                httpResponse.getWriter().write(responseWrapper.getCapturedContent());
            }
        } else {
            chain.doFilter(req, res);
        }
    }

    private String filterJsonResponse(String jsonContent) throws IOException {
        JsonNode rootNode = OBJECT_MAPPER.readTree(jsonContent);
        JsonNode filteredNode = this.filterJsonNode(rootNode);
        return OBJECT_MAPPER.writeValueAsString((Object)filteredNode);
    }

    private JsonNode filterJsonNode(JsonNode node) {
        if (node == null || node.isNull()) {
            return null;
        }
        if (node.isObject()) {
            ObjectNode objectNode = OBJECT_MAPPER.createObjectNode();
            Iterator fieldNames = node.fieldNames();
            while (fieldNames.hasNext()) {
                JsonNode filteredValue;
                String fieldName = (String)fieldNames.next();
                JsonNode fieldValue = node.get(fieldName);
                if ("userPermissions".equals(fieldName) || (filteredValue = this.filterJsonNode(fieldValue)) == null || this.isEmptyCollection(filteredValue)) continue;
                objectNode.set(fieldName, filteredValue);
            }
            return objectNode;
        }
        if (node.isArray()) {
            ArrayNode arrayNode = OBJECT_MAPPER.createArrayNode();
            for (JsonNode element : node) {
                JsonNode filteredElement = this.filterJsonNode(element);
                if (filteredElement == null || this.isEmptyCollection(filteredElement) || this.isFalse(filteredElement) || this.isEmptyString(node)) continue;
                arrayNode.add(filteredElement);
            }
            return arrayNode;
        }
        if (this.isFalse(node) || this.isEmptyString(node)) {
            return null;
        }
        return node;
    }

    private boolean isEmptyCollection(JsonNode node) {
        if (node.isArray()) {
            return node.size() == 0;
        }
        if (node.isObject()) {
            return node.size() == 0;
        }
        return false;
    }

    private boolean isFalse(JsonNode node) {
        if (node.isBoolean()) {
            return !node.asBoolean();
        }
        return false;
    }

    private boolean isEmptyString(JsonNode node) {
        if (node.isTextual()) {
            return node.asText().isEmpty();
        }
        return false;
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    private static class ResponseWrapper
    extends HttpServletResponseWrapper {
        private final ByteArrayOutputStream capture = new ByteArrayOutputStream();
        private PrintWriter writer;
        private ServletOutputStream outputStream;

        public ResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public PrintWriter getWriter() throws IOException {
            if (this.writer == null) {
                this.writer = new PrintWriter(this.capture);
            }
            return this.writer;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.outputStream == null) {
                this.outputStream = new ServletOutputStream(){

                    public void write(int b) throws IOException {
                        capture.write(b);
                    }

                    public boolean isReady() {
                        return true;
                    }

                    public void setWriteListener(WriteListener writeListener) {
                    }
                };
            }
            return this.outputStream;
        }

        public String getCapturedContent() throws IOException {
            if (this.writer != null) {
                this.writer.flush();
            }
            if (this.outputStream != null) {
                this.outputStream.flush();
            }
            return this.capture.toString();
        }
    }
}

