/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.tus.HttpMethod;
import com.nuix.automate.scheduler.tus.TusExtension;
import com.nuix.automate.scheduler.tus.core.CoreProtocol;
import com.nuix.automate.scheduler.tus.creation.CreationExtension;
import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.expiration.ExpirationExtension;
import com.nuix.automate.scheduler.tus.termination.TerminationExtension;
import com.nuix.automate.scheduler.tus.upload.UUIDUploadIdFactory;
import com.nuix.automate.scheduler.tus.upload.UploadIdFactory;
import com.nuix.automate.scheduler.tus.upload.UploadInfo;
import com.nuix.automate.scheduler.tus.upload.UploadLock;
import com.nuix.automate.scheduler.tus.upload.UploadLockingService;
import com.nuix.automate.scheduler.tus.upload.UploadStorageService;
import com.nuix.automate.scheduler.tus.upload.cache.ThreadLocalCachedStorageAndLockingService;
import com.nuix.automate.scheduler.tus.upload.scheduler.SchedulerLockingService;
import com.nuix.automate.scheduler.tus.upload.scheduler.SchedulerStorageService;
import com.nuix.automate.scheduler.tus.utils.TusServletRequest;
import com.nuix.automate.scheduler.tus.utils.TusServletResponse;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class TusFileUploadService {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(TusFileUploadService.class);
    public static final String TUS_API_VERSION = "1.0.0";
    private final LinkedHashMap<String, TusExtension> enabledFeatures = new LinkedHashMap();
    private final Set<HttpMethod> supportedHttpMethods = EnumSet.noneOf(HttpMethod.class);
    private final UploadIdFactory idFactory = new UUIDUploadIdFactory();
    private UploadStorageService uploadStorageService;
    private UploadLockingService uploadLockingService;
    private boolean isThreadLocalCacheEnabled = false;
    private boolean isChunkedTransferDecodingEnabled = false;

    public TusFileUploadService(SchedulerApplication schedulerApplication) {
        this.initFeatures();
    }

    protected void initFeatures() {
        this.addTusExtension(new CoreProtocol());
        this.addTusExtension(new CreationExtension());
        this.addTusExtension(new TerminationExtension());
        this.addTusExtension(new ExpirationExtension());
    }

    public TusFileUploadService withUploadURI(String uploadURI) {
        this.idFactory.setUploadURI(uploadURI);
        return this;
    }

    public TusFileUploadService withUploadStorageService(UploadStorageService uploadStorageService) {
        Validate.notNull((Object)uploadStorageService, (String)"The UploadStorageService cannot be null", (Object[])new Object[0]);
        uploadStorageService.setIdFactory(this.idFactory);
        this.uploadStorageService = uploadStorageService;
        return this;
    }

    public TusFileUploadService withUploadLockingService(UploadLockingService uploadLockingService) {
        Validate.notNull((Object)uploadLockingService, (String)"The UploadStorageService cannot be null", (Object[])new Object[0]);
        uploadLockingService.setIdFactory(this.idFactory);
        this.uploadLockingService = uploadLockingService;
        return this;
    }

    public TusFileUploadService withUploadStorageDao(UploadStorageService uploadStorageService) {
        this.withUploadStorageService(uploadStorageService);
        this.withUploadLockingService(new SchedulerLockingService());
        if (uploadStorageService instanceof SchedulerStorageService && this.uploadLockingService instanceof SchedulerLockingService) {
            ((SchedulerStorageService)uploadStorageService).setUploadLockingService((SchedulerLockingService)this.uploadLockingService);
        }
        return this;
    }

    public TusFileUploadService withThreadLocalCache(boolean isEnabled) {
        this.isThreadLocalCacheEnabled = isEnabled;
        this.prepareCacheIfEnabled();
        return this;
    }

    public TusFileUploadService withChunkedTransferDecoding(boolean isEnabled) {
        this.isChunkedTransferDecodingEnabled = isEnabled;
        return this;
    }

    public TusFileUploadService withUploadExpirationPeriod(Long expirationPeriod) {
        this.uploadStorageService.setUploadExpirationPeriod(expirationPeriod);
        return this;
    }

    public TusFileUploadService addTusExtension(TusExtension feature) {
        Validate.notNull((Object)feature, (String)"A custom feature cannot be null", (Object[])new Object[0]);
        this.enabledFeatures.put(feature.getName(), feature);
        this.updateSupportedHttpMethods();
        return this;
    }

    public TusFileUploadService disableTusExtension(String extensionName) {
        Validate.notNull((Object)extensionName, (String)"The extension name cannot be null", (Object[])new Object[0]);
        Validate.isTrue((!StringUtils.equals((CharSequence)"core", (CharSequence)extensionName) ? 1 : 0) != 0, (String)"The core protocol cannot be disabled", (Object[])new Object[0]);
        this.enabledFeatures.remove(extensionName);
        this.updateSupportedHttpMethods();
        return this;
    }

    public Set<HttpMethod> getSupportedHttpMethods() {
        return EnumSet.copyOf(this.supportedHttpMethods);
    }

    public Set<String> getEnabledFeatures() {
        return new LinkedHashSet<String>(this.enabledFeatures.keySet());
    }

    public void process(HttpServletRequest servletRequest, HttpServletResponse servletResponse, String ownerKey) throws IOException {
        Validate.notNull((Object)servletRequest, (String)"The HTTP Servlet request cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)servletResponse, (String)"The HTTP Servlet response cannot be null", (Object[])new Object[0]);
        HttpMethod method = HttpMethod.getMethodIfSupported(servletRequest, this.supportedHttpMethods);
        TusServletRequest request = new TusServletRequest(servletRequest, this.isChunkedTransferDecodingEnabled);
        TusServletResponse response = new TusServletResponse(servletResponse);
        try (UploadLock lock = this.uploadLockingService.lockUploadByUri(request.getRequestURI());){
            this.processLockedRequest(method, request, response, ownerKey);
        }
        catch (TusException e) {
            LOGGER.error("Unable to lock upload for request URI " + request.getRequestURI(), (Throwable)e);
        }
    }

    public InputStream getUploadedBytes(String uploadURI, String ownerKey) throws IOException, TusException {
        try (UploadLock lock = this.uploadLockingService.lockUploadByUri(uploadURI);){
            InputStream inputStream = this.uploadStorageService.getUploadedBytes(uploadURI, ownerKey);
            return inputStream;
        }
    }

    public UploadInfo getUploadInfo(String uploadURI, String ownerKey) throws IOException, TusException {
        try (UploadLock lock = this.uploadLockingService.lockUploadByUri(uploadURI);){
            UploadInfo uploadInfo = this.uploadStorageService.getUploadInfo(uploadURI, ownerKey);
            return uploadInfo;
        }
    }

    public void deleteUpload(String uploadURI, String ownerKey) throws IOException, TusException {
        try (UploadLock lock = this.uploadLockingService.lockUploadByUri(uploadURI);){
            UploadInfo uploadInfo = this.uploadStorageService.getUploadInfo(uploadURI, ownerKey);
            if (uploadInfo != null) {
                this.uploadStorageService.terminateUpload(uploadInfo);
            }
        }
    }

    public void deleteUpload(UploadInfo uploadInfo) throws IOException, TusException {
        try (UploadLock lock = this.uploadLockingService.lockUploadById(uploadInfo.getId());){
            this.uploadStorageService.terminateUpload(uploadInfo);
        }
    }

    public void finalizeUpload(String datasetId, String uploadURI, String ownerKey, Map<String, String> hashes) throws IOException, TusException {
        try (UploadLock lock = this.uploadLockingService.lockUploadByUri(uploadURI);){
            UploadInfo uploadInfo = this.uploadStorageService.getUploadInfo(uploadURI, ownerKey);
            if (uploadInfo != null && uploadInfo.getLocationIdentifier().equals(datasetId)) {
                this.uploadStorageService.finalizeUpload(uploadInfo, hashes);
            } else {
                LOGGER.error("Cannot finalize upload " + uploadURI + " because it was not found for owner " + ownerKey + " or belongs to a different data set");
            }
        }
    }

    public void cleanup() throws IOException {
        LOGGER.info("Running clean-up on stale locks and expired uploads");
        this.uploadLockingService.cleanupStaleLocks();
        this.uploadStorageService.cleanupExpiredUploads(this.uploadLockingService);
    }

    public boolean isLocked(UploadInfo uploadInfo) {
        return this.uploadLockingService.isLocked(uploadInfo.getId());
    }

    protected void processLockedRequest(HttpMethod method, TusServletRequest request, TusServletResponse response, String ownerKey) throws IOException {
        try {
            this.validateRequest(method, (HttpServletRequest)request, ownerKey);
            this.executeProcessingByFeatures(method, request, response, ownerKey);
        }
        catch (TusException e) {
            this.processTusException(method, request, response, ownerKey, e);
        }
    }

    protected void executeProcessingByFeatures(HttpMethod method, TusServletRequest servletRequest, TusServletResponse servletResponse, String ownerKey) throws IOException, TusException {
        for (TusExtension feature : this.enabledFeatures.values()) {
            if (servletRequest.isProcessedBy(feature)) continue;
            servletRequest.addProcessor(feature);
            feature.process(method, servletRequest, servletResponse, this.uploadStorageService, ownerKey);
        }
    }

    protected void validateRequest(HttpMethod method, HttpServletRequest servletRequest, String ownerKey) throws TusException, IOException {
        for (TusExtension feature : this.enabledFeatures.values()) {
            feature.validate(method, servletRequest, this.uploadStorageService, ownerKey);
        }
    }

    protected void processTusException(HttpMethod method, TusServletRequest request, TusServletResponse response, String ownerKey, TusException exception) throws IOException {
        int status = exception.getStatus();
        String message = exception.getMessage();
        try {
            for (TusExtension feature : this.enabledFeatures.values()) {
                if (request.isProcessedBy(feature)) continue;
                request.addProcessor(feature);
                feature.handleError(method, request, response, this.uploadStorageService, ownerKey);
            }
            UploadInfo uploadInfo = this.uploadStorageService.getUploadInfo(request.getRequestURI(), ownerKey);
            this.uploadStorageService.removeLastNumberOfBytes(uploadInfo, request.getBytesRead());
        }
        catch (TusException ex) {
            LOGGER.warn("An exception occurred while handling another exception", (Throwable)ex);
        }
        response.sendError(status, message);
    }

    private void updateSupportedHttpMethods() {
        this.supportedHttpMethods.clear();
        for (TusExtension tusFeature : this.enabledFeatures.values()) {
            this.supportedHttpMethods.addAll(tusFeature.getMinimalSupportedHttpMethods());
        }
    }

    private void prepareCacheIfEnabled() {
        if (this.isThreadLocalCacheEnabled && this.uploadStorageService != null && this.uploadLockingService != null) {
            ThreadLocalCachedStorageAndLockingService service = new ThreadLocalCachedStorageAndLockingService(this.uploadStorageService, this.uploadLockingService);
            service.setIdFactory(this.idFactory);
            this.uploadStorageService = service;
            this.uploadLockingService = service;
        }
    }
}

