/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.concatenation;

import com.nuix.automate.scheduler.tus.HttpMethod;
import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.upload.UploadInfo;
import com.nuix.automate.scheduler.tus.upload.UploadStorageService;
import com.nuix.automate.scheduler.tus.upload.UploadType;
import com.nuix.automate.scheduler.tus.utils.AbstractRequestHandler;
import com.nuix.automate.scheduler.tus.utils.TusServletRequest;
import com.nuix.automate.scheduler.tus.utils.TusServletResponse;
import com.nuix.automate.scheduler.tus.utils.Utils;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class ConcatenationPostRequestHandler
extends AbstractRequestHandler {
    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.POST.equals((Object)method);
    }

    @Override
    public void process(HttpMethod method, TusServletRequest servletRequest, TusServletResponse servletResponse, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        String uploadUri = servletResponse.getHeader("Location");
        UploadInfo uploadInfo = uploadStorageService.getUploadInfo(uploadUri, ownerKey);
        if (uploadInfo != null) {
            String uploadConcatValue = servletRequest.getHeader("Upload-Concat");
            if (StringUtils.equalsIgnoreCase((CharSequence)uploadConcatValue, (CharSequence)"partial")) {
                uploadInfo.setUploadType(UploadType.PARTIAL);
            } else if (StringUtils.startsWithIgnoreCase((CharSequence)uploadConcatValue, (CharSequence)"final")) {
                uploadInfo.setLength(null);
                uploadInfo.setUploadType(UploadType.CONCATENATED);
                uploadInfo.setConcatenationPartIds(Utils.parseConcatenationIDsFromHeader(uploadConcatValue));
                uploadStorageService.getUploadConcatenationService().merge(uploadInfo);
            } else {
                uploadInfo.setUploadType(UploadType.REGULAR);
            }
            uploadInfo.setUploadConcatHeaderValue(uploadConcatValue);
            uploadStorageService.update(uploadInfo);
        }
    }
}

