/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.core;

import com.nuix.automate.scheduler.tus.HttpMethod;
import com.nuix.automate.scheduler.tus.upload.UploadInfo;
import com.nuix.automate.scheduler.tus.upload.UploadStorageService;
import com.nuix.automate.scheduler.tus.upload.UploadType;
import com.nuix.automate.scheduler.tus.utils.AbstractRequestHandler;
import com.nuix.automate.scheduler.tus.utils.TusServletRequest;
import com.nuix.automate.scheduler.tus.utils.TusServletResponse;
import java.util.Objects;

public class CoreHeadRequestHandler
extends AbstractRequestHandler {
    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.HEAD.equals((Object)method);
    }

    @Override
    public void process(HttpMethod method, TusServletRequest servletRequest, TusServletResponse servletResponse, UploadStorageService uploadStorageService, String ownerKey) {
        UploadInfo uploadInfo = uploadStorageService.getUploadInfo(servletRequest.getRequestURI(), ownerKey);
        if (!UploadType.CONCATENATED.equals((Object)uploadInfo.getUploadType())) {
            servletResponse.setHeader("Upload-Length", Objects.toString(uploadInfo.getLength()));
            servletResponse.setHeader("Upload-Offset", Objects.toString(uploadInfo.getOffset()));
        }
        servletResponse.setHeader("Cache-Control", "no-store");
        servletResponse.setStatus(204);
    }
}

