/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.core;

import com.nuix.automate.scheduler.SchedulerApplication;
import com.nuix.automate.scheduler.tus.HttpMethod;
import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.exception.UploadNotFoundException;
import com.nuix.automate.scheduler.tus.upload.UploadInfo;
import com.nuix.automate.scheduler.tus.upload.UploadStorageService;
import com.nuix.automate.scheduler.tus.utils.AbstractRequestHandler;
import com.nuix.automate.scheduler.tus.utils.TusServletRequest;
import com.nuix.automate.scheduler.tus.utils.TusServletResponse;
import com.nuix.automate.scheduler.tus.utils.Utils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Objects;

public class CorePatchRequestHandler
extends AbstractRequestHandler {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(CorePatchRequestHandler.class);

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.PATCH.equals((Object)method);
    }

    @Override
    public void process(HttpMethod method, TusServletRequest servletRequest, TusServletResponse servletResponse, UploadStorageService uploadStorageService, String ownerKey) throws IOException, TusException {
        boolean found = true;
        UploadInfo uploadInfo = uploadStorageService.getUploadInfo(servletRequest.getRequestURI(), ownerKey);
        if (uploadInfo == null) {
            found = false;
        } else if (uploadInfo.isUploadInProgress()) {
            try {
                uploadInfo.setClientIpAddresses(Utils.buildRemoteIpList((HttpServletRequest)servletRequest));
                uploadInfo.setServerIpAddress(servletRequest.getLocalAddr());
                uploadInfo.setServerName(servletRequest.getServerName());
                uploadInfo.setServerRole(SchedulerApplication.getInstance().getConfiguration().getRole().name());
                uploadInfo = uploadStorageService.append(uploadInfo, servletRequest);
            }
            catch (UploadNotFoundException e) {
                found = false;
            }
        }
        if (found) {
            servletResponse.setHeader("Upload-Offset", Objects.toString(uploadInfo.getOffset()));
            servletResponse.setStatus(204);
            if (!uploadInfo.isUploadInProgress()) {
                LOGGER.info("Upload with ID " + String.valueOf(uploadInfo.getId()) + " at location " + servletRequest.getRequestURI() + " finished successfully");
            }
        } else {
            LOGGER.error("The patch request handler could not find the upload for URL " + servletRequest.getRequestURI() + ". This means something is really wrong the request validators!");
            servletResponse.sendError(500);
        }
    }
}

