/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.core.validation;

import com.nuix.automate.scheduler.tus.HttpMethod;
import com.nuix.automate.scheduler.tus.RequestValidator;
import com.nuix.automate.scheduler.tus.exception.InvalidContentLengthException;
import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.upload.UploadInfo;
import com.nuix.automate.scheduler.tus.upload.UploadStorageService;
import com.nuix.automate.scheduler.tus.utils.Utils;
import jakarta.servlet.http.HttpServletRequest;

public class ContentLengthValidator
implements RequestValidator {
    @Override
    public void validate(HttpMethod method, HttpServletRequest request, UploadStorageService uploadStorageService, String ownerKey) throws TusException {
        Long contentLength = Utils.getLongHeader(request, "Content-Length");
        UploadInfo uploadInfo = uploadStorageService.getUploadInfo(request.getRequestURI(), ownerKey);
        if (contentLength != null && uploadInfo != null && uploadInfo.getOffset() + contentLength > uploadInfo.getLength()) {
            throw new InvalidContentLengthException("The Content-Length value " + contentLength + " in combination with the current offset " + uploadInfo.getOffset() + " exceeds the declared upload length " + uploadInfo.getLength());
        }
    }

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.PATCH.equals((Object)method);
    }
}

