/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.creation.validation;

import com.nuix.automate.scheduler.tus.HttpMethod;
import com.nuix.automate.scheduler.tus.RequestValidator;
import com.nuix.automate.scheduler.tus.exception.InvalidContentLengthException;
import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.upload.UploadStorageService;
import com.nuix.automate.scheduler.tus.utils.Utils;
import jakarta.servlet.http.HttpServletRequest;

public class PostEmptyRequestValidator
implements RequestValidator {
    @Override
    public void validate(HttpMethod method, HttpServletRequest request, UploadStorageService uploadStorageService, String ownerKey) throws TusException {
        Long contentLength = Utils.getLongHeader(request, "Content-Length");
        if (contentLength != null && contentLength > 0L) {
            throw new InvalidContentLengthException("A POST request should have a Content-Length header with value 0 and no content");
        }
    }

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.POST.equals((Object)method);
    }
}

