/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.scheduler.tus.creation.validation;

import com.nuix.automate.scheduler.tus.HttpMethod;
import com.nuix.automate.scheduler.tus.RequestValidator;
import com.nuix.automate.scheduler.tus.exception.PostOnInvalidRequestURIException;
import com.nuix.automate.scheduler.tus.exception.TusException;
import com.nuix.automate.scheduler.tus.upload.UploadStorageService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PostURIValidator
implements RequestValidator {
    private Pattern uploadUriPattern = null;

    @Override
    public void validate(HttpMethod method, HttpServletRequest request, UploadStorageService uploadStorageService, String ownerKey) throws TusException {
        Matcher uploadUriMatcher = this.getUploadUriPattern(uploadStorageService).matcher(request.getRequestURI());
        if (!uploadUriMatcher.matches()) {
            throw new PostOnInvalidRequestURIException("POST requests have to be send to " + uploadStorageService.getUploadURI());
        }
    }

    @Override
    public boolean supports(HttpMethod method) {
        return HttpMethod.POST.equals((Object)method);
    }

    private Pattern getUploadUriPattern(UploadStorageService uploadStorageService) {
        if (this.uploadUriPattern == null) {
            this.uploadUriPattern = Pattern.compile("^" + uploadStorageService.getUploadURI() + "$");
        }
        return this.uploadUriPattern;
    }
}

